/**
 * @author Amit G
 */
Ext.define('Academia.view.student.currentEnrollmentReport.StudentCurrentEnrollmentReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentcurrentenrollmentreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	items: [{
		/*xtype: 'form',
        width: '100%',
        items: [{*/
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items :[{/*
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocationId',
			autoloadStore: false,
			width: 460,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		*/
			xtype : 'multiselectcombofield',
			name : 'academyLocation',
			itemId:'academyLocationId',
			width: 460,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			queryParam:'qry',
			typeAhead:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			editable:false,
			forceSelection:true,
			cls:'commonAutoHeightMultiselectField',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			//xtype: 'combo',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			itemId: 'programGroup',
			name: 'programGroup', 
			store: Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore'),
			valueField:'id',
			displayField:'value',
			editable: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			itemId: 'programCodeName',
			name: 'programCodeName',
			store:'program.ProgramByGroupIdStore',
			valueField:'id',
			displayField:'valueCode',
			queryParam:'qry',
			disabled:true,
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getExaminationTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}
		]
	}]
});
