/**
 * @author Amit G
 */
Ext.define('Academia.view.student.currentEnrollmentReport.StudentCurrentEnrollmentReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentcurrentenrollmentreportgrid',
	title: getCommonTranslation('CURRENT_STUDENT_ENROLLMENT'),
	store: 'student.studentenrollmentreport.StudentCurrentEnrollmentStore',
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [/*{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'student.report.StdDemographicReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}*/]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
		sortable: false,
		renderer:function(value, meta, record){
			if(record.data.isTotalRecord == true ){
				return '<b>'+value+'</b>';
			}else{
				return value;
			}
		}
	},{
		header:  getCommonTranslation('PROGRAM_GROUP'),
		dataIndex: 'programGroupName',
		flex:.1,
		hidden:true,
		sortable: false
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('CURRENT_STUDENTS'),
		dataIndex: 'currentStudents',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('REPEAT_STUDENTS'),
		dataIndex: 'repeatStudents',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			}else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('LEAVING_STUDENTS'),
		dataIndex: 'leavingStudents',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('TOTAL_ENROLLMENT'),
		dataIndex: 'totalCurrentEnrollments',
		renderer:function(value, meta, record){
			var currentStudentsStr = record.data.currentStudents;
			var startingStudentsStr = record.data.startingStudents;
			var leavingStudentsStr = record.data.leavingStudents;

			var currentStudents = parseInt(currentStudentsStr);
			var startingStudents = parseInt(startingStudentsStr);
			var leavingStudents = parseInt(leavingStudentsStr);

			var returnValue = currentStudents + startingStudents - leavingStudents;

			if( returnValue > 0 && record.data.isTotalRecord == false){
				return '<a href=#>'+returnValue+'<a>';
			}else if(returnValue > 0 && record.data.isTotalRecord == true){
				return '<b>'+returnValue+'</b>';
			} else {
				return '-';
			}
		},
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('LEFT_STUDENTS'),
		dataIndex: 'leftStudents',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('STARTING_STUDENTS'),
		dataIndex: 'startingStudents',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
		sortable: false
	}]
});
