/**
 * @author priyanshi sharma
 */
Ext.define('Academia.view.student.feeRegistrationFormSetup.FeeRegistrationFormSetupGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.feeregistrationformsetupgrid',
	store: 'student.feeRegistrationFormSetup.FeeRegFormSetupGridStore',
	title: getCommonTranslation('FEE_REGISTRATION_FORM_SETUP'),
	border: true,
	frame: false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'feeregistrationformsetupstructure':1
		}
	},
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'student.feeRegistrationFormSetup.FeeRegFormSetupGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getCommonTranslation('ACADEMY'),
		dataIndex: 'academy',
		flex: 1,
		sortable: true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value.value;
			}                        
		}
	}, {
		header: getCommonTranslation('LOCATION'),
		dataIndex: 'locations',
		flex: 1,
		sortable: true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value) && value.length>0) {
				return value[0].value;
			}                        
		}
	}, {
		header: getCommonTranslation('REGISTRATION_POP_UP_CONTENT'),
		dataIndex: 'registrationPopUpContent',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('FINANCE_CLAUSE'),
		dataIndex: 'financeClause',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT1'),
		dataIndex: 'firstDocumentCheckBoxContent',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT2'),
		dataIndex: 'secondDocumentCheckBoxContent',
		flex: 1,
		sortable: true
	}/*,{
		header: getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT3'),
		dataIndex: 'thirdDocumentCheckBoxContent',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT4'),
		dataIndex: 'fourthDocumentCheckBoxContent',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT5'),
		dataIndex: 'fifthDocumentCheckBoxContent',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT6'),
		dataIndex: 'sixthDocumentCheckBoxContent',
		flex: 1,
		sortable: true
	}*/]
});