/**
 * @author Amit G
 */
Ext.define('Academia.view.student.medicalDetailsReport.StudentMedicalDetailsReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentmedicaldetailsreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'multiselectcombofield',
				width: 695,
				name: 'multiselectAcademyId',
				itemId: 'multiselectAcademyId',
				allowBlank : false,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				displayField:'value',
				valueField:'id',
				matchFieldWidth:true,
				maxLength:15000,
				autoloadStore: false,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
	        	listeners  :{
	        		render : function(combo){
	        			var store=Ext.create('Academia.store.common.AcademyLocationNameSeparated');
	        			combo.bindStore(store)
	        		}
	        	}
	     	}]
		
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top'
			},
			items:[{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
	     		fieldLabel : getExaminationTranslation('STUDENTID_STUDENTNAME'),
	     		valueField: 'id',
	 			displayField: 'valueCode',
	 			queryParam:'name',
	     		minChars:3,
	     		typeAhead:false,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		width:695,
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('INTAKE_YEAR'),
					name : 'intakeYear',
					itemId : 'intakeYear',
					displayField:'value',
					valueField:'id',
					typeAhead:true,
					forceSelection:true,
					minChars:3,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}'  +
							'</div>';
						}
					},
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.IntakeYearStore');
							combo.bindStore(store)
						}
					}
				},{
					xtype : 'customcombobox',
					name : 'programGroupCombo',
					itemId: 'programGroupCombo',
					fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
					valueField: 'id',
		            displayField: 'value',
		            queryParam:'programGrpName',
		            typeAhead:true,
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                forceSelection:true,
	                minChars:3,
		     		enableKeyEvents  : 'true',
		     		hideTrigger:false,
	                listConfig: {
		     			listeners: {
		 					beforeshow: function(picker) {
		 						picker.minWidth = picker.up('combobox').getSize().width;
		 					}
		 				},
		     			loadingText: getCommonTranslation('SEARCHING'),
		     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		     			getInnerTpl: function() {
		     				return '<div class="search-item">' +
		     				'{value} / {code}' +
								'</div>';
		     			}
		     		},
	                listeners: {
						render: function(combo) {
	                    	  var store = Ext.create('Academia.store.personinfo.common.personalinfo.MappedProgramGroupByALStore');
	                         combo.bindStore(store);
	                     }
					}
				},{
		    		xtype: 'customcombobox',
		    		name: 'programCategory',
		    		itemId : 'programCategoryId',
		    		fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
		    		valueField:'id',
		    		displayField:'value',
		    		forceSelection:true,
	                listeners: {
						render: function(combo) {
	                    	  var store = Ext.create('Academia.store.program.ProgramCategoryStore');
	                         combo.bindStore(store);
	                     }
					}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
				items:[{
	            	 xtype: 'customcombobox',
		    			name:'PROGRAM_NAME',
		    			itemId:'programId',
		    			fieldLabel: getCommonTranslation('PROGRAM'),
		    			valueField: 'id',
		    			displayField: 'value',
		    			queryParam:'name',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		                listeners: {
    						render: function(combo) {
		                    	  var store = Ext.create('Academia.store.common.AssignedProgramStore');
		                         combo.bindStore(store);
		                     }
    					}
		    		
		            },{
		                 xtype: 'customcombobox',
		                 name: 'BATCH_NAME',
		                 itemId: 'batchId',
		                 fieldLabel: getPersonModuleTranslation('BATCH'),
		                 disabled:true,
		                 editable: false,
		                 queryMode: 'local',
		                 displayField: 'value',
		                 valueField: 'id',
		                 listeners: {
		                     render: function(combo) {
		                    	 var store = Ext.create('Academia.store.common.CurrentBatchStore');
		                         combo.bindStore(store);
		                     }
		                 }
		             },{
		                 xtype: 'customcombobox',
		                 itemId:'periodId',
		                 disabled:true,
		                 editable: false,
		                 displayField: 'value',
		                 valueField: 'id',
		                 queryMode: 'local',
		                 fieldLabel: getPersonModuleTranslation('PERIOD'),
		                 name: 'PERIOD_NAME',
		                 listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		                         combo.bindStore(store);
		                     }
		                 }
		             }]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
				items:[{
		        	xtype: 'customcombobox',
		        	name: 'status',
		        	itemId:'statusItemId',
		        	store:Ext.create('Academia.store.common.StatusComboStore'),
		        	displayField:'name',
		        	valueField:'id',
		        	forceSelection:true,
		        	editable:false,
		        	typeAhead:true,
		        	fieldLabel:getCommonTranslation('STATUS')
		        }]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});