/**
 * @author Amit G
 */
var studentALTransferReportGridStore = 'student.report.StudentALTransferReportGridStore';
Ext.define('Academia.view.student.report.StudentALTransferReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentaltransferreportgrid',
	title: getCommonTranslation('STUDENTTRANSFERREPORT'),
	store: studentALTransferReportGridStore,
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'studenttransferreporttabstructure':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : studentALTransferReportGridStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('STUDENT_CODE'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getAdmissionTranslation('FROM_ACADEMY_LOCATION'),
		dataIndex: 'fromAlName',
		flex:.1,
		sortable:true
	},{
		header:  getAdmissionTranslation('FROM_PROGRAM_NAME'),
		dataIndex: 'fromProgramName',
		flex:.1,
		sortable:true
	},{
		header:  getAdmissionTranslation('FROM_BATCH_NAME'),
		dataIndex: 'fromBatchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('TRANSFER_DATE'),
		dataIndex: 'transferDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header: getServiceRequestTranslation('STUDENT_TRANSFER_TO_ACADEMY_LOCATION'),
		dataIndex: 'alname',
		flex:.1,
		sortable:true
	},{
		header:  getAdmissionTranslation('TO_PROGRAM_NAME'),
		dataIndex: 'toProgramName',
		flex:.1,
		sortable:true
	},{
		header:  getAdmissionTranslation('TO_BATCH_NAME'),
		dataIndex: 'toBatchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SERVICE_REQUEST_ID'),
		dataIndex: 'serviceRequestId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('REASON_FOR_LEAVING'),
		dataIndex: 'reasonForLeaving',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(val) {
			if(val == null) {
				val = '-';
				return val;
			}
			else{
				return val;
			}
		}
	},{
		header:  getCommonTranslation('REMARKS'),
		dataIndex: 'remarks',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(val == null){
				val = '-';
				return val;
			}
			else {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 57px;min-width: 16ch;max-width: 17ch;';
				return val;
			}
		}
	}]
});

