/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.student.report.StudentTransferReportFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.studenttransferreportfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'requestTypeId',
			itemId:'requestTypeId',
			fieldLabel: getServiceRequestTranslation('REQUEST_CATEGORY'),
			store:'student.report.ServiceRequestTypeStore',
			displayField: 'value',
			valueField: 'id',
			allowBlank: false,
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			//store: 'feeandpayment.managebill.Student',
			store: 'student.report.StudentSearchServiceRequest',
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
//			allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},
		  {
            xtype: 'statusCombo',
            name: 'STATUS',
            itemId:'status',
            editable: false,
            fieldLabel: getCommonTranslation('STUDENT_IS_ACTIVE_STATUS')
        },]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
        	xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'Program_Group',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:'program.ProgramGroupStore',
			editable: true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			queryParam : 'programGrpName',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel :getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programId',
			store:'feeandpayment.reports.Program',
			displayField:'valueCode',
			valueField:'id',
			//disabled:false,
			//hidden:true,
			queryParam:'programName',
			minChars:3,
    		allowBlank: true,
    		typeAhead:false,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		forceSelection:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code} / {value}'+ 
    				'</div>';
    			}
    		}

		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			hidden:true,
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]
	   },{
   		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 460
		},
		items: [{
			xtype : 'multiselectcombofield',
			name : 'fromAl',
			itemId:'fromAl',
			autoloadStore: false,
			width: 460,
			fieldLabel : getAdmissionTranslation('FROM_ACADEMY_LOCATION'),
			store: Ext.create('Academia.store.feeandpayment.finance.FinanceBlokedStudentFilterAcademyLocationStore'),
			valueField : 'id',
			displayField : 'value',
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			cls:'receiptHeaderMultiselect',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 460
		},
		items: [{
			xtype : 'multiselectcombofield',
			name : 'toALId',
			itemId:'toAcademyLocationItemId',
			autoloadStore: false,
			width: 460,
			fieldLabel : getServiceRequestTranslation('STUDENT_TRANSFER_TO_ACADEMY_LOCATION'),
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
			valueField : 'id',
			displayField : 'value',
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			cls:'receiptHeaderMultiselect',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
        }]},
        {
		xtype: 'fieldcontainer',
		itemId:'courseTransfer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId:'courseId',
			fieldLabel: getPersonModuleTranslation('COURSE_NAME'),
			store: 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
			valueField : 'id',
			displayField : 'value',
			disabled:true,
			hidden:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			name:'periodId',
			itemId: 'periodId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField: 'value',
			valueField: 'id',
			disabled:true,
			hidden:true,
			typeAhead:true,
			disabled:true,
			forceSelection:true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			name : 'sectionId',
			itemId : 'sectionId',
			disabled:true,
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			forceSelection : true,
			hidden:true
		}]
	},{
		xtype : 'fieldcontainer',
		width: '100%',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getCompletionModuleTranslation('TRANSFER_DETAILS_COLON')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			itemId:'dateContainer',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'startDate',
				itemId:'startDate',
				endDateField : 'endDate',
				//maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'endDate',
				itemId : 'endDate',
				startDateField : 'startDate',
				//maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			}]
		}]

	},{	
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
