/**
 * @author Hareesh Soni
 */
Ext.define('Academia.view.student.studentIdentityDocumentReport.StudentIdentityDocumentReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentidentitydocumentreportgrid',
	store: 'student.report.studentIdentityDocumentReport.StudentIdentityDocumentReportGridStore',
	title: getCommonTranslation('STUDENT_IDENTITY_DOCUMENT_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.studentIdentityDocumentReport.StudentIdentityDocumentReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('FIRST_NAME'),
		dataIndex: 'studentFirstName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('MIDDLE_NAME'),
		dataIndex: 'studentMiddleName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('LAST_NAME'),
		dataIndex: 'studentLastName',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM_GROUP_NAME'),
		dataIndex: 'programGroupName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		hidden:true
	},{
		header:  getPersonModuleTranslation('ID_TYPE'),
		dataIndex: 'identityDocumentType',
		flex:.1
	},{
		header:  getPersonModuleTranslation('ID_NUMBER'),
		dataIndex: 'identityDocumentNumber',
		flex:.1
	},{
		header:  getPersonModuleTranslation('ISSUING_AUTHORITY'),
		dataIndex: 'issuingAuthority',
		flex:.1,
		hidden:true
	},{
		header:  getPersonModuleTranslation('ISSUED_PLACE'),
		dataIndex: 'issuedPlace',
		flex:.1,
		hidden:true
	},{
		header:  getPersonModuleTranslation('ISSUED_DATE'),
		dataIndex: 'issuedDate',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('VALID_TILL_DATE'),
		dataIndex: 'validTillDate',
		flex:.1
	},{
		header:  getPersonModuleTranslation('DOCUMENT'),
		dataIndex: 'documentName',
		flex:.1,
		renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
	}]
});
