/**
 * @author <a href="vidhi.shah@serosoft.in">Vidhi Shah</a>
 *
 */
Ext.define('Academia.view.student.studentprofile.FunctionaryDetailsGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.functionarydetailsgrid',
	title: getPersonModuleTranslation('FUNCTIONARY_DETAILS'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		var grid=this$;                   
		grid.addExportToolBarItems(grid);
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
					displayInfo: true
				}]
			}]
		});
		this$.callParent(arguments);
	},
	columns : [{
		header : getPersonModuleTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1,
		hidden:false,
		sortable:true
		
	},{
		header : getPersonModuleTranslation('PROGRAM'),
		dataIndex : 'programs',
		flex:1,
		hidden:false,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.programCode) && !isNullOrEmpty(record.data.programs)) {
				return record.data.programCode+"/"+record.data.programs;
			}                        
		}
		
	},{
		header : getPersonModuleTranslation('BATCH'),
		dataIndex : 'batch',
		flex:1,
		hidden:false,
		sortable:true
		
	},{
		header : getPersonModuleTranslation('FUNCTIONARY_TYPE'),
		dataIndex : 'functionaryTypeValue',
		flex:1,
		hidden:false,
		sortable:true
	},{
		header : getPersonModuleTranslation('FUNCTIONARY_ID_NAME'),
		dataIndex : 'functionaryUserIdCode',
		flex:1,
		hidden:false,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.functionaryUserIdCode) && !isNullOrEmpty(record.data.functionaryUserIdName)) {
				return record.data.functionaryUserIdCode+"/"+record.data.functionaryUserIdName;
			}                        
		}
	},{
		header : getPersonModuleTranslation('FUNCTIONARY_ROLE'),
		dataIndex : 'functionaryUserRole',
		flex:1,
		hidden:false,
		sortable:true
	},{
		header : getPersonModuleTranslation('FUNCTIONARY_INVOLVEMENT_IN_PERCENTAGE'),
		dataIndex : 'functionaryInvolvementInPercentage',
		flex:1,
		hidden:false,
		sortable:true
	},{
		header : getCommonTranslation('FUNCTIONARY_DEPARTMENT'),
		dataIndex : 'functionaryDepartment',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header : getCommonTranslation('OU_DEPARTMENT'),
		dataIndex : 'oUDepartmentValue',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header: getPersonModuleTranslation('START_DATE'),
		dataIndex: 'startDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('END_DATE'),
		dataIndex: 'endDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getPersonModuleTranslation('STATUS'),
		dataIndex : 'activeStatus',
		flex:1,
		sortable:true,
		hidden:false,
		renderer : function(value){
			if(!isNullOrEmpty(value) && value==true) {
				return "Active";
			} else {
				return "Inactive";
			}
		}
	},{
		header: getPersonModuleTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('AUDIT_ID'),
		dataIndex: 'auditIdCode',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.auditIdCode) && !isNullOrEmpty(record.data.auditIdName)) {
				return record.data.auditIdCode+"/"+record.data.auditIdName;
			}                        
		}
	},{
		header : getPersonModuleTranslation('DESCRIPTION'),
		dataIndex : 'description',
		flex:1,
		hidden:true,
		sortable:true
	}],
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.pasthistory.FunctionaryDetailsStore');
	}
});