/**
 * @author Amit G
 */
Ext.define('Academia.view.student.studentprofile.StudentAcademicHistoryPrintTranscriptWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentacademichistoryprinttranscriptwin',
	modal: true,
	frame: true,
	resizable: false,
	title:getCommonTranslation('TRANSCRIPT'),
	items: [{		
    xtype: 'form',
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[{
		xtype: 'fieldcontainer',
		width:'100%',
		 defaults:{
		    	labelAlign:'top',
		    	width:380
		    },
		items: [{
			xtype : 'textfield',
			name : 'TranscriptInExcelPrint',
			itemId:'selectTranscriptInExcelPrint',
			hidden :true
			
			
		},{
	    	xtype : 'multiselectcombofield',
			name : 'selectTheProgramToPrint',
			itemId:'selectTheProgramToPrintItemId',
			store:'student.studentprofile.AcademicsHistoryTranscriptStore',
			fieldLabel : getCommonTranslation('SELECT_THE_PROGRAMS_TO_PRINT'),
	    	valueField:'id',
	    	displayField:'value',
	    	allowBlank:false,
	    	editable: false,
	    	queryParam:'qry',
			typeAhead:true,
			disabled:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			style:{
				marginTop:'2px'
			},
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			itemId: 'printBtnItemId',
			text : getCommonTranslation('PRINT'),
			buttonAlign : 'left',
			ui : 'CustomBtnThird',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}]	
	}
	
	
	]
	}]
});
