/**
 * 
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.student.studentprofile.StudentEthicsClearanceLetterGrid',{
	alias : 'widget.studentethicsclearancelettergrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'student.postGraduateManagement.StudentEthicsClearanceLetterStore',
	title: getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.postGraduateManagement.StudentEthicsClearanceLetterStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('APPROVAL_DATE'),
		dataIndex: 'approvalDate',
		ItemId: 'approvalDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('APPROVAL_PERIOD_START_DATE'),
		dataIndex: 'approvalPeriodStartDate',
		ItemId: 'approvalPeriodStartDate',
		sortable: true,
		hidden:false,
		flex: 1.4,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('APPROVAL_PERIOD_END_DATE'),
		dataIndex: 'approvalPeriodEndDate',
		ItemId: 'approvalPeriodEndDate',
		sortable: true,
		hidden:false,
		flex: 1.4,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('CO_INVESTIGATOR_NAME'),
		dataIndex: 'coInvestigatorName',
		ItemId: 'coInvestigatorName',
		sortable: true,
		hidden:true,
		flex:1.4,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.coInvestigatorName.code+"/"+record.data.coInvestigatorName.value;
			}                        
		}
	},{
		header: getCommonTranslation('PROJECT_NUMBERID'),
		dataIndex: 'projectNumberID',
		itemId: 'projectNumberID',
		sortable: true,
		hidden:false,
		flex: 1
	},{
		header : getPersonModuleTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'studentEthicsClearanceLetterDocuments',
		flex:1,
		sortable:true,
		hidden:false,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.studentEthicsClearanceLetterDocuments.length>1) {					
					return '<a href=#>'+record.data.studentEthicsClearanceLetterDocuments.length+'<a>';
				} else if(record.data.studentEthicsClearanceLetterDocuments.length==1) {
					return '<a href=#>'+record.data.studentEthicsClearanceLetterDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getPersonModuleTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		ItemId: 'auditDateItemId',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditIdItemId',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}]
});