/**
 * @Author Vyabha Thakur 
 */
Ext.define('Academia.view.student.studentprofile.StudentProgramCompletionDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentprogramcompletiondetailsgrid',
	title: getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'),
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	 viewConfig: {
	        stripeRows: CONSTANTS.STRIPEROWS
	 },
	 isGridConfigurable: true,
	 enableColumnHide: false,
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getCommonTranslation('ADMISSION_ID'), 
		dataIndex: 'admissionId',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('STUDENT_ID'), 
		dataIndex: 'studentId',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('STUDENT_NAME'), 
		dataIndex: 'studentName',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('PROGRAM'), 
		dataIndex: 'program',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('BATCH'), 
		dataIndex: 'batch',
		sortable:true,
		flex: .2
	},  {
		header: getCommonTranslation('PERIOD'), 
		dataIndex: 'period',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('DATE_OF_GRADUATION'),
		dataIndex: 'studentDateOfGradution',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('CLASSIFICATION'), 
		dataIndex: 'classification',
		sortable:true,
		flex: .2
	}, {
        header:getCommonTranslation('IS_ALUMNI'),
        dataIndex: 'isAlumni',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
 			if(!isNullOrEmpty(value)) {
 				return record.data.isAlumni==true?'True':'False';
 			} else {
 				return '';
 			}                        
 		}
    }, {
		header: getCommonTranslation('SPECIALIZATION'), 
		dataIndex: 'specialization',
		sortable:true,
		flex: .2
	}, {
        header:getCommonTranslation('AWARD_TYPE'),
        dataIndex: 'awardType',
        sortable: true,
        flex: .2
    }, {
        header:getCommonTranslation('AWARD_CERTIFICATE_ID'),
        dataIndex: 'awardCertificateId',
        sortable: true,
        flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
        	if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
    }, {
		header: getCommonTranslation('AWARD_REQUESTED_DATE'),
		dataIndex: 'studentAwardRequestedDate',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('AWARD_SENT_GIVEN_DATE'),
		dataIndex: 'studentAwardSentGivenDate',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('AWARD_DELIVERY_METHOD'), 
		dataIndex: 'awardDeliveryMethod',
		sortable:true,
		flex: .2
	}, {
        header:getCommonTranslation('AWARD_NOMINATED_PERSON'),
        dataIndex: 'awardNominatedPerson',
        sortable: true,
        flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
        	if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
    }, {
        header:getCommonTranslation('AWARD_TRACKING_NUMBER'),
        dataIndex: 'awardTrackingNumber',
        sortable: true,
        flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
        	if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
    },{
		header: getCommonTranslation('COMMENTS'), 
		dataIndex: 'comments',
		sortable:true,
		flex: .2,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
		    // Handle null or empty value
		    if (val === null || val === '') {
		        rec.tdCls = 'gridInputCustomStyle'; 
		       
		    } else {
		        // Truncate long values and apply tooltip
		        if (val.length > 100) {
		            var valtext = val.substring(0, 70) + "...";
		            rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
		            return valtext;
		        } else {
		            // Apply tooltip and custom CSS class for other values
		            rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
		            rec.tdCls = "assign-remark-column-cls"; 
		            return val;
		        }
		    }
		}
	}],
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.student.studentprofile.StudentProgramCompletionDetailsStore');
    }
});