/**
 * for student portal
 * @Author Ravi Choudhary
 */
Ext.define('Academia.view.studentPortal.ViewExaminationSTPortalGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.viewexaminationstportalgrid',
	store: 'examinationcenters.evaluationgrouplisting.EvalGroupListingMasterStore',
	title: getCommonTranslation('VIEW_EXAMINATION'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.evaluationgrouplisting.EvalGroupListingMasterStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('FEE_PLAN'),
		dataIndex: 'feePlanName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('AMOUNT'),
		dataIndex: 'feeAmount',
		flex:.3,
		sortable: true,
		renderer: function(currency) {
			if(!isNullOrEmpty(currency)) {
				return currencyRender(currency);
			}
			else{
				return currency;
			}
		}
	}, {
		header: getExaminationTranslation('APPLICATION_STATUS'),
		dataIndex: 'applicationStatus',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)) {
				return capitaliseEnumValue(value);
			}
			else{
				return value;
			}
		}
	}, {
		header: getExaminationTranslation('HALL_TICKET_NO'),
		dataIndex: 'hallticket',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)) {
				return "<a href='#'>"+value+"</a>";
			} else {
				return "-";
			}
		}
	}, {
		header: getExaminationTranslation('CENTER_ALLOTED'),
		dataIndex: 'centerAllotted',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)) {
				return capitaliseEnumValue(value);
			}else{
				return value;
			}
		}
	}]
});