/**
 * @author bhanu ps
 */
var revaluationCount=0;
var indexValue=[];
Ext.define('Academia.view.studentPortal.revaluation.RevaluationStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.revaluationstudentgrid',
	store: 'examinationcenters.studentportal.revaluation.StudentRevalGridStore',
	title: getExaminationTranslation('APPLY_FOR_REVALUATION'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.studentportal.revaluation.StudentRevalGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnApplyNowItemId',
		tooltip:getExaminationTranslation('APPLY_NOW'),
		text:getExaminationTranslation('APPLY_NOW')
	},{
		xtype: 'button',
		itemId: 'btnApplyItemId',
		tooltip: getExaminationTranslation('APPLY_AND_PAYONLINE'),
		text:getExaminationTranslation('APPLY_AND_PAYONLINE'),
	},{
		xtype: 'button',
		itemId: 'offlinePaymentItemId',
		tooltip: getExaminationTranslation('APPLY_AND_PAYOFFLINE'),
		text:getExaminationTranslation('APPLY_AND_PAYOFFLINE'),
		//hidden: true
	},{
		xtype: 'button',
		itemId: 'btnRefreshItemId',
		tooltip: getCommonTranslation('REFRESH_SELECTION'),
		text: getCommonTranslation('REFRESH_SELECTION'),
		formBind:true
	},{
		xtype:'displayfield',
		name : 'applyForRevalMsg',
		itemId : 'applyForRevalMsgId',
		hidden:true
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [/*{
		header:getCourseTxCommonTranslation('SELECT'),
		dataIndex : '',
		flex:.09,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' onchange=\"Academia.app.getController(\'Academia.controller.examinationcenters.revaluation.RevaluationController\').revSelectionChange(this);\"/>");
		}
	},*/{
		header:  getExaminationTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariant',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('FACULTY_NAME'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('DETAILED_SEQUENCE'),
		dataIndex: 'event',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('MAX_MARKS'),
		dataIndex: 'maxMarks',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.maxMarks)){
				return record.data.maxMarks;
			}
		}
	},{
		header:  getExaminationTranslation('MAX_GRADE'),
		dataIndex: 'maxGrade',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.maxGrade)){
				return record.data.maxGrade;
			}
		}
	},{
		header:  getExaminationTranslation('MARKS_OBTAINED'),
		dataIndex: 'obtainedMarks',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.obtainedMarks)) {
				return record.data.obtainedMarks;
			}
		}
	},{
		header:  getExaminationTranslation('GRADE_OBTAINED'),
		dataIndex: 'finalGrade',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.finalGrade)){
				return record.data.finalGrade;
			}
		}
	},{
		header:  getExaminationTranslation('RESULT_STATUS'),
		dataIndex: 'resultStatus',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.resultStatus)){
				if(record.data.resultStatus.toUpperCase()== getCommonTranslation("PASS").toUpperCase()) {
					return "<span style='color:green'>"+getCommonTranslation(record.data.resultStatus)+"</span>";
				} else {
					return "<span style='color:red'>"+getCommonTranslation(record.data.resultStatus)+"</span>";
				}
			}
		}
	},{
		header:  getExaminationTranslation('REVALUATION_TYPE'),
		dataIndex: 'revaluationTypeEnum',
		flex:.15,
		sortable:false,
		editor : {
			xtype: 'customcombobox',
			name:'revaluationTypeEnum',
			itemId:'revaluationTypeEnum',
			store:'examCenter.AssignSequence.RevaluationTypeByPeriod',
			valueField : 'value',
			forceSelection:true,
			editable:false,
			typeAhead:false,
			displayField : 'value',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			},
			listeners:{
				select: function(combo){
					/*var grid = combo.up('grid');
					try{
						grid.getSelectionModel().deselectAll();
					}
					catch(e){}*/
					this.up().completeEdit();
				}
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				if(!isNullOrEmpty(record.data.revaluationTypeEnum)) {
					return getCommonTranslation(record.data.revaluationTypeEnum);
				}else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			} else {
				if(record.data.isReturnVoid != undefined && record.data.isReturnVoid){
					var grid = view.up();
					var store = grid.getStore();
					var models = grid.getStore().getRange();
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
				return getCommonTranslation(val);
			}	
		}
	},{
		header:  getExaminationTranslation('START_DATE'),
		dataIndex: 'startDate',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation('END_DATE_LABEL'),
		dataIndex: 'endDate',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header:  getExaminationTranslation('STATUS'),
		dataIndex: 'revaluationStatus',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('APPLIED_DATE'),
		dataIndex: 'appliedDate',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header:  getExaminationTranslation('FEE'),
		dataIndex: 'feeAmount',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var whetherRevalFeeApplicable=null;
			var whetherFeeAmount=null;
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVALUATION" ||
					record.data.revaluationTypeEnum=="Revaluation")){
				whetherRevalFeeApplicable=view.up().up().down('#isRevalFeeApplicable').getValue();
				whetherFeeAmount=view.up().up().down('#revalFeeAmount').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVIEW" ||
					record.data.revaluationTypeEnum=="Review")){
				whetherRevalFeeApplicable=view.up().up().down('#isReviewFeeApplicable').getValue();
				whetherFeeAmount=view.up().up().down('#reviewFeeAmount').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="CHALLENGE" ||
					record.data.revaluationTypeEnum=="Challenge")){
				whetherRevalFeeApplicable=view.up().up().down('#isChallengeFeeApplicable').getValue();
				whetherFeeAmount=view.up().up().down('#challengeFeeAmount').getValue();
			}
			if(whetherRevalFeeApplicable=="true"){
				return whetherFeeAmount;
			}else{
				return "-";
			}
		} 
	},{
		header:  getCommonTranslation('TRANSACTION_DETAILS'),
		dataIndex: 'documentName',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var whetherRevalFeeApplicable=null;
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVALUATION" ||
					record.data.revaluationTypeEnum=="Revaluation")){
				whetherRevalFeeApplicable=view.up().up().down('#isRevalFeeApplicable').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVIEW" ||
					record.data.revaluationTypeEnum=="Review")){
				whetherRevalFeeApplicable=view.up().up().down('#isReviewFeeApplicable').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="CHALLENGE" ||
					record.data.revaluationTypeEnum=="Challenge")){
				whetherRevalFeeApplicable=view.up().up().down('#isChallengeFeeApplicable').getValue();
			}
			if(!isNullOrEmpty(val) && (whetherRevalFeeApplicable=="true")){
				return "<a href='#'>"+val+"</a>";
			}else{
				return "-";
			}
		}   
	},{
		header:  getExaminationTranslation('APPROVAL_STATUS'),
		dataIndex: 'approvalStatus',
		flex:.10,
		sortable:true,
		hidden:true,
		renderer:function(record){
			if(!isNullOrEmpty(record) && record=="APPROVED"){
				return "Approved";
			} else if(!isNullOrEmpty(record) && record=="REJECTED"){
				return "Rejected";
			} else{
				return "Pending";
			}
		}   
	},{
		header:  getCommonTranslation('REMARKS'),
		dataIndex: 'remark',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return val;
			}
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context){
				if(!isNullOrEmpty(editor.record.data.revaluationStatus) && 
						(editor.record.data.revaluationStatus.toUpperCase()=='SUBMITTED'.toUpperCase()
								|| editor.record.data.revaluationStatus.toUpperCase()=='APPLIED'.toUpperCase())){
					return false;
				} else {/*
					var grid = obj.view.up();
					var store = grid.getStore();
					var models = grid.getStore().getRange();
					var maxCourseEvent = editor.record.data.maxCourseEventToApply, count=0, masterId=[];
					var records = grid.getSelectionModel().getSelection();
					for(var i in models) {
						   if((masterId.length == 0 || 
								   (!isNullOrEmpty(masterId)?masterId.id != models[i].data.examRevaluationId:false))) {
							   masterId.push({
								   "id":models[i].data.examRevaluationId,
								   "bucketSize":models[i].data.maxMasterCount,
								   "revalType" : models[i].data.revaluationTypeEnum
							   })
						   }
					}
					for(j in masterId){
 					   var maxCount = masterId[j].bucketSize;
 					   var count=0, selectionMsg='';
 					  for(var i in models) {
 						   if(masterId[j].id == models[i].data.examRevaluationId) {
 							   selectionMsg = models[i].data.revaluationTypeEnum+" "; 
 							   count++;
 						   }
 					   }
 					   if(count>maxCount) {
 						   grid.getSelectionModel().deselect(records[records.length-1]);
 						   showWarningMessage(getCommonTranslation('ALERT'), "Selection can not be more then " +maxCount+" for "+selectionMsg);
 						   return false;
 					   }
 				   }
				 */}
			},
			afteredit: function(obj, editor, context){
				var getcontroller=Academia.app.getController('Academia.controller.examinationcenters.studentportal.revaluation.RevaluationSPController');
				var tempStore=getcontroller.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
				if(!isNullOrEmpty(editor.record.data.revaluationStatus) && 
						(editor.record.data.revaluationStatus.toUpperCase()!='SUBMITTED'.toUpperCase()
								|| editor.record.data.revaluationStatus.toUpperCase()=='APPLIED'.toUpperCase())){
					if(editor.column.text ==  'REVALUATION_TYPE' || editor.column.text=='Revaluation Type' ){
						var grid = obj.view.up();
						var submitUrl=SERVERURL.FIND_REVALUATION_CRITERIA_BY_PERIOD;
						if(editor.value!=null) {
							Ext.Ajax.request({
								type : 'rest',
								url : submitUrl+"?revalutionType="+editor.value.toUpperCase()+"&periodId="+editor.record.data.periodId+"&batchId="+editor.record.data.batchId+"&admissionId="+editor.record.data.admissionId,
								method : 'GET',
								success : function(response, action) {
									var data = Ext.decode(response.responseText);
									var store = grid.getStore();
									var models = grid.getStore().getRange();
									var count=0;
									var admCount=0;
									var records = grid.getSelectionModel().getSelection();//grid.getSelectionModel().getSelection();

									var revaluationType = null;
									if(editor.value == "Revaluation"){
										revaluationType = getExaminationTranslation('REVAL_REVALUATION');
									}else if(editor.value == "Challenge"){
										revaluationType = getExaminationTranslation('REVAL_CHALLENGE');
									}else if(editor.value == "Review"){
										revaluationType = getExaminationTranslation('REVAL_REVIEW');
									}

									var maxCourseEvent = editor.record.data.maxCourseEventToApply, count=0, masterId=[];
									for(var i in models) {
										if(!isNullOrEmpty(models[i].data.revaluationTypeEnum) && (masterId.length == 0 || 
												(!isNullOrEmpty(masterId)?masterId.id != models[i].data.examRevaluationId:false))) {
											masterId.push({
												"id":models[i].data.examRevaluationId,
												"bucketSize":models[i].data.maxMasterCount,
												"revalType" : models[i].data.revaluationTypeEnum
											})
										}
									}

									for(j in masterId){
										var maxCount = masterId[j].bucketSize;
										var count=0, selectionMsg='';
										for(var i in models) {
											if(!isNullOrEmpty(models[i].data.revaluationTypeEnum) && masterId[j].id == models[i].data.examRevaluationId
													&& records[0] && records[0].data.admissionId==models[i].data.admissionId) {
												selectionMsg = models[i].data.revaluationTypeEnum+" "; 
												count++;
											}
										}
									}

									if(count >= data.maxRevaluationToApply){
										showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REVALUATION_TYPE_ACADEMIC_TERM')+' '+revaluationType+' '+
												getExaminationTranslation('REVALUATION_ALLTYPES_WARNING_MSG')+' '+data.maxRevaluationToApply+' '+ getCommonTranslation('LOWERCASE_COURSES'));
										models[editor.rowIdx].set('startDate','');
										models[editor.rowIdx].set('endDate','');
										models[editor.rowIdx].set('feeAmount','');
										models[editor.rowIdx].set('isReturnVoid',true);
										models[editor.rowIdx].set('revaluationTypeEnum','');
										models[editor.rowIdx].set('appliedDate','');
										models[editor.rowIdx].set('appliedDate','');
//										models[editor.rowIdx].set('examRevaluationId','');
//										models[editor.rowIdx].set('maxMasterCount','');
										grid.getSelectionModel().deselect(records[records.length-1]);

										tempStore.remove(records[records.length-1],true);
										editor.row.children[0].children[0].children[0].checked = false;
										return false;
									}
									models[editor.rowIdx].set('isReturnVoid',false);
									models[editor.rowIdx].set('startDate',data.startDate);
									models[editor.rowIdx].set('endDate',data.endDate);
									models[editor.rowIdx].set('feeAmount',data.feeAmount);
									models[editor.rowIdx].set('feePlanRuleStageId',data.feePlanRuleStageId);
									models[editor.rowIdx].set('examRevalRuleMappingId',data.examRevalRuleMappingId);
									models[editor.rowIdx].set('appliedDate',new Date());
									models[editor.rowIdx].set('examRevaluationId',data.id);
									models[editor.rowIdx].set('maxMasterCount',data.maxCourseEventToApply);
									models[editor.rowIdx].set('maxMasterCount',data.maxCourseEventToApply);
									models[editor.rowIdx].set('whetherRevalFeeApplicable',data.whetherRevalFeeApplicable);
									models[editor.rowIdx].set('restrictPaymentForMultipleCostCenters',data.restrictPaymentForMultipleCostCenters);
									models[editor.rowIdx].set('costCenterId',data.costCenterId);
									//editor.row.children[0].children[0].children[0].checked = false;

									var msgLable = grid.down('#applyForRevalMsgId');
									var totalAmount=0, perviousCount=0;
									for(var i in models) {
										/*if(!isNullOrEmpty(models[i].data.feeAmount) && models[i].data.revaluationStatus.toUpperCase() != 'SUBMITTED'.toUpperCase()) {
											totalAmount=totalAmount+parseInt(models[i].data.feeAmount);
										}*/
										if(models[i].data.revaluationStatus.toUpperCase() == 'SUBMITTED'.toUpperCase()) {
											perviousCount++;
										}
									}
									for(var i in records) {
										if(!isNullOrEmpty(records[i].data.feeAmount)) {
											totalAmount=totalAmount+parseInt(records[i].data.feeAmount);
										}
									}
									var appeningString='';
									/*var countRemaining=models[0].data.maxCourseEventToApply-
									grid.getSelectionModel().getSelection().length-perviousCount;*/
									var countRemaining=models[0].data.maxCourseEventToApply-tempStore.data.items.length-perviousCount;
									if(totalAmount>0) {
										appeningString = 'Amount to be paid '+"<span style='color:green'>"+totalAmount+"/-</span>";
									}
									if(models[0].data.revaluationFor == 'COURSE_LEVEL') {
										msgLable.setValue(appeningString);
									} else {
										msgLable.setValue(appeningString);
									}
									msgLable.setVisible(true);

									var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
									var btnApprove=grid.down('#btnApprove');
									var btnApplyItemId=grid.down('#btnApplyItemId');
									var btnApplyNow=grid.down('#btnApplyNowItemId');

									if (data.whetherRevalFeeApplicable){
										btnApplyNow.setDisabled(true);
										// btnApprove.setDisabled(false);
										offlinePaymentItemId.setDisabled(false);
										btnApplyItemId.setDisabled(false);
									} else if(!data.whetherRevalFeeApplicable) {
										btnApplyNow.setDisabled(false);
										btnApprove.setDisabled(true);
										btnApplyItemId.setDisabled(true);
										offlinePaymentItemId.setDisabled(true);
									} else {
										btnApplyNow.setDisabled(false);
										btnApprove.setDisabled(false);
										btnApplyItemId.setDisabled(false);
										offlinePaymentItemId.setDisabled(false);
									}
								}
							});
						}
					}
				} else {
					return false;
				}
			}
		}
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function(editor, context, e ){
			console.log(editor);
		}
	}
});