Ext.define('Academia.view.sunsuccess.SunSuccessEditFlag', {
	extend:'Ext.form.Panel',
	alias:'widget.sunsuccesseditflag',
	autoScroll: false,
    model:'Academia.model.sunsuccess.NewFlagModel',
    modal: true,
	frame: true,
	cls:'customSearchPanel',
	standardSubmit: false,
	itemId:'sunsuccesseditflagItemId',
	cls: 'horizontalScrollingFixed',
	border:true,
	autoScroll: false,
    method: 'POST',
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    bodyStyle:{
    	padding: '8px 10px'
    },
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    defaults: {
        labelAlign: 'top'
    },
    title:getCommonTranslation('FLAG_ADD'),
    plugins:"formlabelrequired",
    items: [{
		   	 xtype:'hidden',
		        name:'programId'  	
		    },{
		       xtype: 'hidden',
		       name: 'id'
		   },{
		       xtype: 'hidden',
		       name: 'flagCode'
		   },{
		   	xtype:'hidden',
		   	name:'programIdCode'
		   },{
				xtype:'fieldset',
				title: getCommonTranslation('BASIC_DETAILS'),
				layout:'vbox',
				frame:true,	
				collapsible:true,
				collapsed:false,
				width:'100%',
				itemId : 'sunsuccessflagItemId',
				items: [{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top'
					},
						items:[{
				        	xtype:'textfield',
				        	name: 'flagId',
				        	fieldLabel: getCommonTranslation('FLAG_ID'),
				        	itemId:'flagid',
				        	width: 226,
				//        	emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				        	readOnly: true
				        },{
				  			xtype : 'textfield',
				  			name : 'flagname',
				  			itemId:'flagnameId',
				  			width: 464,
				  			maxLength:100,
				  			maskRe:/[A-Za-z0-9\s]/,
				  			fieldLabel:getCommonTranslation('FLAG_NAME'), //getCommonTranslation('PROGRAM_SEQUENCES'),
				  			maxValue: 100,
				  			minValue:1,
				  			allowBlank: false
				        }]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						width: 226,
						labelAlign: 'top'
					},
						items:[{
							
					        	xtype: 'customcombobox',
					        	name: 'flagcoordinator',
					        	fieldLabel: getCommonTranslation('FLAG_CO_ORDINATOR'),
					        	itemId:'flagcoordinatorItemId',
					        	allowBlank: false,
					        	displayField: 'value',
					        	valueField: 'id',
					        	store:Ext.create('Academia.store.sunsuccess.SunSuccessNewFlagCoOrdinatorStore'),
								minChars:3,
								queryParam:'name',
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
								enableKeyEvents  : 'true',
								forceSelection:true,
								typeAhead:false,
								hideTrigger:false,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}'  +
										'</div>';
									}
								}
					        
						},{
							
				        	xtype: 'customcombobox',
				        	name: 'flagStatus',
				        	fieldLabel: getCommonTranslation('STATUS'),
				        	itemId:'statusItemId',
				        	//id:'statusId',
				        	name:'status',
				        	displayField:'name',
							valueField:'value',
				        	allowBlank: false,
				        	store: {
				        		fields : ['id', 'name','value'],
								data: [
						               { id:'ACTIVE', name:'Active', value:true },            
						               { id:'INACTIVE',name:'Inactive', value:false}
						        ]
							}
				        
					},{
						
			        	xtype: 'customcombobox',
			        	name: 'buisnesrole',
			        	fieldLabel: getMegaMenuTranslation('SUN_BI_BUISRULES'),
			        	itemId:'businessItemId',
			        	displayField:'value',
			        	valueField:'id',
			        	editable:false,
			        	allowBlank: false,
			        	store:Ext.create('Academia.store.sunsuccess.BusinessRulesFlagComboStore'),
			        	queryParam:'name',
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}'  +
								'</div>';
							}
						}
				    }]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
					items:[{
						
				        	xtype: 'multiselectcombofield',//multiselectcombofield
				        	name: 'programShortName',
				        	fieldLabel: getCommonTranslation('LIST_OF_ROLES'),
				        	itemId:'listofrolesItemId',
				        	//width: 464,
				        	allowBlank: false,
				        	displayField: 'code',
				        	valueField: 'id',
				        	store:Ext.create('Academia.store.sunsuccess.SunSuccessNewFlagRolesStore'),
							minChars:3,
							queryParam:'name',
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}'  +
									'</div>';
								}
							}
				        
					},{
			        	xtype: 'radiogroup',
			        	name: 'doyouwanttoschedule',
			        	fieldLabel: getExaminationTranslation('DO_YOU_WANT_TO_SCHEDULE'),
			        	itemId:'doyouwantscheduleId',
			        	defaults: {flex: .5},
			        	allowBlank: false,
			        	layout: 'hbox',
			        	items:[{
			                    boxLabel  : getCommonTranslation('YES'),
			                    name      : 'no',
			                    inputValue: 1,
			                }, {
			                    boxLabel  : getCommonTranslation('NO'),
			                    name      : 'no',
			                    inputValue: 0,
			                    checked:true
			                
			        	}],
			        listeners:{
			        	change:function(opts,newvalue,oldvalue,obj){
			        		var basicflagdetail = opts.up().up();
		        			var schedule = basicflagdetail.down('#scheduleItemId');
		        			var daydate = basicflagdetail.down('#selectdaydateItemId');
		        			var day = basicflagdetail.down('#selectdateItemId');
			        		if(newvalue.no == 1){
			        			schedule.setDisabled(false);
			        			daydate.setVisible(true);
			        			schedule.setValue(1);
			        			day.setVisible(false);
			        			daydate.setDisabled(false);
			        			day.setDisabled(true);
			        			if(!daydate.getValue() && basicflagdetail.up().getForm().wasValid){
			        				basicflagdetail.up().isValid();
			        			}
			        		}else{
			        			schedule.setDisabled(true);
			        			daydate.setDisabled(true);
			        			day.setDisabled(true);
			        			schedule.reset();
			        			daydate.reset();
			        			day.reset();
			        		}
			        	}
			        }
				}, {
		        	xtype: 'customcombobox',
		        	name: 'schedule',
		        	fieldLabel: getExaminationTranslation('SCHEDULE'),
		        	itemId:'scheduleItemId',
		        	editable:false,
		        	store:{
		        		fields : ['id', 'name'],
						data: [
				               { id:1, name:'Monthly'},            
				               { id:2,name:'Weekly'},
				               { id:3,name:'Daily'},
				        ]
					},
		        	displayField:'name',
		        	valueField:'id',
		        	allowBlank: false,
		        	disabled:true,
		        	
		        	
			    }]
		},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
				items:[{
					xtype: 'customcombobox',
		        	name: 'schedule',
		        	fieldLabel: getExaminationTranslation('SELECT_DAY_DATE'),
		        	itemId:'selectdaydateItemId',
		        	store:Ext.create('Academia.store.sunsuccess.SunsuccessNewFlagDayDateStore'),
		        	displayField:'date',
		        	valueField:'id',
		        	allowBlank: false,
		        	queryMode: 'local',
		        	disabled:true,	
		        	editable:false,
				},{
					xtype: 'customcombobox',
		        	name: 'schedule',
		        	fieldLabel: getExaminationTranslation('SELECT_DAY_DATE'),
		        	itemId:'selectdateItemId',
		        	editable:false,
		        	store:{
		        		fields : ['id', 'day'],
						data: [
							{"id":1, "day":"Monday"},
					        {"id":2, "day":"Tuesday"},
					        {"id":3, "day":"Wednesday"},
					        {"id":4, "day":"Thursday"},
					        {"id":5, "day":"Friday"},
					        {"id":6, "day":"Saturday"},
					        {"id":7, "day":"Sunday"},
				        ]
					},
		        	displayField:'day',
		        	valueField:'id',
		        	hidden:true,
		        	allowBlank: false,
		        	queryMode: 'local',
		        	disabled:true,
				},{
						
			        	xtype: 'datefield',
			        	name: 'startdate',
			        	fieldLabel: getCommonTranslation('START_DATE'),
			        	itemId:'startdateItemId',
			        	listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						endDateField: 'endDateItemId',
						vtype : 'daterange'
			        
				}, {
					
		        	xtype: 'datefield',
		        	name: 'enddate',
		        	fieldLabel: getServiceRequestTranslation('END_DATE'),
		        	itemId:'endDateItemId',
		        	startDateField : 'startdateItemId',
		        //	allowBlank: true
		        	listeners:{
		        		render: function(field) {
							return dateFormatRender(field);
						}
		        	},
				   vtype : 'daterange'
		        
			    }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
				items:[/*{
					
		        	xtype: 'datefield',
		        	name: 'enddate',
		        	fieldLabel: getCommonTranslation('END_DATE'),
		        	itemId:'endDateItemId',
		        	startDateField : 'startdateItemId',
		        //	allowBlank: true
		        	listeners:{
		        		render: function(field) {
							return dateFormatRender(field);
						}
		        	},
				   vtype : 'daterange'
		        
			    },*/{
			        	xtype: 'radiogroup',
			        	name: 'manually',
			        	fieldLabel: 'Can be initiated manually?',//getCommonTranslation('PROGRAM_SHORT_NAME'),
			        	itemId:'manuallyItemId',
			        	defaults: {
							 flex: 1
						 },
						 layout: 'hbox',
						 items: [{
								 boxLabel  :getCommonTranslation('YES') ,
								 name      : 'yes',
								 itemId : 'newYesFlagRadioUnitId',
								 inputValue: true
								 
							 }, {
								 boxLabel  : getCommonTranslation('NO'),
								 name      : 'yes',
								 itemId : 'newNoFlagRadioUnitId',
								 inputValue: false,
								 checked : true
							 }]
			        
				}]
		}]
		   
		}, {

			xtype:'fieldset',
			title: getCommonTranslation('FLAG_CONFIGURATION'),
		//	layout:'vbox',
		//	frame:true,	
			collapsible:true,
			collapsed:false,
			width:'100%',
			itemId : 'sunsuccesseditflaggridIds',
			items:[{
				xtype:'sunsuccessnewflaggrid',
				itemId:'sunsuccesseditflaggridId',
				store: Ext.create('Academia.store.sunsuccess.SunSuccessNewFlagStore')
			}]
		}, {
	        xtype: 'fieldcontainer',
	        width: '100%',
	        style: {
	            marginTop: '10px'
	        },
	        items: [{
	            xtype: 'button',
	            action: 'Submit',
	            text: getCommonTranslation('SAVE'),
	            itemId: 'btnUpdateAddFlag',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true,
	            listeners: {
	            	afterrender: function(btn) {
	            		if(btn.up('form').viewOnly) {
	            			btn.hide();
	            		}
	            	}
	            }
	        }]
	    }]
});