Ext.define('Academia.view.sunsuccess.SunSuccessGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.sunsuccessgrid',
	store: 'sunsuccess.SunSuccessGridStore',
	title: getCommonTranslation('LIST_OF_FLAG'),
	border: true,
	refreshStoreData:true,
	tbar: [{
		xtype: 'button',
		itemId: 'searchResultGridBtnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'searchResultGridBtnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'searchResultGridBtnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'	
	},{
		xtype: 'button',
		itemId: 'searchResultGridBtnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'approveButtonId',
//		width:150,
		text : getCommonTranslation('Approve'),
		tooltip: getCommonTranslation('Approve')
	},{	
		xtype: 'button',
		itemId: 'calculateScoreId',
		text : getCommonTranslation('CALCULATE_SCORE_FLAG'),
		tooltip: getCommonTranslation('CALCULATE_SCORE_FLAG'),
		disabled: true
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,true);
		this.callParent(arguments);     
	},
	selModel: {
		//multiSelect :true,
		mode:'SINGLE'
		//checkOnly : false
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getCommonTranslation('FLAG_ID'),
		dataIndex: 'flagCode',
		sortable:true,
		flex: .1
	}, {
		header: getCommonTranslation('FLAG_NAME'),
		dataIndex: 'flagName',
		sortable: true,
		flex: .1
	}, {
		header: getCommonTranslation('FLAG_COLOR') + ' & ' + getCommonTranslation('NOTOFICATION_EVENT'),
		dataIndex: 'flagConfigurationDetailCount',
		sortable:true,
		flex: .2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value) && value != 0) {
				//	return getCommonTranslation(value);
				return '<a href="#">'+value+'</a>';
			}
			else if(value == 0) {
				return value;
			}
			else {
				return "-";
			}                     
		}
	}, /*{
        header: getCommonTranslation('NOTOFICATION_EVENT'),
        dataIndex: 'businessRuleId',
        sortable:true,
        flex: .1,
        renderer: function(date) {
            return dateRender(date);
        }
    },*/ {
		header: getCommonTranslation('MAPPED_STUDENT'),
		dataIndex: 'mappedStudentCount',
		sortable:true,
		type: 'Date',
		flex: .1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value) && value != 0) {
				//	return getCommonTranslation(value);
				if(value!=0)
					return '<a href="#">'+value+'</a>';
				else
					return value;
			}
			else if(value == 0) {
				return value;
			}
			else {
				return "-";
			}                     
		}
	}, {
		header: getCommonTranslation('NOTIFIED_STUDENT'),
		dataIndex: 'studentsNotifiedCount',
		sortable:true,
		flex: .1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value) && value != 0) {
				//	return getCommonTranslation(value);
				if(value!=0)
					return '<a href="#">'+value+'</a>';
				else
					return value;
			}
			else if(value == 0) {
				return value;
			}
			else {
				return "-";
			}  
		}
	},{
		header: getCommonTranslation('APPROVAL_STATUS'),
		dataIndex: 'approveStatus',
		sortable:true,
		flex: .1,
		renderer: function(value) {
			//return statusRender(value);
			if(value == null) {
				return "";
			}
			else if(value == false){
				return getCommonTranslation('Pending');
			}
			else{
				return getCommonTranslation('Approved');
			}
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'flagStatus',
		sortable:true,
		flex: .1,
		renderer: function(value) {
			return statusRender(value);
		}
	}],
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sunsuccess.SunSuccessGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],

	disableButtonsByPivileges: function(privilegeList) {
		/*TODO: remove the console after understanding, This prints only those permissions
		 * which the user has.
		 * accordingly the buttons will be hidden/shown 
		 */
		buttonsToolBar = this.query('toolbar[dock=top]')[0];//this.query('#sunsuccessButtonsToolbar')[0];
		try{
			var gridItemId = this.itemId;//buttonsToolBar.up('grid').itemId;
		}
		catch(e){
			var gridItemId = '';
		}
		/**
		 * querying the buttons and unhiding them if any.
		 */
		var buttons = buttonsToolBar.query('button');
		Ext.each(buttons, function(button) {
			button.setVisible(false);
		});

		Ext.each(privilegeList, function(privilege) {
			if(privilege === 'DELETE') {
				var button = buttonsToolBar.query('#searchResultGridBtnDelete')[0];
				if(button != undefined) {
					button.setVisible(true);
				}
			} else if (privilege === 'UPDATE') {
				var button = buttonsToolBar.query('#searchResultGridBtnEdit')[0];
				if(button != undefined) {
					button.setVisible(true);
				}
			} else if (privilege === 'CREATE'){
				var button = buttonsToolBar.query('#searchResultGridBtnAdd')[0];
				if(button != undefined) {
					button.setVisible(true);
				}
			} else if (privilege === 'VIEW_DETAILS') {
				var button = buttonsToolBar.query('#searchResultGridBtnView')[0];
				if(button != undefined && gridItemId!="programBathcReportGrid" && gridItemId!="delayedCourseSearchGrIdCBS") {
					button.setVisible(true);
				}
			}  else if (privilege === 'EXPORT') {
				var buttonsArray = new Array();
				buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
				buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
				Ext.each(buttonsArray, function(button) {
					button.setVisible(true);	
				});
			} else if (privilege === 'EDIT') {
				var button = buttonsToolBar.query('#searchResultGridBtnEdit')[0];
				if(button != undefined) {
					button.setVisible(true);
				}
			}else if(privilege === 'APPROVE'){
				var button = buttonsToolBar.query('#approveButtonId')[0];
				if(!isNullOrEmpty(button)){
					button.setVisible(true);
				}  
			}else if(privilege === 'CALCULATE_SCORE_FLAG'){
				var button = buttonsToolBar.query('#calculateScoreId')[0];
				if(!isNullOrEmpty(button)){
					button.setVisible(true);
				}  
			}
		});
	}
})