
/**
 * @author Shashi Kumara
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRulesApplyToBatchGrid', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.businessrulesapplytobatchgrid',
	
	
//	title: getExaminationTranslation('BATCH'),
	width:'100%',
	height:'100%',
	autoScroll:false,
	bodyStyle:{
		border: 0
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	items:[{
		xtype:'label',
		itemId:'degreeClassificationNameLabel',
		margin: 10
	},{
		xtype:'grid',
		title:getExaminationTranslation('BATCH'),
		id:'businessrulebatchgridid',
		store: 'sunsuccess.BusinessRuleBatchGridStore',
		border: true,
		autoScroll:false,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store: 'sunsuccess.BusinessRuleBatchGridStore',
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			}]
		}],
	tbar: [{
			xtype: 'button',
			itemId: 'btnLinkAlItemId',
			tooltip: getExaminationTranslation('NEXT'),
	        scale: CONSTANTS.BUTTONSIZE,
			text:'<div style="color: black">'+getExaminationTranslation('NEXT')+'</div>',
		},{
			xtype: 'button',
			itemId: 'submitid',
			tooltip: getCommonTranslation('SUBMIT'),
	        scale: CONSTANTS.BUTTONSIZE,
	        disabled:true,
			text:'<div style="color: black">'+getExaminationTranslation('SUBMIT')+'</div>',
		},{
			xtype: 'button',
			itemId: 'btnReset',
			tooltip: getExaminationTranslation('RESET'),
			text:'<div style="color: black">'+getExaminationTranslation('RESET')+'</div>',
		},{			
			xtype: 'customcombobox',
			name: 'academyLocation',
			itemId:'academylocationid',
			store: 'sunsuccess.BusinessRuleBatchGridStore',
			valueField: 'batchId',
			displayField: 'batchName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryParam:'qry',
			queryMode: 'remote',
			width:226,
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: '',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
	}],
	columns: [{
		header: getExaminationTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.9,
		sortable:true
	},{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.9,
		sortable:true
	},{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.9,
		sortable:true
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
	}]
	
   }]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});