Ext.define('Academia.view.sunsuccess.sunsuccessbusinessattrbts.SunsuccessBusinessRuleWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.sunsuccessbusinessrulewindow',
	title: getCommonTranslation('ADD_RULE'),
	//height:250,
	modal: true,
	items:[{
		xtype: 'form',
		plugins : "formlabelrequired",
		items: [{
			xtype: 'hiddenfield',
	        name: 'attributeTypeId'
		}, {
			xtype: 'hiddenfield',
	        name: 'attributeRuleId'
		}, {
			xtype: 'hiddenfield',
	        name: 'id'
		},
		{
			xtype:'fieldcontainer',
			itemId:'businessruleId',
			width:550,
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items:[{
				xtype: 'numberfield',
				name: 'rangeFrom',
				itemId:'rangeFromId',
				fieldLabel: getCommonTranslation('RANGE_FROM'),
				width:226,
				allowBlank: false,
	//			minValue:0,
				allowDecimals:true,
				//hideTrigger:true,
	        	mouseWheelEnabled:false,
	        	decimalPrecision :2,
				fixPrecision : function(value){
					         var me = this,
					            nan = isNaN(value),
					            precision = me.decimalPrecision;

					        if (nan || !value) {
					            return nan ? '' : value;
					        } else if (!me.allowDecimals || precision <= 0) {
					            precision = 0;
					        }

					            str = value.toString();
					   if(str.indexOf(".") > 0){
						    str = str.slice(0, (str.indexOf(".")) + precision + 1);
					}
					    return Number(str); 
					        },
				validator : function(val) {
	   	       		 var maxValuefield = this.nextSibling();
	   	       		 var maxValue = maxValuefield.getValue();
	   	       		 if (maxValue != null) {
	   	       			
	   	       			 if (val < maxValue && val <= this.maxValue) {
	   	       				 maxValuefield.clearInvalid();
	   	       				 return true;
	   	       			 } else {
	   	       				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
	   	       			 }
	   	       		 } else {
	   	       			 return true;
	   	       		 }
	   	       	   }
				
			},{
				xtype: 'numberfield',
				name: 'rangeTo',
				itemId:'rangeToId',
				fieldLabel: getCommonTranslation('RANGE_TO'),
				allowBlank: false,
	//			minValue:0,
				allowDecimals:true,
	        	hideTrigger:false,
	        	validateOnBlur: true,
	        	mouseWheelEnabled:false,decimalPrecision :2,
				fixPrecision : function(value){
					         var me = this,
					            nan = isNaN(value),
					            precision = me.decimalPrecision;

					        if (nan || !value) {
					            return nan ? '' : value;
					        } else if (!me.allowDecimals || precision <= 0) {
					            precision = 0;
					        }

					            str = value.toString();
					if(str.indexOf(".") > 0){
					    str = str.slice(0, (str.indexOf(".")) + precision + 1);
				}
					    return Number(str); 
					        },
	        	validator : function(val) {
	    	   		 var minValueField =this.previousSibling();
	    	   		 var minValue = minValueField.getValue();
	    	   		 if (minValue != null) {
	    	   			 if (val > minValue) {
	    	   				 if(val <= minValueField.maxValue){
	    	   					minValueField.clearInvalid();
	    	   					this.wasValid = false;
	    	   					return true;
	    	   				 }else{
	    	   					this.preventMark = false;
	    	   					if(this.wasValid == false){
		    	   					this.wasValid = true;
		    	   				 }
	    	   					return true;
	    	   				 }
	    	   			 } else {
	    	   				 if(this.wasValid == false){
	    	   					this.wasValid = true;
	    	   				 }
	    	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
	    	   			 }
	    	   		 } else {
	    	   			 return true;
	    	   		 }
	    	   	  }
			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			itemId:'businessruleId1',
			hidden:false,
	//		plugins : "formlabelrequired",
			defaults: {
				labelAlign: 'top',
			},
			items:[{
				xtype: 'numberfield',
				name: 'score',
				width:226,
				fieldLabel: getCommonTranslation('SCORE'),
				allowBlank: false,
				minValue:-99.99,
				maxValue:99.99,
				allowDecimals:true,
				hideTrigger:false,
				decimalPrecision :2,
				fixPrecision : function(value){
					         var me = this,
					            nan = isNaN(value),
					            precision = me.decimalPrecision;

					        if (nan || !value) {
					            return nan ? '' : value;
					        } else if (!me.allowDecimals || precision <= 0) {
					            precision = 0;
					        }

					            str = value.toString();
					   if(str.indexOf(".") > 0){
						    str = str.slice(0, (str.indexOf(".")) + precision + 1);
					}
					    return Number(str); 
					        }
			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			itemId:'businessattributeId',
			width:550,
			hidden:true,
	//		plugins : "formlabelrequired",
			defaults: {
				labelAlign: 'top',
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel : getCommonTranslation('SUCCESSFLAGS_ATTRIBUTE_TYPE'),
				width : 226,
				name: 'attributeTypeId',
				itemId:'attributeTypeId',
				displayField: 'code',
				valueField: 'id',
				store: 'sunsuccess.AttributeType',
				minChars:3,
				editable:false,
				queryParam:'name',
				allowBlank: false,
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}

			},{
				xtype: 'textfield',
				name: 'attributeRuleName',
				itemId:'attributeRuleNameId',
				fieldLabel: getCommonTranslation('SUCCESSFLAGS_ATTRIBUTE_RULE_NAME'),
				width:226,
				allowBlank: false,
				disabled: true,
				maxLength:25,
				vtype:'NoSpecialCharacterAsInput',
				allowOnlyWhitespace: false,
				cls: 'custom-disabled'
			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			hidden:true,
			itemId:'businessattributeId1',
	//		plugins : "formlabelrequired",
			defaults: {
				labelAlign: 'top',
			},
			items:[{
				xtype: 'customcombobox',
				displayField: 'code',
				editable:false,
				valueField: 'code',
				store: {
					fields: ['code'],
					data: [{
						code: 'Due Fees Percentage'
					}, {
						code: 'Due Fees Amount'
					}]
				},
				name: 'applicableOn',
				itemId: 'applicableOnId',
				width:226,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_ON'),
				allowBlank: false,
				hidden: true,
				disabled: true
			}]

		},{
			xtype:'fieldcontainer',
			cls : 'windowBtnPos',
			items:[{
				xtype : 'button',
				text  : getCommonTranslation('SAVE'),
				itemId : 'saveButtonId',
				formBind: true,
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
			},{
				xtype : 'button',
				text  : getCommonTranslation('CANCEL'),
				itemId: 'cancelBtnId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
			}]
		}]
	}]
});