/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.survey.sendSurvey.ActivateSurveyWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.activatesurveywindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getCommonTranslation('ACTIVATE_SURVEY'),
    width: 550,
    height: 200,
    items: [{
        xtype: 'form',
        itemId: 'activateSurveyForm',
        layout: 'vbox',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
    			xtype: 'datefield',
    			name: 'fromdate',
    			itemId:'fromdate',
    			allowBlank : false,
    			minValue: new Date(),
    			vtype: 'daterange',
    			endDateField: 'todate',
    			fieldLabel: getAdmissionTranslation('FROM_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		},{
    			xtype: 'datefield',
    			name: 'todate',
    			itemId:'todate',
    			allowBlank : false,
    			vtype: 'daterange',
    			startDateField: 'fromdate',
    			minValue: new Date(),
    			fieldLabel: getAdmissionTranslation('TO_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}]
        },{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('ACTIVATE_SURVEY'),
				itemId : 'activateSurveyWinBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'activateSurveyWinCancelBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		}]
    }]

});