Ext.define('Academia.view.survey.sendSurvey.SendSurveyPBSGridTwo', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sendsurveypbsgridtwo',
	title: getCommonTranslation('LIST_OF_COURSE_VARIANTS'),
	border: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sendsurveystructure':1
		}
	},
	tbar: [{
		xtype: 'button',
		itemId: 'activateSurveyPBSBtn',
		text: getCommonTranslation('ACTIVATE_SURVEY'),
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'getParticipantsPBSBtn',
		text: getCommonTranslation('ADD_PARTICIPANTS'),
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'sendSurveyPBSBtn',
		text: getCommonTranslation('SEND_SURVEY'),
		disabled: true
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_ID'),
		dataIndex: 'surveyId',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_NAME'),
		dataIndex: 'surveyName',
		flex:.3,
		sortable: true
	},{
		header: getCBTranslation('survey_whetherAnonymous'),
		dataIndex: 'isAnonymized',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(!isNullOrEmpty(value) && (value=="true" || value==true)){
				return  getCommonTranslation('YES');
			}else{
				return getCommonTranslation('NO');
			}
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'surveyStatus',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('ENROLLED_PARTICIPANTS'),
		dataIndex: 'totalParticipant',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('NEWLY_ENROLLED_PARTICIPANTS'),
		dataIndex: 'newlyEnrolled',
		flex:.3,
		sortable: true,
		renderer: function(value,rec){
			if(rec.record.get('totalSurveyEnrolled') == 0){
				return "0";
			}
			else{
				return value;
			}
		}
	},{
		header: getCommonTranslation('PARTICIPANTS'),
		dataIndex: 'totalSurveyEnrolled',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_SENT'),
		dataIndex: 'totalEmailSent',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_REMAINING'),
		dataIndex: 'surveyRemaining',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value) && value!=0){
				return '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header: getCommonTranslation('NO_OF_QUESTIONS'),
		dataIndex: 'noOfQuestions',
		flex:.3,
		sortable: true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.survey.SendSurveyPBSGridStore');
	}
});