/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.taskmanagement.TMMyTasksGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.tmmytasksgrid',
	store: 'taskmanagement.TMMyTasksStore',
	title: getServiceRequestTranslation('TM_MY_TASKS'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'taskmanagement.TMMyTasksStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	tbar: [],
	columns: [{
		header: getServiceRequestTranslation('EMM_SERIAL_NO'),
		dataIndex: 'serialNo',
		flex: 0.4,
		sortable: true
	}, {
		header: getServiceRequestTranslation('EMM_ASSIGNED_DATE'),
		dataIndex: 'assignDate',
		flex: 1,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('DESCRIPTION'),
		dataIndex: 'description',
		flex: 2,
		sortable: true
	}, {
		header: getServiceRequestTranslation('TM_ASSIGNED_BY'),
		dataIndex: 'minuteTakerPrintName',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('EMM_TASK_STATUS'),
		dataIndex: 'status',
		flex: 1,
		sortable: true,
		renderer: function(val) {
			var colorValue = '';
			if (val == 'PENDING') {
				colorValue = "<a href='#' style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</a>";
			} else if (val == 'COMPLETED') {
				colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
			}
			return colorValue;
		}
	}, {
		header: getServiceRequestTranslation('DUE_DATE'),
		dataIndex: 'dueDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('EMM_COMPLETION_DATE'),
		dataIndex: 'completionDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('EMM_NO_OF_DAYS_OVERDUE'),
		dataIndex: 'noOfDaysOverdue',
		flex: 1,
		sortable: true,
	}, {
		header: getServiceRequestTranslation('ASSIGNEED_BY_REMARK'),
		dataIndex: 'assignedByRemark',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if(!isNullOrEmpty(value)){
				return "<a href='#'>View</a>";
			}
		}
	},{
		header: getServiceRequestTranslation('ASSIGNEE_REMARK'),
		dataIndex: 'taskRemarks',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return "<a href='#'>View</a>";
		}
	},{
        header: getCommonTranslation('ATTACHMENTS'),
        dataIndex: 'attachments',
        sortable: true,
        flex: 1,
        renderer: function(value, metadata, record) {
    		return '<a href="#">' + "View" + '</a>';
    	}
    }]
});