/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.taskmanagement.TaskManagementFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.taskmanagementfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'userType',
            itemId: 'userTypeItemId',
            fieldLabel: getFileManagementTranslation('USER_TYPE'),
            editable: false,
            disableKeyFilter: false,
            valueField: 'id',
            displayField: 'userGroupName',
            store: 'userGroup.UserGroupStore',
            queryMode: 'local',
            hidden: true
        }, {
            xtype: 'customcombobox',
            name: 'ownerId',
            itemId: 'ownerIdItemId',
            fieldLabel: getServiceRequestTranslation('EMM_USER_ID_NAME'),
            msgTarget: 'qtip',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            minChars: 3,
            disabled: true,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection: true,
            maxLength: 100,
            hidden: true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
                    combo.bindStore(store)
                }
            },
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateItemId',
            vtype: 'daterange',
            endDateField: 'toDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_FROM_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDateItemId',
            vtype: 'daterange',
            startDateField: 'fromDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_TO_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnTaskmanagementfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetTaskmanagementfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});