/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.taskmanagement.TaskManagementTaskGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.taskmanagementtaskgrid',
    store: 'eventmeetingminutes.EventMeetingMinutesTaskStore',
    title: getServiceRequestTranslation('TM_TASK_LIST'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        markDirty:false
    },
    isGridConfigurable: true,
	enableColumnHide: false,
    columns: [{
        header: getServiceRequestTranslation('EMM_SERIAL_NO'),
        dataIndex: 'serialNo',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('EMM_ASSIGN_DATE'),
        dataIndex: 'assignDate',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'assignDate',
            itemId: 'assignDateItemId',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            maxValue: new Date(),
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.assignDatePrefillValue)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.assignDatePrefillValue)) {
                    val = record.data.assignDatePrefillValue;
                }
                models[rowIndex].set("assignDate", val);
                models[rowIndex].set("assignDatePrefillValue", val);
                return dateRender(val);
            }
        }
    }, {
        header: getServiceRequestTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'textareafield',
            name: 'description',
            itemId: 'descriptionId',
            maxLength: 160,
            autoScroll: true,
            grow: true,
            minHeight: 40,
            enableKeyEvents : true,
            shrinkWrap: true,
            padding: 0,
            rows: 10,
            autoHeight: true,
            maskRe: /[^\^<>/]/,
            height: 40,
            margin: '10 0 0 0',
            listeners: {
                focus: function(th, e, oldValue, eOpts) {
                    th.autoSize();
                    var carLngth = th.getValue().length;
                    th.setHeight((carLngth / 40) * 23);
                    var relatedTarget = Ext.get(e.relatedTarget);
                    var currentTarget = Ext.get(e.target);
                    topValue = relatedTarget.getRegion().top;
                    currentTarget.setRegion({
                        top: topValue
                    });
                    th.up().up().doComponentLayout();
                },
                keyup: function(field, e, eOpts) {
                	if (/(<([^>]+)>)/ig.test(field.value)) {
                		field.setValue(field.value.replace(/(<([^>]+)>)/ig, ""));
                	}

                	if (field.value.indexOf('<') > 0) {
                	    field.setValue(field.value.replace('<', ""))
                	}

                	if (field.value.indexOf('>') > 0) {
                	    field.setValue(field.value.replace('>', ""))
                	}

                	if (field.value.indexOf('/') > 0) {
                	    field.setValue(field.value.replace('/', ""))
                	}
                }
            }
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.designation)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getServiceRequestTranslation('TM_ASSIGNED_TO'),
        dataIndex: 'ownerId',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'ownerId',
            itemId: 'ownerIdItemId',
            store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            var models = grid.getStore().getRange();
            if (isNullOrEmpty(val) && isNullOrEmpty(models[rowIndex].get("ownerPrefillId"))) {
                var models = grid.getStore().getRange();
                models[rowIndex].set("ownerPrefillId", null);
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(models[rowIndex].get("ownerPrefillId"))) {
                    val = models[rowIndex].get("ownerPrefillId");
                }
                models[rowIndex].set("ownerId", val);
                models[rowIndex].set("ownerPrefillId", val);

                //var viewParticipantList = grid.getViewParticipantList();
                var viewParticipantList = grid.config.viewParticipantList;
                for (i in viewParticipantList) {
                    if (val == viewParticipantList[i].id) {
                        return viewParticipantList[i].printName;
                    }
                }
            }
        }
    },{
        header: getServiceRequestTranslation('TASK_PROVIDER_REMARK'),
        dataIndex: 'remark',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'textareafield',
            name: 'remark',
            itemId: 'remark',
            maxLength: 160,
            autoScroll: true,
            grow: true,
            minHeight: 40,
            enableKeyEvents : true,
            shrinkWrap: true,
            padding: 0,
            rows: 10,
            autoHeight: true,
            maskRe: /[^\^<>/]/,
            height: 40,
            margin: '10 0 0 0',
            listeners: {
                focus: function(th, e, oldValue, eOpts) {
                    th.autoSize();
                    var carLngth = th.getValue().length;
                    th.setHeight((carLngth / 40) * 23);
                    var relatedTarget = Ext.get(e.relatedTarget);
                    var currentTarget = Ext.get(e.target);
                    topValue = relatedTarget.getRegion().top;
                    currentTarget.setRegion({
                        top: topValue
                    });
                    th.up().up().doComponentLayout();
                },
                keyup: function(field, e, eOpts) {
                	if (/(<([^>]+)>)/ig.test(field.value)) {
                		field.setValue(field.value.replace(/(<([^>]+)>)/ig, ""));
                	}

                	if (field.value.indexOf('<') > 0) {
                	    field.setValue(field.value.replace('<', ""))
                	}

                	if (field.value.indexOf('>') > 0) {
                	    field.setValue(field.value.replace('>', ""))
                	}

                	if (field.value.indexOf('/') > 0) {
                	    field.setValue(field.value.replace('/', ""))
                	}
                }
            }
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.designation)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    },{
        header: getServiceRequestTranslation('EMM_TASK_STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'statusItemId',
            valueField: 'id',
            displayField: 'colorValue',
            forceSelection: true,
            editable: false,
            listeners: {
                focus: function(combo, eOpt) {
                    if (combo.getRawValue() == "")
                        combo.setRawValue(getCommonTranslation("PENDING"));
                    else
                        combo.setRawValue(getCommonTranslation(combo.getValue()));
                },
                blur: function(combo, r) {
                    combo.setValue(combo.getValue());
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.eventmeetingminutes.EventMeetingMinutesStatusStore');
                    combo.bindStore(store);
                },
                change: function(combo, eOpt) {
                    combo.setRawValue(getCommonTranslation(combo.getValue()));
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.statusPrefillValue)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {
                    //if (record.data.statusPrefillValue == 'PENDING') {
                    if (val == 'COMPLETED') {
                        models[rowIndex].set("completionDate", new Date());
                    } else {
                        models[rowIndex].set("completionDate", '');
                    }
                    // }
                } else if (!isNullOrEmpty(record.data.statusPrefillValue)) {
                    val = record.data.statusPrefillValue;
                    models[rowIndex].set("status", val);
                }
                var colorValue = '';
                if (val == 'PENDING') {
                    colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
                } else if (val == 'COMPLETED') {
                    colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
                }
                return colorValue;
            }
        }
    }, {
        header: getServiceRequestTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'dueDate',
            itemId: 'dueDateItemId',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            minValue: new Date(),
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.dueDatePrefillValue)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.dueDatePrefillValue)) {
                    val = record.data.dueDatePrefillValue;
                }
                models[rowIndex].set("dueDate", val);
                models[rowIndex].set("dueDatePrefillValue", val);
                return dateRender(val);
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_COMPLETION_DATE'),
        dataIndex: 'completionDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('EMM_NO_OF_DAYS_OVERDUE'),
        dataIndex: 'noOfDaysOverdue',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: .5,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow)
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 1,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (rowIndex > 0 && !isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
    }, {
        header: getServiceRequestTranslation('ASSIGNEE_REMARK'),
        dataIndex: 'showViewLink',
        flex: 1,
        sortable: true,
        hidden: true,
        renderer: function(value, meta, record) {
            if (value)
                return "<a href='#'>View</a>";
            return '';
        }
    },{
        header: getCommonTranslation('ATTACHMENTS'),
        dataIndex: 'attachments',
        sortable: true,
        flex: 1,
        renderer: function(value, metadata, record) {
    		if(isNullOrEmpty(record.get('id'))){
				return "<p style='color:grey;margin-top: 3px;text-decoration: underline'>View</p>";
			}else{
				return "<a href='#'>"+"View"+"</a>";
			}
    	}
    }
    ],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
                if (editor.record.data.isEditable == 'ADD') {
                    return true;
                } else if (editor.record.data.isEditable == 'EDIT') {
                    return true;
                } else if (editor.record.data.isEditable == 'VIEW') {
                    return false;
                }
            }
        }
    }]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});