/**
 * Sohan Chouhan
 */

Ext.define('Academia.view.transport.vehicle.FitnessCertificateWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.fitnesscertificatewin',
	title: getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
//	maxHeight: 600,
	height: '50%',
	width: '40%',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'fitnesscertificatewinId',
	    plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		items: [{
            xtype: 'hidden',
            itemId: 'id',
            name: 'id'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'certifiedBy',
				itemId:'certifiedBy',
				fieldLabel: getTransportTranslation('CERTIFIED_BY'),
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
			},{
				xtype: 'datefield',
				name:'issueDate',
				itemId:'issueDate',
				vtype: 'daterange',
				fieldLabel: getTransportTranslation('ISSUE_DATE'),
				maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name:'expirationDate',
				itemId:'expirationDate',
				vtype: 'daterange',
				minValue: new Date(),
				fieldLabel: getTransportTranslation('EXPIRATION_DATE'),
				allowBlank: false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name:'vehicleFitCertificateDocument',
				itemId:'vehicleFitCertificateDocument',
				fieldLabel: getTransportTranslation('VEHICLE_FITNESS_CERTIFICATE_DOCUMENT'),
				spinUpEnabled : false,
				spinDownEnabled : false,
				allowBlank: false,
				hideTrigger : true,
			},{
                xtype: 'filefield',
                itemId: 'vehicleFitCertificateUploadFile',
                region: 'south',
                ui: 'CustomBtnSubmit',
                fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
                buttonText: getPersonModuleTranslation('UPLOAD'),
                allowBlank: false,
                name: 'file'
            }]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnVehicleFitCertificate',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnVehicleFitCertificate',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});