/**
 * multiSelect combo box
 */
Ext.define('Ext.ux.MultiselectComboField', {
    extend : 'Ext.form.field.ComboBox',
	alias : 'widget.multiselectcombofield', 
	requires: ['Ext.ux.ComboView'],
	
	addAllSelector: true, // to add all selector to first row
	allSelector: true,
	allText: '<b><u>'+getCommonTranslation('SELECT_ALL')+'</u></b>', // change text for 'all' selector
	noData: false,
	overridetSubmitData :false,
	
	cls: 'x-multiselectcombofield',
	/**
	 * @cfg maxLength for inputEl.
	 */
	maxLength: 5000,
	/**
	 * @cfg minimum width for inputEl.
	 */
	minWidth: 226,
	/**
	 * @cfg minimum width for list.
	 */
	listConfig:{
		//minWidth :226,
		listeners: {
			beforeshow: function(picker) {
				picker.minWidth = picker.up('combobox').getSize().width;
			}
		}
	},
	maskRe: /[^%]/,
	autoloadStore: true,
	/**
	 * @cfg config for enabling multiple selections
	 */
	multiSelect: true,
	/**
	 * @cfg maximum height for inputEl.
	 */
	maxHeight: 150,
	/**
	 * @cfg name of field used for description/tooltip
	 */
	descField: null,
	/**
	 * @cfg config object passed to the view viewCfg: {},
	 */
	/**
	 * @cfg {String} iconClsField The underlying iconCls field name to bind to
	 *      this ComboBox. iconClsField: '',
	 */
	/**
	 * @cfg {Boolean} createNewOnEnter When forceSelection is false, new records
	 *      can be created by the user. This configuration option has no effect
	 *      if forceSelection is true, which is the default.
	 */
	createNewOnEnter: false,
	/**
	 * @cfg {Boolean} forceSelection override parent config. If force selection
	 *      is set to false and
	 */
	forceSelection: true, 
	/**
	 * @cfg {Boolean} selectOnTab Whether the Tab key should select the
	 *      currently highlighted item.
	 */
	isSetWidth : true,
	selectOnTab : false,
	/**
	 * @cfg {String} trigger1Cls css class for the first trigger. To have just
	 *      one trigger acting like in usual combo, set trigger1Cls to null.
	 *      First trigger clears all values
	 */
	trigger1Cls	: Ext.baseCSSPrefix + 'form-clear-trigger',
	/**
	 * @cfg {String} trigger2Cls css class for the second trigger. To have just
	 *      one trigger, set trigger1Cls to null.
	 */
	trigger2Cls	: Ext.baseCSSPrefix + 'form-combo-trigger',
	
	/**
	 * @cfg {String} listIconCls css class to use when an iconClsField is set.
	 *      This class is injected into getInnerTpl method when constructing the
	 *      comboBox boundList
	 */
    listIconCls : 'x-boundlist-icon',
    /**
	 * @cfg {String} delimiter string delimiter. default ' ' overrides parent
	 *      class ', '. Used in setvalue (if value is a string) to split values.
	 */
    delimiter: ' ',
    fieldSubTpl: [
        '<div class="{hiddenDataCls}" role="presentation"></div>',
        '<div id="{id}"',
            '<tpl if="readOnly"> readonly="readonly"</tpl>',
            '<tpl if="disabled"> disabled="disabled"</tpl>',
            '<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>',
            '<tpl if="name"> name="{name}"</tpl>',
            '<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
            '<tpl if="placeholder"> placeholder="{placeholder}"</tpl>',
            '<tpl if="size"> size="{size}"</tpl>',
            'class="{fieldCls} {typeCls} x-boxselect" autocomplete="off" />',
        '</div>',
    {
        compiled: true,
        disableFormats: true
    }
    ],
    getSubTplData: function () {
        try {
			var me = this, fieldStyle = me.getFieldStyle(), ret = me
					.callParent(arguments);
			ret.fieldStyle = (fieldStyle || '')
					+ ';overflow:auto;height:'
					+ (me.height ? (me.height + 'px;') : 'auto;')
					+ (me.maxHeight ? ('max-height:' + me.maxHeight + 'px;')
							: '');
			delete me.height; // need to delete height for the correct component
			// height to be recalculated on layout.
			return ret;
		} catch (e) {
			// TODO: handle exception
		}
    },
    alignPicker: function () {
        try {
			var me = this, picker = me.getPicker(), w = me.triggerWidth;
			me.callParent(arguments);
			if (me.isExpanded && me.matchFieldWidth) {
				picker.setWidth(me.bodyEl.getWidth()
						- (me.trigger2Cls ? (2 * w) : w));
			}
			me.mon(picker, {
				itemclick : me.onItemClick,
				refresh : me.onListRefresh,
				scope : me
			});
			me.mon(picker.getSelectionModel(), {
				'beforeselect' : me.onBeforeSelect,
				'beforedeselect' : me.onBeforeDeselect,
				'itemclick' : me.onListSelectionChange,
				scope : me
			});
			if (me.addAllSelector == true) {
				if (me.store.getTotalCount() > 8) {
					var height = picker.getHeight();
					height = parseInt(height) + 45;
					picker.setHeight(height);
					if (height < 300) {
						picker.getEl().setStyle('height', 300 + 'px');
					} else {
						picker.getEl().setStyle('height', height + 'px');
					}
				}
			}
		} catch (e) {
			// TODO: handle exception
		}
    },
    initComponent: function () {
        try {
			var me = this;
			if (!me.trigger1Cls) {
				me.onTrigger1Click = null;
				me.trigger2Cls = null;
			}
			me.bindStore(me.store || 'ext-empty-store', true);
			me.getValueStore();
			var selModel = me.multiSelect ? {
				selModel : {
					mode : 'SIMPLE',
					enableKeyNav : false
				}
			} : {
				selModel : {
					mode : 'SINGLE',
					enableKeyNav : false
				}
			};
			me.listConfig = Ext.apply(me.listConfig || {}, selModel);
			// if(me.iconClsField || me.descField) {
			Ext
					.apply(
							me.listConfig,
							{
								getInnerTpl : function(displayField) {
									//  return '<div data-qtip="{' +me.descField +'}" class="'+ ((me.iconClsField && me.listIconCls) ? me.listIconCls :'') +' {'+me.iconClsField + '}">{' + me.displayField +'}</div>';

									//return '<tpl if="xindex%2==0"><div class="odd"></tpl><tpl  if="xindex%2==1"><div class="even"></tpl> {' + displayField + '} </div>';

									/*return '<tpl if="xindex%2==0"><div class="combo-even"></tpl><tpl  if="xindex%2==1"><div class="combo-odd"></tpl>{'
											+ me.displayField
											+ '}'
											+ '<div class="x-combo-checker "></div>';*/
									return '<tpl if="xindex%2==0"><div class="x-combo-checker" style="margin-left:5px"></div><div class="combo-even" style="padding-left: 25px !important;"></tpl><tpl  if="xindex%2==1"><div class="x-combo-checker" style="margin-left:5px"></div><div class="combo-odd" style="padding-left: 25px !important;"></tpl>{'
									+ me.displayField
									+ '}';
								}
							});
			// }
			me.rawValue = me.value;
			me.callParent(arguments);
		} catch (e) {
			// TODO: handle exception
		}
    },
    /**
	 * Trigger1 is the clearAll image, which is used to clear all the selected
	 * values from the multiselect combo.
	 */
    onTrigger1Click : function(keepListOpen) {
    	try {
			    	// TODO: check for the validation as per access.
    		
	    	var me = this;
	    	delete me.valueModels;
	    	delete me.tempValue;
	    	me.valueStore.removeAll();
	    	me.getValueStore().removeAll();
	    	me.reset();
	    	me.setValue("");
	    	if(Ext.isDefined(keepListOpen) && keepListOpen == true){
				// Don't close bound list here on de-select
    		}
	    	else{
	    		me.collapse();
	    	}
			me.afterComponentLayout();
			var contentPanel = Ext.ComponentQuery.query('contentPanel');
			if(contentPanel.length == 1){
				var x = contentPanel[0].getActiveTab();
				if(x.getXType() == 'sunsuccessmapflags'){
					var a = me.el.down('[name=academyLocationCombo]');
					if(a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=program]');
					if(b != null){
						b.setHeight('auto');
					}
					var b = me.el.down('[name=batch]');
					if(b != null){
						b.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'feeplanadvlisting'){
					var a = me.el.down('[name=academyLocation]');
					if(a != null){
						a.setHeight('auto');
					}
				}
				if(x.getXType() == 'admissiondemographicsreportview'){
					var a = me.el.down('[name=programId]');
					if(a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=batchId]');
					if(b != null){
						b.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'urpstructure'){
					var a = me.el.down('[name=privilegeId]');
					if (a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=alId]');
					if(b != null){
						b.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}

				if(x.getXType() == 'facultyleavedashboard'){
					var a = me.el.down('[name=academyLocationId]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
			
				if(x.getXType() == 'userloginfrequency'){
					var a = me.el.down('[name=userIds]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
				if(x.getXType() == 'lmemployeeleaverequeststructure'){
					var a = me.el.down('[name=employeeNames]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'journeyassignmentreportstructure'){
					var a = me.el.down('[name=usersId]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'assessmenteventstructure'){
					var a = me.el.down('[name=course]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'facultylistview'){
					var a = me.el.down('[name=deparmentalId]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
				if(!isNullOrEmpty(x.down('resourceavailabilityreportfilter'))){
					var multiResourseAvailabilityUser = me.el.down('[name=faculty]');
					if (multiResourseAvailabilityUser != null){
						multiResourseAvailabilityUser.setHeight('auto');
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
					}
					}
				if(!isNullOrEmpty(x.down('resourceutilizationsearch'))){
					var multiResourseUtilizationUser = me.el.down('[name=faculty]');
					if (multiResourseUtilizationUser != null){
						multiResourseUtilizationUser.setHeight('auto');
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
					}
					}
				
				if(!isNullOrEmpty(x.down('programcoursefilters'))){
					var a = me.el.down('[name=course]');
					var b = me.el.down('[name=section]');
					var c = me.el.down('[name=faculty]');
					var d = me.el.down('[name=homeRoom]');
					if (a != null){
						a.setHeight('auto');
					}
					if (b != null){
						b.setHeight('auto');
					}
					if (c != null){
						c.setHeight('auto');
					}
					if (d != null){
						d.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
				if(x.getXType() == 'courserequisitestructure'){
					var a = me.el.down('[name=courseMutually]');
					if (a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=course]');
					if (b != null){
						b.setHeight('auto');
					}
					
					var c = me.el.down('[name=courseChild]');
					if (c != null){
						c.setHeight('auto');
					}
					
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'hostelfeereportstructure'){
					var a = me.el.down('[name=academyLocation]');
					if (a != null){
						a.setHeight('auto');
					}
					
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
				if(x.getXType() == "panel"){
					me.inputEl.setStyle('height','auto');
				}
			}
			if(me.allSelector){
				if(Ext.isObject(me.allSelector)){
					if(me.allSelector.hasCls('x-boundlist-selected')){
						me.getValueStore().removeAll();
						me.allSelector.removeCls('x-boundlist-selected');
					}
				}
			}
			//me.inputEl.setStyle('height','auto');
			me.up().doLayout();
		} catch (e) {
			// TODO: handle exception
		}
    },
    /**
	 * Trigger1 is the clearAll image, which is used to clear all the selected
	 * values from the multiselect combo.
	 */
    clearAllDataFn : function() {
    	try {
			    	// TODO: check for the validation as per access.
	    	var me = this;
	    	delete me.valueModels;
	    	delete me.tempValue;
	    	me.valueStore.removeAll();
	    	me.getValueStore().removeAll();
	    	me.reset();
	    	me.setValue("");
			me.afterComponentLayout();
			var contentPanel = Ext.ComponentQuery.query('contentPanel');
			if(contentPanel.length == 1){
				var x = contentPanel[0].getActiveTab();
				if(x.getXType() == 'admissiondemographicsreportview'){
					var a = me.el.down('[name=programId]');
					if(a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=batchId]');
					if(b != null){
						b.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'urpstructure'){
					var a = me.el.down('[name=privilegeId]');
					if (a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=alId]');
					if(b != null){
						b.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'facultylistview'){
					var a = me.el.down('[name=deparmentalId]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}

				if(x.getXType() == 'facultyleavedashboard'){
					var a = me.el.down('[name=academyLocationId]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}

				if(x.getXType() == 'userloginfrequency'){
					var a = me.el.down('[name=userIds]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
				if(x.getXType() == 'lmemployeeleaverequeststructure'){
					var a = me.el.down('[name=employeeNames]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
				if(x.getXType() == 'trackenquirylisting'){
					var a = me.el.down('[name=academyLocation]');
					if (a != null){
						a.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'courserequisitestructure'){
					var a = me.el.down('[name=courseMutually]');
					if (a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=course]');
					if (b != null){
						b.setHeight('auto');
					}
					var c = me.el.down('[name=courseChild]');
					if (c != null){
						c.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				if(x.getXType() == 'programadvsearchlisting'){
					var a = me.el.down('[name=batch]');
					if (a != null){
						a.setHeight('auto');
					}
					var b = me.el.down('[name=courseId]');
					if (b != null){
						b.setHeight('auto');
					}
					var c = me.el.down('[name=variant]');
					if (c != null){
						c.setHeight('auto');
					}
					me.el.dom.style.height = 'auto';
					me.up('form').doLayout();
				}
				
			}
			if(me.allSelector){
				if(Ext.isObject(me.allSelector)){
					if(me.allSelector.hasCls('x-boundlist-selected')){
						me.getValueStore().removeAll();
						me.allSelector.removeCls('x-boundlist-selected');
					}
				}
			}
		} catch (e) {
			// TODO: handle exception
		}
    },
    setValueStore: function(store) {
		this.valueStore = store;
    },
    getValueStore: function() {
        	var me = this;
		return me.valueStore || (me.valueStore = me.createValueStore());
    },
    createValueStore: function() {
		return this.valueStore = new Ext.data.Store({
			model : this.store.model
		});
    },
    /**
	 * get all field values from value store and re-set combobox values
	 */
    setStoreValues: function() {
        try {
			var me = this, st = me.getValueStore();
			if(me.tempValue && (me.tempValue.length > me.getValueStore().getCount())){
				me.tempValue = me.getValueStore().data.items;
			}
			me.setValue(me.getValueStore().data.items);
//			me.setValue(st.data.extractValues(me.valueField || st.valueField, 'data'));
			
			me.syncSelection();
		} catch (e) {
			// TODO: handle exception
		}   
    },
    getValueModels: function () {
		return this.valueModels || [];
    },
    afterSetValue: function (){
        try {
			var me = this;
			me.valueStore.removeAll();
			me.valueStore.add(me.getValueModels());
			/*
			 * if (me.isExpanded) { me.alignPicker(); }
			 */
			me.syncSelection();
			me.updateLayout();
			me.alignPicker();
		} catch (e) {
			// TODO: handle exception
		}
	   
	},
	assertValue: Ext.emptyFn,
	setValue: function (value, action) {
		try {
			var me = this, st = me.store;
			if (Ext.isString(value)) {
				value = value.split(me.delimiter);
			};
			if(me.picker){
				var pSelectionMdl = me.picker.getSelectionModel();
				if (pSelectionMdl.view && pSelectionMdl.view.highlightedItem) {
					if (value.length == 0 && !Ext.get(pSelectionMdl.view.highlightedItem).hasCls('x-boundlist-selected') && me.tempValue.length > 0) {
						me.tempArr = me.tempValue;
						delete me.tempValue;
						me.tempValue = [];
						for (i = 0; i < me.tempArr.length; i++) {
							if (pSelectionMdl.view.highlightedItem.textContent != me.tempArr[i].data.displayValue) {
								me.tempValue.push(me.tempArr[i]);
							}
						}
					}
				}
			}
			/*if(value == ''){
			    if(me.allSelector != true) me.allSelector.removeCls('x-boundlist-selected');
			}else{
			    if(vals.length == me.store.getCount() && vals.length != 0){
			        if(me.allSelector != true) me.allSelector.addCls('x-boundlist-selected');
			        else me.afterExpandCheck = true;
			    }
			}*/
			if (me.tempValue) {
				var picker = me.getPicker(), oldPr = picker.preserveScrollOnRefresh;
				value = Ext.Array.unique(value.concat(me.tempValue));
//				var val = me.store.data.extractValues(me.valueField, 'data');
//				if (me.typeAhead && (me.store.getCount() == 1)) {
//					var v = me.store.getAt(0).get(me.valueField);
//					me.tempMulti != true ? value = [ v ] : value.push(v);
//					me._needCollapse = true;
//				}
//				me.store.data.addAll(Ext.Array.filter(me.valueStore.data.items,
//						function(i) {
//							return (Ext.Array.indexOf(val,
//									i.data[me.valueField]) < 0);
//						}));
				picker.preserveScrollOnRefresh = true;
				if (me.picker.refresh) {
					me.picker.refresh();
				}
				picker.preserveScrollOnRefresh = oldPr;
			}
			me.callParent([ value, false ]);
			me.value = value; // need to reset the value here: in case the
			// store is not yeat loaded and multiSelect ==
			// true, me.value is set to [] during the
			// callParent.
			if (st.getCount() > 0) {
				return me.afterSetValue();
			}
			if (!st.isLoading() && me._isStoreLoadCalled !== true
					&& me.autoloadStore) {
				st.load();
				me._isStoreLoadCalled = true;
			}
			st.on('load', me.afterSetValue, me, {
				single : true
			});
		} catch (e) {
			// TODO: handle exception
		}
	},
    getRawValue: function () {
    	if((this.view && this.view.inputEl != null && this.view.inputEl.getValue().match(/%/))){
    		this.view.inputEl.dom.value = '';
    	}
		return Ext.value(this.rawValue, '');
    },
    doRawQuery: function() {
     	try {
			var me = this, qe;
			delete me.tempValue;
			if (me.view && me.typeAhead && (qe = me.view.inputEl.getValue())) {
				me.tempValue = me.value;
				me.tempMulti = me.multiSelect;
				me.multiSelect = true;
				this.doQuery(qe, false, true);
				me.multiSelect = me.tempMulti;
				delete me.tempMulti;
				if (me._needCollapse) {
					me.collapse();
					delete me._needCollapse;
				} else {
					me.onExpand();
					me._preventClear = true;
					me.view.inputEl.focus();
					me.view.inputEl.dom.value = qe;
					me.view.inputEl.setWidth(me.view.inputWidth);
					delete me._preventClear;
				}
				//delete me.tempValue;
			}
		} catch (e) {
			// TODO: handle exception
		}
    },
    onBlur: function() {
    	try {
			var me = this;
			me.view.inputEl.dom.value = '';
			me.view.inputEl.setWidth(10);
			if (me.view.emptyEl) {
				me.view.emptyEl.show();
			}
			;
			if (me.picker && me.isExpanded && me._preventCollapse != true) {
				me.onTriggerClick();
			}
			;
		} catch (e) {
			// TODO: handle exception
		}
    }, 
    onFocus: function() {
    	try {
			var me = this, view = me.view;
			me.callParent(arguments);
			if(view.inputEl.el.getValue() != ""){
				view.inputEl.setWidth(view.inputWidth);	
			}
			if (me._preventClear != true) {
				me.store.clearFilter();
				if (me.picker && me.picker.refresh) {
					me.picker.refresh();
				}
			}
			if (view.emptyEl) {
				view.emptyEl.setVisibilityMode(Ext.dom.AbstractElement.DISPLAY);
				view.emptyEl.hide();
			}
			me.view.focus();
		} catch (e) {
			// TODO: handle exception
		}
    },
    
    buildKeyNav: function() {
    	 try {
			var me = this, selectOnTab = me.selectOnTab, picker = me
					.getPicker();
			return new Ext.view.BoundListKeyNav(
					picker.el,
					{
						boundList : picker,
						forceKeyDown : true,
						tab : function(e) {
							if (selectOnTab
									|| (me.typeAhead && (me.view.inputEl.dom.value || me.tempValue))) {
								this.selectHighlighted(e);
							}
							me.onTriggerClick();
							return true;
						},
						esc : function(e) {
							me.onTriggerClick();
						}
					});
		} catch (e) {
			// TODO: handle exception
		}
    },
  	onExpand: function() {
        try {
			var me = this, keyNav = me.listKeyNav, selectOnTab = me.selectOnTab,
			// node,
			picker = me.getPicker();
			if(me.isSetWidth){
				//picker.setWidth(picker.getWidth()+50);
				picker.setWidth(picker.getWidth());
				me.isSetWidth = false
			}
			// Handle BoundList navigation from the input field. Insert a tab
			// listener specially to enable selectOnTab.
			if (!keyNav) {
				keyNav = me.listKeyNav = me.buildKeyNav();
			}
			// While list is expanded, stop tab monitoring from
			// Ext.form.field.Trigger so it doesn't short-circuit selectOnTab
			if (selectOnTab) {
				me.ignoreMonitorTab = true;
			}
			if (me.addAllSelector == true && me.allSelector == true) {
				me.allSelector = picker
						.getEl()
						.down('.x-boundlist-list-ct')
						.insertHtml(
								'beforeBegin',
								'<div style="border-bottom: 1px solid grey;" class="x-boundlist-item" role="option"><span class="x-combo-checker" style="margin-left:5px;">&nbsp;</span> '
										+ me.allText + '</div>', true);
				me.allSelector.on('click', function(e) {
					if (me.allSelector.hasCls('x-boundlist-selected')) {
						me.allSelector.removeCls('x-boundlist-selected');
						me.setValue('');
					} else {
						var records = [];
						//V2D-470674 if not data available then selection of checkbox should not check
						if(!me.store.data.items.length){
							return false;
						}
						
						me.store.each(function(record) {
							records.push(record);
						});
						me.allSelector.addCls('x-boundlist-selected');
						me.select(records);
					}
				});
				if (me.allSelectorHidden == true) {
					me.allSelector.hide();
				} else {
					me.allSelector.show();
					// me.allSelector.addCls('x-boundlist-selected');
				}

				if (me.afterExpandCheck == true) {
					me.allSelector.addCls('x-boundlist-selected');
					me.afterExpandCheck = false;
				}
			}
			Ext.defer(keyNav.enable, 3, keyNav); // wait a bit so it doesn't
			// react to the down arrow
			// opening the picker
			me.highlightFirstNode();
		} catch (e) {
			// TODO: handle exception
		}
       
    },
    highlightFirstNode: function(select) {
    	try {
			var me = this, picker = me.getPicker();
			me._preventCollapse = true;
			picker.focus();
			delete me.preventCollapse;
			if (picker.getNode && (node = picker.getNode(0))) {
				picker.highlightItem(node);
			}
		} catch (e) {
			// TODO: handle exception
		}
    	
    },
    onCollapse: function() {
    	try {
			var me = this;
			me.callParent(arguments);
			me.view.focus();
		} catch (e) {
			// TODO: handle exception
		}
    },
    createRecord: function(rawValue) {
   		try {
			var me = this, rec = {}, val = rawValue.split(me.delimiter)
					.join('');
			rec[me.valueField] = rawValue;
			rec[me.displayField] = rawValue;
			return rec;
		} catch (e) {
			// TODO: handle exception
		}
    },
    afterComponentLayout : function() {
        try {
			var me = this;
			me.callParent(arguments);
			if (!me.view) {
				var selectBoxOnTab = me.selectBoxOnTab, del = function(e) {
					if (me.readOnly || me.disabled || !me.editable
							|| me.view.inputEl.dom.value) {
						return;
					}
					var selected = selModel.getSelection()[0];
					if (selected) {
						var idx = Ext.Array.indexOf(me.view, me.view
								.getNode(selected));
						selModel.onNavKey.call(selModel, 1);
						me.getValueStore().remove(selected);
						me.setStoreValues();
						selModel.select(idx);
						me.view.focus();
					}
					return true;
				};
				me.view = new Ext.ux.ComboView(Ext.apply({
					store : me.valueStore,
					emptyText : me.emptyText || '',
					field : me,
					renderTo : me.inputEl
				}, me.viewCfg));
				var selModel = me.view.selModel;
				var boxKeyNav = me.boxKeyNav = new Ext.view.BoundListKeyNav(
						me.view.el,
						{
							boundList : me.view,
							forceKeyDown : true,
							down : function(e) {
								if (me.isExpanded && me.view.inputEl.getValue()) {
									return me.picker.focus();
								}
								me.onTriggerClick();
							},
							right : function(e) {
								selModel.onNavKey.call(selModel, +1);
							},
							left : function(e) {
								selModel.onNavKey.call(selModel, -1);
							},
							enter : function(e) {
								if (me.readOnly || me.disabled || !me.editable) {
									return;
								}
								if (me.multiSelect
										&& me.createNewOnEnter == true
										&& e.getKey() == e.ENTER
										&& (rawValue = e.target.value)
										&& (!Ext.isEmpty(rawValue))) {
									var rec = me.store.findExact(me.valueField,
											rawValue);
									if (rec < 0) {
										rec = me.store.add(me
												.createRecord(rawValue));
									}
									me.getValueStore().add(rec);
									me.setStoreValues();
								}
								me.view.focus();
							},
							tab : function(e) {
								if (me.isExpanded && e.target.value) {
									me.highlightFirstNode();
									if (me.typeAhead) {
										me.listKeyNav.selectHighlighted(e);
									}
								}
								return true;
							},
							del : del,
							space : del
						});
				Ext.defer(boxKeyNav.enable, 1, boxKeyNav);
			}
		} catch (e) {
			// TODO: handle exception
		}
    },
    onDestroy: function() {
        try {
			var me = this;
			if (me.view) {
				Ext.destroy(me.view, me.boxKeyNav);
			}
			me.callParent(arguments);
		} catch (e) {
			// TODO: handle exception
		}
    },
    getSubmitData: function() {
        try {
			var this$ = this, data = {}, value, fieldName = this$.name, valueFieldName = this.valueField;
			if (!this$.disabled && this$.valueField) {
				value = this$.getValue();
				if (value !== null) {
					if (this$.overridetSubmitData) {
						var valueArray = new Array();
						Ext.each(value, function(obj) {
							if (obj !== undefined && obj != null && obj != "") {
								if (typeof obj.get == "undefined") {
									valueArray.push(obj);
								} else {
									valueArray.push(obj.get(valueFieldName));
								}
							}
						});
						if (valueArray.length > 0)
							data[fieldName] = valueArray;

					} else {
						data[fieldName] = value;
					}
				}
			}
			return data;
		} catch (e) {
			// TODO: handle exception
		}
	},
	onListSelectionChange: function(list, selectedRecords,e){
		try {
			var me = this, isMulti = me.multiSelect, hasRecords = selectedRecords.length > 0;
			
			setTimeout(function(){
				try{
					var selectCount = list.view.selModel.selected.getCount();
					if(selectCount==0){
						me.onTrigger1Click(true);
					}
				}
				catch(e){
					console.log('');
				}
			},500);
			
			// Only react to selection if it is not called from setValue, and if our list is
			// expanded (ignores changes to the selection model triggered elsewhere)
			if (!me.ignoreSelection && me.isExpanded) {
				if (!isMulti) {
					Ext.defer(me.collapse, 1, me);
				}
				/*
				 * Only set the value here if we're in multi selection mode or we have
				 * a selection. Otherwise setValue will be called with an empty value
				 * which will cause the change event to fire twice.
				 */
				if (isMulti || hasRecords) {
					me.setValue(selectedRecords, false);
				}
				if (hasRecords) {
					me.fireEvent('select', me, selectedRecords);
				}
				me.inputEl.focus();
			}
			if (me.addAllSelector == true && me.allSelector != false) {
				if (me.getValueStore().data.items.length == me.store
						.getTotalCount()) {
					me.allSelector.addCls('x-boundlist-selected');
				} else {
					me.allSelector.removeCls('x-boundlist-selected');
				}
			}
		} catch (e) {
			// TODO: handle exception
		} 
	},
	onKeyup: function(){		
		try {			
			var me = this, view = me.view;			
			view.inputEl.setWidth(view.inputWidth);	
		} catch (e) {
			// TODO: handle exception
		}
	}
});
