/**
 * @author
 * Manas
 * @description
 * Controller for Register For Assessment Group Filter & Grid
 */
Ext.define('Academia.controller.AssessmentGroupRegistration.AssessmentGroupRegistrationController', {
	extend: 'Academia.controller.base.BaseController',
	models: [
		'examinationcenters.marksheet.AssessmentGroupMarksheetModel',
		'examinationcenters.evaluationgroup.EvaluationGroupCourseModel'
	],

	views: [
		'examexecution.ExamRegisterGroupStructure',
		'examinationcenters.evaluationgrouplisting.ResgisterForGroupFilter',
		'examexecution.StudentRegisterForEvalGroupGrid',
		'examexecution.RegGroupApplyWindow', 'examexecution.ApplyForAssessmentGroupStructure',
		'examexecution.RegAssessmentGroupCoreFilter',
		'examexecution.RegAssessmentGroupCoreGrid', 'examexecution.RegAssessmentGroupCoreStructure',
		'examinationcenters.evaluationgrouplisting.RegGroupApplyNowStructureSPPortal',
		'examinationcenters.evaluationgrouplisting.applicationdetail.RegGroupApplicationDetailForm',
		'examinationcenters.evaluationgrouplisting.documentsubmit.RegGroupDocumentGridStucture',
		'examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentGrid',
		'baselayout.contentarea.ContentPanel', 'examexecution.RegGroupApplyEventGrid',
		'feeandpayment.receipts.RegGroupMakePaymentWin',
		'common.IdGeneratorCustomForm', 'admission.manageForm.ManageFormList',
		'examexecution.EvaluationGroupCourseGrid','examinationcenters.generatehallticket.GenerateHallticketWin'
		// 	'admission.admissionCommon.MakePaymentForm'
	],

	stores: [
		'RegEGStores.RegEGProgramStore',
		'RegEGStores.RegEGBatchStore',
		'RegEGStores.RegEGPeriodStore',
		'RegEGStores.RegEGCourseStore',
		'RegEGStores.RegEGApplicationStore', 'RegEGStores.EvaluationGroupStore',
		'RegEGStores.EvaluationGroupProgramStore',
		'RegEGStores.EvaluationGroupBatchStore',
		'RegEGStores.EvaluationGroupApplicationStatusStore',
		'RegEGStores.EvaluationGroupStatusStore',
		'common.AcademicTermStore',
		'RegEGStores.RegAssessmentGroupCoreStore',
		'examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentStore',
		'RegEGStores.ApplyCoursesGridStore',
		'feeandpayment.managebill.BillType', 'feeandpayment.managebill.BillFor',
		'feeandpayment.BillCurrencyStore',
		'feeandpayment.receipts.Bank',
		'feeandpayment.receipts.FeeLedgerName',
		'feeandpayment.ALUnit',
		'feeandpayment.FeePaymentMode',
		'feeandpayment.BillCurrencyStore',
		'feeandpayment.receipts.DrawnOnBank',
		'feeandpayment.receipts.CostCentreReceipt', 'admission.admissionCommon.PaymentModeStore',
		'feeandpayment.receipts.DrawnOnBank', 'feeandpayment.receipts.CostCentreReceipt',
		'admission.manageForm.FeeAdmissionList','RegEGStores.EvaluationGroupCourseGridStore'

	],

	refs: [{
		ref: 'resgisterforgroupfilter',
		selector: 'resgisterforgroupfilter'
	}, {
		ref: 'studentregisterforevalgroupgrid',
		selector: 'studentregisterforevalgroupgrid'
	}, {
		ref: 'regGroupApplyWindow',
		selector: 'regGroupApplyWindow'
	}, {
		ref: 'applyforassessmentgroupstructure',
		selector: 'applyforassessmentgroupstructure'
	}, {
		ref: 'documentsubmittedwindow',
		selector: 'documentsubmittedwindow'
	}, {
		ref: 'applyassessmentgrid',
		selector: 'applyassessmentgrid'
	}, {
		ref: 'documentsubmittedgrid',
		selector: 'documentsubmittedgrid'
	}, {
		ref: 'regassessmentgroupcorestructure',
		selector: 'regassessmentgroupcorestructure'
	},
	{
		ref: 'reggroupapplynowstructurespportal',
		selector: 'reggroupapplynowstructurespportal'
	}, {
		ref: 'regassessmentgroupcorefilter',
		selector: 'regassessmentgroupcorefilter'
	}, {
		ref: 'regassessmentgroupcoregrid',
		selector: 'regassessmentgroupcoregrid'
	}, {
		ref: 'contentpanel',
		selector: 'contentpanel'
	}, {
		ref: 'reggroupmakepaymentwin',
		selector: 'reggroupmakepaymentwin'
	}, {
		ref: 'idgeneratorcustomform',
		selector: 'idgeneratorcustomform'
	}, {
		ref: 'manageformlist',
		selector: 'manageformlist'
    }, {
		ref: 'downloadformwin',
		selector: 'downloadformwin'
	}, {
		ref: 'evaluationgroupcoursegrid',
		selector: 'evaluationgroupcoursegrid'
	}, {
		ref: 'generatehallticketwin',
		selector: 'generatehallticketwin'
	}],

	config: {
		ASSESSMENTGROUP_CORE_REGISTRATION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSESSMENTGROUP_CORE_REGISTRATION_PRIVILEGES')
	},

	init: function() {
		this.control({
			
			'evaluationgroupcoursegrid': {
				afterrender: {}
			},
			'reggroupapplyeventgrid': {
				afterrender: function (grid) {
			        
			    },
				selectionchange: function (selModel, selectedRecords) {
				    var grid = selModel.view.panel;
				    var win = null;
				    var btn = null;
					if (grid) {
				        win = grid.up('reggroupapplywindow');
				    }
					if (win) {
				        btn = win.down('button[itemId=submitBtn]');
				    }
					if (btn) {
				        btn.setDisabled(selectedRecords.length === 0);
				    }
				}

			},
			'regassessmentgroupcoregrid #approveItemId' :{
				click: this.onApplyNowBtnClick
			},

			'regassessmentgroupcoregrid #btnEdit': {
				click: this.onGridEditBtnClick
			},

			'regassessmentgroupcoregrid #withdrawnItemId': {
				click: this.onWithdrawBtnClick
			},
			
			'resgisterforgroupfilter': {
				afterrender: this.onFilterRender
			}, 'regassessmentgroupcoregrid': {
				afterrender: this.onCoreGridRender
			},
			'regassessmentgroupcorestructure': {
				afterrender: this.onRegStructRender
			},
			'resgisterforgroupfilter #resetBtn': {
				click: this.onResetClick
			},
			'resgisterforgroupfilter #programItemId': {
				select: this.onProgramSelect
			},
			'resgisterforgroupfilter #batchIdItemId': {
				select: this.onBatchSelect
			},
			'resgisterforgroupfilter #periodId': {
				select: this.onPeriodSelect
			},
			'resgisterforgroupfilter #evaluationGroupId': {
				select: this.onGroupSelect
			},

			'manageformlist': {
				afterrender: this.onGridsRender
			},

			'applyassessmentwindow': {
				render: this.onApplyAssessmentActivate
			}
			, 'documentsubmittedwindow': {
				render: this.onDocWindow
			}
			,
			'resgisterforgroupfilter #searchBtn': {
				click: this.onSearchClick
			},

			'reggroupapplywindow button[itemId=submitBtn]': {
				click: this.onNextSaveClick
			},

			'regassessmentgroupcoregrid': {
				selectionchange: this.onCoreGridSelectionChange
			},
			
			'regassessmentgroupcoregrid': {
			    cellclick: function (grid, td, cellIndex, record) {

			      var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

			        if (columnName === 'totalCourse') {
			            this.openRegAssessmentGroupCoreGridWindow(record);
			        }
			    }
			},
			'regassessmentgroupcoregrid menuitem[itemId=hallTicketGenerationItemId]': {
			    click: function () {
			        this.generateHallTicket();
			    }
			},
			'regassessmentgroupcoregrid menuitem[itemId=printHallTicketItemId]': {
			    click: function (obj) {
			        this.changeApplicationStatus(obj.text);
			    }
			},
			'regassessmentgroupcoregrid menuitem[itemId=downloadApplicationItemId]': {
			    click: function (obj) {
			        this.changeApplicationStatus(obj.text);
			    }
			},
			'regassessmentgroupcoregrid menuitem[itemId=notifyItemId]': {
				click: function(obj) {
					this.changeApplicationStatus(obj.text);
				}
			},
			'regassessmentgroupcoregrid button[itemId=collectPaymentBtnId]': {
				click: function() {

					var win = this.getReggroupmakepaymentwin();

					if (!win) {
						win = Ext.widget('reggroupmakepaymentwin');
					}
					win.show();

				}
			},

			'studentregisterforevalgroupgrid button[itemId=btnApplyItemId]': {
				click: function() {
					var me = this;
					var grid = me.getStudentregisterforevalgroupgrid();
					me.applyNowForRegGroupForStudent(me, grid);
				}
			},

			'reggroupmakepaymentwin button[itemId=SubmitAndPrintMakePaymentBtn]': {
				click: function(button) {
					var print = true;
					this.createBillForManageForm(button, print);
				}
			},
			'manageformlist button[itemId=submitForm]': {
				click: this.getSubmitApplicationForm
			},
			'reggroupmakepaymentwin  button[itemId=collectPaymentResetBtn]': {
				click: function(button) {
					this.createBillForManageFormReset(button);
				}
			},

			'reggroupmakepaymentwin button[itemId=SubmitBtn]': {
				click: function(button) {
					var print = false;
					this.createBillForManageForm(button, print);
				}
			},


			'studentregisterforevalgroupgrid button[itemId=btnMakePayment]': {
				click: function(obj) {
					var $this = this;
					var grid = $this.getStudentregisterforevalgroupgrid();
					var groupform = $this.getResgisterforgroupfilter();
					var tempStore = grid.getStore();
					//if(grid.getSelectionModel().getCount()>0){
					if (tempStore.data.items.length > 0) {
						var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
						var record = tempStore.data.items;//grid.getSelectionModel().getSelection();
						var innerJsonArr = [], json;
						var totalAmmount = 0;
						var models = grid.getStore().getRange();
						var totalRevalApplied = 0;
						for (var i in record) {
							var feeAmount = record[i].data.feeAmount;
							var newFeeAmount = 100;
							if (!isNullOrEmpty(newFeeAmount)) {
								newFeeAmount = parseFloat(newFeeAmount.replace(/[^\d.]/g, ''));
								totalAmmount = totalAmmount + newFeeAmount;
								innerJsonArr.push({
									"admissionId": record[i].data.admissionId,
									"studentId": studentPortalInfo.student.id,
									"amount": newFeeAmount,
									"feePlanId": record[i].data.feePlanId,
									"feeHeadName": record[i].data.feeHeadName,
									"courseName": record[i].data.courseName,
									"evaluationGroupId": evalGroupValue,
									"periodId": record[i].data.periodId,
									"evaluationGroupCode": record[i].data.evaluationGroupCode
								});
								var lateFeeAmount = record[i].data.lateFeeAmount;
								var totalAmounts = record[i].data.totalAmount;
								if (!isNullOrEmpty(lateFeeAmount)) {
									totalAmmount = totalAmmount + parseInt(lateFeeAmount);
									innerJsonArr.push({
										"admissionId": record[i].data.admissionId,
										"studentId": studentPortalInfo.student.id,
										"amount": lateFeeAmount,
										"feePlanId": record[i].data.feePlanId,
										"feeHeadName": record[i].data.feeHeadName,
										"courseName": record[i].data.courseName,
										"evaluationGroupId": evalGroupValue,
										"periodId": record[i].data.periodId,
										"evaluationGroupCode": "Late Fee Applicable"
									});
								}
								json = {
									'firstName': studentPortalInfo.student.firstName,
									'lastName': studentPortalInfo.student.lastName,
									'phoneNo': studentPortalInfo.student.person.mobileCountryCode + " " + studentPortalInfo.student.person.mobileNumber,
									'email': studentPortalInfo.student.person.emailId,
									'studentCode': studentPortalInfo.student.code,
									'studentName': studentPortalInfo.student.printName,
									'program': studentPortalInfo.programBatchDetails.programName,
									'batch': studentPortalInfo.programBatchDetails.batchName,
									"totalAmount": totalAmmount,
									"currencyCode": record[i].data.currencyCode,
									"examRevalPaymentDetail": innerJsonArr
								};
							} else {
								showWarningMessage(getCommonTranslation('ALERT'),
									'Fee is not applicable for this assessment group');
								return false;
							}
						}
						var buildInfo = "";
						var revalPaymentUrl = "";
						if (!isNullOrEmpty(json)) {
							var XMLHttpRequestObject = false;
							if (window.XMLHttpRequest) {
								XMLHttpRequestObject = new XMLHttpRequest();
								XMLHttpRequestObject.overrideMimeType("text/xml");
							}
							else if (window.ActiveXObject) {
								XMLHttpRequestObject = new
									ActiveXObject("Microsoft.XMLHTTP");
							}
							XMLHttpRequestObject.withCredentials = false;
							XMLHttpRequestObject.onreadystatechange = function() {
								if (this.readyState == 4 && this.status == 200) {
									var id = parseInt(XMLHttpRequestObject.responseText);
									if (!isNaN(id)) {
										var formWindow = $this.getExmevelgrouppaymentsummarywin();
										if (!formWindow) {
											Ext.widget('exmevelgrouppaymentsummarywin');
											formWindow = $this.getExmevelgrouppaymentsummarywin();
										}
										formWindow.show();
										var summaryGrid = formWindow.down('grid');
										summaryGrid.getStore().loadRawData([]);
										summaryGrid.getStore().loadRawData(innerJsonArr);
										var summaryWindMsg = formWindow.down('#summaryWindMsg');
										summaryWindMsg.setVisible(true);
										summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : ' + totalAmmount + " /-</b>");
										Ext.apply(formWindow, {
											data: null,
											setData: function(data) {
												formWindow.data = data;
											},
											getData: function() {
												return formWindow.data;
											}
										});
										formWindow.setData(id);
									} else {
										showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('Payment_PayU_Confirmation'));
									}
								}
								else if (this.readyState == 4 && this.status != 200) {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('Payment_PayU_Confirmation'));
								}
							};
							XMLHttpRequestObject.open("POST", grid.getPaymentAGPostUrl(), true);
							XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
							XMLHttpRequestObject.send("" + Ext.encode(json));
							grid.down('#btnMakePayment').disable();
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},

			'studentregisterforevalgroupgrid': {
				selectionchange: function(selModel, records) {

					var grid = this.getStudentregisterforevalgroupgrid();
					var btnMakePayment = grid.down('#btnMakePayment');
					var btnApply = grid.down('#btnApplyItemId');

					btnMakePayment.disable();
					btnApply.disable();

					if (!records || records.length !== 1) {
						return;
					}

					var rec = records[0];
					var status = rec.get('applicationStatus');
					var feePlanId = rec.get('feePlanId');

					if (
						feePlanId != null &&
						(status === 'Applied' || status === 'Partially Applied')
					) {
						btnMakePayment.enable();
					}

					if (feePlanId == null) {
						if (status === 'Pending' || status === 'Partially Submitted') {
							btnApply.enable();
						}
					} else {
						if (status === 'Pending' || status === 'Partially Applied') {
							btnApply.enable();
						}
					}
				}
			},

			'regassessmentgroupcorefilter': {
				afterrender: function(form) {
					var $this = this;
					var currentAcademyArray = [];
					var academyLocationIds = this.getCurrentAcademyLocation();

					// --------------------------------------
					// REGULAR PORTAL LOGIC (Portal ID = 1)
					// --------------------------------------
					var academicTermId = form.down("#academicTermId");
					var evaluationGroupId = form.down("#assessmentGroupId");
					var programItemId = form.down("#programItemId");
					var batchIdItemId = form.down("#batchIdItemId");
					var groupStatus = form.down("#evaluationGroupStatus");

					// Disable dependent combos initially
					groupStatus.setDisabled(true);
					programItemId.setDisabled(true);
					batchIdItemId.setDisabled(true);

					// --------------------------------------
					// Load Academic Term and Default Cascade
					// --------------------------------------
					academicTermId.getStore().getProxy().extraParams = { academyLocationIds: academyLocationIds };
					academicTermId.getStore().load({
						callback: function(records) {
							Ext.Array.each(records, function(val) {
								if (val.get('sequence') == 1) {
									currentAcademyArray.push(val);
								}
							});

							if (currentAcademyArray.length === 1) {
								academicTermId.setValue(currentAcademyArray[0].data.id);

								// Load Evaluation Group based on term
								evaluationGroupId.getStore().getProxy().extraParams = {
									academyLocationId: academyLocationIds,
									academicTermId: currentAcademyArray[0].data.id
								};

								evaluationGroupId.getStore().load({
									scope: $this,
									callback: function(rec) {
										if (rec.length === 1) {
											evaluationGroupId.setValue(rec[0].data.id);
											programItemId.reset().setDisabled(false);

											var evaluationGroupIdValue = rec[0].data.id;
											programItemId.getStore().getProxy().extraParams = {
												academyLocationId: academyLocationIds,
												evaluationGroupId: evaluationGroupIdValue,
												academicTermId: currentAcademyArray[0].data.id
											};

											// Load Program Store
											programItemId.getStore().load({
												scope: $this,
												callback: function(record) {
													batchIdItemId.setDisabled(false);

													if (record.length === 1) {
														programItemId.setValue(record[0].data.id);
														batchIdItemId.reset();

														// Load Batch Store
														batchIdItemId.getStore().getProxy().extraParams = {
															programId: record[0].data.id,
															academyLocationId: $this.getCurrentAcademyLocation(),
															evaluationGroupId: evaluationGroupIdValue
														};

														batchIdItemId.getStore().load({
															callback: function(record, operation, success) {
																if (success && record.length === 1) {
																	batchIdItemId.setValue(record[0].data.id);
																}
															}
														});
													}
												}
											});
										}
									}
								});
							}
						}
					});

					// --------------------------------------
					// Load Group Status Default
					// --------------------------------------
					groupStatus.getStore().load({
						callback: function() {
							groupStatus.setValue('NOT_APPLIED');
						}
					});
				}
			},
			// SELECT event for academicTermId
			'regassessmentgroupcorefilter customcombobox[itemId=academicTermId]': {
				select: function(obj, record) {
					var $this = this;
					var academyLocationIds = $this.getCurrentAcademyLocation();
					var getFilterForm = this.getRegassessmentgroupcorefilter();
					var formValues = getFilterForm.getValues();

					var evaluationGroupId = getFilterForm.down("#assessmentGroupId");
					var programItemId = getFilterForm.down("#programItemId");
					var batchIdItemId = getFilterForm.down("#batchIdItemId");
					var groupStatus = getFilterForm.down("#evaluationGroupStatus");
					var appStatus = getFilterForm.down("#appStatus");

					evaluationGroupId.enable();
					// --------------------------------------
					// REGULAR PORTAL LOGIC (Portal ID = 1)
					// --------------------------------------
					programItemId.setDisabled(true);
					programItemId.reset();
					batchIdItemId.setDisabled(true);
					batchIdItemId.reset();
					groupStatus.setDisabled(true).reset();
					appStatus.setDisabled(true).reset();
					//   groupStatus.enable();

					evaluationGroupId.reset();
					evaluationGroupId.getStore().getProxy().extraParams = {
						academyLocationId: $this.getCurrentAcademyLocation(),
						academicTermId: record[0].data.id
					};

					evaluationGroupId.getStore().load({
						scope: $this,
						callback: function(rec) {
							var getFilterForm = this.getRegassessmentgroupcorefilter();
							var programItemId = getFilterForm.down("#programItemId");
							var batchIdItemId = getFilterForm.down("#batchIdItemId");
							var groupStatus = getFilterForm.down("#evaluationGroupStatus");
							var appStatus = getFilterForm.down("#appStatus");

							if (rec.length === 1) {
								evaluationGroupId.setValue(rec[0].data.id);

								programItemId.getStore().getProxy().extraParams = {
									academyLocationId: $this.getCurrentAcademyLocation(),
									evaluationGroupId: rec[0].data.id,
									academicTermId: record[0].data.id
								};
								programItemId.setDisabled(false).reset();
								batchIdItemId.setDisabled(false).reset();
								groupStatus.setDisabled(false).reset();
								appStatus.setDisabled(false).reset();

								programItemId.getStore().load({
									scope: $this,
									callback: function(recProg) {
										//   batchIdItemId.setDisabled(false);
										if (recProg.length === 1) {
											programItemId.setValue(recProg[0].data.id);
											batchIdItemId.reset();

											batchIdItemId.getStore().getProxy().extraParams = {
												programId: recProg[0].data.id,
												academyLocationId: this.getCurrentAcademyLocation(),
												evaluationGroupId: rec[0].data.id
											};

											batchIdItemId.getStore().load({
												callback: function(recBatch, operation, success) {
													if (success && recBatch.length === 1) {
														batchIdItemId.setValue(recBatch[0].data.id);
													}
												}
											});
										}
									}
								});
							} else {
								programItemId.setDisabled(true);
								batchIdItemId.setDisabled(true);
							}
						}
					});
				}
			},

			// SELECT event for evaluationGroupId
			'regassessmentgroupcorefilter customcombobox[itemId=assessmentGroupId]': {
				select: function(obj, rec) {
					var $this = this;
					var filterForm = this.getRegassessmentgroupcorefilter();
					var formValues = filterForm.getValues();
					var evaluationGroupId = rec[0].data.id;
					var groupStatus = filterForm.down("#evaluationGroupStatus");

					var applicationStatus = filterForm.down("#appStatus");
					applicationStatus.enable().reset();
					groupStatus.enable().reset();
					// --------------------------------------
					// REGULAR PORTAL LOGIC (Simplified, Period removed)
					// --------------------------------------
					var programCombo = filterForm.down("#programItemId");
					var batchCombo = filterForm.down("#batchIdItemId");
					programCombo.enable();
					batchCombo.setDisabled(true).reset();
					//	batchCombo.enable();
					// Prepare and load Program store
					var programStore = programCombo.getStore();
					programCombo.setDisabled(false).reset();
					programStore.getProxy().extraParams = {
						academyLocationId: $this.getCurrentAcademyLocation(),
						evaluationGroupId: evaluationGroupId,
						academicTermId: formValues.academicTerm
					};

					programStore.load({
						scope: $this,
						callback: function(records) {
							//    batchCombo.setDisabled(false).reset();

							if (records.length === 1) {
								programCombo.setValue(records[0].data.id);
								batchCombo.setDisabled(false).reset();
								// Prepare and load Batch store
								var batchStore = batchCombo.getStore();
								batchCombo.reset();
								batchStore.getProxy().extraParams = {
									programId: records[0].data.id,
									academyLocationId: $this.getCurrentAcademyLocation(),
									evaluationGroupId: evaluationGroupId
								};

								batchStore.load({
									callback: function(recBatch, operation, success) {
										if (success && recBatch.length === 1) {
											batchCombo.setValue(recBatch[0].data.id);
										}
									}
								});
							}
						}
					});
				}
			},

			// SELECT event for programItemId
			'regassessmentgroupcorefilter customcombobox[itemId=programItemId]': {
				select: function(obj, rec) {
					var programId = rec[0].data.id;
					var form = obj.up('form').getForm();
					var batch = form.findField('batchId');
					var evaluationGroupId = form.findField('assessmentGroupId');
					var filterForm = this.getRegassessmentgroupcorefilter();
					var groupStatus = filterForm.down("#evaluationGroupStatus");
					var applicationStatus = filterForm.down("#appStatus");
					applicationStatus.enable().reset();
					groupStatus.enable().reset();
					// --------------------------------------
					// REGULAR PORTAL LOGIC (Simplified, Period Removed)
					// --------------------------------------
					batch.enable().reset();
					batch.getStore().getProxy().extraParams = {
						programId: programId,
						academyLocationId: this.getCurrentAcademyLocation(),
						evaluationGroupId: evaluationGroupId.getValue()
					};

					batch.getStore().load({
						callback: function(record, operation, success) {
							if (success && record.length === 1) {
								batch.setValue(record[0].data.id);
							}
						}
					});
				}
			},

			// SELECT event for batchIdItemId
			'regassessmentgroupcorefilter customcombobox[itemId=batchIdItemId]': {
				select: function(obj, rec) {
					var $this = this;

					if (this.getCurrentLoggedPortalId() != 3) {
						// --------------------------------------
						// REGULAR PORTAL LOGIC (Simplified, Period Removed)
						// --------------------------------------
						var form = $this.getRegassessmentgroupcorefilter();
						var appStatus = form.down("#appStatus");
						var groupStatus = form.down("#evaluationGroupStatus");
						appStatus.enable().reset();
						groupStatus.enable().reset();
					}
				}
			},

			'regassessmentgroupcorefilter customcombobox[itemId=appStatus]': {
				select: function(obj, rec) {
					var $this = this;

					if (this.getCurrentLoggedPortalId() != 3) {
						// --------------------------------------
						// REGULAR PORTAL LOGIC (Simplified, Period Removed)
						// --------------------------------------
						var form = $this.getRegassessmentgroupcorefilter();
						var groupStatus = form.down("#evaluationGroupStatus");
						groupStatus.enable().reset();
					}
				}
			},

			// SELECT event for periodId
			/*	'regassessmentgroupcorefilter customcombobox[itemId=periodId]': {
					select: function(obj, rec) {
						var $this = this;
						var filterForm = this.getRegassessmentgroupcorefilter();
	
						var academicTerm = filterForm.down('#academicTermId');
						var evaluationGroupId = filterForm.down('#evaluationGroupId');
						var studentProgramId = filterForm.down("#studentProgramId");
						var studentBatchId = filterForm.down("#studentBatchId");
						var appStatus = filterForm.down("#appStatus");
						var periodId = rec[0].data.id;
	
						// --------------------------------------
						// STUDENT PORTAL LOGIC ONLY
						// --------------------------------------
						if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
							var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							appStatus.enable();
	
							// Determine Student ID
							var studentId = (this.getCurrentLoggedPortalId() == 7)
								? studentPortalInfo.student.id
								: $this.getCurrentlyLoggedInUser().id;
	
							// Load Evaluation Group store with relevant params
							var evalGroupStore = evaluationGroupId.getStore();
							evalGroupStore.getProxy().extraParams = {
								academicTermId: academicTerm.getValue(),
								studentId: studentId,
								programId: studentProgramId.getValue(),
								batchId: studentBatchId.getValue(),
								periodId: periodId
							};
							evalGroupStore.load();
						}
					}
				},
	
				// SELECT event for studentProgramId 
				'regassessmentgroupcorefilter customcombobox[itemId=studentProgramId]': {
					select: function(obj, record) {
						var $this = this;
						// Use the renamed getter
						var form = this.getRegassessmentgroupcorefilter();
						var programId = form.down("#studentProgramId");
						var batchId = form.down("#studentBatchId");
						var term = form.down("#academicTermId");
						var evaluationGroup = form.down("#evaluationGroupId");
						var appStatus = form.down("#appStatus");
	
						evaluationGroup.reset();
						term.reset();
						appStatus.reset();
	
						var batchStore = batchId.getStore();
						var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	
						if (this.getCurrentLoggedPortalId() == 7) { studentId = studentPortalInfo.student.id; } else { studentId = this.getCurrentlyLoggedInUser().id; }
	
						batchId.setDisabled(false);
						batchId.setReadOnly(false);
						batchStore.getProxy().extraParams = { programId: programId.getValue(), studentId: studentId, };
						batchStore.load();
	
						var termStore = term.getStore();
						termStore.getProxy().extraParams = { programId: programId.getValue(), batchId: batchId.getValue(), };
						termStore.load();
	
						var evaluationGroupStore = evaluationGroup.getStore();
						evaluationGroupStore.getProxy().extraParams = { programId: programId.getValue(), batchId: batchId.getValue(), studentId: studentId, academicTermId: term.getValue() }
						evaluationGroupStore.load();
					}
				},
	
				// SELECT event for studentBatchId
				'regassessmentgroupcorefilter customcombobox[itemId=studentBatchId]': {
					select: function(obj, rec) {
						var batchId = rec[0].data.id;
						var form = obj.up('form').getForm();
						var evaluationGroupField = form.findField('evaluationGroupId');
						var appStatusField = form.findField('appStatus');
						var programField = form.findField('program');
	
						evaluationGroupField.enable();
						evaluationGroupField.getStore().getProxy().extraParams = { programId: programField.getValue(), batchId: batchId };
						evaluationGroupField.getStore().load();
						appStatusField.enable();
					}
				}, */

			// CLICK event for searchBtn
			'regassessmentgroupcorefilter button[itemId=searchBtn]': {
				click: function(obj) {
					var $this = this;
					var filterForm = obj.up('form');
					var form = filterForm.getForm();
					var masterGrid = this.getRegassessmentgroupcoregrid();
					var formValues = form.getValues();

					// --------------------------------------
					// Remove any periodId reference if exists
					// --------------------------------------
					if (formValues.periodId) {
						delete formValues.periodId;
					}

					// --------------------------------------
					// Set extra params for main grid store
					// --------------------------------------
					var store = masterGrid.getStore();



					//  store.getProxy().extraParams = formValues;
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation(),
						groupId: formValues.assessmentGroupId,
						programId: formValues.program,
						batchId: formValues.batchId,
						applicationStatus: formValues.appStatus,
						groupStatus: formValues.groupStatus,
						academicTermId: formValues.academicTerm,
						//	periodId: periodId,
						//	isHallTicketGenerated: formValues.hallticketgenerated,
						//	isHallTicketPublished: formValues.hallticketpublished,
						sort: null
					};

					// --------------------------------------
					// Load main grid store
					// --------------------------------------
					store.load({
						callback: function(records, operation, success) {
							masterGrid.config.searchFilterForm = filterForm;
							$this.resetPageSetting(store, masterGrid);
							//	store.load();
							store.pageSize = 100;

							if (records.length > 0) {
								// --------------------------------------
								// Enable buttons when records found
								// --------------------------------------
								//  masterGrid.down('#btnMakePayment').setDisabled(false);
								//  masterGrid.down('#btnDownloadForm').setDisabled(false);
								//   masterGrid.down('#btnExportToPDF').setDisabled(false);
								//  masterGrid.down('#btnExportToExcel').setDisabled(false);
								masterGrid.down('#spBtnMoreActions').setDisabled(false);

								// Regular Portal Privilege Handling (disabled for now)
								// $this.disableMoreActionPivileges(masterGrid, $this.getAPPLY_FOR_EVALUATION_GROUP_PERMISSION());

							} else {
								// --------------------------------------
								// Disable buttons when no records
								// --------------------------------------
								//    masterGrid.down('#btnMakePayment').setDisabled(true);
								//    masterGrid.down('#btnDownloadForm').setDisabled(true);
								//    masterGrid.down('#btnExportToPDF').setDisabled(true);
								//    masterGrid.down('#btnExportToExcel').setDisabled(true);
								masterGrid.down('#spBtnMoreActions').setDisabled(true);
							}
						}
					});
				}
			},

			// CLICK event for resetBtn
			'regassessmentgroupcorefilter button[itemId=resetBtn]': {
				click: function(obj) {
					var $this = this;
					var filterForm = obj.up('form').getForm();
					var getForm = this.getRegassessmentgroupcorefilter();

					var evaluationGroup = filterForm.findField("assessmentGroupId");
					var academicTermId = filterForm.findField("academicTerm");
					var program = filterForm.findField("program");


					// --------------------------------------
					// RESET BASIC FORM FIELDS
					// --------------------------------------
					program.reset();
					program.setDisabled(true);
					evaluationGroup.reset();

					// --------------------------------------
					// CLEAR GRID AND DISABLE BUTTONS
					// --------------------------------------
					/*   var masterGrid = this.getEvalgrouplistingmastergrid();
					   masterGrid.getStore().removeAll();

					   var buttonsToolBar = masterGrid.query('toolbar')[0];
					   buttonsToolBar.query('#btnMakePayment')[0].setDisabled(true);
					   masterGrid.down('#btnDownloadForm').setDisabled(true);
					   masterGrid.down('#btnExportToPDF').setDisabled(true);
					   masterGrid.down('#btnExportToExcel').setDisabled(true);
					   masterGrid.down('#btnMoreActions').setDisabled(true);
*/
					// --------------------------------------
					// RESETTING LOGIC FOR REGULAR PORTAL (Portal ID = 1)
					// --------------------------------------
					var batchId = filterForm.findField("batchId");
					var groupStatus = filterForm.findField("groupStatus");
					var appStatus = filterForm.findField("appStatus");
					filterForm.reset();
					batchId.setDisabled(true);
					appStatus.reset();
					appStatus.setDisabled(true);
					groupStatus.reset();
					groupStatus.setDisabled(true);


					// --------------------------------------
					// LOAD DEFAULT DATA AFTER RESET
					// --------------------------------------
					var currentAcademyArray = [];
					var academyLocationIds = $this.getCurrentAcademyLocation();

					academicTermId.getStore().getProxy().extraParams = { academyLocationIds: academyLocationIds };
					academicTermId.getStore().load({
						callback: function(records) {
							Ext.Array.each(records, function(val) {
								if (val.get('sequence') == 1) {
									currentAcademyArray.push(val);
								}
							});

							if (currentAcademyArray.length === 1) {
								academicTermId.setValue(currentAcademyArray[0].data.id);

								evaluationGroup.getStore().getProxy().extraParams = {
									academyLocationId: academyLocationIds,
									academicTermId: currentAcademyArray[0].data.id
								};

								evaluationGroup.getStore().load({
									scope: $this,
									callback: function(rec) {
										if (rec.length === 1) {
											evaluationGroup.setValue(rec[0].data.id);
											program.reset().setDisabled(false);

											var evaluationGroupIdValue = rec[0].data.id;
											program.getStore().getProxy().extraParams = {
												academyLocationId: academyLocationIds,
												evaluationGroupId: evaluationGroupIdValue,
												academicTermId: currentAcademyArray[0].data.id
											};

											program.getStore().load({
												scope: $this,
												callback: function(record) {
													batchId.setDisabled(false);
													if (record.length === 1) {
														program.setValue(record[0].data.id);
														batchId.reset();

														batchId.getStore().getProxy().extraParams = {
															programId: record[0].data.id,
															academyLocationId: $this.getCurrentAcademyLocation(),
															evaluationGroupId: evaluationGroupIdValue
														};

														batchId.getStore().load({
															callback: function(record, operation, success) {
																if (success && record.length === 1) {
																	batchId.setValue(record[0].data.id);
																}
															}
														});
													}
												}
											});
										}
									}
								});
							}
						}
					});
				}
			},
			
			'studentregisterforevalgroupgrid button[itemId=downloadForm]': {
				click: function(obj) {
					var $this = this;
					var formWindow = $this.getDownloadformwin();
					if (!formWindow) {
						Ext.widget('downloadformwin');
						formWindow = $this.getDownloadformwin();
					}
					var tempalte = $this.getStore('setup.templatemapping.TemplateNameListFacultyByCode');
					tempalte.getProxy().extraParams = {
						reportType: 'Assessment Group Reports'
					};
					tempalte.load({
						callback: function(record) {
							if (record.length == 1) {
								var grid = $this.getStudentregisterforevalgroupgrid();
								var reportParams = new Object();
								if (grid.getSelectionModel().getCount() > 0) {
									var records = grid.getSelectionModel().getSelection()[0];
									var admissionId = records.data.admissionId;
									var periodId = records.data.periodId;
									var reportParams = new Object();
									reportParams.EVAL_GROUP = records.data.evaluationGroupId
									reportParams.ADMISSION_ID = records.data.admissionId
									reportParams.PERIOD_ID = records.data.periodId
									reportParams.STUDENT_CODE = records.data.studentCode
									reportParams.code = record[0].data.value;
								} else {
									return;
								}

								var academyLocationIds = $this.getCurrentAcademyLocation();
								var form = $this.getDownloadformwin();
								var templateTypeCombo = form.down('#templateTypeId');
								var templateCode = templateTypeCombo.getValue();
								reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds + "";
								var reportTitle = "Examination Form";
								reportParams.headerName = reportTitle;
								reportParams.reportTitle = reportTitle;
								var exportUrl = "rest/applicationDetails/generateAssessmentGroupReports";
								var code = templateCode;
								if (!isNullOrEmpty(code)) {
									reportParams.code = code;
								}
								reportParams.TEMPLATE_TYPE = 'Assessment Group Reports';
								$this.exportJRXMLReport(reportParams.code, reportParams, '', '.pdf', exportUrl);
							} else if (record.length == 0) {
								showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('PLEASE_MAP_TEMPLATE'));
							} else {
								$this.openFormWindow();
							}
						}
					});

				}
			},
			'downloadformwin button[itemId=submitBtn]': {
				click: function(obj, rec) {
					var $this = this;
					var grid = this.getEvalgrouplistingmastergrid();
					var reportParams = new Object();
					if (grid.getSelectionModel().getCount() > 0) {
						var records = grid.getSelectionModel().getSelection()[0];
						var admissionId = records.data.admissionId;
						var periodId = records.data.periodId;
						var reportParams = new Object();
						reportParams.EVAL_GROUP = records.data.evaluationGroupId
						reportParams.ADMISSION_ID = records.data.admissionId
						reportParams.PERIOD_ID = records.data.periodId
						reportParams.STUDENT_CODE = records.data.studentCode
					} else {
						return;
					}

					var academyLocationIds = $this.getCurrentAcademyLocation();
					var form = this.getDownloadformwin();
					var templateTypeCombo = form.down('#templateTypeId');
					var templateCode = templateTypeCombo.getValue();
					reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds + "";
					var reportTitle = "Examination Form";
					reportParams.reportTitle = reportTitle;
					reportParams.headerName = reportTitle;
					var exportUrl = "rest/applicationDetails/generateAssessmentGroupReports";
					var code = templateCode;
					reportParams.code = code;
					reportParams.TEMPLATE_TYPE = 'Assessment Group Reports';
					$this.exportJRXMLReport(code, reportParams, '', '.pdf', exportUrl);
					form.close();
				}
			},

			// CLICK event for exportToPdf
			'regassessmentgroupcorefilter button[itemId=exportToPdf]': {
				click: function(obj) {
					var $this = this;
					var academyLocationIds = $this.getCurrentAcademyLocation();
					// Use the renamed getter
					var form = $this.getRegassessmentgroupcorefilter();
					var formValues = form.getValues();
					var reportParams = new Object();
					var reportTitle = "Assessment Group Report";

					reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds + "";
					reportParams.headerName = reportTitle;

					if (!isNullOrEmpty(formValues.program)) { reportParams.PROGRAM_ID = formValues.program; }
					if (!isNullOrEmpty(formValues.batchId)) { reportParams.BATCH_ID = formValues.batchId; }
					if (!isNullOrEmpty(formValues.assessmentGroupId)) { reportParams.EVAL_GROUP = formValues.assessmentGroupId; }
					if (!isNullOrEmpty(formValues.academicTerm)) { reportParams.ACADEMIC_TERM_ID = formValues.academicTerm; }
					if (!isNullOrEmpty(formValues.groupStatus)) { reportParams.GROUP_STATUS = formValues.groupStatus; }

					var exportUrl = "rest/applicationDetails/generateAssessmentGroupReports";
					var code = "ASSESSMENT_GROUP_REPORT";
					reportParams.code = code;
					$this.exportJRXMLReport(code, reportParams, '', '.pdf', exportUrl);
				}
			},

			// CLICK event for exportToExcel (Inferred from Pdf logic and general ExtJS structure)
			'regassessmentgroupcorefilter button[itemId=exportToExcel]': {
				click: function(obj) {
					var $this = this;
					var academyLocationIds = $this.getCurrentAcademyLocation();
					// Use the renamed getter
					var form = $this.getRegassessmentgroupcorefilter();
					var formValues = form.getValues();
					var reportParams = new Object();
					var reportTitle = "Assessment Group Report";

					reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds + "";
					reportParams.headerName = reportTitle;

					if (!isNullOrEmpty(formValues.program)) { reportParams.PROGRAM_ID = formValues.program; }
					if (!isNullOrEmpty(formValues.batchId)) { reportParams.BATCH_ID = formValues.batchId; }
					if (!isNullOrEmpty(formValues.assessmentGroupId)) { reportParams.EVAL_GROUP = formValues.assessmentGroupId; }
					if (!isNullOrEmpty(formValues.academicTerm)) { reportParams.ACADEMIC_TERM_ID = formValues.academicTerm; }
					if (!isNullOrEmpty(formValues.groupStatus)) { reportParams.GROUP_STATUS = formValues.groupStatus; }

					var exportUrl = "rest/applicationDetails/generateAssessmentGroupReports";
					var code = "ASSESSMENT_GROUP_REPORT";
					reportParams.code = code;
					$this.exportJRXMLReport(code, reportParams, '', '.xlsx', exportUrl);
				}
			},
			
			'regassessmentgroupcoregrid menuitem[itemId=publishHallTicketItemId]': {
				click: function() {

					var $this = this;
					var grid = $this.getRegassessmentgroupcoregrid();
					var form = $this.getRegassessmentgroupcorefilter().getForm();
					var formValues = form.getValues();

					var jsonArr = [];
					var multipleRecordArray = [];
					var pendingHallTicketArray = [];
					var withdrawnRecordArray = [];
					var selection = grid.getSelectionModel().getSelection();
				   if (!selection || selection.length === 0) {
						showWarningMessage(
							getCommonTranslation('ALERT'),
							getCommonTranslation('PLEASE_SELECT_RECORD')
						);
						return;
					}
					var missingHallTicket = false;
					Ext.each(selection, function(rec) {
										    var hallTicket = rec.get('hallTicketPath');   // change field name if needed
										    if (!hallTicket || hallTicket === '') {
										        missingHallTicket = true;
										        return false; // break loop
										    }
										});

										if (missingHallTicket) {
										    showWarningMessage(
										        getCommonTranslation('ERROR'),
										        'Hall Ticket must be generated before publishing'
										    );
										    return;
										}

					Ext.Array.each(selection, function(record) {

						if (!record.data.hallticket) {
							pendingHallTicketArray.push(false);
						}

						if (record.data.applicationStatus === "WITHDRAWN" && record.data.hallticket) {
							withdrawnRecordArray.push(record.data.applicationStatus);
						}
					});

					Ext.Array.each(selection, function(record) {

						if ((record.data.applicationStatus === "WITHDRAWN" ||
							record.data.applicationStatus === "APPROVED" ||
							record.data.applicationStatus === "APPLIED" ||
							record.data.applicationStatus === "SUBMITTED")
							&& !record.data.hallticket) {

							multipleRecordArray.push(record.data.applicationStatus);
						}
					});

					if (multipleRecordArray.length > 0 || pendingHallTicketArray.length > 0) {

						showWarningMessage(
							getCommonTranslation('ALERT'),
							getExaminationTranslation(
								'PLEASE_GENERATE_HALL_TICKET_FOR_SELECTED_RECORDS_BEFORE_PUBLISHING'
							)
						);
						return;

					} else if (withdrawnRecordArray.length > 0) {

						showWarningMessage(
							getCommonTranslation('ALERT'),
							getExaminationTranslation(
								'PLEASE_APPROVE_STUDENTS_BEFORE_PUBLISHING_HALL_TICKET'
							)
						);
						return;
					}

					Ext.Array.each(selection, function(record) {

						if (!isNullOrEmpty(record.data.financeHoldStatus) &&
							record.data.financeHoldStatus === "Hold") {

							showWarningMessage(
								getCommonTranslation('ALERT'),
								'<span class="required" style="color:red">' +
								getExaminationTranslation(
									'HALL_TICKET_CANNOT_BE_PUBLISHED_DUE_TO_NON_PAYMENT_OF_FEES'
								) +
								'</span>'
							);
							return false;

						} else if (record.data.applicationStatus === "APPROVED" &&
							!isNullOrEmpty(record.data.hallticket)) {

							jsonArr.push({
								admissionId: record.data.admissionId,
								evaluationGroupId: formValues.evaluationGroupId,
								reportEnum: "HALL_TICKET",
								periodId: record.data.periodId,
								evalGroupHallTicketId: record.data.evalGroupHallTicketId,
								weatherHold: false
							});
						}
					});

					if (jsonArr.length > 0) {
						$this.saveStudentDetailsForHallTicket(jsonArr, grid);
					}
				}
			}
		});
	},
	
	saveStudentDetailsForHallTicket: function (jsonArr, grid) {

	    var submitUrl = SERVERURL.PATH_PUBLISH_HALL_TICKET;

	    Ext.getBody().mask(
	        getCommonTranslation('SUBMITTING_FORM'),
	        'x-mask-loading'
	    );

	    Ext.Ajax.request({
	        url: submitUrl,
	        method: 'POST',
	        jsonData: jsonArr,

	        success: function () {
	            Ext.getBody().unmask();

	            showSuccessMessage(
	                getExaminationTranslation('HALL_TICKET'),
	                getExaminationTranslation('HALL_TICKET_PUBLISH_SUCCESS_MSG')
	            );

	            grid.down('#downloadHallTicketBtnId').setDisabled(true);
	            grid.getStore().reload();
	            grid.getSelectionModel().deselectAll(true);
	        },

	        failure: function () {
	            Ext.getBody().unmask();
	        }
	    });
	},
	
	onGridEditBtnClick: function(grid) {
	    var grid = this.getRegassessmentgroupcoregrid(); 
	    var selection = grid.getSelectionModel().getSelection();
		if (grid.getSelectionModel().getCount() === 0) {
		    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		    Ext.getBody().unmask();
		    return;
		}
		this.openNewCmpTab();
		var applicationDetails = this.getReggroupapplynowstructurespportal();
		var record = grid.getSelectionModel().getSelection()[0];
	    var evaluationGroupId = record.data.evaluationGroupId;

	    if (isNullOrEmpty(selection[0].data.admissionId) || isNullOrEmpty(selection[0].data.studentId) ||
		 isNullOrEmpty(selection[0].data.evaluationGroupId)) {
	        showWarningMessage(getCommonTranslation('ALERT'), 'Missing required details to fetch application.');
	        Ext.getBody().unmask();
	        return;
	    }

	    Ext.Ajax.request({
	        type: 'rest',
	        url: SERVERURL.APPY_NOW_FOR_REG_GROUP_FOR_STUDENT,
	        method: 'GET',
	        params: {
	            admissionId: selection[0].data.admissionId,
	            studentId:selection[0].data.studentId,
	            evaluationGroupId: selection[0].data.evaluationGroupId
	        },
	        success: function(response) {
	            Ext.getBody().unmask();

	            var result = Ext.decode(response.responseText);
	            record.set('applicationResult', result);

	            if (!isNullOrEmpty(result)) {
	                var form = applicationDetails.down('reggroupapplywindow form');
	                if (form) {
	                    form.getForm().setValues({
	                        studentName: result.studentCode || '',
	                        name: result.studentName || '',
	                        assessmentGroupName: result.evaluationGroupCode || '',
	                        groupStatus: result.evaluationGroupStatus || '',
	                        centerStatus: result.centerStatus || '',
	                        program: result.programName || '',
	                        batch: result.batchName || '',
	                        applicationStatus: result.applicationStatus || '',
	                        roomAllocationStatus: result.roomAllocationStatus || ''
	                    });
	                }

					if (result.groupCourseList && result.groupCourseList.length > 0) {
					    var grid = applicationDetails.down('#reggroupapplyeventgrid');
					    if (!grid) return;

					    var store = grid.getStore();
					    var selModel = grid.getSelectionModel();

					    store.loadData(result.groupCourseList);
					    selModel.deselectAll();

					    store.each(function(record) {
					        if (record.data.mapped) {
					            selModel.select(record, true);
					        }
					    });
					}
	            } else {
	                showInfoMessage(getCommonTranslation('INFO'), 'No data found for selected student.');
	            }
	        },
	        failure: function(response) {
	            Ext.getBody().unmask();
	            showErrorMessage(getCommonTranslation('ERROR'), 'Failed to fetch application: ' + response.statusText);
	        }
	    });
	},
	onApplyNowBtnClick: function() {

		var grid = this.getRegassessmentgroupcoregrid();
		if (!grid) return;

		var selection = grid.getSelectionModel().getSelection();

		if (!selection || selection.length === 0) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getCommonTranslation('PLEASE_SELECT_RECORD')
			);
			return;
		}
		
		// Blocked status list
		var invalidStatuses = ['applied','submitted','partially submitted','approved','partially applied'];
		var hasInvalid = false;

		// Loop through selected records
		Ext.each(selection, function(rec) {
		    var status = (rec.raw.applicationStatus || '').toLowerCase();
		    if (Ext.Array.contains(invalidStatuses, status)) {
		        hasInvalid = true;
		        return false; // break loop
		    }
		});

		if (hasInvalid) {
		    showWarningMessage(getCommonTranslation('ALERT'), 'Invalid Selection for Approval Operation');
		    return;
		}

		var admissionIds = [];
		var evaluationGroupId = null;

		Ext.Array.each(selection, function(record) {
			admissionIds.push(record.get('admissionId'));

			if (!evaluationGroupId) {
				evaluationGroupId = record.get('evaluationGroupId');
			}
		});


		Ext.Ajax.request({
			url: SERVERURL.PATH_UPDATE_APPLICATION_GROUP_STATUS,
			method: 'POST',

			jsonData: {
				admissions: admissionIds.join(','),
				evaluationGroupId: evaluationGroupId,
				approvalCheck: true
			},

			success: function(response) {
				Ext.getBody().unmask();

				var result = response.responseText;

				if (result === 'SUCCESS') {
					showSuccessMessage(
						getCommonTranslation('SUCCESS'),
						'Approved successfully!'
					);
					grid.getStore().reload();
				}
			},

			failure: function() {
				Ext.getBody().unmask();
				showErrorMessage(
					getCommonTranslation('ERROR'),
					'Failed to approve application'
				);
			}
		});
	},
	
	onWithdrawBtnClick: function(grid) {

		var grid = this.getRegassessmentgroupcoregrid();
		if (!grid) return;

		var selection = grid.getSelectionModel().getSelection();
		
		if (!selection || selection.length === 0) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getCommonTranslation('PLEASE_SELECT_RECORD')
			);
			return;
		}
		
		// Valid statuses to allow Withdraw
		var validStatuses = ['SUBMITTED', 'PARTIALLY SUBMITTED'];

		var hasInvalid = false;

		// Loop through selected records
		Ext.each(selection, function(rec) {
		    var status = rec.get('applicationStatus');
		    if (!Ext.Array.contains(validStatuses, status)) {
		        hasInvalid = true;
		        return false; // break loop
		    }
		});

		if (hasInvalid) {
		    showWarningMessage(getCommonTranslation('ERROR'), 'Invalid selection for Withdraw operation');
		    return;
		}


		var admissionIds = [];
		var evaluationGroupId = null;

		Ext.Array.each(selection, function(record) {
			admissionIds.push(record.get('admissionId'));

			if (!evaluationGroupId) {
				evaluationGroupId = record.get('evaluationGroupId');
			}
		});


		Ext.Ajax.request({
			url: SERVERURL.PATH_UPDATE_APPLICATION_GROUP_STATUS,
			method: 'POST',

			jsonData: {
				admissions: admissionIds.join(','),
				evaluationGroupId: evaluationGroupId,
				approvalCheck: false
			},

			success: function(response) {
				Ext.getBody().unmask();

				var result = response.responseText;

				if (result === 'SUCCESS') {
					showSuccessMessage(
						getCommonTranslation('SUCCESS'),
						'Approved successfully!'
					);
					grid.getStore().reload();
				}
			},

			failure: function() {
				Ext.getBody().unmask();
				showErrorMessage(
					getCommonTranslation('ERROR'),
					'Failed to approve application'
				);
			}
		});

	},

	onRegStructRender: function(grid) {


	},

	onCoreGridRender: function(grid) {


	},

	onCoreGridSelectionChange: function (selModel, records) {

	    var grid = this.getRegassessmentgroupcoregrid();
	    if (!grid) return;

	    var moreActionsBtn = grid.down('#spBtnMoreActions');
	    var editBtn = grid.down('#editBtnId');

	    if (!moreActionsBtn || !moreActionsBtn.menu) return;

	    var approveItem  = moreActionsBtn.menu.down('#approveItemId');
	    var withdrawItem = moreActionsBtn.menu.down('#withdrawnItemId');

	    approveItem.disable();
	    withdrawItem.disable();
	    if (editBtn) editBtn.disable();

	    if (!records || records.length === 0) {
	        return;
	    }

	    var enableApprove  = true;
	    var enableWithdraw = true;

	    Ext.Array.each(records, function (rec) {

	        var status = rec.get('applicationStatus');

	        // APPROVE: only SUBMITTED / PARTIALLYSUBMITTED
	        if (status !== 'Submitted' && status !== 'Partially Submitted') {
	            enableApprove = false;
	        }

	        // WITHDRAW: disabled if APPROVED
	        if (status === 'Approved') {
	            enableWithdraw = false;
	        }

	        if (!enableApprove && !enableWithdraw) {
	            return false; 
	        }
	    });

	    if (enableApprove) {
	        approveItem.enable();
	    }

	    if (enableWithdraw) {
	        withdrawItem.enable();
	    }

	    // EDIT: only single + APPLIED / PARTIALLYAPPLIED
	    if (records.length === 1) {
	        var rec = records[0];
	        var status = rec.get('applicationStatus');

	        if (status === 'Applied' || status === 'Partially Applied') {
	            if (editBtn) editBtn.enable();
	        }
	    }else{
			editBtn.setDisabled(true);
		}
	},

	applyNowForRegGroupForStudent: function(me, grid) {
		// Ext.getBody().mask(getCommonTranslation('LOADING_APPLICATION'), 'x-mask-loading');

		
		if (grid.getSelectionModel().getCount() === 0) {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			Ext.getBody().unmask();
			return;
		}
		
		this.openNewCmpTab();

		var applicationDetails = this.getReggroupapplynowstructurespportal();
		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		var studentName = studentPortalInfo.student.printName;
		var admissionId = studentPortalInfo.admissionDetails[0].id;
		var record = grid.getSelectionModel().getSelection()[0];

		var evaluationGroupId = record.data.evaluationGroupId;

		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();

		var admissionId = studentPortalInfo.admissionDetails[0].id;

		var studentId = studentPortalInfo.student.id;

		if (isNullOrEmpty(admissionId) || isNullOrEmpty(studentId) || isNullOrEmpty(evaluationGroupId)) {
			showWarningMessage(getCommonTranslation('ALERT'), 'Missing required details to fetch application.');
			Ext.getBody().unmask();
			return;
		}

		// Step 3️⃣: Perform Ajax call
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.APPY_NOW_FOR_REG_GROUP_FOR_STUDENT,
			method: 'GET',
			params: {
				admissionId: admissionId,
				studentId: studentId,
				evaluationGroupId: evaluationGroupId
			},
			success: function(response) {
				Ext.getBody().unmask();

				var result = Ext.decode(response.responseText);
				record.set('applicationResult', result);

				if (!isNullOrEmpty(result)) {
					// Step 4️⃣: Open window and fill form
					var form = applicationDetails.down('reggroupapplywindow form');
					if (form) {
						form.getForm().setValues({
							studentName: result.studentCode || '',
							name: result.studentName || '',
							assessmentGroupName: result.evaluationGroupCode || '',
							groupStatus: result.evaluationGroupStatus || '',
							centerStatus: result.centerStatus || '',
							program: result.programName || '',
							batch: result.batchName || '',
							applicationStatus: result.applicationStatus || '',
							roomAllocationStatus: result.roomAllocationStatus || ''
						});
					}

					if (result && result.groupCourseList && result.groupCourseList.length > 0) {
					    var grid = applicationDetails.down('#reggroupapplyeventgrid');
					    if (!grid) {
					        return;
					    }

					    var store = grid.getStore();
					    var selModel = grid.getSelectionModel();

					    store.removeAll();
					    store.loadData(result.groupCourseList);
					    selModel.deselectAll();

					    store.each(function(record) {
					        if (record.data.mapped) {
					            selModel.select(record, true);
					        }
					    });
					}
				} else {
					showInfoMessage(getCommonTranslation('INFO'), 'No data found for selected student.');
				}
			},
			failure: function(response) {
				Ext.getBody().unmask();
				showErrorMessage(getCommonTranslation('ERROR'), 'Failed to fetch application: ' + response.statusText);
			}
		});
	},

	onApplyAssessmentActivate: function(panel) {

	}
	, onDocWindow: function(panel) {

	},

	onGridsRender: function(form) {

	},

	// ============================
	// 🔹 ON FILTER RENDER
	// ============================
	onFilterRender: function(form) {
		var me = this;
		var studentInfo = me.getCurrentlyLoggedInUserInfoForPortal();
		if (!studentInfo) return;

		var studentId = studentInfo.student.id;
		var alId = me.getCurrentAcademyLocation();

		var programCombo = form.down('#programItemId'),
			batchCombo = form.down('#batchIdItemId'),
			periodCombo = form.down('#periodId'),
			courseCombo = form.down('#courseId');

		// ✅ SAFETY CHECK before accessing proxy
		if (courseCombo && courseCombo.getStore && courseCombo.getStore()) {
			var courseStore = courseCombo.getStore();
			courseStore.getProxy().extraParams = {
				studentId: studentId
				// periodId intentionally removed
			};
			courseStore.load();
		}

		// Disable dependent combos initially
		Ext.each([batchCombo, periodCombo], function(c) {
			c.setDisabled(true);
			c.clearValue();
		});

		// Enable and load Program combo
		programCombo.setDisabled(false);
		programCombo.clearValue();

		var programStore = programCombo.getStore();
		programStore.removeAll();
		programStore.getProxy().extraParams = {
			alId: alId,
			studentId: studentId
		};

		programStore.load({
			callback: function(records, success) {
				if (success && records && records.length === 1) {
					var programId = records[0].data.programId;
					programCombo.setValue(programId);
					me.loadBatchStore(batchCombo, programId, studentId, form);
				} else {
					programCombo.setDisabled(false);

					// ✅ Optional fallback course reload after 200ms
					Ext.defer(function() {
						if (courseCombo && courseCombo.getStore && courseCombo.getStore()) {
							var store = courseCombo.getStore();
							store.getProxy().extraParams = {
								studentId: studentId
							};
							store.load();
						}
					}, 200);
				}
			}
		});
	},

	// ============================
	// 🔹 STEP 1 → PROGRAM SELECT
	// ============================
	onProgramSelect: function(combo, record, courseId) {
		var form = combo.up('form');
		var studentId = this.getStudentId(form);
		var batchCombo = form.down('#batchIdItemId');
		var courseCombo = form.down('#courseId');
		var programId;

		if (record && record.length > 0 && record[0] && record[0].data) {
			programId = record[0].data.programId;
		} else {
			programId = form.down('#programItemId').getValue();
		}

		if (!programId) {
			return;
		}

		var params = {
			programId: programId,
			studentId: studentId
		};

		if (!isNullOrEmpty(courseId)) {
			params.courseId = courseId;
		}

		this.loadBatchStore(batchCombo, programId, studentId, form, params);
	},

	loadBatchStore: function(batchCombo, programId, studentId, form) {
		var me = this,
			store = batchCombo.getStore();
		var courseCombo = form.down('#courseId');
		store.removeAll();
		store.getProxy().extraParams = {
			programId: programId,
			studentId: studentId
		};
		store.load({
			callback: function(records, success) {
				if (success && records.length === 1) {
					var batchId = records[0].data.batchId;
					batchCombo.setValue(batchId);
					batchCombo.enable();
					me.loadPeriodStore(form.down('#periodId'), batchId, studentId, form);
				} else {
					batchCombo.setDisabled(false);


					Ext.defer(function() {
						if (courseCombo && courseCombo.getStore()) {
							courseCombo.getProxy().extraParams = {
								studentId: studentId,
								periodId: null
							};
							courseCombo.getStore().load();
						}
					}, 200);
				}
			}
		});
	},

	// ============================
	// 🔹 STEP 2 → BATCH SELECT
	// ============================
	onBatchSelect: function(combo, record) {
		var form = combo.up('form'),
			periodCombo = form.down('#periodId');

		periodCombo.setDisabled(false);
		periodCombo.clearValue();

		var batchId = record[0].data.batchId,
			studentId = this.getStudentId(form);

		this.loadPeriodStore(periodCombo, batchId, studentId, form);
	},

	loadPeriodStore: function(periodCombo, batchId, studentId, form) {
		var me = this,
			store = periodCombo.getStore();
		var courseCombo = form.down('#courseId');
		store.removeAll();
		store.getProxy().extraParams = {
			batchId: batchId,
			studentId: studentId
		};

		store.load({
			callback: function(records, success) {
				if (success && records.length === 1) {
					var periodId = records[0].data.periodId;
					periodCombo.setValue(periodId);
					periodCombo.enable();
					// ✅ Fire select manually (ExtJS 4 doesn’t auto fire)
					periodCombo.fireEvent('select', periodCombo, [records[0]]);
				} else {
					periodCombo.setDisabled(false);
					var courseCombo = form.down('#courseId');
					Ext.defer(function() {
						if (courseCombo && courseCombo.getStore()) {
							courseCombo.getProxy().extraParams = {
								studentId: studentId,
								periodId: null
							};
							courseCombo.getStore().load();
						}
					}, 500);
				}
			}
		});
	},

	// ============================
	// 🔹 STEP 3 → PERIOD SELECT
	// ============================
	onPeriodSelect: function(combo, record) {
		var form = combo.up('form'),
			evalGroupCombo = form.down('#evalGroupId');
		periodId = form.down('#periodId').getValue();

		evalGroupCombo.setDisabled(false);
		evalGroupCombo.clearValue();
		studentId = this.getStudentId(form);
		var isPeriod = true;

		this.loadGroupStore(evalGroupCombo, periodId, studentId, isPeriod);
	},

	loadGroupStore: function(evalGroupCombo, periodId, studentId, isPeriod) {
		var form = evalGroupCombo.up('form');
		var programCombo = form.down('#programItemId');
		var batchCombo = form.down('#batchIdItemId');
		var periodCombo = form.down('#periodId');

		if (!isPeriod) {
			programCombo.clearValue();
			batchCombo.clearValue();
			periodCombo.clearValue();
		}
		var store = evalGroupCombo.getStore();
		store.removeAll();
		store.getProxy().extraParams = {
			periodId: periodId,
			studentId: studentId
		};

		store.load({
			callback: function(records, success) {
				if (success && records.length === 1) {
					var evaluationGroupId = records[0].data.evaluationGroupId;
					evalGroupCombo.setValue(evaluationGroupId);
				} else {
					evalGroupCombo.setDisabled(false);
				}
			}
		});
	},
	/* On save Click of Event Apply Course Grid  */
	onNextSaveClick: function (btn) {

	    var grid = null;

	    // 🔹 Decide grid based on portal
	    if (this.getCurrentLoggedPortalId() == 3) {
	        grid = Ext.ComponentQuery.query('studentregisterforevalgroupgrid')[0];
	    } else {
	        grid = Ext.ComponentQuery.query('regassessmentgroupcoregrid')[0];
	    }

	    if (!grid) {
	        return;
	    }

	    var selection = grid.getSelectionModel().getSelection();
	    if (!selection || selection.length === 0) {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			btn.disable();
	        return;
	    }

	    var record = selection[0];
	    var savedResult = record.get('applicationResult');

	    var applicationDetails = this.getReggroupapplynowstructurespportal();
	    if (!applicationDetails) {
	        return;
	    }

	    var courseGrid = applicationDetails.down('#reggroupapplyeventgrid');
	    if (!savedResult || !courseGrid) {
	        return;
	    }

	    var selectedRecords = courseGrid.getSelectionModel().getSelection();
		
		if(selectedRecords.length==0){
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			btn.disable();
		}

	    // 🔹 All selected flag
	    savedResult.allDataSelected =
	        selectedRecords.length === courseGrid.getStore().getCount();

	    savedResult.groupCourseList = [];

	    Ext.Array.each(selectedRecords, function (rec) {
	        savedResult.groupCourseList.push({
	            admissionId: rec.get('admissionId'),
	            courseName: rec.get('courseName'),
	            courseVariantCode: rec.get('courseVariantCode'),
	            courseVariantId: rec.get('courseVariantId'),
	            evaluationGroupId: rec.get('evaluationGroupId'),
	            eventId: rec.get('eventId'),
	            eventName: rec.get('eventName'),
	            mapped: rec.get('mapped'),
	            periodId: rec.get('periodId'),
	            periodName: rec.get('periodName'),
	            sectionId: rec.get('sectionId'),
	            sectionName: rec.get('sectionName'),
	            examinationResultId: rec.get('examinationResultId'),
	            feePlanApplicable: rec.get('feePlanApplicable')
	        });
	    });

	    var currentTab = btn.up('reggroupapplynowstructurespportal');
	    var tabPanel = currentTab ? currentTab.up('tabpanel') : null;

	    Ext.Ajax.request({
	        url: SERVERURL.SAVE_APPLY_GROUP_REG,
	        method: 'POST',
	        jsonData: savedResult,

	        success: function () {

	            showSuccessMessage(
	                getExaminationTranslation('EVALUATION_GROUP'),
	                getCommonTranslation('CONFIG_SAVED_SUCCESSFULLY')
	            );

	            if (currentTab) {
	                currentTab.close();
	            }

	            if (tabPanel && tabPanel.items.getCount() > 0) {
	                tabPanel.setActiveTab(0);
	            }

	            if (grid) {
	                grid.getStore().reload();
	            }
	        },

	        failure: function () {
	            showErrorMessage(
	                getEnquiryTranslation('ALERT'),
	                getCommonTranslation('FAILURE')
	            );
	        }
	    });
	},

	// ============================
	// 🔹 STEP 4 → COURSE SELECT
	// ============================
	onGroupSelect: function(combo, record) {
		var me = this;
		var form = combo.up('form');
		var saveBtn = form.up('panel').down('#searchBtn');
		saveBtn.setDisabled(!form.getForm().isValid());

		if (me._isProgramSelectLocked) return;
		me._isProgramSelectLocked = true;

		var programCombo = form.down('#programItemId');
		var evaluationGroupId = record[0].data.evaluationGroupId;
		var programId = programCombo.getValue();

		/*  if (programCombo && programId && courseId) {
			  programCombo.fireEvent(
				  'select',
				  programCombo,
				  [programCombo.getStore().getById(programId)],
				  courseId
			  );
		  }
  
		  Ext.defer(function () {
			  me._isProgramSelectLocked = false; 
		  }, 500); */
	},

	// ============================
	// 🔹 SEARCH CLICK
	// ============================
	onSearchClick: function(btn) {
		var form = btn.up('form');
		var grid = this.getStudentregisterforevalgroupgrid();
		var store = grid.getStore();
		var values = form.getValues();

		var studentId = this.getStudentId(form);
		var admissionId = this.getCurrentAcademyLocation();

		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		var admissionId = studentPortalInfo.admissionDetails[0].id;

		Ext.apply(store.getProxy().extraParams, {
			admissionId: admissionId,
			studentId: studentId,
			programId: values.programId,
			batchId: values.batchId,
			periodId: values.periodId,
			evaluationGroupId: values.evalGroupId
		});

		store.load();
	},

	// ============================
	// 🔹 RESET CLICK
	// ============================
	onResetClick: function(btn) {
		var me = this;
		var form = btn.up('form');

		form.getForm().reset();

		var grid = me.getStudentregisterforevalgroupgrid();
		if (grid && grid.getStore()) {
			grid.getStore().removeAll();
		}

		me.onFilterRender(form);
	},

	// ============================
	// 🔹 UTIL
	// ============================
	getStudentId: function(form) {
		var tab = form.up('tabpanel') ? form.up('tabpanel').getActiveTab() : null;
		if (tab && typeof tab.getUserId === 'function') {
			return tab.getUserId();
		}
		return null;
	},

	createBillForManageFormReset: function(button) {
		var grid = this.getRegassessmentgroupcoregrid();
		var record = grid.getSelectionModel().getSelection()[0];
		var formWindow = this.getReggroupmakepaymentwin();

		var form = button.up('#makePaymentReceiptform');
		form.down('#depositedBank').reset();
		form.down('#paymentMode').reset();
		form.down('#instrumentNo').reset();
		form.down('#instrumentBank').reset();
		form.down('#narration').reset();
		form.down('#depositedCash').reset();
		form.down('#receivingIAU').reset();
		form.down('#receivingCurrency').setValue(record.raw.currencyId);
		form.down('#amount').setValue(record.get('feeAmount'));
		form.down('#discountAmount').setValue(record.get('discountAmount'));
	},

	openNewCmpTab: function() {
		var me = this;
		var contentpanel = this.getContentpanel();

		//var evalgrouplistingtab = Ext.create('Academia.view.examinationcenters.evaluationgrouplisting.RegGroupApplyNowStructureSPPortal');
		var tab = Ext.widget('reggroupapplynowstructurespportal');
		var tabName = getExaminationTranslation('APPLY_NOW');
		/**
		 * This is to remove tab from content panel and open same tab again 
		 */
		var getcontroller = this.getController('menu.CoreERPNavigationController');
		var getTab = getcontroller.getTab(tabName);
		if (getTab != null) {
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, tab, CONSTANTS.MENU_COLOR_FOUR);
	},
	
	generateHallTicket: function() {

		var $this = this;
		var grid = this.getRegassessmentgroupcoregrid();
		var selection = grid.getSelectionModel().getSelection();

		if (!selection || selection.length === 0) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getCommonTranslation('PLEASE_SELECT_RECORD')
			);
			return;
		}
		
		// Hall Ticket allowed only for APPROVED status
		var requiredStatus = 'approved';
		var hasInvalid = false;

		// Check all records
		Ext.each(selection, function(rec) {
		    var status = rec.raw.applicationStatus;
		    if (status.toLowerCase() !== requiredStatus) {
		        hasInvalid = true;
		        return false; // break loop
		    }
		});

		if (hasInvalid) {
		    showWarningMessage(
		        getCommonTranslation('ERROR'),
		        'Only Approved applications can generate Hall Ticket'
		    );
		    return;
		}


		var statusArray = [];
		var approvedArray = [];

		Ext.Array.each(selection, function(record) {
			/*if (record.data.applicationStatus !== "APPROVED") {
				statusArray.push(record.data.applicationStatus);
			}
			if (record.data.applicationStatus === "APPROVED") {
				approvedArray.push(record.data.applicationStatus);
			} */
		});

		if (approvedArray.length > 0 && statusArray.length > 0) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getExaminationTranslation('RECORDS_WITH_MULTIPLE_STATUSES_CANNOT_BE_SELECTED_TOGETHER')
			);
			grid.getSelectionModel().deselectAll(true);
			return;
		}

		if (approvedArray.length < 1 && statusArray.length > 0) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getExaminationTranslation('HALL_TICKET_GENERATION_ALERT')
			);
			return;
		}

		// ===== Date validation =====
		var isExecutable = false;
		var todayDate = new Date();

		Ext.Array.each(selection, function(record) {
			var tillDate = new Date(record.raw.examdateTill);
			if (todayDate <= tillDate) {
				isExecutable = true;
			}
		});

		if (!isExecutable) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getExaminationTranslation('EVALUATION_GROUP_PASSED_ALERT_MSG')
			);
			return;
		}

		// ===== Load template =====
		var templateStore = $this.getStore(
			'setup.templatemapping.TemplateNameListFacultyByCode'
		);

		templateStore.getProxy().extraParams = {
			reportType: 'Hall Ticket'
		};

		templateStore.load({
			callback: function(records) {

				if (records.length === 1) {
					$this.generateReGenerateHallTicketOnApply(true, records[0].data.id);
				} else {
					var formWindow = $this.getGeneratehallticketwin();
					if (!formWindow) {
						formWindow = Ext.widget('generatehallticketwin');
					}

					formWindow.setHeight(172);
					formWindow.setWidth(500);
					formWindow.show();

					formWindow.down('#isPreExam').setValue(false);

					var templateComboStore =
						formWindow.down('#chooseHallticketTemplate').getStore();

					templateComboStore.getProxy().extraParams = {
						reportType: 'Hall Ticket'
					};
					templateComboStore.load();
				}
			}
		});
	},
	
	generateReGenerateHallTicketOnApply: function(isGenerate, templateId) {

		var $this = this;
		var grid = this.getRegassessmentgroupcoregrid();
		var records = grid.getSelectionModel().getSelection();

		var admArr = [];

		Ext.Array.each(records, function(rec) {
			admArr.push(rec.data.admissionId);
		});

		var firstRec = records[0];

		var json = {
			evaluationGroupId: firstRec.data.evaluationGroupId,
			programId: firstRec.data.programId,
			batchId: firstRec.data.batchId,
			periodId: firstRec.data.periodId,
			admissionIds: admArr.join(','),
			preExaminationReportEnum: 'HALL_TICKET',
			templateConfigId: templateId
		};

		var submitUrl = SERVERURL.GENERATE_HALL_TICKET;

		showWarningMessage(
			getCommonTranslation('ALERT'),
			getExaminationTranslation('HALL_TICKET_GENERATION_UNDERPROSESS')
		);

		var formWindow = $this.getGeneratehallticketwin();
		if (formWindow) {
			formWindow.close();
		}

		Ext.Ajax.request({
			url: submitUrl,
			method: 'POST',
			jsonData: json,
			timeout: 600000,

			success: function(resp) {
				var msg = resp.responseText;

				if (!isNullOrEmpty(msg) && msg !== 'SUCCESS') {
					if (msg === 'HALL_TICKET_ALREADY_INPROGRESS') {
						showWarningMessage(
							getCommonTranslation('ALERT'),
							getExaminationTranslation('HALL_TICKET_ALREADY_INPROGRESS')
						);
					} else {
						showWarningMessage(
							getCommonTranslation('ALERT'),
							msg
						);
					}
				}

				var task = new Ext.util.DelayedTask(function() {
					grid.getStore().reload();
					grid.getSelectionModel().deselectAll(true);
				});
				task.delay(1500);
			}
		});
	},
	
	changeApplicationStatus: function(status) {

		var $this = this;
		var grid = $this.getRegassessmentgroupcoregrid();

		if (grid.getSelectionModel().getCount() === 0) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getCommonTranslation('PLEASE_SELECT_RECORD')
			);
			return;
		}

		var records = grid.getSelectionModel().getSelection()[0];

		if (records.data.centerAllotted === "NOT_ASSIGNED" ||
			records.data.centerAllotted === "Not Assigned") {

			showWarningMessage(
				getCommonTranslation('ALERT'),
				getExaminationTranslation('APPLY_FOR_GRP_CETER_ALLOCATION_ERROR_MSG')
			);
			return;
		}

		var applicationStatus = null;
		var isValid = false;

		// ===== APPROVE =====
		if (status === getExaminationTranslation('CNTRL_APPROVED')) {

			if (records.data.applicationFlag === 'Partially Applied' ||
				records.data.applicationFlag === 'Applied' ||
				records.data.applicationFlag === 'Pending') {

				if (!records.data.isPayFullFees) {
					showWarningMessage(
						getCommonTranslation('ALERT'),
						getExaminationTranslation('FEES_SUBMIT_MSG')
					);
					return;
				}

				if (!records.data.isAllDocumentSubmitted) {
					showWarningMessage(
						getCommonTranslation('ALERT'),
						getExaminationTranslation('ALL_DOCUMENTS_ARE_NOT_SUBMITTED_CANT_APPROVED')
					);
					return;
				}

				applicationStatus = getExaminationTranslation('CNTRL_APPROVED');
				isValid = true;
			}

		}
		// ===== WITHDRAW =====
		else if (status === getExaminationTranslation('WITHDRAWN')) {
			applicationStatus = getExaminationTranslation('CNTRL_WITHDRAWN');
			isValid = true;
		}
		// ===== HALL TICKET GENERATION =====
		else if (status === getExaminationTranslation('HALL_TICKET_GENERATION')) {
			applicationStatus = getExaminationTranslation('CNTRL_HALL_TICKET_GENERATION');
			isValid = true;
		}
		// ===== PRINT HALL TICKET =====
		else if (status === getExaminationTranslation('PRINT_HALL_TICKET')) {
			applicationStatus = getExaminationTranslation('CNTRL_PRINT_HALL_TICKET');
			isValid = true;
		}
		// ===== NOTIFY =====
		else if (status === getExaminationTranslation('NOTIFY')) {
			applicationStatus = getExaminationTranslation('CNTRL_NOTIFY');
			isValid = true;
		}
		// ===== DOWNLOAD APPLICATION =====
		else if (status === getExaminationTranslation('DOWNLOAD_APPLICATION')) {
			applicationStatus = getExaminationTranslation('CNTRL_DOWNLOAD_APPLICATION');
			isValid = true;
		}

		if (!isValid) {
			return;
		}

		// ===== DATE CHECK =====
		var todayDate = new Date();
		var examTillDate = new Date(records.raw.examdateTill);

		if (todayDate > examTillDate) {
			showWarningMessage(
				getCommonTranslation('ALERT'),
				getExaminationTranslation('EVALUATION_GROUP_PASSED_ALERT_MSG')
			);
			return;
		}

		// ===== CONFIRM & SUBMIT =====
		showConfirmMessage(
			getExaminationTranslation('APPLICATION_STATUS'),
			getExaminationTranslation('APPLICATION_STATUS_CHANGE_CONFIRMETION_TEXT'),
			function(btn) {

				if (btn !== 'yes') {
					return;
				}

				Ext.Ajax.request({
					url: SERVERURL.EVAL_GROUP_CHANGE_APPLICATION_STATUS_URL,
					method: 'POST',

					params: {
						admissionId: records.data.admissionId,
						evalApplicationStatus: applicationStatus,
						evaluationGroupId: records.data.evaluationGroupId
					},

					success: function() {
						showSuccessMessage(
							getExaminationTranslation('APPLICATION_STATUS'),
							getExaminationTranslation('APPLICATION_STATUS_SUCCESS_MSG')
						);
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll(true);
					}
				});
			}
		);
	},
	
	openRegAssessmentGroupCoreGridWindow: function (record) {

	    var gridStore = Ext.create(
	        'Academia.store.RegEGStores.EvaluationGroupCourseGridStore'
	    );

	    Ext.Ajax.request({
	        url: SERVERURL.PATH_FIND_COURSES_BY_EVAL_GROUP,
	        method: 'GET',

	        params: {
	            page: 1,
	            limit: 25,
	            admissionId: record.get('admissionId'),
	            evaluationGroupId: record.get('evaluationGroupId'),
	            applicationStatus: record.get('applicationStatus')
	        },

	        success: function (response) {
	            var json = Ext.decode(response.responseText);

	            console.log('Backend rows:', json.rows); 

	            gridStore.removeAll();
				
			   Ext.Array.each(json.rows, function (row) {
			       gridStore.add({
			           courseName: row.courseName +"/"+row.courseVariantCode
			       });
			   });

	            gridStore.totalCount = json.total || json.rows.length;
				
				var grid = Ext.ComponentQuery.query('evaluationgroupcoursegrid')[0];
				  if (grid) {
				      grid.down('#totalRecordDisplayField')
				          .setValue('Total Records: ' + gridStore.data.length);
				  }

	        }
	    });

	    var win = Ext.create('Ext.window.Window', {
	        title: 'Assessment Group Courses',
	        modal: true,
	        width: 900,
	        height: 500,
	        layout: 'fit',

	        items: [{
	            xtype: 'evaluationgroupcoursegrid',
	            store: gridStore
	        }]
	    });
		win.show();
	}

	,createBillForManageForm: function(button, print) {
		this$ = this;
		var grid = this.getRegassessmentgroupcoregrid();
		var manageFormListStore = grid.getStore();
		var form = button.up('form');
		var window = button.up('window');
		var formValues = form.getValues();
		var applicantObject = new Object();
		applicantObject.id = formValues.id;
		formValues.raiseBillType = 'P_AND_C_FEE';
		formValues.applicant = applicantObject;

		var recieptForObj = new Object();
		recieptForObj.id = 2;
		recieptForObj.value = "APPLICANT";
		formValues.receiptFor = recieptForObj;

		var paymentMode = new Object();
		paymentMode.id = formValues.paymentMode;

		var instrumentBank = new Object();
		if (isNullOrEmpty(formValues.instrumentBank)) {
			instrumentBank.id = null;
		} else {
			instrumentBank.id = formValues.instrumentBank;
		}
		var costCentreId;
		if (isNullOrEmpty(formValues.costCentre)) {
			delete formValues.costCentre;
		}

		if (formValues.voucherMode === 'BANK') {
			var receiptPaymentInstrumentsArray = new Array();
			var receiptPaymentInstruments = new Object();
			receiptPaymentInstruments.paymentMode = paymentMode;
			receiptPaymentInstruments.instrumentBank = instrumentBank;
			receiptPaymentInstruments.instrumentNo = formValues.instrumentNo;
			receiptPaymentInstruments.instrumentDate = formValues.instrumentDate;
			receiptPaymentInstruments.amount = formValues.amount;

			delete formValues.instrumentDate;
			delete formValues.amount;

			receiptPaymentInstrumentsArray.push(receiptPaymentInstruments);
			formValues.receiptPaymentInstruments = receiptPaymentInstrumentsArray;
		}

		if (isNullOrEmpty(formValues.depositedBank)) { 
			formValues.depositedBank = null;
		};

		if (isNullOrEmpty(formValues.depositedCash)) {
			formValues.depositedCash = null;
		};
		delete formValues.instrumentNo;
		delete formValues.depositedLedger;
		delete formValues.id;
		delete formValues.paymentMode;
		delete formValues.instrumentBank;
		delete formValues.instrumentAmount;
		delete formValues.customData;
		var submitData = Ext.encode(formValues);

		this$.applyWindowMask();
		window.down('#SubmitBtn').setDisabled(true);
		window.down('#SubmitAndPrintMakePaymentBtn').setDisabled(true);
		this.sendSaveAjaxRequest(SERVERURL.RECEIPT_HEADER_SAVEANDCREATEBILL, 'POST', submitData, function(opt, success, response) {
			if (success) {
				this$.hideWindowMask();
				manageFormListStore.reload();
				grid.getSelectionModel().deselectAll();
				//Call for makePayment as per nita.
				/** https://serosoft.atlassian.net/browse/V2D-120605
				Application is directly goes to submitted state which goes wrong for many clients.
				As discussed with senior commenting this code.
				**/
				/*var serverUrl = SERVERURL.ASSIGN_APPLICATION_ID_MAKE_PAYMENT;
				serverUrl = serverUrl.concat('?applicationId='+formValues.applicant.id);
				this$.sendSaveAjaxRequest(serverUrl, 'POST', null, function(opt,success,response){});*/
				window.close();
				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS')); //No search result found
				if (print == true) {
					this$.getPrintGenerateMakePayment(response.responseText);
				}
			} else {
				this$.hideWindowMask();
				window.down('#SubmitBtn').setDisabled(false);
				window.down('#SubmitAndPrintMakePaymentBtn').setDisabled(false);
				manageFormListStore.reload();
				grid.getSelectionModel().deselectAll();
			}

		});
	}

});