/**
 * Niklesh Tiwane
 */
Ext.define('Academia.controller.alumniManagementSystem.AlumniPortalSetUpController', {
	extend: 'Academia.controller.base.BaseController',
	models:['alumni.alumniPortalSetUp.AlumniPortalSetUpGridModel','alumni.alumniPortalSetUp.AlumniPortalSetUpConfigGridModel',
		'alumni.alumniPortalSetUp.AlumniPortalSetUpConfigGridModel','alumni.alumniPortalSetUp.AlumniPortalConfigureInnerGridModel'],
	stores: ['alumni.alumniPortalSetUp.AlumniPortalSetUpGridStore','alumni.alumniPortalSetUp.AlumniPortalSetUpConfigGridStore',
		'alumni.alumniPortalSetUp.AlumniPortalApplyToAlGridStore','alumni.alumniPortalSetUp.AlumniPortalSetUpNameStore','alumni.alumniPortalSetUp.AlumniPortalSetUpCreatedByStore',
		'alumni.alumniPortalSetUp.AlumniPortalSetUpAlStore','alumni.alumniPortalSetUp.AlumniPortalApplyToAlGridMapppingStore','alumni.alumniPortalSetUp.AlumniPortalConfigureInnerGridStore',
		'alumni.alumniPortalSetUp.AlumniSetupNameStore','alumni.alumniPortalSetUp.AlumniCreatedUserStore'],
	views: [
		'alumniSystem.alumniPortalSetUp.AlumniPortalSetUpStructure','alumniSystem.alumniPortalSetUp.AlumniPortalSetUpFilter',
		'alumniSystem.alumniPortalSetUp.AlumniPortalSetUpGrid','alumniSystem.alumniCommon.widget.AlumniPortalSetUpNameWindow',
		'alumniSystem.alumniPortalSetUp.AlumniPortalConfiguration','alumniSystem.alumniPortalSetUp.AlumniPortalConfigurationGrid',
		'alumniSystem.alumniCommon.widget.AlumniPortalSetupHelpTextWindow','alumniSystem.alumniCommon.widget.AlumniPortalSetUpRenameWindow',
		'alumniSystem.alumniCommon.widget.OpenApplyWindow','alumniSystem.alumniCommon.widget.applyToAlgrid',
		'alumniSystem.alumniPortalSetUp.AddAlumniSetUpMappingStructure','alumniSystem.alumniPortalSetUp.AddAlumniSetUpMappingGrid',
		'alumniSystem.alumniPortalSetUp.AlumniPortalConfigureInnerTab','alumniSystem.alumniPortalSetUp.AlumniPortalConfigureInnerTab',
		'alumniSystem.alumniPortalSetUp.AlumniPortalConfigureInnerGrid','alumniSystem.alumniCommon.widget.AlumniPortalSetupMappingAlertWin',
		'alumniSystem.alumniPortalSetUp.AlumniPortalLoginConfigureScreen'
	],
	config: {
		ALUMNI_PORTAL_SET_UP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ALUMNI_PORTAL_SET_UP_PRIVILEGES'),
	},
	refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'	
	},{
        ref: 'alumniPortalSetUpStructure',
        selector: 'alumniPortalSetUpStructure'	    	
	},{
        ref: 'alumniPortalSetUpFilter',
        selector: 'alumniPortalSetUpFilter'	    	
	},{
        ref: 'alumniPortalSetUpGrid',
        selector: 'alumniPortalSetUpGrid'	    	
	},{
        ref: 'alumniPortalSetUpNameWindow',
        selector: 'alumniPortalSetUpNameWindow'	    	
	},{
        ref: 'alumniPortalConfiguration',
        selector: 'alumniPortalConfiguration'	    	
	},{
        ref: 'alumniPortalConfigurationGrid',
        selector: 'alumniPortalConfigurationGrid'	    	
	},{
        ref: 'alumniPortalSetupHelpTextWindow',
        selector: 'alumniPortalSetupHelpTextWindow'	    	
	},{
        ref: 'alumniPortalSetUpRenameWindow',
        selector: 'alumniPortalSetUpRenameWindow'	    	
	},{
        ref: 'addAlumniSetUpMappingStructure',
        selector: 'addAlumniSetUpMappingStructure'	    	
	},{
		ref: 'openApplyWindow',
        selector: 'openApplyWindow'
	},{
		ref: 'alumniportalconfigureinnergrid',
        selector: 'alumniportalconfigureinnergrid'
	},{
		ref: 'applyToAlgrid',
        selector: 'applyToAlgrid'
	},{
		ref: 'addAlumniSetUpMappingGrid',
        selector: 'addAlumniSetUpMappingGrid'
	},{
		ref: 'alumniPortalSetupMappingAlertWin',
        selector: 'alumniPortalSetupMappingAlertWin'
	},{
		ref: 'alumniportalconfigureinnertab',
        selector: 'alumniportalconfigureinnertab'		
	},{
		ref: 'alumniportalloginconfigurescreen',
        selector: 'alumniportalloginconfigurescreen'		
	}],	
	init: function(application) {
		this.control({
			'alumniPortalSetUpGrid':{
			afterrender:function(grid){
    				var $this = this;
    				$this.addDataGridConfigButton(grid,$this.getALUMNI_PORTAL_SET_UP_PERMISSIONS());
    				$this.doAccessControlValidation(grid, $this.getALUMNI_PORTAL_SET_UP_PERMISSIONS());
    				$this.disableMoreActionPivileges(grid,$this.getALUMNI_PORTAL_SET_UP_PERMISSIONS());

			},
				selectionchange: function(column, selected, eOpts ){  
					var $this = this            	
	            	var grid = $this.getAlumniPortalSetUpGrid();
	            	var gridSeletion = grid.getSelectionModel().getCount();
	            	if(grid.getSelectionModel().getCount()==1) { 
						grid.down('#btnEdit').setDisabled(false)
		            	grid.down('#btnDelete').setDisabled(false)
		            	
	            }
	            	else{
	            		grid.down('#btnEdit').setDisabled(true)
	                	grid.down('#btnDelete').setDisabled(true)                	
	            	}
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	                if(columnName == "countOfAL"){
	                    if(e.target.tagName=='A'){
	                        this.openApplyModal(record);
	                    }
	                }
	               }
			},
			'alumniPortalSetUpGrid button[itemId=btnAdd]':{
 				click:function(obj){ 
 					Ext.widget('alumniPortalSetUpNameWindow').show();
 				}},
			'alumniPortalSetUpGrid button[itemId=btnEdit]':{
				click:function(button, e, eOpts, id){            	
					this.editAlumniPortalSetUp(id,this.getALUMNI_PORTAL_SET_UP_PERMISSIONS())
					
				}},
				'alumniPortalSetUpGrid button[itemId=spBtnMoreActions] #btnRename':{
					click:function(){            	
						this.openRenameAlumniPortalSetupWindow()						
					}},
				'alumniPortalSetUpGrid button[itemId=btnDelete]':{
					click:function(id){ 
						this.deleteAlumniPortalSetup(id);
					}}, 
			'alumniPortalConfigurationGrid button[itemId=btnSavePrivilege]':{
				click:function(obj){
					this.saveAlumniPortalSetUp()
				}},
			'alumniPortalSetUpNameWindow button[itemId=btnSave]':{
 	            click: function(btn) {
 	            	var setUpNameValue = btn.up('form').down('#SetUpWindowItemId').getValue();
 	            	var createType = btn.up('form').down('#createType').getValue();
 	            	if (createType != null && createType == 'copy') {
 	            		this.copyAlumniPortalSetup(setUpNameValue);
					}else{
						this.openAlumniPortalSetUpConfigTab(setUpNameValue,this.getALUMNI_PORTAL_SET_UP_PERMISSIONS());  
					}
 	            	 btn.up('form').up('window').close();
 	            }
 	        },
 	       'addAlumniSetUpMappingGrid customcombobox#academylocationsearchcombo' : {
	 			  select:function(obj, record){
	 				 this.getAddAlumniSetUpMappingGrid().getStore().clearFilter();
	 				 this.getAddAlumniSetUpMappingGrid().getStore().filter({property: 'id',
						  value: record[0].get('id'),
						  exactMatch: true,
						  caseSensitive: true});
	 				var grid = this.getAddAlumniSetUpMappingGrid();
	 				var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
	 			  }
	 		  },
 	       'alumniPortalSetUpGrid button[itemId=spBtnMoreActions] #btnCopy': {
               click: function(button, e, eOpts, id) {
               	var me = this;
                   var grid =  me.getAlumniPortalSetUpGrid();
                   if (grid.getSelectionModel().getCount() >0) {
                	   //Ext.widget('alumniPortalSetUpNameWindow').show()
                   	 var window = me.getAlumniPortalSetUpNameWindow();
            			   if(!window){
            				   window = Ext.widget('alumniPortalSetUpNameWindow');
            				   window.down('#createType').setValue('copy');
            			   }
            			   window.show();
                   }else{
                   	showWarningMessage(getAlumni('ROLE_MSG_TITLE'), getAlumni('PLEASE_SELECT_RECORD'));
                   }
      			  
               }
           },
 	        'alumniPortalSetUpFilter button[itemId=submitBtn]':{
                click: function(cmp){
                	var me = this,
                	form = me.getAlumniPortalSetUpFilter(),
                	grid = me.getAlumniPortalSetUpGrid(),
                	formVal = form.getForm().getValues();                	
                	grid.getStore().getProxy().extraParams = {
                		alumniSetupId:formVal.alumniId,
                		createdById:formVal.createdBy,
                		academyLocationId:formVal.academyLocation,
                		startDate:formVal.createdStartDate,
                		endDate:formVal.createdEndDate,
					}
                	grid.getStore().load();                	
                }
            },
            'alumniPortalSetUpFilter button[itemId=resetBtn]':{ 
            	click: function(cmp){
                	var me = this,
                	form = me.getAlumniPortalSetUpFilter();
                	grid = me.getAlumniPortalSetUpGrid();
                	form.getForm().reset();              	
                }
            },
            'alumniPortalSetUpRenameWindow button[itemId=btnSave]' :{
            	click: function(btn, e, eOpts, id) {
	            	var setUpNameValue = btn.up('form').down('#SetUpWindowItemId').getValue();
	            	this.saveRenameAlumniPortalSetup(setUpNameValue);  
	            	 btn.up('form').up('window').close();
	            }
            },
        
            'addAlumniSetUpMappingGrid':{
                afterrender: function(cmp){ 
                	var mappinGrid = this.getAddAlumniSetUpMappingGrid()
        			mappinGrid.getStore().load();
                }
                },
            'addAlumniSetUpMappingGrid button[itemId=submitBtn]':{
                click: function(cmp){ 
                	this.submitAlumniSetupMapping();
                	}
                },
             'addAlumniSetUpMappingGrid button[itemId=resetBtn]':{
                click: function(cmp){ 
                	var grid = cmp.up('#addAlumniSetUpMappingGridItemId')
            			grid.getSelectionModel().deselectAll();
                	}
                },
            'applyToAlgrid':{
            	render: function(grid) {
            		var setupGrid = this.getAlumniPortalSetUpGrid()
            		var record = setupGrid.getSelectionModel().getSelection()[0];
        			var store = grid.getStore();
        			store.getProxy().extraParams = {
        				alumniSetupId:record.data.id
        			}
        			store.load();
                },
                selectionchange: function(column, selected, eOpts ){  
					var $this = this    
                	var grid = $this.getApplyToAlgrid();	            	
	            	if(grid.getSelectionModel().getCount()==1) { 
		            	grid.down('#btnDelete').setDisabled(false)		            	
	            	}
	            	else{
	                	grid.down('#btnDelete').setDisabled(true)                	
	            	}
                }
            },
            'applyToAlgrid button[itemId=btnAdd]':{
            	click: function(btn){ 
                	this.addAlumniPortalApplyTo(btn);
                }
            },
            'openApplyWindow button[itemId=btnDelete]':{
            	click: function(id){
                	this.deleteAlumniPortalApplyTo(id);
                }
            },
            'alumniPortalConfigurationGrid':{
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) { 
            		var  $this = this; 
 	        		var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		if(columnName == "additionalSetUp"){
 	        			if (e.target.tagName == 'A') { 
 	        				var setupForm = grid.up('alumniPortalConfiguration');
 	        				var containpanel = setupForm.down('tabpanel');
 	        				var tabName = record.data.moduleName;
 	        				var tabDetail = containpanel.items.items;
 	        				for(var i in tabDetail){
 	        					if(tabDetail[i].xtype!='fieldcontainer'){
 	        						tabDetail[i].close();
 	        					}
 	        				}
 	        				var configfeestructure = Ext.widget('alumniportalconfigureinnertab');
 	        				openTab(containpanel, tabName,configfeestructure);
 	        				var grid = $this.getAlumniportalconfigureinnergrid()
 	        				grid.getStore().getProxy().extraParams = {
 	        					alumniPortalSetupId:record.data.alumniPortalSetupId,
 	        					screenName:record.data.formAliasName,
 	        					screenMode:'Create, Edit, and View'
 	        				};
 	        				grid.getStore().load(); 
 	        				}
 	        			}            		
            	}
            },
            'alumniPortalSetupMappingAlertWin button[itemId=alumniSetupAlertBtn]':{
            	click : function(btn) {
            		var alertWin = this.getAlumniPortalSetupMappingAlertWin();
            		alertWin.close();
            	}
            },
            'alumniportalconfigureinnergrid':{
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var $this=this;
            		var searchResultGrid = $this.getAlumniportalconfigureinnergrid();
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
            		var selectedRecord = searchResultGrid.getSelectionModel().getSelection()[0];
            		
            		if(columnName=='helpText' && searchResultGrid.getSelectionModel().getSelection().length>0){ 
            			if(searchResultGrid.getSelectionModel().getSelection().length==1 &&  (record.data.formFieldId == selectedRecord.data.formFieldId)){

            				if (e.target.tagName == 'A') {
            					var formWindow = $this.getAlumniPortalSetupHelpTextWindow();
            					if (!formWindow) {
            						Ext.widget('alumniPortalSetupHelpTextWindow');
            						formWindow = $this.getAlumniPortalSetupHelpTextWindow();
            					}
            					formWindow.show();

            					var defaultHelpText = record.data.defaultHelpText;
            					var helpTextForm = $this.getAlumniPortalSetupHelpTextWindow().down('form').getForm();
            					helpTextForm.findField('defaultHelpText').setValue(defaultHelpText);

            					if(!isNullOrEmpty(record.data.helpText)){
            						helpTextForm.findField('helpText').setValue(record.data.helpText);
            					}
            				}
            			}else{
            				if(searchResultGrid.getSelectionModel().getSelection().length>1 ){
            					showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_ONLY_SINGLE_RECORD')); 
            				}
            				else if(record.data.formFieldId != selectedRecord.data.formFieldId){
            					showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_CURRENT_RECORD'));
            				}
            			}
            		}
            		else{

            			if(columnName=='helpText' && (!searchResultGrid.getSelectionModel().getSelection().length>0 || (record.data.formFieldId != selectedRecord.data.formFieldId)) )
            				showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD')); 

            		}
            	}
            },
            'alumniPortalSetupHelpTextWindow button[itemId=submitBtn]':{
            	click:function(obj){
            		var $this =this;
            		var form = obj.up('form').getForm();
            		var values = form.getValues();
            		var helpText =values.helpText;
            		var helpTextDefault = values.defaultHelpText
            		var grid = $this.getAlumniportalconfigureinnergrid();
            		var getRange = grid.getSelectionModel().selected.getRange();
            		getRange[0].set("helpText",helpText);
            		getRange[0].set("defaultHelpText",helpTextDefault);
            		if(getRange[0]!=null)
            		 {
            			showSuccessMessage(getAlumni('HELP_TEXT_SAVE'),getAlumni('SUCCESS')); 
            		}
            		$this.getAlumniPortalSetupHelpTextWindow().close();
            	}
            },
            'addAlumniSetUpMappingGrid button[itemId=resetBtn]':{
	 			  click:function(btn){
	 				  var tabStructure = this.getAddAlumniSetUpMappingGrid();
	 				  var activeGrid = tabStructure;
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				 if(activeGrid.down('customcombobox'))
   	 				 activeGrid.down('customcombobox').reset();
	 				activeGrid.getStore().load()
	 				
	 		  },
 		 },
 		 'alumniportalloginconfigurescreen': {
				afterrender: function(loginForm){
					var me = this;
					
					var idField = loginForm.down('[name=id]');
					var logoUrlHiddenField = loginForm.down('[name=logoUrlHidden]');
					var backgroundImgUrlHiddenField = loginForm.down('[name=backgroundImgUrlHidden]');
					var uploadIcon1UrlHiddenField = loginForm.down('[name=uploadIcon1UrlHidden]');
					var uploadIcon2UrlHiddenField = loginForm.down('[name=uploadIcon2UrlHidden]');
					var uploadIcon3UrlHiddenField = loginForm.down('[name=uploadIcon3UrlHidden]');
					var forgotPwdLogoUrlHiddenField = loginForm.down('[name=forgotPwdLogoUrlHidden]');
					var logoUrlField = loginForm.down('[name=logoUpload]');
					var backgroundImgUrlField = loginForm.down('[name=backgroundImageUpload]');
					var uploadIcon1UrlField = loginForm.down('[name=guidelineIcon1]');
					var uploadIcon2UrlField = loginForm.down('[name=guidelineIcon2]');
					var uploadIcon3UrlField = loginForm.down('[name=guidelineIcon3]');
					var forgotPwdLogoUrlField = loginForm.down('[name=forgotPasswordLogo]');
					var sameAsForgotPasswordPageField = loginForm.down('[name=sameAsForgotPasswordPage]');
					var welcomeMessageField = loginForm.down('[name=welcomeMessage]');
					var usernameLabelField = loginForm.down('[name=usernameLabel]');
					var passwordLabelField = loginForm.down('[name=passwordLabel]');
					var submitBtnLabelField = loginForm.down('[name=submitBtnLabel]');
					var otherLoginOptionsField = loginForm.down('[name=otherLoginOptions]');
					var customizeLabelField = loginForm.down('[name=customizeLabel]');
					var redirectionUrlsField = loginForm.down('[name=redirectionUrls]');
					var enableHowToUserGuideField = loginForm.down('[name=enableHowToUserGuide]');
					var howToGuideTitleTextField = loginForm.down('[name=howToGuideTitleText]');
					var guidelineLabel1Field = loginForm.down('[name=guidelineLabel1]');
					var guidelineUrl1Field = loginForm.down('[name=guidelineUrl1]');
					var guidelineLabel2Field = loginForm.down('[name=guidelineLabel2]');
					var guidelineUrl2Field = loginForm.down('[name=guidelineUrl2]');
					var guidelineLabel3Field = loginForm.down('[name=guidelineLabel3]');
					var guidelineUrl3Field = loginForm.down('[name=guidelineUrl3]');
					var forgotPasswordUsernameLabelField = loginForm.down('[name=forgotPasswordUsernameLabel]');
					var forgotPasswordLinkLabelField = loginForm.down('[name=forgotPasswordLinkLabel]');
					var capthaVerificationRequiredField = loginForm.down('[name=capthaVerificationRequired]');
					var captchaRedirectUrlField = loginForm.down('[name=captchaRedirectUrl]');
					var termsAndConditions = loginForm.down('[name=termsAndConditions]');
					
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var	submitUrl=SERVERURL.PATH_GET_ALL_ALUMNI_PORTAL_LOGIN_PAGE_SETUP;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						method : 'GET',
						success : function(response, action) {
							Ext.getBody().unmask();
							if(response.responseText != ''){
								var data = Ext.decode(response.responseText);
								var formData = data[0];
								
								idField.setValue(formData.id);
								logoUrlHiddenField.setValue(formData.logoUrl);
								backgroundImgUrlHiddenField.setValue(formData.backgroundImgUrl);
								uploadIcon1UrlHiddenField.setValue(formData.instructionIconUrl1);
								uploadIcon2UrlHiddenField.setValue(formData.instructionIconUrl2);
								uploadIcon3UrlHiddenField.setValue(formData.instructionIconUrl3);
								forgotPwdLogoUrlHiddenField.setValue(formData.forgetPasswordLogoUrl);
								logoUrlField.setRawValue(formData.logoUrl);
								backgroundImgUrlField.setRawValue(formData.backgroundImgUrl);
								uploadIcon1UrlField.setRawValue(formData.instructionIconUrl1);
								uploadIcon2UrlField.setRawValue(formData.instructionIconUrl2);
								uploadIcon3UrlField.setRawValue(formData.instructionIconUrl3);
								forgotPwdLogoUrlField.setRawValue(formData.forgetPasswordLogoUrl);
								sameAsForgotPasswordPageField.setValue(formData.sameASforgetPassword);
								welcomeMessageField.setValue(formData.welcomeMsg);
								usernameLabelField.setValue(formData.userNameLable);
								passwordLabelField.setValue(formData.passwordLable);
								submitBtnLabelField.setValue(formData.submitButtonLabel);
								otherLoginOptionsField.setValue(formData.isSSOLogin);
								customizeLabelField.setValue(formData.ssolableName);
								redirectionUrlsField.setValue(formData.ssoRedirectUrl);
								enableHowToUserGuideField.setValue(formData.isEnableUserGuide);
								howToGuideTitleTextField.setValue(formData.userGuideTitleText);
								guidelineLabel1Field.setValue(formData.instructionLableName1);
								guidelineUrl1Field.setValue(formData.instructionRedirctionUrl1);
								guidelineLabel2Field.setValue(formData.instructionLableName2);
								guidelineUrl2Field.setValue(formData.instructionRedirctionUrl2);
								guidelineLabel3Field.setValue(formData.instructionLableName3);
								guidelineUrl3Field.setValue(formData.instructionRedirctionUrl3);
								forgotPasswordUsernameLabelField.setValue(formData.forgetPasswordUserNameLable);
								forgotPasswordLinkLabelField.setValue(formData.forgetPasswordLinkLabel);
								 if(formData.isCaptchaApplicable) {
                                     capthaVerificationRequiredField.items.items[0].setValue(true);
                                     capthaVerificationRequiredField.items.items[1].setValue(false);
                                 } else {
                                     capthaVerificationRequiredField.items.items[0].setValue(false);
                                     capthaVerificationRequiredField.items.items[1].setValue(true);
                                 }
                                 
                                 if(formData.termsAndConditions) {
                                     termsAndConditions.setValue(true);
                                 } else {
                                     termsAndConditions.setValue(false);
                                 }
                                 
                                 
								captchaRedirectUrlField.setValue(formData.redirectUrl);
							}
						}
					});
				}
			},
			'alumniportalloginconfigurescreen filefield': {
    			change : function(fileField, value, eOpts) {
        	        this.onSelectUploadLoginFileField(fileField, value, eOpts);
        	    }
    		},
			'alumniportalloginconfigurescreen button[itemId=saveSPLoginConfigBtn]': {
				click: function(btn){
					var me = this;
					var form = btn.up('alumniportalloginconfigurescreen');
					me.saveLoginConfig(form)
				}
			},
			'alumniportalloginconfigurescreen button[itemId=resetSPLoginConfigBtn]': {
				click: function(btn){
					var me = this;
					var loginForm = btn.up('alumniportalloginconfigurescreen');
					
					loginForm.fireEvent('afterrender', loginForm);
				}
			},'alumniportalloginconfigurescreen displayfield[itemId=logoUploadLink]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getAlumniportalloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().logoUrlHidden
        					if(logoUrlHiddens){
        						var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        						});
        					}else{
        						showWarningMessage(getCommonTranslation('CONFIGURE_SCREEN'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
        					}
        				 
        		  });
				
				}
			},'alumniportalloginconfigurescreen displayfield[itemId=backgroundImageUploadLink]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getAlumniportalloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().backgroundImgUrlHidden
        					if(logoUrlHiddens){
        						var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        						});
        					}else{
        						showWarningMessage(getCommonTranslation('CONFIGURE_SCREEN'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
        					}
        				 
        		  });
				
				}
			},'alumniportalloginconfigurescreen displayfield[itemId=guidelineIcon1Link]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getAlumniportalloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().uploadIcon1UrlHidden
        					if(logoUrlHiddens){
        						var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        						});
        					}else{
        						showWarningMessage(getCommonTranslation('CONFIGURE_SCREEN'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
        					}
        				 
        		  });
				
				}
			},'alumniportalloginconfigurescreen displayfield[itemId=guidelineIcon2Link]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getAlumniportalloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().uploadIcon2UrlHidden
        					if(logoUrlHiddens){
        						var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        						});
        					}else{
        						showWarningMessage(getCommonTranslation('CONFIGURE_SCREEN'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
        					}
        				 
        		  });
				
				}
			},'alumniportalloginconfigurescreen displayfield[itemId=guidelineIcon3Link]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getAlumniportalloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().uploadIcon3UrlHidden
        					if(logoUrlHiddens){
        						var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        						});
        					}else{
        						showWarningMessage(getCommonTranslation('CONFIGURE_SCREEN'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
        					}
        				 
        		  });
				
				}
			},'alumniportalloginconfigurescreen displayfield[itemId=forgotPasswordLogoLink]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getAlumniportalloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().forgotPwdLogoUrlHidden
        					if(logoUrlHiddens){
        						var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        						});
        					}else{
        						showWarningMessage(getCommonTranslation('CONFIGURE_SCREEN'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
        					}
        				 
        		  });
				
				}
			},
			'alumniPortalSetUpStructure':{
				afterrender:function(structure){
    				var $this = this;
    				$this.disableConfigureScreenTabPivileges(structure,$this.getALUMNI_PORTAL_SET_UP_PERMISSIONS());

				}
			}
		});	
	},
	saveAlumniPortalConfigureScreenData:function(){
	 var $this = this;
	 var grid = $this.getAlumniportalconfigureinnergrid();
	 var academyLocationId; 
	 var languageId;
	 var screenMode;
	 var screenName;
	 var configureArray = [];
	 var submitUrl;
	 var selectedRecord = grid.getSelectionModel().getSelection().length;
	 if(selectedRecord > 0){
		 var totalCount = grid.getStore().data.length;
		 var record = grid.getSelectionModel().getSelection();
		 var isSequenceDefined = true;
		 var sequenceNullFieldName = '';
			 for(var i=0;i<record.length;i++){
				 var isVisible;
				 var isVisibleField = record[i].data.isVisible;
				 if(isVisibleField == null || isVisibleField == 'Yes'){
					 isVisible = true;
				 }else{
					 isVisible = false;
				 }
				 
				 var isMendate;
				 var isMendateField = record[i].data.isMandatory;
				 if(isMendateField == null || isMendateField == 'Optional'){
					 isMendate = false;
				 }else if(isMendateField == true || isMendateField == 'Mandatory'){
					 isMendate = true;
				 }else if (isMendateField == false) {
					 isMendate = false;
				}
				if (record[i].data.sequenceNo == null || record[i].data.sequenceNo == undefined ||
						record[i].data.sequenceNo == '') {
					isSequenceDefined = false;
					sequenceNullFieldName = record[i].data.fieldDisplayName;
				}

				 configureArray.push({
					 "formFieldId": record[i].data.formFieldId,
					 "formFieldDisplaySettingId": record[i].data.formFieldDisplaySettingId,
					 "screenName": record[i].data.screenName,
					 "screenMode": record[i].data.screenMode,
					 "defaultLabel": record[i].data.defaultLabel,
					 "fieldDisplayName": record[i].data.fieldDisplayName,
					 "isFieldLocked": record[i].data.isFieldLocked,
					 "isMandatory": isMendate,
					 "isVisible": isVisible,
					 "languageId":1,
					 "helpText": record[i].data.helpText,
					 "defaultHelpText":record[i].data.defaultHelpText,
					 "defaultValue": record[i].data.defaultValue,
					 "alumniportalsetupid": record[i].data.alumniportalsetupid,
					 "newLabel":record[i].data.newLabel,
					 "whetherForAllAcademyLocation":false,
					 "sequenceNo":record[i].data.sequenceNo
				 });
			 }
			 
			 if (isSequenceDefined) {
				/* if(record[0].data.screenName == 'Personal Details Info'){
					 $this.getAppSetupDynamicForFormFieldsInfo(null);  
				 }*/
				 submitUrl = SERVERURL.CONFIGURE_SCREEN_SAVE;
				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 Ext.Ajax.request({
					 type : 'rest',
					 url : submitUrl,
					 async: false,
					 jsonData : configureArray,
					 method : 'POST',
					 success : function(form, action) {
						 Ext.getBody().unmask();
						 showSuccessMessage(getCommonTranslation('ALUMNI_PORTAL_CONFIGURATION'),getCommonTranslation('SUCCESS'));
						 grid.getStore().reload();
						 //$this.getContentPanelActiveTab().close()
					 },
					 failure: function(res, action) {
						 showWarningMessage(getCommonTranslation('ALUMNI_PORTAL_NOT_CONFIGURATION'),getCommonTranslation('UNSUCCESS'));
		                 Ext.getBody().unmask();
		                }
				 });
			}else{
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_ENTER_SEQUENCE')+' For '+sequenceNullFieldName); 
			}
	  } 
 else{
		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
  }
	 },

	disableMoreActionPivileges: function(gridReference,permissionsMap) {
		var $this = this;
    	var associatedAcadLocationIds = new Array();

    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var saveBtn = gridReference.down('#spBtnMoreActions');
    	saveBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'MOREACTIONS') {
    			if(!isNullOrEmpty(saveBtn)){
    				saveBtn.setVisible(true);
    			}        		
    		}
    	});
    },
	getIdValueJson: function(id, value) {
		if (id) return {
				id: id,
				value: value
			};
	},
	copyAlumniPortalSetup: function(setUpNameValue){
		  var $this=this;
//		  var myjson ={  
//    				"setupName":setUpNameValue
//    			};
			  var grid =  $this.getAlumniPortalSetUpGrid();
				 var record = grid.getSelectionModel().getSelection()[0];
				 if (record.raw!=null && record.raw.id) {
	            	var alumniPortalSetupId=record.get("id")
	            	 Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
	            	 Ext.Ajax.request({
	                     type: 'rest',
	                     method: 'GET',
	                     url: SERVERURL.PATH_ALUMNI_PORTAL_SETUP_COPY,
	                     params:{
	                    	 oldSetupId:alumniPortalSetupId,
	                    	 setupName : setUpNameValue
						   },
						   success : function(response, action) {
							   Ext.getBody().unmask();
							  var id = response.responseText;
			                	if(id != "0"){
			                		Ext.Ajax.request({
			                           type: 'rest',
			                           method: 'GET',
			                           url: SERVERURL.PATH_ALUMNI_PORTAL_SETUP_COPY ,
			                           params:{
			                        	   alumniPortalSetupId:id
			      					   },
			      					   success : function(response, action) {
			      						   var jsonData = Ext.JSON.decode(response.responseText);
			      						   Ext.getBody().unmask();
			      						   var contentpanel = $this.getContentPanel();
			      						   var tabName = getAlumni('ALUMNI_PORTAL_CONFIGURATION');
			      						   var getcontroller = $this.getController('menu.CoreERPNavigationController');			      						 
			      						 showSuccessMessage(getAlumni('ALUMNI'), getAlumni('ALUMNI_COPIED_SUCCESS'));
			      						 applicantPortalSetUpGrid.getStore().loadData(jsonData)
			      					   }			      					   
			                       });
			                	}else{
			                		showWarningMessage(getAlumni('ALUMNI_PORTAL_CONFIGURATION'), getAlumni('PLEASE_ENTER_UNIQUE_SETUP_NAME'));
			                	}
							  grid.getStore().reload();
						   }
	                 });
				 }
			  },
	submitAlumniSetupMapping: function(cmp){
		var $this = this
		var alertWin = this.getAlumniPortalSetupMappingAlertWin();
    	var tabStructure = $this.getAddAlumniSetUpMappingGrid();
    	var portalSetUpGridId =  $this.getAlumniPortalSetUpGrid().getSelectionModel().getSelection()
    	var selectedRecord = tabStructure.getSelectionModel().getSelection();
    	var submitJsonArr = [];
    	if(selectedRecord.length>0){
	    		selectedRecord.forEach(function(obj){
	    			submitJsonArr.push({
	    				alumniPortalSetup: {id:portalSetUpGridId[0].data.id},
	    				academyLocation: {id:obj.get('id')},
	    			});
	    		})
    		
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: SERVERURL.PATH_SAVE_ALUMNI_PORTAL_APPLY_TO_MAPPING,
    			//scope:this,
    			jsonData:submitJsonArr,
    			success : function(response, action) {
    				var contentpanel = $this.getContentPanel();
    		    	var tabName = getAlumni('ADD_ALUMNI_SETUP_MAPPING');
    		    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
    		    	var getTab=getcontroller.getTab(tabName);
    		    	if(getTab!=null){
    		    		contentpanel.remove(getTab, true);
    		    	}
    		    	var grid = $this.getAlumniPortalSetUpGrid();
    		    	var grdStore = grid.getStore();
    		    	grdStore.load();    		    	
    		    	var data = response.responseText;
          			if(isNullOrEmpty(data)){
          				showSuccessMessage(getAlumni('ALUMNI_FOR'), getAlumni('APPLY_TO_CREATED_SUCCESS'));          				
              			contentpanel.remove(getTab, true);
              			grid.getSelectionModel().deselectAll()
          				
          			} else {          				
          				if(!alertWin){
          					alertWin = Ext.widget('alumniPortalSetupMappingAlertWin');
          				}
          				alertWin.down('#alumniSetupAlertItemId').setValue(data);
          				alertWin.show();
          			}
    			}
    		});
    	} else {
    		showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
    	}    		
	},
	saveAlumniPortalSetUp: function() {
		var this$ = this;
		var contentpanel = this$.getContentPanel();
    	var tabName = getAlumni('ALUMNI_PORTAL_CONFIGURATION');
    	var getcontroller=this$.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
		var setUpGrid = this$.getAlumniPortalConfigurationGrid();
        var portalSetUpForm = this$.getAlumniPortalConfiguration();
        var alumniPortalSetUpGrid = this$.getAlumniPortalSetUpGrid();
        var portalSetUpGridId =  alumniPortalSetUpGrid.getSelectionModel().getSelection()   
    	var records = setUpGrid.getStore().data.items;
    	var setupRec = portalSetUpGridId[0];
        var alumniPortalSetupIdGetVal = portalSetUpForm.down('#setUpId').getValue();
        if(records.length > 0) {
        	var alumniPortalModuleSetup = new Array();
        	if(!isNullOrEmpty(records[0].data.alumniPortalModules)){
    	    	Ext.each(records, function(obj) {	
    	    		if(obj.data.moduleCode == 'STEP1_DASHBOARD' || obj.data.moduleCode == 'STEP2_MYPROFILE' || obj.data.moduleCode == 'STEP8_PERSONAL_INFORMATION' || obj.data.moduleCode == 'STEP9_PROFESSIONAL_INFORMATION'
    	    			|| obj.data.moduleCode == 'STEP10_EDUCATION_DETAIL' || obj.data.moduleCode == 'STEP11_ADDRESS' || obj.data.moduleCode == 'STEP12_NOTIFICATIONS'){
    	    			obj.data.visibility = true;      				  
      			 }
    	    	 if(obj.data.moduleCode == 'STEP1_DASHBOARD' || obj.data.moduleCode == 'STEP2_MYPROFILE'){
    	    			obj.data.visibility = true;      				  
      			 }
    	    		alumniPortalModuleSetup.push({
         				"id" : obj.data.id, 
         				"alumniPortalModules":{id:obj.data.alumniPortalModules.id},
         				"alumniPortalSetup":{id:portalSetUpGridId[0].data.id},
         				"visibility":obj.data.visibility == '' ? false : true,
         				"mandatory":'',
         				"sequenceNo":obj.data.sequenceNo,
         				"newModuleName":'',
         			});
    	    	})
    	    	var recordsToUpdate = Ext.encode(alumniPortalModuleSetup);
    	        Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
    	        Ext.Ajax.request({
    	            type: 'rest',
    	            method: 'POST',
    	            url: SERVERURL.PATH_ALUMNI_PORTAL_SAVE_MODULE_SETUP,
    	            jsonData: recordsToUpdate,
    	            success : function(response, action) {
    	            	var jsonData = Ext.JSON.decode(response.responseText);
    	            	var response = response.responseText;
    	            	Ext.getBody().unmask();
    	            	showSuccessMessage(getAlumni('ALUMNI_PORTAL_CONFIGURATION'), getAlumni('SUCCESS'));	            	
    	            	contentpanel.remove(getTab, true);
    	            	alumniPortalSetUpGrid.getStore().load()
//    	            	if(setUpGrid.getStore().getRange().length>0){
//    	            		setUpGrid.getStore().removeAll();
//    	            	}
    	            	setUpGrid.getStore().loadData(jsonData);
    	            }
    	        });            
        	}
        	else{
	    	Ext.each(records, function(obj) {
	    		if(obj.data.moduleCode == 'STEP1_DASHBOARD' || obj.data.moduleCode == 'STEP2_MYPROFILE' || obj.data.moduleCode == 'STEP12_NOTIFICATIONS'){
	    			obj.data.visibility = true;      				  
  			 }
	    		alumniPortalModuleSetup.push({     				
	    			"alumniPortalModules":this$.getIdValueJson(obj.data.id),
     				"alumniPortalSetup":this$.getIdValueJson(alumniPortalSetupIdGetVal),
     				"visibility":obj.data.visibility == '' ? false : true,
     				"mandatory":'',
     				"sequenceNo":obj.data.sequenceNo,
     				"newModuleName":'',
     			});
	    	})
	    	var recordsToUpdate = Ext.encode(alumniPortalModuleSetup);
	        Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
	        Ext.Ajax.request({
	            type: 'rest',
	            method: 'POST',
	            url: SERVERURL.PATH_ALUMNI_PORTAL_SAVE_MODULE_SETUP,
	            jsonData: recordsToUpdate,
	            success : function(response, action) {
	            	var jsonData = Ext.JSON.decode(response.responseText);
	            	var response = response.responseText;
	            	Ext.getBody().unmask();
	            	showSuccessMessage(getAlumni('ALUMNI_PORTAL_CONFIGURATION'), getAlumni('SUCCESS'));	            	
	            	contentpanel.remove(getTab, true);
	            	alumniPortalSetUpGrid.getStore().load()
//	            	if(setUpGrid.getStore().getRange().length>0){
//	            		setUpGrid.getStore().removeAll();
//	            	}
	            	setUpGrid.getStore().loadData(jsonData);
	            }
	        });
        }	
    	}
    },
	addAlumniPortalApplyTo: function(btn){
		var $this = this;
		var contentpanel = $this.getContentPanel();
		var openApplyWindow = $this.getOpenApplyWindow()
		var addAlumniSetUpMapping = Ext.widget('addAlumniSetUpMappingStructure'); 
      	var tabName = getAlumni('ADD_ALUMNI_SETUP_MAPPING');
      	var getcontroller=this.getController('menu.CoreERPNavigationController');
      	var getAlumniMappingTab=getcontroller.getTab(getAlumni('ADD_ALUMNI_SETUP_MAPPING'));
      	if(getAlumniMappingTab!=null){
      		contentpanel.remove(getAlumniMappingTab, true);
      	}
      	openTab(contentpanel, tabName, addAlumniSetUpMapping, CONSTANTS.MENU_COLOR_FIVE); 
      	openApplyWindow.close()
	},
	deleteAlumniPortalApplyTo:function(id){
		 var me = this;
			 var grid = me.getApplyToAlgrid();
			 var openApplyWindow = me.getOpenApplyWindow()
			 var alumniPortalSetUpGrid =me.getAlumniPortalSetUpGrid()
			 var grdStore = grid.getStore();
			 if (grid.getSelectionModel().getCount() > 0) {
				 var records = grid.getSelectionModel().getSelection();
				if(!isNullOrEmpty(records[0])){
					showConfirmMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('DELETE_CONFIRM_MESSAGE_TO_AL'), function(btn, text) {
						 if (btn == 'yes') {
							 var id = records[0].get("id");
							 Ext.Ajax.request({
								 method: "DELETE",
								 type: 'rest',
								 url: SERVERURL.PATH_ALUMNI_DELETE_PORTAL_SETUP+'?id='+id, 
								 headers: {
									 'Content-Type': 'application/json'
								 },
								 success: function(form, action) {
									 grid.getSelectionModel().deselectAll();
				       				  grdStore.load();
									 showSuccessMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('ALUMNI_PORTAL_SETUP_DELETED'));
									 openApplyWindow.close()
									 alumniPortalSetUpGrid.getStore().load()
								 }
							 });
						 }
					 });
			}
			else{
				 showWarningMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('CAN_NOT_DELETE_INACTIVE_SETUP')); //Please select a record
			}
				 
			 } else {
				 showWarningMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('PLEASE_SELECT_RECORD')); //Please select a record
			 } 
		 
	},
	deleteAlumniPortalSetup:function(id){
		 var me = this;
			 var grid = this.getAlumniPortalSetUpGrid();
			 var grdStore = grid.getStore();
			 if (grid.getSelectionModel().getCount() > 0) {
				 var records = grid.getSelectionModel().getSelection();
				if(!isNullOrEmpty(records[0].get("mappingStatus")) && records[0].get("status") == true){
					showConfirmMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						 if (btn == 'yes') {
							 var id = records[0].get("id");
							 Ext.Ajax.request({
								 method: "DELETE",
								 type: 'rest',
								 url: SERVERURL.PATH_ALUMNI_DELETE_PORTAL_SETUP+'?setupId='+id, 
								 headers: {
									 'Content-Type': 'application/json'
								 },
								 success: function(form, action) {
									 grid.getSelectionModel().deselectAll();
				       				  grdStore.load();
									 showSuccessMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('ALUMNI_PORTAL_SETUP_DELETED'));
								 }
							 });
						 }
					 });
			}else{
				 showWarningMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('CAN_NOT_DELETE_INACTIVE_SETUP')); //Please select a record
			}
				 
			 } else {
				 showWarningMessage(getAlumni('ALUMNI_PORTAL_SETUP'), getAlumni('PLEASE_SELECT_RECORD')); //Please select a record
			 } 
		 },
	openAlumniPortalSetUpConfigTab: function(setUpNameValue,permissionsMap){
        var $this = this;
        var myjson ={  
 				"setupName":setUpNameValue
 			};  
        Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            method: 'post',
            url: SERVERURL.PATH_ALUMNI_PORTAL_SETUP_CREATE,
            jsonData: myjson,
            success : function(response, action) {
            	Ext.getBody().unmask();
            	var id = response.responseText;
            	if(id != "0"){
            		var contentpanel = $this.getContentPanel();
                	var tabName = getAlumni('ALUMNI_PORTAL_CONFIGURATION');
                	var getcontroller = $this.getController('menu.CoreERPNavigationController');
                	var getAlumniPortal=getcontroller.getTab(getAlumni('ALUMNI_PORTAL_CONFIGURATION'));
                	var getTab = getcontroller.getTab(tabName);
                	if (getTab != null) {
                		contentpanel.remove(getTab, true);
                	}
                	var contentXtype = 'alumniPortalConfiguration'; 
                	var newTab = $this.getTabReferenceByTabTitle(tabName);
                	if (!newTab) {
                		newTab = contentpanel.add({
                			xtype: contentXtype,
                			closable: true,
                			title: tabName,
                			menuColorCls: CONSTANTS.MENU_COLOR_TWO
                		});
                	}
                	contentpanel.setActiveTab(newTab);
                	var alumniPortalConfigurTab = newTab.down('#alumniPortalSetupInnerTabItemId');
                	alumniPortalConfigurTab.tab.setText(setUpNameValue);
                	var setUpIdField = newTab.down('#setUpId');
                	setUpIdField.setValue(id);

//                	var window = Ext.widget('alumniPortalSetUpNameWindow');
//  				    window.down('#saveBtn').setDisabled(true);
//                     
                	var alumniPortalConfGrid = newTab.down('#alumniPortalConfigurationGridItemId');
                	alumniPortalConfGrid.getSelectionModel().deselectAll();
                	alumniPortalConfGrid.getStore().getProxy().extraParams={
						id:1
					};
                	alumniPortalConfGrid.getStore().load(); 
                	var grid = $this.getAlumniPortalSetUpGrid();
                	grid.getStore().reload();
                	
            	}else{
            		showWarningMessage(getAlumni('ALUMNI_PORTAL_CONFIGURATION'), getAdmissionTranslation('PLEASE_ENTER_UNIQUE_SETUP_NAME'));
            	}
            	
            }
        });
	},
	editAlumniPortalSetUp: function(recordId, permissionsMap){	
    	var $this=this;
    	var contentpanel = $this.getContentPanel();
        var grid =  this.getAlumniPortalSetUpGrid();        
        if (grid.getSelectionModel().getCount()>0) {
            var record = grid.getSelectionModel().getSelection()[0];
            if (record.raw!=null && record.raw.id) {
            	var alumniPortalSetupId=record.get("id")
            	 Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
                 Ext.Ajax.request({
                     type: 'rest',
                     method: 'GET',
                     url: SERVERURL.PATH_ALUMNI_PORTAL_SETUP_FIND_BY_GRID_NAME ,
                     params:{
                    	 alumniPortalSetupId:record.get("id")
					   },
					   success : function(response, action) {
						   var jsonData = Ext.JSON.decode(response.responseText);
						   Ext.getBody().unmask();	
						   var tabName = getAlumni('ALUMNI_PORTAL_CONFIGURATION');
						   var getcontroller = $this.getController('menu.CoreERPNavigationController');
						   var getTab = getcontroller.getTab(tabName);
						   if (getTab != null) {
							   contentpanel.remove(getTab, true);
						   }
						   var contentXtype = 'alumniPortalConfiguration'; 
						   var newTab = $this.getTabReferenceByTabTitle(tabName);
						   if (!newTab) {
							   newTab = contentpanel.add({
								   xtype: contentXtype,
								   closable: true,
								   title: tabName,
								   menuColorCls: CONSTANTS.MENU_COLOR_TWO
							   });
						   }
						   contentpanel.setActiveTab(newTab);
						   var alumnitPortalSetupTab = newTab.down('#alumniPortalSetupInnerTabItemId');
						   alumnitPortalSetupTab.tab.setText(record.data.setupName);
						   var alumniPortalSetUpGrid = newTab.down('#alumniPortalConfigurationGridItemId');
						   if(alumniPortalSetUpGrid.getStore().getRange().length>0){
							   alumniPortalSetUpGrid.getStore().removeAll();
						   }
						   alumniPortalSetUpGrid.getStore().loadData(jsonData);
						   var setUpIdField = newTab.down('#setUpId');
						   setUpIdField.setValue(alumniPortalSetupId);
						   //alumniPortalSetUpGrid.getStore().load()
//						   var programStore = alumniPortalSetUpGrid.getStore();
//			    			programStore.load({
//			    				callback: function(records, operation, success) {
////			    					var data = Ext.decode(response.responseText);
////			    					programStore.loadData(data);
//			    					programStore.getProxy().extraParams = {
//			                           // 'scholarshipId': record.get('ID'),
//			    						alumniPortalSetupd:record.get("id")
//			    						   
//			                        };
//			    					programStore.load();
//			    				}	   
//			    			});
			    			
						  // var setUpIdField = newTab.down('#setUpId');
						   //setUpIdField.setValue(alumniPortalSetupId);
						   //var newR = response.request.id
///
					   }
                 });
            } 
            } else{
            	showWarningMessage(getAlumni('ROLE_MSG_TITLE'), getAlumni('PLEASE_SELECT_RECORD'));
            }      
},
	openRenameAlumniPortalSetupWindow :function(){
		var $this = this;
		var grid = $this.getAlumniPortalSetUpGrid();
		if (grid.getSelectionModel().getCount() == 1) {
			var record = grid.getSelectionModel().getSelection()[0];
			var setupname =record.data.setupName;
			var formwindow = Ext.widget('alumniPortalSetUpRenameWindow');
			formwindow.show();
		    formwindow.down('#SetUpWindowItemId').setValue(setupname);
		}else{
			showWarningMessage(getAlumni('ALUMNI_SETUP_MAPPING'), getAlumni('PLEASE_SELECT_RECORD')); //Please select a record   
		}
},
	saveRenameAlumniPortalSetup: function(setUpNameValue){
        var $this = this;
    	var setUpGrid = $this.getAlumniPortalSetUpGrid();
		var record = setUpGrid.getSelectionModel().getSelection()[0];
		var setupid =record.data.id;
        var myjson ={  
 				"setupName":setUpNameValue,
 				"id":setupid,
 			};  
        Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: SERVERURL.PATH_ALUMNI_UPDATE_PORTAL_SETUP,
            jsonData: myjson,
            success : function(response, action) {
            	Ext.getBody().unmask();
            	var message = response.responseText;
            	if(message != null && message == 'Success'){
            		showSuccessMessage(getAlumni('ALUMNI_PORTAL_CONFIGURATION'), getAlumni('ALUMNI_SETUP_NAME_UPDATED_SUCCESSFULLY'));
            		setUpGrid.getStore().reload();
            		setUpGrid.getSelectionModel().deselectAll();
            		}else{
            		showWarningMessage(getAlumni('ALUMNI_PORTAL_CONFIGURATION'), getAdmissionTranslation('PLEASE_ENTER_UNIQUE_SETUP_NAME'));
            	}            	
            }
        });
	},
	openApplyModal: function(record){
		Ext.widget('openApplyWindow').show()		
	},
	onSelectUploadLoginFileField: function (fileField, value, eOpts) {
	    if (!isNullOrEmpty(value)) {
	        var alumniportalloginconfigurescreen = fileField.up('alumniportalloginconfigurescreen');
	        if(fileField.fileInputEl.dom.files.length==0)
	        	{
	        	return;
	        	}
	        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
	        value = value.replace('C:\\fakepath\\', '');
            var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            fileField.setRawValue(newValue);
	        // Validate file extension
	        if ((extension === "gif") || (extension === "png") || (extension === "bmp") || 
	            (extension === "jpeg") || (extension === "jpg")) {
	            var submitUrl = SERVERURL.PATH_UPLOAD_STUDENT_PORTAL_IMG;

	            // Create a runtime form dynamically
	            var tempForm = Ext.create('Ext.form.Panel', {
	                standardSubmit: false,
	                renderTo: Ext.getBody(), // Render form to the body
	                layout: 'fit',
	                hidden: true,
	                items: [
	                    {
	                        xtype: 'filefield',
	                        name: 'file',
	                        inputType: 'file',
	                        listeners: {
	                            afterrender: function (field) {
	                                field.fileInputEl.dom.files = fileField.fileInputEl.dom.files; // Sync the selected file
	                            }
	                        }
	                    },
	                    {
	                        xtype: 'hiddenfield',
	                        name: 'entityId',
	                        value: '110'
	                    },
	                    {
	                        xtype: 'hiddenfield',
	                        name: 'module',
	                        value: 'login_page_setup'
	                    },
	                    {
	                        xtype: 'hiddenfield',
	                        name: 'entityType',
	                        value: 'student_responsive_login_page'
	                    }
	                ]
	            });

	            // Submit the form
	            tempForm.getForm().submit({
	                url: submitUrl,
	                method: 'POST',
	                enctype: 'multipart/form-data', // Necessary for file upload
	                clientValidation: false,
	                success: function (form, action) {
	                    // Update corresponding hidden fields based on the fileField name
	                    if (fileField.name === "logoUpload") {
	                    	alumniportalloginconfigurescreen.down('[name=logoUrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "backgroundImageUpload") {
	                    	alumniportalloginconfigurescreen.down('[name=backgroundImgUrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "guidelineIcon1") {
	                    	alumniportalloginconfigurescreen.down('[name=uploadIcon1UrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "guidelineIcon2") {
	                    	alumniportalloginconfigurescreen.down('[name=uploadIcon2UrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "guidelineIcon3") {
	                    	alumniportalloginconfigurescreen.down('[name=uploadIcon3UrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "forgotPasswordLogo") {
	                    	alumniportalloginconfigurescreen.down('[name=forgotPwdLogoUrlHidden]').setValue(action.result.path);
	                    }
	                	// Destroy the temporary form after submission
	    	            tempForm.destroy();
	                },
	                failure: function (form, action) {
	    	            fileField.reset();
	    	            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getCommonTranslation('FILE_UPLOAD_FAILED'));
	    	            tempForm.destroy();
	                }
	            });

	            
	        } else {
	            fileField.reset();
	            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
	        }
	    }
	},
	saveLoginConfig: function(loginForm){
		var me = this;
		
		var idField = loginForm.down('[name=id]');
		var logoUrlHiddenField = loginForm.down('[name=logoUrlHidden]');
		var backgroundImgUrlHiddenField = loginForm.down('[name=backgroundImgUrlHidden]');
		var uploadIcon1UrlHiddenField = loginForm.down('[name=uploadIcon1UrlHidden]');
		var uploadIcon2UrlHiddenField = loginForm.down('[name=uploadIcon2UrlHidden]');
		var uploadIcon3UrlHiddenField = loginForm.down('[name=uploadIcon3UrlHidden]');
		var forgotPwdLogoUrlHiddenField = loginForm.down('[name=forgotPwdLogoUrlHidden]');
		var sameAsForgotPasswordPageField = loginForm.down('[name=sameAsForgotPasswordPage]');
		var welcomeMessageField = loginForm.down('[name=welcomeMessage]');
		var usernameLabelField = loginForm.down('[name=usernameLabel]');
		var passwordLabelField = loginForm.down('[name=passwordLabel]');
		var submitBtnLabelField = loginForm.down('[name=submitBtnLabel]');
		var otherLoginOptionsField = loginForm.down('[name=otherLoginOptions]');
		var customizeLabelField = loginForm.down('[name=customizeLabel]');
		var redirectionUrlsField = loginForm.down('[name=redirectionUrls]');
		var enableHowToUserGuideField = loginForm.down('[name=enableHowToUserGuide]');
		var howToGuideTitleTextField = loginForm.down('[name=howToGuideTitleText]');
		var guidelineLabel1Field = loginForm.down('[name=guidelineLabel1]');
		var guidelineUrl1Field = loginForm.down('[name=guidelineUrl1]');
		var guidelineLabel2Field = loginForm.down('[name=guidelineLabel2]');
		var guidelineUrl2Field = loginForm.down('[name=guidelineUrl2]');
		var guidelineLabel3Field = loginForm.down('[name=guidelineLabel3]');
		var guidelineUrl3Field = loginForm.down('[name=guidelineUrl3]');
		var forgotPasswordUsernameLabelField = loginForm.down('[name=forgotPasswordUsernameLabel]');
		var forgotPasswordLinkLabelField = loginForm.down('[name=forgotPasswordLinkLabel]');
		var capthaVerificationRequiredField = loginForm.down('[name=capthaVerificationRequired]');
		var captchaRedirectUrlField = loginForm.down('[name=captchaRedirectUrl]');
		var termsAndConditions = loginForm.down('[name=termsAndConditions]');

		if(capthaVerificationRequiredField.getValue()){
			var captchaFieldVal = capthaVerificationRequiredField.getValue();
			var isCaptcha = captchaFieldVal.capthaVerificationRequired;
		}
		else{
			var isCaptcha = false;
		}

		var submitData = {
		    "id": idField.getValue(),
		    "logoUrl": logoUrlHiddenField.getValue(),
		    "backgroundImgUrl": backgroundImgUrlHiddenField.getValue(),
		    "sameASforgetPassword": sameAsForgotPasswordPageField.getValue(),
		    "welcomeMsg": welcomeMessageField.getValue(),
		    "userNameLable": usernameLabelField.getValue(),
		    "passwordLable": passwordLabelField.getValue(),
		    "submitButtonLabel": submitBtnLabelField.getValue(),
		    "isSSOLogin": otherLoginOptionsField.getValue(),
		    "ssolableName": customizeLabelField.getValue(),
		    "ssoRedirectUrl": redirectionUrlsField.getValue(),
		    "isEnableUserGuide": enableHowToUserGuideField.getValue(),
		    "userGuideTitleText": howToGuideTitleTextField.getValue(),
		    "instructionIconUrl1": uploadIcon1UrlHiddenField.getValue(),
		    "instructionLableName1": guidelineLabel1Field.getValue(),
		    "instructionRedirctionUrl1": guidelineUrl1Field.getValue(),
		    "instructionIconUrl2": uploadIcon2UrlHiddenField.getValue(),
		    "instructionLableName2": guidelineLabel2Field.getValue(),
		    "instructionRedirctionUrl2": guidelineUrl2Field.getValue(),
		    "instructionIconUrl3": uploadIcon3UrlHiddenField.getValue(),
		    "instructionLableName3": guidelineLabel3Field.getValue(),
		    "instructionRedirctionUrl3": guidelineUrl3Field.getValue(),
		    "forgetPasswordLogoUrl": forgotPwdLogoUrlHiddenField.getValue(),
		    "forgetPasswordUserNameLable": forgotPasswordUsernameLabelField.getValue(),
		    "forgetPasswordLinkLabel": forgotPasswordLinkLabelField.getValue(),
		    "isCaptchaApplicable": isCaptcha,
		    "redirectUrl": captchaRedirectUrlField.getValue(),
		    "termsAndConditions": termsAndConditions.getValue()
		}

		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var	submitUrl=SERVERURL.PATH_UPDATE_ALUMNI_PORTAL_LOGIN_PAGE_SETUP;
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : submitData,
			method : 'POST',
			success : function(form, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getCommonTranslation('CONFIGURE_SCREEN'),getCommonTranslation('SUCCESS'));
				loginForm.fireEvent('afterrender', loginForm);
			}
		});
	},
	disableConfigureScreenTabPivileges: function(structureReference, permissionsMap) {
		var me = this;
		var tabStructure = structureReference.down('tabpanel');
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'CONFIGURE_SCREEN') {
				var tabName= getCommonTranslation('CONFIGURE_SCREEN');
				var contentXtype ='alumniportalloginconfigurescreen';
				var itemId='alumniportalloginconfigurescreenItemId';

				var	newTab = tabStructure.add({
					xtype: contentXtype,
					closable: false,
					title: tabName,
					itemId:itemId
				});
			}
		});
	},
});