/**
 * @author Deepak S
 */
Ext.define('Academia.controller.campaignnew.CampaignNewController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['campaignnew.CampaignTypeStore','campaignnew.PresentationTypeStore','campaignnew.ModeOfDeliveryStore','campaignnew.RegistrationTypeStore',
			'campaignnew.PresentationSubTypeStore','campaignnew.SchoolPriorityStore','campaignnew.CampaignStatusStore','user.UserAcademyLocationStore',
			'resourceutilization.ActiveUserStore','common.CountryStore','campaignnew.CampaignSchoolStore','campaignnew.CampaignNewUserALStore',
			'campaignnew.CampaignNewGridStore','campaignnew.CampaignNameFilterStore','campaignnew.CampaignOpenComboStore','campaignnew.CampaignNewALStore',
			'campaignnew.LeadsCapturedStore','campaignnew.CampaignNewSchoolALStore','importutility.ImportEnquiryCampaignStore','common.ModeOfDeliveryStore'],
	requires: ['Ext.ux.LinkedTagField'],
	views: ['campaignnew.CampaignNewStructure','campaignnew.CampaignNewFilter','campaignnew.CampaignNewGrid','campaignnew.CampaignNewFormLayout',
		'examinationcenters.questionPaperBank.MeetingDocumentGrid','campaignnew.CampaignNewALGrid','campaignnew.CampaignNewALWindow','campaignnew.LeadsCapturedTabStructure','campaignnew.LeadsCapturedGrid',
		'campaignnew.CampaignNewSchoolALWindow','campaignnew.CampaignNewSchoolALGrid','campaignnew.ImportListEnquiryCampaignGrid','campaignnew.EnquiryCampaignUploadForm','campaignnew.EnquiryCampaignUploaddownloadStructure',
		'campaignnew.EnquiryCampaignDownloadForm','campaignnew.UploadOptionRadioGroupCampaign'],
		config: {
			  CAMPAIGN_NEW_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TERTIARY_MANAGE_CAMPAIGN_PRIVILEGES'),
			  CAPTURE_LEAD_CAMPAIGN_NEW_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CAPTURELEAD_MANAGE_CAMPAIGN_PRIVILEGES'),
			  ENQUIRY_IMPORT_CAMPAIGN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_IMPORT_CAMPAIGN_UTILITY_PRIVILEGES'),
			},
	refs: [{
    	ref : 'contentPanel',
    	selector : 'contentPanel' 
    },{
  	  ref: 'campaignnewstructure',
	  selector: 'campaignnewstructure'
  }, {
	  ref: 'campaignnewfilter',
	  selector: 'campaignnewfilter'
  }, {
	  ref: 'campaignnewgrid',
	  selector: 'campaignnewgrid'
  }, {
	  ref: 'campaignnewalwindow',
	  selector: 'campaignnewalwindow'
  }, {
	  ref: 'campaignnewschoolalwindow',
	  selector: 'campaignnewschoolalwindow'
  }, {
	  ref: 'campaignnewalgrid',
	  selector: 'campaignnewalgrid'
  },{
	  ref: 'campaignnewformlayout',
	  selector: 'campaignnewformlayout'
  },{
  	ref :'meetingdocumentgrid',
	selector : 'meetingdocumentgrid[itemId=documentsGridCampaignNew]'
},{
  	ref :'leadscapturedgrid',
	selector : 'leadscapturedgrid'
},{
  	ref :'leadsCapturedTab',
	selector : 'leadsCapturedTab'
}, {
    ref: 'importlistenquirycampaigngrid',
    selector: 'importlistenquirycampaigngrid'
}, {
    ref: 'enquirycampaignuploadform',
    selector: 'enquirycampaignuploadform'
}, {
    ref: 'enquirycampaignuploaddownloadstructure',
    selector: 'enquirycampaignuploaddownloadstructure'
}, {
    ref: 'enquirycampaigndownloadform',
    selector: 'enquirycampaigndownloadform'
},{
	ref : 'enquirycampaignuploadoptionradiogroup',
	selector : 'uploadoptionradiogroupcampaign[itemId=enquiryCampaignUploadOptionRadioGroupItemId]'
}],
	init: function(application) {
		this.control({
			
			'campaignnewfilter customcombobox#campaignTypeId' : {
    			select : function(obj, record) {
    				var $this = this;
    				var idVal = record[0].get("id");
    				var formLayout = $this.getCampaignnewfilter();
    				var presentationTypeCombo= $this.getCampaignnewfilter().down('#presentationTypeId');
    				presentationTypeCombo.reset();
    				presentationTypeCombo.setDisabled(false);
    				var presentationTypeStore = presentationTypeCombo.getStore();
    				presentationTypeStore.getProxy().extraParams = {
    					campaignType: idVal
    				};
    				presentationTypeStore.load();
    				
    				var multiBrandCampusCombo= formLayout.down('#multiBrandCampusId');
    				var alids=[];
    				var academyLocationId = multiBrandCampusCombo.getValue();
					var academyLocationIds = null;
					var intakeYearId= formLayout.down('#intakeYearId');

					if(!isNullOrEmpty(academyLocationId)){
						if(academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])){
							for (var i in academyLocationId) {
								if (Ext.isObject(academyLocationId[0])) {
									alids.push(academyLocationId[i].get("id"));
								} else {
									alids.push(academyLocationId[i]);
								}
							}
							academyLocationIds = alids.join();
						}
						else{
							academyLocationIds = academyLocationId;
						}
					} 
    				var campaignNameCombo= formLayout.down('#campaignNameId');
    				var campaignNameComboStore = campaignNameCombo.getStore();
    				campaignNameComboStore.getProxy().extraParams = {
    					campaignType: idVal,
    					intakeYearId: intakeYearId.getValue(),
    					academyLocationIds:academyLocationIds
    				};
    				campaignNameComboStore.load();
    				campaignNameCombo.lastQuery=null;
    			}
    		},
    		'campaignnewfilter customcombobox#presentationTypeId' : {
    			select : function(obj, record) {
    				var $this = this;
    				var idVal = record[0].get("id");
    				var formLayout = $this.getCampaignnewfilter();
    				
    				var multiBrandCampusCombo= formLayout.down('#multiBrandCampusId');
    				var alids=[];
    				var academyLocationId = multiBrandCampusCombo.getValue();
					var academyLocationIds = null;

					if(!isNullOrEmpty(academyLocationId)){
						if(academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])){
							for (var i in academyLocationId) {
								if (Ext.isObject(academyLocationId[0])) {
									alids.push(academyLocationId[i].get("id"));
								} else {
									alids.push(academyLocationId[i]);
								}
							}
							academyLocationIds = alids.join();
						}
						else{
							academyLocationIds = academyLocationId;
						}
					} 
					
					var campaignTypeCombo= formLayout.down('#campaignTypeId');
					var campaignTypeVal = campaignTypeCombo.getValue();
					var intakeYearId= formLayout.down('#intakeYearId');
					
    				var campaignNameCombo= formLayout.down('#campaignNameId');
    				var campaignNameComboStore = campaignNameCombo.getStore();
    				campaignNameComboStore.getProxy().extraParams = {
    					campaignType: campaignTypeVal,
    					presentationType: idVal,
    					intakeYearId: intakeYearId.getValue(),
    					academyLocationIds:academyLocationIds
    				};
    				campaignNameComboStore.load();
    				campaignNameCombo.lastQuery=null;
    			}
    		},
    		'campaignnewfilter button[itemId=resetBtn]':{
    			click: this.resetCampaignFilter
    		},
    		'campaignnewfilter button[itemId=searchBtn]':{
    			click: this.searchCampaignFilter
    		},
    		'campaignnewfilter multiselectcombofield[itemId=multiBrandCampusId]': {
    			render: function(){
    				var $this = this;
    				var formLayout = $this.getCampaignnewfilter();
    				var academyLocationId = this.getCurrentAcademyLocation();
    				var multiBrandCampusId = formLayout.down('#multiBrandCampusId');
    				var ALComboStore = multiBrandCampusId.getStore();
    				ALComboStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   multiBrandCampusId.setValue(academyLocationId);
							   }
						   }
					});
    				var schoolPriorityId= formLayout.down('#schoolPriorityId');
    				schoolPriorityId.reset();
    				var schoolProxy = schoolPriorityId.getStore().getProxy();
    				delete schoolProxy.extraParams.academyLocationIds;
    				delete schoolProxy.extraParams.intakeYearId;
    				delete schoolProxy.extraParams.schoolId;
    			},
    			change : function(obj, record) {
    				var $this = this;
    				var formLayout = $this.getCampaignnewfilter();
    				var campaignNameCombo= formLayout.down('#campaignNameId');
    				var alids=[];
					if(record.length>0){
						for (var i in record) {
							if(Ext.isObject(record[i])){
								alids.push(record[i].get('id'));
							}
							else{
								alids.push(record[i]);	
							}
        				}
					}
					var campaignTypeCombo= formLayout.down('#campaignTypeId');
					var campaignTypeVal = campaignTypeCombo.getValue();
					
					var presentationTypeCombo= formLayout.down('#presentationTypeId');
					var presentationTypeVal = presentationTypeCombo.getValue();
					
					var intakeYearId= formLayout.down('#intakeYearId');
					var schoolId= formLayout.down('#schoolId');
					var schoolPriorityId= formLayout.down('#schoolPriorityId');
					
    				var campaignNameComboStore = campaignNameCombo.getStore();
    				campaignNameComboStore.getProxy().extraParams = {
    					campaignType: campaignTypeVal,
    					presentationType: presentationTypeVal,
    					intakeYearId: intakeYearId.getValue(),
    					academyLocationIds: alids.join()
    				};
    				campaignNameComboStore.load();
    				campaignNameCombo.lastQuery=null;
    				
    				var ownerCombo= formLayout.down('#ownerId');
    				ownerCombo.reset();
    				var ownerComboStore = ownerCombo.getStore();
    				ownerComboStore.getProxy().extraParams = {
    					academyLocationIds: alids.join()
    				};
    				ownerComboStore.load();
    				ownerCombo.lastQuery=null;
    				
    				schoolPriorityId.reset();
    				$this.setSchoolPriority();
    				
    				var schoolIdStore = schoolId.getStore();
    				if(record.length>0 && !isNullOrEmpty(intakeYearId.getValue())){
    					schoolIdStore.getProxy().extraParams = {
    						academyLocationIds: alids.join(),
    						intakeYearId: intakeYearId.getValue()
        				};
    					schoolIdStore.load();
						schoolId.setDisabled(false);
    				}
    				else{
    					schoolId.setDisabled(true);
    				}
    			}
            },
            'campaignnewfilter customcombobox[itemId=intakeYearId]': {
    			change : function(obj, record) {
    				var $this = this;
    				$this.setSchoolPriority();
    			},
    			select : function(obj, record) {
    				var $this = this;
    				var formLayout = $this.getCampaignnewfilter();
    				var campaignNameCombo= formLayout.down('#campaignNameId');
    				var campaignNameComboStore = campaignNameCombo.getStore();
					var multiBrandCampusCombo= formLayout.down('#multiBrandCampusId');
    				var alids=[];
    				var academyLocationId = multiBrandCampusCombo.getValue();
					var academyLocationIds = null;
					
					var campaignTypeCombo= formLayout.down('#campaignTypeId');
					var campaignTypeVal = campaignTypeCombo.getValue();
					
					var presentationTypeCombo= formLayout.down('#presentationTypeId');
					var presentationTypeVal = presentationTypeCombo.getValue();
					
					if(!isNullOrEmpty(academyLocationId)){
						if(academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])){
							for (var i in academyLocationId) {
								if (Ext.isObject(academyLocationId[0])) {
									alids.push(academyLocationId[i].get("id"));
								} else {
									alids.push(academyLocationId[i]);
								}
							}
							academyLocationIds = alids.join();
						}
						else{
							academyLocationIds = academyLocationId;
						}
					}
    				campaignNameComboStore.getProxy().extraParams = {
    					campaignType: campaignTypeVal,
    					presentationType: presentationTypeVal,
    					intakeYearId: obj.getValue(),
    					academyLocationIds:academyLocationIds
    				};
    				campaignNameComboStore.load();
    				
    				var schoolId = formLayout.down('#schoolId');
    				var schoolIdStore = schoolId.getStore();
    				if(!isNullOrEmpty(academyLocationId)){
    					schoolIdStore.getProxy().extraParams = {
    						academyLocationIds: academyLocationIds,
    						intakeYearId: obj.getValue()
        				};
    					schoolIdStore.load();
						schoolId.setDisabled(false);
    				}
    			}
            },
            'campaignnewfilter customcombobox[itemId=schoolId]': {
    			select : function(obj, record) {
    				var $this = this;
    				$this.setSchoolPriority();
    			}
            },
			'campaignnewgrid button[itemId=btnAdd]':{
    			click: this.addCampaignNew
    		},
    		'campaignnewgrid button[itemId=btnEdit]':{
    			click:function(btn) {
    				this.editCampaignNew('EDIT');
    			}
    		},
    		'campaignnewgrid button[itemId=btnView]':{
    			click:function(btn) {
    				this.editCampaignNew('VIEW');
    			}
    		},
    		'campaignnewgrid button[itemId=btnDelete]':{
    			click: this.deleteRecord
    		},
			'campaignnewgrid button[itemId=btnCaptureLead]':{
				click: function(button) {
					var $this=this;
					var grid = $this.getCampaignnewgrid();
					var records=grid.getSelectionModel();
					 if (records.getCount() > 0) {
						 var record=records.getSelection()[0];
						 if(record.get('status').toLowerCase()=='open' || (!isNullOrEmpty(record.get('presentationType')) && record.get('presentationType')=='USSD'
							 && record.get('status')=='COMPLETED')){
    				          this.oprenCreateEnquiry(record.data.id,record);
						 }
						 else if(record.get('status').toLowerCase()=='cancelled'){
					        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('LEAD_CANNOT_BE_CAPTURED_FOR_A_CAMPAIGN_WITH_CANCELLED_STATUS')); 

						 }
						 else{
					        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('LEAD_CANNOT_BE_CAPTURED_FOR_A_CAMPAIGN_WITH_COMPLETED_STATUS')); 

						 }
					 }else {
				        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
				            
				        }
    				//e.stopEvent();
    				//e.stopPropagation();
    				return false;
    			}
    		},
    		'campaignnewformlayout textfield[itemId=code]': {
  			  blur : function(response) {
  				  this.checkUniquenessForCampaignNewCode(response);
					}
  		  },
    		'campaignnewgrid':{
    			render: function(grid) {
    				var me = this;
    				var buttonsToolBar = grid.query('toolbar')[0];
    		    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    		    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    		    	pdftoolbar.setDisabled(true);
    		    	exceltoolbar.setDisabled(true);
    				
    				var academyLocationId = me.getCurrentAcademyLocation();
    				var gridStore = grid.getStore();
    				gridStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				};
    				gridStore.load({
   			    	  callback: function(records, operation, success) {
  						if(records.length>0){
  					    	pdftoolbar.setDisabled(false);
  					    	exceltoolbar.setDisabled(false);
  						}
  					  }
    				});
    				me.doAccessControlValidation(grid, me.getCAMPAIGN_NEW_PERMISSIONS());
    				me.disableMoreActionPivileges(grid, me.getCAMPAIGN_NEW_PERMISSIONS());
    			},
    			afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getCAMPAIGN_NEW_PERMISSIONS());
    				},1500);

    			},
    			cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
    			    if (e.target.tagName == 'A') {
    			        var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
    			        var $this = this;
    			        var grid = $this.getCampaignnewgrid();
        				var records=grid.getSelectionModel();
        	            var columnName = grid.columnManager.columns[ColIdx].dataIndex;
    			        if (dataIndex == 'noOfAcademyLocCount') {
    			            var formWindow = $this.getCampaignnewalwindow();
    			            if (!formWindow) {
    			                Ext.widget('campaignnewalwindow');
    			                formWindow = $this.getCampaignnewalwindow();
    			                formWindow.setHeight(300);
    			                formWindow.setWidth(600);
    			            }
    			            $this.openCampaignNewALWindow(formWindow, dataIndex, record);
    			        } else if (columnName == "noOfEnquiryCount") {
        	            	var contentpanel = $this.getContentPanel();
            	            var tabName = getCommonTranslation('MANAGE_CAMPAIGN_LEADS_CAPTURED');
        	                var campaignnewstructure=$this.getCampaignnewstructure();
        	            	var leadsCapturedTab = Ext.widget("leadsCapturedTab");

        	            	openTab(contentpanel, tabName, leadsCapturedTab,CONSTANTS.MENU_COLOR_ONE);
        	                
        	            } else if (dataIndex == 'noOfSchoolCount') {
    			            var formWin = $this.getCampaignnewschoolalwindow();
    			            if (!formWin) {
    			            	formWin = Ext.widget('campaignnewschoolalwindow');
    			                formWin.setHeight(300);
    			                formWin.setWidth(600);
    			            }
    			            $this.openCampaignNewSchoolALWindow(formWin, dataIndex, record);
    			        }
    			    }
    			    
    			    
    			  
    			}
    		},
    		'campaignnewformlayout customcombobox#campaignTypeId' : {
    			render: function(combo){
    				var $this = this;
    				var formLayout = $this.getCampaignnewformlayout();
    				var store = combo.getStore();
    				store.load();
    			},
    			select : function(obj, record) {
    				var $this = this;
    				var idVal = record[0].get("id");
    				var formLayout = $this.getCampaignnewformlayout();    				
    				var presentationTypeCombo= $this.getCampaignnewformlayout().down('#presentationTypeId');
    				presentationTypeCombo.reset();
    				presentationTypeCombo.setDisabled(false);
    				var presentationTypeStore = presentationTypeCombo.getStore();
    				presentationTypeStore.getProxy().extraParams = {
    					campaignType: idVal
    				};
    				presentationTypeStore.load();
    				$this.showHideCampaignFormFields("CAMPAIGN_TYPE_RESET");
    				$this.setAcademyLocationAndOwnerDefault();
    			},
    			change : function(obj, record) {
    				var formLayout = this.getCampaignnewformlayout();
    				var campaignNumber = formLayout.down('#campaignNumber');
    				var campTypeVal = record;
    				if(campTypeVal == 'SCHOOL_PRESENTATION'){
    					campaignNumber.setVisible(true);
    					campaignNumber.allowBlank = false;
    				}
    				else{
    					campaignNumber.setVisible(false);
    					campaignNumber.allowBlank = true;
    				}
    			}
    		},
    		'campaignnewformlayout customcombobox[itemId=brandCampusId]': {
    			render: function(combo) {
    				var me = this;
    				var store = combo.getStore();
    				var academyLocationId = this.getCurrentAcademyLocation();
    				store.getProxy().extraParams = {
    					id: me.getCurrentlyLoggedInUser().id
    				};
    				store.load({
    					callback: function(records, operation, success) {
    						if (success) {
    							combo.setValue(academyLocationId);
    						}
    					}
    				});
    			},
    			select : function(obj, record) {
    				var $this = this;
    				var idVal = record[0].get("id");
    				var formLayout = $this.getCampaignnewformlayout();
    				var ownerCombo= formLayout.down('#ownerId');
    				var loggedInUserId = $this.getCurrentlyLoggedInUser().id;
    				ownerCombo.reset();
    				var ownerComboStore = ownerCombo.getStore();
    				ownerComboStore.getProxy().extraParams = {
    					academyLocationIds: idVal
    				};
    				ownerComboStore.load({
    					callback: function(records, operation, success) {
    						ownerCombo.setValue(loggedInUserId);
    					}
    				});
    				var intakeYearIdCombo= formLayout.down('#intakeYearId');
    				var campaignNameIdCombo= formLayout.down('#campaignNameId');
            		var schoolPriorityIdCombo= formLayout.down('#schoolPriorityId');
            		var schoolIdCombo= formLayout.down('#schoolId');
    				if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
    					schoolIdCombo.setDisabled(false);
    				}
    				schoolIdCombo.reset();
    				schoolPriorityIdCombo.reset();
    				campaignNameIdCombo.reset();
    				
    				var presentationTypeCombo= formLayout.down('#presentationTypeId');
            		var pType = presentationTypeCombo.getValue();
            		var selectedSchool = formLayout.down('#selectedSchoolId');
					selectedSchool.clearValue();
					selectedSchool.valueStore.removeAll();
    				if(pType == "ACTIVATIONS" || pType == "OPEN_DAY"){
            			var schoolId1 = formLayout.down('#schoolId1');
            			var store = schoolId1.getStore();
            			if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
            				schoolId1.setDisabled(false);
            				store.getProxy().extraParams = {
        						academyLocationIds: idVal,
        						intakeYearId: intakeYearIdCombo.getValue()
            				};
    						store.load();
        				}
            		}
    				else if(pType == "PPC" || pType == "PFMG" || pType == "PMG" || pType == "GR11"){
    					var store = schoolIdCombo.getStore();
    					if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
    						store.getProxy().extraParams = {
        						academyLocationIds: idVal,
        						intakeYearId: intakeYearIdCombo.getValue()
            				};
    						store.load();
        				}
    				}
    				//$this.prefilledCampaignName(obj);
    			}
            },
            'campaignnewformlayout customcombobox[itemId=intakeYearId]': {
            	render: function(combo) {
    				var me = this;
    				var store = combo.getStore();
    				store.load();
    			},
            	select : function(field, value) {
            		var $this = this;
    				var formLayout = $this.getCampaignnewformlayout();
            		var presentationTypeCombo= formLayout.down('#presentationTypeId');
            		var pType = presentationTypeCombo.getValue();
            		if(pType == "PPC" || pType == "PFMG" || pType == "PMG" || pType == "GR11"){
            			var brandCampusIdCombo= formLayout.down('#brandCampusId');
                		var schoolIdCombo= formLayout.down('#schoolId');
                		var campaignNameIdCombo= formLayout.down('#campaignNameId');
                		var schoolPriorityIdCombo= formLayout.down('#schoolPriorityId');
            			if(!isNullOrEmpty(brandCampusIdCombo.getValue())){
        					schoolIdCombo.setDisabled(false);
        				}
        				schoolIdCombo.reset();
        				schoolPriorityIdCombo.reset();
        				campaignNameIdCombo.reset();
        				
        				var store = schoolIdCombo.getStore();
    					if(!isNullOrEmpty(brandCampusIdCombo.getValue())){
    						store.getProxy().extraParams = {
        						academyLocationIds: brandCampusIdCombo.getValue(),
        						intakeYearId: field.getValue()
            				};
    						store.load();
        				}
            		}
            		else{
                		var schoolPriority1Id= formLayout.down('#schoolPriority1Id');
                		var selectedSchool = formLayout.down('#selectedSchoolId');
    					selectedSchool.clearValue();
    					selectedSchool.valueStore.removeAll();
                		schoolPriority1Id.reset();
                		
                		if(pType == "ACTIVATIONS" || pType == "OPEN_DAY"){
                			var schoolId1 = formLayout.down('#schoolId1');
                			var brandCampusIdCombo= formLayout.down('#brandCampusId');
                			var store = schoolId1.getStore();
                			if(!isNullOrEmpty(brandCampusIdCombo.getValue())){
                				schoolId1.setDisabled(false);
                				store.getProxy().extraParams = {
            						academyLocationIds: brandCampusIdCombo.getValue(),
            						intakeYearId: field.getValue()
                				};
        						store.load();
            				}
                		}
                		if(pType == "ADVERTISEMENT" || pType == "WORKSHOPS" || pType == "THIRD_PARTY" || pType == "CAREER_FAIR" || pType == "DIGITAL_ADVERTISING" || pType == "USSD"){
                			var brandCampusIdCombo= formLayout.down('#multiBrandCampusId');
                			var schoolId1 = formLayout.down('#schoolId1');
                			var store = schoolId1.getStore();
                			var academyLocationId = brandCampusIdCombo.getValue();
                			var alids = [];
        					if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
        						for (var i in academyLocationId) {
        							if (Ext.isObject(academyLocationId[0])) {
        								alids.push(academyLocationId[i].get("id"));
        							} else {
        								alids.push(academyLocationId[i]);
        							}
        						}
        						schoolId1.setDisabled(false);
        						store.getProxy().extraParams = {
            						academyLocationIds: alids.join(),
            						intakeYearId: field.getValue()
                				};
        						store.load();
        					}
        					else{
        						if(!isNullOrEmpty(academyLocationId) && !isNaN(academyLocationId)){
        							schoolId1.setDisabled(false);
            						store.getProxy().extraParams = {
                						academyLocationIds: academyLocationId,
                						intakeYearId: field.getValue()
                    				};
            						store.load();
                		}
            		}
                		}
            		}
    				//this.prefilledCampaignName(field);
    			}
            },
            'campaignnewformlayout customcombobox[itemId=statusId]': {
            	select : function(field, value) {
    				this.checkCampaignLeadCaptured(field);
    			}
            },
            'campaignnewformlayout customcombobox[itemId=mobileCountryCodeId]': {
            	render: function(combo) {
    				var me = this;
    				var store = combo.getStore();
    				store.load();
    			},
    			select: function(rowModel, record){
    				var this$ = this;
                	var form = this$.getCampaignnewformlayout();
                	var countryCodeField = form.down("#mobileCountryCodeId");
                 	var mobileField = form.down("#mobileNumberId");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    			}
    			//V2D-101236
            	/*change : function(field, record) {
            		var $this = this;
            		if(!isNullOrEmpty(field.valueModels) && field.valueModels.length>0){
            			var formLayout = $this.getCampaignnewformlayout();
            			var mobileNumberId = formLayout.down('#mobileNumberId');
            			var minVal = field.valueModels[0].get('minimumDigit');
                		var maxVal = field.valueModels[0].get('maximumDigit');
                		if(!isNullOrEmpty(minVal) && !isNullOrEmpty(maxVal)){
                			mobileNumberId.reset();
                			this.setMinMaxLengthOnMobile(mobileNumberId,parseInt(minVal),parseInt(maxVal));
                		}
            		}
    			}*/
            },
            'campaignnewformlayout customcombobox[itemId=mobileNumberId]': {
            	change: function(record){
    				var this$ = this;
                	var personProfile = this$.getCampaignnewformlayout();
                	var mobileField = form.down("#mobileNumberId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'campaignnewformlayout multiselectcombofield[itemId=schoolPriority1Id]': {
            	render: function(field){
            		var $this = this;
            		$this.multiselectMouseOverEvent(field);
            	}
            },
            'campaignnewformlayout multiselectcombofield[itemId=multiBrandCampusId]': {
            	render: function(field){
            		var $this = this;
            		$this.multiselectMouseOverEvent(field);
            	},
    			beforerender: function(combo) {
    				var $this = this;
    				var store = combo.getStore();
    				store.getProxy().extraParams = {
    					id: $this.getCurrentlyLoggedInUser().id
    				};
    				store.load();
    			},
    			change : function(obj, record) {
    				var $this = this;
    				//var idVal = record[0].get("id");
    				var formLayout = $this.getCampaignnewformlayout();
    				var loggedInUserId = $this.getCurrentlyLoggedInUser().id;
    				var ownerCombo= formLayout.down('#ownerId');
    				var presentationTypeId= formLayout.down('#presentationTypeId');
    				var schoolPriority1Id= formLayout.down('#schoolPriority1Id');
    				ownerCombo.reset();
    				var alids=[];
					if(record.length>0){
						for (var i in record) {
							if(Ext.isObject(record[i])){
								alids.push(record[i].get('id'));
							}
							else{
								alids.push(record[i]);	
							}
        				}
    				var ownerComboStore = ownerCombo.getStore();
    				ownerComboStore.getProxy().extraParams = {
    					academyLocationIds: alids.join()
    				};
	    				ownerComboStore.load({
	    					callback: function(records, operation, success) {
	    						ownerCombo.setValue(loggedInUserId);
	    					}
	    				});
					}
    				if(presentationTypeId.getValue()=="THIRD_PARTY" || presentationTypeId.getValue()=="CAREER_FAIR" || presentationTypeId.getValue()=="USSD"){
    					schoolPriority1Id.reset();
    					var selectedSchool = formLayout.down('#selectedSchoolId');
    					selectedSchool.clearValue();
    					selectedSchool.valueStore.removeAll();
    					if(record.length == 0){
    						schoolPriority1Id.reset();
    					}
    				}
    				
    				var intakeYearIdCombo= formLayout.down('#intakeYearId');
    				if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
    					var schoolIdCombo= formLayout.down('#schoolId');
    					schoolIdCombo.setDisabled(false);
    					
    					var schoolId1= formLayout.down('#schoolId1');
        				if(record.length>0){
            				schoolId1.setDisabled(false);
            				var store = schoolId1.getStore();
            				store.getProxy().extraParams = {
        						academyLocationIds: alids.join(),
        						intakeYearId: intakeYearIdCombo.getValue()
            				};
    						store.load();
    						
        				}
        				else{
            				schoolId1.setDisabled(true);
        				}
        				var selectedSchool = formLayout.down('#selectedSchoolId');
    					selectedSchool.clearValue();
    					selectedSchool.valueStore.removeAll();
    				}
    			}
            },
            'campaignnewformlayout customcombobox#presentationTypeId' : {
            	change: function(field, newValue, oldValue, eOpts){
                	this.changePresentationType(field, newValue, oldValue, eOpts);
                },
                select: function(){
                	this.setAcademyLocationAndOwnerDefault();
                }
    		},
    		'campaignnewformlayout customcombobox#presentationSubTypeId' : {
            	change: function(field, newValue, oldValue, eOpts){
                	this.changePresentationSubType(field, newValue, oldValue, eOpts);
                }
    		},
    		'campaignnewformlayout linkedtagfield#selectedSchoolId' : {
            	render: function(field){
            		var $this = this;
            		var campaignNewFormLayout = $this.getCampaignnewformlayout();
            		$this.multiselectMouseOverEvent(field);
    				field.valueStore.on('remove',function(store, record, index, isMove, eOpts){
    					var formLayout = $this.getCampaignnewformlayout();
    					var schoolPriority1Id = formLayout.down('#schoolPriority1Id');
    					var intakeYearId = formLayout.down('#intakeYearId');
    					var multiBrandCampusId = formLayout.down('#multiBrandCampusId');
    					var alids=[];
    					var academyLocationId = multiBrandCampusId.getValue();
    					var academyLocationIds = null;
    					var schoolLength = store.data.keys.length;
    					if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    						for (var i in academyLocationId) {
    							if (Ext.isObject(academyLocationId[0])) {
    								alids.push(academyLocationId[i].get("id"));
    							} else {
    								alids.push(academyLocationId[i]);
    							}
    						}
    						academyLocationIds = alids.join();
    					}
    					if(!isNullOrEmpty(academyLocationIds) && !isNullOrEmpty(intakeYearId.getValue())){
    						if(schoolLength>0){
    							schoolPriority1Id.getStore().getProxy().extraParams = {
        							academyLocationIds: academyLocationIds,
        							intakeYearId:intakeYearId.getValue(),
        							schoolId:store.data.keys.join(),
        							isFirstCall: false
        			    		};
        						schoolPriority1Id.getStore().load({
        							callback: function(records, operation, success) {
        								   if (success) {
    										   if(records.length == 1 || records.length > 1){
    											   //schoolPriority1Id.reset();
    											   var priorityData = [];
    											   if(records.length == 1){
    												   schoolPriority1Id.setValue(records[0]);   
    											   }
    											   else{
    												   records.forEach(function(obj){
    													   priorityData.push(obj.data.id);
    												   });
    												   schoolPriority1Id.setValue(priorityData);
    											   }
    										   }
        								   }
        							   }
        						});
    						}
    						else{
    							schoolPriority1Id.reset();
    						}
    					}
    				});
                }
    		},
    		'campaignnewformlayout button[itemId=campaignResetButtonId]': {
    			click: this.resetCampaignFormPanelData
    		},
    		'campaignnewformlayout button[itemId=btnSaveCampaignNewForm]': {
    			click: this.saveCampaignFormPanelData
    		},
    		'campaignnewformlayout customcombobox#schoolId' : {
            	select: function(obj, record){
            		this.prefilledCampaignName(obj);
                }
    		},
    		/*'campaignnewformlayout customcombobox#schoolPriorityId' : {
            	select: function(obj, record){
            		this.prefilledCampaignName();
                }
    		},*/
    		'campaignnewformlayout customcombobox#schoolId1' : {
            	select: function(obj, record){
                	this.addSelectedSchoolItem(obj, record);
                }
    		},
    		'campaignnewformlayout button#meetingDocsCampaignId' : {
    			click : function() {
    				this.getDocumentController().showDocumentFormWindow('campaignItemId','DOCUMENT');
    			}
    		},
    		'campaignnewformlayout datefield#startDateId' : {
    			select : function(field, value) {
    				this.prefilledCampaignName();
    			}
    		},
    		'campaignnewformlayout textfield[itemId=venueId]': {
            	blur : function(field, value) {
    				this.prefilledCampaignName();
    			}
            },
            'campaignnewformlayout textfield[itemId=noCampaignId]': {
            	blur : function(field, value) {
    				this.prefilledCampaignName();
    			}
            },
            'campaignnewformlayout textfield[itemId=campaignNumber]': {
            	keyup : function(field, value, eOpts) {
            		var formLayout = this.getCampaignnewformlayout();
            		var schoolId = formLayout.down('#schoolId');
            		var presentationTypeFld = formLayout.down('#presentationTypeId');
            		var pType = presentationTypeFld.getValue();
            		if(pType == "PPC" || pType == "PFMG" || pType == "PMG" || pType == "GR11"){
            			this.prefilledCampaignName(schoolId);
            		}
    			}
            },
            'documentformwindow[itemId=campaignItemId] simpledocumentform[itemId=simpleDocumentForm] filefield[itemId=uploadFileField]': {
                change: function(fileField, value, eOpts){
                	var $this = this;
                	value = value.replace('C:\\fakepath\\', '');
                	fileField.setRawValue(value);
                	var $this = this;
 				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
                	if (!isNullOrEmpty(value)) {
                		 Ext.getBody().unmask();
            	        var file = fileField.fileInputEl.dom.files[0];
            	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
            	            fileField.reset();
            	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_fOR_ADD_CAMPAIGN_DOCUMENT'));
            	            return false;
            	        }
                	}
                }
            },
            
    		'documentformwindow[itemId=campaignItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
                click: function() {
                    var $this = this;
                    var isTransient = true;
                    var module = 'preadmission';
                    var entityId;
                    var entityType = 'itemdocument';
                    var entryType = 'campaign';

                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
                    	var documentModel = new Academia.model.course.QuestionPaperDocument();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("documentName", response.name);
                        documentModel.set("isNewRecord", true);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));

                       
                        var documentGrid = $this.getMeetingdocumentgrid();
                        var store = documentGrid.getStore();
                        store.add(documentModel);
                        if (documentGrid.isHidden() && store.data.items.length > 0) {
                            documentGrid.setVisible(true);
                        }
                        Ext.apply(documentGrid, {
                            code: null,
                            setCode: function(code) {
                                documentGrid.code = code;
                            },
                            getCode: function() {
                                return documentGrid.code;
                            }
                        });
                        documentGrid.setCode(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'documentformwindow[itemId=campaignItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId': {
                click: function() {
                    this.getDocumentController().closeDocumentFormWindow();
                }
            },
            'meetingdocumentgrid[itemId=documentsGridCampaignNew]': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getMeetingdocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("ecrptydocumentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                    e.preventDefault();
                    e.stopPropagation();
                }
            },
            'meetingdocumentgrid[itemId=documentsGridCampaignNew] button[itemId=btnDelete]':{
            	click:function(){
            		var $this = this;
            		var grid = $this.getMeetingdocumentgrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			showConfirmMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            				if (btn == 'yes') {
            					if (grid.getSelectionModel().getCount() > 0) {
            						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            						var records = grid.getSelectionModel().getSelection();
            						var id = records[0].get("documentId");
            						if(!isNullOrEmpty(id)){
            							Ext.Ajax.request({
            								method : "DELETE",
            								type : 'rest',
            								url : SERVERURL.PATH_DELETE_CAMPAIGN_NEW_DOC + '?id=' + id,
            								headers : {
            									'Content-Type' : 'application/json'
            								},
            								success : function(form,action) {
            									Ext.getBody().unmask();
            									grid.getStore().reload();
            									showSuccessMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
            									//$this.getMeetingdocumentgrid().getStore().reload();
            								}
            							});
            						}
            						else{
            							grid.getStore().remove(records);
            							Ext.getBody().unmask();
            							showSuccessMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
            						}
            					}
            				}
            			});
            		} else {
            			showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}
            	}
    		},
    		'leadscapturedgrid':{
    			render: function(grid) {
    				var me = this;
    				var leadsCapturedTab=me.getLeadsCapturedTab();
    				leadsCapturedTab.items.items[0].setValue()
    				var campaignNewGrid = me.getCampaignnewgrid();
    				var records=campaignNewGrid.getSelectionModel();
    				var record=records.getSelection()[0];
    				leadsCapturedTab.items.items[0].setValue(record.get('campaignName'));
    				 var campaignId=record.get('id');
    				var gridStore = grid.getStore();
    				gridStore.getProxy().extraParams = {
    					id:campaignId
    				};
    				gridStore.load();
     				this.doAccessControlValidation(grid, this.getCAPTURE_LEAD_CAMPAIGN_NEW_PERMISSIONS());
    			},
    		  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts) {
               	 this.getEnquiryController().showEnquiryForm(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);
            	 e.stopEvent();
            	 e.stopPropagation();
            	 //return true;//comment code for uncheck selected record
             }
    		},
    		'campaignnewstructure': {
    			render:function(structure){
    				var $this = this
    				this.disableImportEnquiryCampaign(structure, this.getENQUIRY_IMPORT_CAMPAIGN_PERMISSIONS());
    				structure.body.on('click', function() {
    					var filter = structure.down('campaignnewfilter');
    					$this.hideInvalidIconFromField(filter);
    			       });
    			}
    		},
    		'campaignnewformlayout': {
    			render:function(form){
    				var $this = this
    				form.body.on('click', function() {
    					//var filter = structure.down('campaignnewfilter');
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
    		},
  	 		'enquirycampaignuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]': {
  	 		    change: this.downloadUploadFormChangeCampaign
  	 		},
  	 		'enquirycampaigndownloadform multiselectcombofield[itemId=academyLocationId]': {
  	 		    change: function() {
  	 		        var store = this.getStore('common.AcademyLocationNameSeparated');
  	 		        store.load();
  	 		    }
  	 		},
  	 		'enquirycampaigndownloadform button[itemId=downloadEnquiryNewFormItemId]': {
  	 		    click: function() {
  	 		        var jsonData = this.createJsonForEnquiryCampaignFormDownload();

  	 		        var csvForm = Ext.create('Ext.form.Panel', {
  	 		            items: [{
  	 		                xtype: 'textfield',
  	 		                maxLength: 20480,
  	 		                itemId: 'exportListDTO',
  	 		                name: 'exportListDTO',
  	 		                vtype: 'spaceAsInput'
  	 		            }]
  	 		        });

  	 		        csvForm.down('#exportListDTO').setValue(Ext.encode(jsonData));
  	 		        csvForm.getForm().submit({
  	 		            target: '_blank',
  	 		            method: 'POST',
  	 		            params: {
  	 		                access_token: Ext.Ajax.defaultHeaders.access_token
  	 		            },
  	 		            headers: {
  	 		                'Authorization': Ext.Ajax.defaultHeaders.Authorization
  	 		            },
  	 		            url: SERVERURL.DOWNLOAD_TEMPLATE_ENQUIRY_CAMPAIGN,
  	 		            standardSubmit: true,
  	 		            success: function(form, action) {
  	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
  	 		            },
  	 		            failure: function(form, action) {
  	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
  	 		            }
  	 		        });
  	 		    }
  	 		},
  	 		'enquirycampaigndownloadform button[itemId=resetBtn]':{
  	 			click:function(obj){
  	 				var $this=this;
  	 				var enquirynewdownloadform = $this.getEnquirycampaigndownloadform().getForm();
  	 				var academyLocationId = $this.getEnquirycampaigndownloadform().down("#academyLocationItemId");
  	 				academyLocationId.clearAllDataFn();
  	 				enquirynewdownloadform.reset();
  	 			}
  	 		},
  	 		'enquirycampaignuploadform button[itemId=resetBtn]': {
  	 		    click: function(obj) {
  	 		        var $this = this;
  	 		        var enquirynewuploadform = $this.getEnquirycampaignuploadform().getForm();
  	 		        enquirynewuploadform.findField('file').reset();
  	 		        var uploadoptionradiogroupform  = $this.getEnquirycampaignuploadoptionradiogroup();
  	 		        uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  	 		        	isUploadAll: false
  	 		        });
  	 		        $this.getEnquirycampaignuploadform().down('#uploadEnquiryNewFormItemId').setDisabled(true);
  	 		    }
  	 		},
  	 		'enquirycampaignuploadform': {
  	 		    render: function(obj) {
  	 		        var $this = this;
  	 		        var importWin = $this.getEnquirycampaignuploadform()
  	 		        var moduleName = importWin.down('#moduleName');
  	 		        moduleName.getStore().load({
  	 		            callback: function(records, operation, success) {
  	 		                for (var i in records) {
  	 		                    if (records[i].data.code == "bulkEnquiryCampaign") {
  	 		                        moduleName.setValue(records[i].data.id);
  	 		                        moduleName.setReadOnly(true)
  	 		                    }
  	 		                }
  	 		            }
  	 		        });
  	 		    }
  	 		},
  	 		'enquirycampaigndownloadform': {
  	 			render: function(obj) {
  	 				var $this = this;
  	 				var downloadForm = $this.getEnquirycampaigndownloadform()
  	 				var campaignNameField = downloadForm.down('#campaignNameId');
  	 				campaignNameField.getStore().getProxy().extraParams = {
  	 					isActive: true
  	 				};  	 		
  	 			}
  	 		},
  	 		'enquirycampaignuploadform button[itemId=uploadEnquiryNewFormItemId]': {
  	 		    click: function(obj) {
  	 		        var $this = this;
  	 		        var grdStore;
  	 		        var form = $this.getEnquirycampaignuploadform();
  	 		        if(form.getForm().isValid()){
  	 		         submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
			        	setTimeout(function() {
   	 		        form.getForm().submit({
   	 		            method: 'POST',
   	 		            url: submitUrl,
   	 		            success: function(form, action) {
   	 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
   	 		            },
   	 		            failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
   	 		            }
   	 		        });
			        	},1000);
   	 		        Ext.defer(function() {
   	 		            var grid = $this.getImportlistenquirycampaigngrid();
   	 		            var form = $this.getEnquirycampaignuploadoptionradiogroup();
   	 		            var isUploadAll = form.items.items[0].getValue().isUploadAll;
   	 		            $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ENQUIRY_CAMPAIGN_UPDATE');
   	 		        }, 2000, this);	
  	 		        }
  	 		    }
  	 		},
  	 		'enquirycampaignuploadform uploadoptionradiogroupcampaign[itemId=enquiryCampaignUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
  	 			change: function( radioGroup, newValue, oldValue, eOpts){
  	 				var grid =this.getImportlistenquirycampaigngrid();
  	 				var form =this.getEnquirycampaignuploadoptionradiogroup();
  	 				var isUploadAll = newValue.isUploadAll;
  	 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ENQUIRY_CAMPAIGN_UPDATE');
  	 			}   
  	 		},
  	 		'importlistenquirycampaigngrid': {
  	 		    render: function(obj) {
  	 		        var $this = this;
  	 		        var grid = $this.getImportlistenquirycampaigngrid();
  	 		        var form = $this.getEnquirycampaignuploadoptionradiogroup();
  	 		        var isUploadAll = form.items.items[0].getValue().isUploadAll;
  	 		        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ENQUIRY_CAMPAIGN_UPDATE');
  	 		    },
  	 		    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
  	 		        if (e.target.tagName == 'A') {
  	 		            var fileType = null;
  	 		            if (cellIndex == 1) {
  	 		                fileType = 'successFile';
  	 		            } else if (cellIndex == 6) {
  	 		                fileType = 'errorFile';
  	 		            } else if (cellIndex == 7) {
  	 		                fileType = 'logFile';
  	 		            }
  	 		            var documentId = record.get("id");
  	 		            if (!isNullOrEmpty(documentId)) {
  	 		                this.getDownloadFileCampaign(documentId, fileType);
  	 		            }
  	 		        }
  	 		    }
  	 		},
  	 		'importlistenquirycampaigngrid button[itemId=btnForce]': {
  	 		    click: function(obj) {
  	 		        var grid = this.getImportlistenquirycampaigngrid();
  	 		        if (grid.getSelectionModel().getCount() > 0) {
  	 		            if (grid.getSelectionModel().getCount() > 1) {
  	 		                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
  	 		            } else {
  	 		                var this$ = this;
  	 		                var id = grid.getSelectionModel().selectionStart.data.id;
  	 		                console.log(id);
  	 		                var urlAppend = "?jobName=" + id;
  	 		                var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
  	 		                Ext.Ajax.request({
  	 		                    url: submitURL,
  	 		                    method: 'GET',
  	 		                    success: function(response) {
  	 		                        if (response.responseText === "JOB_STATUS_NOT_PENDING") {
  	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
  	 		                        } else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
  	 		                            //console.log("Manual trigger hit");
  	 		                            showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
  	 		                        } else if (response.responseText === "SUCCESS") {
  	 		                            //console.log("Manual trigger hit");
  	 		                            showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
  	 		                            grid.getStore().reload();
  	 		                        }
  	 		                    }
  	 		                });
  	 		            }
  	 		        } else {
  	 		            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
  	 		        }
  	 		    }
  	 		},
		});
	},
	addCampaignNew : function(){
    	var contentpanel = this.getContentPanel();
    	
        
        var getcontroller=this.getController('menu.CoreERPNavigationController');
        var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_CAMPAIGN_DETAIL'));
        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_CAMPAIGN_DETAIL'));
        
        if (getEditTab != null) {
        	contentpanel.remove(getEditTab, true);
        }
        if (getViewTab != null) {
        	contentpanel.remove(getViewTab, true);
        }
        
    	var campaignNewFormLayout = this.getCampaignnewformlayout();
    	if (!campaignNewFormLayout) {
    		var campaignNewFormLayout = Ext.widget('campaignnewformlayout',{
            	title:getCampaignTranslation('DETAILS_TAB')
            });
    	}
        var tabName = getCommonTranslation('ADD_CAMPAIGN_DETAIL');
        var statusFld = campaignNewFormLayout.down('#statusId');
        statusFld.setDisabled(true);
        statusFld.getStore().load({
			callback:function(records, operation, success){
				if(records.length>0){
					statusFld.setValue('OPEN');
				}
			}
		});
        var countryCodeFieldArray = ["#mobileCountryCodeId"];
        this.setDefaultCountryCode(campaignNewFormLayout, countryCodeFieldArray);
        openTab(contentpanel, tabName, campaignNewFormLayout, CONSTANTS.MENU_COLOR_ONE);   
        this.setAcademyLocationAndOwnerDefault();
        var countryCodeField = campaignNewFormLayout.down("#mobileCountryCodeId");
     	var mobileField = campaignNewFormLayout.down("#mobileNumberId");
     	this$.setMaximumMinimumDigitsForMobileNoValidation(campaignNewFormLayout,countryCodeField,mobileField,null);
      	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_FIND_WHETHER_EDITABLE,                          
            method: 'GET',
            params: {
            	tableName: 'campaign_new',
            	columnName: 'code'
            },
            success: function(response,form, action) {
                if(!isNullOrEmpty(response.responseText)){
                    var responseObject =  Ext.JSON.decode(response.responseText);
                    if(!Ext.isEmpty(responseObject)){
                        var flagId = campaignNewFormLayout.down('#code');
                        if(responseObject){
                            flagId.setReadOnly(false)
                            this$.setAllowBlank(flagId,false);  
                            this$.setFieldPlaceHolder(flagId,'');
                        }else{
                            flagId.setReadOnly(true);
                            this$.setAllowBlank(flagId,true);
                            this$.setFieldPlaceHolder(flagId,getCommonTranslation('ID_AUTOGENERATE'));
                        }
                    }
                }
            }
        });
    },
    
    editCampaignNew : function(isType){
    	var $this = this;
		var grid = $this.getCampaignnewgrid();
		var contentpanel = $this.getContentPanel();
		if(grid.getSelectionModel().getCount()>0) {
			var getcontroller=this.getController('menu.CoreERPNavigationController');
	        var getAddTab = getcontroller.getTab(getCommonTranslation('ADD_CAMPAIGN_DETAIL'));
	        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_CAMPAIGN_DETAIL'));
	        var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_CAMPAIGN_DETAIL'));

	        if(isType == "VIEW"){
	        	if (getAddTab != null) {
		        	contentpanel.remove(getAddTab, true);
		        }
		        if (getEditTab != null) {
			            contentpanel.remove(getEditTab, true);
		        }
		        if (getViewTab != null) {
		        	contentpanel.remove(getViewTab, true);
		        }
	        }
	        else{
	        	if (getAddTab != null) {
		        	contentpanel.remove(getAddTab, true);
		        }
		        if (getViewTab != null) {
			            contentpanel.remove(getViewTab, true);
		        }
		        if (getEditTab != null) {
		        	contentpanel.remove(getEditTab, true);
	        }
	        }
			var campaignNewFormLayout = this.getCampaignnewformlayout();
			if (!campaignNewFormLayout) {
				var campaignNewFormLayout = Ext.widget('campaignnewformlayout',{
					title:getCampaignTranslation('DETAILS_TAB')
				});
			}
			if(isType != "VIEW"){
				var countryCodeField = campaignNewFormLayout.down("#mobileCountryCodeId");
             	var mobileField = campaignNewFormLayout.down("#mobileNumberId");
             	this$.setMaximumMinimumDigitsForMobileNoValidation(campaignNewFormLayout,countryCodeField,mobileField,null);
             	
             	var buzzCampCode = campaignNewFormLayout.down("#code");
             	buzzCampCode.setReadOnly(true);
			}
			var tabName = getCommonTranslation('EDIT_CAMPAIGN_DETAIL');
			if(isType == "VIEW"){
				tabName = getCommonTranslation('VIEW_CAMPAIGN_DETAIL');
			}
			campaignNewFormLayout.config.isType = isType;
			openTab(contentpanel, tabName, campaignNewFormLayout, CONSTANTS.MENU_COLOR_ONE);  
			$this.populateCampaignRecord(grid, campaignNewFormLayout, isType);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    checkUniquenessForCampaignNewCode : function(response) {
		var $this = this;
		var form = $this.getCampaignnewformlayout().getForm();
		var code = form.findField('code').getValue();
		var id = form.findField('id').getValue();
		Ext.Ajax
				.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.CAMPAIGN_NEW_CODE_CHECK_UNIQUENESS,
					params : {
						code : code,
						id : id,
					},
					headers : {
						'Content-Type' : 'application/json'
					},
					callback : function(resp,callback, action) {
						var mssg = action.responseText;
						if (mssg == "false") {
//							console.log(mssg);
							showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('CAMPAIGN_CODE_EXISTS'));
							form.findField('code').reset();
						}
					}
				});
	},

    populateCampaignRecord: function(grid, campaignNewFormLayout, isEditable){
    	var $this = this;
		var record = grid.getSelectionModel().getSelection()[0];
		var submitUrl = SERVERURL.PATH_CAMPPAIGN_NEW_FIND_BY_ID;
		var formPnl = campaignNewFormLayout;
		var campaignResetButtonId = formPnl.down('#campaignResetButtonId');
		campaignResetButtonId.setVisible(false);
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl+"?id="+record.data.id,
			method : 'GET',
			success : function(resp, action) {
				var data = Ext.decode(resp.responseText);
				 if(!isNullOrEmpty(data.createdOn)){
					 data.createdOn = new Date(data.createdOn);
				 }
				 formPnl.down('#createdOnId').setReadOnly(true);
					 
                 if(!isNullOrEmpty(data.startDate)){
                	 data.startDate = new Date(data.startDate);
                 }
                 formPnl.down('#startDateId').setReadOnly(true);
                	 
                 if(!isNullOrEmpty(data.endDate)){
                	 data.endDate = new Date(data.endDate);
                 }
                 formPnl.down('#endDateId').setReadOnly(true);
                	 
                 if(!isNullOrEmpty(data.intakeYear)){
                	 data.intakeYear = data.intakeYear.id;
                 }
                 if(data.presentationType == "PPC" || data.presentationType == "PFMG" || data.presentationType == "PMG" || data.presentationType == "GR11"){
                	 $this.loadDataForSchoolForm(formPnl,data);
                 }
                 else if(data.presentationType == "THIRD_PARTY" || data.presentationType == "CAREER_FAIR" || data.presentationType == "USSD"){
                	 $this.loadDataForSchoolFormCareerThirdPary(formPnl,data);
                 }
                 else if(data.campaignType == "NON_SCHOOL_PRESENTATION"){
                	 $this.loadDataForNonSchoolForm(formPnl,data,isEditable);
                 }
                 /*else if(data.presentationType == "ACTIVATIONS" || data.presentationType == "ADVERTISEMENT" ||
                		 data.presentationType == "MARKETING" || data.presentationType == "COMPETITION" || 
                		 data.presentationType == "EXPO" || data.presentationType == "OPEN_DAY"){
                	 $this.loadDataForNonSchoolForm(formPnl,data,isEditable);
                 }*/
                 
                 var documentGrid = formPnl.down('#documentsGridCampaignNew');
                 documentGrid.getStore().getProxy().api.read = SERVERURL.PATH_FIND_DOCUMENT_BY_CAMPAIGN_ID;
                 documentGrid.getStore().getProxy().extraParams={
                	 id:data.id
                 };
                 documentGrid.getStore().load();
                 if(isEditable == "VIEW"){
                	 var btnSaveCampaign= formPnl.down('#btnSaveCampaignNewForm');
                	 var btnDocUpload= formPnl.down('#meetingDocsCampaignId');
                	 $this.toggleReadOnlyFormItems(formPnl.getForm(), true);
                	 btnSaveCampaign.setVisible(false);
                	 btnDocUpload.setVisible(false);
                	 documentGrid.down('#btnDelete').setVisible(false);
                 }
                 else{
                	 formPnl.down('#campaignTypeId').setDisabled(true);
                	 formPnl.down('#presentationTypeId').setDisabled(true);
                	 formPnl.down('#presentationSubTypeId').setDisabled(true);
                	 formPnl.down('#presentationSubTypeNameId').setDisabled(true);
                	 formPnl.down('#intakeYearId').setDisabled(true);
                	 formPnl.down('#brandCampusId').setDisabled(true);
                	 formPnl.down('#schoolId').setDisabled(true);
                	 formPnl.down('#schoolPriorityId').setDisabled(true);
                	 formPnl.down('#startDateId').setDisabled(true);
                	 formPnl.down('#endDateId').setDisabled(true);
                	 formPnl.down('#campaignNameId').setDisabled(true);
                	 formPnl.down('#createdOnId').setDisabled(true);
                	 formPnl.down('#multiBrandCampusId').setDisabled(true);
                	 formPnl.down('#selectedSchoolId').setDisabled(true);
                	 formPnl.down('#schoolPriority1Id').setDisabled(true);
                	 if(data.presentationType == "OPEN_DAY" || data.presentationType == "ACTIVATIONS"){
                		 formPnl.down('#venueId').setDisabled(true);
                		 formPnl.down('#noCampaignId').setDisabled(true);
                	 }
                 }
			}
		});
    },
    
    loadDataForSchoolForm: function(formPnl,data){
    	var campaignTypeId= formPnl.down('#campaignTypeId');
    	var presentationTypeCombo= formPnl.down('#presentationTypeId');
    	var intakeYearId= formPnl.down('#intakeYearId');
    	var modeDeliveryId= formPnl.down('#modeDeliveryId');
    	var registrationTypeId= formPnl.down('#registrationTypeId');
    	var brandCampusId= formPnl.down('#brandCampusId');
    	var ownerId= formPnl.down('#ownerId');
    	var schoolId= formPnl.down('#schoolId');
    	var statusId= formPnl.down('#statusId');
		presentationTypeCombo.setDisabled(false);
		campaignTypeId.setReadOnly(true);
		intakeYearId.setReadOnly(true);
		var presentationTypeStore = presentationTypeCombo.getStore();
		
		presentationTypeStore.getProxy().extraParams = {
			campaignType: data.campaignType
		};
		presentationTypeStore.load({
			callback: function(records, operation, success) {
				presentationTypeCombo.setValue(data.presentationType);
				presentationTypeCombo.setReadOnly(true);
				if( !isNullOrEmpty(modeDeliveryId) && !isNullOrEmpty(data.modeOfDeliveryCSM) ){
					modeDeliveryId.getStore().load({
						callback: function(records, operation, success) {
							  for (var i in records) {
		 		                    if (records[i].data.id == data.modeOfDeliveryCSM.id) {
		 		                       modeDeliveryId.setValue(records[i].data.id);
		 		                    }
		 		                }
						}
					});
				}
				registrationTypeId.getStore().load({
					callback: function(records, operation, success) {
						registrationTypeId.setValue(data.registrationType);
					}
				});
				if(data.campaignAcademyLocation.length>0){
					var alVal = data.campaignAcademyLocation[0].academyLocation.id;
					brandCampusId.setValue(alVal);
					brandCampusId.setReadOnly(true);
					var ownerComboStore = ownerId.getStore();
					ownerComboStore.getProxy().extraParams = {
    					academyLocationIds: alVal
    				};
    				ownerComboStore.load({
    					callback: function(records, operation, success) {
    						ownerId.setValue(data.owner.id);
    					}
    				});
				}
				
				if(data.campaignSchoolMapping.length>0){
					var schoolVal = data.campaignSchoolMapping[0].campaignSchool.id;
					schoolId.setReadOnly(true);
					var schoolIdStore = schoolId.getStore();
					schoolIdStore.load({
    					callback: function(records, operation, success) {
    						schoolId.setValue(schoolVal);
    					}
    				});
				}
				statusId.getStore().load({
					callback: function(records, operation, success) {
						statusId.setValue(data.status);
					}
				});
				var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(data);
				formPnl.getForm().setValues(data);
				//formPnl.loadRecord(campaignNewModel);
				Ext.getBody().unmask();
			}
		});
    },
    
    loadDataForSchoolFormCareerThirdPary: function(formPnl,data){
    	var campaignTypeId= formPnl.down('#campaignTypeId');
    	var presentationTypeCombo= formPnl.down('#presentationTypeId');
    	var intakeYearId= formPnl.down('#intakeYearId');
    	var modeDeliveryId= formPnl.down('#modeDeliveryId');
    	var registrationTypeId= formPnl.down('#registrationTypeId');
    	var multiBrandCampusId= formPnl.down('#multiBrandCampusId');
    	var ownerId= formPnl.down('#ownerId');
    	var schoolId1= formPnl.down('#schoolId1');
    	var selectedSchoolId= formPnl.down('#selectedSchoolId');
    	var schoolPriority1Id= formPnl.down('#schoolPriority1Id');
    	var statusId= formPnl.down('#statusId');
    	var campaignNameId= formPnl.down('#campaignNameId');
    	var presentationSubTypeId= formPnl.down('#presentationSubTypeId');
    	var presentationSubTypeNameId= formPnl.down('#presentationSubTypeNameId');
		presentationTypeCombo.setDisabled(false);
		campaignTypeId.setReadOnly(true);
		intakeYearId.setReadOnly(true);
		schoolId1.setDisabled(true);
		selectedSchoolId.setReadOnly(true);
		var presentationTypeStore = presentationTypeCombo.getStore();
		
		presentationTypeStore.getProxy().extraParams = {
			campaignType: data.campaignType
		};
		presentationTypeStore.load({
			callback: function(records, operation, success) {
				presentationTypeCombo.setValue(data.presentationType);
				presentationTypeCombo.setReadOnly(true);
				if( !isNullOrEmpty(modeDeliveryId) && !isNullOrEmpty(data.modeOfDeliveryCSM) ){
					modeDeliveryId.getStore().load({
						callback: function(records, operation, success) {
							  for (var i in records) {
		 		                    if (records[i].data.id == data.modeOfDeliveryCSM.id) {
		 		                       modeDeliveryId.setValue(records[i].data.id);
		 		                    }
		 		                }
						}
					});
				}
				registrationTypeId.getStore().load({
					callback: function(records, operation, success) {
						registrationTypeId.setValue(data.registrationType);
					}
				});
				var alids=[];
				var academyLocationId = data.campaignAcademyLocation;
				var academyLocationIds = null;
				var campaignSchoolMappingArry=[];
				if(data.campaignAcademyLocation.length>0){
					if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
						for (var i in academyLocationId) {
							if (Ext.isObject(academyLocationId[0])) {
								alids.push(academyLocationId[i].academyLocation.id);
							}
						}
						academyLocationIds = alids.join();
					}
					
					multiBrandCampusId.setReadOnly(true);
					multiBrandCampusId.setValue(alids);
					var ownerComboStore = ownerId.getStore();
					ownerComboStore.getProxy().extraParams = {
    					academyLocationIds: academyLocationIds
    				};
    				ownerComboStore.load({
    					callback: function(records, operation, success) {
    						ownerId.setValue(data.owner.id);
    					}
    				});
				}
				
				if(data.campaignSchoolMapping.length>0){
					data.campaignSchoolMapping.forEach(function(obj){
						selectedSchoolId.valueStore.add(obj.campaignSchool);
						campaignSchoolMappingArry.push(obj.campaignSchool.id);
					});
				}
				
				if(!isNullOrEmpty(academyLocationIds) && !isNullOrEmpty(data.intakeYear) && data.campaignSchoolMapping.length>0){
					schoolPriority1Id.getStore().getProxy().extraParams = {
						academyLocationIds: academyLocationIds,
						intakeYearId:data.intakeYear,
						schoolId:campaignSchoolMappingArry.join(),
						isFirstCall: false
		    		};
					schoolPriority1Id.getStore().load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1 || records.length > 1){
									var priorityData = [];
									if(records.length == 1){
										schoolPriority1Id.setValue(records[0]);   
									}
									else{
										records.forEach(function(obj){
											priorityData.push(obj.data.id);
										});
										schoolPriority1Id.setValue(priorityData);
									}
								}
							}
						}
					});
				}
				if(data.presentationType == "THIRD_PARTY"){
					var presentationSubTypeStore = presentationSubTypeId.getStore();
					presentationSubTypeStore.getProxy().extraParams = {
						campaignType: data.campaignType,
						presentationType:data.presentationType
					};
					presentationSubTypeStore.load({
						callback: function(records, operation, success) {
							presentationSubTypeId.setValue(data.presentationSubType);
							presentationSubTypeNameId.setValue(data.presentationSubTypeName);
						}
					});
					presentationSubTypeId.setReadOnly(true);
					presentationSubTypeNameId.setReadOnly(true);
				}
				if(data.presentationType == "USSD"){
					var presentationSubTypeStore = presentationSubTypeId.getStore();
					presentationSubTypeStore.getProxy().extraParams = {
						campaignType: data.campaignType,
						presentationType:data.presentationType
					};
					presentationSubTypeStore.load({
						callback: function(records, operation, success) {
							presentationSubTypeId.setValue(data.presentationSubType);
							presentationSubTypeNameId.setValue(data.presentationSubTypeName);
						}
					});
					presentationSubTypeId.setReadOnly(true);
					presentationSubTypeNameId.setReadOnly(true);
				}
				statusId.getStore().load({
					callback: function(records, operation, success) {
						statusId.setValue(data.status);
					}
				});
				var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(data);
				campaignNewModel.data.customData = data.customData;
				formPnl.getForm().setValues(data);
				//formPnl.loadRecord(campaignNewModel);
				campaignNameId.setReadOnly(true);
				Ext.getBody().unmask();
			}
		});
    },
    
    loadDataForNonSchoolForm: function(formPnl,data,isEditable){
    	var campaignTypeId= formPnl.down('#campaignTypeId');
    	var presentationTypeCombo= formPnl.down('#presentationTypeId');
    	var intakeYearId= formPnl.down('#intakeYearId');
    	var modeDeliveryId= formPnl.down('#modeDeliveryId');
    	var registrationTypeId= formPnl.down('#registrationTypeId');
    	var brandCampusId= formPnl.down('#brandCampusId');
    	var multiBrandCampusId= formPnl.down('#multiBrandCampusId');
    	var ownerId= formPnl.down('#ownerId');
    	var schoolId= formPnl.down('#schoolId');
    	var statusId= formPnl.down('#statusId');
    	var schoolId1= formPnl.down('#schoolId1');
    	var selectedSchoolId= formPnl.down('#selectedSchoolId');
    	var numberOfLeadId= formPnl.down('#numberOfLeadId');
    	var venueId= formPnl.down('#venueId');
    	var noCampaignId= formPnl.down('#noCampaignId');
    	var campaignNameId= formPnl.down('#campaignNameId');
    	var advertURLId= formPnl.down('#advertURLId');
    	var presentationSubTypeId= formPnl.down('#presentationSubTypeId');
    	var presentationSubTypeNameId= formPnl.down('#presentationSubTypeNameId');
		presentationTypeCombo.setDisabled(false);
		campaignTypeId.setReadOnly(true);
		intakeYearId.setReadOnly(true);
		schoolId1.setDisabled(true);
		selectedSchoolId.setReadOnly(true);
		advertURLId.setReadOnly(true);
		var presentationTypeStore = presentationTypeCombo.getStore();
		
		presentationTypeStore.getProxy().extraParams = {
			campaignType: data.campaignType
		};
		presentationTypeStore.load({
			callback: function(records, operation, success) {
				presentationTypeCombo.setValue(data.presentationType);
				presentationTypeCombo.setReadOnly(true);
				if( !isNullOrEmpty(modeDeliveryId) && !isNullOrEmpty(data.modeOfDeliveryCSM) ){
					modeDeliveryId.getStore().load({
						callback: function(records, operation, success) {
							  for (var i in records) {
		 		                    if (records[i].data.id == data.modeOfDeliveryCSM.id) {
		 		                       modeDeliveryId.setValue(records[i].data.id);
		 		                    }
		 		                }
						}
					});
				}
				registrationTypeId.getStore().load({
					callback: function(records, operation, success) {
						registrationTypeId.setValue(data.registrationType);
					}
				});
				statusId.getStore().load({
					callback: function(records, operation, success) {
						statusId.setValue(data.status);
					}
				});
				var alids=[];
				var academyLocationId = data.campaignAcademyLocation;
				var academyLocationIds = null;
				if(data.presentationType == "ACTIVATIONS" || data.presentationType == "OPEN_DAY"){
					venueId.setReadOnly(true);
					noCampaignId.setReadOnly(true);
					
					if(data.campaignAcademyLocation.length>0){
						var alVal = data.campaignAcademyLocation[0].academyLocation.id;
						brandCampusId.setValue(alVal);
						brandCampusId.setReadOnly(true);
						var ownerComboStore = ownerId.getStore();
						ownerComboStore.getProxy().extraParams = {
	    					academyLocationIds: alVal
	    				};
	    				ownerComboStore.load({
	    					callback: function(records, operation, success) {
	    						ownerId.setValue(data.owner.id);
	    					}
	    				});
					}
				}
				else if(data.presentationType == "ADVERTISEMENT" || data.presentationType == "MARKETING" 
						|| data.presentationType == "EXPO" || data.presentationType == "WORKSHOPS" || data.presentationType == "COMPETITION"
							|| data.presentationType == "CORPORATE_CAMPAIGN" || data.presentationType == "FUNCTIONS" || data.presentationType == "PROMOTION" || data.presentationType == "DIGITAL_ADVERTISING"){
					
					if(data.presentationType == "ADVERTISEMENT" || data.presentationType == "MARKETING" || data.presentationType == "DIGITAL_ADVERTISING"){
						if(isEditable == "EDIT"){
							advertURLId.setReadOnly(false);	
						}
					}
					
					if(data.campaignAcademyLocation.length>0){
						if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
							for (var i in academyLocationId) {
								if (Ext.isObject(academyLocationId[0])) {
									alids.push(academyLocationId[i].academyLocation.id);
								}
							}
							academyLocationIds = alids.join();
						}
						multiBrandCampusId.setReadOnly(true);
						multiBrandCampusId.setValue(alids);
						var ownerComboStore = ownerId.getStore();
						ownerComboStore.getProxy().extraParams = {
	    					academyLocationIds: academyLocationIds
	    				};
	    				ownerComboStore.load({
	    					callback: function(records, operation, success) {
	    						ownerId.setValue(data.owner.id);
	    					}
	    				});
					}
				}
				
				if(data.campaignSchoolMapping.length>0){
					var campaignSchoolMappingArry=[];
					data.campaignSchoolMapping.forEach(function(obj){
						selectedSchoolId.valueStore.add(obj.campaignSchool);
						campaignSchoolMappingArry.push(obj.campaignSchool.id);
					});
				}
				
				if(data.presentationType == "WORKSHOPS" || data.presentationType == "FUNCTIONS" || data.presentationType == "PROMOTION"){
					var presentationSubTypeStore = presentationSubTypeId.getStore();
					presentationSubTypeStore.getProxy().extraParams = {
						campaignType: data.campaignType,
						presentationType:data.presentationType
					};
					presentationSubTypeStore.load({
						callback: function(records, operation, success) {
							presentationSubTypeId.setValue(data.presentationSubType);
							presentationSubTypeNameId.setValue(data.presentationSubTypeName);
						}
					});
					presentationSubTypeId.setReadOnly(true);
					presentationSubTypeNameId.setReadOnly(true);
				}
				
				var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(data);
				formPnl.getForm().setValues(data);
				//formPnl.loadRecord(campaignNewModel);
				campaignNameId.setReadOnly(true);
				Ext.getBody().unmask();
			}
		});
    
    },
	
    changePresentationType: function(field, newValue, oldValue, eOpts){
    	var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
    	$this.showHideCampaignFormFields(newValue);
    	$this.prefilledCampaignName();
    	var schoolIdCombo= formLayout.down('#schoolId');
    	schoolIdCombo.setDisabled(true);
		schoolIdCombo.reset();
		var sschoolId1Combo= formLayout.down('#schoolId1');
		sschoolId1Combo.setDisabled(true);
		sschoolId1Combo.reset();
    },
    deleteRecord: function() {
		var $this = this;
		var grid = $this.getCampaignnewgrid();
		if (grid.getSelectionModel().getCount() > 0) {
			 var count = grid.getSelectionModel().getCount();
			 var val=grid.getSelectionModel().getSelection()[0].data.id;
			 if(val!=undefined && count > 0){
				
	    			  showConfirmMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	        			  if (btn == 'yes') {
	        				  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	        				  Ext.Ajax.request({
	        					  method: "DELETE",
	        					  type: 'rest',
	        					  url: SERVERURL.PATH_CAMPAIGN_NEW_DELETE+'?id='+val,
	        					  headers: {
	        						  'Content-Type': 'application/json'
	        					  },
	        					  success: function(response, action) {
	        						  Ext.getBody().unmask();
	        						  var data = response.responseText;
	        						  if(data == 'CAPTURE_LEAD'){
	        							  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'),getCommonTranslation('CAMAPAIGNNEW_DELETE_MSG'));
	        						  }else if(data == 'DEPENDENCY_EXIST'){
	        							  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'),getCommonTranslation('DEPENDENCY_EXISTS'));
	        						  }else{
	        							  grid.getStore().reload(); // after deleted a record reloading the grid data
	        							  showSuccessMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'), getCommonTranslation('CAMPAIGN_DELETED_SUCCESS'));  
	        						  }
	        					  }
	        				  });
	        			  }
	        		  });
	    		  } else {
	    			  showWarningMessage(getCommonTranslation('CAMPAIGN_MSG_BOX_TITLE'),getCommonTranslation('DELETED_MSSG'));
	    		  }
	    	  } else {
	    		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	  }
	},
    prefilledCampaignName: function(obj){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var presentationTypeFld = formLayout.down('#presentationTypeId');
		var brandCampusId = formLayout.down('#brandCampusId');
		var schoolId = formLayout.down('#schoolId');
		var intakeYearId = formLayout.down('#intakeYearId');
		var schoolPriorityId = formLayout.down('#schoolPriorityId');
		var pType = presentationTypeFld.getValue();
		var field = formLayout.down('#startDateId');
		var campaignNameId = formLayout.down('#campaignNameId');
		var venueId = formLayout.down('#venueId');
		var noCampaignId = formLayout.down('#noCampaignId');
		var endDateId = formLayout.down('#endDateId');
		var campaignNumber = '';
		var campaignNumberField = formLayout.down('#campaignNumber');
		if( !isNullOrEmpty(campaignNumberField.getValue()) ){
			campaignNumber = campaignNumberField.getValue();
		}
		if(pType == "PPC" || pType == "PFMG" || pType == "PMG" || pType == "GR11"){
			if(!isNullOrEmpty(brandCampusId.getValue()) && !isNullOrEmpty(schoolId.getValue()) && !isNullOrEmpty(intakeYearId.getValue()) && !isNullOrEmpty(schoolPriorityId.getValue()) && !isNullOrEmpty(presentationTypeFld.getValue()) && !isNullOrEmpty(field.getValue())){
				var brandCode = "",
				school = schoolId.getRawValue(),
				intakeYear = intakeYearId.getRawValue(),
				schoolPriority = schoolPriorityId.getRawValue(),
				presentationType = presentationTypeFld.getRawValue();
				var brandCampusStore = brandCampusId.getStore();
				var rec = brandCampusStore.findRecord('id',brandCampusId.getValue());
				if(!isNullOrEmpty(rec)){
					brandCode = rec.data.code;
				}
				var dateFldVal = Ext.Date.format(field.getValue(),'d/m/Y');
				var dateStr = dateFldVal.replace(/\//g, "");
				var campaignNameStr = brandCode + " " + school + " " + intakeYear + " " + schoolPriority + " " + presentationType + " " + dateStr;
				campaignNameId.reset();
				if( !isNullOrEmpty(campaignNumber) && campaignNumber != '' ){
					campaignNameStr = campaignNameStr + " " + campaignNumber;
				}
				campaignNameId.setValue(campaignNameStr);
				endDateId.clearInvalid();
			}
			
			if(!isNullOrEmpty(obj) && !isNullOrEmpty(brandCampusId.getValue()) && !isNullOrEmpty(schoolId.getValue()) && !isNullOrEmpty(intakeYearId.getValue())){
				var brandCode = "",
				school = schoolId.getRawValue(),
				intakeYear = intakeYearId.getRawValue(),
				schoolPriority = schoolPriorityId.getRawValue(),
				presentationType = presentationTypeFld.getRawValue();
				var dateStr = '';
				var brandCampusStore = brandCampusId.getStore();
				var rec = brandCampusStore.findRecord('id',brandCampusId.getValue());
				if(!isNullOrEmpty(rec)){
					brandCode = rec.data.code;
				}
				if(!isNullOrEmpty(field.getValue())){
					var dateFldVal = Ext.Date.format(field.getValue(),'d/m/Y');
					dateStr = dateFldVal.replace(/\//g, "");
				}
				schoolPriorityId.getStore().getProxy().extraParams = {
					academyLocationIds: brandCampusId.getValue(),
					intakeYearId:intakeYearId.getValue(),
					schoolId:schoolId.getValue(),
					isFirstCall: false
	    		};
				schoolPriorityId.getStore().load({
					callback: function(records, operation, success) {
						   if (success) {
							   if(records.length == 1){
								   var campaignNameStr = brandCode + " " + school + " " + intakeYear + " " + records[0].data.value + " " + presentationType + " " + dateStr;
								   schoolPriorityId.setValue(records[0]);
								   schoolPriorityId.setReadOnly(true);
								   if( !isNullOrEmpty(campaignNumber) && campaignNumber != '' ){
										campaignNameStr = campaignNameStr + " " + campaignNumber;
									}
								   campaignNameId.setValue(campaignNameStr);
							   }
							   else{
								   var schoolName = schoolId.getRawValue();
								   schoolPriorityId.reset();
								   showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("PLEASE_SET_PRIORITY_FOR_THE_SCHOOL_MSG") + " " + schoolName);
								   
							   }
						   }
					   }
				});
			}
			else{
				if(!isNullOrEmpty(obj) && obj.getItemId() == "schoolId"){
					if(isNullOrEmpty(brandCampusId.getValue()) && isNullOrEmpty(intakeYearId.getValue())){
						showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMAPAIGNNEW_CHECK_AL_AND_INTAKEYEAR_MSG"));	
					}
					else if(isNullOrEmpty(brandCampusId.getValue())){
						showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMAPAIGNNEW_CHECK_AL_MSG"));
					}
					else if(isNullOrEmpty(intakeYearId.getValue())){
						showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMAPAIGNNEW_CHECK_INTAKEYEAR_MSG"));
					}
					obj.reset();
				}
			}
		}
		else if(pType == "THIRD_PARTY" || pType == "CAREER_FAIR" || pType == "USSD"){
			var multiBrandCampusId = formLayout.down('#multiBrandCampusId');
			var selectedSchoolId = formLayout.down('#selectedSchoolId');
			if(!isNullOrEmpty(obj)){
				schoolPriorityId.reset();
				multiBrandCampusId.reset();
				selectedSchoolId.clearValue();
				selectedSchoolId.valueStore.removeAll();
			}
		}
		else if(pType == "ACTIVATIONS" || pType == "OPEN_DAY"){
			if(!isNullOrEmpty(brandCampusId.getValue()) && !isNullOrEmpty(intakeYearId.getValue()) && !isNullOrEmpty(venueId.getValue())){
				var brandCode = "",
				intakeYear = intakeYearId.getRawValue(),
				brandCampusStore = brandCampusId.getStore();
				var rec = brandCampusStore.findRecord('id',brandCampusId.getValue());
				var venueFldVal = venueId.getValue();
				var noCampaignVal = noCampaignId.getValue();
				if(!isNullOrEmpty(rec)){
					brandCode = rec.data.code;
				}
				var campaignNameStr = brandCode + " " + intakeYear + " " + venueFldVal + " " + noCampaignVal;
				campaignNameId.reset();
				campaignNameId.setValue(campaignNameStr);
			}
		}
    },
    
    changePresentationSubType: function(field, newValue, oldValue, eOpts){
    	var $this = this;
    	var formLayout = $this.getCampaignnewformlayout();
    	var presentationSubTypeNameTxt = formLayout.down('#presentationSubTypeNameId');
    	var selectedSchoolFld = formLayout.down('#selectedSchoolId');
    	var schoolPriority1IdFld = formLayout.down('#schoolPriority1Id');
    	var presentationTypeIdFld = formLayout.down('#presentationTypeId');
    	
    	if(newValue == "OTHER"){
    		presentationSubTypeNameTxt.setVisible(true);
    		$this.setAllowBlank(presentationSubTypeNameTxt, false);
    		presentationSubTypeNameTxt.reset();
    	}
    	else{
    		presentationSubTypeNameTxt.setVisible(false);
    		$this.setAllowBlank(presentationSubTypeNameTxt, true);
    		presentationSubTypeNameTxt.reset();
    	}
    	if(presentationTypeIdFld.getValue() == "THIRD_PARTY"){
    		if(newValue == "RFR"){
    			selectedSchoolFld.labelSeparator = ': ';
    			selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    			schoolPriority1IdFld.setVisible(true);
    			$this.setAllowBlank(schoolPriority1IdFld, true);	
    		}
    		else{
    			selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    			selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    			schoolPriority1IdFld.setVisible(true);
    			$this.setAllowBlank(schoolPriority1IdFld, false);
    		}
    	}
    	if(presentationTypeIdFld.getValue() == "USSD"){
    		if(newValue == "Other"){
    			selectedSchoolFld.labelSeparator = ': ';
    			selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    			schoolPriority1IdFld.setVisible(true);
    			$this.setAllowBlank(schoolPriority1IdFld, false);	
    		}
    		else{
    			selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    			selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    			schoolPriority1IdFld.setVisible(true);
    			$this.setAllowBlank(schoolPriority1IdFld, false);
    		}
    	}
    	
    	formLayout.getForm().checkValidity();
    },
    
    showHideCampaignFormFields: function(checkType){
    	var $this = this;
    	var formLayout = $this.getCampaignnewformlayout();
    	var schoolIdFld = formLayout.down('#schoolId');
    	var schoolPriorityIdFld = formLayout.down('#schoolPriorityId');
    	var schoolIdCareerFld = formLayout.down('#schoolId1');
    	var selectedSchoolFld = formLayout.down('#selectedSchoolId');
    	var schoolPriority1IdFld = formLayout.down('#schoolPriority1Id');
    	var numberOfLeadIdFld = formLayout.down('#numberOfLeadId');
    	var campaignTypeFld = formLayout.down('#campaignTypeId');
    	var presentationTypeFld = formLayout.down('#presentationTypeId');
    	var presentationSubTypeCombo = formLayout.down('#presentationSubTypeId');
    	var presentationSubTypeNameTxt = formLayout.down('#presentationSubTypeNameId');
    	var preSubTypeFld = formLayout.down('#preSubTypeFld');
    	var multiBrandCampusId = formLayout.down('#multiBrandCampusId');
    	var brandCampusId = formLayout.down('#brandCampusId');
    	var campaignNameId = formLayout.down('#campaignNameId');
    	var contactDetailFld = formLayout.down('#contactDetailFld');
    	var emailAddressId = formLayout.down('#emailAddressId');
    	var modeDeliveryId = formLayout.down('#modeDeliveryId');
    	var registrationTypeId = formLayout.down('#registrationTypeId');
    	var venueId = formLayout.down('#venueId');
    	var startDateId = formLayout.down('#startDateId');
    	var endDateId = formLayout.down('#endDateId');
    	var noCampaignId = formLayout.down('#noCampaignId');
    	var advertURLContainterFld = formLayout.down('#advertURLFld');
    	var advertURLTxtFld = formLayout.down('#advertURLId');
    	var ownerFld = formLayout.down('#ownerId');
    	var intakeYearId = formLayout.down('#intakeYearId');
    	var campaignNumber = formLayout.down('#campaignNumber');

    	//ownerFld.reset();
    	schoolPriority1IdFld.reset();
    	schoolIdFld.reset();
    	schoolPriorityIdFld.reset();
    	presentationSubTypeCombo.reset();
    	presentationSubTypeNameTxt.reset();
    	//multiBrandCampusId.reset();
    	//brandCampusId.reset();
    	emailAddressId.reset();
    	campaignNameId.reset();
    	venueId.reset();
    	noCampaignId.reset();
    	startDateId.reset();
		endDateId.reset();
		advertURLTxtFld.reset();
		schoolIdCareerFld.reset();
		selectedSchoolFld.reset();
		intakeYearId.reset();
		modeDeliveryId.reset();
		registrationTypeId.reset();
		campaignNumber.reset();
		selectedSchoolFld.clearValue();
		selectedSchoolFld.valueStore.removeAll();
    	// School forms
    	if(checkType == "PPC" || checkType == "PFMG" || checkType == "PMG" || checkType == "GR11" || checkType == "RESET" || checkType == "CAMPAIGN_TYPE_RESET"){
    		formLayout.down('#schoolPriorityFld').setVisible(true);
    		formLayout.down('#selectSchoolFld1').setVisible(false);
    		formLayout.down('#selectPriorityFld1').setVisible(false);
    		numberOfLeadIdFld.setVisible(true);
    		$this.setAllowBlank(schoolIdFld, false);
    		$this.setAllowBlank(schoolPriorityIdFld, false);
    		$this.setAllowBlank(schoolIdCareerFld, true);
    		//$this.setAllowBlank(selectedSchoolFld, true);
    		$this.setAllowBlank(schoolPriority1IdFld, true);
    		schoolPriority1IdFld.setVisible(true);
    		$this.setAllowBlank(numberOfLeadIdFld, false);
    		$this.setAllowBlank(presentationSubTypeCombo, true);
    		$this.setAllowBlank(presentationSubTypeNameTxt, true);
    		preSubTypeFld.setVisible(false);
    		multiBrandCampusId.setVisible(false);
    		brandCampusId.setVisible(true);
    		$this.setAllowBlank(multiBrandCampusId, true);
    		$this.setAllowBlank(brandCampusId, false);
    		contactDetailFld.setVisible(true);
    		campaignNameId.setReadOnly(true);
    		$this.setAllowBlank(modeDeliveryId, false);
    		$this.setAllowBlank(registrationTypeId, false);
    		if(checkType == "RESET"){
    			presentationTypeFld.setDisabled(true);
    		}
    		venueId.setVisible(false);
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, false);
    		$this.setAllowBlank(endDateId, false);
    		advertURLContainterFld.setVisible(false);
    	}
    	else if(checkType == "CAREER_FAIR"){
    		modeDeliveryId.setVisible(true);
    		formLayout.down('#schoolPriorityFld').setVisible(false);
    		formLayout.down('#selectSchoolFld1').setVisible(true);
    		formLayout.down('#selectPriorityFld1').setVisible(true);
    		numberOfLeadIdFld.setVisible(false);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		$this.setAllowBlank(schoolIdCareerFld, true);
    		//$this.setAllowBlank(selectedSchoolFld, true);
    		selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    		selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    		$this.setAllowBlank(schoolPriority1IdFld, false);
    		schoolPriority1IdFld.setVisible(true);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		$this.setAllowBlank(presentationSubTypeCombo, true);
    		$this.setAllowBlank(presentationSubTypeNameTxt, true);
    		preSubTypeFld.setVisible(false);
    		
    		multiBrandCampusId.setVisible(true);
    		brandCampusId.setVisible(false);
    		$this.setAllowBlank(multiBrandCampusId, false);
    		$this.setAllowBlank(brandCampusId, true);
    		contactDetailFld.setVisible(true);
    		campaignNameId.setReadOnly(false);
    		$this.setAllowBlank(modeDeliveryId, false);
    		$this.setAllowBlank(registrationTypeId, false);
    		venueId.setVisible(false);
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, false);
    		$this.setAllowBlank(endDateId, false);
    		advertURLContainterFld.setVisible(false);
    	}
    	else if(checkType == "THIRD_PARTY" || checkType == "USSD" ){
    		formLayout.down('#schoolPriorityFld').setVisible(false);
    		formLayout.down('#selectSchoolFld1').setVisible(true);
    		formLayout.down('#selectPriorityFld1').setVisible(true);
    		numberOfLeadIdFld.setVisible(true);
    		var presentationSubTypeStore = presentationSubTypeCombo.getStore();
    		presentationSubTypeStore.getProxy().extraParams = {
    			campaignType: campaignTypeFld.getValue(),
    			presentationType:presentationTypeFld.getValue()
    		};
    		presentationSubTypeStore.load({
    			callback: function(records, operation, success) {
    				if(presentationSubTypeStore.data.length==1 && checkType=="USSD" ){
    					presentationSubTypeCombo.setValue(presentationSubTypeStore.data.keys[0]);	
    				}
    			}
    		});
    		
             
    		preSubTypeFld.setVisible(true);
    		$this.setAllowBlank(presentationSubTypeCombo, false);
    		$this.setAllowBlank(presentationSubTypeNameTxt, true);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		$this.setAllowBlank(schoolIdCareerFld, true);
    		//$this.setAllowBlank(selectedSchoolFld, true);
    		selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    		selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    		$this.setAllowBlank(schoolPriority1IdFld, false);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		schoolPriority1IdFld.setVisible(true);
    		
    		setTimeout(function(){
        		if(campaignTypeFld.getValue() == "NON_SCHOOL_PRESENTATION" && presentationTypeFld.getValue() == "USSD"){
        			schoolPriority1IdFld.setVisible(false);
        			$this.setAllowBlank(schoolPriority1IdFld, true);
        			$this.setAllowBlank(selectedSchoolFld, true);
        			$this.setAllowBlank(schoolIdCareerFld, true);
        		}
    		},500);
    		
    		multiBrandCampusId.setVisible(true);
    		brandCampusId.setVisible(false);
    		$this.setAllowBlank(multiBrandCampusId, false);
    		$this.setAllowBlank(brandCampusId, true);
    		contactDetailFld.setVisible(true);
    		campaignNameId.setReadOnly(false);
    		$this.setAllowBlank(modeDeliveryId, false);
    		$this.setAllowBlank(registrationTypeId, false);
    		venueId.setVisible(false);
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, false);
    		$this.setAllowBlank(endDateId, false);
    		advertURLContainterFld.setVisible(false);
    		if(checkType == "USSD"){
    			numberOfLeadIdFld.setVisible(true);
    			$this.setAllowBlank(numberOfLeadIdFld, false);
    		}
    	}
    	// Non school form
    	else if(checkType == "ACTIVATIONS" || checkType == "OPEN_DAY"){
    		modeDeliveryId.setVisible(true);
    		$this.setAllowBlank(modeDeliveryId, true);
    		$this.setAllowBlank(registrationTypeId, true);
    		multiBrandCampusId.setVisible(false);
    		brandCampusId.setVisible(true);
    		$this.setAllowBlank(multiBrandCampusId, true);
    		$this.setAllowBlank(brandCampusId, false);
    		formLayout.down('#schoolPriorityFld').setVisible(false);
    		formLayout.down('#selectSchoolFld1').setVisible(true);
    		formLayout.down('#selectPriorityFld1').setVisible(true);
    		//selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    		//selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    		schoolPriority1IdFld.setVisible(false);
    		$this.setAllowBlank(schoolPriority1IdFld, true);
    		venueId.setVisible(true);
    		$this.setAllowBlank(venueId, false);
    		noCampaignId.setVisible(true);
    		$this.setAllowBlank(noCampaignId, false);
    		$this.setAllowBlank(startDateId, true);
    		$this.setAllowBlank(endDateId, true);
    		campaignNameId.setReadOnly(true);
    		numberOfLeadIdFld.setVisible(false);
    		preSubTypeFld.setVisible(false);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		advertURLContainterFld.setVisible(false);
    		$this.setAllowBlank(presentationSubTypeCombo, true);
    		if(checkType == "OPEN_DAY"){
    			numberOfLeadIdFld.setVisible(true);
    			$this.setAllowBlank(numberOfLeadIdFld, false);
    		}
    	}
    	else if(checkType == "ADVERTISEMENT"){
    		modeDeliveryId.setVisible(true);
    		$this.setAllowBlank(modeDeliveryId, true);
    		$this.setAllowBlank(registrationTypeId, true);
    		multiBrandCampusId.setVisible(true);
    		brandCampusId.setVisible(false);
    		$this.setAllowBlank(multiBrandCampusId, false);
    		$this.setAllowBlank(brandCampusId, true);
    		formLayout.down('#schoolPriorityFld').setVisible(false);
    		formLayout.down('#selectSchoolFld1').setVisible(true);
    		formLayout.down('#selectPriorityFld1').setVisible(true);
    		//selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    		//selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    		schoolPriority1IdFld.setVisible(false);
    		$this.setAllowBlank(schoolPriority1IdFld, true);
    		venueId.setVisible(false);
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, true);
    		$this.setAllowBlank(endDateId, true);
    		campaignNameId.setReadOnly(false);
    		numberOfLeadIdFld.setVisible(false);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		advertURLContainterFld.setVisible(true);
    		preSubTypeFld.setVisible(false);
    		$this.setAllowBlank(presentationSubTypeCombo, true);
    	}
    	else if(checkType == "DIGITAL_ADVERTISING"){
    		modeDeliveryId.setVisible(true);
    		$this.setAllowBlank(modeDeliveryId, true);
    		$this.setAllowBlank(registrationTypeId, true);
    		multiBrandCampusId.setVisible(true);
    		brandCampusId.setVisible(false);
    		$this.setAllowBlank(multiBrandCampusId, false);
    		$this.setAllowBlank(brandCampusId, true);
    		formLayout.down('#schoolPriorityFld').setVisible(false);
    		formLayout.down('#selectSchoolFld1').setVisible(true);
    		formLayout.down('#selectPriorityFld1').setVisible(true);
    		//selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
    		//selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
    		schoolPriority1IdFld.setVisible(false);
    		$this.setAllowBlank(schoolPriority1IdFld, true);
    		venueId.setVisible(false);
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, true);
    		$this.setAllowBlank(endDateId, true);
    		campaignNameId.setReadOnly(false);
    		numberOfLeadIdFld.setVisible(false);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		advertURLContainterFld.setVisible(true);
    		var presentationSubTypeStore = presentationSubTypeCombo.getStore();
    		presentationSubTypeStore.getProxy().extraParams = {
    			campaignType: campaignTypeFld.getValue(),
    			presentationType:presentationTypeFld.getValue()
    		};
    		presentationSubTypeStore.load();
    		preSubTypeFld.setVisible(true);
    		$this.setAllowBlank(presentationSubTypeCombo, false);
    	}
    	else if(checkType == "MARKETING" || checkType == "COMPETITION" || checkType == "EXPO" || checkType == "CORPORATE_CAMPAIGN"){
    		modeDeliveryId.setVisible(true);
    		$this.setAllowBlank(modeDeliveryId, true);
    		$this.setAllowBlank(registrationTypeId, true);
    		multiBrandCampusId.setVisible(true);
    		brandCampusId.setVisible(false);
    		$this.setAllowBlank(multiBrandCampusId, false);
    		$this.setAllowBlank(brandCampusId, true);
    		formLayout.down('#schoolPriorityFld').setVisible(false);
    		formLayout.down('#selectSchoolFld1').setVisible(false);
    		formLayout.down('#selectPriorityFld1').setVisible(false);
    		schoolPriority1IdFld.setVisible(false);
    		$this.setAllowBlank(schoolPriority1IdFld, true);
    		venueId.setVisible(false);
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, true);
    		$this.setAllowBlank(endDateId, true);
    		campaignNameId.setReadOnly(false);
    		numberOfLeadIdFld.setVisible(false);
    		preSubTypeFld.setVisible(false);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		$this.setAllowBlank(presentationSubTypeCombo, true);
    		if(checkType == "MARKETING"){
    			advertURLContainterFld.setVisible(true);
    		}
    		else{
    			advertURLContainterFld.setVisible(false);
    		}
    		if(checkType == "EXPO"){
    			numberOfLeadIdFld.setVisible(true);
    			$this.setAllowBlank(numberOfLeadIdFld, false);
    		}
    	}
    	else if(checkType == "WORKSHOPS" || checkType == "FUNCTIONS" || checkType == "PROMOTION"){
    		$this.setAllowBlank(modeDeliveryId, true);
    		$this.setAllowBlank(registrationTypeId, true);
    		multiBrandCampusId.setVisible(true);
    		brandCampusId.setVisible(false);
    		$this.setAllowBlank(multiBrandCampusId, false);
    		$this.setAllowBlank(brandCampusId, true);
    		
    		if(checkType == "FUNCTIONS" || checkType == "PROMOTION"){
    			formLayout.down('#schoolPriorityFld').setVisible(false);
        		formLayout.down('#selectSchoolFld1').setVisible(false);
        		formLayout.down('#selectPriorityFld1').setVisible(false);
        		schoolPriority1IdFld.setVisible(false);
        		$this.setAllowBlank(schoolPriority1IdFld, true);
        		venueId.setVisible(false);
    		}else{
    			formLayout.down('#schoolPriorityFld').setVisible(false);
        		formLayout.down('#selectSchoolFld1').setVisible(true);
        		formLayout.down('#selectPriorityFld1').setVisible(true);
        		//selectedSchoolFld.labelSeparator = ': <span class="required" style="color:red"> *</span>';
        		//selectedSchoolFld.setFieldLabel(getCommonTranslation('SELECTED_SCHOOL'));
        		schoolPriority1IdFld.setVisible(false);
        		$this.setAllowBlank(schoolPriority1IdFld, true);
        		venueId.setVisible(true);
    		}
    		
    		$this.setAllowBlank(venueId, true);
    		noCampaignId.setVisible(false);
    		$this.setAllowBlank(noCampaignId, true);
    		$this.setAllowBlank(startDateId, true);
    		$this.setAllowBlank(endDateId, true);
    		campaignNameId.setReadOnly(false);
    		numberOfLeadIdFld.setVisible(false);
    		$this.setAllowBlank(numberOfLeadIdFld, true);
    		$this.setAllowBlank(schoolIdFld, true);
    		$this.setAllowBlank(schoolPriorityIdFld, true);
    		advertURLContainterFld.setVisible(false);
    		
    		var presentationSubTypeStore = presentationSubTypeCombo.getStore();
    		presentationSubTypeStore.getProxy().extraParams = {
    			campaignType: campaignTypeFld.getValue(),
    			presentationType:presentationTypeFld.getValue()
    		};
    		presentationSubTypeStore.load();
    		preSubTypeFld.setVisible(true);
    		$this.setAllowBlank(presentationSubTypeCombo, false);
    	}
    },
	
    resetCampaignFilter: function(){
    	var $this = this,
    	formLayout = $this.getCampaignnewfilter(),
    	schoolIdFld = formLayout.down('#schoolId'),
    	schoolPriorityIdFld = formLayout.down('#schoolPriorityId'),
    	campaignTypeFld = formLayout.down('#campaignTypeId'),
    	presentationTypeFld = formLayout.down('#presentationTypeId'),
    	modeDeliveryId = formLayout.down('#modeDeliveryId'),
    	registrationTypeId = formLayout.down('#registrationTypeId'),
    	startDateId = formLayout.down('#startDateId'),
    	endDateId = formLayout.down('#endDateId'),
    	ownerFld = formLayout.down('#ownerId'),
    	intakeYearId = formLayout.down('#intakeYearId'),
    	statusId = formLayout.down('#statusId');

    	var academyLocationId = this.getCurrentAcademyLocation();
    	schoolIdFld.reset();
    	schoolPriorityIdFld.reset();
    	campaignTypeFld.reset();
    	presentationTypeFld.reset();
    	modeDeliveryId.reset();
    	registrationTypeId.reset();
    	startDateId.reset();
    	endDateId.reset();
    	ownerFld.reset();
    	intakeYearId.reset();
    	statusId.reset();
    	presentationTypeFld.setDisabled(true);
    	startDateId.setMinValue(false);
    	endDateId.setMinValue(false);
    	startDateId.setMaxValue(false);
    	endDateId.setMaxValue(false);
    	schoolIdFld.setDisabled(true);

    	var campaignNameCombo= formLayout.down('#campaignNameId'),
    	campaignNameComboStore = campaignNameCombo.getStore();
    	campaignNameComboStore.getProxy().extraParams = {
    		campaignType: null,
    		presentationType:null,
    		academyLocationIds:academyLocationId
    	};
    	campaignNameComboStore.load();
    	campaignNameCombo.lastQuery=null;
    	campaignNameCombo.reset();
    	campaignNameCombo.setRawValue(null);
    	var multiBrandCampusId = formLayout.down('#multiBrandCampusId'),
    	ALComboStore = multiBrandCampusId.getStore();
    	ALComboStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				multiBrandCampusId.setValue(academyLocationId);
    			}
    		}
    	});
    	var extraParamsSchool = schoolPriorityIdFld.getStore().getProxy().extraParams;
    	if(!isNullOrEmpty(extraParamsSchool.intakeYearId)){
    		delete extraParamsSchool.intakeYearId;
    	}
    	if(!isNullOrEmpty(extraParamsSchool.academyLocationIds)){
    		delete extraParamsSchool.academyLocationIds;
    	}
    	if(!isNullOrEmpty(extraParamsSchool.schoolId)){
    		delete extraParamsSchool.schoolId;
    	}
    	if(!isNullOrEmpty(extraParamsSchool.isFirstCall)){
    		delete extraParamsSchool.isFirstCall;
    	}
    	schoolPriorityIdFld.getStore().load();
    },
    
    searchCampaignFilter: function(){
    	var $this = this;
		var formLayout = $this.getCampaignnewfilter();
		this.showInvalidIconOnField(formLayout);
		var formValue = formLayout.getValues();
		formLayout.down('#searchBtn').setDisabled(true);
    	var grid = $this.getCampaignnewgrid();
    	var alids=[];
		var academyLocationId = formValue.multiBrandCampus;
		var academyLocationIds = null;

		if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
			for (var i in academyLocationId) {
				if (Ext.isObject(academyLocationId[0])) {
					alids.push(academyLocationId[i].get("id"));
				} else {
					alids.push(academyLocationId[i]);
				}
			}
			academyLocationIds = alids.join();
		}
		else if(!isNullOrEmpty(academyLocationId)){
			academyLocationIds = academyLocationId;
		}
		
    	grid.getStore().getProxy().extraParams= {
    		academyLocationIds:academyLocationIds,
    		intakeYearId:formValue.intakeYear,
    		campaignType:formValue.campaignType,
    		presentationType:formValue.presentationType,
    		campaignName:formValue.campaignName,
    		status:formValue.status,
    		startDate :formValue.startDate,
    		endDate:formValue.endDate,
    		schoolId:formValue.school,
    		schoolPriority:formValue.schoolPriority,
    		modeOfDeliveryId:formValue.modeDelivery,
    		registrationType:formValue.registrationType,
    		ownerId:formValue.owner
    	};
    	grid.getSelectionModel().deselectAll();
    	$this.resetGridSetting(grid);
    	grid.getStore().load({
			callback:function(records, operation, success){
			formLayout.down('#searchBtn').setDisabled(false);
					if(records.length>0){
						var exportPDFAll = grid.down('#btnExportToPDF');
		        		exportPDFAll.setDisabled(false);
		        		var exportExcelAll = grid.down('#btnExportToExcel');
		        		exportExcelAll.setDisabled(false);
					}else{
						var exportPDFAll = grid.down('#btnExportToPDF');
		        		exportPDFAll.setDisabled(true);
		        		var exportExcelAll = grid.down('#btnExportToExcel');
		        		exportExcelAll.setDisabled(true);
					}
			}
		});
/***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	
    	grid.config.searchFilterForm = $this.getCampaignnewfilter();
    	
/***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    
	resetCampaignFormPanelData: function(){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		formLayout.getForm().reset();
		var statusFld = formLayout.down('#statusId');
		$this.showHideCampaignFormFields("RESET");
        statusFld.getStore().load({
			callback:function(records, operation, success){
				if(records.length>0){
					statusFld.setValue('OPEN');
				}
			}
		});
        this.setAcademyLocationAndOwnerDefault();
	},
	
	saveCampaignFormPanelData: function(){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		this.showInvalidIconOnField(formLayout);
		var disableditems = formLayout.query('[disabled=true]');
		Ext.each(disableditems, function(item) { item.enable(); });
		var values = formLayout.getForm().getValues();
		Ext.each(disableditems, function(item) { item.disable(); });


		var grid = $this.getCampaignnewgrid();
		var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(values);
		var formData = campaignNewModel.data;
		var id = formLayout.down('#idItemId').getValue();

		if (isNullOrEmpty(id)) {
			if(values.presentationType == "PPC" || values.presentationType == "PFMG" || 
					values.presentationType == "PMG" || values.presentationType == "GR11" || 
					values.presentationType == "THIRD_PARTY" || values.presentationType == "CAREER_FAIR"
						||values.presentationType == "USSD"){
				formData = this.createJSONforSchoolForm(values.presentationType);
			}
			else if(values.presentationType == "ACTIVATIONS" || values.presentationType == "ADVERTISEMENT" || 
					values.presentationType == "MARKETING" || values.presentationType == "COMPETITION" || 
					values.presentationType == "EXPO" || values.presentationType == "CORPORATE_CAMPAIGN" || 
					values.presentationType == "OPEN_DAY" || values.presentationType == "WORKSHOPS" || 
					values.presentationType == "FUNCTIONS" || values.presentationType == "PROMOTION" || values.presentationType == "DIGITAL_ADVERTISING"){
				formData = this.createJSONforNonSchoolForm(values.presentationType);
			}
		}
		else{
			if(values.presentationType == "PPC" || values.presentationType == "PFMG" || 
					values.presentationType == "PMG" || values.presentationType == "GR11" || 
					values.presentationType == "THIRD_PARTY" || values.presentationType == "CAREER_FAIR" ||values.presentationType == "USSD"){
				formData = this.createJSONforSchoolFormUpdate(values.presentationType);
				
			}
			else if(values.presentationType == "ACTIVATIONS" || values.presentationType == "ADVERTISEMENT" || 
					values.presentationType == "MARKETING" || values.presentationType == "COMPETITION" || 
					values.presentationType == "EXPO" || values.presentationType == "CORPORATE_CAMPAIGN" || 
					values.presentationType == "OPEN_DAY" || values.presentationType == "WORKSHOPS" || 
					values.presentationType == "FUNCTIONS" || values.presentationType == "PROMOTION" || values.presentationType == "DIGITAL_ADVERTISING"){
				formData = this.createJSONforNonSchoolFormUpdate(values.presentationType);
			}
			var campaignNameId = formLayout.down('#campaignNameId');
			formData.campaignName = campaignNameId.getValue();
		}
	if(!isNullOrEmpty(values.customData)) {
			formData.customData = values.customData;
		}
		if(!isNullOrEmpty(formData)){
			var meetingdocumentgrid = formLayout.down('#documentsGridCampaignNew');
			var docStore = meetingdocumentgrid.getStore();
			var docArray = [];
			if (docStore.data.items != null && docStore.data.items.length > 0) {
				for(var i in docStore.data.items) {
					if(docStore.data.items[i].data.isNewRecord!=undefined && docStore.data.items[i].data.isNewRecord){
						var newData = {
								"name" : docStore.data.items[i].data.documentName,
								"path" : docStore.data.items[i].data.path,
								"type" : "DOCUMENT",
								"createdBy" : $this.getIdValueJson(
										docStore.data.items[i].data.createdBy.id,
										docStore.data.items[i].data.createdBy.value)
						};
						var data = {
								'document':newData
						};
						docArray.push(data);
					}
				}
				formData.campaignNewDocument = docArray;
			}
			else{
				formData.campaignNewDocument = [];
			}
			formData = Ext.encode(formData);
			var tabName;
			var submitUrl, isUpdate = false;

			if (isNullOrEmpty(id)) {
				submitUrl = SERVERURL.PATH_SAVE_CAMPAIGN_NEW;
				isUpdate = false;
				tabName = getCommonTranslation('ADD_CAMPAIGN_DETAIL');
			} else {
				submitUrl = SERVERURL.PATH_UPDATE_CAMPAIGN_NEW;				    			
				isUpdate = true;
				tabName = getCommonTranslation('EDIT_CAMPAIGN_DETAIL');
			}        
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: formData,
				method: 'POST',
				success: function(form, action) {
					var resp = form.responseText;
					Ext.getBody().unmask();
					if(resp == "0"){
						showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("DUPLICATE_CAMPAIGN_NAME_MSG"));
					}
					else{
						if (isUpdate) {
							showSuccessMessage(getCommonTranslation('MANAGE_CAMPAIGN'), getCommonTranslation('CAMPAIGN_UPDATED_SUCCESSFULLY'));											
						} else {
							showSuccessMessage(getCommonTranslation('MANAGE_CAMPAIGN'), getCommonTranslation('CAMPAIGN_CREATED_SUCCESSFULLY'));										
						}

						var contentpanel = $this.getContentPanel();
						var getcontroller = $this.getController('menu.CoreERPNavigationController');
						var getTab = getcontroller.getTab(tabName);
						var campaignTabName = getMegaMenuTranslation('CE_TERTIARY_MANAGE_VIEW_COMPAIGNS');
						var getCampaignTabName = getcontroller.getTab(campaignTabName);
						if (getTab != null) {
							contentPanel.remove(getTab, true);
						}
						if (getCampaignTabName != null) {
							contentPanel.setActiveTab(getCampaignTabName);
						}
						if(grid != undefined) {
							var grdStore = grid.getStore();
							grid.getSelectionModel().deselectAll();
							grdStore.reload();
						}
					}
				},
				failure: function(form, action) {
					Ext.getBody().unmask();
					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
				}
			});
		}
	},
	
	createJSONforSchoolForm: function(pType){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var values = formLayout.getForm().getValues();
		var grid = $this.getCampaignnewgrid();
		
		var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(values);
		var formData = campaignNewModel.data;
		formData.campaignType = values.campaignType;
		formData.presentationType = values.presentationType;

		if(values.presentationType == "THIRD_PARTY" || values.presentationType == "USSD"){
			formData.presentationSubType = values.presentationSubType;
			formData.presentationSubTypeName = values.presentationSubTypeName;
		}
		formData.intakeYear = {
				"id":values.intakeYear
		};
		formData.modeofDelivery = values.modeDelivery;
		formData.registrationType = values.registrationType;
		formData.owner = {
				"id":values.owner
		};
		if(values.presentationType == "CAREER_FAIR" || values.presentationType == "THIRD_PARTY" ||values.presentationType == "USSD"){
			var priorityData = [];
			
			if(Ext.isObject(values.schoolPriority1)){
				formData.schoolPriority = values.schoolPriority1.data.id;
			}
			else{
				if(!isNullOrEmpty(values.schoolPriority1)){
				values.schoolPriority1.forEach(function(obj){
					priorityData.push(obj);
				});
				formData.schoolPriority = priorityData.join();
			}
			

			
		}
		}
		else{
			formData.schoolPriority = values.schoolPriority;
		}

		formData.startDate = values.startDate;
		formData.endDate = values.endDate;
		//formData.numberofCampaign = values.numberofCampaign;
		//formData.venue = values.venue;
		formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
		formData.createdOn = values.createdOn;
		formData.status = "OPEN";
		formData.contactPersonName = values.contactPersonName;
		formData.emailAddress = values.emailAddress;
		formData.mobileCountryCode = values.mobileCountryCode;
		formData.mobileNo = values.mobileNo;
		//formData.advertisementURL = values.advertURL;
		formData.remarks = values.remarks;
		formData.campaignName = values.campaignName;
		formData.campaignNumber = values.campaignNumber;

		var campaignALArray = [];
		var campaignSchoolMappingArray = [];

		if(values.presentationType == "CAREER_FAIR" || values.presentationType == "THIRD_PARTY" || values.presentationType == "USSD"){
			
			if(!isNullOrEmpty(values.multiBrandCampus) && values.multiBrandCampus.length > 0 && !isNullOrEmpty(values.multiBrandCampus[0])){
			values.multiBrandCampus.forEach(function(obj){
				var objData = {
						"campaignNew":{
							"id":values.id
						},
						"academyLocation":{
							"id":obj.data.id
						}
				}
				campaignALArray.push(objData);
			});
		}
		else{
				if(!isNullOrEmpty(values.multiBrandCampus) && !isNaN(values.multiBrandCampus)){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"academyLocation":{
								"id":values.multiBrandCampus
							}
					}
					campaignALArray.push(objData);
				}
			}
		}
		else{
			var obj = {
					"campaignNew":{
						"id":values.id
					},
					"academyLocation":{
						"id":values.brandCampus
					}
			}
			campaignALArray.push(obj);
		}

		if(values.presentationType == "PPC" || values.presentationType == "PFMG" || values.presentationType == "PMG" || values.presentationType == "GR11"){
			var obj = {
					"campaignNew":{
						"id":values.id
					},
					"campaignSchool":{
						"id":values.school
					}
			}
			campaignSchoolMappingArray.push(obj);
		}
		else if(values.presentationType == "CAREER_FAIR" || values.presentationType == "THIRD_PARTY" || values.campaignType =="SCHOOL_PRESENTATION" && values.presentationType == "USSD" ){
			var selectedSchool = formLayout.down('#selectedSchoolId');
			var items = selectedSchool.valueStore.data.items;
			if(items.length>0){
				items.forEach(function(obj){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"campaignSchool":{
								"id":obj.data.id
							}
					}
					campaignSchoolMappingArray.push(objData);
				});
			}
			else{
				if(values.presentationSubType != "RFR"){
				showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMPAING_PLEASE_SELECT_SCHOOL_MSG"));
				return;
			}
		}
		}
		formData.campaignAcademyLocation = campaignALArray;
		formData.campaignSchoolMapping = campaignSchoolMappingArray;

		if(values.presentationType == "PPC" || values.presentationType == "PFMG" || values.presentationType == "PMG" || values.presentationType == "GR11" || values.presentationType == "CAREER_FAIR"){
			delete formData.presentationSubType;
			delete formData.presentationSubTypeName;
		}
		if(values.presentationType == "THIRD_PARTY" || values.presentationType == "CAREER_FAIR" || values.presentationType == "USSD"){
			//delete formData.numberOfleadsTargeted;
		}
		delete formData.numberOfleadsCaptured;
		delete formData.advertisementURL;
		delete formData.numberofCampaign;
		delete formData.venue;
		delete formData.academyLocations;
		delete formData.conversionRate;
		if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
			delete formData.modeOfDeliveryCSM;
			}
		return formData;
	},
	
	createJSONforNonSchoolForm: function(pType){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var values = formLayout.getForm().getValues();
		var grid = $this.getCampaignnewgrid();
		
		var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(values);
		var formData = campaignNewModel.data;
		formData.campaignType = values.campaignType;
		formData.presentationType = values.presentationType;
		formData.intakeYear = {
				"id":values.intakeYear
		};
		if(pType == "ACTIVATIONS" || pType == "OPEN_DAY"){
			formData.modeofDelivery = values.modeDelivery;
			formData.registrationType = values.registrationType;
			formData.owner = {
					"id":values.owner
			};
			formData.startDate = values.startDate;
			formData.endDate = values.endDate;
			formData.numberofCampaign = values.numberofCampaign;
			formData.venue = values.venue;
			formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
			formData.createdOn = values.createdOn;
			formData.status = "OPEN";
			formData.contactPersonName = values.contactPersonName;
			formData.emailAddress = values.emailAddress;
			formData.mobileCountryCode = values.mobileCountryCode;
			formData.mobileNo = values.mobileNo;
			//formData.advertisementURL = values.advertURL;
			formData.remarks = values.remarks;
			formData.campaignName = values.campaignName;
			
			var campaignALArray = [];
			var campaignSchoolMappingArray = [];
			
			var obj = {
					"campaignNew":{
						"id":values.id
					},
					"academyLocation":{
						"id":values.brandCampus
					}
			}
			campaignALArray.push(obj);
			var selectedSchool = formLayout.down('#selectedSchoolId');
			var items = selectedSchool.valueStore.data.items;
			if(items.length>0){
				items.forEach(function(obj){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"campaignSchool":{
								"id":obj.data.id
							}
					}
					campaignSchoolMappingArray.push(objData);
				});
			}
			else{
				//showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMPAING_PLEASE_SELECT_SCHOOL_MSG"));
				//return;
			}
			formData.campaignAcademyLocation = campaignALArray;
			formData.campaignSchoolMapping = campaignSchoolMappingArray;
			if(pType == "OPEN_DAY"){
				formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
			}
			else{
				delete formData.numberOfleadsTargeted;
			}
			delete formData.advertisementURL;
			delete formData.presentationSubType;
			delete formData.presentationSubTypeName;
			delete formData.numberOfleadsCaptured;
			delete formData.schoolPriority;
			if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
				delete formData.modeOfDeliveryCSM;
				}
		}
		else if(pType == "ADVERTISEMENT" || pType == "DIGITAL_ADVERTISING"){
			formData.modeofDelivery = values.modeDelivery;
			formData.registrationType = values.registrationType;
			formData.owner = {
					"id":values.owner
			};
			formData.startDate = values.startDate;
			formData.endDate = values.endDate;
			//formData.numberofCampaign = values.numberofCampaign;
			//formData.venue = values.venue;
			formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
			formData.createdOn = values.createdOn;
			formData.status = "OPEN";
			formData.contactPersonName = values.contactPersonName;
			formData.emailAddress = values.emailAddress;
			formData.mobileCountryCode = values.mobileCountryCode;
			formData.mobileNo = values.mobileNo;
			formData.advertisementURL = values.advertisementURL;
			formData.remarks = values.remarks;
			formData.campaignName = values.campaignName;
			var campaignALArray = [];
			var campaignSchoolMappingArray = [];
			
			if(!isNullOrEmpty(values.multiBrandCampus) && values.multiBrandCampus.length > 0 && !isNullOrEmpty(values.multiBrandCampus[0])){
			values.multiBrandCampus.forEach(function(obj){
				var objData = {
						"campaignNew":{
							"id":values.id
						},
						"academyLocation":{
							"id":obj.data.id
						}
				}
				campaignALArray.push(objData);
			});
			}
			else{
				if(!isNullOrEmpty(values.multiBrandCampus) && !isNaN(values.multiBrandCampus)){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"academyLocation":{
								"id":values.multiBrandCampus
							}
					}
					campaignALArray.push(objData);
				}
			}
			
			var selectedSchool = formLayout.down('#selectedSchoolId');
			var items = selectedSchool.valueStore.data.items;
			if(items.length>0){
				items.forEach(function(obj){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"campaignSchool":{
								"id":obj.data.id
							}
					}
					campaignSchoolMappingArray.push(objData);
				});
			}
			else{
				//showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMPAING_PLEASE_SELECT_SCHOOL_MSG"));
				//return;
			}
			formData.campaignAcademyLocation = campaignALArray;
			formData.campaignSchoolMapping = campaignSchoolMappingArray;
			
			delete formData.presentationSubType;
			if(pType == "DIGITAL_ADVERTISING"){
				formData.presentationSubType = values.presentationSubType;
				formData.presentationSubTypeName = values.presentationSubTypeName;
				
			}else{
				delete formData.presentationSubTypeName;
			}
			delete formData.numberOfleadsTargeted;
			delete formData.numberOfleadsCaptured;
			delete formData.schoolPriority;
			delete formData.numberofCampaign;
			delete formData.venue;
			if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
				delete formData.modeOfDeliveryCSM;
				}
		}
		else if(pType == "MARKETING" || pType == "COMPETITION" || pType == "EXPO" || pType == "CORPORATE_CAMPAIGN"){
			formData.modeofDelivery = values.modeDelivery;
			formData.registrationType = values.registrationType;
			formData.owner = {
					"id":values.owner
			};
			formData.startDate = values.startDate;
			formData.endDate = values.endDate;
			formData.createdOn = values.createdOn;
			formData.status = "OPEN";
			formData.contactPersonName = values.contactPersonName;
			formData.emailAddress = values.emailAddress;
			formData.mobileCountryCode = values.mobileCountryCode;
			formData.mobileNo = values.mobileNo;
			formData.advertisementURL = values.advertisementURL;
			formData.remarks = values.remarks;
			formData.campaignName = values.campaignName;
			var campaignALArray = [];
			
			if(!isNullOrEmpty(values.multiBrandCampus) && values.multiBrandCampus.length > 0 && !isNullOrEmpty(values.multiBrandCampus[0])){
			values.multiBrandCampus.forEach(function(obj){
				var objData = {
						"campaignNew":{
							"id":values.id
						},
						"academyLocation":{
							"id":obj.data.id
						}
				}
				campaignALArray.push(objData);
			});
			}
			else{
				if(!isNullOrEmpty(values.multiBrandCampus) && !isNaN(values.multiBrandCampus)){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"academyLocation":{
								"id":values.multiBrandCampus
							}
					}
					campaignALArray.push(objData);
				}
			}
			
			formData.campaignAcademyLocation = campaignALArray;
			
			delete formData.presentationSubType;
			delete formData.presentationSubTypeName;
			delete formData.numberOfleadsCaptured;
			delete formData.schoolPriority;
			delete formData.numberofCampaign;
			delete formData.venue;
			delete formData.campaignSchoolMapping;
			
			if(pType == "COMPETITION" || pType == "CORPORATE_CAMPAIGN"){
				delete formData.advertisementURL;
			}
			if(pType == "EXPO"){
				formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
				delete formData.advertisementURL;
			}
			else{
				delete formData.numberOfleadsTargeted;
				
			}
			if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
				delete formData.modeOfDeliveryCSM;
				}
		}
		else if(pType == "WORKSHOPS" || pType == "FUNCTIONS" || pType == "PROMOTION"){
			formData.modeofDelivery = values.modeDelivery;
			formData.registrationType = values.registrationType;
			formData.owner = {
					"id":values.owner
			};
			formData.startDate = values.startDate;
			formData.endDate = values.endDate;
			//formData.numberofCampaign = values.numberofCampaign;
			formData.venue = values.venue;
			//formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
			formData.createdOn = values.createdOn;
			formData.status = "OPEN";
			formData.contactPersonName = values.contactPersonName;
			formData.emailAddress = values.emailAddress;
			formData.mobileCountryCode = values.mobileCountryCode;
			formData.mobileNo = values.mobileNo;
			//formData.advertisementURL = values.advertisementURL;
			formData.remarks = values.remarks;
			formData.campaignName = values.campaignName;
			
			if(pType == "WORKSHOPS"){
				var campaignALArray = [];
				var campaignSchoolMappingArray = [];
				
				if(!isNullOrEmpty(values.multiBrandCampus) && values.multiBrandCampus.length > 0 && !isNullOrEmpty(values.multiBrandCampus[0])){
				values.multiBrandCampus.forEach(function(obj){
					var objData = {
							"campaignNew":{
								"id":values.id
							},
							"academyLocation":{
								"id":obj.data.id
							}
					}
					campaignALArray.push(objData);
				});
				}
				else{
					if(!isNullOrEmpty(values.multiBrandCampus) && !isNaN(values.multiBrandCampus)){
						var objData = {
								"campaignNew":{
									"id":values.id
								},
								"academyLocation":{
									"id":values.multiBrandCampus
								}
						}
						campaignALArray.push(objData);
					}
				}
				
				var selectedSchool = formLayout.down('#selectedSchoolId');
				var items = selectedSchool.valueStore.data.items;
				if(items.length>0){
					items.forEach(function(obj){
						var objData = {
								"campaignNew":{
									"id":values.id
								},
								"campaignSchool":{
									"id":obj.data.id
								}
						}
						campaignSchoolMappingArray.push(objData);
					});
				}
				else{
					//showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMPAING_PLEASE_SELECT_SCHOOL_MSG"));
					//return;
				}
				formData.campaignAcademyLocation = campaignALArray;
				formData.campaignSchoolMapping = campaignSchoolMappingArray;
			}
			else{
				delete formData.venue;
				delete formData.campaignSchoolMapping;
				
				if(pType == "FUNCTIONS" || pType == "PROMOTION"){
					var campaignALArray = [];

					if(!isNullOrEmpty(values.multiBrandCampus) && values.multiBrandCampus.length > 0 && !isNullOrEmpty(values.multiBrandCampus[0])){
					values.multiBrandCampus.forEach(function(obj){
						var objData = {
								"campaignNew":{
									"id":values.id
								},
								"academyLocation":{
									"id":obj.data.id
								}
						}
						campaignALArray.push(objData);
					});
					}
					else{
						if(!isNullOrEmpty(values.multiBrandCampus) && !isNaN(values.multiBrandCampus)){
							var objData = {
									"campaignNew":{
										"id":values.id
									},
									"academyLocation":{
										"id":values.multiBrandCampus
									}
							}
							campaignALArray.push(objData);
						}
					}
					
					formData.campaignAcademyLocation = campaignALArray;
				}
			}
			
			formData.presentationSubType = values.presentationSubType;
			formData.presentationSubTypeName = values.presentationSubTypeName;
			
			delete formData.numberOfleadsTargeted;
			delete formData.numberOfleadsCaptured;
			delete formData.schoolPriority;
			delete formData.numberofCampaign;
			delete formData.advertisementURL;
			if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
				delete formData.modeOfDeliveryCSM;
				}
		}
		if(isNullOrEmpty(formData.modeofDelivery)){
			delete formData.modeofDelivery;
		}
		if(isNullOrEmpty(formData.registrationType)){
			delete formData.registrationType;
		}
		delete formData.academyLocations;
		delete formData.conversionRate;
		return formData;
	},
	
	createJSONforSchoolFormUpdate:function(pType){

		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var values = formLayout.getForm().getValues();
		var grid = $this.getCampaignnewgrid();
		
		var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(values);
		var formData = campaignNewModel.data;
		
		formData.id = values.id;
		formData.modeofDelivery = values.modeDelivery;
		formData.registrationType = values.registrationType;
		formData.owner = {
				"id":values.owner
		};
		formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
		formData.status = values.status;
		formData.contactPersonName = values.contactPersonName;
		formData.emailAddress = values.emailAddress;
		formData.mobileCountryCode = values.mobileCountryCode;
		formData.mobileNo = values.mobileNo;
		formData.remarks = values.remarks;
		formData.campaignNumber = values.campaignNumber;
		
		delete formData.campaignType;
		delete formData.presentationType;
		delete formData.intakeYear;
		delete formData.presentationSubType;
		delete formData.presentationSubTypeName;
		delete formData.schoolPriority;
		delete formData.startDate;
		delete formData.endDate;
		delete formData.createdOn;
		delete formData.campaignName;
		delete formData.campaignAcademyLocation;
		delete formData.campaignSchoolMapping;
		delete formData.numberOfleadsCaptured;
		delete formData.advertisementURL;
		delete formData.numberofCampaign;
		delete formData.venue;
		delete formData.academyLocations;
		delete formData.conversionRate;
		if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
			delete formData.modeOfDeliveryCSM;
			}
		return formData;
	
	},
	
	createJSONforNonSchoolFormUpdate:function(pType){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var values = formLayout.getForm().getValues();
		var grid = $this.getCampaignnewgrid();
		
		var campaignNewModel = new Academia.model.campaignnew.CampaignNewGridModel(values);
		var formData = campaignNewModel.data;
		
		formData.id = values.id;
		formData.modeofDelivery = values.modeDelivery;
		formData.registrationType = values.registrationType;
		formData.owner = {
				"id":values.owner
		};
		formData.numberOfleadsTargeted = values.numberOfleadsTargeted;
		formData.status = values.status;
		formData.contactPersonName = values.contactPersonName;
		formData.emailAddress = values.emailAddress;
		formData.mobileCountryCode = values.mobileCountryCode;
		formData.mobileNo = values.mobileNo;
		formData.remarks = values.remarks;
			
		if(pType == "WORKSHOPS" || pType == "ACTIVATIONS" || pType == "OPEN_DAY"){
			formData.venue = values.venue;	
		}
		else{
			delete formData.venue;
		}
		if(pType == "ADVERTISEMENT" || pType == "MARKETING" || pType == "DIGITAL_ADVERTISING"){
			formData.advertisementURL = values.advertisementURL;
			if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
				delete formData.modeOfDeliveryCSM;
				}
		}
		else{
			delete formData.advertisementURL;
		}
		
		if(isNullOrEmpty(formData.modeofDelivery)){
			delete formData.modeofDelivery;
		}
		if(isNullOrEmpty(formData.registrationType)){
			delete formData.registrationType;
		}
		delete formData.campaignType;
		delete formData.presentationType;
		delete formData.intakeYear;
		delete formData.presentationSubType;
		delete formData.presentationSubTypeName;
		delete formData.schoolPriority;
		delete formData.startDate;
		delete formData.endDate;
		delete formData.createdOn;
		delete formData.campaignName;
		delete formData.campaignAcademyLocation;
		delete formData.campaignSchoolMapping;
		delete formData.numberOfleadsCaptured;
		delete formData.numberofCampaign;
		delete formData.academyLocations;
		delete formData.conversionRate;
		if(isNullOrEmpty(formData.modeOfDeliveryCSM)){
			delete formData.modeOfDeliveryCSM;
			}
		return formData;
	},
	
	checkCampaignLeadCaptured: function(field){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var statusVal = field.getValue();
		var campaignId = formLayout.down('#idItemId').getValue();
		var presentationTypeId = formLayout.down('#presentationTypeId').getValue();
		if(!isNullOrEmpty(presentationTypeId) && statusVal=="COMPLETED" && presentationTypeId=="USSD") {
		} else {
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_MAPPED_ENQUIRY_BY_CAMPAIGN_ID+"?id="+campaignId,
			method : 'GET',
			success : function(resp, action) {
				var data = Ext.decode(resp.responseText);
				if(statusVal == "CANCELLED" && data == true){
					field.setValue('OPEN');
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CAMPAIGN_NEW_STATUS_CANCELLED_MSG'));
				}
				else if(statusVal == "COMPLETED" && data == false){
					field.setValue('OPEN');
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CAMPAIGN_NEW_STATUS_COMPLETED_MSG'));
				}
			}
		});
		}
	},
	
	addSelectedSchoolItem: function(combo, record){
		var $this = this;
		var formLayout = $this.getCampaignnewformlayout();
		var intakeYearId = formLayout.down('#intakeYearId');
		var multiBrandCampusId = formLayout.down('#multiBrandCampusId');
		var selectedSchoolId = formLayout.down('#selectedSchoolId');
		var schoolPriority1Id = formLayout.down('#schoolPriority1Id');
		var campaignTypeId = formLayout.down('#campaignTypeId');
		var storeSchool = selectedSchoolId.getStore();
		var obj = {'id':record[0].data.id,'value':record[0].data.value };
		storeSchool.add(obj);
		var selectedSchoolData = selectedSchoolId.getValue();
		var selectedSchoolIds=[];
		var schoolId1 = formLayout.down('#schoolId1');
		var alids=[];
		var academyLocationId = multiBrandCampusId.getValue();
		var academyLocationIds = null;
		var schoolName = schoolId1.getRawValue();
		
		if(campaignTypeId.getValue() == 'NON_SCHOOL_PRESENTATION'){
			if(!isNullOrEmpty(selectedSchoolData)){
				var index = storeSchool.findExact('id',obj.id);
				if(index != -1){
					var valIndex = selectedSchoolId.valueStore.findExact('id',obj.id);
					if(valIndex == -1){
						selectedSchoolId.valueStore.add(obj);
					}
				}
				else{
					selectedSchoolData.push(obj.id);
					selectedSchoolId.setValue(selectedSchoolData);
				}
			}
			else{
				var index = storeSchool.findExact('id',obj.id);
				if(index != -1){
					var valIndex = selectedSchoolId.valueStore.findExact('id',obj.id);
					if(valIndex == -1){
						selectedSchoolId.valueStore.add(obj);	
					}
				}
				else{
					selectedSchoolIds.push(obj.id);
					selectedSchoolId.setValue(selectedSchoolIds);
				}
			}
		}
		else{
			if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
				for (var i in academyLocationId) {
					if (Ext.isObject(academyLocationId[0])) {
						alids.push(academyLocationId[i].get("id"));
					} else {
						alids.push(academyLocationId[i]);
					}
				}
				academyLocationIds = alids.join();
			}
			else{
				if(!isNullOrEmpty(academyLocationId) && !isNaN(academyLocationId)){
					academyLocationIds = academyLocationId.toString();
				}
			}
			
			if(!isNullOrEmpty(academyLocationIds) && !isNullOrEmpty(schoolId1.getValue()) && !isNullOrEmpty(intakeYearId.getValue())){
				schoolPriority1Id.getStore().getProxy().extraParams = {
					academyLocationIds: academyLocationIds,
					intakeYearId:intakeYearId.getValue(),
					schoolId:schoolId1.getValue(),
					isFirstCall: true
	    		};
				schoolPriority1Id.getStore().load({
					callback: function(records, operation, success) {
						schoolPriority1Id.clearInvalid();
						if (success) {
							if(records.length == 1 || records.length > 1){
								if(!isNullOrEmpty(selectedSchoolData)){
									var index = storeSchool.findExact('id',obj.id);
									if(index != -1){
										var valIndex = selectedSchoolId.valueStore.findExact('id',obj.id);
										if(valIndex == -1){
											selectedSchoolId.valueStore.add(obj);
										}
									}
									else{
										selectedSchoolData.push(obj.id);
										selectedSchoolId.setValue(selectedSchoolData);
									}
								}
								else{
									var index = storeSchool.findExact('id',obj.id);
									if(index != -1){
										var valIndex = selectedSchoolId.valueStore.findExact('id',obj.id);
										if(valIndex == -1){
											selectedSchoolId.valueStore.add(obj);	
										}
									}
									else{
										selectedSchoolIds.push(obj.id);
										selectedSchoolId.setValue(selectedSchoolIds);
									}
								}
								if(selectedSchoolId.valueStore.data.length>0){
									schoolPriority1Id.getStore().getProxy().extraParams = {
										academyLocationIds: academyLocationIds,
										intakeYearId:intakeYearId.getValue(),
										schoolId:selectedSchoolId.valueStore.data.keys.join(),
										isFirstCall: false
									};
									schoolPriority1Id.getStore().load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1 || records.length > 1){
													//schoolPriority1Id.reset();
													var priorityData = [];
													if(records.length == 1){
														schoolPriority1Id.setValue(records[0]);   
													}
													else{
														records.forEach(function(obj){
															priorityData.push(obj.data.id);
														});
														schoolPriority1Id.setValue(priorityData);
													}
												}
											}
										}
									});
								}
							}
							else{
								//schoolPriority1Id.reset();
								showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("PLEASE_SET_PRIORITY_FOR_THE_SCHOOL_MSG") + " " + schoolName);
								if(selectedSchoolId.valueStore.data.length>0){
									schoolPriority1Id.getStore().getProxy().extraParams = {
										academyLocationIds: academyLocationIds,
										intakeYearId:intakeYearId.getValue(),
										schoolId:selectedSchoolId.valueStore.data.keys.join(),
										isFirstCall: false
									};
									schoolPriority1Id.getStore().load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 1 || records.length > 1){
													//schoolPriority1Id.reset();
													var priorityData = [];
													if(records.length == 1){
														schoolPriority1Id.setValue(records[0]);   
													}
													else{
														records.forEach(function(obj){
															priorityData.push(obj.data.id);
														});
														schoolPriority1Id.setValue(priorityData);
													}
												}
											}
										}
									});
								}
							}
						}
					}
				});
			}
			else{
				if(isNullOrEmpty(academyLocationIds) && isNullOrEmpty(intakeYearId.getValue())){
					showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMAPAIGNNEW_CHECK_AL_AND_INTAKEYEAR_MSG"));	
				}
				else if(isNullOrEmpty(academyLocationIds)){
					showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMAPAIGNNEW_CHECK_AL_MSG"));
				}
				else if(isNullOrEmpty(intakeYearId.getValue())){
					showWarningMessage(getCommonTranslation('MANAGE_CAMPAIGN'),getCommonTranslation("CAMAPAIGNNEW_CHECK_INTAKEYEAR_MSG"));
				}
			}
		}
		combo.reset();
	},
	setSchoolPriority: function(){
		var $this = this;
		var formLayout = $this.getCampaignnewfilter();
		var intakeYearId= formLayout.down('#intakeYearId');
		var schoolId= formLayout.down('#schoolId');
		var schoolPriorityId= formLayout.down('#schoolPriorityId');
		var multiBrandCampusId= formLayout.down('#multiBrandCampusId');
		var alids=[];
		var academyLocationId = multiBrandCampusId.getValue();
		var academyLocationIds = null;
		var schoolName = schoolId.getRawValue();
		schoolPriorityId.reset();
		if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
			for (var i in academyLocationId) {
				if (Ext.isObject(academyLocationId[0])) {
					alids.push(academyLocationId[i].get("id"));
				} else {
					alids.push(academyLocationId[i]);
				}
			}
			academyLocationIds = alids.join();
		}
		else if(!isNullOrEmpty(academyLocationId)){
			academyLocationIds = academyLocationId;
		}
		
		if(!isNullOrEmpty(academyLocationIds) && !isNullOrEmpty(schoolId.getValue()) && !isNullOrEmpty(intakeYearId.getValue())){
			schoolPriorityId.getStore().getProxy().extraParams = {
				academyLocationIds: academyLocationIds,
				intakeYearId:intakeYearId.getValue(),
				schoolId:schoolId.getValue(),
				isFirstCall: false
    		};
			schoolPriorityId.getStore().load({
			   callback: function(records, operation, success) {
				   if (success) {
					   if(records.length == 1 || records.length > 1){
						   var priorityData = [];
						   if(records.length == 1){
							   schoolPriorityId.setValue(records[0]);   
						   }
						   else{
							   records.forEach(function(obj){
								   priorityData.push(obj.data.id);
							   });
						   }
					   }
				   }
			   }
		   });
		}
	},
	getDocumentController : function() {
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    getIdValueJson: function(id, value) {
        if (id) return {
            id: id,
            value: value
        };
    },
    oprenCreateEnquiry : function(campaignId,gridSelectionRecords){
    	
    	var contentpanel = this.getContentPanel();
    	
    	/**
    	 *  comment for enquiry revamp
    	 *  uncomment for previous enquiry flow
    	 */
//    	var createenquiry = Ext.widget('createEnquiry');
    	var createenquiry = Ext.widget('enquiryformrevampstructure');
    	if (!createenquiry) {
    		createenquiry = Ext.widget('enquirytabstructure');
		}
    	var tabName = getCommonTranslation('CREATE_ENQUIRY');
    	openTab(contentpanel, tabName, createenquiry,CONSTANTS.MENU_COLOR_ONE);
    	//set Campaign user 
    	var followUpUserStore =createenquiry.down('#followUpUser').getStore();
    	if(!isNullOrEmpty(gridSelectionRecords.data))
		{
    	var campaignOwnerId=gridSelectionRecords.data.ownerId;
		}
    	Ext.defer(function() {
    	followUpUserStore.load({
    		scope:this,
    		callback: function(records, operation, success) {
        			if(success){
        				createenquiry.down('#followUpUser').setValue(campaignOwnerId);
    			}
 		   }	
    	});
    	}
    	, 2000, this);
    	
    	this$ = this;
    	var countryCodeField = createenquiry.down("#phoneCountryCode");
     	var mobileField = createenquiry.down("#cellNumber");
    	countryCodeField.labelSeparator = '';
     	countryCodeField.setFieldLabel('');
     	mobileField.labelSeparator = '';
     	mobileField.setFieldLabel('');
     	this$.setMaximumMinimumDigitsForMobileNoValidation(createenquiry,countryCodeField,mobileField,null);
     	countryCodeField = createenquiry.down("#alternatePhoneCountryCode");
     	mobileField = createenquiry.down("#alternateCellNumber");
     	this$.setMaximumMinimumDigitsForMobileNoValidation(createenquiry,countryCodeField,mobileField,null);
     	
    	var campaignNewStore=createenquiry.down('#campaignNew').getStore();
    	var campaignSchool=createenquiry.down('#campaignSchool');
    	var campaignAcademyLocations = [];
    	var campaignAcademyLocationsObj = gridSelectionRecords.data.academyLocations;
    	for(var i in campaignAcademyLocationsObj){
    		var alId = campaignAcademyLocationsObj[i].academyLocId;
    		campaignAcademyLocations.push(alId);
    	}
    	campaignNewStore.getProxy().extraParams.academyLocationIds = campaignNewStore.getProxy().extraParams.academyLocationIds+","+campaignAcademyLocations.join();
	 
	 Ext.defer(function() {
		 campaignNewStore.load({
	    		scope:this,
	    		callback: function(records, operation, success) {
	        			if(success){
	        				
	        				//var campaignNew=	createenquiry.down('#captutreLeadCampaign');
	        				var campaignNew=	createenquiry.down('#campaignNew');
	        				//campaignNew.setVisible(true);
	        				campaignNew.setVisible(true);
	        				campaignNew.setValue(campaignId);
	        				campaignNew.setReadOnly(true);
	        				this$.selectNewCampaignField(campaignNew,campaignId,null,null,campaignAcademyLocations.join());
	    			}
	 		   }	
	    	});
	    	},200,this);
    },
    selectCampaignSchoolField: function(obj, campaignNewId, campaignSchoolId, enquiryId, enquiryAcademyLocationId){
        var form = obj.up('form');
        var schoolPriorityField = form.down("#schoolPriority");
        var url='';             

        if(campaignNewId==null){
            url = SERVERURL.CAMPAIGN_NEW_DETAILS + "?schoolId="+campaignSchoolId;
        }
        else
        {
            url = SERVERURL.CAMPAIGN_NEW_DETAILS + "?campaigId="+campaignNewId+"&schoolId="+campaignSchoolId;
            if( !isNullOrEmpty(enquiryId) && enquiryId > 0 ){
                url = url+"&academyLocationIds="+enquiryAcademyLocationId;
            }
        }

        Ext.Ajax.request({
            type: 'rest',
            url: url,
            method: 'GET',
            success: function(response) {
                var data = Ext.decode(response.responseText);
                if( !isNullOrEmpty(data) && data.length!=0 ){
                    if( !isNullOrEmpty(data[0].schoolPriority) ){
                        var schoolPriority = data[0].schoolPriority.value;
                        schoolPriorityField.setValue(schoolPriority);
                    }
                }
            }
        });
    },
    selectNewCampaignField: function(obj, campaignNewId, campaignSchoolId, enquiryId, campaignAcademyLocationIds){
        var form = obj.up('form');
        var campaignSchoolCombo = form.down("#campaignSchool");
        var campaignTypeField = form.down("#campaignType");
        var presentationTypeField = form.down("#presentationType");
        var schoolPriorityField = form.down("#schoolPriority");
        var schoolPriorityComboField = form.down("#schoolPriorityNew");
       
        var intakeYear = form.down("#enqIntakeYear");
        var registrationType = form.down("#regType");
        var modeofDelivery = form.down("#modeOfDelivery");
        schoolPriorityField.reset();
        schoolPriorityField.setVisible(true);
        schoolPriorityComboField.setVisible(false);
        var $this = this;
        var campSchoolId = campaignSchoolId;
        var schoolPriority = '';
        $this.setAllowBlank(campaignSchoolCombo,true);
        var academyLocUrl = '';
        if( !isNullOrEmpty(campaignNewId) && campaignNewId > 0 ){
            academyLocUrl = campaignAcademyLocationIds;
        }
        else
            academyLocUrl = this.getCurrentAcademyLocation();

        if(!isNullOrEmpty(campaignNewId)){
            campSchoolId = null;
        }

        if(campaignNewId!=null){
            var url = SERVERURL.PATH_CAMPAIGN_DEATIL_BY_ID +"?campaignId="+campaignNewId;
            Ext.Ajax.request({
                type: 'rest',
                url: url,
                method: 'GET',
                success: function(response) {
                    if(response.responseText != null && response.responseText != ""){
                        var responseData = Ext.JSON.decode(response.responseText);
                        if( !isNullOrEmpty(campaignTypeField) && !isNullOrEmpty(responseData.campaignType) ){
                            campaignTypeField.setValue(responseData.campaignType);
                        }
                        if( !isNullOrEmpty(presentationTypeField) && !isNullOrEmpty(responseData.presentationType) ){
                            presentationTypeField.setValue(responseData.presentationType);
                        }
                        if(!isNullOrEmpty(intakeYear) && !isNullOrEmpty(responseData.intakeYearId) ){
							  intakeYear.getStore().load({
								  callback: function(records, operation, success) {
									  for(i in records){
										  if(records[i].data.id==responseData.intakeYearId){
											  intakeYear.setValue(records[i].data.id);  
										  }
									  }
								  }	
							  });
						  }else if( !isNullOrEmpty(intakeYear)){
							  intakeYear.reset();
						  }
						  if( !isNullOrEmpty(registrationType) && !isNullOrEmpty(responseData.registrationType) ){
							  registrationType.setValue(responseData.registrationType);
						  }
						  if( !isNullOrEmpty(modeofDelivery) && !isNullOrEmpty(responseData.modeOfDeliveryCSM) ){
							  modeofDelivery.setValue(responseData.modeOfDeliveryCSM);
						  }
                    }
                }
            });
        }

        var campaignSchoolStore = campaignSchoolCombo.getStore();
        campaignSchoolStore.getProxy().extraParams = {                    
            campaigId:campaignNewId,
            academyLocationIds:academyLocUrl,
            schoolId:campSchoolId
        };
        campaignSchoolStore.removeAll();
        campaignSchoolCombo.reset();

        campaignSchoolStore.load({
            callback: function(records, operation, success) {
                for(var i in records){                            
                    campaignSchoolCombo.setValue(records[i].data.schoolId);
                    if(campaignSchoolId == records[i].data.schoolId && !isNullOrEmpty(records[i].data.schoolPriority))
                        schoolPriority = records[i].data.schoolPriority.value;
                }

                if(records.length!=0){

                    if( records.length!=1 ){
                        $this.setAllowBlank(campaignSchoolCombo,false);
                        campaignSchoolCombo.select(campaignSchoolId);
                        schoolPriorityField.setValue(schoolPriority);
                    }
                }
                campaignSchoolCombo.setReadOnly(false);
                if( !isNullOrEmpty(records) && records.length == 1 ){
                    campaignSchoolCombo.select(records[0].data.schoolId);
                    if(!isNullOrEmpty(records[0].data.schoolPriority)){
                        schoolPriorityField.setValue(records[0].data.schoolPriority.value);
                        campaignSchoolCombo.setReadOnly(true);
                    }
                }
            }  
        });
    },
    getEnquiryController:function(){
		return this.getController('enquiry.EnquiryController');
	  },
    disableMoreActionPivileges: function(gridReference, permissionsMap) {

        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        buttonsToolBar = gridReference.query('toolbar')[0];
        var splitbuttons = buttonsToolBar.query('splitbutton')[0];

        var btnCaptureLead = gridReference.down('#btnCaptureLead');
        btnCaptureLead.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'CAPTURE_LEAD') {
                if (!isNullOrEmpty(btnCaptureLead)) {
                	btnCaptureLead.setVisible(true);
                }
            }
        });
    },
    openCampaignNewALWindow: function(formWindow, dataIndex, record) {
        var $this = this;
        var win = $this.getCampaignnewalwindow();
        var alGrid = win.down('#campaignNewAcademyLocationGridItemId');
        var gridStore = alGrid.getStore();
        gridStore.removeAll();
        var arr = [];
        var campaignId = record.data.id;
        /*for (var i = 0; i < record.data.academyLocations.length; i++) {
            arr.push({
                "academyDisplayName": record.data.academyLocations[i].academyDisplayName
            });
        }
        gridStore.loadRawData(arr, true);*/
        $this.resetPageSetting(gridStore);
        gridStore.getProxy().extraParams = {
        	campaigId: campaignId
        }
        
        formWindow.down('#campaignNameAL').setValue(record.data.campaignName);
        formWindow.show();
        gridStore.load();
    },
    openCampaignNewSchoolALWindow: function(formWin, dataIndex, record) {
        var $this = this;
        var win = $this.getCampaignnewschoolalwindow();
        var alGrid = win.down('#campaignNewSchoolNameItemId');
        var gridStore = alGrid.getStore();
        var intakeYearIds = record.data.intakeYearId;
        var campaignTyp = record.data.campaignType;
        
        var alids=[];
		var academyLocationId = record.data.academyLocations;
		var academyLocationIds = null;
		if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
			for (var i in academyLocationId) {
					alids.push(academyLocationId[i].academyLocId)
			}
			academyLocationIds = alids.join();
		}
		$this.resetPageSetting(gridStore);
        gridStore.getProxy().extraParams = {
            campaigId: record.data.id,
            intakeYearId:intakeYearIds,
            campaignType:campaignTyp,
            academyLocationIds:academyLocationIds
        }
        formWin.show();
        gridStore.load();
    },
    multiselectMouseOverEvent: function(field){
    	var $this = this;
    	var campaignNewFormLayout = $this.getCampaignnewformlayout();
    	field.bodyEl.on('mouseover', function(e, t, eOpts) {
		    if(e.target.className == "x-tab-close-btn x-boxselect-item-close"){
		    	var fld = field;
		    	if(campaignNewFormLayout.config.isType == "EDIT" && fld.isDisabled()){
		    		e.target.style.backgroundPosition = "0px 0px";
    		    	e.stopPropagation();
    		    	e.preventDefault();
		    	}
		    	else{
		    		if(fld.itemId == "schoolPriority1Id"){
		    			e.target.style.backgroundPosition = "0px 0px";
	    		    	e.stopPropagation();
	    		    	e.preventDefault();
		    		} 
		    	}
		    }
		})
    },
    disableImportEnquiryCampaign:function(structure,permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var enquirynewuploaddownloadstructure = structure.down('#enquirynewuploaddownloadstructureItemId');
		enquirynewuploaddownloadstructure=false;
	
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				enquirynewuploaddownloadstructure = true;
			} else {
				enquirynewuploaddownloadstructure = false;
			}
		});

		this.showCampaignEnquiryTab(enquirynewuploaddownloadstructure, structure);
	},
	showCampaignEnquiryTab : function(enquirynewuploaddownloadstructure, structure) {
		var panelItem = new Array();
		var $this = this;
		var newcont=structure.items.items.length;
		var insertPosition=newcont+1;
			var panelItem = new Array();
 			var $this = this;
 			var newcont = structure.items.items.length;
 			var insertPosition = newcont;
 			panelItem.push({
 				xtype:'tabpanel',
 				plain: true,
 				style:{overflow:'hidden !important',margin:'0!important'},
 				bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
 				frame: false,
 				border:false,
 				items:[{
 					title :getCommonTranslation('SEARCH'),     
 					items : [{
 						xtype: 'campaignnewfilter',
 						itemId: 'campaignnewfilterItemId',
 					},{
 						xtype: 'campaignnewgrid',
 						itemId: 'campaignnewgridItemId'
 					}]
 					}]
 				});
			
			
			var insertAt = panelItem["0"].items.length;
 			if (enquirynewuploaddownloadstructure) {
 				panelItem["0"].items[insertAt] = {
 						xtype:'enquirycampaignuploaddownloadstructure',
						itemId:'enquirycampaignuploaddownloadstructureItemId',
						title: getTranslation('IMPORT_ENQUIRY')
 				};
 			}
			
			structure.insert(insertPosition,panelItem);
	}, 
	downloadUploadFormChangeCampaign: function(cb, nv, ov) {
        var $this = this;
        var downloadTemplateForm = this.getEnquirycampaigndownloadform();
        var uploadTemplateForm = this.getEnquirycampaignuploadform();
        var grid = $this.getImportlistenquirycampaigngrid();
        if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
            uploadTemplateForm.hide();
            downloadTemplateForm.show();
            grid.setVisible(false);
        } else {
     	   var uploadoptionradiogroupform  = $this.getEnquirycampaignuploadoptionradiogroup();
     	   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
     		   isUploadAll: false
     	   });
            downloadTemplateForm.hide();
            uploadTemplateForm.show();
            grid.setVisible(true);
        }
    },
    createJsonForEnquiryCampaignFormDownload: function() {
        var enquiryNewDownloadForm = this.getEnquirycampaigndownloadform();
        var academyLocIds = enquiryNewDownloadForm.down('#academyLocationItemId').value;
        var mainJson = new Object();
        var alArray = new Array();
        for (var i = 0; i < academyLocIds.length; i++) {
            alArray.push(academyLocIds[i].data.id);
        }
        mainJson.academyLocations = alArray;
        mainJson.campaignNewId = enquiryNewDownloadForm.down('#campaignNameId').getValue();
        return mainJson;
    }, 
    getDownloadFileCampaign: function(documentId, fileType) {
        if (!isNullOrEmpty(documentId)) {
            var csvForm = Ext.create('Ext.form.Panel');
            csvForm.getForm().submit({
                target: '_blank',
                method: 'POST',
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token
                },
                headers: {
                    'Authorization': Ext.Ajax.defaultHeaders.Authorization
                },
                url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
                standardSubmit: true
            });
        } 
    },
    setAcademyLocationAndOwnerDefault: function(){
    	var $this = this;
    	var formLayout = $this.getCampaignnewformlayout();
    	var brandCampusId = formLayout.down('#brandCampusId');
    	var multiBrandCampusId = formLayout.down('#multiBrandCampusId');
    	var ownerId = formLayout.down('#ownerId');
    	var selectSchoolFld1 = formLayout.down('#selectSchoolFld1');
    	var schoolPriorityFld = formLayout.down('#schoolPriorityFld');
    	var intakeYearIdCombo= formLayout.down('#intakeYearId');
    	var loggedInUserId = $this.getCurrentlyLoggedInUser().id;
    	var store = brandCampusId.getStore();
    	var multiStore = multiBrandCampusId.getStore();
    	var academyLocationId = this.getCurrentAcademyLocation();
    	store.getProxy().extraParams = {
    		id: loggedInUserId
    	};
    	multiStore.getProxy().extraParams = {
    		id: loggedInUserId
    	};
    	multiBrandCampusId.reset();
    	brandCampusId.reset();
    	store.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(selectSchoolFld1.isVisible()){
        				if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
        					selectSchoolFld1.down('#schoolId1').setDisabled(false);
        				}
    					var extraParamsSchool = selectSchoolFld1.down('#schoolId1').getStore().getProxy().extraParams;
    			    	if(!isNullOrEmpty(extraParamsSchool.intakeYearId)){
    			    		delete extraParamsSchool.intakeYearId;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.academyLocationIds)){
    			    		delete extraParamsSchool.academyLocationIds;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.schoolName)){
    			    		delete extraParamsSchool.schoolName;
    			    	}
    			    	
    				}
    				if(schoolPriorityFld.isVisible()){
    					if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
    						schoolPriorityFld.down('#schoolId').setDisabled(false);
        				}
    					var extraParamsSchool = schoolPriorityFld.down('#schoolId').getStore().getProxy().extraParams;
    			    	if(!isNullOrEmpty(extraParamsSchool.intakeYearId)){
    			    		delete extraParamsSchool.intakeYearId;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.academyLocationIds)){
    			    		delete extraParamsSchool.academyLocationIds;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.schoolName)){
    			    		delete extraParamsSchool.schoolName;
    			    	}
    				}
    				brandCampusId.setValue(academyLocationId);
    				
    				var ownerComboStore = ownerId.getStore();
    				ownerComboStore.load({
    					callback: function(records, operation, success) {
    						ownerId.setValue(loggedInUserId);
    					}
    				});
    			}
    		}
    	});
    	multiStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(selectSchoolFld1.isVisible()){
    					if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
    						selectSchoolFld1.down('#schoolId1').setDisabled(false);
        				}
    					var extraParamsSchool = selectSchoolFld1.down('#schoolId1').getStore().getProxy().extraParams;
    			    	if(!isNullOrEmpty(extraParamsSchool.intakeYearId)){
    			    		delete extraParamsSchool.intakeYearId;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.academyLocationIds)){
    			    		delete extraParamsSchool.academyLocationIds;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.schoolName)){
    			    		delete extraParamsSchool.schoolName;
    			    	}
    				}
    				if(schoolPriorityFld.isVisible()){
    					if(!isNullOrEmpty(intakeYearIdCombo.getValue())){
    						schoolPriorityFld.down('#schoolId').setDisabled(false);
        				}
    					var extraParamsSchool = schoolPriorityFld.down('#schoolId').getStore().getProxy().extraParams;
    			    	if(!isNullOrEmpty(extraParamsSchool.intakeYearId)){
    			    		delete extraParamsSchool.intakeYearId;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.academyLocationIds)){
    			    		delete extraParamsSchool.academyLocationIds;
    			    	}
    			    	if(!isNullOrEmpty(extraParamsSchool.schoolName)){
    			    		delete extraParamsSchool.schoolName;
    			    	}
    				}
    				multiBrandCampusId.setValue(academyLocationId);
    				
    				var ownerComboStore = ownerId.getStore();
    				ownerComboStore.load({
    					callback: function(records, operation, success) {
    						ownerId.setValue(loggedInUserId);
    					}
    				});
    			}
    		}
    	});
    }
});