/**
 * @author seshagiri.k
 */
Ext.define('Academia.controller.course.coursegroup.AssignCoursesController', {
    //extend: 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
    models: ['course.coursegroup.AssignCoursesModel','course.coursegroup.AssignSelectCourse'],
    stores: ['course.coursegroup.AssignCoursesStructureStore'/*,'course.coursegroup.ViewPerformanceStore'*/,
             'course.coursegroup.AssignSelectCourse'
             ],
    views: ['course.coursegroup.assigncourses.AssignCoursesStructure',
            'course.coursegroup.assigncourses.AssignCoursesStructureGrid',
            'course.coursegroup.assigncourses.AssignCoursesForm',
            'course.coursegroup.CourseGroupForm'],
    alias: "widget.AssignCoursesController",
    refs: [{
        ref: 'assignCoursesForm',
        selector: 'assignCoursesForm'
    }, {
        ref: 'assignCoursesStructureGrid',
        selector: 'assignCoursesStructureGrid'
    },
    {
        ref: 'courseGroupStructureGrid',
        selector: 'courseGroupStructureGrid'
    },
    {
	   	 ref: 'searchresultgrid',
		 selector: 'searchresultgrid[itemId=courseGroupStructureGrid]'
   },{
       ref: 'courseGroupForm',
       selector: 'courseGroupForm'
   },{
       ref: 'assigncoursesform',
       selector: 'assignCoursesForm form'
   }],
    init: function(application) {
        this.control({
            'assignCoursesStructureGrid button[itemId=btnAdd]': {
                click: function() {
                    this.canBeUpdated('add');
                }
            },
            'assignCoursesStructureGrid button[itemId=btnEdit]': {
                click: function() {
                    this.canBeUpdated('edit');
                }
            },
            'assignCoursesStructureGrid button[itemId=btnView]': {
                click: function() {
                    this.viewFormWindow();
                }
            },
            'assignCoursesStructureGrid button[itemId=btnDelete]': {
                click: function() {
                    this.canBeUpdated('delete');
                }
            },
            'assignCoursesForm combo[itemId=courseGroup_Id]': {
            	 select:function(obj, record){ 
                    var rec = record[0].get('courseCredits');
                    var form = Ext.getCmp('assigncoursesform').getForm();
                    form.findField('courseCredits').setValue(rec);
                    
                    var whetherMandatoryId = form.findField('whetherMandatoryitem').setValue(rec);
                    whetherMandatoryId.reset();
            	    
            	    var enrollmentCriteria =form.findField('enrollmentCriteriaId').setValue(rec);
            	    enrollmentCriteria.reset();
            	    enrollmentCriteria.allowBlank = true;
        			enrollmentCriteria.setVisible(true);
   			  },
            
            change:function(){
            	     var form = Ext.getCmp('assigncoursesform').getForm();
            	     form.findField('courseCredits').reset();
           }
            
            },
               

            'assignCoursesForm radiogroup[itemId=whetherMandatory_id]':{
            	change:function(obj, record){
            		
                       var form = Ext.getCmp('assigncoursesform').getForm();
            		var enrollmentCriteria = form.findField('enrollmentCriteriaId');
            		
                		if(record.whetherMandatory) {
                			enrollmentCriteria.setVisible(false);
                			enrollmentCriteria.allowBlank = true;
                		}
                		else {
                			enrollmentCriteria.allowBlank = false;
                			enrollmentCriteria.setVisible(true);
                		}
            		}
            	
            },
            'assignCoursesForm form button[itemId=saveAssignCoursesButtonId]': {
                click: this.saveUpdateUser
            },
            'assignCoursesForm form button[itemId=btnCancelAssignCoursesForm]': {
                click: this.closeFormWindow
            },
            'assignCoursesStructureGrid' : {
            	render : function() {
            		var $this = this;
            		//var grid = $this.getSearchresultgrid();
            		var form = $this.getCourseGroupForm().getForm();
            		var store = $this.getStore('course.coursegroup.AssignCoursesStructureStore');
            		//var records = grid.getSelectionModel().getSelection();
            		//alert('hi ' + form.findField('id').getValue());
            		var courseId = form.findField('id').getValue();
            		/*if(form.findField('id').getValue() == null){
            			// edit case
            			courseId = records[0].data.ID;
            			records[0].data.ID = null;
            		}
            		else{
            			// add case
            			courseId = form.findField('id').getValue();
            		}*/
            		
            		store.getProxy().extraParams = {
            			id : courseId
            		};
            		store.load();
            	}
            },
            'assignCoursesForm':{
            	render: function(window){
    				var $this = this;
    				window.body.on('click', function() {
    					var filter = window.down('idgeneratorformwin');
    	    			$this.hideInvalidIconFromField(filter);
    	    	       });
    			}
            }
        });
    },
    editShowFormWindow: function() {
        var formWindow = this.getAssignCoursesForm();
        if (!formWindow) {
            Ext.widget('assignCoursesForm');
            formWindow = this.getAssignCoursesForm();
        }
        formWindow.show();
        this.courseGroupcode();
//        this.courseSelectFilter();	
    },
    showFormWindow: function() {
        var formWindow = this.getAssignCoursesForm();
        if (!formWindow) {
            Ext.widget('assignCoursesForm');
            formWindow = this.getAssignCoursesForm();
        }
        formWindow.show();
        this.courseGroupcode();
		this.courseSelectFilter();	
    },
    closeFormWindow: function() {
        this.getAssignCoursesForm().close();
    },
    viewFormWindow: function() {
    	
    	this.editFormWindow();
		 var form = Ext.getCmp('assigncoursesform').getForm();
		 if (form) {
		Ext.ComponentQuery.query('button#saveAssignCoursesButtonId')[0].hide(); 
		Ext.ComponentQuery.query('button#btnCancelAssignCoursesForm')[0].hide();  
			toggleReadOnlyFormItems(form, true);
		}
    },
    canBeUpdated: function(mode){
    	var $this = this;
    	/*var form = $this.getCourseGroupForm().getForm();
    	var id = form.findField('id').getValue();
    	*/
    	
    	
    	if(mode == 'add'){
    		$this.showFormWindow();
    	}else{
    		 var grid = $this.getAssignCoursesStructureGrid();
			 if(grid.getSelectionModel().getCount() > 0){
        	 var record = grid.getSelectionModel().getSelection()[0];
             
        	 var courseGroupCourseId = record.get("id");
    		 var courseGroupId = record.get("courseGroupId");
    		 var courseId = record.get("courseId");
    		 
    		 Ext.Ajax.request({
    	    		type : 'rest',
    	    		url : SERVERURL.PATH_CHECK_IF_GROUP_IS_MAPPED,
    	    		params : {
    	    			courseGroupId : courseGroupId,
    	    			courseId:courseId
    	    		},
    	    		method : 'GET',
    	    		success : function(response) {
    	    			var res = response.responseText;
    	    			if(res == "SUCCESS"){
    	    				 if(mode == 'edit')
     	    					$this.editFormWindow();
     	    				else if(mode == 'delete')
     	    					$this.deleteRecord();
    	    			}
    	    			else{
    	    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation(res));
    	    			}
    	    		}
    	    	});
			}else{
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
    	}
			
    },
    editFormWindow: function() {
        var grid = this.getAssignCoursesStructureGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this.editShowFormWindow();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
            	 var id = records[0].data.id;
     
            	Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.ASSIGN_COURSE_FIND_BY_ID,
					params : {
						courseGroupCourseId : id,
						courseName : ''
					},
					method : 'GET',
					 success : function(response) {
						 var data = Ext.JSON.decode(response.responseText);
						 var form = Ext.getCmp('assigncoursesform').getForm();
						 
						 var whetherMandatory =  data[0].whetherMandatory;
				
						 form.findField('courseGroupName').setVisible(true);
						 form.findField('courseName').setVisible(false);
						 form.findField('courseName').allowBlank=true;
//        				 form.findField('courseId').setValue(data[0].courseId);
//        				 form.findField('courseGroupName').setRawValue(data[0].courseCode);
						 var courseGroupNameCombo = form.findField('courseGroupName');
						 var courseStore = courseGroupNameCombo.getStore();
						 courseStore.getProxy().extraParams = {
							 courseGroupId: data[0].courseGroupId,
							 courseId:data[0].courseId
						   }
						 courseStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
                   				courseGroupNameCombo.setValue(data[0].courseId);
                   			  }
                   		  }
                   	  });
	                	  
//        				 form.findField('courseGroupName').setValue(data[0].courseId);
	                			
       				  	form.findField('id').setValue(data[0].id);
       				    form.findField('courseCredits').setValue(data[0].courseCredits);
       				    form.findField('whetherMandatoryValue').setValue(data[0].whetherMandatory);
       				    form.findField('enrollmentCriteria').setValue(data[0].enrollmentCriteria);
       				    form.findField('courseCluster').setValue(data[0].courseClusterId);
       				    form.findField('whetherMajor').setValue(data[0].whetherMajor);
       				    
       				var whetherMandatoryRadio =Ext.ComponentQuery.query('radiogroup#whetherMandatory_id')[0];
       				    
						if(whetherMandatory){
							whetherMandatoryRadio.items.items[0].setValue(true);
							whetherMandatoryRadio.items.items[1].setValue(false);
						}else if(!whetherMandatory){
							whetherMandatoryRadio.items.items[0].setValue(false);
							whetherMandatoryRadio.items.items[1].setValue(true);
						}
       				
       					var button =Ext.ComponentQuery.query('button#saveAssignCoursesButtonId')[0];
       					button.setText('Save');
       				 }
            	});
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    deleteRecord: function() {
        var grid = this.getAssignCoursesStructureGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('TITLE_ASSIGN_COURSES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            	
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    
                    var id = record.get("id");
                    
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'rest',
                        url: SERVERURL.ASSIGN_COURSE_GROUPS_DELETE + '?id='+ id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params: {
                            id: id
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getCommonTranslation('TITLE_ASSIGN_COURSES'),
    								getCommonTranslation('SUCCESS'));
                        }
                    });
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
        }
    },
    saveUpdateUser: function(model, records) {
    	var $this = this;
    	var form = Ext.getCmp('assigncoursesform').getForm();
    	var values = form.getValues();
    	var mainForm = $this.getCourseGroupForm().getForm();
    	var courseId = mainForm.findField('id').getValue();
    	var assignCourses = new Academia.model.course.coursegroup.AssignCoursesModel();
    	var assignCourseStore = this.getAssignCoursesStructureGrid().getStore();
    	var assignCoursGroups = values.courseName;
    	 var assignCourseGroupIds = [];
    	var enrollmentCriteria = values.enrollmentCriteria;
    	var whetherMandatory = values.whetherMandatory;
    	var courseCluster = values.courseCluster;
    	var whetherMajor= values.whetherMajor;
    	
    	 
    	if(whetherMandatory)
    		enrollmentCriteria = null;
    	
    	 if(assignCoursGroups !=undefined && assignCoursGroups.length > 0){
    		 for(var i in assignCoursGroups){
    			 if(Ext.isObject(assignCoursGroups[0])){
    				 assignCourseGroupIds.push(assignCoursGroups[i].get("id"));
    			 }else{
    				 assignCourseGroupIds.push(assignCoursGroups[i]);
    			 }
    		 }
    	 }
    	
    	
     	var courseArray = [];
    	for(var i=0; i< assignCourseGroupIds.length;i++){
    	/*assignCourses.set("id", values.id);
    	assignCourses.set("whetherMandatory", values.whetherMandatory);
    	assignCourses.set("courseGroupId", courseId);
    	assignCourses.set("courseId", values.courseName);*/
    		
    		courseArray.push({
    			"id": values.id,
    			"whetherMandatory" : values.whetherMandatory,
    			"courseGroupId": courseId,
    			"courseId": assignCourseGroupIds[i],
    			"enrollmentCriteria" : enrollmentCriteria,
    			"courseClusterId":courseCluster,
    			"whetherMajor":whetherMajor

    		});
    	}
    	
    	var submitUrl;
    	var selectedCourseLength = 0;
    	var courseAddedMandateLength = 0;
    	var courseAddedOptionalLength = 0;
    	var maxCourses = mainForm.findField('maxCourses').getValue();
    	var maxCourseEnrollment=mainForm.findField('maxCourseEnrollment').getValue();
    	var maxOptionalCourses = mainForm.findField('optionalMaxCourses').getValue();
    	var maxMandateCourses=maxCourseEnrollment;
    	var willSubmit = false,willStop=false;
    	
    	assignCourseStore.each(function(obj){
    		if(obj.get('whetherMandatory')){
    			courseAddedMandateLength = courseAddedMandateLength+1;
    		} else {
    			courseAddedOptionalLength = courseAddedOptionalLength+1;
    		}
    	});
    	
    	if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
    		
    		//assignCourses.set("courseId", values.courseName);
    		selectedCourseLength=values.courseName.length;
    		submitUrl = SERVERURL.ASSIGN_COURSE_ADD;
    		var jData = courseArray;
    	} else {
    		
    		/*var courseId111 =form.findField('courseId').getValue();   
    		if(values.courseName>0){*/
    			assignCourses.set("courseId", values.courseGroupName);
    		/*}else{
    			assignCourses.set("courseId", courseId111);
    		}*/
    			selectedCourseLength=1
    			var whetherMandatoryValue = form.findField('whetherMandatoryValue').getValue();
    			if(whetherMandatoryValue=="true"){
    				if(whetherMandatory && courseAddedMandateLength>0){
    					courseAddedMandateLength=courseAddedMandateLength-1;
    				}else if(!whetherMandatory){
    					courseAddedMandateLength=courseAddedMandateLength-1;
    				}
    				
    			}else{
    				if(!whetherMandatory && courseAddedOptionalLength>0){
    					courseAddedOptionalLength=courseAddedOptionalLength-1;
    				}else if(whetherMandatory){
    					courseAddedOptionalLength=courseAddedOptionalLength-1;
    				}
    			}
    			assignCourses.set("whetherMandatory", values.whetherMandatory);
        		assignCourses.set("courseGroupId", courseId);
        		assignCourses.set("enrollmentCriteria", values.enrollmentCriteria);
        		if(whetherMandatory)
        		assignCourses.set("enrollmentCriteria", null);
        		assignCourses.set("id", values.id);
        		assignCourses.set("courseClusterId", values.courseCluster);
        		assignCourses.set("whetherMajor", values.whetherMajor);
        		
        		

    		submitUrl = SERVERURL.ASSIGN_COURSE_UPDATE;
    		var formData = Ext.encode(assignCourses.data);
    		var jData  = formData;
    	}
    	
       	if((maxCourses>=(courseAddedMandateLength+courseAddedOptionalLength+selectedCourseLength)) && (selectedCourseLength<=maxCourses)){
       if(whetherMandatory){
    		if((courseAddedMandateLength == 0 && selectedCourseLength <= maxMandateCourses) || (courseAddedMandateLength > 0 && selectedCourseLength<=(maxMandateCourses-courseAddedMandateLength))){
    			willSubmit = true;
    		} 
    	} else {
    		if((courseAddedOptionalLength == 0 && selectedCourseLength <= maxOptionalCourses) || (courseAddedOptionalLength > 0 && selectedCourseLength<=(maxOptionalCourses-courseAddedOptionalLength))){
    			willSubmit = true;
    		} 
    	}
	
    }
//    	var courseAddedLength =  assignCourseStore.data.length;
						    	if (willSubmit) {
							$this.applyWindowMask();
							Ext.Ajax
									.request({
										type : 'rest',
										url : submitUrl,
										jsonData : jData,
										method : 'POST',
										success : function(form, action) {
											$this.hideWindowMask();
										// Ext.JSON.decode(form.responseText);
											/*
											 * showSuccessMessage(getCommonTranslation('TITLE_ASSIGN_COURSES'),
											 * getCommonTranslation('SUCCESS'));
											 */

											if (form.responseText == 'SUCCESS') {
												showSuccessMessage(
														getCommonTranslation('TITLE_ASSIGN_COURSES'),
														getCommonTranslation('SUCCESS'));
												$this.getStore('course.coursegroup.AssignCoursesStructureStore').load();
												$this.getAssignCoursesForm().down('form').getForm().reset();
												$this.getAssignCoursesForm().close();
											} else if (form.responseText == 'COURSE_WITH_M_CANT_BE_ADDED') {
												showWarningMessage(getCommonTranslation('ALERT'),
														getProgramandcourseTranslation('MARK_TYPE_COURSE_CANT_BE_ADDED_COURSE_GROUP'));
											} else if (form.responseText == 'COURSE_WITH_G_CANT_BE_ADDED') {
												showWarningMessage(getCommonTranslation('ALERT'),
														getProgramandcourseTranslation('GRADE_TYPE_COURSE_CANT_BE_ADDED_COURSE_GROUP'));
											}else {
												showWarningMessage(getCommonTranslation('ALERT'),
														getProgramandcourseTranslation(form.responseText));
									}

											$this.getStore('course.coursegroup.AssignCoursesStructureStore').load();
											$this.getAssignCoursesForm().down('form').getForm().reset();
											$this.getAssignCoursesForm().close();
										}
									});
						} else {
    		if(whetherMandatory){
    			if((maxCourses<=(courseAddedMandateLength+courseAddedOptionalLength))){
    				willStop=true;
    				
    				}else{
    					if(maxMandateCourses==null){
        					maxMandateCourses=0;
        				}
    			       showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('WE_CAN_ADD_ONLY') +' '+maxMandateCourses+ ' '+getCommonTranslation('COUNT_OF_MANDATORY_COURSES')+'.');
    			     }
    			}else{
    				if((maxCourses<=(courseAddedMandateLength+courseAddedOptionalLength))){
    					willStop=true;
    					}else{
    			          showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('WE_CAN_ADD_ONLY') +' '+ maxOptionalCourses +' '+ getCommonTranslation('COUNT_OF_OPTIONAL_COURSES')+'.');
        			}
    	  }
    		if(willStop){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('WE_CAN_ADD_ONLY')+' '+maxCourses+ ' '+getCommonTranslation('MAX_COURSES')+'.');
    			
    		}
    	}
    },
    courseGroupcode :function(){
    	var $this = this;
    	var mainForm = $this.getCourseGroupForm().getForm();
    	var code = mainForm.findField('code').getValue();
    	//var grid = $this .getSearchresultgrid();

    	//var records = grid.getSelectionModel().getSelection();
    	//if (records != undefined && records != "" && records != null) {
    	//var code = records[0].data.COURSE_GROUP_CODE;
    	var form = Ext.getCmp('assigncoursesform').getForm();
    	form.findField('courseCode').setValue(code);

    	//}
    },
    courseSelectFilter:function(){

    	var $this = this;
    	//var grid = $this .getSearchresultgrid();
    	//var records = grid.getSelectionModel().getSelection();
    	//var courseId = records[0].data.ID;

    	var form = $this.getCourseGroupForm().getForm();
    	var courseId = form.findField('id').getValue();
    	var store = $this.getStore('course.coursegroup.AssignSelectCourse');
    	store.getProxy().extraParams = {
    		courseGroupId: courseId
    	};
    	store.load(); 
    }
    
});