/*
 * This controller is used for Course Specialization Tab(Course Specialization Links)   
 */
/**
 * @author Raj Kumar
 * @author seshagiri.k
 */
Ext.define('Academia.controller.course.coursespecialization.CourseSpecializationController', {
    extend: 'Academia.controller.base.BaseController',
	models : ['course.coursespecialization.CourseSpecializationModel',
	          'common.IdValueCodeDataModel','course.coursespecialization.CourseSpecializationSubmitModel'],
    stores : ['course.coursespecialization.CourseSpecializationStore','course.coursespecialization.CourseSpecializationCourseGroup',
              'course.coursespecialization.CourseSpecializationGroupStore','course.coursespecialization.CourseSpecializationProgram','course.coursespecialization.AllSpecializationGroupStore'],
    views : [ 'course.coursespecialization.CourseSpecializationStructure',
              'course.coursespecialization.CourseSpecializationGrid',
              'course.coursespecialization.CourseSpecializationFormWindow',
              'course.coursespecialization.CourseSpecializationForm',
              'course.coursespecialization.history.ViewHistoryTabStructure',
              'course.coursespecialization.history.ViewRelatedProgramStructure',
              'course.coursespecialization.history.ViewPerformenceStructure',
              'baselayout.contentarea.ContentPanel',
              'course.coursespecialization.CourseSpecializationListing',
              'course.coursespecialization.CourseSpecializationForm','course.coursespecialization.CourseSpecializationCourseGroup',
              'course.coursespecialization.CourseSpecializationProgram','course.CourseLinkDetails','course.coursespecialization.CourseSpecializationCourseGroupGrid'],
              
              alias : "widget.coursespecializationcontroller",
   config:{
	   	/*
	   	 	* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	   	 	*/
			/**
			 * @cfg {Array} COURSESPECIALIZATION_PERMISSIONS array (required)
			 * The array of permissions to use for Access control wise enabling and disabling buttons.
			 * @accessor
			 */
	       COURSESPECIALIZATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSESPECIALIZATION_PRIVILEGES')
         },
         
              refs : [{
            	  ref: 'coursespecialization',
            	  selector: 'coursespecialization'
              },{
            	  ref: 'coursespecializationformWindow',
            	  selector: 'coursespecializationformwindow form'
              },{
            	  ref: 'coursespecializationgrid',
            	  selector: 'coursespecializationgrid'
              },{
            	  ref: 'viewperformencestructure',
            	  selector: 'viewperformencestructure'
              },{
            	  ref: 'coursespecializationform',
            	  selector: 'coursespecializationform'
              },{
            	  ref: 'coursespecializationformwindow',
            	  selector: 'coursespecializationformwindow'
              },{
            	  ref: 'viewhistorytabstructure',
            	  selector: 'viewhistorytabstructure'
              },{
            	  ref: 'contentPanel',
            	  selector: 'contentPanel'
              },{
            	  ref: 'viewrelatedprogramstructure',
            	  selector: 'viewrelatedprogramstructure'
              },{
            	  ref: 'coursespecializationlisting',
            	  selector: 'coursespecializationlisting'
              },{
            	  ref: 'coursespecializationform',
            	  selector: 'coursespecializationform'
              },{
             	 ref: 'searchresultgrid',
            	 selector: 'searchresultgrid[itemId=coursespecializationgrid]'
             },{
           	  ref: 'coursespecializationcoursegroup',
        	  selector: 'coursespecializationcoursegroup'
          },{
           	  ref: 'coursespecializationprogram',
        	  selector: 'coursespecializationprogram'
          },{
           	  ref: 'coursespecializationcoursegroupgrid',
        	  selector: 'coursespecializationcoursegroupgrid'
          }],
              init: function() {
            	  this.control({
            		 /* 'coursespecializationgrid ': {
            			  render : function(){
            				  this.onGridRender();
            			  }
            		  },*/
            		  /*'searchresultgrid[itemId=coursespecializationgrid]':{
             			 render:function(grid){
             				var permissionsMap = new Ext.util.HashMap();
                            this.gridRenderFunction(grid);
                            permissionsMap = this.getCOURSESPECIALIZATION_PERMISSIONS();
                            this.genericCBGridAccessControlValidation(grid,permissionsMap);
             			 }
             		 },*/
            		  'coursespecialization':{
            			  afterrender:function(structure){
  		            		var grid = structure.down('#coursespecializationgrid');
  		   				    this.getCBGridHeaderFreeze(grid,structure);
  		            	}
            		  },
             		'coursespecializationform button[itemId=courseSpecSearchButtonId]' : {
        				click : this.loadCourseSpecializationGrid
        			},
             		'coursespecializationform button[itemId=courseSpecResetId]' : {
        				click : function(obj){
        					var form=obj.up('form');
        					form.getForm().reset();
        				}
        			},
            		  'searchresultgrid[itemId=coursespecializationgrid] button[itemId=searchResultGridBtnAdd]': {
            			  click: function() {
            				  this.showCoursespecializationformwindow();
            			  }
            		  },'searchresultgrid[itemId=coursespecializationgrid] button[itemId=searchResultGridBtnEdit]': {
            			  click: function() {
            				  this.editFormWindow();
            			  }
            		  },'searchresultgrid[itemId=coursespecializationgrid] button[itemId=searchResultGridBtnView]': {
            			  click: function() {
            				  this.viewFormWindow();
            			  }
            		  },'searchresultgrid[itemId=coursespecializationgrid] button[itemId=searchResultGridBtnDelete]': {
            			  click: function() {
            				  this.deleteRecord();
            			  }
            		  },
            		  'coursespecializationformwindow button[itemId=btnViewHistory]': {
            			  click: function() {
            				  this.showViewHistoryTabStructureWindow();
            			  }
            		  },'viewrelatedprogramform button[itemId=btnCompareVRPSForm]': {
            			  click: function() {
            				  var menuController = Academia.app.getController('menu.CoreERPNavigationController');
            				  menuController.addTab(getCommonTranslation('VIEW_RELATED_PROGRAMS'), 'viewrelatedprogramstructure');
            			  }
            		  },'viewperformenceprogramform button[itemId=btnCompareVPPSForm]': {
            			  click: function() {
            				  var menuController = Academia.app.getController('menu.CoreERPNavigationController');
            				  menuController.addTab(getCommonTranslation('VIEW_PERFORMENCE_PROGRAM'), 'viewperformencestructure');
            			  }
            		  },'coursespecializationform button[itemId=btnClear]': {
            			  click: function() {
            				  this.refreshForm();
            			  }
            		  },
            		  'coursespecializationform textfield[itemId=csf_name]': {
            			  change : function(f) {
            				  this.enableDisableName(f);
            			  }
            		  },
            		  'coursespecializationform textfield[itemId=csf_code]': {
            			  change : function(f) {
            				  this.enableDisableCode(f);
            			  }
            		  },
            		  'coursespecializationformwindow button[itemId=CSForm_SaveButtonId]' : {
            			  click : this.saveCourseSpecialization
            		  },'coursespecializationformwindow button[itemId=CSForm_CancelButtonId]': {
            			  click: this.closeFormWindow
            		  },
            		  //
            		  'searchresultgrid[itemId=coursespecializationgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
          	            click: function() {
          	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
          	            }
          	        },
          	        'searchresultgrid[itemId=coursespecializationgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
          	            click: function() {
          	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
          	            }
          	        },
          	        'searchresultgrid[itemId=coursespecializationgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
          	            click: function() {
          	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
          	            }
          	        },
          	        'searchresultgrid[itemId=coursespecializationgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
          	            click: function() {
          	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
          	            }
          	        },
          	      'advancedsearchquerybuilder[itemId=advancedsearchCourseSpecializationList] searchresultgrid[itemId=userAdvSearchResultGrid]': {
                      cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                    	  var $this=this;
                      	  var searchResultGrid = grid.panel;
                            var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
                            if(columnName=='NO_OF_ASSOCIATED_COURSE' &&  record.data.NO_OF_ASSOCIATED_COURSE > 0){ // checked
   		                	  
     		                  	var store=$this.getStore('course.coursespecialization.CourseSpecializationCourseGroup');
     		                  	var submitURL=SERVERURL.FIND_ASSOCIATED_SPECIALIZED_COURSE_GROUP;
           					    store.getProxy().api.read=submitURL;
     		                  	store.getProxy().extraParams = {
     		                  		specializationId: record.data.ID
     		    					    };
     		                  	store.load();
     		                  	
     		                  	var formWindow = $this.getCoursespecializationcoursegroup();
     		     	       		        if (!formWindow) {
     		     	       		             Ext.widget('coursespecializationcoursegroup');
     		     	       		            formWindow = $this.getCoursespecializationcoursegroup();
     		     	       		        }
     		     	       		        formWindow.down('#courseGroup').setValue(record.data.SPECIALIZATION_NAME);
     		     	       		        formWindow.show();
     		              	   }
     		                  
     		                  if(columnName=='NO_OF_ASSOCIATED_PROGRAMS' &&  record.data.NO_OF_ASSOCIATED_PROGRAMS > 0){ // checked
     		                	  
     			                  	var store=$this.getStore('course.coursespecialization.CourseSpecializationProgram');
     			                  	store.getProxy().extraParams = {
     			                  		specializationId: record.data.ID
     			    					    };
     			                  	store.load();
     			                  	
     			                  	var formWindow = $this.getCoursespecializationprogram();
     			     	       		        if (!formWindow) {
     			     	       		             Ext.widget('coursespecializationprogram');
     			     	       		            formWindow = $this.getCoursespecializationprogram();
     			     	       		       }
     			  	       		        formWindow.show();
     			              	   }
                      }
          	      },
          	      'searchresultgrid[itemId=coursespecializationgrid]':{
          	    	 render:function(grid){
         				var permissionsMap = new Ext.util.HashMap();
                        this.gridRenderFunction(grid);
                        permissionsMap = this.getCOURSESPECIALIZATION_PERMISSIONS();
                        this.genericCBGridAccessControlValidation(grid,permissionsMap);
         			 },
 		 			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 		               	  var $this=this;
 		              	  var searchResultGrid = $this.getSearchresultgrid();
 		                  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
 		                  if(columnName=='NO_OF_ASSOCIATED_COURSE' &&  record.data.NO_OF_ASSOCIATED_COURSE > 0){ // checked
 		                	  
 		                  	var store=$this.getStore('course.coursespecialization.CourseSpecializationCourseGroup');
 		                  	var submitURL=SERVERURL.FIND_ASSOCIATED_SPECIALIZED_COURSE_GROUP;
       					    store.getProxy().api.read=submitURL;
 		                  	store.getProxy().extraParams = {
 		                  		specializationId: record.data.ID
 		    					    };
 		                  	store.load();
 		                  	
 		                  	var formWindow = $this.getCoursespecializationcoursegroup();
 		     	       		        if (!formWindow) {
 		     	       		             Ext.widget('coursespecializationcoursegroup');
 		     	       		            formWindow = $this.getCoursespecializationcoursegroup();
 		     	       		        }
 		     	       		        formWindow.down('#courseGroup').setValue(record.data.SPECIALIZATION_NAME);
 		     	       		        formWindow.show();
 		              	   }
 		                  
 		                  if(columnName=='NO_OF_ASSOCIATED_PROGRAMS' &&  record.data.NO_OF_ASSOCIATED_PROGRAMS > 0){ // checked
 		                	  
 			                  	var store=$this.getStore('course.coursespecialization.CourseSpecializationProgram');
 			                  	store.getProxy().extraParams = {
 			                  		specializationId: record.data.ID
 			    					    };
 			                  	store.load();
 			                  	
 			                  	var formWindow = $this.getCoursespecializationprogram();
 			     	       		        if (!formWindow) {
 			     	       		             Ext.widget('coursespecializationprogram');
 			     	       		            formWindow = $this.getCoursespecializationprogram();
 			     	       		       }
 			  	       		        formWindow.show();
 			              	   }
 		 		 }
 				
 				},
 				 'coursespecializationformwindow': {
 	    			render: function(window){
 	    				var $this = this;
 	    				window.body.on('click', function() {
 	    	    			var filter = window.down('form');
 	    	    			$this.hideInvalidIconFromField(filter);
 	    	    	       });
 	    			}
 	    		}
            	  });
              },
              onGridRender : function (){
            	  var $this = this;
            	  var grid = $this.getCoursespecializationgrid();
            	  var store = grid.getStore();
            	  store.load();
              },
              enableDisableCode : function(f){
            	  var val = f.getValue();
            	  if(!val){

            		  f.nextSibling().setReadOnly(false);

            	  }else{

            		  f.nextSibling().setReadOnly(true);      		
            	  }
              },
              enableDisableName : function(f){
            	  var val = f.getValue();
            	  if(!val){

            		  f.previousSibling().setReadOnly(false);

            	  }else{

            		  f.previousSibling().setReadOnly(true);	        		
            	  }

              },
              refreshForm:function(){

            	  var form = this.getCoursespecializationform().getForm();
            	  form.reset();
              },
              showCoursespecializationformwindow: function() {
//            	  var $this = this;
//            	  var store = this.getStore('course.coursespecialization.CourseSpecializationGroupStore');
            	  var formWindow = this.getCoursespecializationformwindow();
            	  if (!formWindow) {
            		  Ext.widget('coursespecializationformwindow');
            		  formWindow = this.getCoursespecializationformwindow();
            	  }
//            	  store.load();
            	  formWindow.down("#autoApproveSpecialization").setVisible(false);
            	  var permissionsMap = new Ext.util.HashMap();
            	  permissionsMap = this.getCOURSESPECIALIZATION_PERMISSIONS();
            	  var associatedAcadLocationIds = new Array();
            	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
            	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            	  Ext.each(permissionList, function(privilege) {
            		  if (privilege ==='AUTO_APPROVE_SPECIALIZATION') {
            			  formWindow.down("#autoApproveSpecialization").setVisible(true);
            		  }

            	  });
            	  formWindow.show();
              },
              closeFormWindow: function() {
            	  var form =  this.getCoursespecializationformwindow();
            	  form.close();
              },
              editFormWindow: function() {

            	  var grid = this.getSearchresultgrid();
            	  
            	  if (grid.getSelectionModel().getCount() > 0) {
            		  this.showCoursespecializationformwindow();
            		  var form = this.getCoursespecializationformWindow();
            		  var records = grid.getSelectionModel().getSelection();
            		 
            		  var record = records[0];
    				  var id = record.get("ID");
            		  Ext.Ajax.request({
    					  method: "GET",
    					  type: 'rest',
    					  url: SERVERURL.COURSE_SPECIALIZATION_FINDALL_SGBY_ID+'?specilizationId='+id,
    					  headers: {
    						  'Content-Type': 'application/json'
    					  },
    					  success: function(f) {
    						  var data = Ext.JSON.decode(f.responseText);
    						 var csmodel = new Academia.model.course.coursespecialization.CourseSpecializationModel(data);
    						 form.loadRecord(csmodel);
    						 form.getForm().findField("specializationCode").setReadOnly(true);

    	            		 // var formWindow = this.getCoursespecializationformwindow();
    	            		 // formWindow.down('#btnViewHistory').show();

    	            		  var courseGroups = data.courseGroup;
    	            		  var courseGroupItems;
    	            		  if(courseGroups.length>0){
    	            			  courseGroupItems=[];
    	            			  Ext.each(courseGroups, function(value) {
    	            				  courseGroupItems.push(value.id);
    	            			  });
    	            			  
    	            			 var coruseGroup = form.getForm().findField("courseGroup");//.setValue(courseGroupItems);
    	            			 var store = coruseGroup.getStore();
    	            			 store.load({
    	            				 callback : function(records,operation,success) {
    	                                 if (success) {
    	                                	 coruseGroup.setValue(courseGroupItems);
    	                                      }
    	                                  } 
    	            			 });
    	            			 
    	            		  }
    						 
    					  }
    				  });

            	  } else {
            		  showWarningMessage(getCommonTranslation('COURSE_SPECIALIZATION_MSG_BOX_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            	  }
              },
              viewFormWindow: function() {
            	  this.editFormWindow();
            	  var form =this.getCoursespecializationformWindow();
            	  if (form) {
            		  form.down('#CSForm_SaveButtonId').setVisible(false);
            		  form.getForm().findField("specializationName").setReadOnly(true);
            		  form.getForm().findField("specializationDescription").setReadOnly(true);
            		  form.getForm().findField("specializationNameOtherLanguage").setReadOnly(true);
            		  form.getForm().findField("autoApproveSpecialization").setReadOnly(true);
            		  var groupItems = form.getForm().findField("courseGroup");
            		  groupItems.setReadOnly(true)
            		   Ext.defer(function() {
            			  groupItems.el.dom.querySelector('input').readOnly = true;
            		  }, 500);
            		  //  groupItems.labelEl.setOpacity(1);
            	  }

              },deleteRecord: function() {
               	  var grid = this.getSearchresultgrid();

            	  if (grid.getSelectionModel().getCount() > 0) {
            		  showConfirmMessage(getCommonTranslation('COURSE_SPECIALIZATION_MSG_BOX_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            			  if (btn == 'yes') {
            				  var record = grid.getSelectionModel().getSelection()[0];
            				  var id = record.get("ID");
            				  Ext.Ajax.request({
            					  method: "DELETE",
            					  type: 'rest',
            					  url: SERVERURL.COURSE_SPECIALIZATION_DELETE+'?id='+id,
            					  headers: {
            						  'Content-Type': 'application/json'
            					  },
            					  success: function(form, action) {
            						  if (form.responseText == 'SUCCESS') {
            						  grid.getStore().reload();
            						  showSuccessMessage(getCommonTranslation('COURSE_SPECIALIZATION_MSG_BOX_TITLE'), getCommonTranslation('SUCCESS'));
            						 }else{
            							 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_SPECIALIZATION_DEPENDNCY'));            							 
            						 }
            					  }
            				  });
            			  }
            		  });
            	  } else {
            		  showWarningMessage(getCommonTranslation('COURSE_SPECIALIZATION_MSG_BOX_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
            	  }
              },
              saveCourseSpecialization : function(){

            	  var $this = this;
            	  var grid = $this.getSearchresultgrid();

            	  var frmWin = $this.getCoursespecializationformWindow();
            	  var form = frmWin.getForm();
            	  var value = form.getValues();


            	  var csModel = new Academia.model.course.coursespecialization.CourseSpecializationSubmitModel();
            
            	  csModel.set("specializationCode",value.specializationCode);
            	  csModel.set("specializationName",value.specializationName);
            	  csModel.set("specializationDescription",value.specializationDescription);
            	  csModel.set("specializationNameOtherLanguage",value.specializationNameOtherLanguage);
            	  csModel.set("autoApproveSpecialization",value.autoApproveSpecialization);            	  
            		  var groups = value.courseGroup;
            		  
            		  var courseGroup;
            		     var multiCGArrayData=[];
            		     for(var i in groups){
            		         if(Ext.isObject(groups[0])){
            		        	 courseGroup = groups[i].get("id");
            		        	 multiCGArrayData.push(courseGroup);
            		         }else{
            		        	 courseGroup = groups[i];
            		        	 multiCGArrayData.push(courseGroup);
            		         }
            		     }
            		  
            		  
            		  
            		  
                	  var myJson;
                	  if(multiCGArrayData.length>0){
                		  myJson = [];
                		  for(var i in multiCGArrayData){
                			  myJson.push({
                					  "id": multiCGArrayData[i]
                			  });
                		  }
                	  }
            	  csModel.set("courseGroup",myJson);
            	  
            	  if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
            		  submitUrl = SERVERURL.COURSE_SPECIALIZATION_CREATE;
            	  } else {
            		  csModel.set("id",value.id);
            		  submitUrl = SERVERURL.COURSE_SPECIALIZATION_UPDATE;
            	  }
            	  

            	  var formData = Ext.encode(csModel.data);
            	  $this.applyWindowMask(); 
            	  Ext.Ajax.request({
            		  type: 'rest',
            		  url: submitUrl,
            		  jsonData: formData,
            		  method: 'POST',
            		  success: function(form, action) {
            			  $this.hideWindowMask();
            			  grid.getStore().reload();
            			  $this.closeFormWindow();
            			  showSuccessMessage(getCommonTranslation('COURSE_SPECIALIZATION'), getCommonTranslation('SUCCESS'));
            		  }
            	  });
            	  


              },
              showViewHistoryTabStructureWindow: function() {
            	  this.closeFormWindow();
            	  var me=this;
            	  var contentpanel=me.getContentPanel();
            	  var viewstructure=Ext.widget('viewhistorytabstructure');
            	  var tabName=getCommonTranslation('HISTORY');
            	  openTab(contentpanel,tabName,viewstructure);

              },
              // toolbar for buttons
              gridRenderFunction:function(grid){
            	  grid.addButtonToolbar();
              },
              loadCourseSpecializationGrid : function(model, records) {
               	var quickSearchForm = this.getCoursespecializationform();
               	quickSearchForm.down('#courseSpecSearchButtonId').setDisabled(true);
           		var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
           		var searchResultGrid = this.getSearchresultgrid();
           		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
               	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.COURSE_SPECIALIZATION_LIST_VIEWCODE);
              	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,quickSearchForm.down('#courseSpecSearchButtonId'));
           	},
           	
           	createJsonFormat:function(quickSearchForm, record){			
           		var specializationCode = quickSearchForm.down('#specialization_code');
           		//var specializationName = quickSearchForm.down('#specialization_name');
           		
           		var values = new Object();
           		values.configCode = CONSTANTS.CB.COURSE_SPECIALIZATION_LIST_CONFIGCODE;
           		var searchcriteria = new Array();
           		if(specializationCode.getValue() != "" && specializationCode.getValue() != null){
           			searchcriteria.push({paramCode:"SPECIALIZATION_CODE", paramValues:[specializationCode.getValue()]});
           		}
           		/*if(specializationName.getValue() != ""){
           			searchcriteria.push({paramCode:"SPECIALIZATION_NAME", paramValues:[specializationName.getValue()]});
           		}*/
           		values.searchCriterias=searchcriteria;
           		return values;
           	},
           	//
           	/*exportList : function(exportUrl,filetype,whetherAll) {
           		var quickSearchForm=this.getCoursespecializationform();	
           		var searchResultGrid = this.getSearchresultgrid();
           		var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
           		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
           		var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
           		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
           		jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
           		}
           		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString);
           		}, */
           	exportUserList : function(exportUrl,filetype,whetherAll) {
                var quickSearchForm=this.getCoursespecializationform(); 
                var searchResultGrid = this.getSearchresultgrid();
                var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
                var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
                var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
                var visibleColumns=this.getVisibleColumns(searchResultGrid);
                var reportTitle=getCommonTranslation("COURSE_SPECIALIZATION_LIST");
  if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                              jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                       }
  searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

  },


           		createSearchCriteriaString: function(searchForm) {
           		    	 var me=this;
           		        var formValues = new Array();
           		        formValues = searchForm.getValues();        
           		        var searchCriteriaString="";
           		        for (var key in formValues) {
           		        	var value = formValues[key];            
           		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
           		                var keyValueJsonObject = me.getJsonObject( key , value);
           		searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
           		            }
           		        }
           		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
           		        return searchCriteriaString;
           		},
           		getJsonObject : function(key, value, additionalValue) {
					if (value != '' && value != null
							&& additionalValue == undefined) {
						return {
							"paramCode" : key,
							"paramValues" : [ value ]
						};
					} else if (value != '' && additionalValue != undefined) {
						return {
							"paramCode" : key,
							"paramValues" : [ value, additionalValue ]
						};
					}
				}
});

