/**
 * @author sumit.meena
 * 
 */
Ext.define('Academia.controller.course.readingmaterial.ReadingMaterialController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['course.readingmaterial.ReadingNameStore','course.readingmaterial.ReadingTypeStore','course.readingmaterial.PublisherStore',
	          'course.readingmaterial.ReadingMaterialConditionStore','user.UserAcademyLocationStore','course.readingmaterial.ReadingMaterialDetailsConditionStore',
	          'course.readingmaterial.ReadingMaterialGridStr','course.readingmaterial.InvtItemMasterDetailUploadStore','course.readingmaterial.InvtItemMasterDetailDownloadStore',
	          'course.readingmaterial.ISBNTenStore','course.readingmaterial.ISBNThirteenthStore',
	          'course.readingmaterial.PncMapCoursesStore','common.StatusComboStore',
	          'course.readingmaterial.PncMapCoursesPrescribedRecStore','coursetransaction.coursereading.DistributionMode','course.readingmaterial.InvtItemMasterReadingStockDetailStore',
	          'coursetransaction.coursereading.CourseReadingListGrid','Academia.store.course.readingmaterial.FirstAuthorStore'],
	          
	views : ['course.readingmaterial.ReadingMaterialStructure','course.readingmaterial.ReadinMaterialFilter',
	         'course.readingmaterial.ReadingMaterialForm','course.readingmaterial.readingmaterialinformation.ReadingMaterialInformationStructure',
	         'course.readingmaterial.readingmaterialinformation.AddInformationForm','common.CustomForm',
	         'course.readingmaterial.readingmaterialinformation.ReadingMaterialGrid','course.readingmaterial.readingmaterialinformation.InvtItemMasterDetailDocument',
	         'course.readingmaterial.readingmaterialinformation.InvtItemMasterDetailDocumentWin','course.readingmaterial.readingmaterialinformation.InvtItemMasterDetailDownloadDocumentGrid',
	         'course.readingmaterial.readingmaterialinformation.MapCoursesPncForm',
	         'course.readingmaterial.readingmaterialinformation.MapCoursesPncGrid','course.readingmaterial.readingmaterialinformation.InvtItemMasterReadingStockDetailGrid',
	         'coursetransaction.coursereading.ResourceRequestDetailsPncForm','course.readingmaterial.readingmaterialinformation.MapLinkedCoursesDetailPncForm',
	         'course.readingmaterial.readingmaterialinformation.MapLinkedCoursesDetailPncGrid',
	         'Academia.view.coursetransaction.coursereading.AssignCoursesList'],		
	         config: {
				 READING_MATERIAL_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('READING_MATERIAL_INFORMATION_PRIVILEGES'),
				 ADD_STOCK_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADD_STOCK_PRIVILEGES')
                  }, 
	         
	         
	         refs : [{
				ref:'readingMaterialMasterGrid',
				selector:'searchresultgrid[itemId=readingMaterialMasterGridItemId]'
		    },{
		    	ref:'readinmaterialfilter',
				selector:'readinmaterialfilter'
		    },{
		    	ref:'readingmaterialform',
				selector:'readingmaterialform'
		    },{
				ref : 'contentPanel',
				selector : 'contentPanel'
			},{
				ref : 'addinformationform',
				selector : 'addinformationform'
			},{
				ref : 'readingmaterialinformationstructure',
				selector : 'readingmaterialinformationstructure'
			},{
				ref : 'inventoryDetailGrid',
				selector : 'searchresultgrid[itemId=inventoryDetailGridItemId]'
			},{
				ref : 'readingmaterialgrid',
				selector : 'readingmaterialgrid'
			},{
				ref : 'readingmaterialstructure',
				selector : 'readingmaterialstructure'
			},{
				ref : 'invtitemmasterdetaildocument',
				selector : 'invtitemmasterdetaildocument'
			},{
				ref : 'invtitemmasterdetaildocumentwin',
				selector : 'invtitemmasterdetaildocumentwin'
			},
			{
				ref : 'invtitemmasterdetaildownloaddocumentgrid',
				selector : 'invtitemmasterdetaildownloaddocumentgrid'
			},
			{
				ref : 'mapcoursespncform',
				selector : 'mapcoursespncform'
			},
			{
				ref : 'mapcoursespncgrid',
				selector : 'mapcoursespncgrid'
			},{
				ref : 'invtitemmasterreadingstockdetailgrid',
				selector : 'invtitemmasterreadingstockdetailgrid'
			},{
				 ref : 'resourcerequestdetailspncform',
				 selector : 'resourcerequestdetailspncform'
			},{
				 ref : 'maplinkedcoursesdetailpncform',
				 selector : 'maplinkedcoursesdetailpncform'
			},{
				ref : 'assigncourseslist',
				selector : 'assigncourseslist'
			},{
				 ref : 'maplinkedcoursesdetailpncgrid',
				 selector : 'maplinkedcoursesdetailpncgrid'
			}],
           init : function() {
	        	  this.control({
	        		'readingmaterialstructure':{
	        			afterrender : function(structure){
	        				var grid = structure.down('readingmaterialgrid');
	        				var form = structure.down('form');
		     				 this.getGridHeaderFreeze(grid,form);
	        			}
	        		},'readingmaterialgrid':{
	        			 render: function(grid){
	        			   this.doAccessControlValidation(grid, this.getREADING_MATERIAL_INFORMATION_PERMISSIONS());
                           this.disableMoreActionPivileges(grid, this.getREADING_MATERIAL_INFORMATION_PERMISSIONS());
	        			 },

	        			 
	        			 afterrender: function(grid) {
	        	                var me = this;
	        	               me.addDataGridConfigButton(grid,me.getREADING_MATERIAL_INFORMATION_PERMISSIONS());
	        	               },

	        			 cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	     					if (e.target.tagName == 'A') {
	     						var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	     						var $this = this;
	     						if(dataIndex == 'courseId'){
	     							$this.openLinkedCoursesDetailsTab(dataIndex, record);
	     						}
	     					}
	         			}
	        		},'invtitemmasterreadingstockdetailgrid':{
	        			render: function(grid){
	        				this.doAccessControlValidation(grid, this.getADD_STOCK_PERMISSIONS());
	        			},
	        			cellclick : function(grids,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	        				var $this=this;
	        				var invtitemmasterreadingstockdetailgrid = grids.up();
	        				var columnName=invtitemmasterreadingstockdetailgrid.columnManager.columns[cellIndex].dataIndex;
	        				if(e.target.tagName == 'A'){
	        					if(columnName=='noOfDocument' &&  record.data.noOfDocument> 0){ // checked
	        						//var store=$this.getStore('course.readingmaterial.InvtItemMasterDetailUploadStore');
	        						var formWindow = $this.getInvtitemmasterdetaildocumentwin();
	        						if (!formWindow) {

	        							formWindow = Ext.widget('invtitemmasterdetaildocumentwin');
	        							//$this.getInvtitemmasterdetaildocumentwin().getStore().reload();
	        							//$this.getInvtitemmasterdetaildocumentwin().getView().refresh();
	        							//$this.getInvtitemmasterdetaildocumentwin().getStore().loadData(searchResultGrid);

	        						}
	        						var downloadStore=formWindow.down('grid').getStore();
	        						downloadStore.getProxy().extraParams = {
	        							invtMasterDetailId: record.data.id
	        						};
	        						//$this.resetPageSetting(store);
	        						downloadStore.load();
	        						formWindow.show();

	        					}
	        				}
	        			}
	        		},
	        		  /*'searchresultgrid[itemId=readingMaterialMasterGridItemId]': {
                         render: function(grid){
                             this.gridRenderFunction(grid);
                        	 console.log('perm..',this.getREADING_MATERIAL_INFORMATION_PERMISSIONS());
                             this.genericCBGridAccessControlValidation(grid, this.getREADING_MATERIAL_INFORMATION_PERMISSIONS());
                             this.disableMoreActionPivileges(grid, this.getREADING_MATERIAL_INFORMATION_PERMISSIONS());
                         }
         		       },*/
//         		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] button[itemId=searchResultGridBtnAdd]': {
	        		  	'readingmaterialgrid button[itemId=btnAdd]': {
                           click: function(grid){
                             this.showReadingMaterialTab();
                           }
           		       },
           		       'readingmaterialgrid button[itemId=btnEdit]': {
           		    	   click: function(grid){
           		    		   this.editReadingMaterialTab();
           		    	   }
           		       },
//         		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] button[itemId=searchResultGridBtnView]': {
           		    'readingmaterialgrid button[itemId=btnView]': {
                           click: function(grid){
                             this.viewDataOfReadingMaterial();
                           }
           		       },
//         		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] button[itemId=searchResultGridBtnDelete]': {
           		    'readingmaterialgrid button[itemId=btnDelete]': {
                           click: function(){
                             this.deleteReadingMaterialMasterGrid();
                           }  
           		       },
//         		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] splitbutton[itemId=spBtnMoreActions] #addInventoryItemId': {
           		       'readingmaterialgrid splitbutton[itemId=spBtnMoreActions] #addInventoryItemId': {
                           click: function(){
                        	   this.loadDataOnInformationTab();
                           }
           		       },
//         		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] splitbutton[itemId=spBtnMoreActions] #inventoryDetailItemId': {
           		    'readingmaterialgrid splitbutton[itemId=spBtnMoreActions] #inventoryDetailItemId': {
         		    	  click: function(){
         		    		 this.loadDataOnInformationTab("inventoryDetail");
         		    	  }
         		       },
         		       'readingmaterialgrid button[itemId=mapCourseReadingMaterail]': {
         		    	   click: function(){

         		    		   var me = this;
         		    		   var contentpanel = me.getContentPanel();
         		    		   var mapcoursespncform = Ext.widget('mapcoursespncform');
         		    		   var tabName = getCourseTxCommonTranslation('MAP_COURSES');
         		    		   /**
         		    		    * This is to remove tab from content panel and open same tab again 
         		    		    */
         		    		   var getcontroller=this.getController('menu.CoreERPNavigationController');
         		    		   var getTab=getcontroller.getTab(tabName);
         		    		   if(getTab!=null){
         		    			   contentpanel.remove(getTab, true);
         		    		   }
         		    		   openTab(contentpanel, tabName, mapcoursespncform,CONSTANTS.MENU_COLOR_THREE);
         		    	   }
         		       },
         		       'readingmaterialgrid splitbutton[itemId=spBtnMoreActions] #mapCourseVariantReadingMaterail': {
         		    	   click: function(){
         		    		   var $this = this;
         		    		   var grid = $this.getReadingmaterialgrid();
         		    		   if (grid.getSelectionModel().getCount() > 0) {		    	 
         		    			   var me = this;
         		    			   var contentpanel = me.getContentPanel();
         		    			   var structure = Ext.widget('resourcerequestdetailspncform');
         		    			   var tabName = getCommonTranslation("RESOURCE_REQUEST_DETAILS");
         		    			   var record = grid.getSelectionModel().getSelection()[0];
         		    			   var readingId = record.data.readingId;
         		    			   var alId = this.getCurrentAcademyLocation();
         		    			   var assignCourseList = structure.down('#assigncourseslistItemId');
         		    			   assignCourseList.getStore().removeAll();
         		    			   assignCourseList.getStore().clearFilter();
         		    			   assignCourseList.config.readingId = readingId;
         		    			   assignCourseList.config.academyLocationId = alId;
         		    			   var getcontroller=$this.getController('menu.CoreERPNavigationController');
         		    			   var getTab=getcontroller.getTab(tabName);
         		    			   if(getTab!=null){
         		    				   contentpanel.remove(getTab, true);
         		    			   }
         		    			   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);

         		    			   if(!isNullOrEmpty(record.data.isbnTen) && !isNullOrEmpty(record.data.isbnThirteen)){
         		    				   var readingNameFull = record.data.readingName+' / '+record.data.isbnTen+' / '+record.data.isbnThirteen;
         		    				   structure.down('#readingNameRRDId').setValue(readingNameFull);
         		    			   }
         		    			   else if(!isNullOrEmpty(record.data.isbnTen)){
         		    				  var readingNameFull = record.data.readingName+' / '+record.data.isbnTen;
        		    				   structure.down('#readingNameRRDId').setValue(readingNameFull);
         		    			   }
         		    			   else if(!isNullOrEmpty(record.data.isbnThirteen)){
         		    				   var readingNameFull = record.data.readingName+' / '+record.data.isbnThirteen;
         		    				   structure.down('#readingNameRRDId').setValue(readingNameFull);
         		    			   }
         		    			   else{
         		    				   structure.down('#readingNameRRDId').setValue(record.data.readingName);
         		    			   }

         		    			   structure.down('#resourceTypeRRDId').setValue(record.data.readingType);
         		    			   
         		    			   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
         		    			   Ext.Ajax.request({
         		    				   type: 'rest',
         		    				   url: SERVERURL.PATH_FIND_COURSE_READING_ACADEMIC_TERM,
         		    				   method: 'GET',
         		    				   params: {
         		    					  readingId:record.data.readingId
         		    				   },
         		    				   success: function(response, action) {
         		    					   Ext.getBody().unmask();
         		    					   var responseData = Ext.decode(response.responseText);
         		    					   if(!isNullOrEmpty(responseData) && responseData.length>0){
         		    						   var ObjModel = [];
         		    						   var cntLC = 1;
         		    						   responseData.forEach(function(obj){
         		    							   var dateVal = obj.dateRequired;
         		    							   if(!isNullOrEmpty(obj.dateRequired)){
         		    								   dateVal = dateRender(obj.dateRequired);
         		    							   }
         		    							   var assignCoursesModel = new Academia.model.coursetransaction.coursereading.AssignCourses();
         		    							   assignCoursesModel.set("serialNo", cntLC);
         		    							   assignCoursesModel.set("academicTermId", obj.academicTermId);
         		    							   assignCoursesModel.set("courseId", obj.courseId);
         		    							   assignCoursesModel.set("courseDepartment", obj.courseDepartment);
         		    							   assignCoursesModel.set("dateRequired", dateVal);
         		    							   assignCoursesModel.set("userRequestedId", obj.userRequestedId);
         		    							   assignCoursesModel.set("issuedNumber", obj.issuedNumber);
         		    							   assignCoursesModel.set("readingId", obj.readingId);
         		    							   assignCoursesModel.set("id", obj.id);
         		    							   assignCoursesModel.set("courseVariantId", obj.courseVariantId);
         		    							   assignCoursesModel.set("courseVariantCode", obj.courseVariantCode);
         		    							   assignCoursesModel.set("courseReadingId", obj.courseReadingId);
         		    							   assignCoursesModel.set("isAddDeleteRow", true);
         		    							   assignCoursesModel.commit();
         		    							   ObjModel.push(assignCoursesModel);
         		    							   cntLC = cntLC+1;
         		    						   });
         		    						   assignCourseList.getStore().loadRawData(ObjModel, true);
         		    						   assignCourseList.getStore().sort([
         		    							   {
         		    								   property : 'serialNo',
         		    								   direction: 'ASC'
         		    							   }
         		    							   ]);
         		    						   assignCourseList.getStore().sorters.clear();
         		    						   assignCourseList.down('#assignCourse_Add_Id').hide();
         		    						   assignCourseList.down('#academicTerm').setVisible(true);
         		    						   assignCourseList.down('#fldContCVSaveItemId').setVisible(true);
         		    						   assignCourseList.down('#resetBtn').setVisible(true);
         		    					   }
         		    				   }
         		    			   });

         		    		   }else{
         		    			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         		    		   }
         		    	   }
         		       },
         		     
          		      'readinmaterialfilter button[itemId=searchBtn]':{
	        			 click:function(obj){
	        				 this.loadReadingMasterGrid();
	        			}  
	        		  },
	        		  'readinmaterialfilter button[itemId=resetBtn]' : {
	        			  click : function(){
	        				  this.resetReadinmaterialfilter();
	        			  }
	        		  },
	        		  'readinmaterialfilter combo[itemId=readingTypeItemId]':{
	        			 select:function(obj,rec){
	        				 var data=rec[0].data.id;
	        				 var form=obj.up('form').getForm();
	        				 var readingNameField=form.findField('readingName');
	        				 readingNameField.enable();
	        				 readingNameField.getStore().getProxy().extraParams={
	        					 inventoryTypeId: data
	                         },
	                         readingNameField.getStore().load();
	        			}  
	        		  },
	        		  'readingmaterialform button[itemId=submitBtn]':{
	        			  click:function(){
	        				  this.saveReadingMaterialData();
	        			  }
	        		  },
	        		  'readingmaterialform customcombobox#readingTypeItemId':{
	        			  select:function(obj, record){
	        				  var form = obj.up('form').getForm();
	        				  var data = record[0].data.value;
	        				  var readingName = form.findField('readingName');
	        				  if(data=="Link") {
	        					  readingName.setFieldLabel(getCommonTranslation('LINK'));
	        					  
	        				  } else  if(data=="Youtube"){
	        					  readingName.setFieldLabel(getCommonTranslation('YOUTUBE'));
	        				  } else {
	        					  readingName.setFieldLabel(getCourseTxCommonTranslation('READING_NAME'));
	        					  this.setAllowBlank(readingName,false);
	        				  }
	        			  }
	        		  },
	        		  
	        		  'readingmaterialform button[itemId=cancelBtn]':{
	        			  click:function(obj){
	        				  var getForm=obj.up('form').getForm();
	        				  getForm.reset();	        				  
	        			  }
	        		  },
	        		  'readingmaterialinformationstructure [itemId=btnAdd]':{
	        			  click:function(){
	        				  this.showAddinformationform();
	        			  }
	        		  },
	        		  'addinformationform [itemId=submitBtn]':{
	        			  click:function(){
	        				  this.saveAddReadingMaterialInformationData();
	        			  }
	        		  },
	        		  'addinformationform button[itemId=resetBtn]':{
	        			  click:function(obj){
	        				  var getForm=obj.up('form').getForm();
	        				  getForm.findField('academyLocationId').reset();
	        				  getForm.findField('quantity').reset();
	        				  getForm.findField('vendorName').reset();
	        				  getForm.findField('purchaseDate').reset();
	        				  getForm.findField('invtItemCondition').reset();
	        				  getForm.findField('remark').reset();
	        			  }
	        		  },
	        		  'addinformationform button[itemId=invtMasterDetailDocumentId]':{
	        			  click:function(){
	        				  this.getDocumentController().showDocumentFormWindow('invtMasterDetailItemId', 'DOCUMENT');
	        			  }
	        		  },
	        		  'addinformationform':{
	        			  render:function(form){
	        				  $this = this;
	        				  var docGridStore =form.down('invtitemmasterdetaildocument').getStore();
	        				  $this.getStore('course.readingmaterial.InvtItemMasterDetailUploadStore').removeAll();
	        				  docGridStore.removeAll();

	        			  }
	        		  },
          		      'searchresultgrid[itemId=inventoryDetailGridItemId]':{
          		    	render: function(grid){
     	    				this.gridRenderFunctionNew(grid); 	
     	    			},
     	    			
 	        			cellclick : function(grids,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	        				var $this=this;
 	        				var searchResultGrid = grids.up();
 	        				var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
 	        				if(e.target.tagName == 'A'){
 	        					if(columnName=='NO_OF_DOCUMENT' &&  record.data.NO_OF_DOCUMENT> 0){ // checked
 	        						//var store=$this.getStore('course.readingmaterial.InvtItemMasterDetailUploadStore');
 	        						var formWindow = $this.getInvtitemmasterdetaildocumentwin();
 	        						if (!formWindow) {

 	        							formWindow = Ext.widget('invtitemmasterdetaildocumentwin');
 	        							//$this.getInvtitemmasterdetaildocumentwin().getStore().reload();
 	        							//$this.getInvtitemmasterdetaildocumentwin().getView().refresh();
 	        							//$this.getInvtitemmasterdetaildocumentwin().getStore().loadData(searchResultGrid);

 	        						}
 	        						var downloadStore=formWindow.down('grid').getStore();
 	        						downloadStore.getProxy().extraParams = {
 	        							invtMasterDetailId: record.data.ID
 	        						};
 	        						//$this.resetPageSetting(store);
 	        						downloadStore.load();
 	        						formWindow.show();

 	        					}
 	        				}
 	        			}
          		      },
          		      'invtitemmasterdetaildownloaddocumentgrid': {
          		    	  cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
          		    		  var $this = this;
          		    		  var documentGrid = $this.getInvtitemmasterdetaildownloaddocumentgrid();
          		    		  var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

          		    		  if (columnName == "documentName") {
          		    			  if (e.target.tagName == 'A') {
          		    				  var documentId = record.get("documentId");
          		    				  if (!isNullOrEmpty(documentId)) {
          		    					  $this.getDocumentController().downloadDocumentFile(documentId);
          		    				  }
          		    			  }
          		    		  }
          		    	  }
          		      },
         		       'searchresultgrid[itemId=inventoryDetailGridItemId] button[itemId=searchResultGridBtnDelete]': {
                           click: function(){
                             this.deleteReadingInformationDetailGrid();
                           }  
           		       },
	        		  'searchresultgrid[itemId=readingMaterialMasterGridItemId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
      		            click: function() {
      		                this.exportReadingMaterialList(SERVERURL.PDFEXPORT,'pdf',false);
      		             }
	      		       },
	      		      'searchresultgrid[itemId=readingMaterialMasterGridItemId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	      		          click: function() {
	      		                this.exportReadingMaterialList(SERVERURL.PDFEXPORT,'pdf',true);
	      		          }
	      		       },
	      		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	      		            click: function() {
	      		                this.exportReadingMaterialList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	      		            }
	      		        },
	      		       'searchresultgrid[itemId=readingMaterialMasterGridItemId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	      		            click: function() {
	      		                this.exportReadingMaterialList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	      		           }
	      		       },
	      		       'documentformwindow[itemId=invtMasterDetailItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
	      		    	   click: function() {
	      		    		   var $this = this;
	      		    		   var isTransient = true;
	      		    		   var module = 'ProgramAndCourse';
	      		    		   var entityId;
	      		    		   var entityType = 'invtMasterDetaildocument';
	      		    		   var documentGrid = $this.getInvtitemmasterdetaildocument();

	      		    		   $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
	      		    			   var documentModel = new Academia.model.fdmanagement.FDManagementDocumentModel();
	      		    			   documentModel.set("documentName", response.name);
	      		    			   documentModel.set("path", response.path);
	      		    			   documentModel.set("type", response.type);
	      		    			   documentModel.set("documentName", response.name);
	      		    			   documentModel.set("isNewRecord", true);
	      		    			   documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));

	      		    			   var store = documentGrid.getStore();
	      		    			   store.add(documentModel);
	      		    			   if (documentGrid.isHidden() && store.data.items.length > 0) {
	      		    				   documentGrid.setVisible(true);
	      		    			   }
	      		    			   Ext.apply(documentGrid, {
	      		    				   code: null,
	      		    				   setCode: function(code) {
	      		    					   documentGrid.code = code;
	      		    				   },
	      		    				   getCode: function() {
	      		    					   return documentGrid.code;
	      		    				   }
	      		    			   });
	      		    			   documentGrid.setCode(documentModel);
	      		    			   $this.getDocumentController().closeDocumentFormWindow();
	      		    		   }, isTransient);
	      		    	   }
	      		       },
	                 'documentformwindow[itemId=invtMasterDetailItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId': {
	                	 click: function() {
	                		 this.getDocumentController().closeDocumentFormWindow();
	                	 }
	                 },
	                 'invtitemmasterdetaildocument button#btnDelete': {
	                 	click: function() {
	                 		var $this = this;
	                 		var grid = $this.getInvtitemmasterdetaildocument();
	                 		var serverURL = SERVERURL.INVT_ITEM_MASTER_DETAIL_DELETE;
	                 		if (grid.getSelectionModel().getCount() > 0) {
	                 			showConfirmMessage(getCommonTranslation('COURSE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                 				if (btn == 'yes') {
	                 					var store = grid.getStore();
	                 					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                 					var record = grid.getSelectionModel().getSelection()[0];
	                 					var id = record.get("id");
	                 					if (!isNullOrEmpty(id)) {
	                 						Ext.Ajax.request({
	                 							method: "DELETE",
	                 							type: 'rest',
	                 							url: serverURL + '?id=' + id,
	                 							headers: {
	                 								'Content-Type': 'application/json'
	                 							},
	                 							success: function(form, action) {
	                 								Ext.getBody().unmask();
	                 								store.reload();
	                 								showSuccessMessage(getCommonTranslation('COURSE'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	                 							}
	                 						});
	                 					} else {
	                 						if (record) {
	                 							store.remove(record);
	                 						}
	                 						Ext.getBody().unmask();
	                 					}
	                 				}
	                 			});
	                 		} else {
	                 			 showWarningMessage(getCourseTxCommonTranslation('COURSE_READ'), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                 		}
	                 	}
	                 },
	                 'invtitemmasterdetaildocument' : {
	        			  cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	        				  var $this = this;
	        				  var documentGrid = $this.getInvtitemmasterdetaildocument();
	        				  var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	        				  if (columnName == "documentName") {
	        					  if (e.target.tagName == 'A') {
	        						  var documentId = record.get("documentId");
	        						  if (!isNullOrEmpty(documentId)) {
	        							  $this.getDocumentController().downloadDocumentFile(documentId);
	        						  }
	        					  }
	        				  }
	        			  }
	        		  },
	        		  'readinmaterialfilter' : {
	        			  render : function(form) {
	        				  var $this = this;
	        				  permissionsMap = this.getREADING_MATERIAL_INFORMATION_PERMISSIONS();
	        				  var associatedAcadLocationIds = new Array();
	        				  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        				  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        				  var readingMaterial, otherResource = false;
	        				  var radioButton = form.down('#sectionTypeId');
	        				  var criteriaBasedGradeFieldId = form.down('#materialTypeRadioFieldId');
	        				  criteriaBasedGradeFieldId.setVisible(false);
	        				  Ext.each(permissionList, function(privilege) {
	        					  if (privilege === 'PC_READING_MATERIAL') {
	        						  readingMaterial = true;
	        					  }
	        					  if (privilege === 'PC_OTHER_RESOURCES') {
	        						  otherResource = true;
	        					  }
	        				  });
	        				  if (readingMaterial && otherResource) {
	        					  criteriaBasedGradeFieldId.setVisible(true);
	        					  radioButton.items.items[0].setValue(true);
	        					  radioButton.items.items[1].setValue(false);
	        				  } else if (readingMaterial && !otherResource) {
	        					  criteriaBasedGradeFieldId.setVisible(false);
	        					  radioButton.items.items[1].setVisible(false);
	        					  radioButton.items.items[0].setValue(true);
	        				  } else if (otherResource && !readingMaterial) {
	        					  criteriaBasedGradeFieldId.setVisible(false);
	        					  radioButton.items.items[1].setValue(true);
	        					  radioButton.items.items[0].setVisible(false);
	        				  } else  if (!readingMaterial && !otherResource) {
	        					  criteriaBasedGradeFieldId.setVisible(false);
	        					  radioButton.items.items[1].setVisible(false);
	        					  radioButton.items.items[0].setValue(true);
	        				  }
	        				  var multiselectAcademyLocationId = form.down("#multiselectAcademyLocationId");
	        				  var alIds=[];
	        				  alIds.push(this.getCurrentAcademyLocation());
	        				  var multiselectAcademyLocationStore=multiselectAcademyLocationId.getStore();
	        				  multiselectAcademyLocationStore.load({
	        					  callback: function(records, operation, success) {
	        						  if (success) {
	        							  if(records.length > 0){
	        								  multiselectAcademyLocationId.setValue(alIds);
	        								  multiselectAcademyLocationId.setValue(alIds);
	        								  
	        							  }		 
	        						  }
	        					  }
	        				  });
	        				  academyLocationIds = alIds.join();
	        				  $this.onAcademyLocationSelectionAndReset(form, academyLocationIds);
	        				  if(!isNullOrEmpty($this.getReadingmaterialgrid())){
	        					  $this.getReadingmaterialgrid().getStore().removeAll();
	        		 			   try {
	        		 				  $this.getReadingmaterialgrid().down('custompagingtoolbar').hide();
	        		 			   }
	        		 			   catch(e){
	        		 			   }
	        				  }
	        			  }
	        		  },
	  				'readinmaterialfilter multiselectcombofield[itemId=multiselectAcademyLocationId]': {
	  					blur:function(ob,rec) {
	  						var form = this.getReadinmaterialfilter();
	  						var grid = this.getReadingmaterialgrid();
	  						grid.down('#exportReport').setDisabled(true);
	  						var academicTermCombo = form.down('#academicTerm');
	  						var programCombo = form.down('#programId');
	  						var batchCombo = form.down('#batchId');
	  						var periodCombo = form.down('#periodId');
	  						var courseCombo = form.down('#courseId');
	  						var courseDepartment = form.down('#courseDepartment');
	  						var readingTypeCombo = form.down('#resourceTypeId');
	  						var readingNameFilter = form.down('#readingNameId');
	  						var isbnTenCombo = form.down('#isbnTenId');
	  						var isbnThirteenthCombo = form.down('#isbnThirteenthId');
	  						academicTermCombo.reset();
	  						programCombo.reset();
	  						batchCombo.reset();
	  						periodCombo.reset();
	  						courseCombo.reset();
	  						courseDepartment.reset();
	  						readingTypeCombo.reset();
	  						readingNameFilter.reset();
	  						isbnTenCombo.reset();
	  						isbnThirteenthCombo.reset();

	  						batchCombo.setDisabled(true);
	  						periodCombo.setDisabled(true);

	  						var alinfomodel = Academia.model.authentication.ALInfoModel;
	  						var wheatherSchool = alinfomodel.get('wheatherSchool');
	  						if(wheatherSchool){
	  							periodCombo.setVisible(false);
	  						}else{
	  							periodCombo.setVisible(true);
	  						}	                  		

	  						var academyLocationId = ob.up('form').down('#multiselectAcademyLocationId').getValue();
	  						var alIds=[];
	  						var academyLocationIds; 

	  						if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
	  							for(var i in academyLocationId){
	  								if(Ext.isObject(academyLocationId[i])){
	  									alIds.push(academyLocationId[i].get("id"));
	  								}else{
	  									alIds.push(academyLocationId[i]);
	  								}
	  							}
	  						} else {
	  							alIds.push(this.getCurrentAcademyLocation());
	  						}
	  						academyLocationIds = alIds.join();

	  						var departmentStore = courseDepartment.getStore();
	  						departmentStore.getProxy().extraParams = {
	  							academyLocationIds : academyLocationIds
	  						};
	  						departmentStore.load();

	  						var academicTermStore = academicTermCombo.getStore();
	  						academicTermStore.getProxy().extraParams = {
	  							academyLocationIds : academyLocationIds
	  						};
	  						academicTermStore.load();
	  						
	  						var coursestore = courseCombo.getStore();
	  						coursestore.getProxy().extraParams = {	
	  							academyLocationIds:academyLocationIds
	  						};
	  						coursestore.load();

	  						var programStore =  programCombo.getStore();
	  						programStore.getProxy().extraParams = {	
	  							academyLocationIds:academyLocationIds
	  						};
	  						programStore.load();
	  						
	  						var readingNameStore =  readingNameFilter.getStore();
	  						readingNameStore.getProxy().extraParams = {	
	  							inventoryTypeId:null
	  						};
	  						readingNameStore.load();
	  						
	  						var isbnTenStore = isbnTenCombo.getStore();
	  		            	isbnTenStore.getProxy().extraParams = {	
	  		            		inventoryTypeId: null
	  		            	};
	  		            	isbnTenStore.load();

	  		            	var isbnThirteenthStore = isbnThirteenthCombo.getStore();
	  		            	isbnThirteenthStore.getProxy().extraParams = {	
	  		            		inventoryTypeId: null
	  		            	};
	  		            	isbnThirteenthStore.load();
	  					}
	  				},
	  				'readinmaterialfilter combo#academicTerm': {
	                	  select: function(obj, record) {
	                		  var this$ = this;
	                		  var academicTermId = obj.value;
	                		  var form = this$.getReadinmaterialfilter();
	                		  var academicTermCombo = form.down('#academicTerm');
	                		  var courseDepartmentCombo = form.down('#courseDepartment');
	                		  var programCombo = form.down('#programId');
	                		  var batchCombo = form.down('#batchId');
	                		  var periodCombo = form.down('#periodId');
	                		  var courseCombo = form.down('#courseId');
	                		  var grid = this.getReadingmaterialgrid();
		  					  grid.down('#exportReport').setDisabled(false);
	                		  programCombo.reset();
	                		  batchCombo.reset();
	                		  periodCombo.reset();
	                		  courseCombo.reset();
	                		  courseDepartmentCombo.reset();

	                		  batchCombo.setDisabled(true);
	                		  periodCombo.setDisabled(true);
	                		  
	                		  var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		  var wheatherSchool = alinfomodel.get('wheatherSchool');
	                		  if(wheatherSchool){
	                			  periodCombo.setVisible(false);
	                		  }else{
	                			  periodCombo.setVisible(true);
	                		  }
	                		  
	                		  var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
	                		  var alIds=[];
	                		  var academyLocationIds; 
	                		  if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
	                			  for(var i in academyLocationId){
	                				  if(Ext.isObject(academyLocationId[0])){
	                					  alIds.push(academyLocationId[i].get("id"));
	                				  }else{
	                					  alIds.push(academyLocationId[i]);
	                				  }
	                			  }
	                			  academyLocationIds = alIds.join();
	                		  }else {
	                			  alIds.push(this$.getCurrentAcademyLocation());
	                		  }
	                		  academyLocationIds = alIds.join();
	                		  if(academicTermId > 0) {
	                			  var coursestore = courseCombo.getStore();
	                			  coursestore.getProxy().extraParams = {	
	                				  academyLocationIds:academyLocationIds,
	                				  academicTermId:academicTermId
	                			  };
	                			  coursestore.load();
	                			  
	                			  var programStore =  programCombo.getStore();
	                			  programStore.getProxy().extraParams = {	
	                				  academyLocationIds:academyLocationIds,
	                				  academicTermId:academicTermId
	                			  };
	                			  programStore.load();
	                			  
	                			  var departmentStore = courseDepartmentCombo.getStore();
	  	  						departmentStore.getProxy().extraParams = {
	  	  							academyLocationIds : academyLocationIds,
	  	  							academicTermId:academicTermId
	  	  						};
	  	  						departmentStore.load();
	                		  }
	                	  }
	                  },
	                  'readinmaterialfilter combo#courseDepartment': {
	                	  select: function(obj, record) {
	                		  var this$ = this;
	                		  var departmentId = record[0].get("id");
	                		  var form = this$.getReadinmaterialfilter();
	                		  var programCombo = form.down('#programId');
	                		  var batchCombo = form.down('#batchId');
	                		  var periodCombo = form.down('#periodId');
	                		  var courseCombo = form.down('#courseId');
	                		  programCombo.reset();
	                		  batchCombo.reset();
	                		  periodCombo.reset();
	                		  courseCombo.reset();

	                		  batchCombo.setDisabled(true);
	                		  periodCombo.setDisabled(true);

	                		  var portalId = this.getCurrentLoggedPortalId();
	                		  var facultyId = null;
	                		  
	                		  var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		  var wheatherSchool = alinfomodel.get('wheatherSchool');
	                		  if(wheatherSchool){
	                			  periodCombo.setVisible(false);
	                		  }else{
	                			  periodCombo.setVisible(true);
	                		  }	      
	                		  
	                		  if(portalId == 2) {
	                			  facultyId = this.getCurrentlyLoggedInUser().id;
	                		  }
	                		  
	                		  var academicTermId=0;
	                		  if(form.down("#academicTerm").getValue()!=null){
	                			  academicTermId = form.down("#academicTerm").getValue();
	                		  }
	                		  var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
	                		  var alIds=[];
	                		  var academyLocationIds; 
	                		  if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
	                			  for(var i in academyLocationId){
	                				  if(Ext.isObject(academyLocationId[0])){
	                					  alIds.push(academyLocationId[i].get("id"));
	                				  }else{
	                					  alIds.push(academyLocationId[i]);
	                				  }
	                			  }
	                			  academyLocationIds = alIds.join();
	                		  }else {
	                			  alIds.push(this$.getCurrentAcademyLocation());
	                			  academyLocationIds = alIds.join();
	                		  }

	                		  if(departmentId > 0 && academicTermId>0) {
	                			  var coursestore = courseCombo.getStore();
	                			  coursestore.getProxy().extraParams = {	
	                				  facultyId : facultyId,
	                				  academyLocationIds:academyLocationIds,
	                				  academicTermId:academicTermId,
	                				  departmentId:departmentId
	                			  };
	                			  coursestore.load();
	                		  }
	                		  
	                		  if(departmentId > 0 && academicTermId==0) {
	                			  var coursestore = courseCombo.getStore();
	                			  coursestore.getProxy().extraParams = {	
	                				  facultyId : facultyId,
	                				  academyLocationIds:academyLocationIds,
	                				  departmentId:departmentId
	                			  };
	                			  coursestore.load();
	                		  }
	                	  }
	                  },
	                  'readinmaterialfilter combo[itemId=resourceTypeId]' : {
			 				 select:function(obj,rec){ 
			 					 var this$ = this;
			 					 var data=rec[0].get("id");
			 					 var form = this$.getReadinmaterialfilter();
		        				 
		        				 var isbnTenCombo = form.down('#isbnTenId');
		        				 isbnTenCombo.reset();
		        				 
		        				 var readingNameCombo = form.down('#readingNameId');
		        				 readingNameCombo.reset();
		        				 readingNameCombo.setDisabled(false);
		        				 
		        				 var isbnThirteenthCombo = form.down('#isbnThirteenthId');
		        				 isbnThirteenthCombo.reset();
		        				 
		        				 var readingNameStore = readingNameCombo.getStore();
		        				 readingNameStore.getProxy().extraParams = {
		        					 inventoryTypeId: data
		        				 },
		        				 readingNameStore.load();
		        				 
		        				 if(data>0){
		        					 var isbnTenStore = isbnTenCombo.getStore();
		        					 isbnTenStore.getProxy().extraParams = {	
		        						 inventoryTypeId: data
		        					 };
		        					 isbnTenStore.load();
		        					 
		        					 var isbnThirteenthStore = isbnThirteenthCombo.getStore();
		        					 isbnThirteenthStore.getProxy().extraParams = {	
		        						 inventoryTypeId: data
		        					 };
		        					 isbnThirteenthStore.load();
		        				 }
			 				 }
			 			 },
			 			 'readinmaterialfilter combo[itemId=readingNameId]' : {
			 				 select:function(obj,rec){ 
			 					 var this$ = this;
			 					 var data=rec[0].get("id");
			 					 var form = this$.getReadinmaterialfilter();
			 					 var isbnTenCombo = form.down('#isbnTenId');
			 					 isbnTenCombo.reset();

			 					 var isbnThirteenthCombo = form.down('#isbnThirteenthId');
			 					 isbnThirteenthCombo.reset();

			 					 var inventoryTypeId = form.down("#resourceTypeId").getValue();

			 					 if(data>0){
			 						 var isbnTenStore = isbnTenCombo.getStore();
			 						 isbnTenStore.getProxy().extraParams = {	
			 							 inventoryTypeId: inventoryTypeId,
			 							 readingNameId:data
			 						 };
			 						 isbnTenStore.load();

			 						 var isbnThirteenthStore = isbnThirteenthCombo.getStore();
			 						 isbnThirteenthStore.getProxy().extraParams = {	
			 							 inventoryTypeId: inventoryTypeId,
			 							 readingNameId:data
			 						 };
			 						 isbnThirteenthStore.load();
			 					 }
			 				 }
			 			 },
			 			 'readinmaterialfilter combo#programId':{
			 				 select : function(obj,record){
			 					 var this$ = this;
			 					 var programId = record[0].get('id');
			 					 var form = this$.getReadinmaterialfilter();

			 					 var portalId = this.getCurrentLoggedPortalId();
			 					 var facultyId = null;

			 					 if(portalId == 2) {
			 						 facultyId = this.getCurrentlyLoggedInUser().id;
			 					 }

			 					 var academicTermId=0;
			 					 if(form.down("#academicTerm").getValue()!=null){
			 						 academicTermId = form.down("#academicTerm").getValue();
			 					 }
			 					 var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
			 					 var alIds=[];
			 					 var academyLocationIds; 
			 					 if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
			 						 for(var i in academyLocationId){
			 							 if(Ext.isObject(academyLocationId[0])){
			 								 alIds.push(academyLocationId[i].get("id"));
			 							 }else{
			 								 alIds.push(academyLocationId[i]);
			 							 }
			 						 }
			 						 academyLocationIds = alIds.join();
			 					 }else {
			 						 alIds.push(this$.getCurrentAcademyLocation());
			 						 academyLocationIds = alIds.join();
			 					 }
			 					 
			 					 var programCombo=form.down("#programId");
			 					 var batchCombo=form.down("#batchId");
			 					 var periodCombo=form.down("#periodId");

			 					 batchCombo.setDisabled(false);
			 					 periodCombo.reset();
			 					 periodCombo.setDisabled(true);
			 					 if(academicTermId>0){
			 						 var batchStore=batchCombo.getStore();
			 						 batchStore.getProxy().extraParams = {
			 							 programId:programId,
			 							 academicTermId:academicTermId
			 						 };
			 						 batchStore.load({
			 							 callback: function(records, operation, success) {
			 								 if (success) {

			 									 if(records.length==1){
			 										 periodCombo.setDisabled(false);
			 										 var batchId = records[0].get('id');
			 										 batchCombo.setValue(batchId);

			 										 var periodStore = periodCombo.getStore();
			 										 periodStore.getProxy().extraParams = {
			 											 batchId:batchId,
			 											 academicTermId:academicTermId
			 										 };
			 										 periodStore.load({
			 											 callback: function(records, operation, success) {
			 												 if (success) {
			 													 if(records.length==1){
			 														 periodCombo.setValue(records[0].get('id'));
			 														 form.down("#periodId").setValue(records[0].get('id'));
			 													 }
			 												 }
			 											 }
			 										 });									
			 									 }
			 								 }
			 							 }
			 						 });
			 					 }else{
			 						 var batchStore=batchCombo.getStore();
			 						 batchStore.getProxy().extraParams = {
			 							 programId:programId,
			 						 };
			 						 batchStore.load({
			 							 callback: function(records, operation, success) {
			 								 if (success) {

			 									 if(records.length==1){
			 										 periodCombo.setDisabled(false);
			 										 var batchId = records[0].get('id');
			 										 batchCombo.setValue(batchId);

			 										 var periodStore = periodCombo.getStore();
			 										 periodStore.getProxy().extraParams = {
			 											 batchId:batchId,
			 										 };
			 										 periodStore.load({
			 											 callback: function(records, operation, success) {
			 												 if (success) {
			 													 if(records.length==1){
			 														 periodCombo.setValue(records[0].get('id'));
			 														 form.down("#periodId").setValue(records[0].get('id'));
			 													 }
			 												 }
			 											 }
			 										 });									
			 									 }
			 								 }
			 							 }
			 						 });
			 					 }
			 				 }
			 			 },
			 			 'readinmaterialfilter combo#batchId':{
			 				 select : function(obj,record){
			 					 var this$ = this;
			 					 var batchId = record[0].get('id');
			 					 var form = this$.getReadinmaterialfilter();

			 					 var portalId = this.getCurrentLoggedPortalId();
			 					 var facultyId = null;

			 					 if(portalId == 2) {
			 						 facultyId = this.getCurrentlyLoggedInUser().id;
			 					 }

			 					 var academicTermId=0;
			 					 if(form.down("#academicTerm").getValue()!=null){
			 						 academicTermId = form.down("#academicTerm").getValue();
			 					 }
			 					 var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
			 					 var alIds=[];
			 					 var academyLocationIds; 
			 					 if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
			 						 for(var i in academyLocationId){
			 							 if(Ext.isObject(academyLocationId[0])){
			 								 alIds.push(academyLocationId[i].get("id"));
			 							 }else{
			 								 alIds.push(academyLocationId[i]);
			 							 }
			 						 }
			 						 academyLocationIds = alIds.join();
			 					 }else {
			 						 alIds.push(this$.getCurrentAcademyLocation());
			 						 academyLocationIds = alIds.join();
			 					 }
			 					 var periodCombo=form.down("#periodId");
			 					 periodCombo.setDisabled(false);
			 					 if(academicTermId>0){
			 						 var periodStore = periodCombo.getStore();
			 						 periodStore.getProxy().extraParams = {
			 							 batchId:batchId,
			 							 academicTermId:academicTermId
			 						 };
			 						 periodStore.load();
			 					 }else{
			 						 var periodStore = periodCombo.getStore();
			 						 periodStore.getProxy().extraParams = {
			 							batchId:batchId
			 						 };
			 						 periodStore.load();
			 					 }
			 				 }
			 			 }
			 			 ,'readingmaterialstructure [itemId=readingmaterialgridId]':{
			 				 selectionchange: function(column, selected,eOpts ){
			 					 var grid=this.getReadingmaterialgrid();
			 					 var btnEdit= buttonsToolBar.query('#btnEdit')[0];
			 					 if(selected.length== 1){ 
			 						 grid.down('#spBtnMoreActions').setDisabled(false);
			 						 if(selected[0].data.courseId > 0) {
			 							 //btnEdit.setDisabled(false);
			 							grid.down('#btnEdit').setDisabled(false);
			 							 grid.down('#mapCourseVariantReadingMaterail').setDisabled(false);
			 						 } else {
			 							 //btnEdit.setDisabled(false);
			 							 grid.down('#btnEdit').setDisabled(false);
			 							 grid.down('#mapCourseVariantReadingMaterail').setDisabled(true);
			 						 }
			 					 }
			 					 else{
			 						 //btnEdit.setDisabled(true);
			 						 grid.down('#btnEdit').setDisabled(true);
			 						 grid.down('#spBtnMoreActions').setDisabled(true);
			 						 grid.down('#mapCourseVariantReadingMaterail').setDisabled(true);
			 					 }							
			 				 }
			 			 },
			 			 'mapcoursespncgrid button[itemId=btnAdd]':{
			 				 click:function(){
			 					 this.addMapCoursePncGridRecord(1);
			 				 }
			 			 },
			 			'mapcoursespncgrid button[itemId=btnSaveMapCourseItemId]':{
			 				 click:function(){
			 					 this.saveMapCoursePncGridRecord();
			 				 }
			 			 },
			 			 'mapcoursespncgrid':{
			 				 render:function(grid){
			 					 grid.getStore().removeAll();
			 				 },
			 				 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
			 					 var $this = this;
			 					 var grid = $this.getMapcoursespncgrid();
			 					 var columnName = grid.columnManager.columns[cellIndex].dataIndex;

			 					 if (e.target.tagName == 'DIV') {
			 						 if (columnName == "addButton") {
			 							 if (e.target.className == "addButtonClsForGridActionCls") {
			 								 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
			 									 var serialNo;
			 									 if (grid.getStore() != null)
			 										 serialNo = grid.getStore().getCount();
			 									 this.addMapCoursePncGridRecord(serialNo + 1, record);
			 									grid.getStore().totalCount = grid.getStore().count();
			 									grid.getView().refresh();
			 								 }
			 							 }
			 						 } else if (columnName == "deleteButton") {
			 							 if (e.target.className == "deleteButtonClsForGridActionCls") {
			 								 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {

			 									 grid.getStore().removeAt(rowIndex);
			 									 var models = grid.getStore().getRange();
			 									 for (var i = 0; i < models.length; i++) {
			 										 models[i].data.serialNo = i + 1;
			 									 }
			 									 grid.getStore().loadRawData(models, true);
			 									 if(models.length == 0){
			 										 grid.down('#btnAdd').show();
			 										 grid.down('#fldContSaveItemId').hide();
			 									 }
			 									 grid.getStore().totalCount = grid.getStore().count();
			 									 grid.getView().refresh();
			 								 }
			 							 }
			 						 }
			 					 }
			 				 }
			 			 },
			 			'mapcoursespncform':{
			 				render:function(form){
			 					var alId = this.getCurrentAcademyLocation();
			 					var academyLocationCombo = form.down('#academyLocationCombo');
			 					var resourceTypeCombo = form.down('#topicId');
			 					var academyLocationComboStore=academyLocationCombo.getStore();
			 					var resourceTypeComboStore=resourceTypeCombo.getStore();
			 					academyLocationComboStore.load({
			 						callback: function(records, operation, success) {
			 							if (success) {
			 								if(records.length > 0){
			 									academyLocationCombo.setValue(alId);
			 								}		 
			 							}
			 						}
			 					});
			 					resourceTypeComboStore.getProxy().extraParams = {
			 						isReadingMaterial:true
			 					};
			 					resourceTypeComboStore.load({
			 						callback: function(records, operation, success) {
			 							if (success) {
			 								if(records.length==1){
			 									resourceTypeCombo.setValue(records[0].data.value);
			 								}		 
			 							}
			 						}
			 					});
			 					var courseDepartment = form.down('#courseDepartment');
			 					var store = courseDepartment.getStore();
			 					store.getProxy().extraParams = {
			 						academyLocationIds:alId
			 					};
			 					store.load();
			 				}
			 			},
			 			'mapcoursespncform button[itemId=resetMapCourseItemId]':{
			 				click:function(){
			 					var me = this;
			 					var form = me.getMapcoursespncform();
			 					form.getForm().reset();
			 					var alId = this.getCurrentAcademyLocation();
			 					var academyLocationCombo = form.down('#academyLocationCombo');
			 					var academyLocationComboStore=academyLocationCombo.getStore();
			 					academyLocationComboStore.load({
			 						callback: function(records, operation, success) {
			 							if (success) {
			 								if(records.length > 0){
			 									academyLocationCombo.setValue(alId);
			 								}		 
			 							}
			 						}
			 					});
			 					
			 					var courseDepartment = form.down('#courseDepartment');
			 					var store = courseDepartment.getStore();
			 					store.getProxy().extraParams = {
			 						academyLocationIds:alId
			 					};
			 					store.load();
			 					var mapcoursespncgrid = me.getMapcoursespncgrid();
			 					if(!isNullOrEmpty(mapcoursespncgrid)){
			 						mapcoursespncgrid.config.departmentId = null;
			 						mapcoursespncgrid.config.inventoryTypeId = null;
			 						mapcoursespncgrid.config.academyLocationId = null;
			 					}
			 				}
			 			},
			 			'mapcoursespncform button[itemId=searchBtn]':{
			 				click:function(){
			 					var me = this;
			 					var form = me.getMapcoursespncform();
			 					var values = form.getValues();
			 					var departmentId = values.department;
			 					var inventoryTypeId = values.TOPIC_READING_ID;
			 					var mapcoursespncgrid = me.getMapcoursespncgrid();
			 					if(!isNullOrEmpty(mapcoursespncgrid)){
			 						mapcoursespncgrid.config.departmentId = departmentId;
			 						mapcoursespncgrid.config.inventoryTypeId = inventoryTypeId;
			 						mapcoursespncgrid.config.academyLocationId = values.ACADEMY_LOCATION_ID;
			 					}
			 				}
			 			},
			 			'mapcoursespncform customcombobox[itemId=academyLocationCombo]' : {
			 				select:function(obj,rec){
			 					var form = this.getMapcoursespncform();
			 					var alId = obj.getValue();
			 					var courseDepartment = form.down('#courseDepartment');
			 					var store = courseDepartment.getStore();
			 					store.getProxy().extraParams = {
			 						academyLocationIds:alId
			 					};
			 					store.load();
			 				}
			 			},
			 			'readingmaterialform':{
		        			afterrender : function(form){
		        				var resourceType = form.down('#readingTypeItemId');
		        				var store = resourceType.getStore();
		        				store.getProxy().extraParams = {
					      			isReadingMaterial : true
		    					 };
		    					 store.load();
		        			}
		        		},
		        		'maplinkedcoursesdetailpncgrid':{
			 				 render:function(grid){
			 					 //grid.getStore().removeAll();
			 				 },
			 				 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
			 					 var $this = this;
			 					 var grid = $this.getMaplinkedcoursesdetailpncgrid();
			 					 var columnName = grid.columnManager.columns[cellIndex].dataIndex;

			 					 if (e.target.tagName == 'DIV') {
			 						 if (columnName == "deleteButton") {
			 							 if (e.target.className == "deleteButtonClsForGridActionCls") {
			 								 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
			 									$this.deleteLinkedCoursesGridRecord(grid,record);
			 								
			 								 }
			 							 }
			 						 }
			 					 }
			 				 }
			 			 },
			 			'maplinkedcoursesdetailpncgrid button[itemId=btnSaveMapLinkedCourseItemId]':{
			 				 click:function(){
			 					 this.updateMapLinkedCoursePncGridRecord();
			 				 }
			 			 },
			 			 'assigncourseslist customcombobox[itemId=courseVariant]' :{
			 				 afterrender:function(combo){
			 					 var me = this;
			 					 var assigncourseslist = combo.up('assigncourseslist');
			 					 var academyLocationId = assigncourseslist.config.academyLocationId;
			 					 
			 					 if(!isNullOrEmpty(combo)){
			 						 combo.store.on('beforeload', function(api, action, beforeload){ 
			 							 var assigncourseslistGrid = me.getAssigncourseslist();
			 							 if(assigncourseslist.getSelectionModel().getSelection().length){
			 								 var data = assigncourseslist.getSelectionModel().getSelection()[0].data;
			 							 }else{
			 								 var data = assigncourseslistGrid.getSelectionModel().getSelection()[0].data;
			 							 }
			 							 var academicTermId = data.academicTermId;
			 							 var courseId = data.courseId;
			 							 
			 							 this.getProxy().extraParams = {
			 								 academyLocationIds: academyLocationId,
			 								 academicTermId: academicTermId,
			 								 courseId: courseId
			 							 };
			 						 });
			 						 combo.getStore().load();
			 					 }
			 				 }
			 			 },
			 			 'readingmaterialgrid button[itemId=exportReport]':{
			 				 click:function(obj){
			 					 var $this=this;
			 					 var grid=$this.getReadingmaterialgrid();
			 					 var filter=$this.getReadinmaterialfilter();
			 					 var reportParams =new Object();
			 					 var reportTitle="";
			 					 var code = "READING_MATERIAL_REPORT";

			 					 var academyLocationId = filter.down('#multiselectAcademyLocationId').getValue();
			 					 var alIds=[];
			 					 var academyLocationIds; 

			 					 if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
			 						 for(var i in academyLocationId){
			 							 if(Ext.isObject(academyLocationId[i])){
			 								 alIds.push(academyLocationId[i].get("id"));
			 							 }else{
			 								 alIds.push(academyLocationId[i]);
			 							 }
			 						 }
			 					 } else {
			 						 alIds.push(this.getCurrentAcademyLocation());
			 					 }
			 					var isbnTen=filter.down("#isbnTenId").getValue();
				            	var isbn10s=[];
				            	var isbnTenIds; 
				            	if(isbnTen !=undefined && isbnTen.length > 0 && isbnTen[0] != ""){
				            		for(var i in isbnTen){
				            			if(Ext.isObject(isbnTen[i])){
				            				isbn10s.push(isbnTen[i].get("id"));
				            			}
				            		}
				            		isbnTenIds = isbn10s.join();
				            	}
				            	
				            	var isbnThirteen=filter.down("#isbnThirteenthId").getValue();
				            	var isbn13s=[];
				            	var isbnThirteenIds; 
				            	if(isbnThirteen !=undefined && isbnThirteen.length > 0 && isbnThirteen[0] != ""){
				            		for(var i in isbnThirteen){
				            			if(Ext.isObject(isbnThirteen[i])){
				            				isbn13s.push(isbnThirteen[i].get("id"));
				            			}
				            		}
				            		isbnThirteenIds = isbn13s.join();
				            	}
			 					 academyLocationIds = alIds.join();
			 					 reportParams.ACADEMIC_TERM_ID= filter.down('#academicTerm').getValue();
			 					 reportParams.ACADEMIC_TERM_NAME= filter.down('#academicTerm').getRawValue();
			 					 reportParams.academyLocationIds= academyLocationIds;
			 					 reportParams.programId= filter.down('#programId').getValue();
			 					 reportParams.batchId= filter.down('#batchId').getValue();
			 					 reportParams.periodId= filter.down('#periodId').getValue();
			 					 reportParams.courseDepartmentId= filter.down('#courseDepartment').getValue();
			 					 reportParams.courseId= filter.down('#courseId').getValue();
			 					 reportParams.readingNameId= filter.down('#readingNameId').getValue();
			 					 reportParams.readingTypeId= filter.down('#resourceTypeId').getValue();
			 					 reportParams.isbn10= isbnTenIds;
			 					 reportParams.isbn13= isbnThirteenIds;
			 					 var URL = SERVERURL.PATH_EXPORT_READING_MATERIAL_REPORT;
			 					 this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',URL);
			 				 } 
			 			 }
	        	  });
	        	  },
	        	  /**
					* this function is used to hide button menu while scrolling
					*/
		            hideButtonMenuWhileScrolling:function(grid){
		        	    var studentattendancestructure=this.getStudentattendancestructure();
		        	    studentattendancestructure.body.on('scroll', function(e){
						var moreactionButton=grid.down('#spBtnMoreActions');
						    moreactionButton.hideMenu();
					    }, studentattendancestructure);
		            },
		            /**
		             * Open reading material information tab
		             */
		            showAddInformationTab:function(){
		            	var me = this;
						var contentpanel = me.getContentPanel();
						var informationstructure = Ext.widget('readingmaterialinformationstructure');
						var tabName = getProgramandcourseTranslation('PC_ADD_READING_STOCK');
						/**
		              	   * This is to remove tab from content panel and open same tab again 
		              	   */
		              	var getcontroller=this.getController('menu.CoreERPNavigationController');
		              	var getTab=getcontroller.getTab(tabName);
		              	if(getTab!=null){
		              	   contentpanel.remove(getTab, true);
		              	}
						openTab(contentpanel, tabName, informationstructure,CONSTANTS.MENU_COLOR_THREE);
		            },
		            showAddInformationTabNew:function(){
		            	var me = this;
						var contentpanel = me.getReadingmaterialinformationstructure();
						contentpanel = contentpanel.down('#readingMaterialTabPanelItemId');
						var addinformation = Ext.widget('addinformationform');
						var tabName = getProgramandcourseTranslation('PC_ADD');
						/**
		              	   * This is to remove tab from content panel and open same tab again 
		              	   */
		              	var getcontroller=this.getController('menu.CoreERPNavigationController');
		              	var getTab=getcontroller.getTab(tabName);
		              	if(getTab!=null){
		              	   contentpanel.remove(getTab, true);
		              	}
						openTab(contentpanel, tabName, addinformation,CONSTANTS.MENU_COLOR_THREE);
		            },
		            /**
		             * Open reading material create tab
		             */
		            showReadingMaterialTab : function(type) {
		            	var me = this;
		            	var contentpanel = me.getContentPanel();
		            	var readingmaterialform = Ext.widget('readingmaterialform');
		            	var tabName = null;
		            	tabName = getCourseTxCommonTranslation('ADD_INVENTORY_INFORMATION');
		            	
		            	var getcontroller=this.getController('menu.CoreERPNavigationController');
		            	var getTab=getcontroller.getTab(tabName);
		            	if(getTab!=null){
		            		contentpanel.remove(getTab, true);
		            	}
		            	
		            	tabName = getCourseTxCommonTranslation('VIEW_INVENTORY_INFORMATION');
		            	
		            	var getcontroller=this.getController('menu.CoreERPNavigationController');
		            	var getTab=getcontroller.getTab(tabName);
		            	if(getTab!=null){
		            		contentpanel.remove(getTab, true);
		            	}
		            	
		            	tabName = getCourseTxCommonTranslation('EDIT_INVENTORY_INFORMATION');
		            	
		            	var getcontroller=this.getController('menu.CoreERPNavigationController');
		            	var getTab=getcontroller.getTab(tabName);
		            	if(getTab!=null){
		            		contentpanel.remove(getTab, true);
		            	}

		            	if(type==1){
		            		tabName = getCourseTxCommonTranslation('EDIT_INVENTORY_INFORMATION');
		            	}else if(type==2){
		            		tabName = getCourseTxCommonTranslation('VIEW_INVENTORY_INFORMATION');
		            	}else{
		            		tabName = getCourseTxCommonTranslation('ADD_INVENTORY_INFORMATION');
		            	}
		            	openTab(contentpanel, tabName, readingmaterialform,CONSTANTS.MENU_COLOR_THREE);
		            },
					/**
					 * Load data on information tab on click of more action button
					 */
					loadDataOnInformationTab:function(){
						var $this = this;
						var grid = $this.getReadingmaterialgrid();

						if (grid.getSelectionModel().getCount() > 0) {
							var records = grid.getSelectionModel().getSelection()[0];
							$this.showAddInformationTab();
							$this.loadReadingInformationDetailGrid(records.data.readingId);

							var readingmaterialinformationstructure =  $this.getReadingmaterialinformationstructure().getForm();
							readingmaterialinformationstructure.findField('id').setValue(records.data.readingId);
							readingmaterialinformationstructure.findField('displayReadingType').setValue(records.data.readingType);
							readingmaterialinformationstructure.findField('displayReadingName').setValue(records.data.readingName);
							readingmaterialinformationstructure.findField('readingAuthor').setValue(records.data.author);
							readingmaterialinformationstructure.findField('publisher').setValue(records.data.publisher);
							readingmaterialinformationstructure.findField('isbnTen').setValue(records.data.isbnTen);
							readingmaterialinformationstructure.findField('isbnThirteen').setValue(records.data.isbnThirteen);
							readingmaterialinformationstructure.findField('issueYear').setValue(records.data.issueYear);
							readingmaterialinformationstructure.findField('currentStock').setValue(records.data.currentStock);
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
						}   	
					},showAddinformationform:function(){
						var $this = this;
						var grid = $this.getReadingmaterialgrid();
						var records = grid.getSelectionModel().getSelection()[0];
						$this.showAddInformationTabNew();
						var addinformationform = $this.getAddinformationform();
						var getForm = addinformationform.getForm();

						var id=this.getReadingmaterialinformationstructure().down('#id').getValue();
						var displayReadingType=this.getReadingmaterialinformationstructure().down('#displayReadingType').getValue();
						var displayReadingName=this.getReadingmaterialinformationstructure().down('#displayReadingName').getValue();
						var readingAuthor=this.getReadingmaterialinformationstructure().down('#readingAuthor').getValue();
						var publisher=this.getReadingmaterialinformationstructure().down('#publisher').getValue();
						var isbnTen=this.getReadingmaterialinformationstructure().down('#isbnTen').getValue();
						var isbnThirteen=this.getReadingmaterialinformationstructure().down('#isbnThirteen').getValue();
						var issueYear=this.getReadingmaterialinformationstructure().down('#issueYear').getValue();
						var currentStock=this.getReadingmaterialinformationstructure().down('#currentStock').getValue();
						getForm.findField('id').setValue(id);
						getForm.findField('displayReadingType').setValue(displayReadingType);
						getForm.findField('displayReadingName').setValue(displayReadingName);
						getForm.findField('readingAuthor').setValue(readingAuthor);
						getForm.findField('publisher').setValue(publisher);
						getForm.findField('isbnTen').setValue(isbnTen);
						getForm.findField('isbnThirteen').setValue(isbnThirteen);
						getForm.findField('issueYear').setValue(issueYear);
						getForm.findField('currentStock').setValue(currentStock);
					},
					gridRenderFunctionNew:function(grid){
						grid.addButtonToolbar();
						var butonstoolbar=grid.down('#functionButtonsToolbar');
						butonstoolbar.items.items[1].setVisible(false);
						butonstoolbar.items.items[1].hidden = true;
						butonstoolbar.items.items[2].setVisible(false);
						butonstoolbar.items.items[2].hidden = true;
						butonstoolbar.items.items[3].setVisible(false);
						butonstoolbar.items.items[3].hidden = true;
				    },
					
					 /**
						 * Add reading material function
						 */
					saveReadingMaterialData:function(){
						var $this = this;
						var readingMaterialGrid = $this.getReadingmaterialgrid();
						var form=$this.getReadingmaterialform();
						var getForm=form.getForm();
						var values = getForm.getValues();
						var inventoryTypeId = null;
						var id = null;
						var submitUrl;
						if(isNullOrEmpty(values.isbn10) && isNullOrEmpty(values.isbn13)){
							showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PLEASE_ENTER_ANY_ISBN_DETAILS'));
							   return false;
						}
						if (values.readingId == null
								|| values.readingId == "") {
							inventoryTypeId=values.readingType;
							submitUrl = SERVERURL.READING_MATERIAL_CREATE_URL;
						} else {
							id=values.readingId;
							inventoryTypeId=values.inventoryTypeId;
							submitUrl = SERVERURL.READING_MATERIAL_UPDATE_URL;
						}
						var data={
							       "customData":values.customData,
							       "invtPublisherMaster":{
							           "id": values.invtPublisherMasterId
							       },
							       "invtTypeMaster":{
							           "id": inventoryTypeId
							       },
							       "inventoryItemName": values.readingName,
							       "firstAuthorName": values.firstAuthorName,
							       "secondAuthorName": values.secondAuthorName,
							       "thirdAuthorName": values.thirdAuthorName,
							       "fourthdAuthorName": values.fourthAuthorName,
							       "fifthAuthorName": values.fifthAuthorName,
							       "binding": !isNullOrEmpty(values.courseResourceBinding)?values.courseResourceBinding:null,
							       "issueYear":values.issuedYear,
							       "isbnTen":values.isbn10,
							       "isbnThirteen":values.isbn13,
							       "edition":values.edition,
							       "volume": values.volume,
							       "remarks": values.remark,
							       "currentStock": 20,
							       "id":id,
							   };
						
						var formData = Ext.encode(data);
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(form, action) {
								var data = form.responseText;
								if(data=="SUCCESS"){
									Ext.getBody().unmask();
									getForm.reset();
									showSuccessMessage(getCourseTxCommonTranslation('READING_MATERIAL'),getCommonTranslation('SUCCESS'));
									readingMaterialGrid.getStore().reload();
									$this.getContentPanel().getActiveTab().close();
								}else{
									Ext.getBody().unmask();
									showErrorMessage(getCommonTranslation('FAILURE'), getErrorTranslation(data));
								}
							}
						});
					},
					/**
					 * Edit data of reading material.
					 */
					editReadingMaterialTab : function() {
						var $this = this;
						var grid = $this.getReadingmaterialgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							$this.showReadingMaterialTab(1);

							var records = grid.getSelectionModel().getSelection()[0];
							var id = records.get("readingId");
							var form=$this.getReadingmaterialform();
							var getForm=form.getForm();
							getForm.findField('readingId').setValue(id);
							Ext.Ajax.request({
								type : 'rest',
								url: SERVERURL.READING_MATERIAL_EDIT_URL+'?inventoryItemId='+id,
								method : 'GET',
								success : function(resp, action) {
									var jData = Ext.decode(resp.responseText);
									console.log('jData',jData);

									if(!isNullOrEmpty(jData)){
										if(!isNullOrEmpty(jData.invtTypeMaster.id)){
											var readingTypeField=getForm.findField('readingType');
											readingTypeField.getStore().load({
												callback:function(){
													readingTypeField.setValue(jData.invtTypeMaster.id);
													readingTypeField.setDisabled(true);
													getForm.findField('inventoryTypeId').setValue(jData.invtTypeMaster.id);
													
												}
											});
										}
										getForm.findField('readingName').setValue(jData.inventoryItemName);
										getForm.findField('firstAuthorName').setValue(jData.firstAuthorName);
										getForm.findField('secondAuthorName').setValue(jData.secondAuthorName);
										getForm.findField('thirdAuthorName').setValue(jData.thirdAuthorName);
										getForm.findField('fourthAuthorName').setValue(jData.fourthdAuthorName);
										getForm.findField('fifthAuthorName').setValue(jData.fifthAuthorName);
										getForm.findField('issuedYear').setValue(jData.issueYear);
										getForm.findField('isbn10').setValue(jData.isbnTen);
										getForm.findField('isbn13').setValue(jData.isbnThirteen);
										if(!isNullOrEmpty(jData.binding)){
											var courseResourceBinding=getForm.findField('courseResourceBinding');
											courseResourceBinding.getStore().load({
												callback:function(){
													courseResourceBinding.setValue(jData.binding);
												}
											});
										}

										if(!isNullOrEmpty(jData.invtPublisherMaster.id)){
											var invtPublisherMasterIdField=getForm.findField('invtPublisherMasterId');
											invtPublisherMasterIdField.getStore().load({
												callback:function(){
													invtPublisherMasterIdField.setValue(jData.invtPublisherMaster.id);
												}
											});
										}
										getForm.findField('edition').setValue(jData.edition);
										getForm.findField('volume').setValue(jData.volume);
										getForm.findField('remark').setValue(jData.remarks);

										if (form) {
											form.down('#cancelBtn').hide();
											toggleReadOnlyFormItems(getForm, false);
										}
									}
								}
							});
						}else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
						}


					},
					
					/**
					 * View data of reading material.
					 */
					viewDataOfReadingMaterial:function(){
						var $this = this;
						var grid = $this.getReadingmaterialgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							$this.showReadingMaterialTab(2);

							var records = grid.getSelectionModel().getSelection()[0];
							var id = records.get("readingId");
							var form=$this.getReadingmaterialform();
							var getForm=form.getForm();
							Ext.Ajax.request({
								type : 'rest',
								url: SERVERURL.READING_MATERIAL_EDIT_URL+'?inventoryItemId='+id,
								method : 'GET',
								success : function(resp, action) {
									var jData = Ext.decode(resp.responseText);
									console.log('jData',jData);

									if(!isNullOrEmpty(jData)){
										if(!isNullOrEmpty(jData.invtTypeMaster.id)){
											var readingTypeField=getForm.findField('readingType');
											readingTypeField.getStore().load({
												callback:function(){
													readingTypeField.setValue(jData.invtTypeMaster.id);
												}
											});
										}
										getForm.findField('readingName').setValue(jData.inventoryItemName);
										getForm.findField('firstAuthorName').setValue(jData.firstAuthorName);
										getForm.findField('secondAuthorName').setValue(jData.secondAuthorName);
										getForm.findField('thirdAuthorName').setValue(jData.thirdAuthorName);
										getForm.findField('fourthAuthorName').setValue(jData.fourthdAuthorName);
										getForm.findField('fifthAuthorName').setValue(jData.fifthAuthorName);
										getForm.findField('issuedYear').setValue(jData.issueYear);
										getForm.findField('isbn10').setValue(jData.isbnTen);
										getForm.findField('isbn13').setValue(jData.isbnThirteen);
										if(!isNullOrEmpty(jData.binding)){
											var courseResourceBinding=getForm.findField('courseResourceBinding');
											courseResourceBinding.getStore().load({
												callback:function(){
													courseResourceBinding.setValue(jData.binding);
												}
											});
										}

										if(!isNullOrEmpty(jData.invtPublisherMaster.id)){
											var invtPublisherMasterIdField=getForm.findField('invtPublisherMasterId');
											invtPublisherMasterIdField.getStore().load({
												callback:function(){
													invtPublisherMasterIdField.setValue(jData.invtPublisherMaster.id);
												}
											});
										}
										getForm.findField('edition').setValue(jData.edition);
										getForm.findField('volume').setValue(jData.volume);
										getForm.findField('remark').setValue(jData.remarks);

										if (form) {
											form.down('#submitBtn').hide();
											form.down('#cancelBtn').hide();
											toggleReadOnlyFormItems(getForm, true);
										}
									}
								}
							});
						}else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
						}
					},
					 /**
		               * delete reading material function
		               */
					deleteReadingMaterialMasterGrid:function(grid){
						 var $this=this;
						 var grid = $this.getReadingmaterialgrid();
		             	 if (grid.getSelectionModel().getCount() > 0) {
		             		 var records = grid.getSelectionModel().getSelection()[0];
		             		 var id = records.get("readingId");
		             		showConfirmMessage(getCourseTxCommonTranslation('READING_MATERIAL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn, text) {
		             			 if (btn == 'yes'){
			             		 Ext.Ajax.request({
			             			 method: "DELETE",
			             			 type: 'rest',
			             			 url: SERVERURL.READING_MATERIAL_DELETE_URL+'?id='+id,
			             			 headers: {
			             				 'Content-Type': 'application/json'
			             			 },
			             			 params: {
			             				 id: id
			             			 },
			             			 success: function(form, action) {
			             				 var data = form.responseText;
			             				 if(data=="SUCCESS"){
			             					 showSuccessMessage(getCourseTxCommonTranslation('READING_MATERIAL'),getCommonTranslation('RECORD_DELETE_SUCCESS'));	             					 
			             					 grid.store.reload();
			             					 /**
			             					  * Load information detail grid.
			             					  */
			             					 var tabName = getCourseTxCommonTranslation('ADD_INVENTORY_INFORMATION');
			             					 var getcontroller=$this.getController('menu.CoreERPNavigationController');
			             					 var getTab=getcontroller.getTab(tabName);
			             					 if(getTab!=null){
			             						 $this.loadReadingInformationDetailGrid();
			             					 } 
			             				 }else if(data=="COURSE_MAPPED"){
			             					showErrorMessage(getCommonTranslation('FAILURE'), getErrorTranslation('CANNOT_DELETE_READING_MATERIAL_IS_ALREADY_MAPPED_WITH_COURSE')); 

			             				 }else if(data=="DISTRIBUTION_MAPPED"){
			             					showErrorMessage(getCommonTranslation('FAILURE'), getErrorTranslation('CANNOT_DELETE_READING_MATERIAL_IS_ALREADY_USED_FOR_DISTRIBUTION')); 
			             				 }

			             			 }
			             		      });
			             			 }
			             		 });
		             	  }else{
		             		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		             	 }
		              },
		              /**
		               * Add reading material information function
		               */
		              saveAddReadingMaterialInformationData:function(){
		            	    var $this = this;
		            	    var contentpanel = $this.getContentPanel();
							var inventoryDetailGrid = $this.getInventoryDetailGrid();
							var form=$this.getAddinformationform();
							var getForm=form.getForm();
							var grid = $this.getInvtitemmasterreadingstockdetailgrid();
							var values = getForm.getValues();
							if(values.invtItemCondition=="Damaged"){
								values.quantity=-(values.quantity)
							}
							var documents = [];
							var docArray = [];
							var docData=$this.getInvtitemmasterdetaildocument().getStore();
							if(docData.data.items!=null && docData.data.items.length>0){
							docData.each(function(obj){
								///documents.push(obj.data);
								var newData={
				        				  "name":obj.data.documentName,
				        				  "path":obj.data.path,
				        				  "type":obj.data.type,
				        				  "createdBy":$this.getIdValueJson(obj.data.createdBy.id,obj.data.createdBy.value)
				        		  };
				        		  if(obj.data.documentId==""){
				        			  docArray.push(newData);  
				        		  }
							});
							}
							if(docArray.length > 0 ){
								documents = docArray;
				        	  }else{
				        		  documents = null;
				        	  }
							
							var data={
								       "customData":[],
								       "invtItemMaster":{
								           "id": values.id
								       },
								       "academyLocation":{
								           "id": values.academyLocationId
								       },
								       'documents':documents,
								       "quntity": values.quantity,
								       "vendorName": values.vendorName,
								       "purchaseDate":values.purchaseDate,
								       "invtItemCondition": values.invtItemCondition,
								       "remarks": values.remark
								   };
							var submitUrl=SERVERURL.ADD_INFORMATION_CREATE_URL;
							var formData = Ext.encode(data);
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								type : 'rest',
								url : submitUrl,
								jsonData : formData,
								method : 'POST',
								success : function(form, action) {
									Ext.getBody().unmask();
									getForm.findField('academyLocationId').reset();
									getForm.findField('quantity').reset();
									getForm.findField('vendorName').reset();
									getForm.findField('purchaseDate').reset();
									getForm.findField('invtItemCondition').reset();
									getForm.findField('remark').reset();
									showSuccessMessage(getCourseTxCommonTranslation('READING_MATERIAL_INFORMATION'),getCommonTranslation('SUCCESS'));
									$this.loadReadingInformationDetailGrid(values.id);
									/**
									 * Load information detail grid.
									 */
									
									var contentPanel =grid.up('readingmaterialinformationstructure');
									contentPanel=contentPanel.down('tabpanel');
									var tabName = getProgramandcourseTranslation('PC_ADD');
									var getcontroller=$this.getController('menu.CoreERPNavigationController');
									var getTab=getcontroller.getInnerTab(contentPanel,tabName);
									if(getTab!=null){
										contentPanel.remove(getTab, true);
										$this.loadReadingInformationDetailGrid(values.id);
									}
								}
							});
							docData.removeAll();	
							
		              },
		              /**
		               * delete reading material function
		               */
		              deleteReadingInformationDetailGrid:function(){
		            	  var $this=this;
							 var grid = $this.getInventoryDetailGrid();
			             	 if (grid.getSelectionModel().getCount() > 0) {
			             		 var records = grid.getSelectionModel().getSelection()[0];
			             		 var id = records.get("ID");
			             		 showConfirmMessage(getCourseTxCommonTranslation('READING_MATERIAL_INFORMATION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn, text) {
			             			 if (btn == 'yes'){
				             		 Ext.Ajax.request({
				             			 method: "DELETE",
				             			 type: 'rest',
				             			 url: SERVERURL.READING_INFORMATION_DELETE_URL+'?id='+id,
				             			 headers: {
				             				 'Content-Type': 'application/json'
				             			 },
				             			 params: {
				             				 id: id
				             			 },
				             			 success: function(form, action) {
				             			     showSuccessMessage(getCourseTxCommonTranslation('READING_MATERIAL_INFORMATION'), getCourseTxCommonTranslation('READING_MATERIAL'));	             					 
				             				 grid.store.reload();
				             				 /**
					       	              	   * Load information detail grid.
					       	              	   */
				             				  var tabName ="Reading Material";
					       	              	  var getcontroller=$this.getController('menu.CoreERPNavigationController');
					       	              	  var getTab=getcontroller.getTab(tabName);
					       	              	   if(getTab!=null){
					       	              		 $this.loadReadingMasterGrid();
					       	               	   }
				             			     }
				             		       });
				             			 }
				             		 });
			             	 } else {
			             		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			             }
		              },
		              loadReadingInformationDetailGrid:function(readingId){
		            	  var this$=this;
		            	  //getReadingmaterialinformationstructure
		            	  //var quickSearchForm = this.getAddinformationform().getForm();
		            	  //var jsonFormatFormData = this.createJsonFormatForInformation(quickSearchForm);
		            	  /*var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		            	  var InventoryDetailGrid = this.getInventoryDetailGrid();
		            	  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.INVENTORY_ITEM_MASTER_DETAIL_REPORT_VIEW_CODE);	
		            	  
		            	  var values = new Object();
		            	  var searchcriteria = new Array();
		            	  values.configCode = CONSTANTS.CB.INVENTORY_ITEM_MASTER_DETAIL_REPORT_CONFIG_CODE;

		            	  var INVENTORYTYPE_ID = this.getJsonObject('INVENTORY_DETAILS_ID', readingId);
		            	  this.pushJsonObjectInArray(INVENTORYTYPE_ID,searchcriteria);

		            	  values.searchCriterias = searchcriteria;
		            	  InventoryDetailGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, values)*/;
		            	  var grid = this$.getInvtitemmasterreadingstockdetailgrid();
			    		  var store = grid.getStore();
			    		  store.getProxy().extraParams = {
			    			  inventoryItemId: readingId
			    		  };
			    		  store.loadPage(1);
			    		  
		              },
		              createJsonFormatForInformation: function(quickSearchForm) {
			    		 var form =  quickSearchForm;
			    		 var formValues =form.getValues();
			    		 																																																																																													
			    	     var values = new Object();
			    	     var searchcriteria = new Array();
			    	     values.configCode = CONSTANTS.CB.INVENTORY_ITEM_MASTER_DETAIL_REPORT_CONFIG_CODE;
			    	     
			             var INVENTORYTYPE_ID = this.getJsonObject('INVENTORY_DETAILS_ID', formValues.id);
			    	     this.pushJsonObjectInArray(INVENTORYTYPE_ID,searchcriteria);
			    	     
			             values.searchCriterias = searchcriteria;
			             return values;
				      },
		             gridRenderFunction: function(grid) {
			      		grid.addButtonToolbar();
			      		 var calButton	={
		        			    xtype : 'splitbutton',
		        			    itemId:'spBtnMoreActions',
		        			    text : getCommonTranslation('MOREACTIONS'),
		        			    menu:[{
			        				text:getCourseTxCommonTranslation('ADD_READING_MATERIAL_DETAIL'),
			        				itemId:'addInventoryItemId',
			        				disabled:true
		        			    },{
			        				text:getCourseTxCommonTranslation('INVENTORY_DETAIL'),
			        				itemId:'inventoryDetailItemId'
		        			    }],
		        			    listeners: { click: function() { this.showMenu(); } }
			        			
			        	 };
			        	 grid.down('#functionButtonsToolbar').insert(4,calButton);
		            },
		            loadReadingMasterGrid : function(){
		            	var this$=this;
		            	var formFilter = this$.getReadinmaterialfilter();
		            	formFilter.down('#searchBtn').setDisabled(true);
		            	var quickSearchForm = formFilter.getForm();
		    			var grid = this.getReadingmaterialgrid();
		    			var store = grid.getStore();

		            	var academyLocationId=quickSearchForm.findField("multiselectAcademyLocation").getValue();
		            	var alIds=[];
		            	var academyLocationIds; 
		            	if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
		            		for(var i in academyLocationId){
		            			if(Ext.isObject(academyLocationId[0])){
		            				alIds.push(academyLocationId[i].get("id"));
		            			}else{
		            				alIds.push(academyLocationId[i]);
		            			}
		            		}
		            		academyLocationIds = alIds.join();
		            	}else {
		            		alIds.push(this$.getCurrentAcademyLocation());
		            		academyLocationIds = alIds.join();
		            	}
		            	
		            	var firstAuthor=quickSearchForm.findField("multiselectFirstAuthor").getValue();
		            	var firstAuthorNames=[];
		            	var firstAuthors; 
		            	if(firstAuthor !=undefined && firstAuthor.length > 0 && firstAuthor[0] != ""){
		            		for(var i in firstAuthor){
		            			if(Ext.isObject(firstAuthor[i])){
		            				firstAuthorNames.push(firstAuthor[i].get("code"));
		            			}
		            		}
		            		firstAuthors = firstAuthorNames.join();
		            	}
		            	
		            	var isbnTen=quickSearchForm.findField("isbnTen").getValue();
		            	var isbn10s=[];
		            	var isbnTenIds; 
		            	if(isbnTen !=undefined && isbnTen.length > 0 && isbnTen[0] != ""){
		            		for(var i in isbnTen){
		            			if(Ext.isObject(isbnTen[i])){
		            				isbn10s.push(isbnTen[i].get("id"));
		            			}
		            		}
		            		isbnTenIds = isbn10s.join();
		            	}
		            	
		            	var isbnThirteen=quickSearchForm.findField("isbnThirteenth").getValue();
		            	var isbn13s=[];
		            	var isbnThirteenIds; 
		            	if(isbnThirteen !=undefined && isbnThirteen.length > 0 && isbnThirteen[0] != ""){
		            		for(var i in isbnThirteen){
		            			if(Ext.isObject(isbnThirteen[i])){
		            				isbn13s.push(isbnThirteen[i].get("id"));
		            			}
		            		}
		            		isbnThirteenIds = isbn13s.join();
		            	}

		            	var academicTermId = quickSearchForm.findField('academicTerm').getValue();
		            	var courseDepartmentId = quickSearchForm.findField('department').getValue();
		            	var courseId = quickSearchForm.findField('COURSE').getValue();
		            	var readingType = quickSearchForm.findField('resourceType').getValue();
		            	var readingNameId = quickSearchForm.findField('readingName').getValue();
		            	//var isbnTenId = quickSearchForm.findField('isbnTen').getValue();
		            	//var isbnThirteenthId = quickSearchForm.findField('isbnThirteenth').getValue();
		            	var programId = quickSearchForm.findField('programId').getValue();
		            	var batchId = quickSearchForm.findField('batchId').getValue();
		            	var periodId = quickSearchForm.findField('periodId').getValue();

		            	var searchedFormData = {
			            		academyLocationIds:academyLocationIds,
			            		academicTermId:academicTermId,
			            		courseDepartmentId:courseDepartmentId,
			            		courseId:courseId,
			            		programId:programId,
			            		batchId:batchId,
			            		periodId:periodId
	                	   };
		            	grid.searchedFormData = searchedFormData;
		            	
		            	store.getProxy().extraParams = {
		            		readingTypeId: readingType,
		            		readingNameId:readingNameId,
		            		academyLocationIds:academyLocationIds,
		            		academicTermId:academicTermId,
		            		courseDepartmentId:courseDepartmentId,
		            		courseId:courseId,
		            		//isbn10:isbnTenId,
		            		isbnTenIds:isbnTenIds,
		            		//isbn13:isbnThirteenthId,
		            		isbnThirteenIds:isbnThirteenIds,
		            		programId:programId,
		            		batchId:batchId,
		            		periodId:periodId,
		            		firstAuthors:firstAuthors
		            	};
		            	this.resetPageSetting(store);
		            	store.load({
		            		callback: function(records, operation, success) {
		            			if (success) {
		            				formFilter.down('#searchBtn').setDisabled(false);	 
		            			}
		            		}
		            	});
		            	grid.config.searchFilterForm = this$.getReadinmaterialfilter();
		            },
			    	 createJsonFormat: function(quickSearchForm) {
			    		 var form =  quickSearchForm;
			    		 var formValues =form.getValues();
			    		 																																																																																													
			    	     var values = new Object();
			    	     var searchcriteria = new Array();
			    	     values.configCode = CONSTANTS.CB.INVENTORY_ITEM_MASTER_REPORT_CONFIG_CODE;
			    	     
			             var INVENTORYTYPE_ID = this.getJsonObject('INVENTORYTYPE_ID', formValues.readingType);
			    	     this.pushJsonObjectInArray(INVENTORYTYPE_ID,searchcriteria);
			    	     
			    	     var INVENTORY_ITEM_NAME = this.getJsonObject('INVENTORY_ITEM_NAME', formValues.readingName);
			    	     this.pushJsonObjectInArray(INVENTORY_ITEM_NAME,searchcriteria);
			    	     
			             values.searchCriterias = searchcriteria;
			             return values;
			    	    },
			    	    getJsonObject: function(key, value, additionalValue) {
			    	         if (value != '' && value != null && additionalValue == undefined) {
			    	             return {
			    	                 "paramCode": key,
			    	                 "paramValues": [value]
			    	             };
			    	         } else if (value != '' && additionalValue != undefined) {
			    	             return {
			    	                 "paramCode": key,
			    	                 "paramValues": [value, additionalValue]
			    	             };
			    	         }
			    	     },
			    	     pushJsonObjectInArray: function(object, array) {
			    	         if (object) {
			    	             array.push(object);
			    	         }
			    	     },
			    	     
			    	     exportReadingMaterialList : function(exportUrl,filetype,whetherAll) {
		                      var quickSearchForm=this.getReadinmaterialfilter(); 
		                      var searchResultGrid = this.getReadingMaterialMasterGrid();
		                      var pagingtoolbaroptions = this.getReadingMaterialMasterGrid().down('pagingtoolbar').getStore().lastOptions;
		                      var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
		                      var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
		                      var visibleColumns=this.getVisibleColumns(searchResultGrid);
		                      var reportTitle=getCommonTranslation("READING_MATERIAL_LIST");
		                      if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
		                                    jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		                             }
		                      searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

		        },
		        
		        createSearchCriteriaString: function(searchForm) {
    		    	 var me=this;
    		        var formValues = new Array();
    		        formValues = searchForm.getValues();        
    		        var searchCriteriaString="";
    		        for (var key in formValues) {
    		        	var value = formValues[key];            
    		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
    		              //  var keyValueJsonObject = me.getJsonObject( key , value);
    		//searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
    		            }
    		        }
    		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
    		        return searchCriteriaString;
    		},
    		disableMoreActionPivileges: function(gridReference,permissionsMap) {
            	var associatedAcadLocationIds = new Array();
            	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            	buttonsToolBar = gridReference.query('toolbar')[0];
            	var moreActionButton = gridReference.down('#spBtnMoreActions');
            	moreActionButton.setVisible(false);
            	var addInventoryItemId = gridReference.down('#addInventoryItemId');
            	addInventoryItemId.setVisible(false);
            	var mapCourseReadingMaterail = gridReference.down('#mapCourseReadingMaterail');
            	mapCourseReadingMaterail.setVisible(false);
            	var exportReportButton=gridReference.down('#exportReport');
            	var mapCourseVariantReadingMaterail = gridReference.down('#mapCourseVariantReadingMaterail');
            	mapCourseVariantReadingMaterail.setVisible(false);
            	
            	if(!isNullOrEmpty(exportReportButton)){
            		 exportReportButton.setVisible(true);
	        	 }

            	Ext.each(permissionList, function(privilege) {
            		if (privilege === 'MOREACTIONS') {
                		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
                		if(!isNullOrEmpty(button)){
                			moreActionButton.setVisible(true);
                		}        		
                	}
            		if (privilege === 'ADD_STOCK') {
                		var button = buttonsToolBar.query('#addInventoryItemId')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
                	if (privilege === 'MAP_COURSES') {
                		var button = buttonsToolBar.query('#mapCourseReadingMaterail')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
                	if (privilege === 'MAP_COURSE_VARIANTS') {
                		var button = buttonsToolBar.query('#mapCourseVariantReadingMaterail')[0];
                		if(!isNullOrEmpty(button)){
                			button.setVisible(true);
                		}        		
                	}
                	if (privilege === 'EXPORT_REPORT') {
	        			 if(!isNullOrEmpty(exportReportButton)){
	        				 exportReportButton.setVisible(true);
	    	        	 }
	        		 }

            	});
            },           
                      
            //added for document upload for invtItemMasterDetail
            getDocumentController: function() {
            	var this$ = this;
            	return this$.getController('Academia.controller.document.DocumentController');
            },
            getIdValueJson : function(id, value, code) {
            	if (id)
            		return {
            		id : id,
            		value : value,
            		code : code
            	};
            },
            resetReadinmaterialfilter:function(){
            	var $this = this;
            	var form = $this.getReadinmaterialfilter();
            	var multiselectAcademyLocationId = form.down("#multiselectAcademyLocationId");
            	var academyLocationId = this.getCurrentAcademyLocation();
            	var alIds = [];
            	alIds.push(this.getCurrentAcademyLocation());
            	var multiselectAcademyLocationStore=multiselectAcademyLocationId.getStore();
            	multiselectAcademyLocationStore.load({
            		callback: function(records, operation, success) {
            			if (success) {
            				if(records.length > 0){
            					multiselectAcademyLocationId.setValue(academyLocationId);
            				}		 
            			}
            		}
            	});
            	var academyLocationIds = alIds.join();
            	$this.onAcademyLocationSelectionAndReset(form, academyLocationIds);
            },
            addMapCoursePncGridRecord: function(serialNo, currentRecord){
            	var me = this;
            	var mapcoursespncgrid = me.getMapcoursespncgrid();
            	var ObjModel = [];
            	if(serialNo == 1){
            		var pncMapCoursesModel = new Academia.model.coursetransaction.coursereading.PncMapCoursesModel();

            		pncMapCoursesModel.set("serialNo", serialNo);
            		pncMapCoursesModel.set("courseId", '');
            		pncMapCoursesModel.set("readingName", '');
            		pncMapCoursesModel.set("status", 'ACTIVE');
            		pncMapCoursesModel.set("courseReadingPrescribe", 'PRESCRIBED');
            		//pncMapCoursesModel.set("dateRequired", '');
            		pncMapCoursesModel.set("phaseoutYear", '');
            		pncMapCoursesModel.set("distributionMode", '');
            		pncMapCoursesModel.set("isAddDeleteRow", true);

            		ObjModel.push(pncMapCoursesModel);
            		mapcoursespncgrid.getStore().loadRawData(ObjModel, true);
            		mapcoursespncgrid.getStore().sort([
            		    {
            		        property : 'serialNo',
            		        direction: 'ASC'
            		    }
            		]);

            		mapcoursespncgrid.down('#btnAdd').hide();
            		mapcoursespncgrid.down('#fldContSaveItemId').show();
            	}
            	else if(serialNo>1){
            		var courseId = currentRecord.get('courseId');
            		var pncMapCoursesModel = new Academia.model.coursetransaction.coursereading.PncMapCoursesModel();
            		pncMapCoursesModel.set("serialNo", serialNo);

            		pncMapCoursesModel.set("readingName", '');
            		pncMapCoursesModel.set("status", 'ACTIVE');
            		pncMapCoursesModel.set("courseReadingPrescribe", 'PRESCRIBED');
            		//pncMapCoursesModel.set("dateRequired", '');
            		pncMapCoursesModel.set("phaseoutYear", '');
            		pncMapCoursesModel.set("distributionMode", '');
            		pncMapCoursesModel.set("isAddDeleteRow", true);
            		if(!isNullOrEmpty(courseId)){
            			pncMapCoursesModel.set("courseId", courseId);
            		}
            		else{
            			pncMapCoursesModel.set("courseId", '');
            		}
            		ObjModel.push(pncMapCoursesModel);
            		mapcoursespncgrid.getStore().loadRawData(ObjModel, true);
            		mapcoursespncgrid.getStore().sort([
            		    {
            		        property : 'serialNo',
            		        direction: 'ASC'
            		    }
            		]);
            	}
            },
            saveMapCoursePncGridRecord: function(){
        		var $this = this;
        		var contentPanel = $this.getContentPanel();
        		var grid = $this.getMapcoursespncgrid();
            	//var pncMapCoursesModel = new Academia.model.coursetransaction.coursereading.PncMapCoursesModel();
        		if(grid.getStore().getCount()>0) {
        			var json = $this.createMapCourseJson(grid);
        			if(!isNullOrEmpty(json) && json.length>0){
        				var submitUrl= SERVERURL.COURSE_READING_CREATE;
        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        				var formData = Ext.encode(json);
        				Ext.Ajax.request({
        					type : 'rest',
        					url : submitUrl,
        					jsonData : formData,
        					method : 'POST',
        					success : function(frm, action) {
        						Ext.getBody().unmask();
        						showSuccessMessage(getCourseTxCommonTranslation('MAP_COURSES'), getCommonTranslation('SUCCESS'));
        						var tabName = getCourseTxCommonTranslation('MAP_COURSES');
        						var getcontroller=$this.getController('menu.CoreERPNavigationController');
        						var getTab=getcontroller.getTab(tabName);
        						if(getTab!=null){
        							contentPanel.remove(getTab, true);
        						}
        						if(!isNullOrEmpty($this.getReadingmaterialgrid())){
 									$this.getReadingmaterialgrid().getStore().reload();
 								}
        					}
        				});
        			}
        		} else {
        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        		}
        	},
        	createMapCourseJson: function(grid){
        		var records = grid.getStore().getRange();
        		var arryRecordToSave=[];
        		for(var i in records) {

        			if(!isNullOrEmpty(records[i].data.courseId) && !isNullOrEmpty(records[i].data.readingName) && !isArray(records[i].data.readingName) && !isArray(records[i].data.courseId)){
        				var fromDate = null ;
        				var toDate = null;
        				var status = 0;
        				/*if(!isNullOrEmpty(records[i].data.dateRequired))
        				{	
        					fromDate = Ext.Date.format(new Date(records[i].data.dateRequired), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);//records[i].data.fromDate;
        					if(fromDate==="NaN-NaN-0NaN"){
        						fromDate= records[i].data.dateRequired;
        					}
        				}*/
        				if(!isNullOrEmpty(records[i].data.status) && records[i].data.status == 'ACTIVE')
        				{
        					status = 1;
        				}
        				
        				var readingNameId = this.getIdValueJson(records[i].data.readingName);
        				arryRecordToSave.push({
        					"course":this.getIdValueJson(records[i].data.courseId),
        					"invtItemMaster":readingNameId,
        					"status":status,
        					"courseReadingPrescribe":records[i].data.courseReadingPrescribe,
        					//"dateRequired":fromDate,
        					"phaseoutYear":records[i].data.phaseoutYear,
        					"distributionMode":this.getIdValueJson(records[i].data.distributionMode)
        				});
        			}
        			else{
        				arryRecordToSave=[];
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_THE_COURSE_AND_READING_NAME_MSG'));
        			}
        		}
        		return arryRecordToSave;
        	},
        	
        	openLinkedCoursesDetailsTab:function(dataIndex, record){
            	var $this = this; 
            	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
            	var structure = Ext.widget('maplinkedcoursesdetailpncform');
            	var tabName = getCommonTranslation('LINKED_COURSES');
            	var values = $this.getReadingmaterialgrid().searchedFormData;
            	
            	var academyLocationIds = values.academyLocationIds;
            	var academicTermId = values.academicTermId;
            	var courseDepartmentId = values.courseDepartmentId;
            	var courseId = values.courseId;
            	var programId = values.programId;
            	var batchId = values.batchId;
            	var periodId = values.periodId;
            	
            	var getcontroller=this.getController('menu.CoreERPNavigationController');
            	var getTab=getcontroller.getTab(tabName);
            	if(getTab!=null){
            		contentPanel.remove(getTab, true);
            	}
            	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_THREE);

            	if(!isNullOrEmpty(record.data.isbnTen) && !isNullOrEmpty(record.data.isbnThirteen)){
            		var readingNameFull = record.data.readingName+' / '+record.data.isbnTen+' / '+record.data.isbnThirteen;
            		structure.down('#readingNameId').setValue(readingNameFull);
            	}
            	else if(!isNullOrEmpty(record.data.isbnTen)){
            		var readingNameFull = record.data.readingName+' / '+record.data.isbnTen;
            		structure.down('#readingNameId').setValue(readingNameFull);
            	}
            	else if(!isNullOrEmpty(record.data.isbnThirteen)){
            		var readingNameFull = record.data.readingName+' / '+record.data.isbnThirteen;
            		structure.down('#readingNameId').setValue(readingNameFull);
            	}
            	else{
            		structure.down('#readingNameId').setValue(record.data.readingName);
            	}
            	
            	structure.down('#resourceTypeId').setValue(record.data.readingType);
            	var grid = structure.down('#maplinkedcoursesdetailpncgridItemId');
            	grid.getStore().removeAll();
            	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        		Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.COURSE_READING_LIST,
                    method: 'GET',
                    params: {
                    	invtItemMasterId:record.data.readingId,
                    	academyLocationIds : academyLocationIds,
                    	academicTermId:academicTermId,
                    	courseDepartmentId:courseDepartmentId,
                    	courseId:courseId,
                    	programId:programId,
                    	batchId:batchId,
                    	periodId:periodId,
                    	sort:null,
                    	page: 1,
                    	start: 0,
                    	limit: 1000
                    },
                    success: function(response, action) {
                    	Ext.getBody().unmask();
                        var responseData = Ext.decode(response.responseText);
                        if(!isNullOrEmpty(responseData.rows) && responseData.rows.length>0){
                        	var ObjModel = [];
                        	var cntLC = 1;
                        	responseData.rows.forEach(function(obj){
                        		var status;
                        		if(obj.status){
                        			status = 'ACTIVE';
                        		} else{
                        			status = 'INACTIVE';
                        		}
                        		var pncMapCoursesModel = new Academia.model.coursetransaction.coursereading.PncMapCoursesModel();
                        		pncMapCoursesModel.set("serialNo", cntLC);
                        		pncMapCoursesModel.set("courseName", obj.courseName);
                        		pncMapCoursesModel.set("courseDepartmentName", obj.courseDepartmentName);
                        		pncMapCoursesModel.set("status", status);
                        		pncMapCoursesModel.set("courseReadingPrescribe", obj.courseReadingPrescribe);
                        		//pncMapCoursesModel.set("dateRequired", obj.dateRequired);
                        		pncMapCoursesModel.set("phaseoutYear", obj.phaseoutYear);
                        		pncMapCoursesModel.set("distributionModeId", obj.distributionModeId);
                        		pncMapCoursesModel.set("courseId", obj.courseId);
                        		pncMapCoursesModel.set("readingId", obj.readingId);
                        		pncMapCoursesModel.set("id", obj.id);
                        		pncMapCoursesModel.set("isAddDeleteRow", true);
                        		pncMapCoursesModel.commit();
                        		ObjModel.push(pncMapCoursesModel);
                        		cntLC = cntLC+1;
                        	});
                    		grid.getStore().loadRawData(ObjModel, true);
                        }
                       
                    }
                });
            },
            deleteLinkedCoursesGridRecord: function(grid,record){
            	var $this = this;
            	if (grid.getSelectionModel().getCount() > 0) {
         			showConfirmMessage(getCommonTranslation('LINKED_COURSES'), getCommonTranslation('LINKED_COURSES_MAPPING_DELETE_MSG'), function(btn, text) {
         				if (btn == 'yes') {
         					var store = grid.getStore();
         					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         					var record = grid.getSelectionModel().getSelection()[0];
         					var id = record.get("id");
         					Ext.getBody().unmask();
         					if (!isNullOrEmpty(id)) {
         						Ext.Ajax.request({
         							method: "DELETE",
         							type: 'rest',
         							url: SERVERURL.COURSE_READING_DELETE+'?id='+id,
         							headers: {
         								'Content-Type': 'application/json'
         							},
         							params: {
         								id: id
         							},
         							success: function(form, action) {
         								Ext.getBody().unmask();
         								store.remove(record);
         								if(store.getCount()==0){
         									grid.down('#btnSaveMapLinkedCourseItemId').setDisabled(true);
         								}
         								
         								showSuccessMessage(getCommonTranslation('LINKED_COURSES'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
         								if(!isNullOrEmpty($this.getReadingmaterialgrid())){
         									$this.getReadingmaterialgrid().getStore().reload();
         									var structure = Ext.widget('maplinkedcoursesdetailpncform');
											var values = $this.getReadingmaterialgrid().searchedFormData;
											var grid = structure.down('#maplinkedcoursesdetailpncgridItemId');
							            	grid.getStore().removeAll();
							            	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
							        		Ext.Ajax.request({
							                    type: 'rest',
							                    url: SERVERURL.COURSE_READING_LIST,
							                    method: 'GET',
							                    params: {
							                    	invtItemMasterId:record.data.readingId,
							                    	academyLocationIds : academyLocationIds,
							                    	academicTermId:values.academicTermId,
							                    	courseDepartmentId:values.courseDepartmentId,
							                    	courseId:values.courseId,
							                    	programId:values.programId,
							                    	batchId:values.batchId,
							                    	periodId:values.periodId,
							                    	sort:null,
							                    	page: 1,
							                    	start: 0,
							                    	limit: 1000
							                    },
							                    success: function(response, action) {
							                    	Ext.getBody().unmask();
							                        var responseData = Ext.decode(response.responseText);
							                        if(!isNullOrEmpty(responseData.rows) && responseData.rows.length>0){
							                        	var ObjModel = [];
							                        	var cntLC = 1;
							                        	responseData.rows.forEach(function(obj){
							                        		var status;
							                        		if(obj.status){
							                        			status = 'ACTIVE';
							                        		} else{
							                        			status = 'INACTIVE';
							                        		}
							                        		var pncMapCoursesModel = new Academia.model.coursetransaction.coursereading.PncMapCoursesModel();
							                        		pncMapCoursesModel.set("serialNo", cntLC);
							                        		pncMapCoursesModel.set("courseName", obj.courseName);
							                        		pncMapCoursesModel.set("courseDepartmentName", obj.courseDepartmentName);
							                        		pncMapCoursesModel.set("status", status);
							                        		pncMapCoursesModel.set("courseReadingPrescribe", obj.courseReadingPrescribe);
							                        		//pncMapCoursesModel.set("dateRequired", obj.dateRequired);
							                        		pncMapCoursesModel.set("phaseoutYear", obj.phaseoutYear);
							                        		pncMapCoursesModel.set("distributionModeId", obj.distributionModeId);
							                        		pncMapCoursesModel.set("courseId", obj.courseId);
							                        		pncMapCoursesModel.set("readingId", obj.readingId);
							                        		pncMapCoursesModel.set("id", obj.id);
							                        		pncMapCoursesModel.set("isAddDeleteRow", true);
							                        		pncMapCoursesModel.commit();
							                        		ObjModel.push(pncMapCoursesModel);
							                        		cntLC = cntLC+1;
							                        	});
							                    		grid.getStore().loadRawData(ObjModel, true);
							                        }
							                       
							                    }
							                });
         									
         								}
         							},
         							failure:function(form, action){
         								var resp = Ext.decode(form.responseText);
         				            	if(!isNullOrEmpty(resp) && resp.length>0){
         				            		showWarningMessage(getCommonTranslation('LINKED_COURSES'),getCommonTranslation(resp[0].key));
         				            	}
         							}
         						});
         					}
         				}
         			});
         		
         		} else {
         			 showWarningMessage(getCommonTranslation('LINKED_COURSES'), getCommonTranslation("PLEASE_SELECT_RECORD"));
         		}
            },
            updateMapLinkedCoursePncGridRecord: function(){
        		var $this = this;
        		var contentPanel = $this.getContentPanel();
        		var grid = $this.getMaplinkedcoursesdetailpncgrid();
        		if(grid.getStore().getCount()>0) {
        			var json = $this.createMapLinkedCourseJson(grid);
        			if(!isNullOrEmpty(json) && json.length>0){
        				var submitUrl= SERVERURL.COURSE_READING_UPDATE;
        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        				var formData = Ext.encode(json);
        				Ext.Ajax.request({
        					type : 'rest',
        					url : submitUrl,
        					jsonData : formData,
        					method : 'POST',
        					success : function(frm, action) {
        						Ext.getBody().unmask();
        						showSuccessMessage(getCommonTranslation('LINKED_COURSES'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
        						var tabName = getCommonTranslation('LINKED_COURSES');
        						var getcontroller=$this.getController('menu.CoreERPNavigationController');
        						var getTab=getcontroller.getTab(tabName);
        						if(getTab!=null){
        							contentPanel.remove(getTab, true);
        						}
        						if(!isNullOrEmpty($this.getReadingmaterialgrid())){
 									$this.getReadingmaterialgrid().getStore().reload();
 								}
        					}
        				});
        			}
        		} else {
        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        		}
        	},
        	createMapLinkedCourseJson: function(grid){
        		var records = grid.getStore().getRange();
        		var arryRecordToSave=[];
        		for(var i in records) {

    				var status = 0;
    				if(!isNullOrEmpty(records[i].data.status) && records[i].data.status == 'ACTIVE')
    				{
    					status = 1;
    				}
    				
    				var readingNameId = this.getIdValueJson(records[i].data.readingId);
    				arryRecordToSave.push({
    					"course":this.getIdValueJson(records[i].data.courseId),
    					"invtItemMaster":readingNameId,
    					"status":status,
    					"id":records[i].data.id,
    					"courseReadingPrescribe":records[i].data.courseReadingPrescribe,
    					"phaseoutYear":records[i].data.phaseoutYear,
    					"distributionMode":this.getIdValueJson(records[i].data.distributionModeId)
    				});
    				
        		}
        		return arryRecordToSave;
        	},
        	getIdValueJson: function(id, value,code) {
        		if (id) return {
        			id: id,
        			value: value,
        			code: code
        		};
        	},
        	onAcademyLocationSelectionAndReset: function(form, academyLocationIds) {
            	var academicTermCombo = form.down('#academicTerm');
            	var programCombo = form.down('#programId');
            	var batchCombo = form.down('#batchId');
            	var periodCombo = form.down('#periodId');
            	var courseCombo = form.down('#courseId');
            	var courseDepartment = form.down('#courseDepartment');
            	var readingTypeCombo = form.down('#resourceTypeId');
            	var readingNameFilter = form.down('#readingNameId');
            	var isbnTenCombo = form.down('#isbnTenId');
            	var isbnThirteenthCombo = form.down('#isbnThirteenthId');
            	var multiselectFirstAuthor = form.down('#multiselectFirstAuthor');
            	var grid = this.getReadingmaterialgrid();
				grid.down('#exportReport').setDisabled(true);
            	academicTermCombo.reset();
            	programCombo.reset();
            	batchCombo.reset();
            	periodCombo.reset();
            	courseCombo.reset();
            	courseDepartment.reset();
            	readingTypeCombo.reset();
            	readingNameFilter.reset();
            	isbnTenCombo.reset();
            	isbnThirteenthCombo.reset();
            	multiselectFirstAuthor.reset();
            	if(!isNullOrEmpty(isbnTenCombo.getValue)){
            		isbnTenCombo.setValue('');
            	}
            	if(!isNullOrEmpty(isbnThirteenthCombo.getValue)){
            		isbnThirteenthCombo.setValue('');
            	}
            	if(!isNullOrEmpty(multiselectFirstAuthor.getValue)){
            		multiselectFirstAuthor.setValue('');
            	}
            	
            	batchCombo.setDisabled(true);
				periodCombo.setDisabled(true);
					
            	var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool){
						periodCombo.setVisible(false);
					}else{
						periodCombo.setVisible(true);
					}

            	var departmentStore = courseDepartment.getStore();
            	departmentStore.getProxy().extraParams = {
            		academyLocationIds : academyLocationIds
            	};
            	departmentStore.load();

            	var academicTermStore = academicTermCombo.getStore();
            	academicTermStore.getProxy().extraParams = {
            		academyLocationIds : academyLocationIds
            	};
            	academicTermStore.load();

            	var coursestore = courseCombo.getStore();
            	coursestore.getProxy().extraParams = {	
            		academyLocationIds:academyLocationIds
            	};
            	coursestore.load();

            	var programStore =  programCombo.getStore();
            	programStore.getProxy().extraParams = {	
            		academyLocationIds:academyLocationIds
            	};
            	programStore.load();

            	var readingNameStore =  readingNameFilter.getStore();
            	readingNameStore.getProxy().extraParams = {	
            		inventoryTypeId:null
            	};
            	readingNameStore.load();

            	var isbnTenStore = isbnTenCombo.getStore();
            	isbnTenStore.getProxy().extraParams = {	
            		inventoryTypeId: null
            	};
            	isbnTenStore.load();

            	var isbnThirteenthStore = isbnThirteenthCombo.getStore();
            	isbnThirteenthStore.getProxy().extraParams = {	
            		inventoryTypeId: null
            	};
            	isbnThirteenthStore.load();
            	
				var store = readingTypeCombo.getStore();
				store.getProxy().extraParams = {
	      			isReadingMaterial : true
				 };
				 store.load();
				 
				 var firstAuthorStore = multiselectFirstAuthor.getStore();
				 firstAuthorStore.getProxy().extraParams = {	
					 firstAuthors: null
				 };
				 firstAuthorStore.load();
            }
});
