/**
 <  * @author Anshu Singh
 */
Ext.define('Academia.controller.course.reports.CourseCreditGradeReportController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['common.ParameterizedProgramBatchPeriodDetailStore', 'course.CourseComboByCriteriaStore', 'common.AcademyLocationNameSeparated',
            'program.ProgramByALAcademicTermAndCategoryStore', 'course.coursegroup.CourseCreditGradeReportGridStore',
            'course.CourseDepartmentALWiseStore','program.MappedProgramCategorybyAlStore',
            'common.AcademicTermByMappedPeriodStore'],
    views: ['course.coursegroup.CourseCreditGradeReportsGrid',
    	    'course.reports.CourseCreditGradeReportsStructure','course.reports.CourseCreditGradeReportSearchForm'],
            config: {
        	  	  	COURSE_CREDIT_GRADE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_CREDIT_GRADE_REPORT_PRIVILEGES')
               },
    refs: [{
        ref: 'coursecreditgradereportsstructure',
        selector: 'coursecreditgradereportsstructure'  
    },{
    	ref : 'coursecreditgradereportsgrid',
	    selector : 'coursecreditgradereportsgrid' 
    },{
   	 ref : 'coursecreditgradereportsearchform',
	 selector : 'coursecreditgradereportsearchform'
   }],
    
    init: function() {
        this.control({
                 'coursecreditgradereportsstructure':{
                	 render: function(me, eOpts) {
							me.up('panel').body.el.dom.style.overflowX='hidden';
						},
        	},
        	
        	
             'coursecreditgradereportgrid': {
                   render: function(grid) {
                   	this.loadCourseCreditGradeReport(grid);
                   },
                 },
                                
        		 'coursecreditgradereportsearchform button[itemId=resetBtn]' : {
        			 click : function(obj){
        				 var form=this.getCoursecreditgradereportsearchform();
						
        				 var $this = this;

							var academicTermField = form.down("#academicTerm");
							var programComboBox = form.down("#programId");
							var batchComboBox = form.down("#batchId");
							var periodComboBox = form.down('#periodId');
							var courseDepartment = form.down("#courseDepartment");
							var programCategory =  form.down("#programCategory");
							var courseComboBox =  form.down("#courseId");
							var portalId = this.getCurrentLoggedPortalId();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
															
							var courseDepartmentComboBox= form.down("#courseDepartment");
							var programCategoryComboBox= form.down("#programCategory");
		    				var programId= form.down("#programIds");
				
							programComboBox.reset();
							programComboBox.clearValue();
							programId.reset();
							programId.clearValue();
							batchComboBox.reset();
							batchComboBox.clearValue();
							periodComboBox.reset();
							periodComboBox.clearValue();
							courseDepartment.reset();
							courseDepartment.clearValue();
						    courseComboBox.reset();
							courseComboBox.clearValue();
							academicTermField.reset();
						   
						    form.down("#academyLocationId").reset();
						    form.down("#academyLocationId").clearValue();
						    programCategoryComboBox.reset();
						    programCategoryComboBox.clearValue();
						    var academyLocationId = form.down("#academyLocationId").getValue();

							if(academyLocationId==null){
								academyLocationId= this.getUserAccessibleAL();
							}

							if(wheatherSchool) {
								periodComboBox.hide();
							}
							var academicTermId=null;
								var academicTermComboStore = academicTermField.getStore();
								academicTermComboStore.getProxy().extraParams = {
									academyLocationIds : academyLocationId
								};
								academicTermComboStore.load({
									callback: function(rec, success) {
										if (success) {
											for(var i in rec){
												if(rec[i].get('sequence')==1){
													academicTermField.setValue(rec[i].get('id'));
													academicTermId=rec[i].get('id');
													
													 
												}
											}
											var courseDepartmentStore = courseDepartmentComboBox.getStore();
						    				 courseDepartmentStore.getProxy().extraParams = {
						    					 academyLocationIds : academyLocationId
						    				 };
						    				 courseDepartmentStore.load();
						    				 
						    				 var programCategoryStore =programCategoryComboBox.getStore();
						    				 programCategoryStore.getProxy().extraParams = {
						    					 academyLocationIds : academyLocationId
						    				 };
						    				 programCategoryStore.load();
						    				 
						    				 var programStore = programComboBox.getStore();
						    				 programStore.getProxy().extraParams = {
						    					 academyLocationIds : academyLocationId,
						    					 academicTermId : academicTermId,
						    					 programCategoryId : programCategoryComboBox.getValue()
						    				 };
						    				 programStore.load();
					    				 
					    				 var courseStore = courseComboBox.getStore();
					    				 courseStore.getProxy().extraParams = {
					    					 academyLocationIds : academyLocationId,
					    					 academicTermId : academicTermId,
					    					 departmentId : courseDepartmentComboBox.getValue(),
					    					 programId : programComboBox.getValue(),
					    					 batchId : batchComboBox.getValue(),
					    					 periodId : periodComboBox.getValue(),
					    					 programCategory:programCategory.getValue()
					    				 };
					    				 courseStore.load();
										}
									}
								});
								
								
		    				 form.down("#batchId").setDisabled(true);
		    				 form.down("#periodId").setDisabled(true);
        			 }
        		 }, 

					'coursecreditgradereportsearchform': {
						render: function(form) {
							var $this = this;

							var academicTermField = form.down("#academicTerm");
							var programComboBox = form.down("#programId");
							var batchComboBox = form.down("#batchId");
							var periodComboBox = form.down('#periodId');
							var courseDepartment = form.down("#courseDepartment");
							var programCategory =  form.down("#programCategory");
							var courseComboBox =  form.down("#courseId");
							var portalId = this.getCurrentLoggedPortalId();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
															
							var courseDepartmentComboBox= form.down("#courseDepartment");
							var programCategoryComboBox= form.down("#programCategory");
				
							programComboBox.reset();
							programComboBox.clearValue();
							batchComboBox.reset();
							batchComboBox.clearValue();
							periodComboBox.reset();
							periodComboBox.clearValue();
							courseDepartment.reset();
							courseDepartment.clearValue();
						    courseComboBox.reset();
							courseComboBox.clearValue();
							academicTermField.reset();
							academicTermField.clearValue();
							programCategoryComboBox.reset();
						    programCategoryComboBox.clearValue();
							
						    var academyLocationId = form.down("#academyLocationId").getValue();
							if(academyLocationId==null){
								academyLocationId= this.getUserAccessibleAL();
							}

							if(wheatherSchool) {
								periodComboBox.hide();
							}
							var academicTermId=null;
								var academicTermComboStore = academicTermField.getStore();
								academicTermComboStore.getProxy().extraParams = {
									academyLocationIds : academyLocationId
								};
								academicTermComboStore.load({
									callback: function(rec, success) {
										if (success) {
											for(var i in rec){
												if(rec[i].get('sequence')==1){
													academicTermField.setValue(rec[i].get('id'));
													academicTermId=rec[i].get('id');
													
													 
												}
											}
											var courseDepartmentStore = courseDepartmentComboBox.getStore();
						    				 courseDepartmentStore.getProxy().extraParams = {
						    					 academyLocationIds : academyLocationId
						    				 };
						    				 courseDepartmentStore.load();
						    				 
						    				 var programCategoryStore =programCategoryComboBox.getStore();
						    				 programCategoryStore.getProxy().extraParams = {
						    					 academyLocationIds : academyLocationId
						    				 };
						    				 programCategoryStore.load();
						    				 
						    				 var programStore = programComboBox.getStore();
						    				 programStore.getProxy().extraParams = {
						    					 academyLocationIds : academyLocationId,
						    					 academicTermId : academicTermId,
						    					 programCategoryId : programCategoryComboBox.getValue()
						    				 };
						    				 programStore.load();
					    				 
					    				 var courseStore = courseComboBox.getStore();
					    				 courseStore.getProxy().extraParams = {
					    					 academyLocationIds : academyLocationId,
					    					 academicTermId : academicTermId,
					    					 departmentId : courseDepartmentComboBox.getValue(),
					    					 programId : programComboBox.getValue(),
					    					 batchId : batchComboBox.getValue(),
					    					 periodId : periodComboBox.getValue(),
					    					 programCategory:programCategory.getValue()
					    				 };
					    				 courseStore.load();
										}
									}
								});
								
								
		    				 form.down("#batchId").setDisabled(true);
		    				 form.down("#periodId").setDisabled(true);
		    				 
						}
					},
          //***1**************Export For Report**********************************************************************
			  
		        //*********************************************************************************************************************   
			       
		        'coursecreditgradereportsearchform customcombobox[itemId=academyLocationId]': {
        		 select: function(obj, record) {
        			 var academyLocationId = record[0].get("id"); 
        			 if(academyLocationId==null){
        			 academyLocationId = this.getUserAccessibleAL();
        			 }
        			 var $this = this;
        			 
        			var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm');
        			academicTermComboBox.reset();
        			        		
    				 var courseDepartmentComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseDepartment');
    				 courseDepartmentComboBox.reset();
    				 
    				var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');
    				programCategoryComboBox.reset();
    				
    				 var programComboBox = this.getCoursecreditgradereportsearchform().down('combo#programId');
    				 programComboBox.reset();

    				 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');
    				 batchComboBox.reset();
    				 batchComboBox.clearValue();
    				 batchComboBox.setDisabled(true);

    				 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
    				 periodComboBox.reset();
    				 periodComboBox.setDisabled(true);

    				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
    				courseComboBox.reset();
    				    				 
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
    				 var wheatherSchool = alinfomodel.get('wheatherSchool');
    				 if(wheatherSchool){
    					 $this.getCoursecreditgradereportsearchform().down('#periodId').hide();
    				 }

    				 var academicTermComboStore = academicTermComboBox.getStore();
    				 
    				 var programStore = programComboBox.getStore();
    				 var academicTermId=null;

						academicTermComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId
						};
						academicTermComboStore.load({
							callback: function(rec, success) {
								if (success) {
									for(var i in rec){
										if(rec[i].get('sequence')==1){
											academicTermComboBox.setValue(rec[i].get('id'));
											academicTermId=rec[i].get('id');
											
										}
									}
									
									 var courseDepartmentStore = courseDepartmentComboBox.getStore();
				    				 courseDepartmentStore.getProxy().extraParams = {
				    					 academyLocationIds : academyLocationId
				    				 };
				    				 courseDepartmentStore.load();
				    				 
				    				 var programCategoryStore =programCategoryComboBox.getStore();
				    				 programCategoryStore.getProxy().extraParams = {
				    					 academyLocationIds : academyLocationId
				    				 };
				    				 programCategoryStore.load();
				    				 
				    				 var programStore = programComboBox.getStore();
				    				 programStore.getProxy().extraParams = {
				    					 academyLocationIds : academyLocationId,
				    					 academicTermId : academicTermId,
				    					 programCategoryId : programCategoryComboBox.getValue()
				    				 };
				    				 programStore.load();
			    				 
			    				 var courseStore = courseComboBox.getStore();
			    				 courseStore.getProxy().extraParams = {
			    					 academyLocationIds : academyLocationId,
			    					 academicTermId : academicTermId,
			    					 departmentId : courseDepartmentComboBox.getValue(),
			    					 programId : programComboBox.getValue(),
			    					 batchId : batchComboBox.getValue(),
			    					 periodId : periodComboBox.getValue(),
			    					 programCategory:programCategoryComboBox.getValue()
			    				 };
			    				 courseStore.load();
								}
							}
					});

					
    			 }
        	 },
        	 
             'coursecreditgradereportsearchform button[itemId=courseReportSearchButtonId]': {
           	  click:function(){
           		  this.courseReportSearchButton();  
           	  } 
             	},
   			 'coursecreditgradereportsearchform combo[itemId=academicTerm]': {
   				 select: function(obj, record) {
        			 var academicTermId = record[0].get("id"); 
        			 var $this = this;
        			 var courseDepartmentComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseDepartment');
    				    				 
    				 var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');
    				 var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm');
    				
    				 var programComboBox = this.getCoursecreditgradereportsearchform().down('combo#programId');
    				 programComboBox.reset();
    				 programComboBox.clearValue();
    		

    				 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');
    				 batchComboBox.reset();
    				 batchComboBox.clearValue();
    				 batchComboBox.setDisabled(true);

    				 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
    				 periodComboBox.reset();
    				 periodComboBox.clearValue();
    				 periodComboBox.setDisabled(true);

    				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
    				 courseComboBox.reset();
    				    				 
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
    				 var wheatherSchool = alinfomodel.get('wheatherSchool');
    				 if(wheatherSchool){
    					 $this.getCoursecreditgradereportsearchform().down('#periodId').hide();
    				 }

    				 var academicTermComboStore = academicTermComboBox.getStore();
    				 var academyLocationId = this.getCoursecreditgradereportsearchform().down('combo#academyLocationId').getValue(); 
          			if(academyLocationId==null){
						academyLocationId= this.getUserAccessibleAL();
					}
    				 var programStore = programComboBox.getStore();

    				 var courseDepartmentStore = courseDepartmentComboBox.getStore();
    				 courseDepartmentStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId
    				 };
    				 courseDepartmentStore.load();
    				 
    				 var programCategoryStore =programCategoryComboBox.getStore();
    				 programCategoryStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId
    				 };
    				 programCategoryStore.load();
    				 
    				 var programStore = programComboBox.getStore();
    				 programStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermId,
    					 programCategoryId : programCategoryComboBox.getValue()
    				 };
    				 programStore.load();
    				 
    				 var batchStore = batchComboBox.getStore();
    				 batchStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermId,
    					 programCategoryId : programCategoryComboBox.getValue(),
    					 programId : programComboBox.getValue()
    					 
    				 };
    				 batchStore.load();
    				 
    				 var periodStore = periodComboBox.getStore();
    				 periodStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermId,
    					 programCategoryId : programCategoryComboBox.getValue(),
    					 programId : programComboBox.getValue(),
    					 batchId : batchComboBox.getValue()
    					
    				 };
    				 periodStore.load();    				 
    				     				 
    				 var courseStore = courseComboBox.getStore();
    				 courseStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermId,
    					 departmentId : courseDepartmentComboBox.getValue(),
    					 programId : programComboBox.getValue(),
    					 batchId : batchComboBox.getValue(),
    					 periodId : periodComboBox.getValue(),
    					 programCategory:programCategoryComboBox.getValue()
    				 };
    				 courseStore.load();
    			
    			 }
   			 },

	           
   			 'coursecreditgradereportsearchform combo[itemId=courseDepartment]': {
   				 select: function(obj, record) {
        			 var courseDepartmentId = record[0].get("id");
        			
        			 var $this = this;
        			 var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm'); 
    				 var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');
    				
    				 var programComboBox = this.getCoursecreditgradereportsearchform().down('combo#programId');
    				 programComboBox.reset();

    				 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');
    				 batchComboBox.reset();
    				 batchComboBox.setDisabled(true);

    				 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
    				 periodComboBox.reset();
    				 periodComboBox.setDisabled(true);

    				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
    				 courseComboBox.reset();
    				    				 
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
    				 var wheatherSchool = alinfomodel.get('wheatherSchool');
    				 if(wheatherSchool){
    					 $this.getCoursecreditgradereportsearchform().down('#periodId').hide();
    				 }

    				 var academicTermComboStore = academicTermComboBox.getStore();
    				 var academyLocationId = this.getCoursecreditgradereportsearchform().down('combo#academyLocationId').getValue(); 
          			if(academyLocationId==null){
						academyLocationId= this.getUserAccessibleAL();
					}
    				 var programStore = programComboBox.getStore();
   				   				 
    				 var programCategoryStore =programCategoryComboBox.getStore();
    				 programCategoryStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId
    				 };
    				 programCategoryStore.load();
    				 
    				 var programStore = programComboBox.getStore();
    				 programStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 programCategoryId : programCategoryComboBox.getValue()
    				 };
    				 programStore.load();
    				 
    				 var batchStore = batchComboBox.getStore();
    				 batchStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 programCategoryId : programCategoryComboBox.getValue(),
    					 programId : programComboBox.getValue()
    					 
    				 };
    				 batchStore.load();
    				 
    				 var periodStore = periodComboBox.getStore();
    				 periodStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 programCategoryId : programCategoryComboBox.getValue(),
    					 programId : programComboBox.getValue(),
    					 batchId : batchComboBox.getValue()
    					
    				 };
    				 periodStore.load();    				 
    				     				 
    				 var courseStore = courseComboBox.getStore();
    				 courseStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 departmentId : courseDepartmentId,
    					 programId : programComboBox.getValue(),
    					 batchId : batchComboBox.getValue(),
    					 periodId : periodComboBox.getValue(),
    					 programCategory:programCategoryComboBox.getValue()
    				 };
    				 courseStore.load();
    			
    			
    			 }
   			 },

	           
   			 'coursecreditgradereportsearchform combo[itemId=programCategory]': {
   				 select: function(obj, record) {
        			 var programCategoryId = record[0].get("id");  
        			
        			 var $this = this;
        			 var academyLocationId = this.getCoursecreditgradereportsearchform().down('combo#academyLocationId').getValue(); 
             			if(academyLocationId==null){
							academyLocationId= this.getUserAccessibleAL();
						}
        			 var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm');         			         			        		
     				 var courseDepartmentComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseDepartment');     				      				 
     				 var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');
     			    				
     				 var programComboBox = this.getCoursecreditgradereportsearchform().down('combo#programId');
     				 programComboBox.reset();

     				 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');
     				 batchComboBox.reset();
     				 batchComboBox.clearValue();
     				 batchComboBox.setDisabled(true);

     				 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
     				 periodComboBox.reset();
     				 periodComboBox.setDisabled(true);

     				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
     				courseComboBox.reset();
    				    				 
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
    				 var wheatherSchool = alinfomodel.get('wheatherSchool');
    				 if(wheatherSchool){
    					 $this.getCoursecreditgradereportsearchform().down('#periodId').hide();
    				 }
    				 var programStore = programComboBox.getStore();
    				 programStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 programCategoryId :programCategoryId
    				 };
    				 programStore.load();
    				 
    				 
    				 var batchStore = batchComboBox.getStore();
    				 batchStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 programCategoryId :programCategoryId,
    					 programId : programComboBox.getValue()
    					 
    				 };
    				 batchStore.load();
    				 
    				 var periodStore = periodComboBox.getStore();
    				 periodStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 programCategoryId : programCategoryId,
    					 programId : programComboBox.getValue(),
    					 batchId : batchComboBox.getValue()
    					
    				 };
    				 periodStore.load();    				 
    				     				 
    				 var courseStore = courseComboBox.getStore();
    				 courseStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 departmentId : courseDepartmentComboBox.getValue(),
    					 programId : programComboBox.getValue(),
    					 batchId : batchComboBox.getValue(),
    					 periodId : periodComboBox.getValue(),
    					 programCategory:programCategoryId
    				 };
    				 courseStore.load();
    			
    			 }
   			 },

	           
   			 'coursecreditgradereportsearchform combo[itemId=programId]': {
   				 select: function(obj, record) {
   					 var $this = this;
   					 
        			 var academyLocationId =  this.getCoursecreditgradereportsearchform().down('combo#academyLocationId').getValue(); 
          			if(academyLocationId==null){
						academyLocationId= this.getUserAccessibleAL();
					} 
        			 var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm');         			         			        		
     				 var courseDepartmentComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseDepartment');     				     				 
     				 var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');     			     				
     				 var programComboBox = this.getCoursecreditgradereportsearchform().down('combo#programId');
     				
     				 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');     				
     				 batchComboBox.setDisabled(false);
     				
     				 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
     				 periodComboBox.reset();
     				 periodComboBox.setDisabled(true);

     				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
     				 courseComboBox.reset();
    				    				 
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
    				 var wheatherSchool = alinfomodel.get('wheatherSchool');
    				 if(wheatherSchool){
    					 $this.getCoursecreditgradereportsearchform().down('#periodId').hide();
    				 }
    			    				 
    				 var programId = record[0].get("id");
    				 this.getCoursecreditgradereportsearchform().down('combo#programIds').setValue(programId);  
    				 if (programId > 0) {
    					 batchCom = this.getCoursecreditgradereportsearchform().down('#batchId');
    					 batchCom.clearValue();

    					 var batchStore = batchComboBox.getStore();
        				 batchStore.getProxy().extraParams = {
        					 academyLocationIds : academyLocationId,
        					 academicTermId : academicTermComboBox.getValue(),
        					 programCategoryId : programCategoryComboBox.getValue(),
        					 programId : programId
        					 
        				 };
        				 batchStore.load({
    						 callback: function(records, operation, success) {
    							 if (success) {
    								 var batchId = 0;
    								 for (var i = 0, j = 0; i < records.length; i++) {
    									 if (records.length == 1) {
    										 batchId = records[i].data.id;
    									 } else if (records[i].data.isCurrentPeriodOfProgram) {
    										 if (j == 0) {
    											 batchId = records[i].data.id;
    											 j++;
    										 } else {
    											 batchId = 0;
    											 return;
    										 }
    									 }
    								 }

    							 }
    							 if (batchId > 0) {
    								 $this.getCoursecreditgradereportsearchform().down('#batchId').setValue(batchId);
    								 var periodField=$this.getCoursecreditgradereportsearchform().down('#periodId');
    								 periodField.setDisabled(false);

    								 var periodStore = periodComboBox.getStore();
    			    				 periodStore.getProxy().extraParams = {
    			    					 academyLocationIds : academyLocationId,
    			    					 academicTermId : academicTermComboBox.getValue(),
    			    					 programCategoryId : programCategoryComboBox.getValue(),
    			    					 programId : programId,
    			    					 batchId : batchComboBox.getValue()
    			    					
    			    				 };
    			    				 periodStore.load({
    		    						 callback: function(records, operation, success) {
    		    							 if (success) {
    		    								 if (records.length == 0) {
    		    									 if (wheatherSchool) {
    		    										 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    		    									 }
    		    								 } else if (records.length == 1) {
    		    									 var periodId = records[0].data.id;
    		    									 $this.getCoursecreditgradereportsearchform().down('#periodId').setValue(periodId);
    		    									 var courseStore = courseComboBox.getStore();
    		    				    				 courseStore.getProxy().extraParams = {
    		    				    					 academyLocationIds : academyLocationId,
    		    				    					 academicTermId : academicTermComboBox.getValue(),
    		    				    					 departmentId : courseDepartmentComboBox.getValue(),
    		    				    					 programId : programId,
    		    				    					 batchId : batchComboBox.getValue(),
    		    				    					 periodId : periodId,
    		    				    					 programCategory:programCategoryComboBox.getValue()
    		    				    				 };
    		    				    				 courseStore.load();
    		    									 if (wheatherSchool) {
    		    										 $this.getCoursecreditgradereportsearchform().down('#periodId').setVisible(false);
    		    									 }    									
    		    									
    		    								 } 
    		    							 }
    		    						 }
    		    					 });
    			                    }
    			                }
    			            });
    			        }
    			    
    				 
    				
    			
    			 }
   			 },
   			 'coursecreditgradereportsearchform combo[itemId=batchId]': {
   				 select: function(obj, record) {
   					 var $this = this;
   					 
   					 var batchId = record[0].get("id");
        			 var academyLocationId =  this.getCoursecreditgradereportsearchform().down('combo#academyLocationId').getValue(); 
          			if(academyLocationId==null){
						academyLocationId= this.getUserAccessibleAL();
					}
        			 var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm');
        			 var courseDepartmentComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseDepartment');
        			 var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');
        			 var programId =  this.getCoursecreditgradereportsearchform().down('combo#programIds').getValue();
        			 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');
        			 
        			 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
        			 periodComboBox.reset();
     				 periodComboBox.setDisabled(false);

     				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
     				 courseComboBox.reset();
     				
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
    				 var wheatherSchool = alinfomodel.get('wheatherSchool');
    				 if(wheatherSchool){
    					 $this.getCoursecreditgradereportsearchform().down('#periodId').hide();
    				 }
    				 
    				 if (batchId > 0) {
    					 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
    					
    					 var periodStore = periodComboBox.getStore();
        				 periodStore.getProxy().extraParams = {
        					 academyLocationIds : academyLocationId,
        					 academicTermId : academicTermComboBox.getValue(),
        					 programCategoryId : programCategoryComboBox.getValue(),
        					 programId : programId,
        					 batchId : batchId
        					
        				 };
        				 periodStore.load({
    						 callback: function(records, operation, success) {
    							 if (success) {
    								 if (records.length == 0) {
    									 if (wheatherSchool) {
    										 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    									 }
    								 } else if (records.length == 1) {
    									 var periodId = records[0].data.id;
    									 $this.getCoursecreditgradereportsearchform().down('#periodId').setValue(periodId);
    									 var courseStore = courseComboBox.getStore();
    			        				 courseStore.getProxy().extraParams = {
    			        					 academyLocationIds : academyLocationId,
    			        					 academicTermId : academicTermComboBox.getValue(),
    			        					 departmentId : courseDepartmentComboBox.getValue(),
    			        					 programId : programId,
    			        					 batchId : batchId,
    			        					 periodId : periodId,
    			        					 programCategory:programCategoryComboBox.getValue()
    			        				 };
    			        				 courseStore.load();
    									 if (wheatherSchool) {
    										 $this.getCoursecreditgradereportsearchform().down('#periodId').setVisible(false);
    									 }    									
    									
    								 } 
    							 }
    						 }
    					 });    					 
    					
    				 }
    			 }
   			 },

	           
   			 'coursecreditgradereportsearchform combo[itemId=periodId]': {
   				 select: function(obj, record) {
   					 var $this = this;   					 
   					 var periodId = record[0].get("id");
   					
        			 var academyLocationId =  this.getCoursecreditgradereportsearchform().down('combo#academyLocationId').getValue(); 
          			if(academyLocationId==null){
						academyLocationId= this.getUserAccessibleAL();
					}  
        			 var academicTermComboBox = this.getCoursecreditgradereportsearchform().down('combo#academicTerm');
     				 var courseDepartmentComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseDepartment');
     				 var programCategoryComboBox = this.getCoursecreditgradereportsearchform().down('combo#programCategory');
     				 var programComboBox = this.getCoursecreditgradereportsearchform().down('combo#programId');
     				 var batchComboBox = this.getCoursecreditgradereportsearchform().down('combo#batchId');    				

     				 var periodComboBox = this.getCoursecreditgradereportsearchform().down('combo#periodId');
     				 var courseComboBox = this.getCoursecreditgradereportsearchform().down('combo#courseId');
     				 courseComboBox.reset();
     				 
     				var programId = this.getCoursecreditgradereportsearchform().down('combo#programIds').getValue();

    				 var courseStore = courseComboBox.getStore();
    				 courseStore.getProxy().extraParams = {
    					 academyLocationIds : academyLocationId,
    					 academicTermId : academicTermComboBox.getValue(),
    					 departmentId : courseDepartmentComboBox.getValue(),
    					 programId : programId,
    					 batchId : batchComboBox.getValue(),
    					 periodId : periodId,
    					 programCategory:programCategoryComboBox.getValue()
    				 };
    				 courseStore.load();
    			 }
   			 }

        });
    },
    
    /************************ START: Common functions for dynamic grid links  ****************************************/
    
    createJsonFormat: function(courseReportSearchForm, respectiveLinkConfigCode, records) {
      //  var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        var courseId = courseReportSearchForm.getForm().findField('courseId');
        var academyLocationId = courseReportSearchForm.getForm().findField('academyLocationId');
        values.configCode = respectiveLinkConfigCode;
        
        var COURSE_ID = this.getJsonObject('COURSE_ID', courseId.getValue());
        this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
        
        var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId.getValue());
        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);

        values.searchCriterias = searchcriteria;
        return values;
    },
    getJsonObject: function(key, value, additionalValue) {
      	 if (value != '' && value != null && additionalValue == undefined) {
      		 return {
      			 "paramCode": key,
      			 "paramValues": [value]
      		 };
      	 } else if (value != '' && additionalValue != undefined) {
      		 return {
      			 "paramCode": key,
      			 "paramValues": [value, additionalValue]
      		 };
      	 }
       },
       pushJsonObjectInArray: function(object, array) {
      	 if (object) {
      		 array.push(object);
      	 }
       },
       
    /************************ END: Common functions for dynamic grid links  ****************************************/
     createSearchCriteriaString: function(searchForm) {
       		   var me=this;
       		   var formValues = new Array();
       		   formValues = searchForm.getValues();        
       		   var searchCriteriaString="";
       		   for (var key in formValues) {
       			   var value = formValues[key];            
       			   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
       				  
       			   }
       		   }
       		   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
       		   return searchCriteriaString;
       	   },
       
       
          getIdValueJson: function(id, value) {
      	 if (id) return {
      		 id: id,
      		 value: value
      	 };
       },
       loadCourseCreditGradeReport: function(grid) {
   		var gridStore = grid.getStore();
   		var courseReportSearchForm = this.getCoursecreditgradereportsearchform();
   		courseReportSearchForm.down('#courseReportSearchButtonId').setDisabled(true);
   		var courseId = courseReportSearchForm.down('#courseId').getValue();
   		var academicTerm = courseReportSearchForm.down('#academicTerm').getValue();
   		var courseDepartment = courseReportSearchForm.down('#courseDepartment').getValue();
   		var programCategory = courseReportSearchForm.down('#programCategory').getValue();
   	
   		var programId = courseReportSearchForm.down('#programIds').getValue();
   		var batchId = courseReportSearchForm.down('#batchId').getValue();
   		var periodId = courseReportSearchForm.down('#periodId').getValue();
   		var academyLocationId =   courseReportSearchForm.down('#academyLocationId').getValue(); 
   		grid.config.searchFilterForm = courseReportSearchForm;
			if(academyLocationId==null){
			academyLocationId= this.getUserAccessibleAL();
		} 
   		gridStore.getProxy().extraParams = {
			   courseId:courseId,
			   academyLocationId:academyLocationId,
			   academicTermId:academicTerm,
			   courseDepartmentId:courseDepartment,
			   programCategoryId:programCategory,
			   programId:programId,
			   batchId:batchId,
     		   periodId:periodId								   
			   };
   		this.resetPageSetting(gridStore);
   		gridStore.load({
			callback: function(records, operation, success) {
				courseReportSearchForm.down('#courseReportSearchButtonId').setDisabled(false);
			}
 		   });
   		
   	} ,
   	courseReportSearchButton:function(){
 	   var $this = this;
	
	   this.loadCourseCreditGradeReport(this.getCoursecreditgradereportsgrid());

   },
   getUserAccessibleAL:function(){
	   var academyLocationId = [];
	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	   for(var i=0; i<academyLocationList.length; i++){
		   academyLocationId.push(academyLocationList[i].id);
	   }
	   return academyLocationId.join();
   }
});