/**
 * @author prathamesh.sheth
 * 
 * This controller is used for  custom category details.   
 */
Ext.define('Academia.controller.customcategories.CustomCategoryController', {
    extend: 'Academia.controller.base.BaseController',

    models: ['customcategories.CustomCategoryModel', 'customcategories.CustomCategoryValuesModel'],

    stores: ['customcategories.TableConfigCategoryStore', 'customcategories.TableColumnConfigStore', 
             'customcategories.StandardMasterCategoryStore', 'customcategories.CustomCategoryStore',
             'customcategories.CustomCategoryValuesStore', 'customcategories.DynamicStandardMasterCategoryComboStore',
             'customcategories.DynamicCustomCategoryComboStore','customcategories.TableConfigCategoryMasterSearchStore'],

    views: ['personinfo.common.PersonCommonWindow', 'common.CustomFieldForm', 'customcategories.CustomCategory', 
            'customcategories.StandardMasterCustomCategoryForm', 'customcategories.CustomCategoryStandardMasterGrid', 
            'customcategories.CustomCategoryForm', 'customcategories.CustomCategoryGrid', 
            'customcategories.CustomCategoryValuesForm', 'customcategories.CustomCategoryValuesGrid'],

    alias: "widget.customcategorycontroller",

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'customCategory',
        selector: 'customcategory'
    }, {
        ref: 'standardMasterCustomCategoryForm',
        selector: 'standardmastercustomcategoryform'
    }, {
        ref: 'customCategoryStandardMasterGrid',
        selector: 'customcategorystandardmastergrid'
    }, {
        ref: 'customCategoryForm',
        selector: 'customcategoryform'
    }, {
        ref: 'customCategoryGrid',
        selector: 'customcategorygrid'
    }, {
        ref: 'customCategoryValuesForm',
        selector: 'customcategoryvaluesform'
    }, {
        ref: 'customCategoryValuesGrid',
        selector: 'customcategoryvaluesgrid'
    }],
    config: {
    	CUSTOM_CATEGORIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CUSTOM_CATEGORIES_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	/**
             * Standard master custom category add/edit/view/delete
             */
        	'customcategorystandardmastergrid[itemId=customCategoryStandardMasterGrid] combo[itemId=customTableConfigField]': {
        		select: function(combo, records, eOpts) {
                	var grid = this.getCustomCategoryStandardMasterGrid();
                	var customTableConfigValue = combo.getValue();
                	this.loadCustomCategoryGridStore(grid, customTableConfigValue, 'CUSTOM_CATEGORY', true);
                }
            },
            'customcategorystandardmastergrid[itemId=customCategoryStandardMasterGrid] button[itemId=btnAdd]': {
                click: function() {
                	this.showCommonFormWindow('STANDARD_MASTER_CUSTOM_CATEGORY');
                }
            },
            'customcategorystandardmastergrid[itemId=customCategoryStandardMasterGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editStandardMasterCustomCategory('STANDARD_MASTER_CUSTOM_CATEGORY', false);
                }
            },
            'customcategorystandardmastergrid[itemId=customCategoryStandardMasterGrid] button[itemId=btnView]': {
                click: function() {
                    this.editStandardMasterCustomCategory('STANDARD_MASTER_CUSTOM_CATEGORY', true);
                }
            },
            'customcategorystandardmastergrid[itemId=customCategoryStandardMasterGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteStandardMasterCustomCategory();
                }
            },
            /*'standardmastercustomcategoryform[itemId=standardMasterCustomCategoryForm]': {
                render: function(form) {
                	this.loadTableConfigFieldDropDown(form, null, 'CUSTOM_CATEGORY');
                }
            },*/
            'standardmastercustomcategoryform[itemId=standardMasterCustomCategoryForm] nestedJsonCombo[itemId=customTableConfigField]': {
                select: function(combo, records, eOpts) {
                	var form = this.getStandardMasterCustomCategoryForm();
                	var customTableConfigValue = combo.getValue();
                	this.loadColumnNameDropDown(form, customTableConfigValue, 'CUSTOM_CATEGORY');
                }
            },
            'standardmastercustomcategoryform[itemId=standardMasterCustomCategoryForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveStandardMasterCustomCategory();
                }
            },
            'standardmastercustomcategoryform[itemId=standardMasterCustomCategoryForm] button[itemId=cancelButtonId]': {
                click: function() {
                    this.closeCommonFormWindow();
                }
            },

            /**
             * Custom Category add/edit/view/delete
             */
            'customcategorygrid[itemId=customCategoryGrid]': {
        		render: function(grid){
    				this.doAccessControlValidation(grid, this.getCUSTOM_CATEGORIES_PERMISSIONS());
    			},
        	},
            'customcategorygrid[itemId=customCategoryGrid] combo[itemId=customTableConfigField]': {
                select: function(combo, records, eOpts) {
                	var grid = this.getCustomCategoryGrid();
                	var customTableConfigValue = combo.getValue();
                	this.loadCustomCategoryGridStore(grid, customTableConfigValue, 'CUSTOM_CATEGORY', false);
                	this.getCustomCategoryValuesGrid().setDisabled(true);
                }
            },
            'customcategorygrid[itemId=customCategoryGrid] button[itemId=btnAdd]': {
                click: function() {
                	this.showCommonFormWindow('CUSTOM_CATEGORY');
                }
            },
            'customcategorygrid[itemId=customCategoryGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editCustomCategory('CUSTOM_CATEGORY', false);
                }
            },
            'customcategorygrid[itemId=customCategoryGrid] button[itemId=btnView]': {
                click: function() {
                    this.editCustomCategory('CUSTOM_CATEGORY', true);
                }
            },
            'customcategorygrid[itemId=customCategoryGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteCustomCategory();
                }
            },
            'customcategorygrid[itemId=customCategoryGrid]': {
                select: function(grid, record, index, eOpts) {
                	if(!isEmpty(record)){
                		var customCategoryValuesGrid = this.getCustomCategoryValuesGrid();
                		var customTableConfig = record.get('id');
                    	this.loadCustomCategoryValuesGridStore(customCategoryValuesGrid, customTableConfig);
                    	customCategoryValuesGrid.setDisabled(false);
                	}
                }
            },
            'customcategoryform[itemId=customCategoryForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveCustomCategory();
                }
            },
            /*'customcategoryform[itemId=customCategoryForm]': {
                render: function(form) {
                	this.loadTableConfigFieldDropDown(form, null, 'CUSTOM_CATEGORY');
                }
            },*/
            'customcategoryform[itemId=customCategoryForm] nestedJsonCombo[itemId=customTableConfigField]': {
                select: function(combo, records, eOpts) {
                	var form = this.getCustomCategoryForm();
                	var customTableConfigValue = combo.getValue(); 
                	this.loadColumnNameDropDown(form, customTableConfigValue, 'CUSTOM_CATEGORY');
                }
            },
            'customcategoryform[itemId=customCategoryForm] button[itemId=cancelButtonId]': {
                click: function() {
                    this.closeCommonFormWindow();
                }
            },
            /**
             * Custom Category values add/edit/view/delete
             */
            'customcategoryvaluesgrid[itemId=customCategoryValuesGrid]': {
                render: function(grid) {
                	grid.setDisabled(true);
                }
            },
            'customcategoryvaluesgrid[itemId=customCategoryValuesGrid] button[itemId=btnAdd]': {
                click: function() {
                    this.showCommonFormWindow('CUSTOM_CATEGORY_VALUE');
                }
            },
            'customcategoryvaluesgrid[itemId=customCategoryValuesGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editCustomCategoryValue('CUSTOM_CATEGORY_VALUE', false);
                }
            },
            'customcategoryvaluesgrid[itemId=customCategoryValuesGrid] button[itemId=btnView]': {
                click: function() {
                    this.editCustomCategoryValue('CUSTOM_CATEGORY_VALUE', true);
                }
            },
            'customcategoryvaluesgrid[itemId=customCategoryValuesGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteCustomCategoryValue();
                }
            },
            'customcategoryvaluesform[itemId=customCategoryValuesForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveCustomCategoryValue();
                }
            },
            'customcategoryvaluesform[itemId=customCategoryValuesForm] button[itemId=cancelButtonId]': {
                click: function() {
                    this.closeCommonFormWindow();
                }
            }
        });
    },
    /**
     * Load custom category grid store
     */
    loadCustomCategoryGridStore: function(grid, customTableConfigValue, customType, whetherStandardMaster){
    	if(grid){
    		var store = grid.getStore();
    		store.getProxy().extraParams = {
    			customType: customType,
    			customTableConfigId: customTableConfigValue,
    			whetherStandardMaster: whetherStandardMaster
    		}; 
    		store.load();
    	}
    },
    /**
     * show common form window
     * @param formType
     */
    showCommonFormWindow: function(formType) {
        var this$ = this;
        var title = null,
            xtypeForm = null;
        itemId = null;
        var formWindow = this$.getPersonCommonWindow();
        if (!formWindow) {
            switch (formType) {

            case 'STANDARD_MASTER_CUSTOM_CATEGORY':
                {
                    title = getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY');
                    xtypeForm = 'standardmastercustomcategoryform';
                    itemId = 'standardMasterCustomCategoryForm';
                    break;
                }
            case 'CUSTOM_CATEGORY':
                {
                    title = getCommonTranslation('CUSTOM_CATEGORIES');
                    xtypeForm = 'customcategoryform';
                    itemId = 'customCategoryForm';
                    break;
                }
            case 'CUSTOM_CATEGORY_VALUE':
                {
                    title = getCommonTranslation('CUSTOM_CATEGORY_VALUES');
                    xtypeForm = 'customcategoryvaluesform';
                    itemId = 'customCategoryValuesForm';
                    break;
                }
            default:
                {
                    break;
                }
            }

            formWindow = Ext.widget('personcommonwindow', {
                title: title,
                itemId: 'personCommonWindow',
                items: [{
                    xtype: xtypeForm,
                    itemId: itemId
                }]
            });
        }

        formWindow.show();
    },
    /**
     * load enity name store
     * @param form custom category form
     * @param entityValue
     */
    loadTableConfigFieldDropDown: function(form, entityValue, customType){
    	var this$ = this;
    	if(form){
    		var customTableConfigField = form.down('#customTableConfigField');
        	var store = customTableConfigField.getStore();
        	if(!isNullOrEmpty(entityValue)){
				  this$.loadColumnNameDropDown(form, entityValue, customType);
			}
    	}
    	
    },
    /**
     * load column name store
     * @param form custom category form
     * @param customTableConfigId
     */
    loadColumnNameDropDown: function(form, customTableConfigId, customType, columnMappingId){
    	if(form){
    		if(!isNullOrEmpty(customTableConfigId) && !isNullOrEmpty(customType)){
    			var columnNameField = form.down('#columnNameField');
    			columnNameField.setDisabled(false);
            	var store = columnNameField.getStore();
            	store.getProxy().extraParams = {
        			customType: customType,
        			customFieldDataType: 'COMBOBOX',
        			columnMappingId: columnMappingId,
            		customTableConfigId: customTableConfigId
        		};
    		}
        }
    	
    },
    /**
     * view common form window
     */
    viewCommonFormWindow: function(form) {

        if (form) {
            form.down('#submitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    /**
     * Close common form window
     */
    closeCommonFormWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },

    /*
     * This function is used for to edit standard master custom category details   
     */
    editStandardMasterCustomCategory: function(formType, isView) {
        var this$ = this;
        var grid = this$.getCustomCategoryStandardMasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this$.showCommonFormWindow(formType);
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
            	var form = this$.getStandardMasterCustomCategoryForm();
            	this$.loadColumnNameDropDown(form, record.get('customTableConfigId'), 'CUSTOM_CATEGORY', record.get('columnMappingId'));
            	form.down('#customTableConfigField').getStore().load({
                    callback: function(records, operation, success) {
                    	form.down('#customTableConfigField').setValue(record.data.customTableConfigId);
                    }
                });
                form.down('#customTableConfigField').setReadOnly(true);
                form.down('#columnNameField').setReadOnly(true);
                form.loadRecord(record);
                if (isView) {
                    this$.viewCommonFormWindow(form);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },


    /*
     * This function is used for to delete standard master custom category after clicking on delete button   
     */
    deleteStandardMasterCustomCategory: function() {
    	var this$ = this;
        var grid = this$.getCustomCategoryStandardMasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'), getCommonTranslation('DELETE_CUSTOM_FIELD_CATEGORY'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection();
                    for (var count = 0; count < records.length; count++) {
                        var id = "";
                        if (!isNullOrEmpty(records[count].get("id"))) {
                            id = records[count].get("id");
                        }
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.CUSTOM_CATEGORY_DELETE,
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params: {
                                id: id,
                                whetherConfiremd:false
                            },
                            success: function(form, action) {
                                grid.getStore().reload();
                                if (form.responseText == 'DEPENDENT_RECORD_EXISTS') {
                                	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENT_RECORD_EXISTS'));
								}else{
									showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY_DELETE_SUCCESS'));	
								}
                            },
                            failure:function(response){
                            	if(response.status!=401) {
                            	console.log(response.responseText);
                            	showConfirmMessage("Field In Use", generateErrorMessage(response)+getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                                     if (btn == 'yes') {
                                    	 
                                    	 
                                    	 Ext.Ajax.request({
                                             type: 'rest',
                                             url: SERVERURL.CUSTOM_CATEGORY_DELETE,
                                             method: 'DELETE',
                                             headers: {
                                                 'Content-Type': 'application/json'
                                             },
                                             params: {
                                                 id: id,
                                                 whetherConfiremd:true
                                             },
                                             success: function(form, action) {
                                                 grid.getStore().reload();
                                                 showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_CUSTOM_FIELD_MSG'));
                                             }
                                    	 });
                                    	 
                                    	 
                                    	 
                                     }
                            	 });
                            	}
                                     
                            }
                        });
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * save the value for standard master custom category values
     */
    saveStandardMasterCustomCategory: function() {

        var this$ = this;
        var form = this$.getStandardMasterCustomCategoryForm();
        var grid = this$.getCustomCategoryStandardMasterGrid();

        var submitUrl,  methodType, isUpdate = false;
        var id = form.down('#id_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_SAVE;
            methodType = 'POST';
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_SAVE;
            methodType = 'PUT';
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonStandardMasterCustomcastegory(form);
        this$.applyWindowMask(); 
        this.sendSaveAjaxRequest(submitUrl, methodType, jsonFormatFormData, function(option, success, response) {
        	
            if (success) {
            	var result = response.responseText;
                this$.closeCommonFormWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if(result == "0"){
                	showErrorMessage(getCommonTranslation('CUSTOM_CATEGORIES'),getCommonTranslation('DUPLICATE_CUSTOM_CAT_MSG'));
                }
                else{
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'), getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY_ADD_SUCCESS'));
                } else {
                    showSuccessMessage(getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'), getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY_UPDATE_SUCCESS'));
                }
                }
            } else {
                this$.closePersonCommonWindow();
                grid.getStore().reload();
            }
            this$.hideWindowMask();
        });
    },

    getJsonStandardMasterCustomcastegory: function(form){
    	var this$ = this;
        var jsonFormFieldData = new Object();
    	var formData = form.getValues();
    	if(!isNullOrEmpty(form.down('#customTableConfigField').valueModels[0].raw.viewCode)) {
        	formData.customTableConfig.viewCode = form.down('#customTableConfigField').valueModels[0].raw.viewCode;
    	}
    	jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },

    /**
     * This function is used for to edit custom category details   
     */
    editCustomCategory: function(formType, isView) {
        var this$ = this;
        var grid = this$.getCustomCategoryGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this$.showCommonFormWindow(formType);
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
                var form = this$.getCustomCategoryForm();
                this$.loadColumnNameDropDown(form, record.get('customTableConfigId'), 'CUSTOM_CATEGORY', record.get('columnMappingId'));
                form.down('#customTableConfigField').setReadOnly(true);
                form.down('#columnNameField').setReadOnly(true);
                form.loadRecord(record);
                if (isView) {
                    this$.viewCommonFormWindow(form);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('CUSTOM_CATEGORIES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },


    /**
     * This function is used for to delete custom category after clicking on delete button   
     */
    deleteCustomCategory: function() {
    	var this$ = this;
        var grid = this$.getCustomCategoryGrid();
        var customCategoryValuesGrid = this$.getCustomCategoryValuesGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('CUSTOM_CATEGORIES'), getCommonTranslation('DELETE_CUSTOM_FIELD_CATEGORY'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection();
                    for (var count = 0; count < records.length; count++) {
                        var id = "";
                        if (!isNullOrEmpty(records[count].get("id"))) {
                            id = records[count].get("id");
                        }
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.CUSTOM_CATEGORY_DELETE,
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params: {
                                id: id,
                                whetherConfiremd:false
                            },
                            success: function(form, action) {
                                grid.getStore().reload();
                                if (form.responseText == 'DEPENDENT_RECORD_EXISTS') {
                                	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENT_RECORD_EXISTS'));
								}else{
                                	this$.loadCustomCategoryValuesGridStore(customCategoryValuesGrid, null);
                                	customCategoryValuesGrid.setDisabled(true);
                                	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('CUSTOM_CATEGORY_DELETE_SUCCESS'));
								}
                            },
                            failure:function(response){
                            	if(response.status!=401) {
                            	console.log(response.responseText);
                            	showConfirmMessage("Field In Use", generateErrorMessage(response)+getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                                     if (btn == 'yes') {
                                    	 
                                    	 
                                    	 Ext.Ajax.request({
                                             type: 'rest',
                                             url: SERVERURL.CUSTOM_CATEGORY_DELETE,
                                             method: 'DELETE',
                                             headers: {
                                                 'Content-Type': 'application/json'
                                             },
                                             params: {
                                                 id: id,
                                                 whetherConfiremd:true
                                             },
                                             success: function(form, action) {
                                                 grid.getStore().reload();
                                                 showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_CUSTOM_FIELD_MSG'));
                                             }
                                    	 });
                                     }
                            	 });
                            	} 
                            }
                        });
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('CUSTOM_CATEGORIES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * save the json for custom category
     */
    saveCustomCategory: function() {

        var this$ = this;
        var form = this$.getCustomCategoryForm();
        /* Disable button to overcome duplicate submit */
        form.down('#submitButtonId').setDisabled(true);
        var grid = this$.getCustomCategoryGrid();
        var customCategoryValuesGrid = this$.getCustomCategoryValuesGrid();
        var submitUrl, methodType, isUpdate = false;
        var id = form.down('#id_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_SAVE;
            methodType = 'POST';
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_SAVE;
            methodType = 'PUT';
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonCustomCastegory(form);
        this$.applyWindowMask(); 
        this.sendSaveAjaxRequest(submitUrl, methodType, jsonFormatFormData, function(option, success, response) {
        	this$.hideWindowMask();
            if (success) {
            	var result = response.responseText;
                this$.closeCommonFormWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if(result == "0"){
                	showErrorMessage(getCommonTranslation('CUSTOM_CATEGORIES'),getCommonTranslation('DUPLICATE_CUSTOM_CAT_MSG'));
                }
                else{
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('CUSTOM_CATEGORIES'), getCommonTranslation('CUSTOM_CATEGORY_ADD_SUCCESS'));
                } else {
                    showSuccessMessage(getCommonTranslation('CUSTOM_CATEGORIES'), getCommonTranslation('CUSTOM_CATEGORY_UPDATE_SUCCESS'));
                }
                }
                this$.loadCustomCategoryValuesGridStore(customCategoryValuesGrid, null);
                customCategoryValuesGrid.setDisabled(true);
            } else {
                this$.closePersonCommonWindow();
                grid.getStore().reload();
            }
        });
    },
    getJsonCustomCastegory: function(form){
    	var this$ = this;
        var jsonFormFieldData = new Object();
    	var formData = form.getValues();
    	if(!isNullOrEmpty(form.down('#customTableConfigField').valueModels[0].raw.viewCode)) {
        	formData.customTableConfig.viewCode = form.down('#customTableConfigField').valueModels[0].raw.viewCode;
    	}
    	jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    loadCustomCategoryValuesGridStore: function(customCategoryValuesGrid, customTableConfigId){
    	var this$ = this;
    	var store = customCategoryValuesGrid.getStore();
    	store.getProxy().extraParams = {
    		customType: 'CUSTOM_CATEGORY',
    		customTableConfigId: customTableConfigId,
    		whetherStandardMaster: false
    	};
    	store.load();
    },
    /**
     * This function is used for to edit custom category values details   
     */
    editCustomCategoryValue: function(formType, isView) {
        var this$ = this;
        var grid = this$.getCustomCategoryValuesGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this$.showCommonFormWindow(formType);
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
                var form = this$.getCustomCategoryValuesForm();
                form.loadRecord(record);
                if (isView) {
                    this$.viewCommonFormWindow(form);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },


    /**
     * This function is used for to delete custom category values after clicking on delete button   
     */
    deleteCustomCategoryValue: function() {
    	var this$ = this;
        var grid = this$.getCustomCategoryValuesGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('DELETE_CUSTOM_FIELD_CATEGORY'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection();
                    for (var count = 0; count < records.length; count++) {
                        var id = "";
                        if (!isNullOrEmpty(records[count].get("id"))) {
                            id = records[count].get("id");
                        }
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.CUSTOM_CATEGORY_VALUE_DELETE,
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params: {
                                id: id
                            },
                            success: function(form, action) {
                                grid.getStore().reload();
                                showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('CUSTOM_CATEGORY_VALUE_DELETE_SUCCESS'));
                            }
                        });
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * save the json for custom category values
     */
    saveCustomCategoryValue: function() {

        var this$ = this;
        var form = this$.getCustomCategoryValuesForm();
        var grid = this$.getCustomCategoryValuesGrid();
        
        var submitUrl, methodType, isUpdate = false;
        var id = form.down('#id_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_VALUE_SAVE;
            isUpdate = false;
            methodType = 'POST';
        } else {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_VALUE_UPDATE;
            isUpdate = true;
            methodType = 'PUT';
        }
        var customCategoryGrid = this.getCustomCategoryGrid();
    	var record = customCategoryGrid.getSelectionModel().getSelection()[0];
    	if(!isEmpty(record)){
    		
    		var store = grid.getStore();
    		var dispalyOrderFldVal = form.down('#dispalyOrderField').getValue();
    		var rec = store.findRecord('displayOrder',dispalyOrderFldVal,null,false,false,true);
    		if(!isNullOrEmpty(rec)){
    			if (!isNullOrEmpty(id.getSubmitValue())) {
    				var recId =  rec.get('id');
    				if(id.getSubmitValue() != recId){
    					showWarningMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('DISPLAY_ORDER_NOT_SAME_MSG'));
    	    			return false;
    				}
    			}
    			else{
    				showWarningMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('DISPLAY_ORDER_NOT_SAME_MSG'));
	    			return false;
    			}
    		}
    		
    		var customFieldConfig = {
        			id: record.get('id')	
        	};
            var jsonFormatFormData = this$.getJsonCustomCategoryValues(form, customFieldConfig);

            this.sendSaveAjaxRequest(submitUrl, methodType, jsonFormatFormData, function(option, success, response) {
                if (success) {
                    this$.closeCommonFormWindow();
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll();
                    if (isUpdate) {
                        showSuccessMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('CUSTOM_CATEGORY_VALUE_UPDATE_SUCCESS'));
                    } else {
                        showSuccessMessage(getCommonTranslation('CUSTOM_CATEGORY_VALUES'), getCommonTranslation('CUSTOM_CATEGORY_VALUE_ADD_SUCCESS'));
                    }
                } else {
                	this$.closeCommonFormWindow();
                    grid.getStore().reload();
                }
            });
    	}
    	
    },
    getJsonCustomCategoryValues: function(form, customFieldConfig){
    	var this$ = this;
        var jsonFormFieldData = new Object();
    	var formData = form.getValues();
    	formData.customFieldConfig = customFieldConfig;
    	jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },

});