/**
 * This controller is used for the Email Account Statement
 * 
 * 
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.controller.emailAccountStatement.EmailAccountStatementController', {
	extend: 'Academia.controller.base.BaseController',
	views: ['emailAccountStatement.EmailAccountStatementStructure','emailAccountStatement.EmailAccountStatementFilter','emailAccountStatement.EmailAccountStatementCriteriaGrid','emailAccountStatement.SponsorBulkSendingStatementAccountStructure','emailAccountStatement.SponsorAccountStatementAddCriteriaForm',
		'emailAccountStatement.SponserAccountStatementCriteriaGrid'],
	stores:['emailAccountStatement.EmailAccountAcademiaLocationStore','emailAccountStatement.EmailAccountProgramBatchSeatStore','program.ProgramGroupStoreForLocalSerach','emailAccountStatement.EmailAccountStudentStore','emailAccountStatement.EmailAccountPaymentPlanStore','emailAccountStatement.EmailAccountCriteriaGridStore',
		'emailAccountStatement.EmailAccountBatchStore','emailAccountStatement.EmailAccountPeriodStore','emailAccountStatement.EmailAccountSeatTypeStore','scholarships.ScholarshipAccountingYearStore','scholarships.allowSchoalrshipIDNameStore',
		'emailAccountStatement.SponserAccountCriteriaGridStore','emailAccountStatement.SponserScholarshipStatusStore','emailAccountStatement.SponsorScholarshipIdsStore',
		'emailAccountStatement.EmailToUserNameStore'],
		refs: [{
			ref:'emailAccountStatementFilter',
			selector:'emailAccountStatementFilter'
		},{
			ref:'emailAccountStatementCriteriaGrid',
			selector:'emailAccountStatementCriteriaGrid'
		},{
			ref:'sponsorBulkSendingStatementAccountStructure',
			selector:'sponsorBulkSendingStatementAccountStructure'
		},{
			ref:'sponsorAccountStatementAddCriteriaForm',
			selector:'sponsorAccountStatementAddCriteriaForm'
		},{
			ref:'emailAccountStatementStructure',
			selector:'emailAccountStatementStructure'
		},{
			ref:'sponserAccountStatementCriteriaGrid',
			selector:'sponserAccountStatementCriteriaGrid'
		}],  
		config: {
			TNS_EMAIL_ACCOUNT_STATEMENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_EMAIL_ACCOUNT_STATEMENT'),
			TNS_SPONSER_ACCOUNT_STATEMENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_SPONSER_ACCOUNT_STATEMENT')
		},

		init: function(application) {
			this.control({
				'emailAccountStatementFilter':{
					render: function() {
	                	var me=this;
	                	var grid =this.getEmailAccountStatementCriteriaGrid();
	                	var associatedAcadLocationIds = new Array();
	            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getTNS_EMAIL_ACCOUNT_STATEMENT());
	            		grid.down('#bulkEmailBtn').setVisible(false);
	            		grid.down('#btnDelete').setVisible(false);
	            		Ext.each(permissionList, function(privilege) {
	            			if (privilege === "BULK_EMAIL") {
	            				grid.down('#bulkEmailBtn').setVisible(true);
	            			}
	            			if (privilege === "DELETE") {
	            				grid.down('#btnDelete').setVisible(true);
	            			}
	            		});
	                },
					afterrender:function(form){
						var me = this,
						academiaLocation = form.down('#academyLocationItemId'),
						currentAcademia=this.getCurrentAcademyLocation(),
						grid = me .getEmailAccountStatementCriteriaGrid(),
						programNameOrCode=form.down('#programNameOrCode'),
						studentId=form.down('#studentId'),
						statementFrom=form.down('#statementFrom'),
						statementTill=form.down('#statementTill'),
						status=form.down('#status'),
						paymentPlanEnrolled=form.down('#paymentPlanEnrolled'); 
						academiaLocation.getStore().load(function(records){
							records.forEach(function(rec){
								if(rec.data.id === currentAcademia){
									academiaLocation.setValue(currentAcademia);
									programNameOrCode.setDisabled(false);
									paymentPlanEnrolled.setDisabled(false);
									studentId.setDisabled(false);
									status.setDisabled(false);
									programNameOrCode.getStore().getProxy().extraParams = {
										academyLocationIds:currentAcademia
									}
									me.setParamToFetchDropDownData();
									paymentPlanEnrolled.setDisabled(false);
									paymentPlanEnrolled.getStore().getProxy().extraParams = {
										academyLocationIds:currentAcademia
									}
								}

							})

						});
						statementFrom.setValue(new Date(new Date().getFullYear(), 0, 1))
						statementTill.setValue(new Date());
						grid.getStore().load();
						status.setVisible(false);
					}
				},
				'emailAccountStatementFilter multiselectcombofield[itemId=academyLocationItemId]':{
					change:function(cmp){
						var me = this,
						form = me.getEmailAccountStatementFilter(),
						val =cmp.getValue(),
						programNameOrCode=form.down('#programNameOrCode'),
						batchId=form.down('#batchId'),
						studentId=form.down('#studentId'),
						status=form.down('#status'),
						paymentPlanEnrolled=form.down('#paymentPlanEnrolled'),
						seatTypeId=form.down('#seatTypeId'); 
						paymentPlanEnrolled.setDisabled(false);
						paymentPlanEnrolled.reset();
						programNameOrCode.reset();
						programNameOrCode.setDisabled(false);
						paymentPlanEnrolled.reset();
						studentId.setDisabled(false);
						studentId.reset();
						batchId.reset();
						batchId.setDisabled(true);
						seatTypeId.reset();
						seatTypeId.setDisabled(true);
						status.setDisabled(false);
						if(val.length > 0){
							try{
								var academyLocationId = Ext.Array.pluck(Ext.Array.pluck(val, 'data'), 'id').join();
							} catch(e) {
								var academyLocationId = val.join();
							}
						}
						if(academyLocationId){
							programNameOrCode.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId
							}
							paymentPlanEnrolled.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId
							}
							paymentPlanEnrolled.getStore().load();
							programNameOrCode.getStore().load();
							me.setParamToFetchDropDownData();
						}else{
							status.setDisabled(true);
							studentId.setDisabled(true);
							programNameOrCode.setDisabled(true);
							paymentPlanEnrolled.setDisabled(true);
						}
						

					}

				},
				'emailAccountStatementFilter multiselectcombofield[itemId=programGroupId]':{
					change:function(cmp){
						var me = this;
						Ext.defer(function(){
						
						var val =cmp.getValue(),
						form = me.getEmailAccountStatementFilter(),
						academiaLocation = form.down('#academyLocationItemId'),
						programNameOrCode=form.down('#programNameOrCode'),
						batchId=form.down('#batchId'),
						periodId=form.down('#periodId'),

						academiaLoc = academiaLocation.getValue(),
						seatTypeId=form.down('#seatTypeId'); 
						programNameOrCode.reset();
						batchId.reset();
						batchId.setDisabled(true);
						periodId.reset();
						periodId.setDisabled(true);
						seatTypeId.reset();
						seatTypeId.setDisabled(true);
						if(val && val.length > 0){
							try{
								var programGroup = Ext.Array.pluck(Ext.Array.pluck(val, 'data'), 'id').join();
							} catch(e) {
								var programGroup = val.join();
							}
						}
						if(academiaLoc && academiaLoc.length > 0){
							try{
								var academyLocationId = Ext.Array.pluck(Ext.Array.pluck(academiaLoc, 'data'), 'id').join();
							} catch(e) {
								var academyLocationId = academiaLoc.join();
							}
						}else{
							var academyLocationId = academiaLoc;
						}
						if(academyLocationId){
							programNameOrCode.setDisabled(false);
							programNameOrCode.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								programGroupId:programGroup
							}

							programNameOrCode.getStore().load();
						}
						
						},200);
					}
					

				},
				'emailAccountStatementFilter multiselectcombofield[itemId=programNameOrCode]':{
					change:function(cmp){
						var me = this;
						Ext.defer(function(){
						
						var val =cmp.getValue(),
						form = me.getEmailAccountStatementFilter(),
						academiaLocation = form.down('#academyLocationItemId'),
						programGroupId = form.down('#programGroupId'),
						programNameOrCode=form.down('#programNameOrCode'),
						batchId=form.down('#batchId'),
						periodId=form.down('#periodId'),
						studentId=form.down('#studentId'),
						paymentPlanEnrolled=form.down('#paymentPlanEnrolled'),
						academiaLoc = academiaLocation.getValue(),
						programGroupVal = programGroupId.getValue(),
						seatTypeId=form.down('#seatTypeId'); 
						paymentPlanEnrolled.reset();
						studentId.reset();
						batchId.reset();
						batchId.setDisabled(false);
						periodId.reset();
						periodId.setDisabled(true);
						seatTypeId.reset();
						seatTypeId.setDisabled(true);
						if(val && val.length > 0){
							try{
								var programValId = Ext.Array.pluck(Ext.Array.pluck(val, 'data'), 'programId').join();
							} catch(e) {
								var programValId = val.join();
							}
						}
						if(academiaLoc && academiaLoc.length > 0){
							try{
								var academyLocationId = Ext.Array.pluck(Ext.Array.pluck(academiaLoc, 'data'), 'id').join();
							} catch(e) {
								var academyLocationId = academiaLoc.join();
							}
						}else{
							var academyLocationId = academiaLoc
						}
						if(programGroupVal && programGroupVal.length > 0){
							try{
								var programGroupValId = Ext.Array.pluck(Ext.Array.pluck(programGroupVal, 'data'), 'id').join();
							} catch(e) {
								var programGroupValId = programGroupVal.join();
							}
						}
						if(academyLocationId){
							batchId.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								programGroupId:programGroupValId,
								programId:programValId
							}
							paymentPlanEnrolled.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								programId:programValId
							}
							
							me.setParamToFetchDropDownData();
							
						}
						if(!programValId){
							batchId.setDisabled(true);
							periodId.setDisabled(true);
							seatTypeId.setDisabled(true);
						}else{
							batchId.getStore().load();
							paymentPlanEnrolled.getStore().load();
						}
						},200)

					}
				},
				'emailAccountStatementFilter multiselectcombofield[itemId=batchId]':{
					change:function(cmp){
						var me = this;
						Ext.defer(function(){
						
						var val =cmp.getValue(),
						form = me.getEmailAccountStatementFilter(),
						academiaLocation = form.down('#academyLocationItemId'),
						programGroupId = form.down('#programGroupId'),
						programNameOrCode=form.down('#programNameOrCode'),
						batchId=form.down('#batchId'),
						periodId=form.down('#periodId'),
						studentId=form.down('#studentId'),
						academiaLoc = academiaLocation.getValue(),
						programGroupVal = programGroupId.getValue(),
						programVal=programNameOrCode.getValue(),
						seatTypeId=form.down('#seatTypeId'); 
						studentId.reset();
						periodId.reset();
						periodId.setDisabled(false);
						seatTypeId.reset();
						seatTypeId.setDisabled(true);
						if(val && val.length > 0){
							try{
								var batchValId = Ext.Array.pluck(Ext.Array.pluck(val, 'data'), 'batchId').join();
							} catch(e) {
								var batchValId = val.join();
							}
						}
						if(academiaLoc && academiaLoc.length > 0){
							try{
								var academyLocationId = Ext.Array.pluck(Ext.Array.pluck(academiaLoc, 'data'), 'id').join();
							} catch(e) {
								var academyLocationId = academiaLoc.join();
							}
						}else{
							var academyLocationId = academiaLoc;
						}
						if(programGroupVal && programGroupVal.length > 0){
							try{
								var programGroupValId = Ext.Array.pluck(Ext.Array.pluck(programGroupVal, 'data'), 'id').join();
							} catch(e) {
								var programGroupValId = programGroupVal.join();
							}
						}
						if(programVal && programVal.length > 0){
							try{
								var programValId = Ext.Array.pluck(Ext.Array.pluck(programVal, 'data'), 'programId').join();
							} catch(e) {
								var programValId = programVal.join();
							}
						}
						if(academyLocationId){
							periodId.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								programGroupId:programGroupValId,
								programId:programValId,
								batchId:batchValId
							}
							me.setParamToFetchDropDownData();
							
						}
						if(!batchValId){
							periodId.setDisabled(true);
							seatTypeId.setDisabled(true);
						}else{
							periodId.getStore().load();
						}
						
						},200);
					}
				},
				'emailAccountStatementFilter multiselectcombofield[itemId=periodId]':{
					change:function(cmp){
						var me = this;
						Ext.defer(function(){
						
						var val =cmp.getValue(),
						form = me.getEmailAccountStatementFilter(),
						academiaLocation = form.down('#academyLocationItemId'),
						programGroupId = form.down('#programGroupId'),
						programNameOrCode=form.down('#programNameOrCode'),
						batchId=form.down('#batchId'),
						periodId=form.down('#periodId'),
						academiaLoc = academiaLocation.getValue(),
						programGroupVal = programGroupId.getValue(),
						programVal=programNameOrCode.getValue(),
						batchVal=batchId.getValue(),
						seatTypeId=form.down('#seatTypeId'); 
						seatTypeId.reset();
						seatTypeId.setDisabled(false);
						if(val && val.length > 0){
							try{
								var periodIdVal = Ext.Array.pluck(Ext.Array.pluck(val, 'data'), 'periodId').join();
							} catch(e) {
								var periodIdVal = val.join();
							}
						}
						if(academiaLoc && academiaLoc.length > 0){
							try{
								var academyLocationId = Ext.Array.pluck(Ext.Array.pluck(academiaLoc, 'data'), 'id').join();
							} catch(e) {
								var academyLocationId = academiaLoc.join();
							}
						}else{
							var academyLocationId = academiaLoc
						}
						if(programGroupVal && programGroupVal.length > 0){
							try{
								var programGroupValId = Ext.Array.pluck(Ext.Array.pluck(programGroupVal, 'data'), 'id').join();
							} catch(e) {
								var programGroupValId = programGroupVal.join();
							}
						}
						if(programVal && programVal.length > 0){
							try{
								var programValId = Ext.Array.pluck(Ext.Array.pluck(programVal, 'data'), 'programId').join();
							} catch(e) {
								var programValId = programVal.join();
							}
						}
						if(batchVal && batchVal.length > 0){
							try{
								var batchValId = Ext.Array.pluck(Ext.Array.pluck(batchVal, 'data'), 'batchId').join();
							} catch(e) {
								var batchValId = batchVal.join();
							}
						}
						if(academyLocationId){
							seatTypeId.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocationId,
								programGroupId:programGroupValId,
								programId:programValId,
								batchId:batchValId,
								periodId:periodIdVal
							}
							
							me.setParamToFetchDropDownData();
						}
						if(!periodIdVal){
							seatTypeId.setDisabled(true);
						}else{
							seatTypeId.getStore().load();
						}
						
						},200)
					}
				},
				'emailAccountStatementFilter multiselectcombofield[itemId=seatTypeId]':{
					change:function(cmp){
						this.setParamToFetchDropDownData();

					}
				},
				'emailAccountStatementFilter button[itemId=resetBtnItemId]':{
					click:function(btn){
						btn.setDisabled(true);
						var me = this,
						currentAcademia=this.getCurrentAcademyLocation(),
						form = me.getEmailAccountStatementFilter(),
						academiaLocation = form.down('#academyLocationItemId'),
						studentId=form.down('#studentId'),
						statementFrom=form.down('#statementFrom'),
						statementTill=form.down('#statementTill'),
						programNameOrCode=form.down('#programNameOrCode'),
						batchId=form.down('#batchId'),
						periodId=form.down('#periodId'),
						seatTypeId=form.down('#seatTypeId'),
						status=form.down('#status'),
						paymentPlanEnrolled=form.down('#paymentPlanEnrolled'); 
						form.getForm().reset();
						programNameOrCode.setDisabled(true);
						batchId.setDisabled(true);
						periodId.setDisabled(true);
						seatTypeId.setDisabled(true);
						studentId.setDisabled(true);
						status.setDisabled(true);
						paymentPlanEnrolled.setDisabled(true);
						
						academiaLocation.getStore().load(function(records){
							records.forEach(function(rec){
								if(rec.data.id === currentAcademia){
									academiaLocation.setValue(currentAcademia);
									programNameOrCode.setDisabled(false);
									programNameOrCode.getStore().getProxy().extraParams = {
										academyLocationIds:currentAcademia
									}
									studentId.getStore().getProxy().extraParams = {
										academyLocationIds:currentAcademia
									}
									paymentPlanEnrolled.setDisabled(false);
									paymentPlanEnrolled.getStore().getProxy().extraParams = {
										academyLocationIds:currentAcademia
									}
								}

							})

						});
						statementFrom.setValue(new Date(new Date().getFullYear(), 0, 1))
						statementTill.setValue(new Date());
					}
				},
				'emailAccountStatementFilter button[itemId=addCriteriaBtn]':{
					click:this.saveAddCriteria
				},
				'emailAccountStatementFilter customcombobox[itemId=status]':{
					select:function(cmp){
							this.setParamToFetchDropDownData(cmp);
					}
				},
					'emailAccountStatementCriteriaGrid':{
						selectionchange: function(column, selected,eOpts ){
		                    var grid = column.view.up('grid'),
		                    bulkBtn = grid.down('#bulkEmailBtn');
		                    btnDelete = grid.down('#btnDelete');
		                    if(selected.length && selected[0].data.status == "PENDING" && selected[0].data.totalResult > 0){
		                    	bulkBtn.setDisabled(false);
		                    }else{
		                    	bulkBtn.setDisabled(true);
		                    }
		                    if(selected.length && selected[0].data.status == "PENDING"){
							btnDelete.setDisabled(false);
						    }else{
							btnDelete.setDisabled(true);
						    }
		                    
		                },
		  	 		    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		  	 		    	try{
		  	 		        if (e.target && e.target.tagName == 'A') {
		  	 		        	var data = Ext.decode(record.data.criteriaJson)[0],fieldLabel;
		  	 		        	var formattedJSON = '';
		  	 		        	for (key in data) {
		  	 		        		switch(key) {
		  	 					  case 'academyLocation':
		  	 						fieldLabel =getCommonTranslation('ACADEMY_LOCATION');
		  	 						  break;
		  	 					  case 'programGroup': 
		  	 						fieldLabel =getFeeAndPaymentCommonTranslation('PROGRAM_GROUP');
		  	 						  break;
		  	 					 case 'programs': 
			  	 						fieldLabel =getCommonTranslation('PROGRAM_CODE_OR_NAME');
			  	 						  break;
		  	 					 case 'batches': 
			  	 						fieldLabel =getCommonTranslation('BATCH');
			  	 						  break;
		  	 					 case 'periods': 
			  	 						fieldLabel =getCommonTranslation('PERIOD');
			  	 						  break;
		  	 					 case 'seatTypes': 
			  	 						fieldLabel =getCommonTranslation('SEAT_TYPE');
			  	 						  break;
		  	 					 case 'studentIds': 
			  	 						fieldLabel =getCommonTranslation('STUDENT_CODE_NAME');
			  	 						  break;
		  	 					 case 'paymentPlanEnrolled': 
			  	 						fieldLabel =getCommonTranslation('PAYMENT_PLAN_ENROLLED');
			  	 						  break;
		  	 					 case 'criteriaStatus': 
			  	 						fieldLabel =getCommonTranslation('STATUS');
			  	 						  break;
		  	 					 case 'enrollmentStatus': 
			  	 						fieldLabel =getCommonTranslation('COURSE_ENROLLMENT_STATUS');
			  	 						  break;
		  	 					 case 'address': 
			  	 						fieldLabel =getCommonTranslation('ADDRESS');
			  	 						  break;
		  	 					 case 'typeOfBalance': 
			  	 						fieldLabel =getCommonTranslation('TYPE_OF_BALANCE');
			  	 						  break;
		  	 					 case 'minimumBalance': 
			  	 						fieldLabel =getFeeAndPaymentCommonTranslation('MINIMUM_AMOUNT');
			  	 						  break;
		  	 					 case 'maximumBalance': 
			  	 						fieldLabel =getFeeAndPaymentCommonTranslation('MAXIMUM_AMOUNT');
			  	 						  break;
		  	 					case 'statementFrom': 
		  	 						fieldLabel =getFeeAndPaymentCommonTranslation('STATEMENT_FROM');
		  	 						  break;
		  	 					case 'statementTo': 
		  	 						fieldLabel =getCommonTranslation('STATEMENT_TILL');
		  	 						  break;
		  	 					case 'withZeroOutstanding': 
		  	 						fieldLabel =getCommonTranslation('WITH_ZERO_OUTSTANDING');
		  	 						  break;	  
		  	 						 
		  	 					}
		  	 		        	    if (Ext.isArray(data[key])) {
		  	 		        	        var tmpArr = [];
		  	 		        	        for (var i = 0; i < data[key].length; i++) {
		  	 		        	            tmpArr.push(data[key][i].name);
		  	 		        	        }
		  	 		        	        if (tmpArr.length) {
		  	 		        	            formattedJSON += '<b style="font-size: 14px;">'+fieldLabel + ': </b><br/><span style="white-space: normal;display: inline-block;border-bottom: 1px solid #898989;padding-bottom: 6px;width: 100%;">  ' + tmpArr.join(', ') + '</span><br/><br/>';
		  	 		        	        }
		  	 		        	    } else {
		  	 		        	        if (!isNullOrEmpty(data[key])) {
		  	 		        	        var	keyVal = data[key];
		  	 		        	     	switch(keyVal) {
				  	 					  case 'DEFAULT':
				  	 						keyVal =getCommonTranslation('FEE_PAYER_ADRESS_DEFAULT_SELECTED');
				  	 						  break;
				  	 					  case 'CRNT': 
				  	 						keyVal =getCommonTranslation('STUDENT_CURRENT_ADRESS');
				  	 						  break;
				  	 					 case 'PRMNT': 
				  	 						keyVal =getCommonTranslation('STUDENT_PERMANENT_ADDRESS');
					  	 						  break;
				  	 					 case 'OFC': 
				  	 						keyVal =getCommonTranslation('STUDENT_OFFICE_ADDRESS');
					  	 						  break;
				  	 					 case 'CRSPDNC': 
				  	 						keyVal =getCommonTranslation('STDUENT_CORRESPONDENCE_ADDRESS');
					  	 						  break;
				  	 					}
		  	 		        	            formattedJSON += '<b style="font-size: 14px;">'+fieldLabel + ': </b><br/><span style="white-space: normal;display: inline-block;border-bottom: 1px solid #898989;padding-bottom: 6px;width: 100%;">    ' + getCommonTranslation(keyVal) + '</span><br/><br/>';
		  	 		        	        }
		  	 		        	    }
		  	 		        	}
		  	 		        	Ext.create('Ext.window.Window', {
		  	 		        	    title: getCommonTranslation('FILTER_CRITERIA'),
		  	 		        	    height: '50%',
		  	 		        	    maxWidth:'40%',
		  	 		        	    width:'40%',
		  	 		        	    autoScroll:true,
		  	 		        	    resizable:true,
		  	 		        	    modal: true,
		  	 		        	    items: {
		  	 		        	        xtype: 'container',
		  	 		        	        html: '<pre style=" width: 100%; ">' + formattedJSON + '</pre>'
		  	 		        	    }
		  	 		        	}).show();
		  	 		        }
		  	 		    	}catch(e){
		  	 		    		console.log('Error')
		  	 		    	}
		  	 		    }
				},
				
				'emailAccountStatementCriteriaGrid button[itemId=bulkEmailBtn]':{
					click:function(btn){
						
						var grid =this.getEmailAccountStatementCriteriaGrid(),
						selectedRec = grid.getSelectionModel().getSelection();
						if(selectedRec && selectedRec.length){
							showConfirmMessage(getCommonTranslation('BULK_EMAIL'), getCommonTranslation('EMAIL_ACCOUNT_STATEMENT_SELECTED_STUDENT'), function (cbtn, text) {
						        if (cbtn == 'yes') {
						        	btn.setDisabled(true)
						        	Ext.getBody().mask(getCommonTranslation('BULK_EMAIL'), 'x-mask-loading');
									Ext.defer(function(){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.PATH_SEND_BULK_EMAIL_SOA+ '?statementEmailTabFilterId=' + selectedRec[0].data.criteriaId,
											method: 'POST',
											 headers: {
						        				  'Content-Type': 'application/json'
						        			  },
											async: false,
											success: function(res, action) {
												Ext.getBody().unmask();
												if(!isNullOrEmpty(res.responseText) && res.responseText.indexOf('SOA_COUNT_UPDATED_ON_BULK_EMAIL') > -1) {
							        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SOA_COUNT_UPDATED_ON_BULK_EMAIL'));
												} else {
												showSuccessMessage(getCommonTranslation('BULK_EMAIL') ,getCommonTranslation('BULK_EMAIL_CRITERIA_ADDED_SUCCESSFULLY'));
												}
												grid.getStore().load();
												btn.setDisabled(false);
												
											},failure:function(){
												btn.setDisabled(false);
											}
										});
									},100);
						        }
						    });
							
						}
						
					}
				},
				'sponsorAccountStatementAddCriteriaForm button[itemId=sponserAddCriteriaBtn]':{
					click:this.saveSponsorAccountCriteria
				},
				'sponsorAccountStatementAddCriteriaForm button[itemId=sponserResetBtnItemId]':{
					click:function(){
						var form = this.getSponsorAccountStatementAddCriteriaForm();
						form.getForm().reset();
						form.down('#scholarshipStatus').reset();
						form.down('#scholarshipStatus').setDisabled(true);
						form.down('#scholarshipId').setDisabled(true);
						this.getSponsorAccountStatementAddCriteriaForm().down('#scholarshipStatus').setDisabled(true);
					}
				},
				'emailAccountStatementStructure':{
					afterrender:function(cmp){
						var me = this,
						isView= false,
						associatedAcadLocationIds = new Array();
						var grid =this.getEmailAccountStatementCriteriaGrid();
	            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getTNS_EMAIL_ACCOUNT_STATEMENT());
	            		grid.down('#bulkEmailBtn').setVisible(false);
	            		grid.down('#btnDelete').setVisible(false);
	            		Ext.each(permissionList, function(privilege) {
	            			if(privilege === 'VIEW'){
	            				isView=true
	            			}
	            			if (privilege === "DELETE") {
	            				grid.down('#btnDelete').setVisible(true);
	            			}
	            			if (privilege === "BULK_EMAIL") {
	            				grid.down('#bulkEmailBtn').setVisible(true);
	            			}
	            		});
	            		if(!isView){
	            			cmp.down('tabpanel').remove(cmp.down('tabpanel').items.items[1]);
	            		}
					}
				},
				'sponsorBulkSendingStatementAccountStructure':{
					afterrender:function(cmp){
						var me = this,
						grid = me.getSponserAccountStatementCriteriaGrid(),
						associatedAcadLocationIds = new Array();
						this.doAccessControlValidation(grid, me.getTNS_SPONSER_ACCOUNT_STATEMENT());
	            		associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,me.getTNS_SPONSER_ACCOUNT_STATEMENT());
	            		grid.down('#sponsorBulkEmailBtn').setVisible(false);
	            		grid.down('#btnDelete').setVisible(false);
	            		Ext.each(permissionList, function(privilege) {
	            			if (privilege === "BULK_EMAIL") {
	            				grid.down('#sponsorBulkEmailBtn').setVisible(true);
	            			}
	            			if (privilege === "DELETE") {
	            				grid.down('#btnDelete').setVisible(true);
	            			}
	            		});
	            		cmp.down('#scholarshipStatus').getStore().load();
	            		grid.getStore().load();
					}
				},
				'sponserAccountStatementCriteriaGrid':{
					selectionchange: function(column, selected,eOpts ){
						var grid = column.view.up('grid'),
						bulkBtn = grid.down('#sponsorBulkEmailBtn');
						btnDelete = grid.down('#btnDelete');
						if(selected.length && selected[0].data.status == "PENDING" && selected[0].data.totalResult > 0){
							bulkBtn.setDisabled(false);
						}else{
							bulkBtn.setDisabled(true);
						}
						if(selected.length && selected[0].data.status == "PENDING"){
							btnDelete.setDisabled(false);
						}else{
							btnDelete.setDisabled(true);
						}
					},
					cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
						try{
							if (e.target && e.target.tagName == 'A') {
								var data = Ext.decode(record.data.criteriaJson)[0],fieldLabel;
								var newData={
										accountingYearName:data.accountingYearName,
										scholarshipName:data.scholarshipName,
										scholarshipStatus:data.scholarshipStatus,
										language:data.language,
										withZeroOutstanding:data.withZeroOutstanding,
								};
								data = newData;
								var formattedJSON = '';
								for (key in data) {
									switch(key) {
									case 'accountingYearName':
										fieldLabel =getCommonTranslation('ACCOUNTING_YEAR');
										break;
									case 'scholarshipName': 
										fieldLabel =getCommonTranslation('SCHOLARSHIP_ID_NAME');
										break;
									case 'scholarshipStatus': 
										fieldLabel =getCommonTranslation('SCHOLARSHIP_STATUS');
										break;
									case 'language': 
										fieldLabel =getCommonTranslation('STATEMENT_LANGUAGE');
										break;
									case 'withZeroOutstanding': 
										fieldLabel =getCommonTranslation('WITH_ZERO_OUTSTANDING');
										break;  
									}
									if (Ext.isArray(data[key])) {
										var tmpArr = [];
										for (var i = 0; i < data[key].length; i++) {
											if(key == 'scholarshipStatus'){
												tmpArr.push(getCommonTranslation(data[key][i].name));
											}else{
												tmpArr.push(data[key][i].name);
											}

										}
										if (tmpArr.length) {
											formattedJSON += '<b style="font-size: 14px;">'+fieldLabel + ': </b><br/><span style="white-space: normal;display: inline-block;border-bottom: 1px solid #898989;padding-bottom: 6px;width: 100%;">  ' + tmpArr.join(', ') + '</span><br/><br/>';
										}
									} else {
										if (!isNullOrEmpty(data[key])) {
											var	keyVal = data[key];
											formattedJSON += '<b style="font-size: 14px;">'+fieldLabel + ': </b><br/><span style="white-space: normal;display: inline-block;border-bottom: 1px solid #898989;padding-bottom: 6px;width: 100%;">    ' + getCommonTranslation(keyVal) + '</span><br/><br/>';
										}
									}
								}
								Ext.create('Ext.window.Window', {
									title: getCommonTranslation('FILTER_CRITERIA'),
									height: '50%',
									maxWidth:'40%',
									width:'40%',
									autoScroll:true,
									resizable:true,
									modal: true,
									items: {
										xtype: 'container',
										html: '<pre style=" width: 100%; ">' + formattedJSON + '</pre>'
									}
								}).show();
							}
						}catch(e){
							console.log('Error')
						}
					}
			},
			
			'sponserAccountStatementCriteriaGrid button[itemId=sponsorBulkEmailBtn]':{
				click:function(btn){
					var grid =this.getSponserAccountStatementCriteriaGrid(),
					selectedRec = grid.getSelectionModel().getSelection();
					if(selectedRec && selectedRec.length){
						showConfirmMessage(getCommonTranslation('BULK_EMAIL'), getCommonTranslation('EMAIL_ACCOUNT_STATEMENT_SELECTED_STUDENT'), function (cbtn, text) {
					        if (cbtn == 'yes') {
					        	btn.setDisabled(true)
					        	Ext.getBody().mask(getCommonTranslation('BULK_EMAIL'), 'x-mask-loading');
								Ext.defer(function(){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_SEND_BULK_EMAIL_TO_SPONSOR+ '?statementEmailFilterId=' + selectedRec[0].data.criteriaId,
										method: 'POST',
										 headers: {
					        				  'Content-Type': 'application/json'
					        			  },
										async: false,
										success: function(res, action) {
											Ext.getBody().unmask();
											if(!isNullOrEmpty(res.responseText) && res.responseText.indexOf('SOA_COUNT_UPDATED_ON_BULK_EMAIL') > -1) {
						        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SOA_COUNT_UPDATED_ON_BULK_EMAIL'));
											} else {
											showSuccessMessage(getCommonTranslation('BULK_EMAIL') ,getCommonTranslation('BULK_EMAIL_CRITERIA_ADDED_SUCCESSFULLY'));
											}
											grid.getStore().load();
											btn.setDisabled(false);
											
										},failure:function(){
											btn.setDisabled(false);
										}
									});
								},100);
					        }
					    });
						
					}
					
				}
			},
				'sponserAccountStatementCriteriaGrid button[itemId=btnDelete]':{
					click:function(btn){
						//btn.setDisabled(true);
						var grid =this.getSponserAccountStatementCriteriaGrid(),
						selectedRec = grid.getSelectionModel().getSelection();
						if(selectedRec && selectedRec.length){
							showConfirmMessage(getCommonTranslation('Bulk_Account_Statement_Sponsor'), getCommonTranslation('ARE_YOU_SURE_DELETE_SELECTED_CRITERIA'), function (cbtn, text) {
						        if (cbtn == 'yes') {
						        		Ext.getBody().mask(getCommonTranslation('BULK_EMAIL'), 'x-mask-loading');
						        	Ext.Ajax.request({
		            					 method : "DELETE",
		            					 type : 'rest',
		            					 url : SERVERURL.PATH_DELETE_STATEMENT_SPONSER_EMAIL_TAB_FILTER+ '?id=' + selectedRec[0].data.criteriaId,
		            					 headers : {
		            						 'Content-Type' : 'application/json'
		            					 },
		            					 params:{
					        				  id:selectedRec[0].data.criteriaId
					        			  },
		            					 success : function(form,action) {
		            						 Ext.getBody().unmask();
		            						 showSuccessMessage(getCommonTranslation('Bulk_Account_Statement_Sponsor'),getCommonTranslation('SUCCESS'));
		            						 grid.getStore().load();
		            					 }
		            				 });
						        	}
						        })
						}
						
					}
					
				},
				'emailAccountStatementCriteriaGrid button[itemId=btnDelete]':{
					click:function(btn){
						//btn.setDisabled(true);
						var grid =this.getEmailAccountStatementCriteriaGrid(),
						selectedRec = grid.getSelectionModel().getSelection();
						if(selectedRec && selectedRec.length){
							showConfirmMessage(getMegaMenuTranslation('FP_EMAIL_ACCOUNT_STATEMENT'), getCommonTranslation('ARE_YOU_SURE_DELETE_SELECTED_CRITERIA'), function (cbtn, text) {
						        if (cbtn == 'yes') {
						        		Ext.getBody().mask(getCommonTranslation('DELETE'), 'x-mask-loading');
						        	Ext.Ajax.request({
		            					 method : "DELETE",
		            					 type : 'rest',
		            					 url : SERVERURL.PATH_DELETE_EMAIL_ACCOUNT_STATEMENT_CRITERIA+ '?id=' + selectedRec[0].data.criteriaId,
		            					 headers : {
		            						 'Content-Type' : 'application/json'
		            					 },
		            					 params:{
					        				  id:selectedRec[0].data.criteriaId
					        			  },
		            					 success : function(form,action) {
		            						 Ext.getBody().unmask();
		            						 showSuccessMessage(getMegaMenuTranslation('FP_EMAIL_ACCOUNT_STATEMENT'),getCommonTranslation('SUCCESS'));
		            						 grid.getStore().load();
		            					 }
		            				 });
						        	}
						        })
						}
						
					}
					
				},
				'sponsorAccountStatementAddCriteriaForm customcombobox[itemId=scholarshipId]':{
					select:function(cmp){
						var me = this,
						form =  me.getSponsorAccountStatementAddCriteriaForm(),
						scholarshipStatus= form.down('#scholarshipStatus');
						scholarshipStatus.setDisabled(false);
						
					}
				},
				'sponsorAccountStatementAddCriteriaForm customcombobox[itemId=accountingYear]':{
					select:function(cmp){
						var me = this,
						form =  me.getSponsorAccountStatementAddCriteriaForm(),
						scholarshipId= form.down('#scholarshipId');
						scholarshipId.getStore().getProxy().extraParams = {
							accoutingYearId:cmp.getValue()
						}
						scholarshipId.setDisabled(false);
						scholarshipId.getStore().load();
						
					}
				},
				'emailAccountStatementFilter customcombobox[itemId=studentStatus]':{
					select: function(combo) {
						var form = combo.up('form'),
						studentId =form.down('#studentId'),
						studentStatus =form.down('#studentStatus'),
						studentIdStore = studentId.getStore();
						studentIdStore.getProxy().setExtraParam('isActive', studentStatus.getValue());
						studentIdStore.load();
					}
				},
				'emailAccountStatementFilter customcombobox[itemId=emailToId]':{
					select: function(combo) {
						var form = combo.up('form'),
						userName = form.down('#userNameId');
						if(combo.getValue()=='admin'){
							userName.setVisible(true);
							this.setAllowBlank(userName,false);
						}else{
							this.setAllowBlank(userName,true);
							userName.setVisible(false);
							userName.reset();
						}
						form.getForm().checkValidity();
					}
				},
				'emailAccountStatementFilter customcombobox[itemId=userNameId]':{
					afterrender:function(combo){
						var userNameIdStore = combo.getStore();
						userNameIdStore.getProxy().setExtraParam('roleName', 'Debt Collector');
					}
				}
			});
		},
		saveAddCriteria:function(btn){
			btn.setDisabled(true);
			var me = this,
			form = me.getEmailAccountStatementFilter(),
			formValue = form.getValues(),
			grid = me.getEmailAccountStatementCriteriaGrid(),
			academyLocation=[],
			programGroup=[],
			programs=[],
			batches=[],
			seatTypes=[],
			studentIds=[],
			paymentPlanEnrolled=[],
			periods=[],
			criteriaJsonList=[],
			criteriaObj={};
			// academyLocation
			if(formValue.academyLocationItemId && formValue.academyLocationItemId.length && formValue.academyLocationItemId[0]){
				formValue.academyLocationItemId.forEach(function(rec){
					academyLocation.push({
						id:rec.data.id,
						name:rec.data.location
					});
				});
			}else if(formValue.academyLocationItemId){
				academyLocation.push({
					id:formValue.academyLocationItemId,
					name:form.down('#academyLocationItemId').rawValue
				});
			}
			if(academyLocation.length){
				criteriaObj.academyLocation = academyLocation;
			}
			// programGroup
			if(formValue.programGroupId && formValue.programGroupId.length && formValue.programGroupId[0]){
				formValue.programGroupId.forEach(function(rec){
					programGroup.push({
						id:rec.data.id,
						name:rec.data.value
					});
				});
			}
			if(programGroup.length){
				criteriaObj.programGroup = programGroup;
			}
			
			// program
			if(formValue.programNameOrCode && formValue.programNameOrCode.length && formValue.programNameOrCode[0]){
				formValue.programNameOrCode.forEach(function(rec){
					programs.push({
						id:rec.data.programId,
						name:rec.data.programValue
					});
				});
			}
			if(programs.length){
				criteriaObj.programs = programs;
			}
			
			// batch
			if(formValue.batchId && formValue.batchId.length && formValue.batchId[0]){
				formValue.batchId.forEach(function(rec){
					batches.push({
						id:rec.data.batchId,
						name:rec.data.batchName
					});
				});
			}
			if(batches.length){
				criteriaObj.batches = batches;
			}
			
			// periods
			if(formValue.periodId && formValue.periodId.length && formValue.periodId[0]){
				formValue.periodId.forEach(function(rec){
					periods.push({
						id:rec.data.periodId,
						name:rec.data.periodName
					});
				});
			}
			if(periods.length){
				criteriaObj.periods = periods;
			}
			
			// seatType
			if(formValue.seatTypeId && formValue.seatTypeId.length && formValue.seatTypeId[0]){
				formValue.seatTypeId.forEach(function(rec){
					seatTypes.push({
						id:rec.data.seatTypeId,
						name:rec.data.seatValue
					});
				});
			}
			if(seatTypes.length){
				criteriaObj.seatTypes = seatTypes;
			}
			
			// student
			if(formValue.studentId && formValue.studentId.length && formValue.studentId[0]){
				formValue.studentId.forEach(function(rec){
					studentIds.push({
						id:rec.data.id,
						name:rec.data.value
					});
				});
			}
			if(studentIds.length){
				criteriaObj.studentIds = studentIds;
			}
			
			// paymentPlanEnrolled
			if(formValue.paymentPlanEnrolled && formValue.paymentPlanEnrolled.length && formValue.paymentPlanEnrolled[0]){
				formValue.paymentPlanEnrolled.forEach(function(rec){
					paymentPlanEnrolled.push({
						id:rec.data.id,
						name:rec.data.displayValue
					});
				});
			}
			if(paymentPlanEnrolled.length){
				criteriaObj.paymentPlanEnrolled = paymentPlanEnrolled;
			}
			
			/*if(formValue.status){
				criteriaObj.criteriaStatus = "ACTIVE";
			}else if(formValue.status == false){
				criteriaObj.criteriaStatus = "INACTIVE";
			}*/
			
			if(formValue.enrollmentStatus){
				criteriaObj.enrollmentStatus = formValue.enrollmentStatus;
			}
			if(formValue.address){
				criteriaObj.address = formValue.address;
			}
			
			if(formValue.typeOfBalance){
				criteriaObj.typeOfBalance = formValue.typeOfBalance;
			}
			
			if(formValue.minAmount){
				criteriaObj.minimumBalance = parseFloat(formValue.minAmount);
			}

			if(formValue.maxAmount){
				criteriaObj.maximumBalance = parseFloat(formValue.maxAmount);
			}
			if(formValue.statementFrom){
				criteriaObj.statementFrom = formValue.statementFrom;
			}
			if(formValue.statementTill){
				criteriaObj.statementTo = formValue.statementTill;
			}
		    criteriaObj.isActive = formValue.studentStatus;
			if(formValue.userName ){
				criteriaObj.adminId = formValue.userName;
			}
			criteriaJsonList.push(criteriaObj);
			if(formValue.withZeroOutstanding)
			{
				criteriaObj.withZeroOutstanding = "Yes";
			}else{
				criteriaObj.withZeroOutstanding = "No";
			}
			var criteria = {
					criteriaJsonList:criteriaJsonList
			}
			var formData = Ext.encode(criteria);
			Ext.getBody().mask(getCommonTranslation('ADD_CRITERIA'), 'x-mask-loading');
			Ext.defer(function(){
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_SAVE_STATEMENT_EMAIL_TAB_FILTER,
				method: 'POST',
				jsonData : formData,
				async: false,
				success: function(res, action) {
					Ext.getBody().unmask();
					grid.getStore().load();
					btn.setDisabled(false);
					showSuccessMessage(getCommonTranslation('ADD_CRITERIA') ,getCommonTranslation('BULK_EMAIL_CRITERIA_ADDED_SUCCESSFULLY'));
				},
				failure:function(){
					Ext.getBody().unmask();
					btn.setDisabled(false);
				}
			});
			},100);
			
		},
		setParamToFetchDropDownData:function(cmp){
			var me = this,
			 form = me.getEmailAccountStatementFilter(),
				resetBtnItemId = form.down('#resetBtnItemId');
			resetBtnItemId.setDisabled(true);
			Ext.defer(function(){
				var form = me.getEmailAccountStatementFilter();
				if(form){
				var academiaLocation = form.down('#academyLocationItemId'),
				programNameOrCode=form.down('#programNameOrCode'),
				batchId=form.down('#batchId'),
				studentId=form.down('#studentId'),
				periodId=form.down('#periodId'),
				seatTypeId=form.down('#seatTypeId'),
				status=form.down('#status'),
				studentStatus =form.down('#studentStatus'),
				academiaLoc = academiaLocation.getValue(),
				programVal=programNameOrCode.getValue(),
				batchVal=batchId.getValue(),
				periodVal=periodId.getValue(),
				seatTypeVal=seatTypeId.getValue();
				studentId.reset();
				if(periodVal && periodVal.length > 0){
					try{
						var periodValId = Ext.Array.pluck(Ext.Array.pluck(periodVal, 'data'), 'periodId').join();
					} catch(e) {
						var periodValId = periodVal.join();
					}
				}
				if(academiaLoc && academiaLoc.length > 0){
					try{
						var academyLocationId = Ext.Array.pluck(Ext.Array.pluck(academiaLoc, 'data'), 'id').join();
					} catch(e) {
						var academyLocationId = academiaLoc.join();
					}
				}else if(academiaLoc){
					var academyLocationId = academiaLoc;
				}
				if(programVal && programVal.length > 0){
					try{
						var programValId = Ext.Array.pluck(Ext.Array.pluck(programVal, 'data'), 'programId').join();
					} catch(e) {
						var programValId = programVal.join();
					}
				}
				if(batchVal && batchVal.length > 0){
					try{
						var batchValId = Ext.Array.pluck(Ext.Array.pluck(batchVal, 'data'), 'batchId').join();
					} catch(e) {
						var batchValId = batchVal.join();
					}
				}
				if(seatTypeVal && seatTypeVal.length > 0){
					try{
						var seatTypeValId = Ext.Array.pluck(Ext.Array.pluck(seatTypeVal, 'data'), 'seatTypeId').join();
					} catch(e) {
						var seatTypeValId = seatTypeVal.join();
					}
				}
				studentId.getStore().getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					programId:programValId,
					batchId:batchValId,
					seatTypeId:seatTypeValId,
					periodId:periodValId,
					status:status.getValue(),
					isActive:studentStatus.getValue()
					
				}
				studentId.getStore().load();
				resetBtnItemId.setDisabled(false);
			}
			},700);
			
		},
		saveSponsorAccountCriteria:function(btn){
			btn.setDisabled(true);
			var me = this,scholarshipStatusArray=[],criteriaJsonList=[],
			form =me.getSponsorAccountStatementAddCriteriaForm(),
			sponsorGrid = me.getSponserAccountStatementCriteriaGrid(),
			formVal = form.getForm().getValues(),
			currentYear = new Date().getFullYear(),
			januaryFirst = new Date(currentYear, 0, 1),
			formattedDate = Ext.Date.format(januaryFirst, 'Y-m-d'),
			accountingYearName = form.down('#accountingYear').lastSelection[0],
			scholarshipIdName = form.down('#scholarshipId').lastSelection[0],
			scholarshipStatus = Ext.pluck(Ext.pluck(formVal.scholarshipStatus,'data'),'code');
			scholarshipStatus.forEach(function(status){
				scholarshipStatusArray.push({
					code:status,
					name:status
				});
			});
			criteriaJsonList.push({
				scholarshipStatus:scholarshipStatusArray,
				scholarshipId:formVal.scholarshipId,
				scholarshipName:scholarshipIdName.data.valueCode,
				accountingYearName:accountingYearName.data.currentAccountingYear,
				accountingYearId:formVal.accountingYear,
				language:formVal.language,
				withZeroOutstanding:formVal.sponserWithZeroOutstandingId?'YES':'NO',
				statementFrom:formattedDate,
				statementTo:Ext.Date.format(new Date(), 'Y-m-d')
			})
			var jsonData={
				criteriaJsonList:criteriaJsonList
			}
			var formData= Ext.encode(jsonData);
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.PATH_SAVE_STATEMENT_SPONSER_EMAIL_TAB_FILTER,
				jsonData : formData,
				method : 'POST',
				success : function(f, action) {
					Ext.getBody().unmask();
					btn.setDisabled(false);
					form.getForm().reset();
					form.down('#scholarshipStatus').reset();
					form.down('#scholarshipStatus').setDisabled(true);
					form.down('#scholarshipId').setDisabled(true);
					showSuccessMessage(getCommonTranslation('Bulk_Account_Statement_Sponsor'),getCommonTranslation('SUCCESS'));
					sponsorGrid.getStore().load();
				},
				failure: function(result, request) {
					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
					return false;
				}
			});
		}
})