/***
 * Rajkumar
 * 
 */
Ext.define('Academia.controller.enquiry.admission.AdmissionReqmntDetailController', {
	extend: 'Academia.controller.base.BaseController',
	models:['enquiry.admission.AdmissionReqmntSubmitModel','enquiry.admission.AdmissionReqmntSubmitModel'],
	stores:['enquiry.admission.AdmissionReqmntStore','common.ProgramByAcademyLocationStore','program.ProgramByGroupIdStore','common.ModeOfDeliveryStore',
		'common.RegistrationTypeStore','program.ProgrmaFromBeatchLevelModAndRegType'],
	views :['enquiry.admission.AdmissionReqmntDetailStructure',
             'enquiry.admission.AdmissionReqmntDetailForm',
	         'enquiry.admission.AdmissionReqmntDetailGrid','enquiry.admission.AdmissionReqmntDetailFormStructure'
	       ],

	                  alias : "widget.admissionreqmntdetailcontroller",
	                  config: {
	      	          	/*
	      	      	   	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	      	      	   	 */
	      	          	/**
	      	               * @cfg {Array} ENQUIRY_ADMISSION_DETAIL_PERMISSIONS array (required)
	      	               * The array of permissions to use for Access control wise enabling and disabling buttons.
	      	               * @accessor
	      	               */
	      		      ENQUIRY_ADMISSION_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_ADMISSION_DETAIL_PRIVILEGES')
	      	          },         

	                  refs : [{
	                	  ref : 'admissionreqmntdetailForm',
	                	  selector : 'admissionreqmntdetailform form'
	                  },{
	                	  ref : 'admissionreqmntdetailform',
	                	  selector : 'admissionreqmntdetailform'
	                  },{
	                	  ref : 'admissionreqmntdetailgrid',
	                	  selector : 'admissionreqmntdetailgrid'	
	                  },{
	                	  ref : 'admissionreqmntstructure',
	                	  selector : 'admissionreqmntstructure'	
	                  },{
	                	  ref : 'enquirytabstructure',
	                	  selector : 'enquirytabstructure' 
	                  },{
	                	  ref : 'admissionreqmntdetailformstructure',
	                	  selector : 'admissionreqmntdetailformstructure' 
	                  }],

	                  init : function() {

	                	  this.control({
	                		  
	                		  'admissionreqmntdetailgrid':{
	                			  render:function(grid){
	                				  this.doAccessControlValidation(grid, this.getENQUIRY_ADMISSION_DETAIL_PERMISSIONS());
	                				  var commonForm = this.getEnquirytabstructure().getForm();
	                				  var commonVal = commonForm.getValues();
	                				  var buttonId = commonVal.buttonType;
	                				  if(buttonId == 'View'){
	                					  grid.down('#btnAdd').setVisible(false);
	                					  grid.down('#btnEdit').setVisible(false);
	                					  grid.down('#btnDelete').setVisible(false);
	                				  }
	                				  if(commonVal.enqTypes == 'Counselling'){
	                					  this.setGridBtnHideShow(grid,false,buttonId);
	                				  }else{
	                					  this.setGridBtnHideShow(grid,true,buttonId);  
	                				  }
                					  if(commonVal.enqTypes == 'Placement' || commonVal.enqTypes == 'Corporate'){
                						  this.HideGridBtnInPlacementEnquiry(grid,false,buttonId);
                					  }
	                			  },
	                			  afterrender : function(grid){
	                  				var me = this;
	                  				me.addDataGridConfigButton(grid,me.getENQUIRY_ADMISSION_DETAIL_PERMISSIONS());
	                  			}
	                		  },
	                		  
	                		  'admissionreqmntdetailgrid button[itemId=btnAdd]':{
	                			  click:this.showFormWindow
	                		  },
	                		  'admissionreqmntdetailgrid button[itemId=btnEdit]':{
	                			  click:this.editFormWindow
	                		  },
	                		  'admissionreqmntdetailgrid button[itemId=btnDelete]':{
	                			  click:this.deleteFormWindow
	                		  },
	                		  'admissionreqmntdetailgrid button[itemId=btnView]':{
	                			  click:this.viewFormWindow
	                		  },
	                		  'admissionreqmntdetailform button[itemId=ard_submitbuttonId]':{
	                			  click:this.saveAdmissionDetail
	                		  },
	                		  'admissionreqmntdetailform button[itemId=ard_cancelbuttonId]':{
	                			  click:this.cancelAdmissionDetail
	                		  },

	                		  /*'admissionreqmntdetailform customcombobox#academyId': {
	                			  select: function(obj, record) {
	                				  var academyId = record[0].get("id");
	                				  var store = this.getStore('common.AcademyLocationByAcademyId');

	                				  store.getProxy().extraParams = {
	                					  id: academyId
	                				  };
	                				  store.load();
	                			  }
	                		  },*/
	                		  'admissionreqmntdetailform customcombobox#academyLocationId':{
	                			  select: function(obj, record) {
	                				  var programComboField = obj.up('form').down('#programId');
	                				  var academyLocationField = obj.up('form').down('#academyLocationId');
	                				  var modeDeliveryId = obj.up('form').down('#modeDeliveryId').getValue();
	                				  var registrationTypeEnum = obj.up('form').down('#registrationTypeId').getValue();
	                				  var alValue = academyLocationField.getValue();
	                				  var batchLevelRegType=null;
	                				  programComboField.reset();
	                				  var grid = Ext.getCmp('admissionrqmnt_grid');
	                				  var records = grid.getSelectionModel().getSelection()[0];
	                				  var isOtherBlankProgramRequired=null;
	                				  if(!isNullOrEmpty(records)){
	                					  if(!isNullOrEmpty(records.data.program)){
	                						  isOtherBlankProgramRequired = false;
	                					  }else{
	                						  isOtherBlankProgramRequired = true;
	                					  }  
	                				  }else{
	                					  isOtherBlankProgramRequired = false;
	                				  }
	                				  programComboField.getStore().getProxy().extraParams = {
	                					  academyLocationIds:alValue,
	                					  isOtherBlankProgramRequired:isOtherBlankProgramRequired
	                				  }
	                				  if( !isNullOrEmpty(modeDeliveryId)){
	                					  programComboField.getStore().getProxy().extraParams.modeOfDeliveryId = modeDeliveryId;
	                				  }
	                				  
	                				  if(!isNullOrEmpty(registrationTypeEnum)){
	                					  if(registrationTypeEnum=='FULL_TIME'){
	                						  batchLevelRegType=false;
	                					  }else if(registrationTypeEnum=='PART_TIME'){
	                						  batchLevelRegType=true;
	                					  }
	                					  programComboField.getStore().getProxy().extraParams.registrationTypeEnum =batchLevelRegType;
	                				  }
	                				  programComboField.getStore().load();
	                				  var seatCombo = obj.up('form').down('#seatTypeId');
	                				  seatCombo.reset();
	                				  seatCombo.setDisabled(true);
	                				  seatCombo.allowBlank = true;
	                				  var fieldOfInterestCombo = obj.up('form').down('#fieldOfInterest');
	                				  fieldOfInterestCombo.reset();
	                				  fieldOfInterestCombo.setDisabled(true);
	                				  var batchCombo = obj.up("form").down("#batchId");
	                				  batchCombo.reset();
	                				  batchCombo.setDisabled(true);
	                				  batchCombo.allowBlank=true;
	                			  }
	                		  },
	                		  'admissionreqmntdetailform ':{
	                			  afterrender : function(){
	                				  var form=this.getAdmissionreqmntdetailform();
	                				  var programComboField=form.down('#programId');
	                				  var al=form.down('#academyLocationId').getValue();
	                				  if(al==null)
	                					  var alValue=this.getCurrentAcademyLocation();
	                				  programComboField.getStore().getProxy().extraParams = {
	                					  academyLocationIds:alValue,
	                					  isOtherBlankProgramRequired:false
	                				  }
	                			  }
	                		  },
	                		
	                		  'admissionreqmntdetailform customcombobox#registrationTypeId': {
	                			  select: function(obj, record) {
	                				  var programComboField = obj.up('form').down('#programId');
	                				  var academyLocationField = obj.up('form').down('#academyLocationId');
	                				  var modeDeliveryId = obj.up('form').down('#modeDeliveryId').getValue();
	                				  var regTypeCombo = obj;
	                				  var registrationTypeEnum = regTypeCombo.getValue();
	                				  var batchLevelRegType=null;
	                				  
	                				  var alValue = academyLocationField.getValue();

	                				  programComboField.reset();

	                				  var grid = Ext.getCmp('admissionrqmnt_grid');
	                				  var records = grid.getSelectionModel().getSelection()[0];
	                				  var isOtherBlankProgramRequired=null;
	                				  if(!isNullOrEmpty(records)){
	                					  if(!isNullOrEmpty(records.data.program)){
		                					   isOtherBlankProgramRequired = false;
		                				  }else{
		                					  isOtherBlankProgramRequired = true;
		                				  } 
	                				  }else{
	                					  isOtherBlankProgramRequired = false; 
	                				  }
	                				 
	                				  programComboField.getStore().getProxy().extraParams = {
	                					  academyLocationIds:alValue,
	                					  isOtherBlankProgramRequired:isOtherBlankProgramRequired
	                				  }
	                				  if( !isNullOrEmpty(regTypeCombo) && !isNullOrEmpty(registrationTypeEnum) ){
		                					  if(registrationTypeEnum=='FULL_TIME'){
		                						  batchLevelRegType=false;
		                					  }else if(registrationTypeEnum=='PART_TIME'){
		                						  batchLevelRegType=true;
		                					  }
	                					  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = batchLevelRegType;
	                				  }
	                				  if( !isNullOrEmpty(modeDeliveryId) && !isNullOrEmpty(modeDeliveryId) ){
	                					  programComboField.getStore().getProxy().extraParams.modeOfDeliveryId = modeDeliveryId;
	                				  }
	                				  programComboField.getStore().load();
	                				  var seatCombo = obj.up('form').down('#seatTypeId');
	                				  seatCombo.reset();
	                				  seatCombo.setDisabled(true);
	                				  var fieldOfInterestCombo = obj.up('form').down('#fieldOfInterest');
	                				  fieldOfInterestCombo.reset();
	                				  fieldOfInterestCombo.setDisabled(true);
	                				  var batchCombo = obj.up("form").down("#batchId");
	                				  batchCombo.reset();
	                				  batchCombo.setDisabled(true);
	                			  }
	                		  },
	                		  
	                		  'admissionreqmntdetailform customcombobox#modeDeliveryId': {
	                			  select: function(obj, record) {
	                				  var programComboField = obj.up('form').down('#programId');
	                				  var academyLocationField = obj.up('form').down('#academyLocationId');
	                				  var registrationTypeEnum = obj.up('form').down('#registrationTypeId').getValue();
	                				  var alValue = academyLocationField.getValue();
	                				  var batchLevelRegType=null;
	                				  programComboField.reset();

	                				  var grid = Ext.getCmp('admissionrqmnt_grid');
	                				  var records = grid.getSelectionModel().getSelection()[0];
	                				  var isOtherBlankProgramRequired=null;
	                				  if(!isNullOrEmpty(records)){
	                					  if(!isNullOrEmpty(records.data.program)){
	                						  isOtherBlankProgramRequired = false;
	                					  }else{
	                						  isOtherBlankProgramRequired = true;
	                					  } 
	                				  }else{
	                					  isOtherBlankProgramRequired = false; 
	                				  }
	                				  programComboField.getStore().getProxy().extraParams = {
	                					  academyLocationIds:alValue,
	                					  isOtherBlankProgramRequired:isOtherBlankProgramRequired
	                				  }
	                				  var modeOfdeliveryCombo = obj;
	                				  if(!isNullOrEmpty(modeOfdeliveryCombo.getValue())){
	                					  programComboField.getStore().getProxy().extraParams.modeOfDeliveryId = modeOfdeliveryCombo.getValue();
	                				  }
	                				  if(!isNullOrEmpty(registrationTypeEnum)){
	                					  if(registrationTypeEnum=='FULL_TIME'){
	                						  batchLevelRegType=false;
	                					  }else if(registrationTypeEnum=='PART_TIME'){
	                						  batchLevelRegType=true;
	                					  }
	                					  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = batchLevelRegType;
	                				  }
	                				  programComboField.getStore().load();
	                				  var seatCombo = obj.up('form').down('#seatTypeId');
	                				  seatCombo.reset();
	                				  seatCombo.setDisabled(true);
	                				  var fieldOfInterestCombo = obj.up('form').down('#fieldOfInterest');
	                				  fieldOfInterestCombo.reset();
	                				  fieldOfInterestCombo.setDisabled(true);
	                				  var batchCombo = obj.up("form").down("#batchId");
	                				  batchCombo.reset();
	                				  batchCombo.setDisabled(true);
	                			  }
	                		  },
	                		  
	                		  'admissionreqmntdetailform customcombobox#programId': {
	                			  select: function(obj, record) {
	                				  var programId = record[0].get("id");
	                				  var store = this.getStore('enquiry.AcademicBatchStore');
	                				  var batchCombo = obj.up('form').down('#batchId');
	                				  var seatCombo = obj.up('form').down('#seatTypeId');
	                				  var fieldOfInterestCombo = obj.up('form').down('#fieldOfInterest');
	                				  var modeOfDeliveryId = obj.up('form').down('#modeDeliveryId').getValue();
	                				  //This is Enum
	                				  var registrationTypeEnum = obj.up('form').down('#registrationTypeId').getValue();
	                				  var modeOfDeliveryparam=null;
	                				  var registrationTypeparam=null;
	                				  
	                				  if(modeOfDeliveryId!=null){
	                					  modeOfDeliveryparam = modeOfDeliveryId;
	                				  }
	                				  
	                				  if(registrationTypeEnum!=null){
	                					  if(registrationTypeEnum=='FULL_TIME'){
	                						  registrationTypeparam=false;
	                					  }
	                					  if(registrationTypeEnum=='PART_TIME'){
	                						  registrationTypeparam=true;
	                					  }
	                				  }
	                				  if(programId ==0){
	                					  batchCombo.reset();
	                					  seatCombo.reset();
	                					  batchCombo.setDisabled(true);
	                					  seatCombo.setDisabled(true);
	                					  batchCombo.allowBlank = true;
	                					  seatCombo.allowBlank = true;
	                					  fieldOfInterestCombo.setDisabled(false);
	                				  }else{
	                					  batchCombo.setDisabled(false);
	                					  seatCombo.setDisabled(false);
	                					  batchCombo.allowBlank = false;
	                					  seatCombo.allowBlank = false;
	                					  fieldOfInterestCombo.reset();
	                					  fieldOfInterestCombo.setDisabled(true); 
	                					  if(obj.up('form').isValid()){
	                						  obj.up('form').down('#ard_submitbuttonId').setDisabled(false);
	                					  }else{
	                						  obj.up('form').down('#ard_submitbuttonId').setDisabled(true);
	                					  }
	                				  }
	                				  
	                				  if(modeOfDeliveryparam!=null && registrationTypeparam!=null){
	                					  store.getProxy().extraParams = {
	                						  id: programId,
	                						  modeOfDeliveryId:modeOfDeliveryparam,
	                						  batchPartTime:registrationTypeparam
	                					  };
	                				  }else if(modeOfDeliveryparam!=null){
	                					  store.getProxy().extraParams = {
	                						  id: programId,
	                						  modeOfDeliveryId:modeOfDeliveryparam,
	                					  };
	                				  }else if(registrationTypeparam!=null){
	                					  store.getProxy().extraParams = {
	                						  id: programId,
	                						  batchPartTime:registrationTypeparam
	                					  };
	                				  }else{
	                					  store.getProxy().extraParams = {
	                						  id: programId,
	                					  };

	                				  }
	                				  
	                				  //store.load();
	                				  store.load({
	                						callback: function(records, operation, success) {
	                							if (success) {
	                								if(records.length == 1){
	                								 batchCombo.setValue(records[0].data.id);
	                								 batchCombo.fireEvent('select',batchCombo,records);
	                								}else{
	                									seatCombo.reset();
	                								}
	                							}
	                						}
	                					});
	                			  }
	                		  },
	                		  'admissionreqmntdetailform customcombobox#batchId': {
	                			  select: function(obj, record) {

	                				  var batchId = record[0].get("id");
	                				  var store = this.getStore('enquiry.ProgramBatchSeatTypeStore');
	                				  
	                				  var seatCombo = obj.up('form').down('#seatTypeId');

	                				  store.getProxy().extraParams = {
	                					  id: batchId
	                				  };
	                				  //store.load();
	                				  store.load({
	                						callback: function(records, operation, success) {
	                							if (success) {
	                								if(records.length == 1){
	                									seatCombo.setValue(records[0].data.id);
	                									//seatCombo.fireEvent('select',batchCombo,records);
	                								} else {
	                									seatCombo.reset();
	                								}
	                							}
	                						}
	                					});
	                			  }
	                		  },
	                		  'admissionreqmntstructure' : {
	                			  activate: function(f){
	                    			this.onAdmissionFormRender();
	                			  }
	                		  },
	                		  'admissionreqmntdetailformstructure':{
	                			  render:function(structure){
	                  				var $this = this
	                  				structure.body.on('click', function() {
	                  					var form = structure.down('admissionreqmntdetailform');
	                  					$this.hideInvalidIconFromField(form);
	                  			       });
	                  			}
	                		  }
	                	  });
	                  },
	                  showFormWindow : function() {

	                	  var formWindow = this.getAdmissionreqmntdetailformstructure();
	                	  if (!formWindow) {
	                		  Ext.widget('admissionreqmntdetailformstructure');
	                		  formWindow = this.getAdmissionreqmntdetailformstructure();
	                	  }
	                	  formWindow.show();

	                  },
	                  editFormWindow: function() {
	                	  var grid = Ext.getCmp('admissionrqmnt_grid');
	                	  if (grid.getSelectionModel().getCount() > 0) {
	                		  this.showFormWindow();
	                		  var form = this.getAdmissionreqmntdetailform();
	                		  var getForm = form.getForm();
	                		  var records = grid.getSelectionModel().getSelection()[0];
	                		  if (records != undefined && records != "" && records != null) {
	                			  Ext.Ajax.request({
	                	                method: 'GET',
	                	                url: SERVERURL.ENQUIRY_ADMISSION_REQ_EDIT_BY_ID,
	                	                params: {
	                	                    id: records.data.id
	                	                },
	                	                success: function(response) {
	                	                	if (response.responseText != null && response.responseText != "") {
	                	                		var data = JSON.parse(response.responseText);
	                	                		var batchField=getForm.findField('batch');
	                	                		var seatTypeField=getForm.findField('seatType');
	                	                		var programField=getForm.findField('program');
	                	                		var programStore = programField.getStore();
	                	                		var academyLocationField=getForm.findField('academyLocation');
	                	                		var modeofDeliveryField=getForm.findField('modeofDelivery');
	                	                		var academyStore = academyLocationField.getStore();
	                	                		var academyId = data.academyLocation.id;
	                	                		var programId=null;
	                	                		var batchId=null;
	                	                		var isOtherBlankProgramRequired = false;
	                	                		var seatId=null;
	                	                		if( !isNullOrEmpty(data.program) ){
	                	                			programId = data.program.id;
	                	                			if(data.batch){
	                	                				batchId = data.batch.id;
	                	                			}
	                	                			if(data.programBatchSeatConfiguration!=null){
	                	                				seatId = data.programBatchSeatConfiguration.id;
	                	                			}
	                	                			var batchStore = batchField.getStore();
	                	                			if(data.modeOfDeliveryCSM!=null && data.batchPartTime!=null){
	                	                				batchStore.getProxy().extraParams = {
	                	                					id: programId,
	                	                					modeOfDeliveryId:data.modeOfDeliveryCSM.id,
	                	                					batchPartTime:data.batchPartTime
	                	                				};
	                	                			}else if(data.modeOfDeliveryCSM!=null){
	                	                				batchStore.getProxy().extraParams = {
	                	                					id: programId,
	                	                					modeOfDeliveryId:data.modeOfDeliveryCSM.id,
	                	                				};
	                	                			}else if(data.batchPartTime!=null){
	                	                				batchStore.getProxy().extraParams = {
	                	                					id: programId,
	                	                					batchPartTime:data.batchPartTime
	                	                				};
	                	                			}else{
	                	                				batchStore.getProxy().extraParams = {
	                	                					id: programId,
	                	                				};

}
	                	                			batchStore.load({
	                	                				callback: function(record, operation, success) {
	                	                					if (success) {
	                	                						batchField.setValue(batchId);
	                	                					}
	                	                				}
	                	                			});

	                	                			var seatStore = seatTypeField.getStore();
	                	                			seatStore.getProxy().extraParams = {
	                	                				id :batchId
	                	                			};
	                	                			if(data.programBatchSeatConfiguration!=null){
	                	                				seatStore.load({
	                	                					callback: function(record, operation, success) {
	                	                						if (success) {
	                	                							seatTypeField.setValue(seatId);
	                	                						}
	                	                					}
	                	                				});
	                	                			}

	                	                		} else {
	                	                			programId = 0;

	                	                			isOtherBlankProgramRequired = true;
	                	                			var fieldofInterestField = form.down("#fieldOfInterest");
	                	                			fieldofInterestField.setDisabled(false);
	                	                			batchField.setDisabled(true);
	                	                			seatTypeField.setDisabled(true);
	                	                			fieldofInterestField.setValue(data.fieldOfInterest);
	                	                		}

	                	                		var academyLocationField = form.down("#academyLocationId");

	                	                		var modeOfDeliveryField = form.down("#modeDeliveryId");
	                	                		if(data.modeOfDeliveryCSM !=null){
	                	                			if(data.modeOfDeliveryCSM.id!=null){
	                	                				var modOfDelId =data.modeOfDeliveryCSM.id;
	                	                				var modeofDelivery = modeOfDeliveryField.getStore();
	                	                				modeofDelivery.getProxy().extraParams = {
	                	                					id:modOfDelId
	                	                				};
	                	                				modeofDelivery.load({
	                	                					callback: function(record, operation, success) {
	                	                						if (success) {
	                	                							modeOfDeliveryField.setValue(modOfDelId);
	                	                						}
	                	                					}
	                	                				});
	                	                			}
	                	                		}
	                	                		var registrationTypeField = form.down("#registrationTypeId");
	                	                		if(!isNullOrEmpty(data.batchPartTime)){
	                	                			registrationTypeField.getStore().load({
	                	                				callback : function(record,success) {
	                	                					if (success){
	                	                						for(var i in record) {
	                	                							if(data.batchPartTime==true){
	                	                								registrationTypeField.setValue(record[0].data.value);
	                	                							}else if(data.batchPartTime==false){
	                	                								registrationTypeField.setValue(record[1].data.value);
	                	                							}
	                	                						}
	                	                					}
	                	                				}
	                	                			});
	                	                		}
	                	                		var regType=null
	                	                		if(data.batchPartTime !=null){
	                	                				regType=data.batchPartTime;
	                	                		}
	                	                		var modeOfDel = null;
	                	                		if(data.modeOfDeliveryCSM !=null){
	                	                			modeOfDel= data.modeOfDeliveryCSM.id
	                	                		}
	                	                		programStore.getProxy().extraParams = {
            	                					modeOfDeliveryId:modeOfDel,
            	                					registrationTypeEnum:regType,
            	                					academyLocationIds:academyId,
            	                					isOtherBlankProgramRequired:isOtherBlankProgramRequired
            	                				};
	                	                		programStore.load({
	                	                			callback: function(record, operation, success) {
	                	                				if (success) {
	                	                					programField.setValue(programId);
	                	                				}
	                	                			}
	                	                		});
	                	                		getForm.findField('id').setValue(records.data.id);
	                	                		academyStore.load({
	                	                			callback: function(record, operation, success) {
	                	                				if (success) {
	                	                					academyLocationField.setValue(academyId);
	                	                				}
	                	                			}
	                	                		});

	                	                	}
	                	                }
	                			  });
	                		  }
	                	  } else {
	                		  showWarningMessage(getCommonTranslation('ADMISSION_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	  }
	                  },

	                  deleteFormWindow : function(){
	                	  var $this = this;
	                	  var grid = this.getAdmissionreqmntdetailgrid();
	                	  var store = grid.getStore();

	                	  if (grid.getSelectionModel().getCount() > 0) {

	                		  var records = grid.getSelectionModel().getSelection()[0];
	                		  showConfirmMessage(getCommonTranslation('CONFIRM_DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			  if (btn == 'yes') {
	                	        	 
	                	        	  var commonForm = $this.getEnquirytabstructure().getForm();
	                	        	  var commonVal = commonForm.getValues();
	                	        	  var enquiryId = commonVal.enqId;
                                
	                					  var record = grid.getSelectionModel().getSelection()[0];
	                					  var id = record.get("id");
	                					  Ext.Ajax.request({
	                						  method: "DELETE",
	                						  type: 'rest',
	                						  url: SERVERURL.ENQUIRY_ADMISSION_DELETE+'?id='+id,
	                						  headers: {
	                	                            'Content-Type': 'application/json'
	                	                        },
	                	                        params: {
	                	                            id: id
	                	                        },
	                	                        success: function(form, action) {
												  var res = Ext.JSON.decode(form.responseText);
												  if (res == 1) {
													  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DELETE_SG_APPOINTMENT_FIRST'));
												  } else {
	                	                        	var commonForm = $this.getEnquirytabstructure().getForm();
	                	                        	var commonVal = commonForm.getValues();
	                	                        	var studentDetailId = commonVal.studentDetailId;  
	                	                        	Ext.Ajax.request({
	                	                        		type : 'rest',
	                	                        		url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+studentDetailId,
	                	                        		//jsonData : jsonData,
	                	                        		//data: jsonData,
	                	                        		method : 'GET',
	                	                        		success : function(form, action) {
	                	                        			var data = Ext.JSON.decode(form.responseText);
	                	                        			//console.log(data);
	                	                        			if(data.length>0){
	                	                        				var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
		                	                        			if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
		                	                        				programIntake.setValue(data[0].programIntakeCombo); 
		                	                        			}
	                	                        			}
	                	                        		}
	                	                        	});

	                	                        	grid.getStore().reload();
	                	                        	showSuccessMessage(getEnquiryTranslation('ADMISSION_DEATILS'), getCommonTranslation('SUCCESS'));
	                	                        }
											  }
	                					  });
	                			  }
	                		  });

	                	  } else {
	                		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
	                	  }
	                  },

	                  viewFormWindow : function(){
	                	  this.editFormWindow();
	                	  var form =this.getAdmissionreqmntdetailform();
	                	  if (form) {
	                		  form.down('#ard_submitbuttonId').setVisible(false);
	                		  form = form.getForm();
	                		  toggleReadOnlyFormItems(form, true);
	                	  }
	                  },

	                  cancelAdmissionDetail : function(){

	                	  var form = this.getAdmissionreqmntdetailformstructure();	
	                	  form.close();
	                  },

	                  saveAdmissionDetail : function(){

	                	  var $this = this;
	                	  var formWindow = $this.getAdmissionreqmntdetailform();
	                	  this.showInvalidIconOnField(formWindow);
	                	  var commonForm = this.getEnquirytabstructure().getForm();
	                	 
	                	  var commonVal = commonForm.getValues();
	                	  var studentDetailId = commonVal.studentDetailId;  
                         
	                	  var grid =  Ext.getCmp('admissionrqmnt_grid');
	                	  var grdStore = grid.getStore();  

	                	 
	                	  var form = formWindow.getForm();
	                	  var value = form.getValues();
                          var  seatId=value.seatType;
                          
	                	  var registrationTypeValue = form.findField('registrationType').getRawValue();
                          var modeofDeliveryValue = form.findField('modeofDelivery').getRawValue();
                         
                          if(registrationTypeValue!=null && registrationTypeValue!=''){
                        	  var registrationTypeId = form.findField('registrationType').getStore().findRecord('value',registrationTypeValue).data.id;
                          }
                          if(modeofDeliveryValue!=null && modeofDeliveryValue!=''){
                        	  var modeofDeliveryId = form.findField('modeofDelivery').getStore().findRecord('value',modeofDeliveryValue).data.id;
                          }
                          var admissionModel = new Academia.model.enquiry.admission.AdmissionReqmntSubmitModel();
	                	  admissionModel.set("id",parseInt(value.id));
	                	  admissionModel.set("academyLocation",$this.getIdValueJson(value.academyLocation));
	                	  admissionModel.set("program",$this.getIdValueJson(value.program));
	                	  admissionModel.set("batch",$this.getIdValueJson(value.batch));
	                	  admissionModel.set("whetherDeleted","false");
	                	  admissionModel.set("customFieldDatas",value.customFieldDatas);
	                	  admissionModel.set("fieldOfInterest",value.fieldOfInterest);
	                	  admissionModel.set("modeOfDeliveryCSM",$this.getIdValueJson(value.modeofDelivery));
	                	  
	                	  if(value.registrationType != "" && value.registrationType != null){
	                      	var registrationTypeBoolean = null;
	                      	if(value.registrationType=="FULL_TIME" || value.registrationType=="Full Time"){
	                      		registrationTypeBoolean = false;
	                      	}else if(value.registrationType=="PART_TIME" || value.registrationType=="Part Time"){
	                      		registrationTypeBoolean = true;
	                      	}
	                      	admissionModel.set("batchPartTime",registrationTypeBoolean);	
	                      }
	                	  
	                	  /*delete admissionModel.data.registrationTypeCSM;
	                	  delete admissionModel.data.modeOfDeliveryCSM*/
	                	  var sId = {id:parseInt(studentDetailId)};
	                	  var psc = {id:seatId};
	                	  admissionModel.set("enquiryStudentDetail",sId);
	                	  if( !isNullOrEmpty(seatId) ){
	                		  admissionModel.set("programBatchSeatConfiguration",psc);  
	                	  }

	                	  if (value.id == null ||value.id == "") {
	                		  submitUrl = SERVERURL.ENQUIRY_ADMISSION_CREATE;
	                	  } else {

	                		  submitUrl = SERVERURL.ENQUIRY_ADMISSION_UPDATE;
	                	  }
	                	  if(isNullOrEmpty(seatId)){
	                		  delete  admissionModel.data.programBatchSeatConfiguration;
	                	  }
	                	  var submitData = Ext.encode(admissionModel.data);
	                	  Ext.Ajax.request({
	                		  url: submitUrl,
	                		  jsonData: submitData,
	                		  method: 'POST',
	                		  success: function(response) {
	                			  var res = Ext.JSON.decode(response.responseText);
	                			  if(res==0){
	                				  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_NOT_ENIQUE'));//Please select a record
	                			  }else if(res==1){
		                              showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANT_CHANGE_PROGRAM_DELETE_SG_APPOINTMENT_FIRST'));
	                              } else{	
	                				  Ext.Ajax.request({
	                                      type : 'rest',
	                                      url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+sId.id,
	                                      //jsonData : jsonData,
	                                      //data: jsonData,
	                                      method : 'GET',
	                                      success : function(form, action) {
	                                      var data = Ext.JSON.decode(form.responseText);
	                                      	//console.log(data);
	                                      	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
	                                  		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
	                                  			programIntake.setValue(data[0].programIntakeCombo); 
	                                  		}
	                                      }
	                                  });
	                				  
	                				  showSuccessMessage(getCommonTranslation('ADMISSION_TITLE'),getCommonTranslation('SUCCESS'));
	                			  }
	                			  formWindow.close();
	                			  grdStore.reload();
	                			  $this.cancelAdmissionDetail();
	                			 
	                		  }
	                	  });

	                  },
	                  onAdmissionFormRender : function(){
	                	  var commonForm = this.getEnquirytabstructure().getForm();
	                	  var commonVal = commonForm.getValues();
	                	  var enquiryId = commonVal.enqId;
	                	  var studentDetailId = commonVal.studentDetailId;  

	                	  var grid = this.getAdmissionreqmntdetailgrid();

	                	  var store = grid.getStore();
	                	  store.getProxy().extraParams = {
	                		  id: studentDetailId
	                	  };
	                	  store.load();
	                  },
	                  getLocationDropDown : function (){

	                  },
	                  getIdValueJson: function(id, value) {
	                	  if (id) return {
	                		  id: id,
	                		  value: value
	                	  };
	                  },
	                  setGridBtnHideShow: function(grid,check,buttonId){
	                	  if(buttonId!= 'View'){
	                		  grid.down('#btnAdd').setVisible(check);
	    					  grid.down('#btnEdit').setVisible(check);
	    					  grid.down('#btnView').setVisible(check);
	    					  grid.down('#btnDelete').setVisible(check); 
	    					  var btnToolBar =  grid.query('toolbar')[0];
	    					  btnToolBar.query('#btnExportToPDF')[0].setVisible(check); 
	    					  btnToolBar.query('#btnExportToExcel')[0].setVisible(check);   
	                	  }
	                  },
	                  HideGridBtnInPlacementEnquiry: function(grid,check,buttonId){
	                	  if(buttonId!= 'View'){
	                		  if(grid.xtype=='admissionreqmntdetailgrid'){
	                			  grid.down('#btnAdd').setVisible(check);
	                			  grid.down('#btnEdit').setVisible(check);
	                			  grid.down('#btnView').setVisible(check);
	                			  grid.down('#btnDelete').setVisible(check); 
	                			  var btnToolBar =  grid.query('toolbar')[0];
	                			  btnToolBar.query('#btnExportToPDF')[0].setVisible(check); 
	                			  btnToolBar.query('#btnExportToExcel')[0].setVisible(check);   
	                		  }
	                	  }
	                  }
	                
});
