/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.controller.enquiry.student.StudentDetailRevampController', {
	extend : 'Academia.controller.enquiry.EnquiryRevampController',
	models : ['enquiry.studentDetail.StudentDetailModel',
	          'enquiry.studentDetail.StudentAddressModel'],
	          
	stores : ['enquiry.studentDetail.GenderStore', 'enquiry.studentDetail.BloodGroupStore','enquiry.ReferredIdStore','enquiry.ReferredIdStore2',
	          'enquiry.ReferredIdStore3','enquiry.ReferredIdStore4',
            'enquiry.studentDetail.ReservationCategoryStore','organization.CountryRegionStore1',
            'enquiry.studentDetail.IncomeSlabStore','enquiry.studentDetail.StudentAddressStore','common.NationalityStore',
            'organization.AddressTypeStore','organization.CityStore', 'organization.CountryRegionStore','organization.CityByCountryRegion',
            'admission.manageForm.StudentWithOutAL','criteriabuilder.userquicksearch.QuickSearchCode','common.RelationshipStore'],
            
	views : [ 'enquiry.student.StudentDetailStructure','enquiry.student.StudentDetailFormRevamp',
              'enquiry.student.StudentAddressFormWindow','enquiry.student.StudentAddressGrid'],
              
    alias : "widget.studentdetailrevampcontroller",
    
              refs : [{
            	  ref : 'enquirytabstructure',
            	  selector : 'enquirytabstructure'
              },{
            	  ref : 'studentdetailformrevamp',
            	  selector : 'studentdetailformrevamp'
              },{
            	  ref: 'studentAddress',
            	  selector: 'studentaddress[itemId=studentaddressRevempId] form'
              },{
              	ref:'searchresultgrid',
            	selector:'searchresultgrid[itemId=trackenquirygrid]'
              },{
            	  ref: 'studentaddress',
            	  selector: 'studentaddress[itemId=studentaddressRevempId]'   
              },{
            	  ref: 'studentaddressgrid',
            	  selector: 'studentaddressgrid'  		  
              },{
            	  ref: 'customfieldform',
            	  selector: 'customfieldform'  		  
              }],
              
              init : function() {

            	  this.control({
            		  'studentdetailformrevamp button[itemId=studentdetail_submitbuttonId]':{
            			  click:this.saveStudentDetail
            		  },
            		  'studentdetailformrevamp button[itemId=studentdetail_cancelbuttonId]':{
            			  click:this.cancelStudentDetail
            		  },
            		  'studentdetailformrevamp button[itemId=studentdetail_addressId]':{
            			  click:this.openStudentDetailAddress
            		  },
            		  'studentdetailformrevamp radiogroup[itemId=SD_radioBtn_F]':{
            			  change:function(f){
            				  this.checkFatherEmployee(f);
            			  }
            		  },
            		  
               		  'studentdetailformrevamp livesearchcombo[itemId=studentDetails_memployeeIdF]':{
               			select:function(combo,data){
            				  this.setFatherEmployeeDetails(combo,data);
            			  }
            		  },
            		  
            		  'studentdetailformrevamp radiogroup[itemId=SD_radioBtn_M]':{
            			  change:function(f){
            				  this.checkMotherEmployee(f);
            			  }
            		  },
               		  
               		  'studentdetailformrevamp livesearchcombo[itemId=studentDetails_memployeeIdM]':{
               			select:function(combo,data){
            				  this.setMotherEmployeeDetails(combo,data);
            			  }
            		  },
            		  
            		  'studentdetailformrevamp radiogroup[itemId=SD_radioBtn_orgSiblling]':{
            			  change:function(radioGroup){
            				  this.checkOrgSiblling(radioGroup);
            			  }
            		  },
            		  'studentdetailformrevamp':{
            			  render:function(f){
            				  this.onStudentFormRender(f);
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressRevempId] button[itemId=studentWin_submitbuttonId]':{
            			  click:this.addStudentAddressRevemp
            		  },
            		  'studentaddress[itemId=studentaddressRevempId] combo[itemId=countryId]':{
            			select:function(f,r){
            			  var countryId=r[0].data.id;	  
//            			  var store = this.getStore('organization.CityStore');
            			  var store = this.getStore('organization.CountryRegionStore');
              				store.getProxy().extraParams = {
              					cid: countryId
              				};
              				store.load();
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressRevempId] combo[itemId=parentCountryRegionId]':{
            			  select:function(f,r){
            				  var countryRegionId=r[0].data.id;	  
            				  var store = this.getStore('organization.CityByCountryRegion');
            				  store.getProxy().extraParams = {
            					  id: countryRegionId
            				  };
            				  store.load();
            			  }
            		  },
            		  /*'studentaddress[itemId=studentaddressRevempId] combo[itemId=cityId]':{
              			select:function(f,r){
              			  var $this=this;
              			  var form = $this.getStudentAddress().getForm();
              			  var countryId=form.findField('country').getValue();
              			  var store = this.getStore('organization.CountryRegionStore');
                				store.getProxy().extraParams = {
                					cid: countryId
                				};
                				store.load();
              			  }
              		  },*/
              		  'studentaddress[itemId=studentaddressRevempId] combo[itemId=genericFieldId1]':{
                			select:function(f,r){
                			 var countryRegionId=r[0].data.id;
//                    	     var store = this.getStore('organization.CountryRegionStore1');
                			 var store = this.getStore('organization.CityByCountryRegion');
                  				store.getProxy().extraParams = {
                  					id: countryRegionId
                  				};
                  				store.load();
                			  }
                    		},
                    		
            		  'studentaddress[itemId=studentaddressRevempId] button[itemId=studentWin_cancelbuttonId]':{
            			  click:function(f){
            				  var addressWin = this.getStudentaddress();
            				  if (addressWin) {
								addressWin.close();
							}
            			  }
            		  },
            		  
            		  'studentdetailformrevamp button[itemId=btnAddRelationshipDetails]': {
            			  click : this.addRelationshipDetailContainer
            		  },
            		  
            		   'studentdetailformrevamp checkboxfield[itemId=relationshipCheckbox]': {
                       	change : function($this,data){
                       		var form = $this.up('studentdetailformrevamp');
                       		this.ShowHideOrganizationDetails(form,$this.getValue());
                       	}
                       },
                       'studentdetailformrevamp combo[itemId=relationshipStudent]':{
                  			select:this.setStudentRelatedDetails
                       },
                       'studentdetailformrevamp combo[itemId=relationshipUser]':{
                  			select:this.setEmployeeRelatedDetails
                       },
            		  
            		  
            		  'studentdetailformrevamp combo[itemId=relationShipField]':{
                 			change:function(combo,data){
              				  this.setRelationShipDetails(combo,data);
              			  }
                      },
            		  
            		  'studentaddress[itemId=studentaddressRevempId]':{
            			  render:function(){
            				  var $this = this;
            				 var form = $this.getStudentAddress();
            				 var addressType = form.down('#addressTypeId');
            				 addressType.store.load({
      		                    callback: function(rec, operation, success) {
      		                        if (success) {
      		                        	addressType.setValue(rec[0].data.id);
      		                        	$this.addressTypeStudent(rec[0].data.id);
      		                        }
      		                    }
      		                });
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressRevempId] combo[itemId=addressTypeId]':{
            			  select:function(){
            				  this.addressTypeStudent();
            			  }
            		  }
            	  });
              },
              
              
              setEmployeeRelatedDetails : function(obj,records){
      	        var this$ = this;
      	        var form = obj.up('studentdetailformrevamp');
      	        var userCode = records[0].get('value');
      	        if (!isNullOrEmpty(userCode)) {
      	        	var params = {
      	                userCode: userCode
      	            };
      	            this$.sendGetAjaxRequest(SERVERURL.VALIDATE_EMPLOYEE_ID, 'GET', params, function(option, success, response) {
      	            	if(success){
      	            		var data = Ext.decode(response.responseText);
      	            		if (!isEmpty(data)) {
      	            			form.down("#relationshipName").setValue(data.person.printName);
      	            			form.down("#relationshipMobileNo").setValue(data.person.mobileNumber);
      	            			form.down("#relationshipEmail").setValue(data.person.emailId);
      	            		}
      	            	}
      	            });
      	        }
          },
          setStudentRelatedDetails : function(obj,records){
          	var this$ = this;
          	var form = obj.up('studentdetailformrevamp');
          	var studentCode = records[0].get('studentCode');
          	if (!isNullOrEmpty(studentCode)) {
          		var params = {
          				studentCode: studentCode
          		};
          		this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
          			if(success){
          				var data = Ext.decode(response.responseText);
          				if (!isEmpty(data)) {
          					form.down("#relationshipName").setValue(data.person.printName);
          					form.down("#relationshipMobileNo").setValue(data.person.mobileNumber);
          					form.down("#relationshipEmail").setValue(data.person.emailId);
        					form.getForm().findField("birthDate").setValue(data.person.birthDate);
          				}
          			}
          		});
          	}
          },
              
              ShowHideOrganizationDetails  : function(form,checked){
             		var relationShipField = form.down("#relationShipField").getValue();
          		var relationshipStudent = form.down("#relationshipStudent");
          		var relationshipUser = form.down("#relationshipUser");
          		relationshipStudent.setVisible(false);
          		relationshipUser.setVisible(false);
          		if(!checked){
          			relationshipStudent.reset();
          			relationshipUser.reset();
          		}else{
          			switch (relationShipField) {
          			case 'BROTHER':
          				relationshipStudent.setVisible(true);
          				break;
          			case 'SISTER':
          				relationshipStudent.setVisible(true);
          				break;
          			case 'FATHER':
          				relationshipUser.setVisible(true);
          				break;
          			case 'MOTHER':
          				relationshipUser.setVisible(true);
          				break;
          			case 'GUARDIAN':
          				relationshipUser.setVisible(true);
          				break;
          			case 'LOCAL_GUARDIAN':
          				relationshipUser.setVisible(true);
          			}
          		}
          	},
              
              addRelationshipDetailContainer: function(bttn) {
                  var this$ = this;
                  var form = bttn.up('studentdetailformrevamp');
                  var panelItem = new Array();
                  panelItem.push({
                  	xtype:'panel',
          			layout:'vbox',
          			cls: 'panelNoSpace',
          			items:[{
          				xtype: 'fieldcontainer',        
          				width: 'auto',
          				layout: 'hbox',
          				defaults: {
          					labelAlign: 'top',
          					width: 226
          				},
          				items: [{
          					xtype: 'customcombobox',
          					fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
          					name: 'relationship',
          					valueField: 'name',
          					displayField: 'value',
          					itemId: 'relationShipFieldId',
          					store: 'common.RelationshipStore',
          					editable: false,
          					allowBlank: true,
          					listeners:{
          						change : function(obj,value){
          							this$.setMoreRelationShipDetails(obj,value);
          						}
          					}
          				},{
          					xtype: 'checkboxfield',
          					itemId: 'relationshipCheckboxId',
          					labelAlign: 'right',
          					boxLabel: getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'),
          					name: 'relationshipCheckbox',
          					inputValue: true,
          					uncheckedValue: false,
          					style:{marginTop:'23px'},
          					listeners : {
          						change : function(obj){
          							this$.ShowHideMoreOrganizationDetails(obj,obj.getValue());
          			        	}
          					}
          				},{
          					xtype: 'customcombobox',
          					name: 'relationshipStudent',
          					itemId: 'relationshipStudentId',
          					fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
          					store: 'admission.manageForm.StudentWithOutAL',
          					valueField: 'id',
          					hidden:true,
          					displayField: 'valueCode',
          					queryParam:'studentNameOrCode',
          					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
          					enableKeyEvents  : 'true',
          					minChars:3,
          					typeAhead:false,
          					forceSelection:true,
          					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
          					triggerAction: '',
          					hideTrigger:false,
          					listConfig: {
          						listeners: {
          							beforeshow: function(picker) {
          								picker.minWidth = picker.up('combobox').getSize().width;
          							}
          						},
          						loadingText: getCommonTranslation('SEARCHING'),
          						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
          						getInnerTpl: function() {
          							return '<div class="search-item">' +
          							'{studentCode} / {studentName}' +
          							'</div>';
          						}
          					},
          					listeners :{ 
          						select : function(obj,record){
          							this$.setMoreStudentRelatedDetails(obj,record);
          						}
          					}
          				},{
          					xtype: 'customcombobox',
          					name: 'relationshipUser',
          					itemId: 'relationshipUserId',
          					fieldLabel: getAdmissionTranslation('EMPLOYEE_NAME'),
          					store: 'criteriabuilder.userquicksearch.QuickSearchCode',
          					valueField: 'id',
          					displayField: 'value',
          					queryParam:'code',
          					minChars:3,
          					hidden:true,
          					typeAhead:false,
          					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
          					enableKeyEvents  : 'true',
          					hideTrigger:false,
          					//cls:'gridInputCustomStyle',
          					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
          					triggerAction: '',
          					forceSelection:true,
          					listConfig: {
          						listeners: {
          							beforeshow: function(picker) {
          								picker.minWidth = picker.up('combobox').getSize().width;
          							}
          						},
          						loadingText: getCommonTranslation('SEARCHING'),
          						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
          						getInnerTpl: function() {
          							return '<div class="search-item">' +
          							'{value}' +
          							'</div>';
          						}
          					},
          					listeners :{ 
          						select : function(obj,record){
          							this$.setMoreEmployeeRelatedDetails(obj,record);
          						}
          					}
          				},{
          					xtype:'hidden',
          					name:'personRelationshipsId'
          				},{
          					xtype:'hidden',
          					name:'personRelationshipsVersion'
          				}]
          			},{
                      xtype: 'fieldcontainer',
                      width: 'auto',
                      layout: {
                          type: 'hbox',
                          align: 'bottom'
                      },
                      defaults: {
          				labelAlign: 'top',
          				width: 226
          			},
                      items: [{
                      	xtype: 'textfield',
                      	name: 'relationshipName',
                      	itemId:'relationshipNameId',
          				fieldLabel: getAdmissionTranslation('NAME'), //Last Name       
          				allowBlank: true,
          				readOnly:true
          			},{
          				xtype : 'numberfield',
          				name: 'relationshipMobileNo',
          				itemId: 'relationshipMobileNoId',
          				hideTrigger: true,
          				mouseWheelEnabled:false,
          				maxLength: 10,
          				enforceMaxLength : true,
          				minValue:0,
          				readOnly:true,
          				fieldLabel : getAdmissionTranslation('MOBILE_NO')//Contact No.
          			}, {
          				xtype: 'textfield',
          				name: 'relationshipEmail',
          				vtype:'email',
          				readOnly:true, 
          				itemId: 'relationshipEmail',
          				fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID,
          			},{
          				xtype:'hidden',
          				name:'relatedPersonId'
          			},{
          				xtype:'hidden',
          				name:'relatedPersonVersion'
          			},{
                     	  xtype: 'button',
                           glyph: ICONGLYPH.DELETEGLYPH,
                           cls: 'CustomBodyBtnReject',
                           tooltip: getCommonTranslation('DELETETOOLTIP'),
                           width:35,
                           listeners:{
                               click:function(obj){
                               var name = obj.previousSibling().previousSibling().previousSibling().previousSibling().previousSibling();
                               name.validate();
                             	  var frm = obj.up('studentdetailformrevamp');
                             	  var receiptPanel = frm.down('#relationshipDetailsId');
                             	  var container = obj.up('panel');
                             	  receiptPanel.remove(container);
                                frm.doLayout();
                               }
                           }
                     }] 
          		}]
                  });
                  var receiptheaderPanel = form.down('#relationshipDetailsId');
                  receiptheaderPanel.add(panelItem);
                  form.doLayout();
              },
              
          	setRelationShipDetails : function(combo,data){
       		 var form = this.getStudentdetailformrevamp();
       	  Ext.suspendLayouts();
         
       		 var relationshipCheckbox = form.down("#relationshipCheckbox");
       		 relationshipCheckbox.reset();
       		var selectedValue = combo.getValue();
       		switch (selectedValue) {
       		case 'BROTHER':
       			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
       			break;
       		case 'SISTER':
       			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
       			break;
       		case 'FATHER':
       			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
       			break;
       		case 'MOTHER':
       			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
       			break;
       		case 'GUARDIAN':
       			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
       			break;
       		case 'LOCAL_GUARDIAN':
       			relationshipCheckbox.setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
       		}
       			this.setEditableField(form,selectedValue);
       		 Ext.resumeLayouts();
       	},
       	setMoreRelationShipDetails : function(combo,data){
      		 var form = this.getStudentdetailformrevamp();
      		 var relationshipCheckbox = combo.nextSibling();
      		 relationshipCheckbox.reset();
      		var selectedValue = combo.getValue();
      		switch (selectedValue) {
      		case 'BROTHER':
      			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
      			break;
      		case 'SISTER':
      			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
      			break;
      		case 'FATHER':
      			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
      			break;
      		case 'MOTHER':
      			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
      			break;
      		case 'GUARDIAN':
      			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
      			break;
      		case 'LOCAL_GUARDIAN':
      			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
      		}
      		this.setMoreEditableField(combo,selectedValue);
      	},
              
              setMoreEmployeeRelatedDetails : function(obj,records){
      	        var this$ = this;
      	        var form = obj.up('studentdetailformrevamp');
      	        var userCode = records[0].get('value');
      	        if (!isNullOrEmpty(userCode)) {
      	        	var params = {
      	                userCode: userCode
      	            };
      	            this$.sendGetAjaxRequest(SERVERURL.VALIDATE_EMPLOYEE_ID, 'GET', params, function(option, success, response) {
      	            	if(success){
      	            		var data = Ext.decode(response.responseText);
      	            		if (!isEmpty(data)) {
      	            			var containers = obj.ownerCt.nextSibling();
      	            			containers.items.items[0].setValue(data.person.printName);
      	    					containers.items.items[1].setValue(data.person.mobileNumber);
      	    					containers.items.items[2].setValue(data.person.emailId);
      	            		}
      	            	}
      	            });
      	        }
          },
              
              
              setMoreStudentRelatedDetails : function(obj,records){
              	var this$ = this;
              	var form = obj.up('studentdetailformrevamp');
              	var studentCode = records[0].get('studentCode');
              	if (!isNullOrEmpty(studentCode)) {
              		var params = {
              				studentCode: studentCode
              		};
              		this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
              			if(success){
              				var data = Ext.decode(response.responseText);
              				if (!isEmpty(data)) {
              					var containers = obj.ownerCt.nextSibling();
              					containers.items.items[0].setValue(data.person.printName);
              					containers.items.items[1].setValue(data.person.mobileNumber);
              					containers.items.items[2].setValue(data.person.emailId);
              				}
              			}
              		});
              	}
              },  
              
          	ShowHideMoreOrganizationDetails  : function(obj,checked){
        		var form = this.getStudentdetailformrevamp();
           		var relationShipField = obj.previousSibling().getValue();
        		var relationshipStudent = obj.nextSibling();
        		var relationshipUser = obj.nextSibling().nextSibling();
        		relationshipStudent.setVisible(false);
        		relationshipUser.setVisible(false);
        		if(!checked){
        			relationshipStudent.reset();
        			relationshipUser.reset();
        		}else{
        			switch (relationShipField) {
        			case 'BROTHER':
        				relationshipStudent.setVisible(true);
        				break;
        			case 'SISTER':
        				relationshipStudent.setVisible(true);
        				break;
        			case 'FATHER':
        				relationshipUser.setVisible(true);
        				break;
        			case 'MOTHER':
        				relationshipUser.setVisible(true);
        				break;
        			case 'GUARDIAN':
        				relationshipUser.setVisible(true);
        				break;
        			case 'LOCAL_GUARDIAN':
        				relationshipUser.setVisible(true);
        			}
        		}
        	},
        	
        	setEditableField : function(form,selectedValue){
        		
        		var relationshipName = form.down('#relationshipName');
        		var relationshipMobileNo = form.down('#relationshipMobileNo');
        		var relationshipEmail = form.down('#relationshipEmail');
        		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
        		relationshipName.labelSeparator='';
        		
        		if(!isNullOrEmpty(selectedValue)){
        			relationshipName.setReadOnly(false);
        			relationshipMobileNo.setReadOnly(false);
        			relationshipEmail.setReadOnly(false);
        			relationshipName.allowBlank=false;
        			relationshipName.setFieldLabel(getAdmissionTranslation('NAME')+allowblankFalse);
        		}else{
        			relationshipName.setReadOnly(true);
        			relationshipMobileNo.setReadOnly(true);
        			relationshipEmail.setReadOnly(true);
        			relationshipName.allowBlank=true;
        			relationshipName.setFieldLabel(getAdmissionTranslation('NAME'));
        		}
        		relationshipName.validate();
        	},
             /* setMoreRelationShipDetails : function(combo,data){
            		 var form = this.getStudentdetailformrevamp();
            		 var relationshipCheckbox = combo.nextSibling();
            		 relationshipCheckbox.reset();
            		var selectedValue = combo.getValue();
            		switch (selectedValue) {
            		case 'BROTHER':
            			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
            			break;
            		case 'SISTER':
            			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_SIBLING_OF_ACADEMY'));
            			break;
            		case 'FATHER':
            			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
            			break;
            		case 'MOTHER':
            			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
            			break;
            		case 'GUARDIAN':
            			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
            			break;
            		case 'LOCAL_GUARDIAN':
            			combo.nextSibling().setBoxLabel(getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'));
            		}
            		this.setMoreEditableField(combo,selectedValue);
            	},*/

              openStudentDetailAddress : function(){

            	  var formWindow = this.getStudentaddress();
            	  if (!formWindow) {
            		  Ext.widget('studentaddress',{
              			  itemId:'studentaddressRevempId'
              		  });
            		  formWindow = this.getStudentaddress();
            	  }
            	  formWindow.show();
              },
              saveStudentDetail:function(f){
            	  var $this= this;
            	  var form = f.ownerCt.ownerCt.getForm();
                  var val = form.getValues();
            	  var studentModel = new Academia.model.enquiry.studentDetail.StudentDetailModel(val);
            	 
            	  studentModel.set("id", Ext.getCmp('studentDetails_id').getValue());
            	  studentModel.set("whetherDeleted",false);
            	  
            	  var grid = this.getStudentaddressgrid();
            	  var store = grid.getStore();
            	  var myItems = store.getRange();

            	  if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
            		  studentModel.data.salutation =  {"id":1};
            		  studentModel.data.reservationCategory.id = 1;
            	  }
            	  
            	  var myjson = [];
            	  for(var i in myItems){
            		  myjson.push({
            			  "id":'',
            			  "address":{
            				  "addressType" : myItems[i].get('addressType'),
            				  "addressText" : myItems[i].get('addressText'),
            				  "country" : myItems[i].get('country'),
            				  "city" : myItems[i].get('city'),
            				  "parentCountryRegion" : myItems[i].get('parentCountryRegion'),
            				  "countryRegion" : myItems[i].get('countryRegion'),			
            				  "phoneCountryCode" : myItems[i].get('phoneCountryCode'),
            				  "phoneAreaCode" : myItems[i].get('phoneAreaCode'),
            				  "phoneNo" : myItems[i].get('phoneNo'),
            				  "cellCountryCode" : myItems[i].get('cellCountryCode'),
            				  "cellNo" : myItems[i].get('cellNo'),
            				  "primaryEmailId" :  myItems[i].get('primaryeEmailId'),
            				  "alternateEmailId" : myItems[i].get('alternateEmailId')
            			  }
            			  });
            		  }
            		  this.deleteEmptyFields(studentModel.data);
            		  var submitData = Ext.encode(studentModel.data);
            		  var submitUrl =  SERVERURL.ENQUIRY_STUDENT_DETAIL_UPDATE;
            		  Ext.Ajax.request({
            			  url: submitUrl,
            			  jsonData: submitData,
            			  method: 'POST',
            			  success: function(response) {
            				  var grid=$this.getSearchresultgrid();
            	              grid.getStore().reload();
            				  showSuccessMessage(getCommonTranslation('ENQUIRY_TITLE'),getCommonTranslation('SUCCESS'));
            			  }
            		  });
            	  },
            	  
            	  deleteEmptyFields:function(object){
            		  for (var property in object) {
            			  if(isNullOrEmpty(object[property])){
            				  delete object[property];
            			  }
            			}
            	  },
            	  
            	  cancelStudentDetail:function(){
            		  var form = this.getstudentdetailformrevamp().getForm();
            		  form.reset();
            	  },
            	  
            	  checkFatherEmployee : function(radioGroup){
            		  var siblingDetailsComponent = radioGroup.up('studentdetailformrevamp').down('#studentDetails_memployeeIdF');
            		  siblingDetailsComponent.setVisible(radioGroup.getValue().fatherEmployed);
            	  },
            	  
            	  setFatherEmployeeDetails : function(combo,data){
            		  
            		  var fatherDetailsContainer = combo.up('studentdetailformrevamp').down('#fatherDetailsContainer');
            		  var fatherFirstName=data[0].get('firstName');
            		  var fatherMiddleName=data[0].get('middleName');
            		  var fatherLastName=data[0].get('lastName');
            		  
            		  fatherDetailsContainer.down('#studentDetails_fatherFirstName').setValue(fatherFirstName);
            		  fatherDetailsContainer.down('#studentDetails_fatherMiddleName').setValue(fatherMiddleName);
            		  fatherDetailsContainer.down('#studentDetails_fatherLastName').setValue(fatherLastName);
            	  },
            	  
            	  setMotherEmployeeDetails : function(combo,data){
            		  
            		  var fatherDetailsContainer = combo.up('studentdetailformrevamp');
            		  var motherFirstName=data[0].get('firstName');
            		  var motherMiddleName=data[0].get('middleName');
            		  var motherLastName=data[0].get('lastName');
            		  
            		  fatherDetailsContainer.down('#studentDetails_motherFirstName').setValue(motherFirstName);
            		  fatherDetailsContainer.down('#studentDetails_motherMiddleName').setValue(motherMiddleName);
            		  fatherDetailsContainer.down('#studentDetails_motherLastName').setValue(motherLastName);
            	  },
            	  
            	  checkMotherEmployee : function(radioGroup){
            		  var siblingDetailsComponent = radioGroup.up('studentdetailformrevamp').down('#studentDetails_memployeeIdM');
            		  siblingDetailsComponent.setVisible(radioGroup.getValue().motherEmployed);
            	  },
            	  
            	  checkOrgSiblling : function(radioGroup){
            		  var siblingDetailsComponent = radioGroup.up('studentdetailformrevamp').down('#siblingDetailsComponent');
            		  siblingDetailsComponent.setVisible(radioGroup.getValue().whetherSiblingStudying);
            	  },
            	  onStudentFormRender:function(form){
            		  var this$ = this;
            		  var studentStructure = this$.getEnquirytabstructure();
            		  var commonForm = this$.getEnquirytabstructure().getForm();
            		  var commonVal = commonForm.getValues();
            		  var enquiryType = commonVal.enqTypes;
            		  var studentDetailId = commonVal.studentDetailId;
            		  var buttonId = commonVal.buttonType;
            		  
                  	  if(buttonId == 'View'){
                  		form.down('#studentdetail_submitbuttonId').setVisible(false);
                  		form.down('#studentdetail_cancelbuttonId').setVisible(false);
                  		form.down('#studentdetail_addressId').setVisible(false);
                  	 }
            		  if(enquiryType!='Admission'){
            			  studentStructure.setDisabled(true);
            		  }else{

            			  if(studentDetailId > 0){
            				  Ext.Ajax.request({
            					  method: 'GET',
            					  // changed by utsav, bcoz above was getting student detail record on the basis of enquiry which is wrong
            					  // it should be on the basis of studentId
            					  //url: SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL,
            					  url: SERVERURL.ENQUIRY_STUDENT_DETAIL_BYID,
            					  params:{id:studentDetailId},
            					  success: function(response) {
            						  if(response.responseText!=null &&  response.responseText!=""){
            							  var data = Ext.decode(response.responseText);
            							  var enquiryStudentDetail = new Academia.model.enquiry.studentDetail.StudentDetailModel(data);
            		                      form.getForm().loadRecord(enquiryStudentDetail);

            		                      /*   remove later after test
            		                      var cd = data.customData[0];
            							  console.log(cd);
            							  enquiryStudentDetail.set("customFieldData",cd);*/
            							  Ext.getCmp('studentDetails_id').setValue(data.id);
            							  Ext.getCmp('studentDetails_enquiryId').setValue(data.enquiry.id);
	      								//  Ext.getCmp('studentDetails_registeredByType').setValue(data.registeredByType);
        								  Ext.getCmp('studentDetails_gender').setValue(data.gender);
        								  //Ext.getCmp('studentDetails_studentDateOfBirth').setValue(dateRender(data.studentDateOfBirth));
        								  form.down('#studentDetails_studentDateOfBirth').setValue(dateRender(data.studentDateOfBirth));
        								  
        								  // Read only true for this field
//        								  Ext.getCmp('studentDetails_registeredByType').setReadOnly(true);
        								  try{
        									  var reservationCategoryId = data.reservationCategory.id;
        									  var incomeslabId = data.incomeSlabs.id;
        								  }catch(e){
        								  }
        								  var IncomeStore = this$.getStore('enquiry.studentDetail.IncomeSlabStore');
        								  IncomeStore.load({
        									  callback: function(record, operation, success) {
        										  if (success) {
        											  Ext.getCmp('studentDetails_incomeSlabs').setValue(incomeslabId);
        										  }
        									  }
        								  });
        								  
        								  var reservationCategory = this$.getStore('enquiry.studentDetail.ReservationCategoryStore');
        								  reservationCategory.load({
        									  callback: function(record, operation, success) {
        										  if (success) {
        											  Ext.getCmp('studentDetails_reservationCategory').setValue(reservationCategoryId);
        										  }
        									  }
        								  });
        								  
        								  /*var registerByType = this$.getStore('enquiry.EnquiryRegisteredBy');
        								  registerByType.load({
        									  callback: function(record, operation, success) {
        										  if (success) {
        											  Ext.getCmp('studentDetails_registeredByType').setValue(data.registeredByType);
        										  }
        									  }
        								  });*/
        								  var Salutation = this$.getStore('common.SalutationStore');
        								  Salutation.load({
        									  callback: function(record, operation, success) {
        										  if (success) {
        											  Ext.getCmp('studentDetails_salutation').setValue(data.salutation);
        										  }
        									  }
        								  });
            						  }
            					  }
            				  });
            			  }
            		  }
            	  },
            	  addStudentAddressRevemp : function (){
            		  var $this = this;
            		  var form = this.getStudentAddress().getForm();
            		  var values = form.getValues();
                      var studentId=Ext.getCmp('studentDetails_id').getValue();
                      var dataModel=new Academia.model.enquiry.studentDetail.StudentAddressModel();
                     
                      dataModel.set('id',values.addressId);
                      dataModel.set('version',values.version);
                      dataModel.set('addressText',values.addressText);
                      dataModel.set('country',$this.getIdValueJson(values.country));
                      dataModel.set('parentCountryRegion',$this.getIdValueJson(values.parentCountryRegion));
                      dataModel.set('city',$this.getIdValueJson(values.city));
                      dataModel.set('pincode',values.pincode);
                      dataModel.set('cellCountryCode',values.cellCountryCode);
                      dataModel.set('cellNo',values.cellNo);
                      dataModel.set('phoneCountryCode',values.phoneCountryCode);
                      dataModel.set('phoneAreaCode',values.phoneAreaCode);
                      dataModel.set('phoneNo',values.phoneNo);
                      dataModel.set('primaryeEmailId',values.primaryeEmailId);
                      dataModel.set('alternateEmailId',values.alternateEmailId);
                      dataModel.set('addressType',$this.getIdValueJson(values.addressType));
                      dataModel.set('countryRegion',$this.getIdValueJson(values.countryRegion));
                      dataModel.set('salutation',values.salutation);
                      var data={
                    		  "id":parseInt(values.id),
                    		  "addressTypeId":parseInt(values.addressType),
                    		  "studentDetailId":parseInt(studentId),
                    		  "address":dataModel.data,
                    		  "enquiryStudentDetail":$this.getIdValueJson(parseInt(studentId))
                               };
                      
                      Ext.Ajax.request({
    					  method: 'POST',
    					  url: SERVERURL.CREATE_ADDRESS_URL,
    					  jsonData:data,
    					  success: function(response) {
    						  showSuccessMessage(getCommonTranslation('ENQUIRY_ADDRESS'),getCommonTranslation('SUCCESS'));
    					    }
    					  });
            		  $this.getStudentaddress().close();
            	  },
            	  getIdValueJson: function(id, value) {
            		  if (id) return {
            			  id: id,
            			  value: value
            		  };
            	  },
            	  addressTypeStudent:function(renderId){
     				 var $this=this;
     				 var form = $this.getStudentAddress().getForm();
     				 var addressType = form.findField('addressType');
     				 var addId = form.findField('addressType').getValue();
     				 //console.log('addId',addId);
     				//console.log('renderId',renderId);
     				 var addressId; 
     				 if(renderId!=undefined && renderId !="" && renderId !=null){
     					addressId = renderId; 
     				 }else{
     					addressId = addId;
     				 }
     				 /*addressType.store.load({
     		                    callback: function(rec, operation, success) {
     		                        if (success) {
     		                        	addressType.setValue(addId);
     		                        }
     		                    }
     		                });*/
	            		  
     				 var studentId=Ext.getCmp('studentDetails_id').getValue();
     				  
     				  Ext.Ajax.request({
             			  url: SERVERURL.SELECT_ADDRESS_TYPE_URL,
             			  method: 'GET',
             			  params:{
             				  studentDetailId:studentId,
             				  addressTypeId:addId
             			  },
             			  success: function(f) {
             				if(f.responseText){
             				var  jData=Ext.JSON.decode(f.responseText);
             				//console.log('jData',jData);
             				var dataModel=new Academia.model.enquiry.studentDetail.StudentAddressModel(jData.address);
             				form.loadRecord(dataModel);
             				if(isNullOrEmpty(dataModel.data.country)){
             					form.findField('country').reset();
             					form.findField('addressText').reset();
             					form.findField('parentCountryRegion').reset();
             					form.findField('city').reset();
             				}
             				
             				if(jData.id!=null){
             					form.findField('id').setValue(jData.id);
             				}
             				if(jData.address!=null){
             					form.findField('addressId').setValue(jData.address.id);
             				}
             				
             				if(jData.enquiryStudentDetail!=null){
             					form.findField('enquiryStudentDetailId').setValue(jData.enquiryStudentDetail.id);
             				}
             				if(jData.address.version!=null){
             					form.findField('version').setValue(jData.address.version);
             				}

             				var addressTypeCombo=Ext.ComponentQuery.query('combo#addressTypeId')[0];
       						if(dataModel.data.addressType!=null){
       						addressTypeCombo.store.load({
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	addressTypeCombo.setValue(dataModel.data.addressType.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.country!=null){
       						var countryCombo=form.findField('country');
       						countryCombo.store.load({
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	countryCombo.setValue(dataModel.data.country.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.parentCountryRegion !=null && dataModel.data.city!=null){
       						var cityCombo=form.findField('city');
       						cityCombo.store.load({
       							params:{
//       								id:dataModel.data.country.id
       								id:dataModel.data.parentCountryRegion.id
       							},
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	cityCombo.setValue(dataModel.data.city.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.country!=null && dataModel.data.parentCountryRegion!=null){
       						var parentCountryRegionCombo=form.findField('parentCountryRegion');
       						parentCountryRegionCombo.store.load({
       							params:{
       								cid:dataModel.data.country.id
       							},
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	parentCountryRegionCombo.setValue(dataModel.data.parentCountryRegion.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.parentCountryRegion!=null && dataModel.data.countryRegion!=null){
       						var countryRegionCombo=form.findField('countryRegion');
       						countryRegionCombo.store.load({
       							params:{
       								pid:dataModel.data.parentCountryRegion.id
       							},
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	countryRegionCombo.setValue(dataModel.data.countryRegion.id);
       		                        }
       		                    }
       		                });
       						}
             		     }
             			}
             		  });
            	   }
              });
