/**
 * @author Aman
 * @description Controller for Exam Block Listing
 */
Ext.define('Academia.controller.examblock.ExamBlockController', {
    extend: 'Academia.controller.base.BaseController',

    views: [
        'examblock.ExamBlockFilter',
        'examblock.ExamBlockListingGrid',
        'examexecution.ExamBlockStructure',
        'assessmentSchedule.AssessmentScheduleExternalStruct', // Internal Structure
        'assessmentSchedule.ExamBlockAddForm',
		'baselayout.contentarea.ContentPanel'
    ],

    models: [
        'examBlock.ExamBlockModel'
    ],

    stores: [
        'assessmentSchedule.examCodeNameStore',
        'assessmentSchedule.examBlockCenterStore',
		'examinationcenters.evaluationgrouplisting.centerallocation.CenterNameStoreForBlock',
		'assessmentSchedule.examBlockGridStore'
    ],

    refs: [{
            ref: 'examblockfilter',
            selector: 'examblockfilter'
        },
        {
            ref: 'examblocklistinggrid',
            selector: 'examblocklistinggrid'
        },
        {
            ref: 'examrblockstructure',
            selector: 'examrblockstructure'
        },
        {
            ref: 'assessmentscheduleexternalstruct',
            selector: 'assessmentscheduleexternalstruct'
        },
		{
			ref: 'examblockaddform',
			selector: 'examblockaddform'
		}, {
			ref: 'contentPanel',
			selector: 'contentPanel'
		}
	],

    init: function() {
        this.control({
            'examrblockstructure': {
                render: this.onRegStructRender
            },
            'examblocklistinggrid button[itemId=btnAdd]': {
                click: this.openNewExamBlockTab
            },
			
			'examblocklistinggrid':{
			            	afterrender: function(grid){
			            		grid.getStore().removeAll();
			            	}},
			
			'examblockaddform button[itemId=examBlockSaveBtn]': {
			    click: this.saveUpdateExamBlock
			},
						
            'examblocklistinggrid button[itemId=btnEdit]': {
                click: this.loadDataOnEditWindow
            },
            'examblocklistinggrid button[itemId=btnDelete]': {
                click: this.deleteGridData
            },
			
			'examblockfilter button[itemId=searchBtn]': {
			    click: this.searchExamBlock
			},
			

			'examblockfilter button[itemId=resetBtn]': {
			    click: function(btn) {
			        var form = btn.up('form');
			        form.getForm().reset();      
			        var grid = Ext.ComponentQuery.query('examblocklistinggrid')[0];
			        // grid.getStore().load(); 
			    }
			}
			,
			'examblockfilter combobox[name=examBlockId]': {
			    select: this.onExamBlockSelect
			},
			
            'examblocklistinggrid button[itemId=btnView]': {
                click: function(btn) {
                    this.loadDataOnEditWindow(btn);
                    var form = this.getExamblockaddform();
                    if (form) {
                        form.down('#examBlockSaveBtn').setVisible(false);
                        form.down('#examBlockResetBtn').setVisible(false);
                        toggleReadOnlyFormItems(form.getForm(), true);
                    }
                }
            }
        });
    },
	
	searchExamBlock: function () {
	    var form  = this.getExamblockfilter().getForm(),
	        params = form.getValues(),
	        grid   = this.getExamblocklistinggrid(),
	        store  = grid.getStore();

	    var dto = {
	        id: params.examBlockId || null,
	        examCenterId: params.examCenterId || null,
	        fromDate: params.fromDate || null,
	        tillDate: params.toDate || null,
	        status: params.status || null,
			page:1,
			sort:null,
			limit:100
	    };

	    Ext.Ajax.request({
	        url: SERVERURL.PATH_EXAM_BLOCK_GRID_DATA,
	        method: 'POST',
	        jsonData: dto,

	        success: function(resp){
	            var json = Ext.decode(resp.responseText);

	            // RESET STORE
	            store.removeAll();

	            // LOAD ARRAY DIRECTLY 🔥
	            store.loadData(json.rows);

	            // PAGING FIX (optional)
	            store.totalCount = json.total || json.rows.length;
	        }
	    });
	},

	
	onExamBlockSelect: function (combo, rec) {
	    var filter = this.getExamblockfilter(),
	        blockId = rec[0].data.id,
	        centreCombo = filter.down('combobox[name=centreId]'),
	        store = centreCombo.getStore();

	    centreCombo.setDisabled(false);

	    store.proxy.extraParams = { examBlockId: blockId };

	    store.load();
	} ,
	
	saveUpdateExamBlock: function () {
	    var form = this.getExamblockaddform().getForm(),
	        v = form.getValues(),
	        exam = { data: {} };

	    exam.set = function (k, val) {
	        exam.data[k] = val;
	    };

	    exam.set("id", v.id);
	    exam.set("code", v.code);
	    exam.set("name", v.name);
	    exam.set("examCenterId", v.examCenterId);
	    exam.set("fromDate", v.fromDate);
	    exam.set("tillDate", v.tillDate);
	    exam.set("studentCanSelectCenter", v.studentCanSelectCenter);
	    exam.set("onlineExamApplicable", v.onlineExamApplicable);

	    var url = (!form.findField('id').getSubmitValue())
	        ? SERVERURL.PATH_EXAM_BLOCK_CREATE
	        : SERVERURL.PATH_EXAM_BLOCK_UPDATE;

	    Ext.Ajax.request({
	        type: 'rest',
	        url: url,
	        jsonData: Ext.encode(exam.data),
	        method: 'POST',
	        
			success: function () {
			    Ext.getBody().unmask();

			    showSuccessMessage(
			        getExaminationTranslation('EXAM_BLOCK'),
			        getExaminationTranslation('EXAM_BLOCK_SUCCESS_MSG')
			    );

			    form.reset();

			  //   this.getExamblocklistinggrid().getStore().reload();

			    var contentpanel = this.getContentPanel(),
			        nav = this.getController('menu.CoreERPNavigationController'),
			        tabName = getExaminationTranslation('MANAGE_EXAM_BLOCK'),
			        tab = nav.getTab(tabName);

			    if (tab) {
			        contentpanel.remove(tab, true);
			    }
			},
			 
			scope: this
	    });
	}
,
		
	onRegStructRender: function() {
        var grid=this.getExamblocklistinggrid();
		grid.getStore().removeAll();
    },

	openNewExamBlockTab: function() {
	    var contentpanel = this.getContentPanel(),
	        tabName = getExaminationTranslation('MANAGE_EXAM_BLOCK');

	    var newTab = Ext.widget('examblockaddform');
		/**
		 * This is to remove tab from content panel and open same tab again 
		 */
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
	    openTab(contentpanel, tabName, newTab, CONSTANTS.MENU_COLOR_FOUR);

	    // IMPORTANT - deselect grid
	    var grid = this.getExamblocklistinggrid();
	    if (grid) {
	        grid.getSelectionModel().deselectAll();
	    }

	    // Reset exam center combo
	    var combo = newTab.down('combobox[name=examCenterId]');
	    if (combo) {
	        combo.reset();
	        combo.getStore().removeAll();
	        combo.getStore().load();
	    }

	    // Show reset button for ADD
	    var resetBtn = newTab.down('#examBlockResetBtn');
	    if (resetBtn) {
	        resetBtn.setVisible(true);
	    }
	},

	loadDataOnEditWindow: function() {
	    var grid = this.getExamblocklistinggrid(),
	        selection = grid.getSelectionModel().getSelection();

	    if (selection.length === 0) {
	        showWarningMessage(
	            getCommonTranslation('ALERT'),
	            getCommonTranslation('PLEASE_SELECT_RECORD')
	        );
	        return;
	    }

	    this.openNewExamBlockTab(); // just opens the form

	    var record = selection[0],
	        form = this.getExamblockaddform(),
	        examForm = form.getForm();

	    // Hide reset button in edit
	    form.down('#examBlockResetBtn').setVisible(false);

	    Ext.Ajax.request({
	        url: SERVERURL.EXAM_BLOCK_FIND_BY_ID,
	        method: 'GET',
	        params: { examBlockId: record.get('id') },
	        success: function(resp) {
	            var jData = Ext.decode(resp.responseText);

	            examForm.setValues(jData);

	            // convert timestamp to Date object
	            function toDate(val) {
	                return val ? new Date(parseInt(val)) : null;
	            }

	            var fromField = examForm.findField('fromDate');
	            if (fromField && jData.fromDate) {
	                fromField.setValue(toDate(jData.fromDate));
	            }

	            var tillField = examForm.findField('tillDate');
	            if (tillField && jData.tillDate) {
	                tillField.setValue(toDate(jData.tillDate));
	            }

	            var centerField = examForm.findField('examCenterId');
	            if (centerField) {
	                centerField.getStore().load({
	                    callback: function() {
	                        centerField.setValue(jData.examCenterId);
	                    }
	                });
	            }
	        }
	    });
	},

	deleteGridData: function () {
	    var me   = this,
	        grid = me.getExamblocklistinggrid(),
	        sel  = grid.getSelectionModel().getSelection();

	    if (!sel.length) {
	        showWarningMessage(
	            getCommonTranslation('ALERT'),
	            getCommonTranslation('PLEASE_SELECT_RECORD')
	        );
	        return;
	    }

	    var id = sel[0].get('id');

	    showConfirmMessage(
	        getExaminationTranslation('EXAM_BLOCK'),
	        getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	        function(btn) {
	            if (btn === 'yes') {
	                Ext.Ajax.request({
	                    method: 'DELETE',
						url: SERVERURL.PATH_EXAM_BLOCK_DELETE+'?id='+id,
						success: function(resp) {
	                        var msg = resp.responseText + '';

	                        if (msg === 'SUCCESS') { // 🔥 SUCCESS expected
								grid.getStore().removeAll();
	                            showSuccessMessage(
	                                getExaminationTranslation('EXAM_BLOCK'),
	                                getExaminationTranslation('EXAM_BLOCK_DELETED_MSG')
	                            );
	                        } else {
	                            showWarningMessage(
	                                getExaminationTranslation('EXAM_BLOCK'),
	                                getCommonTranslation('RECORD_CANNOT_BE_DELETED_AS_IT_IS_USED_AS_A_REFERENCE')
	                            );
	                        }
	                    }
	                });
	            }
	        }
	    );
	} 
});