/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define(
				'Academia.controller.examinationcenters.ExaminationCentersController',
				{
					//extend : 'Ext.app.Controller',
					extend : 'Academia.controller.base.BaseController',
					models : [ 'genericmodels.dropdowns.EnumCombo',
							'examinationcenters.ExaminationCenter',
							'examinationcenters.RoomGridBlank',
							'examinationcenters.AddressModelBlank',
							'common.IdValueCodeDataModel' ],
					stores : [ 'examinationcenters.CenterType',
							'examinationcenters.YesNo',
							'examCenter.ExamCenterStore',
							'examinationcenters.CenterUseFor',
							'examinationcenters.RoomGridBlank',
							'common.CountryStore', 'organization.CityStore',
							'examinationcenters.AddressStoreBlank',
							'examinationcenters.CenterResponisble',
							'examinationcenters.ExamResourseCode',
							'common.ResourceType','organization.AddressTypeStore',
							'organization.CountryRegionStore','organization.CountryRegionStore1','organization.CityByCountryRegion',
							'examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterName',
							'examinationcenters.AmenitiesExamCenter'
						],
					views : [
							'examinationcenters.ExaminationCenterGrid',
							'examinationcenters.ExaminationCenter',
							'examinationcenters.RoomDetails',
							'examinationcenters.ExaminationStructure',
							'examinationcenters.ExaminationAddressDetails',
							'examinationcenters.ExaminationCenterGridStructure',
							'examinationcenters.ExaminationSearch','examinationcenters.RoomDetailsGrid',
							'studentPortal.ExaminationCenterGridStructureForPortal', 'examinationcenters.ExaminationCenterSearchTab'
						// 'examinationcenters.AmenitiesExamCenter'
					],
					config:{
						    	 /*
						        	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
						         		   	 */
						         	   	/**
						         	        * @cfg {Array}  EXAMINATIONCENTER_PERMISSION array (required)
						         	        * The array of permissions to use for Access control wise enabling and disabling buttons.
						         	        * @accessor
						         	        */
						EXAMINATIONCENTER_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATIONCENTER_PRIVILEGES')
						     },         
					refs : [
							{
								ref : 'examinationsearch',
								selector : 'examinationsearch'
							},
							{
								ref : 'searchresultgrid',
								selector : 'searchresultgrid[itemId=examinationCenterId]'
							}, {
								ref : 'examinationcenter',
								selector : 'examinationcenter'
							}, {
								ref : 'roomdetails',
								selector : 'roomdetails'
							}, {
								ref : 'roomDetailsForm',
								selector : 'roomdetails form'
							}, {
								ref : 'examinationaddressdetails',
								selector : 'examinationaddressdetails'
							}, {
								ref : 'examinationAddressdetails',
								selector : 'examinationaddressdetails form'
							}, {
								ref : 'examinationstructure',
								selector : 'examinationstructure'
							}, {
								ref : 'contentPanel',
								selector : 'contentPanel'
							}, {
								ref : 'roomdetailsgrid',
								selector : 'roomdetailsgrid'
							}, {
								ref : 'examinationcentergridstructure',
								selector : 'examinationcentergridstructure'
							},{
								ref : 'examinationcentergrid',
								selector : 'examinationcentergrid'
							}, {
								ref: 'examinationcentersearchtab',
								selector: 'examinationcentersearchtab'
							}],
							
					init : function() {
						this.control({
							//
							'examinationcentergridstructure':{
								render : function(obj){
									
								}
							},
							
							'examinationcentergridstructure':{
					        	afterrender : function(structure){
					        		var $this = this;
					        		var form = structure.down('form');
					        		var grid = structure.down('#examinationCenterId');
					        	/*	grid.down('#searchResultGridBtnDelete').hide();
					        	    $this.getCBGridHeaderFreeze(grid,form);*/
					        	}
				    		},
							
							'searchresultgrid[itemId=examinationCenterId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					            click: function() {
					                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
					            }
					        },
					        'searchresultgrid[itemId=examinationCenterId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					            click: function() {
					                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
					            }
					        },
					        'searchresultgrid[itemId=examinationCenterId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					            click: function() {
					                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
					            }
					        },
					        'searchresultgrid[itemId=examinationCenterId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					            click: function() {
					                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
					            }
					        },
							//
									'examinationsearch button[itemId=searchBtn]' : {
										click : this.loadExamCenter
									},
									'examinationsearch button[itemId=resetBtn]' : {
										click : function(){
											var examForm=this.getExaminationsearch().getForm()
											examForm.findField('centerName').setDisabled(true);
											examForm.reset();
										}
									},
									'examinationsearch customcombobox[itemId=centerResponsibleItem]' : {
										select : function(obj,rec){
											var data=rec[0].data.value;
											var form=obj.up('form').getForm();
											var centerResField=form.findField('centerResponsible');
											var academyLocationId=this.getCurrentAcademyLocation();
											centerResField.enable();
											centerResField.getStore().getProxy().extraParams = {
												academyLocationId:academyLocationId,
												roleName:"CENTER_SUPERVISOR"
						   					   };
											centerNameField.getStore().load({
												callback:function(rec,success){
			    									if(rec.length==1){
			    										centerResField.setValue(rec[0].data.id);
			    								  }
			    								}
											});
											form.isValid();
										}
									},
									'examinationsearch customcombobox[itemId=centerTypeItemId]' : {
										select : function(obj,rec){
											var data=rec[0].data.value;
											var form=obj.up('form').getForm();
											var centerNameField=form.findField('centerName');
											centerNameField.enable();
											centerNameField.getStore().getProxy().extraParams = {
												centerType:data
						   					   };
											centerNameField.getStore().load();
										}
									},
									'examinationsearch customcombobox[itemId=stageTypeItemId]' : {
										select : function(obj,rec){
											var data=rec[0].data.value;
											var form=obj.up('form').getForm();
											form.isValid();									
										}
									},
									'examinationcenter button[itemId=submitBtn]' : {
										click : this.addExaminationCenter

									},
									'examinationcenter button[itemId=cancelBtn]' : {
										click : function() {
											var examForm= this.getExaminationcenter().getForm()
											examForm.findField('resourseId').setDisabled(true);
											examForm.reset();
											this.getRoomdetailsgrid().getStore().removeAll();
										}
									},
									'examinationcenter customcombobox[itemId=centerType_Id]' : {
										select : function(obj, record) {
											this.centerTypeChanges(obj, record);
										}
									},
									'examinationcenter customcombobox[itemId=resourseIdItemId]' : {
										select : function(obj, record) {
											var data=record[0].data.id;
											var examForm=obj.up('form').getForm();
											var resourseType = examForm.findField('resourseType').getValue();
											Ext.Ajax.request({
												method : "GET",
												type : 'rest',
												url : SERVERURL.CHECK_UNIQUE_FOR_INTERNAL_URL,
											    params:{
											    	resourceTypeId:resourseType,
											    	resourceId:data
											    },
												headers : {
													'Content-Type' : 'application/json'
												},
												success : function(resp, action) {
													var mssg = resp.responseText;
													if (mssg == "false") {
														showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('RESOURCE_CODE_EXISTS'));
														examForm.findField('resourseId').reset();
													}else{
														
														/**
														 * It is used to fetch capacity based on resource id  
														 */
														var centerCapacity=examForm.findField('centerCapacity');
														var data=record[0].data.id;
														Ext.Ajax.request({
															method : "GET",
															type : 'rest',
															url : SERVERURL.GET_CAPACITY_FOR_INTERNAL,
														    params:{
														    	resourceId:data
														    },
															headers : {
																'Content-Type' : 'application/json'
															},
															success : function(resp, action) {
																var respData = resp.responseText;
																var  jData=Ext.JSON.decode(respData);
																centerCapacity.setValue(jData.capacity);
																centerCapacity.setReadOnly(true);
															}
														});
													}
												}
											});
											examForm.isValid();
										}
									},
									'examinationcenter':{
										render:function(form){
											var $this=this;
											var examForm=form.getForm();
											var centerResponsible=examForm.findField('centerResponsible');
											var academyLocationId=$this.getCurrentAcademyLocation();
											var store = centerResponsible.getStore();
											store.getProxy().extraParams = {
												academyLocationId:academyLocationId,
												roleName:'CENTER_SUPERVISOR',
						   					   };
						   				//	store.load();	
										}
									},
									'examinationcenter textfield[itemId=cemterName_Id]' : {
										blur : function(response) {
											this.checkUniquenessForCenteName(response);
										}
									},
									'examinationcenter textfield[itemId=centerCode_Id]' : {
										blur : function(response) {
											this.checkUniquenessForCenterCode(response);
										}
									},
									'examinationcenter radiogroup[itemId=amenitiesApplicableId]':{
									                                       change : function(value,newValue,oldValue){
									                                               var $this = this;
									                                              var examForm= $this.getExaminationcenter().getForm();
									                                            var amenities = examForm.findField('amenities');
									                                              if(newValue.whetherAmenitiesActive==true){
									                                                      amenities.show();
									                                                       amenities.reset();
																						   amenities.allowBlank = false;
																						   amenities.validate();
									                                                    var store = $this.getStore('examinationcenters.AmenitiesExamCenter');
									                                                    store.load();
									                                            }else{
									                                                       amenities.hide();
									                                                       amenities.reset();
																						   amenities.allowBlank = true; 
																						   amenities.clearInvalid();
									                                            }
									                                       }
									                                    },
									'roomdetails button[itemId=roomDetailsubmitBtn]' : {
										click : this.addInRoomGrid
									},
									'roomdetails button[itemId=cancelBtn]' : {
										click :function (obj){
											obj.up('window').close();
										}
									},
								    'roomdetails numberfield[itemId=roomCapacity_Id]':{   
				                	   change: function(obj, record) {   
											var $this=this; 
										var examForm = $this.getExaminationcenter().getForm();
										var centerCapacity=examForm.findField('centerCapacity').getValue();
										
										var form = $this.getRoomDetailsForm(); 
										saveBtn = form.down('#roomDetailsubmitBtn');
										var values = form.getValues();   
										var store = $this.getStore('examinationcenters.RoomGridBlank');
										var grid = $this.getRoomdetailsgrid();
										var totalCapacity=0;
										
										Ext.Array.each(store.data.items,function(value,index){
				  						  totalCapacity=totalCapacity+parseInt(value.data.roomCapacity);
				  					    });
										totalCapacity=totalCapacity+parseInt(values.roomCapacity);
										
										if(totalCapacity<centerCapacity)
											{
											saveBtn.setDisabled(false); 	     
											//showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('TOTAL_ROOMS_CAPACITY_ERROR_MSG') + centerCapacity);
											return;
											}      
											}}, 
						            'roomdetailsgrid button[itemId=btnAdd]' : {
										click : function() {
											var $this=this;
											var examForm=$this.getExaminationcenter().getForm();
											var noOfRooms=examForm.findField('noOfRooms');
											var roomGridStore=$this.getRoomdetailsgrid().getStore();
											/**
											 * apply condition on room details so can't add more than No. of rooms (no of rooms)
											 */
											if(roomGridStore.data.items.length>=parseInt(noOfRooms.getValue())){
												showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('NO_OF_ROOMS_EXCEEDS_MSG') + noOfRooms.getValue());
												return;
											}else{
												this.openRoomDetailsWindow();
											}
										}
									},
									'roomdetailsgrid button[itemId=btnDelete]' : {
										click : function() {
											this.deleteFromRoomGrid();
										}
									},
									'examinationcenter button[itemId=examinationAddressDetailsWin]' : {
										click : function(obj){
											var $this=this;
											var examForm=obj.up('form').getForm();
											var centerTypeValue=examForm.findField('centerType').getValue();
											var idValue=examForm.findField('id').getValue();
											/***
											 * Here condition is to check id at the time of edit and its center Type 
											 * first condition run when id is null and center type internal 
											 */
											if(idValue!=""){
												var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
												var btntxt = button.getText();
												if(centerTypeValue==getExaminationTranslation('CNTRL_INTERNAL')){
													if(btntxt == "View Address"){
														$this.readOnlyAddressForm();
													}
													else{
														$this.openExaminationAddress();
													}
												}else if(centerTypeValue==getExaminationTranslation('CNTRL_EXTERNAL')){
													//$this.openAddresDetailsWindow();
													if(btntxt == "View Address"){
														$this.readOnlyAddressForm();
													}
													else{
														$this.openExaminationAddress();
													}
												}
											}else{
											    $this.openExaminationAddress();
											}
										}
									},
									'examinationaddressdetails button[itemId=saveButtonId]' : {
										click : function() {
											this.saveAddressDetails();
										}
									},
									'examinationaddressdetails button[itemId=cancelButtonId]' : {
										click : function(obj) {
											obj.up('window').close();
										}
									},
								
								      'examinationcentergrid' : {
										render : function(grid) {
											//this.gridRenderFunction(grid);
											console.log('perm..',this.getEXAMINATIONCENTER_PERMISSION())
											this.doAccessControlValidation(grid,this.getEXAMINATIONCENTER_PERMISSION());
											this.disableMoreActionPivilegesRest(grid,this.getEXAMINATIONCENTER_PERMISSION());
											/**
				                             * This function is used to hide button menu while scrolling.
				                             */
											if(this.getCurrentLoggedPortalId()==1){
												this.hideButtonMenuWhileScrolling(grid);	
											}
										},
										cellclick : function(view, td,cellIndex, record, tr,rowIndex, e, eOpts) {
											var grid=view.ownerCt;
											var button=grid.down('#examCenterDeleteBtn');
											var centerStatus=record.data.whetherActive;
											if(centerStatus){
												button.setText(getExaminationTranslation('DISABLE'));
											}else{
												button.setText(getExaminationTranslation('ENABLE'));
											}
										}
									},
									
									'searchresultgrid[itemId=examinationCenterId] button[itemId=searchResultGridBtnAdd]' : {
										click : function() {
											this.showExaminatinCenter();
										}
									},
									'searchresultgrid[itemId=examinationCenterId] button[itemId=searchResultGridBtnEdit]' : {
										click : function(){
											this.editExaminationCenter();
										}
									},
									'searchresultgrid[itemId=examinationCenterId] menuitem[itemId=enableDisableItemId]' : {
										click : this.delteExaminationCenter
									},
									'searchresultgrid[itemId=examinationCenterId] button[itemId=searchResultGridBtnView]' : {
										click : this.viewExamCenter
									},
									//New Rest code
									'examinationcentergrid  button[itemId=examCenterEditdBtn]' : {
										click : function(){
											this.editExaminationCenter();
									 }
									},
									'examinationcentergrid  button[itemId=examCenterAddBtn]' : {
										click : this.showExaminatinCenter
									},
									'examinationcentergrid  button[itemId=examCenterViewBtn]' : {
										click : this.viewExamCenter
									},
									'examinationcentergrid  splitbutton[itemId=spBtnMoreActionsAssessmentEvent] #examCenterDeleteBtn' : {
										click : this.deleteExaminationCenterRest
									},
									
									
									'searchresultgrid[itemId=examinationCenterId]' : {
										render : function(grid) {
										   this.gridRenderFunction(grid);
											console.log('perm..',this.getEXAMINATIONCENTER_PERMISSION())
											this.genericCBGridAccessControlValidation(grid,this.getEXAMINATIONCENTER_PERMISSION());
											this.disableMoreActionPivileges(grid,this.getEXAMINATIONCENTER_PERMISSION());
											/**
				                             * This function is used to hide button menu while scrolling.
				                             */
											if(this.getCurrentLoggedPortalId()==1){
												this.hideButtonMenuWhileScrolling(grid);	
											}
										},
										cellclick : function(view, td,cellIndex, record, tr,rowIndex, e, eOpts) {
											var grid=view.ownerCt;
											var button=grid.down('#enableDisableItemId');
											var centerStatus=record.data.CENTER_STATUS;
											if(centerStatus==getExaminationTranslation('CNTRL_ACTIVE')){
												button.setText(getExaminationTranslation('DISABLE'));
											}else if(centerStatus==getExaminationTranslation('CNTRL_INACTIVE')){
												button.setText(getExaminationTranslation('ENABLE'));
											}
										}
									},
									'examinationaddressdetails customcombobox#countryId' : {
										select : function(obj, record) {
											var examForm=this.getExaminationAddressdetails();
											var cityComboBox = examForm.down('customcombobox#cityId');
											cityComboBox.clearValue();
											var genericField1ComboBox = examForm.down('customcombobox#parentCountryRegionId');
											genericField1ComboBox.reset();

											var countryId = record[0].get("id");

											var cityStore = cityComboBox.getStore();
											cityStore.getProxy().extraParams = {
												id : countryId
											};
											cityStore.load();

											var countryRegionStore = genericField1ComboBox.getStore();
											countryRegionStore.getProxy().extraParams = {
												cid : countryId
											};
											countryRegionStore.load();
											

										}
									},
									'examinationaddressdetails customcombobox#parentCountryRegionId': {
										select: function(obj1, record) {
											var cityComboBox = this.getExaminationAddressdetails().down('customcombobox#cityId');
											cityComboBox.reset();
											var countryRegion1 = record[0].get("id");
//											var store = this.getStore('organization.CountryRegionStore1');
											var store = this.getStore('organization.CityByCountryRegion');
//											store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
											store.getProxy().extraParams = {
												id: countryRegion1
											};
											store.reload();
										}
									},
									'examinationaddressdetails customcombobox#cellCountryCode': {
										select: function(obj, record) {
											var value = obj.getValue();
											var form=this.getExaminationAddressdetails();
											var country = form.down('#countryId');
											var cellNo = form.down('#cellNo');
											
										    var countryList =country.getStore().data.items; 
										    for(var i=0;i<countryList.length;i++){
										    	var model=countryList[i].data;
										    	if(model.isdCode == value){
										    		cellNo.maxLength = model.maximumDigit;
										    		cellNo.minLength = model.minimumDigit;
										    	}
										    }   
										}
									},
									/*'examinationaddressdetails customcombobox#genericFieldId1':{
										select:function(obj,rec){
											var data=rec[0].data.id;
											var genericField2ComboBox = this.getExaminationAddressdetails().down('customcombobox#genericFieldId2');
											genericField2ComboBox.reset();
											genericField2ComboBox.enable();
											var countryRegion2Store = genericField2ComboBox.getStore();
											countryRegion2Store.getProxy().extraParams = {
												pid : data
											};
											countryRegion2Store.load();
										}
									},*/
									'examinationcenter customcombobox[itemId=resourseTypeItemId]':{
									  select:function(obj,rec){
										  var $this=this;
										  var data =rec[0].data.id;
										  var form=obj.up('form').getForm();
										  var academyLocationId=$this.getCurrentAcademyLocation();
										  var resourseIdField=form.findField('resourseId');
							  	var centerCapacity=form.findField('centerCapacity');
										  centerCapacity.reset();
										  resourseIdField.enable();
										  resourseIdField.getStore().getProxy().extraParams = {
											  resourceTypeId: data,
											  academyLocationId:academyLocationId
						   					 };
										  resourseIdField.getStore().load();
									  }	
									}
								});
					},
					/**
					 * this function is used to hide button menu while scrolling
					 */
		            hideButtonMenuWhileScrolling:function(grid){
		        	    var examinationcentergridstructure=this.getExaminationcentergridstructure();
		        	    examinationcentergridstructure.body.on('scroll', function(e){
						var moreactionButton=grid.down('#spBtnMoreActions');
						    moreactionButton.hideMenu();
					    }, examinationcentergridstructure);
		            },
				   openRoomDetailsWindow:function(){
			        	var formWindow = this.getRoomdetails();
						if (!formWindow) {
							Ext.widget('roomdetails');
							formWindow = this.getRoomdetails();
						}
						formWindow.show();
				    }, 
				    openAddresDetailsWindow:function(){
			        	var formWindow = this.getExaminationaddressdetails();
						if (!formWindow) {
							Ext.widget('examinationaddressdetails');
							formWindow = this.getExaminationaddressdetails();
						}
						formWindow.show();
				    },
					showExaminatinCenter : function() {
						var me = this;
						var contentpanel = me.getContentPanel();
						var examinationStructure = Ext.widget('examinationstructure');
						var tabName = getExaminationTranslation('MANAGE_EXAMINATION_CENTER');
						 /**
		              	   * This is to remove tab from content panel and open same tab again 
		              	   */
		              	 var getcontroller=this.getController('menu.CoreERPNavigationController');
		              	 var getTab=getcontroller.getTab(tabName);
		              	 if(getTab!=null){
		              		 contentpanel.remove(getTab, true);
		              	 }
						openTab(contentpanel, tabName, examinationStructure,CONSTANTS.MENU_COLOR_FOUR);
					},
					loadExamCenter : function() {
						var $this = this;
						var quickSearchForm = $this.getExaminationsearch();
						var form=quickSearchForm.getForm();
						var centerTypeField=form.findField('centerType');
						var centerNameField=form.findField('centerName');
						
						var grid = $this.getExaminationcentergrid();
						//deselect the grid
						grid.getSelectionModel().deselectAll();
						
						var gridStore = grid.getStore();
						
						$this.resetPageSetting(grid.getStore(), grid); 
	                    grid.getStore().pageSize=100;

						gridStore.getProxy().extraParams = {
							'centerType':centerTypeField.getValue(),
							'centerName':centerNameField.rawValue
						};
						
						gridStore.load();
						
						/*
						Code commented in-favor of rest api 
						var quickSearchForm = this.getExaminationsearch();
						var form=quickSearchForm.getForm();
						var centerTypeField=form.findField('centerType');
						var viewCode=null;
						var configCode=null;
						*
						 * Load xml on the bases of center type internal and external
						 
						if(centerTypeField.getValue()==getExaminationTranslation('CNTRL_INTERNAL')){
							viewCode=CONSTANTS.CB.EXAMINATION_INTERNAL_CENTER_LISTING_VIEWCODE;
							configCode=CONSTANTS.CB.EXAMINATION_INTERNAL_CENTER_LISTING_CONFIGCODE;
						}else if(centerTypeField.getValue()==getExaminationTranslation('CNTRL_EXTERNAL')){
							viewCode=CONSTANTS.CB.EXAMINATION_CENTER_LISTING_VIEWCODE;
							configCode=CONSTANTS.CB.EXAMINATION_CENTER_LISTING_CONFIGCODE;
						}
						
						var jsonFormatFormData = this.createJsonFormat(quickSearchForm,configCode );
						var searchResultGrid = this.getSearchresultgrid();
						var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						resultViewUrl = resultViewUrl.concat(viewCode);
						searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl,jsonFormatFormData);
						
						 Ext.defer(function() {
							var portalId = this.getCurrentLoggedPortalId();
							var searchGridCol =searchResultGrid.getView().getGridColumns();
								if(portalId == 3 || portalId == 7) {
									for(var i=searchGridCol.length-1;i>=0;i--) {
										var column = searchGridCol[i];
										if(column.dataIndex == 'CENTER_STATUS' || column.dataIndex =='CENTER_CAPACITY'){
											column.hide();
										}
									}
							   }
						 }, 50, this);
					*/},
					createJsonFormat : function(quickSearchForm, configCode) {
						var form = quickSearchForm.getForm();
						var centerType =form.findField('centerType');
						var centerName = form.findField('centerName');
						var values = new Object();
						var searchcriteria = new Array();
						values.configCode = configCode;
						
						var academyLocationId = this.getCurrentAcademyLocation();
						
						var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', academyLocationId);
						this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);

						var CENTER_TYPE = this.getJsonObject('CENTER_TYPE', centerType.getValue());
				        this.pushJsonObjectInArray(CENTER_TYPE,searchcriteria);
				        var EXAM_CENTER_ID = this.getJsonObject('EXAM_CENTER_ID', centerName.getValue());
				        this.pushJsonObjectInArray(EXAM_CENTER_ID,searchcriteria);
				        var academyLocationId=this.getCurrentAcademyLocation();
				        /*var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_IDS', academyLocationId);
				        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);*/
						values.searchCriterias = searchcriteria;
						return values;
					},
					getJsonObject : function(key, value, additionalValue) {
						if (value != '' && value != null
								&& additionalValue == undefined) {
							return {
								"paramCode" : key,
								"paramValues" : [ value ]
							};
						} else if (value != '' && additionalValue != undefined) {
							return {
								"paramCode" : key,
								"paramValues" : [ value, additionalValue ]
							};
						}
					},
					pushJsonObjectInArray : function(object, array) {
						if (object) {
							array.push(object);
						}
					},
					/** 
					@deprecated in favor  of rest api 
					*/
					gridRenderFunction : function(grid) {						
						grid.addButtonToolbar();
						var moreActionButton = {	
								xtype : 'splitbutton',
						        itemId:'spBtnMoreActions',
						        text : getCommonTranslation('MOREACTIONS'),
						        menu:[{
						            text:getExaminationTranslation('ENABLE'),
						            itemId:'enableDisableItemId'
						        }],
						        listeners: { click: function() { this.showMenu(); } }
							
						};
						grid.down('#functionButtonsToolbar').insert(4,moreActionButton);
					},
					/**
					 * it is used check unique center code
					 */
					checkUniquenessForCenterCode : function(response) {
						var $this = this;
						var form = $this.getExaminationcenter().getForm();
						var centreCode = form.findField('centreCode').getValue();
						var id=form.findField('id').getValue();
						Ext.Ajax.request({
							method : "GET",
							type : 'rest',
							url : SERVERURL.CHECK_UNIQUE_CENTER_CODE_NAME,
						    params:{
						    	centerCode:centreCode,
						    	examCenterId:id
						    },
							headers : {
								'Content-Type' : 'application/json'
							},
							success : function(resp, action) {
								var mssg = resp.responseText;
								if (mssg == "false") {
									showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('CENTER_CODE_EXISTS'));
									form.findField('centreCode').reset();
								}
							}
						});
					},
					/**
					 * it is used check unique center name
					 */
					checkUniquenessForCenteName : function(response) {
						var $this = this;
						var form = $this.getExaminationcenter().getForm();
						var centerName = form.findField('centerName').getValue();
						var id=form.findField('id').getValue();
						Ext.Ajax.request({
							method : "GET",
							type : 'rest',
							url : SERVERURL.CHECK_UNIQUE_CENTER_CODE_NAME,
						    params:{
						    	examCenterName:centerName,
						    	examCenterId:id
						    },
							headers : {
								'Content-Type' : 'application/json'
							},
							success : function(resp, action) {
								var mssg = resp.responseText;
								
								if (mssg == "false") {
									showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('CENTER_NAME_EXISTS'));
									form.findField('centerName').reset();
								}
							}
						});
					},
					saveAddressDetails : function() {
						var $this = this;
						var form = $this.getExaminationAddressdetails()
								.getForm();
						var values = form.getValues();
						var store = $this.getStore('examinationcenters.AddressStoreBlank');
								
						if (store.data.length > 0) {
							store.removeAll();
						}
						var adrsData=new Academia.model.examinationcenters.AddressModelBlank();
						adrsData.set('id',values.id);
						adrsData.set('version',values.version);
						adrsData.set('addressText',values.addressText);
						adrsData.set('country',$this.getIdValueJson(values.country));
						adrsData.set('parentCountryRegion',$this.getIdValueJson(values.parentCountryRegion));
						adrsData.set('countryRegion',$this.getIdValueJson(values.countryRegion));
						adrsData.set('city',$this.getIdValueJson(values.city));
						adrsData.set('pincode',values.pincode);
						adrsData.set('cellCountryCode',values.cellCountryCode);
						adrsData.set('cellNo',values.cellNo);
						adrsData.set('phoneCountryCode',values.phoneCountryCode);
						adrsData.set('phoneAreaCode',values.phoneAreaCode);
						adrsData.set('phoneNo',values.phoneNo);
						adrsData.set('primaryeEmailId',values.primaryeEmailId);
						adrsData.set('alternateEmailId',values.alternateEmailId);
						adrsData.set('code',values.code);
						adrsData.set('phoneNo',values.phoneNo);
						adrsData.set('addressType',$this.getIdValueJson(values.addressType));
						adrsData.set('websiteURL',values.websiteURL);
						store.loadRawData(adrsData.data, true);
						showSuccessMessage(getExaminationTranslation('Room Address Saved'),getCommonTranslation('SUCCESS'));  
						$this.getExaminationaddressdetails().close(); 
						var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
						button.setText(getExaminationTranslation('EDIT_ADDRESS'));
					
					},
					
					openExaminationAddress : function() {
						var $this = this;
						var formWindow = $this.getExaminationaddressdetails();
						if (!formWindow) {
							Ext.widget('examinationaddressdetails');
							formWindow = $this.getExaminationaddressdetails();
						}
						formWindow.show();

						var examForm= $this.getExaminationcenter();
						var addressForm = $this.getExaminationAddressdetails();
						var getAddressForm = $this.getExaminationAddressdetails().getForm();
						var centerTypeValue = examForm.getForm().findField('centerType').getValue();
						var phoneCountryCodeField = getAddressForm.findField('phoneCountryCode');
						var phoneNumberField = getAddressForm.findField('phoneNo');
						$this.setAllowBlank(phoneCountryCodeField,false);
						$this.setAllowBlank(phoneNumberField,false);
						if (centerTypeValue == getExaminationTranslation('CNTRL_INTERNAL')) {
							addressForm.down('#saveButtonId').hide();
							addressForm.down('#cancelButtonId').hide();
							toggleReadOnlyFormItems(getAddressForm, true);
						} else {
							getAddressForm.findField('addressText').reset();
						}
						//var id =examForm.getForm().findField('id').getValue();
						//if (id > 0 && id != null) {
						var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
						var btntxt = button.getText();
						if(btntxt!="Add Address" || btntxt == "View Address"){
							if(centerTypeValue == getExaminationTranslation('CNTRL_EXTERNAL') && btntxt == "View Address"){
								addressForm.down('#saveButtonId').hide();
								addressForm.down('#cancelButtonId').hide();
							}
							var store = $this.getStore('examinationcenters.AddressStoreBlank');
							if (store.getRange().length > 0) {
								var addressData = store.getRange();
								var addData = addressData[0].data;
								getAddressForm.findField('addressText').setValue(addData.addressText);
								getAddressForm.findField('version').setValue(addData.version);
								getAddressForm.findField('phoneAreaCode').setValue(addData.phoneAreaCode);
								getAddressForm.findField('phoneNo').setValue(addData.phoneNo);
								getAddressForm.findField('cellNo').setValue(addData.cellNo);
								getAddressForm.findField('primaryeEmailId').setValue(addData.primaryeEmailId);
								getAddressForm.findField('alternateEmailId').setValue(addData.alternateEmailId);
								getAddressForm.findField('pincode').setValue(addData.pincode);
								getAddressForm.findField('websiteURL').setValue(addData.websiteURL);
							 
								if(addData.addressType!=null){
									var addressTypeField = getAddressForm.findField('addressType');
									addressTypeField.store.load({
												callback : function(records, operation,success) {
													if (success) {
														addressTypeField.setValue(addData.addressType.id);
													}
												}
											});
									}
								
								var country = getAddressForm.findField('country');
								country.store.load({
											callback : function(records,operation, success) {
												if (success) {
													country.setValue(addData.country.id);
												}
											}
										});

								var city = getAddressForm.findField('city');
								city.store.load({
									params:{
										id:addData.parentCountryRegion.id
									},
									callback : function(records, operation,success) {
										if (success) {
											city.setValue(addData.city.id);
										}
									}
								});
								
								if(addData.parentCountryRegion!=null){
								var parentCountryRegion = getAddressForm.findField('parentCountryRegion');
								parentCountryRegion.store.load({
									params:{
										cid:addData.country.id
									},
									callback : function(records,operation, success) {
										if (success) {
											parentCountryRegion.setValue(addData.parentCountryRegion.id);
										}
									}
										});
								//commenting this because countryRegion is not exist in examinationaddressdetails form 
								//V2D-79224
							    
							/*	if(addData.countryRegion!=null){
								var countryRegionField = getAddressForm.findField('countryRegion');
								countryRegionField.enable();
								countryRegionField.store.load({
											params:{
												pid:addData.parentCountryRegion.id
											},
											callback : function(records,operation, success) {
												if (success) {
													countryRegionField.setValue(addData.countryRegion.id);
												}
											}
										});
								   }*/
								}
								var phoneCountryCodeField = getAddressForm.findField('phoneCountryCode');
								phoneCountryCodeField.store.load({
											callback : function(records,operation, success) {
												if (success) {
													phoneCountryCodeField.setValue(addData.phoneCountryCode);
												}
											}
										});
								
								var cellCountryCodeField = getAddressForm.findField('cellCountryCode');
								cellCountryCodeField.store.load({
											callback : function(records, operation,success) {
												if (success) {
													cellCountryCodeField.setValue(addData.cellCountryCode);
													var cellNo = getAddressForm.findField('cellNo');
												    var countryList =country.getStore().data.items; 
												    for(var i=0;i<countryList.length;i++){
												    	var model=countryList[i].data;
												    	if(model.isdCode == addData.cellCountryCode){
												    		cellNo.maxLength = model.maximumDigit;
												    		cellNo.minLength = model.minimumDigit;
												    	}
												    } 
												}
											}
										});
							}
						}
					},
					
					readOnlyAddressForm : function() {
						var $this = this;
						var academyLocationId=$this.getCurrentAcademyLocation();
						Ext.Ajax.request({
									type : 'rest',
									url : SERVERURL.ADDRESS_INTERNAL,
									params : {
										academyLocationId : academyLocationId
									},
									method : 'GET',
									success : function(resp, action) {
										var addressDetails = Ext.JSON.decode(resp.responseText);
										$this.openAddresDetailsWindow();
										var forms = $this.getExaminationAddressdetails();
										var form = forms.getForm();
										var store = $this.getStore('examinationcenters.AddressStoreBlank');
										if (store.getRange().length > 0) {
											var addressData = store.getRange();
											var addData = addressData[0].data;
											}
										
										var address = form.findField('addressText').setValue(addData.addressText);
										address.readOnly = true;
										form.findField('phoneAreaCode').setValue(addData.phoneAreaCode);
										form.findField('phoneNo').setValue(addData.phoneNo);
										form.findField('cellNo').setValue(addData.cellNo);
										form.findField('primaryeEmailId').setValue(addData.primaryeEmailId);
										form.findField('alternateEmailId').setValue(addData.alternateEmailId);
										form.findField('pincode').setValue(addData.pincode);
										form.findField('websiteURL').setValue(addData.websiteURL);
										
										if(addressDetails.addressType!=null){
											var addressTypeField = form.findField('addressType');
											addressTypeField.store.load({
														callback : function(records, operation,success) {
															if (success) {
																addressTypeField.setValue(addressDetails.addressType.id);
															}
														}
													});
											}
										
										if(addressDetails.country!=null){
											var country = form.findField('country');
											country.store.load({
														callback : function(records, operation,success) {
															if (success) {
																country.setValue(addressDetails.country.id);
															}
														}
													});
											
										if(addressDetails.city!=null){
											var city = form.findField('city');
												city.store.load({
													params:{
														id:addressDetails.parentCountryRegion.id
													},
															callback : function(records, operation,success) {
																if (success) {
																	city.setValue(addressDetails.city.id);
																}
															}
														});
											}
										}

										if(addressDetails.parentCountryRegion!=null){
										var parentCountryRegion = form.findField('parentCountryRegion');
										parentCountryRegion.store.load({
											 params:{
											     cid : addressDetails.country.id
				                		     	},
													callback : function(records, operation,success) {
														if (success) {
															parentCountryRegion
																	.setValue(addressDetails.parentCountryRegion.id);
														}
													}
												});
										}
										
										if(addressDetails.countryRegion!=null){
											var countryRegionNameField = form.findField('countryRegionName');
											countryRegionNameField.enable();
											countryRegionNameField.store.load({
												 params:{
												 pid : addressDetails.parentCountryRegion.id
					                		 	},
														callback : function(records, operation,success) {
															if (success) {
																countryRegionNameField.setValue(addressDetails.countryRegion.id);
																		
															}
														}
													});
											}
										
										var cellCountryCodeField = form.findField('cellCountryCode');
										cellCountryCodeField.store.load({
													callback : function(records, operation,success) {
														if (success) {
															cellCountryCodeField.setValue(addressDetails.cellCountryCode);
														}
													}
												});
										
										var phoneCountryCodeField = form.findField('phoneCountryCode');
										phoneCountryCodeField.store.load({
													callback : function(records, operation,success) {
														if (success) {
															phoneCountryCodeField.setValue(addressDetails.phoneCountryCode);
														}
													}
												});

										if (forms) {
											forms.down('#saveButtonId').hide();
											forms.down('#cancelButtonId').hide();
											form = forms.getForm();
											toggleReadOnlyFormItems(form, true);
										}
									}
								});
					},
					/***
					 * This function is used to hide and show the room detail grid on the bases of center type
					 */
					centerTypeChanges : function(obj, record) {
						$this = this;
						var form=obj.up('form').getForm();
						var selectedValue = form.findField('centerType').getValue();
						var resourseTypeField=form.findField('resourseType');
						var resourseIdField=form.findField('resourseId');
						var centreCodeField=form.findField('centreCode');
						var centerNameField=form.findField('centerName');
						var centerCapacityField=form.findField('centerCapacity');
						var amenitiesApplicableField=form.findField('amenitiesApplicable');
						var amenitiesField=form.findField('amenities');
					
						resourseTypeField.setVisible(false);
						resourseIdField.setVisible(false);
						centreCodeField.setVisible(false);
						centerNameField.setVisible(false);
						
						resourseTypeField.reset();
						resourseIdField.reset();
						centreCodeField.reset();
						centerNameField.reset();
						
						resourseTypeField.allowBlank=true;
						resourseIdField.allowBlank=true;
						centreCodeField.allowBlank=true;
						centerNameField.allowBlank=true;
						
						if (selectedValue == getExaminationTranslation('CNTRL_EXTERNAL')) {
							/**
							 * Here center Capacity is been reset on the bases of resource code.
							 */
							centerCapacityField.reset();
							centerCapacityField.setReadOnly(false);
							
							Ext.ComponentQuery.query('roomdetailsgrid#roomDetails_Id')[0].show();
							var noOfRoomsField =  Ext.ComponentQuery.query('numberfield#noOfRooms_Id')[0];
							noOfRoomsField.setVisible(true);
			            	 Ext.apply(noOfRoomsField, {allowBlank: false});
							var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
							button.setText(getExaminationTranslation('ADD_ADDRESS'));
							
							centreCodeField.setVisible(true);
							centerNameField.setVisible(true);
							centreCodeField.allowBlank=false;
							centerNameField.allowBlank=false;
							centreCodeField.setFieldLabel(getExaminationTranslation('CENTER_CODE'));
							$this.setAllowBlank (centreCodeField,false);
							centerNameField.setFieldLabel(getExaminationTranslation('CENTER_NAME'));
							$this.setAllowBlank (centerNameField,false);
							this.getRoomdetailsgrid().getStore().removeAll();
							
							amenitiesApplicableField.reset();
							amenitiesField.reset();
							
							amenitiesApplicableField.setVisible(true);
							
						} else if (selectedValue == getExaminationTranslation('CNTRL_INTERNAL')) {
							Ext.ComponentQuery.query('roomdetailsgrid#roomDetails_Id')[0].hide();
							Ext.ComponentQuery.query('numberfield#noOfRooms_Id')[0].hide();
							
							resourseTypeField.setVisible(true);
							resourseIdField.setVisible(true);
							resourseTypeField.allowBlank=false;
							resourseIdField.allowBlank=false;
							resourseTypeField.setFieldLabel(getExaminationTranslation('RESOURSE_TYP'));
							$this.setAllowBlank (resourseTypeField,false);
							resourseIdField.setFieldLabel(getExaminationTranslation('RESOURSE_COD'));
							$this.setAllowBlank (resourseIdField,false);
							var noOfRoomsField =  Ext.ComponentQuery.query('numberfield#noOfRooms_Id')[0];
							noOfRoomsField.setVisible(false);
							noOfRoomsField.reset();
			            	 Ext.apply(noOfRoomsField, {allowBlank: true});
							var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
							button.setText(getExaminationTranslation('VIEW_ADDRESS'));
							
							amenitiesApplicableField.reset();
							amenitiesField.reset();
							
							amenitiesApplicableField.setVisible(false);
						} else {
							Ext.ComponentQuery.query('roomdetailsgrid#roomDetails_Id')[0].show();
							var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
							button.setText(getExaminationTranslation('ADD_ADDRESS'));
						}
					},
					 

					addInRoomGrid : function(btn) {  
						//V2D-328923
						btn.setDisabled(true); //Disable the btn to prevent multiple clicks						
						var $this=this; 
						var examForm = $this.getExaminationcenter().getForm();
						var  examDetailsForm = $this.getExaminationcenter();
						var centerCapacity=examForm.findField('centerCapacity').getValue();
						var saveBtn = examDetailsForm.down('#submitBtn');
						var addressBtn =examDetailsForm.down('#examinationAddressDetailsWin');
						var window=$this.getRoomdetails();
						var form = this.getRoomDetailsForm().getForm(); 
						var values = form.getValues();
						var record = [];
						record.push({
							"id":null,
							"roomNumber" : values.roomNumber,
							"roomLocation" : values.roomLocation,
							"roomCapacity" : values.roomCapacity
						});
						/**
						 * apply check of center capacity on room capacity
						 */
						var store = this.getStore('examinationcenters.RoomGridBlank');
						var grid = this.getRoomdetailsgrid();
						var store1=grid.getStore();
						var totalCapacity=0;
						Ext.Array.each(store.data.items,function(value,index){
  						  totalCapacity=totalCapacity+parseInt(value.data.roomCapacity);
  					    });
						totalCapacity=totalCapacity+parseInt(values.roomCapacity);
						
						if(centerCapacity==null ){   
							//showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('TOTAL_ROOMS_CAPACITY_ERROR_MSG') + centerCapacity);
							showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('TOTAL_ROOMS_CAPACITY_ERROR_MSG'));
							return; 
							
						}else if(totalCapacity>centerCapacity )
							{
							showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('TOTAL_ROOMS_CAPACITY_ERROR_MSG') + centerCapacity);
							return;
							
							}
						store.loadRawData(record, true);
						if(store.getCount()> 0 && examDetailsForm.isValid()){
							saveBtn.enable();
							addressBtn.enable();
						}
						   
						recordCount = grid.getStore().getCount();
						
						grid.store.totalCount = recordCount;
						grid.getView().refresh();    
					   
                        window.close(); 							
					},
					/***
					 * Delete for room details.
					 */
					deleteFromRoomGrid : function() {
						var grid = this.getRoomdetailsgrid();
						var store = grid.getStore();
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(getExaminationTranslation('ROOM_DETAILS'),
									getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									function(btn, text) {
										if (btn == 'yes') {
											var selectedRecord = grid.selModel.getSelection();
											var id=selectedRecord[0].data.id;
											/**
											 * This delete works at time of edit (when their is id of room) and at the time creating room(if id is not their). 
											 */
											if(isNullOrEmpty(id)){
												store.remove(selectedRecord);
												recordCount = grid.getStore().getCount();
										        grid.store.totalCount = recordCount; 
						                        grid.getView().refresh();  	
												showSuccessMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('ROOM_DETAILS_DELETE_MSG'));
											}else{
												Ext.Ajax.request({
													method : "DELETE",
													type : 'rest',
													url : SERVERURL.ROOM_DETAIL_DELETE_URL+ '?id='+ id,
													headers : {
														'Content-Type' : 'application/json'
													},
													params : {
														id : id
													},
													success : function(resp,action) {
														var data=resp.responseText;
														if(data=="true"){ 
															
															store.remove(selectedRecord);
															recordCount = grid.getStore().getCount();
										                    grid.store.totalCount = recordCount; 
						                                    grid.getView().refresh();    
															showSuccessMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('ROOM_DETAILS_DELETE_MSG'));	
														}else if(data=="false"){
															showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('ROOM_DETAILS_WARNING_MSG'));
														}
													}
												});
											}
											 
										}
									});
						} else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					},
					addExaminationCenter : function() {
						var $this = this;
						var form = $this.getExaminationcenter().getForm();
						var roomGridFilled =true;
						var addressGridFilled = true;
						var values = form.getValues();
						var examinationCenter = new Academia.model.examinationcenters.ExaminationCenter();
						examinationCenter.set("centerType", values.centerType);
						examinationCenter.set("centreCode", values.centreCode);
						examinationCenter.set("centerName", values.centerName);
						examinationCenter.set("centerCapacity",values.centerCapacity);
						examinationCenter.set("allowAllocationBySupervisor",values.allowAllocationBySupervisor);
						if(values.noOfRooms !=""){
						examinationCenter.set("noOfRooms", values.noOfRooms);
						}
						examinationCenter.set("stageType", values.stageType);
						//examinationCenter.set("whetherRoomCapacitySame",values.whetherRoomCapacitySame);
						examinationCenter.set("centerResponsibleId",values.centerResponsible);
						examinationCenter.set("whetherActive",values.whetherActive);

						var roomGridStore = $this.getStore('examinationcenters.RoomGridBlank');
						var wSCenterRoomDetail = [];
						var newStore = roomGridStore.getRange();
						var address;

						for (var i = 0; i < roomGridStore.getRange().length; i++) {
							wSCenterRoomDetail.push({
								"id" : newStore[i].data.id,
								"roomNo" : newStore[i].data.roomNumber,
								"roomLocation" : newStore[i].data.roomLocation,
								"roomCapacity" : newStore[i].data.roomCapacity
							});
							
						}
						
						examinationCenter.set("wSCenterRoomDetail",wSCenterRoomDetail);
						
						var selectedAmenities = values.amenities;
						var wSCenterAmenities = [];

						if (Ext.isArray(selectedAmenities) && selectedAmenities.length > 0) {

						    for (var i = 0; i < selectedAmenities.length; i++) {
								if(Ext.isObject(selectedAmenities[i])) {
						        wSCenterAmenities.push({
						            id: selectedAmenities[i].data.id
						        });
								}
								else {
									wSCenterAmenities.push(selectedAmenities[i]);
								}
						    }

						    examinationCenter.set('amenitiesApplicable', true);
							examinationCenter.set('amenitiesMapping', wSCenterAmenities);

						} else {
						    examinationCenter.set('amenitiesApplicable', false);
							examinationCenter.set('amenitiesMapping', wSCenterAmenities);
						}


						var submitUrl;
						if (form.findField('id').getSubmitValue() == null
								|| form.findField('id').getSubmitValue() == "") {
							submitUrl = SERVERURL.EXAMINATION_CREATE;
						} else {
							examinationCenter.set("id", values.id);
							examinationCenter.set("version", values.version);
							submitUrl = SERVERURL.EXAMINATION_UPDATE;
						}

						if (values.centerType == getExaminationTranslation('CNTRL_EXTERNAL')) {
							var addrssId = form.findField('addressId').getValue();
							if (addrssId == null) {
								addrssId = "";
							}

							var store = this.getStore('examinationcenters.AddressStoreBlank');
							if(store.getRange().length  < 1){
								addressGridFilled =false;
							}
							if( roomGridStore.getRange().length < 1)	{
								roomGridFilled =false
							}	
							if (store.getRange().length > 0 && roomGridStore.getRange().length > 0) {
								var addressData = store.getRange();
								var addData = addressData[0].data;
                                 
                                 var countryRegion=null;
                                 if(addData.countryRegion!=null&&addData.countryRegion!=""){
                                	 countryRegion={"id" :addData.countryRegion.id } ;
                                 }
								address = {
									"id" : addrssId,
									"version" : addData.version,
									"addressText" : addData.addressText,
									"country" : {
										"id" : addData.country.id
									},
									"parentCountryRegion" : {
										"id" : addData.parentCountryRegion.id
									},
									"countryRegion" :countryRegion,									
                                    "city" : {
										"id" : addData.city.id
									},
									"cellCountryCode" : addData.cellCountryCode,
									"cellNo" : addData.cellNo,
									"pincode" : addData.pincode,
									"phoneCountryCode" : addData.phoneCountryCode,
									"phoneAreaCode" : addData.phoneAreaCode,
									"phoneNo" : addData.phoneNo,
									"primaryeEmailId" : addData.primaryeEmailId,
									"alternateEmailId" : addData.alternateEmailId,
									"code" : addData.code,
									"addressType" : null,
									"websiteURL" : addData.websiteURL,
								};
								examinationCenter.set("address", address);
								
								/**
								 * apply check of center capacity on room capacity only at the time of external.
								 */
								var roomGridStore = this.getStore('examinationcenters.RoomGridBlank');
								var totalCapacity=0;
								Ext.Array.each(roomGridStore.data.items,function(value,index){
		  						  totalCapacity=totalCapacity+parseInt(value.data.roomCapacity);
		  					    });
								if(totalCapacity>values.centerCapacity){
									showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('TOTAL_ROOMS_CAPACITY_ERROR_MSG') + values.centerCapacity);
									return;
								}else if(roomGridStore.data.items.length>values.noOfRooms){
									/**
									  * apply condition on room details so can't add more than No. of rooms (no of rooms)
									  */
										showWarningMessage(getExaminationTranslation('ROOM_DETAILS'),getExaminationTranslation('NO_OF_ROOMS_EXCEEDS_MSG')+ values.noOfRooms);
										return;
									}
								
								var formData = Ext.encode(examinationCenter.data);
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl,
									jsonData : formData,
									method : 'POST',
									success : function(form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getExaminationTranslation('EXAMINATION_CENTER'),getCommonTranslation('SUCCESS'));
										$this.getExaminationcenter().getForm().reset();
										$this.getRoomdetailsgrid().getStore().removeAll();
										//$this.loadExamCenter();
									}
								});
							} else {
								Ext.getBody().unmask();
								if(!addressGridFilled){
									showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('ADD_EXAMINATION_ADDRESS'));
								}
								if(!roomGridFilled){
									showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('PLEASE_ADD_ROOM_DETAILS'));
								}
							}
						} else {
							var academyLocationId=$this.getCurrentAcademyLocation();
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
										type : 'rest',
										url : SERVERURL.ADDRESS_INTERNAL,
										params : {
											academyLocationId : academyLocationId
										},
										method : 'GET',
										success : function(form, action) {
											var addressDetails = Ext.JSON.decode(form.responseText);
											var addData = addressDetails;
											address = {
												"id" : addData.id,
												"version":addData.version,
												"addressText" : addData.addressText,
												"country" : {
													"id" : addData.country.id,
													"value" : addData.country.value,
													"code" : addData.country.code
												},
												"parentCountryRegion" : {
													"id" : addData.parentCountryRegion.id,
													"value" : addData.parentCountryRegion.value,
													"code" : addData.parentCountryRegion.code
												},
												"countryRegion" :  {
													"id" : addData.countryRegion !=null ? addData.countryRegion.id : null,
													"value" : addData.countryRegion !=null ? addData.countryRegion.value : null,
													"code" : addData.countryRegion !=null ? addData.countryRegion.code : null
												},
												"city" : {
													"id" : addData.city.id,
													"value" : addData.city.value,
													"code" : addData.city.code
												},
												"cellCountryCode" : addData.cellCountryCode,
												"cellNo" : addData.cellNo,
												"phoneCountryCode" : addData.phoneCountryCode,
												"phoneAreaCode" : addData.phoneAreaCode,
												"phoneNo" : addData.phoneNo,
												"primaryeEmailId" : addData.primaryeEmailId,
												"alternateEmailId" : addData.alternateEmailId,
												"code" : addData.code,
												"addressType" : {
													"id" : addData.addressType.id,
													"value" : addData.addressType.value,
													"code" : addData.addressType.code
												}
											};
											examinationCenter.set("address",address);
											examinationCenter.set("wSCenterRoomDetail",null);
											examinationCenter.set("resourceId",values.resourseId);
											examinationCenter.set("resourceType",values.resourseType);
											/**
											 * 
											 */
											delete examinationCenter.data.whetherRoomCapacitySame;
											var formData = Ext.encode(examinationCenter.data);
											Ext.Ajax.request({
														type : 'rest',
														url : submitUrl,
														jsonData : formData,
														method : 'POST',
														success : function(form, action) {
															 Ext.getBody().unmask();
															showSuccessMessage(getExaminationTranslation('EXAMINATION_CENTER'),getCommonTranslation('SUCCESS'));
															$this.getExaminationcenter().getForm().reset();
															$this.getRoomdetailsgrid().getStore().removeAll();
															$this.getActiveTabfromContentPanel().close();
															$this.getExaminationcentergrid().getStore().reload();
															//$this.loadExamCenter();
														}
													});
										}
									});
						}
						
					},
					editExaminationCenter : function() {
						var $this = this;
						var grid = $this.getExaminationcentergrid();
						var academyLocationId=$this.getCurrentAcademyLocation();
						if (grid.getSelectionModel().getCount() > 0) {
						  $this.showExaminatinCenter();
							var records = grid.getSelectionModel().getSelection();
							
							if (records != undefined && records != ""
									&& records != null) {
								var id = records[0].data.id;
								Ext.Ajax.request({
											type : 'rest',
											url : SERVERURL.EXAMINATION_FIND_BY_ID,
											params : {
												id : id
											},
											method : 'GET',
											success : function(response) {
												var form = $this.getExaminationcenter().getForm();
												var data = Ext.decode(response.responseText);
												form.findField('id').setValue(data.id);
												form.findField('version').setValue(data.version);
												form.findField('addressId').setValue(data.address.id);
												
												var resetButton =Ext.ComponentQuery.query('button#cancelBtn')[0];
				            					 resetButton.setVisible(false);
												//form.down('#cancelBtn').setVisible(false);
												
											 
												var centerCapacityField = form.findField('centerCapacity');
												centerCapacityField.setValue(data.centerCapacity);
												if(data.centerType!=""){
												var centerTypeField = form.findField('centerType');
												centerTypeField.setReadOnly(true);
											/*	centerTypeField.store.load({
															callback : function(records,operation,success) {
																if (success) {
																	centerTypeField.setValue(data.centerType);
																}
															}
														});*/
												centerTypeField.setValue(data.centerType);
												if(data.centerType === 'EXTERNAL') {
													var amenitiesApplicableField=form.findField('amenitiesApplicable');
													amenitiesApplicableField.setVisible(true);
												}
												}		
												
												if(data.centerResponsibleId!=null){
												var centerResponsible = form.findField('centerResponsible');
												centerResponsible.store.load({
															params:{
																academyLocationId:academyLocationId 
															},
															callback : function(records,operation,success) {
																if (success) {
																	centerResponsible.setValue(data.centerResponsibleId);
																}
															}
														});
												}
												var centreActiveField = form.findField('centreActive');
												if(data.whetherActive){
													centreActiveField.items.items[0].setValue(true);
													centreActiveField.items.items[1].setValue(false);
												}else if(!data.whetherActive){
													centreActiveField.items.items[0].setValue(false);
													centreActiveField.items.items[1].setValue(true);
												}
												
												var amenitiesApplicableField = form.findField('amenitiesApplicable');
												var amenitiesField = form.findField('amenities');
												if(data.amenitiesApplicable){
													amenitiesApplicableField.items.items[0].setValue(true);
													amenitiesApplicableField.items.items[1].setValue(false);
													
													var store = amenitiesField.getStore();
													
													var selectedAmenityIds = [];

													if (data.amenitiesMapping && data.amenitiesMapping.length > 0) {
													    Ext.Array.each(data.amenitiesMapping, function(item) {
													        selectedAmenityIds.push(item.id);
															//selectedAmenityIds.push(item.value);
													    });
													}

													store.load({
													    callback: function(records, operation, success) {
													        if (success && selectedAmenityIds.length > 0) {
													            amenitiesField.setValue(selectedAmenityIds); // 🔥 MULTISELECT MAGIC
													        }
													    }
													});
													
												}else if(!data.whetherActive){
													amenitiesApplicableField.items.items[0].setValue(false);
													amenitiesApplicableField.items.items[1].setValue(true);
												}
												
												var amenitiesField = form.findField('amenities');
												
												
												if(data.stageType!=null){
												var stageTypeField = form.findField('stageType');
												stageTypeField.store.load({
															callback : function(records,operation,success) {
																if (success) {
																	stageTypeField.setValue(data.stageType);
																}
															}
														});
												stageTypeField.setValue(data.stageType);
												}
												
												var addReq = Ext.ComponentQuery.query('radiogroup#roomAllotment_Id')[0];
												if (data.allowAllocationBySupervisor) {
													addReq.items.items[0].setValue(true);
													addReq.items.items[1].setValue(false);
												} else if (!data.hasAdditionalRequirement) {
													addReq.items.items[0].setValue(false);
													addReq.items.items[1].setValue(true);
												}

												/*var roomCapacity = Ext.ComponentQuery.query('radiogroup#eachRoomCapacity_Id')[0];
												if (data.whetherRoomCapacitySame) {
													roomCapacity.items.items[0].setValue(true);
													roomCapacity.items.items[1].setValue(false);
												} else if (!data.whetherRoomCapacitySame) {
													roomCapacity.items.items[0].setValue(false);
													roomCapacity.items.items[1].setValue(true);
												}*/
												
												var noOfRoomsField=form.findField('noOfRooms');
												var centreCodeField=form.findField('centreCode');
												var centerNameField=form.findField('centerName');
												var resourseTypeField = form.findField('resourseType');
												var resourseIdField = form.findField('resourseId');
												
												noOfRoomsField.setVisible(false);
												noOfRoomsField.allowBlank=true;
												
												centreCodeField.allowBlank=true;
												centreCodeField.setVisible(false);
												
												centerNameField.allowBlank=true;
												centerNameField.setVisible(false);
												
												resourseTypeField.allowBlank=true;
												resourseTypeField.setVisible(false);
												
												resourseIdField.allowBlank=true;
												resourseIdField.setVisible(false);
												
												var record = [];
												if (data.centerType == getExaminationTranslation('CNTRL_EXTERNAL')) {
													$this.getRoomdetailsgrid().setVisible(true);
													noOfRoomsField.setVisible(true);
													noOfRoomsField.allowBlank=false;
													noOfRoomsField.setValue(data.noOfRooms);
													
													centreCodeField.allowBlank=false;
													centreCodeField.setVisible(true);
													centreCodeField.setValue(data.centreCode);
													
													centerNameField.allowBlank=false;
													centerNameField.setVisible(true);
													centerNameField.setValue(data.centerName);
													
													 
													if (data.wSCenterRoomDetail.length > 0) {
														for (var i = 0; i < data.wSCenterRoomDetail.length; i++) {
															record.push({
																        "id":data.wSCenterRoomDetail[i].id,
																		"roomNumber" : data.wSCenterRoomDetail[i].roomNo,
																		"roomLocation" : data.wSCenterRoomDetail[i].roomLocation,
																		"roomCapacity" : data.wSCenterRoomDetail[i].roomCapacity
																	});
														}
														var store = $this.getStore('examinationcenters.RoomGridBlank');
														store.removeAll();
														store.loadRawData(record, true);  
														
												 }
													var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
													button.setText(getExaminationTranslation('EDIT_ADDRESS'));
												} else {
													centerCapacityField.setReadOnly(true);
													$this.getRoomdetailsgrid().setVisible(false);
													
													resourseTypeField.setVisible(true);
													resourseIdField.setVisible(true);
													resourseIdField.enable();
													resourseTypeField.allowBlank=false;
													resourseIdField.allowBlank=false;
													resourseTypeField.setFieldLabel(getExaminationTranslation('RESOURSE_TYP')+'<span class="required" style="color:red"> *</span>');
													resourseIdField.setFieldLabel(getExaminationTranslation('RESOURSE_COD')+'<span class="required" style="color:red"> *</span>');
													if(data.resourceType!=null){
													resourseTypeField.store.load({
																callback : function(records,operation,success) {
																	if (success) {
																		resourseTypeField.setValue(data.resourceType);
																	}
																}
															});
													
													if(data.resourceId!=null){
													resourseIdField.store.load({
												     	params:{
												     		  resourceTypeId: data.resourceType,
															  academyLocationId:academyLocationId
													          },
																callback : function(records,operation,success) {
																	if (success) {
																		resourseIdField.setValue(data.resourceId);
																	}
																}
															});		
													    }		
													}
													var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
													button.setText(getExaminationTranslation('VIEW_ADDRESS'));
												}
												var store = $this.getStore('examinationcenters.AddressStoreBlank');
												store.removeAll();
												store.loadRawData(data.address,true);
												
											}
										});
							}
							
						}
						else {
							showWarningMessage(getCommonTranslation('ALERT'),
									getCommonTranslation('PLEASE_SELECT_RECORD'));
							grid.getStore().reload();
						}
					},
					/*
					editExaminationCenter : function() {
						var $this = this;
						var grid = $this.getSearchresultgrid();
						var academyLocationId=$this.getCurrentAcademyLocation();
						if (grid.getSelectionModel().getCount() > 0) {
							$this.showExaminatinCenter();
							var records = grid.getSelectionModel().getSelection();
							if (records != undefined && records != ""
									&& records != null) {
								var id = records[0].data.ID;
								Ext.Ajax.request({
											type : 'rest',
											url : SERVERURL.EXAMINATION_FIND_BY_ID,
											params : {
												id : id
											},
											method : 'GET',
											success : function(response) {
												var form = $this.getExaminationcenter().getForm();
												var data = Ext.decode(response.responseText);
												form.findField('id').setValue(data.id);
												form.findField('version').setValue(data.version);
												form.findField('addressId').setValue(data.address.id);
												
												var resetButton =Ext.ComponentQuery.query('button#cancelBtn')[0];
				            					 resetButton.setVisible(false);
												//form.down('#cancelBtn').setVisible(false);
												
												*
												 * Center Capacity will be read only at the time of center type =Internal
												 
												var centerCapacityField = form.findField('centerCapacity');
												centerCapacityField.setValue(data.centerCapacity);
												if(data.centerType!=""){
												var centerTypeField = form.findField('centerType');
												centerTypeField.setReadOnly(true);
												centerTypeField.store.load({
															callback : function(records,operation,success) {
																if (success) {
																	centerTypeField.setValue(data.centerType);
																}
															}
														});
												centerTypeField.setValue(data.centerType);
												}		
												
												if(data.centerResponsibleId!=null){
												var centerResponsible = form.findField('centerResponsible');
												centerResponsible.store.load({
															params:{
																academyLocationId:academyLocationId 
															},
															callback : function(records,operation,success) {
																if (success) {
																	centerResponsible.setValue(data.centerResponsibleId);
																}
															}
														});
												}
												var centreActiveField = form.findField('centreActive');
												if(data.whetherActive){
													centreActiveField.items.items[0].setValue(true);
													centreActiveField.items.items[1].setValue(false);
												}else if(!data.whetherActive){
													centreActiveField.items.items[0].setValue(false);
													centreActiveField.items.items[1].setValue(true);
												}
												
												if(data.stageType!=null){
												var stageTypeField = form.findField('stageType');
												stageTypeField.store.load({
															callback : function(records,operation,success) {
																if (success) {
																	stageTypeField.setValue(data.stageType);
																}
															}
														});
												stageTypeField.setValue(data.stageType);
												}
												
												var addReq = Ext.ComponentQuery.query('radiogroup#roomAllotment_Id')[0];
												if (data.allowAllocationBySupervisor) {
													addReq.items.items[0].setValue(true);
													addReq.items.items[1].setValue(false);
												} else if (!data.hasAdditionalRequirement) {
													addReq.items.items[0].setValue(false);
													addReq.items.items[1].setValue(true);
												}

												var roomCapacity = Ext.ComponentQuery.query('radiogroup#eachRoomCapacity_Id')[0];
												if (data.whetherRoomCapacitySame) {
													roomCapacity.items.items[0].setValue(true);
													roomCapacity.items.items[1].setValue(false);
												} else if (!data.whetherRoomCapacitySame) {
													roomCapacity.items.items[0].setValue(false);
													roomCapacity.items.items[1].setValue(true);
												}
												*
												 * load room details grid while populating data
												 
												var noOfRoomsField=form.findField('noOfRooms');
												var centreCodeField=form.findField('centreCode');
												var centerNameField=form.findField('centerName');
												var resourseTypeField = form.findField('resourseType');
												var resourseIdField = form.findField('resourseId');
												
												noOfRoomsField.setVisible(false);
												noOfRoomsField.allowBlank=true;
												
												centreCodeField.allowBlank=true;
												centreCodeField.setVisible(false);
												
												centerNameField.allowBlank=true;
												centerNameField.setVisible(false);
												
												resourseTypeField.allowBlank=true;
												resourseTypeField.setVisible(false);
												
												resourseIdField.allowBlank=true;
												resourseIdField.setVisible(false);
												
												var record = [];
												if (data.centerType == getExaminationTranslation('CNTRL_EXTERNAL')) {
													$this.getRoomdetailsgrid().setVisible(true);
													noOfRoomsField.setVisible(true);
													noOfRoomsField.allowBlank=false;
													noOfRoomsField.setValue(data.noOfRooms);
													
													centreCodeField.allowBlank=false;
													centreCodeField.setVisible(true);
													centreCodeField.setValue(data.centreCode);
													
													centerNameField.allowBlank=false;
													centerNameField.setVisible(true);
													centerNameField.setValue(data.centerName);
													
													*
													 * It is used to load data in room grid 
													 
													if (data.wSCenterRoomDetail.length > 0) {
														for (var i = 0; i < data.wSCenterRoomDetail.length; i++) {
															record.push({
																        "id":data.wSCenterRoomDetail[i].id,
																		"roomNumber" : data.wSCenterRoomDetail[i].roomNo,
																		"roomLocation" : data.wSCenterRoomDetail[i].roomLocation,
																		"roomCapacity" : data.wSCenterRoomDetail[i].roomCapacity
																	});
														}
														var store = $this.getStore('examinationcenters.RoomGridBlank');
														store.removeAll();
														store.loadRawData(record, true);  
														
												 }
													var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
													button.setText(getExaminationTranslation('EDIT_ADDRESS'));
												} else {
													centerCapacityField.setReadOnly(true);
													$this.getRoomdetailsgrid().setVisible(false);
													
													resourseTypeField.setVisible(true);
													resourseIdField.setVisible(true);
													resourseIdField.enable();
													resourseTypeField.allowBlank=false;
													resourseIdField.allowBlank=false;
													resourseTypeField.setFieldLabel(getExaminationTranslation('RESOURSE_TYP')+'<span class="required" style="color:red"> *</span>');
													resourseIdField.setFieldLabel(getExaminationTranslation('RESOURSE_COD')+'<span class="required" style="color:red"> *</span>');
													if(data.resourceType!=null){
													resourseTypeField.store.load({
																callback : function(records,operation,success) {
																	if (success) {
																		resourseTypeField.setValue(data.resourceType);
																	}
																}
															});
													
													if(data.resourceId!=null){
													resourseIdField.store.load({
												     	params:{
												     		  resourceTypeId: data.resourceType,
															  academyLocationId:academyLocationId
													          },
																callback : function(records,operation,success) {
																	if (success) {
																		resourseIdField.setValue(data.resourceId);
																	}
																}
															});		
													    }		
													}
													var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
													button.setText(getExaminationTranslation('VIEW_ADDRESS'));
												}
												var store = $this.getStore('examinationcenters.AddressStoreBlank');
												store.removeAll();
												store.loadRawData(data.address,true);
												
											}
										});
							}
						} else {
							showWarningMessage(getCommonTranslation('ALERT'),
									getCommonTranslation('PLEASE_SELECT_RECORD'));
							grid.getStore().reload();
						}
					},*/
					getIdValueJson : function(id, value, code) {
						if (id)
							return {
								id : id,
								value : value,
								code : code
							};
					},
					deleteExaminationCenterRest : function(){
						var $this = this;
						var grid = $this.getExaminationcentergrid();
						
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(getExaminationTranslation('EXAMINATION_CENTER'),getExaminationTranslation('STATUS_CONFIRM_MESSAGE'),function(btn, text) {
								if (btn == 'yes') {
									var records = grid.getSelectionModel().getSelection()[0];
									var id = records.data.id;
									var status=null;
									var centerStatus=records.data.whetherActive;
									if(centerStatus){
										status=false;
									}else{
										status=true;
									}
									Ext.Ajax.request({
										method : "DELETE",
										type : 'rest',
										url : SERVERURL.EXAMINATION_DELTE+ '?id='+ id+'&status='+status,
										headers : {
											'Content-Type' : 'application/json'
										},
										params : {
											id : id
										},
										success : function(form,action) {
											showSuccessMessage(getExaminationTranslation('EXAMINATION_CENTER_WITHOUT_S'),getCommonTranslation('SUCCESS'));
											grid.getSelectionModel().deselectAll();
											grid.getStore().reload();
										}
									});
								}
							});
						} else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
						
					},
					delteExaminationCenter : function() {
						var $this = this;
						var grid = $this.getSearchresultgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(getExaminationTranslation('EXAMINATION_CENTER'),getExaminationTranslation('STATUS_CONFIRM_MESSAGE'),function(btn, text) {
								if (btn == 'yes') {
									var records = grid.getSelectionModel().getSelection()[0];
									var id = records.data.ID;
									var status=null;
									var centerStatus=records.data.CENTER_STATUS;
									if(centerStatus==getExaminationTranslation('CNTRL_ACTIVE')){
										status=false;
									}else if(centerStatus==getExaminationTranslation('CNTRL_INACTIVE')){
										status=true;
									}
									Ext.Ajax.request({
										method : "DELETE",
										type : 'rest',
										url : SERVERURL.EXAMINATION_DELTE+ '?id='+ id+'&status='+status,
										headers : {
											'Content-Type' : 'application/json'
										},
										params : {
											id : id
										},
										success : function(form,action) {
											showSuccessMessage(getExaminationTranslation('EXAMINATION_CENTER_WITHOUT_S'),getCommonTranslation('SUCCESS'));
											grid.getStore().reload();
										}
									});
								}
							});
						} else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					},
					viewExamCenter : function() {
						this.editExaminationCenter();
						var form = this.getExaminationcenter();
						if (form) {
							form.down('#submitBtn').hide();
							form.down('#cancelBtn').hide();
							form = form.getForm();
							toggleReadOnlyFormItems(form, true);
						}
						var roomDetailGrid = this.getRoomdetailsgrid();
						roomDetailGrid.down('button#btnAdd').setVisible(false);
						roomDetailGrid.down('button#btnDelete').setVisible(false);
						//this.getRoomdetails().down('button#roomDetailsubmitBtn').hide();
						var button = Ext.ComponentQuery.query('button#examinationAddressDetailsWin')[0];
						var task = new Ext.util.DelayedTask(function(){
							button.setText(getExaminationTranslation('VIEW_ADDRESS'));
						});
       					
       					task.delay(1000);
					},
					//************************disableMoreActionPivileges **************************************************
					disableMoreActionPivileges: function(gridReference,permissionsMap) {
				    	
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				    	
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
						var button = gridReference.down('#spBtnMoreActions');
						button.setVisible(false);
						var enableButton = gridReference.down('#enableDisableItemId');
						enableButton.setVisible(false);
				    	Ext.each(permissionList, function(privilege) {
				    		if (privilege === 'MOREACTIONS') {
				        		//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
				        		if(!isNullOrEmpty(button)){
				        			button.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'ENABLE') {
				        		//var button = buttonsToolBar.query('#enableDisableItemId')[0];
				        		if(!isNullOrEmpty(button)){
				        			enableButton.setVisible(true);
				        		}        		
				        	}
				    	});
				    },
					//***********************
					disableMoreActionPivilegesRest: function(gridReference,permissionsMap) {
				    	
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				    	
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
						var button = gridReference.down('#spBtnMoreActionsAssessmentEvent');
						button.setVisible(false);
						var enableButton = gridReference.down('#examCenterDeleteBtn');
						enableButton.setVisible(false);
				    	Ext.each(permissionList, function(privilege) {
				    		if (privilege === 'MOREACTIONS') {
				        		var button = buttonsToolBar.query('#spBtnMoreActionsAssessmentEvent')[0];
				        		if(!isNullOrEmpty(button)){
				        			button.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'ENABLE') {
				        		var button = buttonsToolBar.query('#examCenterDeleteBtn')[0];
				        		if(!isNullOrEmpty(button)){
				        			enableButton.setVisible(true);
				        		}        		
				        	}
				    	});
				    },
					exportUserList : function(exportUrl,filetype,whetherAll) {
				        var quickSearchForm=this.getExaminationsearch(); 
				        var searchResultGrid = this.getSearchresultgrid();
						var form=quickSearchForm.getForm();
				        var centerTypeField=form.findField('centerType');
						var configCode=null;
						if(centerTypeField.getValue()==getExaminationTranslation('CNTRL_INTERNAL')){
							configCode=CONSTANTS.CB.EXAMINATION_INTERNAL_CENTER_LISTING_CONFIGCODE;
						}else if(centerTypeField.getValue()==getExaminationTranslation('CNTRL_EXTERNAL')){
							configCode=CONSTANTS.CB.EXAMINATION_CENTER_LISTING_CONFIGCODE;
						}
				        var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
				        var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
				        var jsonFormatFormData=this.createJsonFormat(quickSearchForm,configCode);
				        var visibleColumns=this.getVisibleColumns(searchResultGrid);
				        var reportTitle=getCommonTranslation('EXAMINATION_CENTER_LIST');
				if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
				                      jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
				               }
				searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

				},


				    	createSearchCriteriaString: function(searchForm) {
				    	    	 var me=this;
				    	        var formValues = new Array();
				    	        formValues = searchForm.getValues();        
				    	        var searchCriteriaString="";
				    	        for (var key in formValues) {
				    	        	var value = formValues[key];            
				    	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
				    	                var keyValueJsonObject = me.getJsonObject( key , value);
				    	searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
				    	            }
				    	        }
				    	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
				    	        return searchCriteriaString;
				    	}	
		

					
				});
