/**
 * @author Sumit meena
 */
Ext.define('Academia.controller.examinationcenters.evaluation.evaluationPlanHierarchy.EvaluationLevelOneAndTwoFormController', {
   // extend: 'Ext.app.Controller',
    extend: 'Academia.controller.base.BaseController',  
    stores: ['examinationcenters.evaluation.EvaluationType','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPlanHeirarchyStore','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForAcademic','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationTypeOtherLevelOneForm',
             'examinationcenters.evaluation.CourseMaster','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForExternal','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForOther','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
             'examinationcenters.evaluation.OtherCategory','examinationcenters.evaluation.evaluationPlanHeirarchy.RepetitionTypeEnumStore','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventsByLevelIdStore','examinationcenters.evaluation.RoundingModeForLevelOne',
             'examinationcenters.evaluation.RoundingModeForLevelTwo','examinationcenters.evaluation.evaluationPlanHeirarchy.SuppplementaryDroolStore'],
    models: ['genericmodels.dropdowns.EnumCombo','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationLevelOneForm','common.IdValueCodeDataModel','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSequenceForm',
             'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrade'],
    views: ['examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanLevelOneForm','examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanLevelTwoForm'],
    config:{
   		ASSESSMENT_SCHEME_SUBTYPE_LEVEL_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ASSESSMENT_SCHEME_SUBTYPE_LEVEL_PRIVILEGES')
	   },
    refs: [ {
		        ref: 'evaluationplanleveloneform',
		        selector: 'evaluationplanleveloneform'
	    	},
	    	{
		        ref: 'evaluationPlanLeveloneForm',
		        selector: 'evaluationplanleveloneform form'
	    	},
	    	{
		        ref: 'evaluationplanleveltwoform',
		        selector: 'evaluationplanleveltwoform'
	    	},
	    	{
		        ref: 'evaluationPlanLeveltwoForm',
		        selector: 'evaluationplanleveltwoform form'
	    	},
	    	{
		        ref: 'evaluationplanbasicdetailform',
		        selector: 'evaluationplanbasicdetailform'
	    	}
    ],
    init: function(application) {
        this.control({
        	'evaluationplanleveloneform button[itemId=addButtonItemId]':{
        		click:function(){
        			var form=this.getEvaluationPlanLeveloneForm();
        			form.down('#addButtonItemId').setDisabled(true);
        			this.saveFormData();
        		}
        	},
        	'evaluationplanleveltwoform button[itemId=levelTwoAddButtonId]':{
        		click:function(){
        			var form=this.getEvaluationplanleveltwoform();
        			form.down('#levelTwoAddButtonId').setDisabled(true);
        			this.saveLevelTwoFormData();
        		}
        	},
        	'evaluationplanleveloneform':{
        		afterrender:function(obj){
        		 var $this=this;
        		 var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
     		     var node=tree.getSelectionModel().getSelection()[0];
     	    	 var evaluationFirstLevelId=node.data.cls;
        		 var form=$this.getEvaluationplanbasicdetailform().getForm();
     			 var evaluationTypeValue=form.findField('evaluationPlanType').getValue();
     			 var evaluationPlanId=form.findField('id').getValue();
     			 var levelOneForm=obj.getForm();
     			 var calculateAverageField=levelOneForm.findField('calculateAverage');
     			 calculateAverageField.setVisible(false);
		         var marksOrGradeField=levelOneForm.findField('marksOrGrade');
		         var printNameInMarksheetField = levelOneForm.findField('printNameInMarksheet');
			     var whetherFinalPromotionLevel = levelOneForm.findField('whetherFinalPromotionLevel');
			     whetherFinalPromotionLevel.setBoxLabel(getExaminationTranslation('WHETHER_FINAL_PROMOTION_LEVEL'));
		         printNameInMarksheetField.setVisible(true);
     			 /**
     			  * According to the Assessment Type in masters entry evaluation Type fields are shown in first level form.
     			  */
     			 if(evaluationTypeValue==getExaminationTranslation('CNTRL_ACADEMICS')){
     				var evaluationTypeOtherField=levelOneForm.findField('evaluationTypeOther');
     				evaluationTypeOtherField.allowBlank=true;
     				var evaluationTypeAcademic=levelOneForm.findField('evaluationTypeAcademic');
     				evaluationTypeAcademic.show();
     				evaluationTypeAcademic.allowBlank=false;
     				evaluationTypeAcademic.setReadOnly(false);
     				evaluationTypeAcademic.getStore().getProxy().extraParams = {
     					evaluationPlanId:evaluationPlanId
    				   };
     				evaluationTypeAcademic.getStore().load();
     				 /**
     	          	   * Course and marking method checks in case of Assessment type "ACADEMICS" only.
     	          	   */
     		          	var courseGradeTypeForAcademicsValue=form.findField('courseGradeTypeForAcademics').getValue();
     		          	var markingMethodValue=form.findField('markingMethod').getValue();
						var isDroolApplicable = form.findField('whetherDroolApplicable').getValue().isDroolApplicable;
						if(form.findField('drools').valueModels.length>0){
					    	var drools=form.findField('drools').valueModels[0].data.code;	
					    }	
						var whetherPassesCriticalField=levelOneForm.findField('whetherPassesCriticalId');
     		          	var minMarksOrGradeNumberField=levelOneForm.findField('minMarksOrGradeNumber');
     	    			var maxMarksOrGradeNumberField=levelOneForm.findField('maxMarksOrGradeNumber');
     	    			var minMarksOrGradeComboField=levelOneForm.findField('minMarksOrGradeCombo');
     	    			var maxMarksOrGradeComboField=levelOneForm.findField('maxMarksOrGradeCombo');
     	    			
     	    			var minMarksOrGradeAwardComboField=levelOneForm.findField('minMarksOrGradeAwardCombo');
     	    			var maxMarksOrGradeAwardComboField=levelOneForm.findField('maxMarksOrGradeAwardCombo');
     	    			
     	    			var gradeTypeField=levelOneForm.findField('gradeType');
     	    			whetherPassesCriticalField.setVisible(true);
     	    			whetherPassesCriticalField.disable();
    	    			marksOrGradeField.setReadOnly(false);
     	    			gradeTypeField.allowBlank=true;
     	    			
     	    			minMarksOrGradeComboField.allowBlank=true;
     					maxMarksOrGradeComboField.allowBlank=true;
     					minMarksOrGradeNumberField.allowBlank=true;
     					maxMarksOrGradeNumberField.allowBlank=true;
     	    			
     	    			gradeTypeField.setVisible(false);
     	    			
     					minMarksOrGradeComboField.setVisible(false);
     					maxMarksOrGradeComboField.setVisible(false);
     					minMarksOrGradeNumberField.setVisible(false);
     					maxMarksOrGradeNumberField.setVisible(false);
     					
     	                gradeTypeField.reset();
     					
     	               calculateAverageField.setVisible(true);
     	                
     					minMarksOrGradeComboField.reset();
     					minMarksOrGradeNumberField.reset();
     						
     		          	if(courseGradeTypeForAcademicsValue=="RELATIVE" && markingMethodValue=="CONSOLIDATED"){
     		          		/**
     		          		 * Mark is shown in marksOrGrade Field
     		          		 */
     		          		marksOrGradeField.getStore().load({
     		          			callback:function(rec,success){
     		          				marksOrGradeField.setValue(rec[0]);
     		          			}
     		          		});
     		          		marksOrGradeField.setReadOnly(true);
     		          		
     		          		minMarksOrGradeNumberField.allowBlank=false;
     	    				maxMarksOrGradeNumberField.allowBlank=false;
     	    				
     	    				minMarksOrGradeNumberField.setVisible(true);
     	    				maxMarksOrGradeNumberField.setVisible(true);
     	    				
     		          		
     		          	}else if(courseGradeTypeForAcademicsValue=="RELATIVE" && markingMethodValue=="INDIVIDUAL"){
     		          	
     		          		/**
     		          		 * Grade is shown in marksOrGrade Field
     		          		 */
     		          		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
     		          		marksOrGradeField.getStore().load({
     		          			callback:function(rec,success){
     		          				marksOrGradeField.setValue(rec[1]);
     		          			}
     		          		});
     		          		marksOrGradeField.setReadOnly(true);
     		          		
     		          		gradeTypeField.setVisible(true);
     	    				
     	    				gradeTypeField.allowBlank=false;
     	    				//gradeTypeField.setFieldLabel(gradeTypeField.getFieldLabel()+allowblankFalse);
     	    				
     	    				minMarksOrGradeComboField.allowBlank=false;
     	    				maxMarksOrGradeComboField.allowBlank=false;
     	    				
     	    				/*minMarksOrGradeComboField.setFieldLabel(minMarksOrGradeComboField.getFieldLabel()+allowblankFalse);
     	    				maxMarksOrGradeComboField.setFieldLabel(maxMarksOrGradeComboField.getFieldLabel()+allowblankFalse);
     	    				*/
     	    				minMarksOrGradeComboField.setVisible(true);
     	    				maxMarksOrGradeComboField.setVisible(true);
     	    				
     		          	}else if(isNullOrEmpty(courseGradeTypeForAcademicsValue)){
     		          		/**
     		          		 * Mark is shown in marksOrGrade Field
     		          		 */
     		          		marksOrGradeField.getStore().load({
     		          			callback:function(rec,success){
     		          				marksOrGradeField.setValue(rec[0]);
     		          			}
     		          		});
     		          		marksOrGradeField.setReadOnly(true);
     		          		
     		          		minMarksOrGradeNumberField.allowBlank=false;
     	    				maxMarksOrGradeNumberField.allowBlank=false;
     	    				
     	    				minMarksOrGradeNumberField.setVisible(true);
     	    				maxMarksOrGradeNumberField.setVisible(true);
     	    				
     		          	}
     				
     			 }else if(evaluationTypeValue==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
     				var evaluationTypeExternalField=levelOneForm.findField('evaluationTypeExternal');
     				evaluationTypeExternalField.show();
     				evaluationTypeExternalField.allowBlank=false;
     				/**
     				 * Here evaluationTypeExternalField populate on the bases of external master id on basic detail tab
     				 */
     				var externalId=form.findField('externalCourseMaster').getValue();
     				evaluationTypeExternalField.store.load({
  	              		 callback: function(records, operation, success) {
  	              			 if (success) {
  	              				evaluationTypeExternalField.setValue(externalId);
  	              			 }
  	              		 }
  	              	 });
     				//evaluationTypeExternalField.getStore().load();
     				evaluationTypeExternalField.setReadOnly(true);
     			 }else if(evaluationTypeValue==getExaminationTranslation('CNTRL_OTHER')){
     				var evaluationTypeOtherField=levelOneForm.findField('evaluationTypeOther');
     				var categoryId=form.findField('categoryId').getValue(); 
     				
     				var evaluationTypeAcademic=levelOneForm.findField('evaluationTypeAcademic');
     				evaluationTypeAcademic.allowBlank=true;
     				
     				var resultPublishMode=levelOneForm.findField('resultPublishMode');
     		    		if(form.findField('categoryId').valueModels[0]!=undefined && 
     		    				form.findField('categoryId').valueModels[0].data.code=="true"){
     		        		resultPublishMode.reset(); 
     		        		resultPublishMode.enable();
     		        		resultPublishMode.setVisible(true);
     		        		resultPublishMode.getStore().load({
     			          			callback:function(rec,success){
     			          				resultPublishMode.setValue(rec[1].data.id);
     			          			}
     			     });
     		        }
     				
     				var markOrGradeBasicDetail=form.findField('marksOrGrade').getValue();
     				if(markOrGradeBasicDetail==getExaminationTranslation('CNTRL_MARK')) {
     					marksOrGradeField.getStore().load({
 		          			callback:function(rec,success){
 		          				marksOrGradeField.setValue(rec[0]);
 		          			}
 		          		});
 		          		marksOrGradeField.setReadOnly(true);
     				}
     				evaluationTypeOtherField.show();
     				evaluationTypeOtherField.allowBlank=false;
     				if(!evaluationTypeOtherField.isHidden()){
        				var evaluationTypeOtherStore=evaluationTypeOtherField.getStore();
        				evaluationTypeOtherStore.getProxy().extraParams = {
        					evaluationPlanId:evaluationPlanId,
        					evaluationPlanLevelOneId : evaluationFirstLevelId
	    				   };
        				evaluationTypeOtherStore.load({
        					 callback: function(records, operation, success) {
      	              			 if (success) {
      	              				evaluationTypeOtherField.setValue(categoryId);
      	              				evaluationTypeOtherField.allowBlank=true;
  	              					printNameInMarksheetField.setValue(form.findField('categoryId').getRawValue());
      	              			 }
      	              		 }
        				});
        				//evaluationTypeOtherField.setReadOnly(true);
        				
        			}
     			 }
     			 
     			var roundingMode=levelOneForm.findField('roundingMode');
			  	roundingMode.getStore().load({
   				callback:function(){
   					roundingMode.setValue("HALF_UP");		
   				}
			  	});
			  	var roundingCount=levelOneForm.findField('roundingCount');
			  	setTimeout(function(){
			  		roundingCount.setValue(2);
			  	},300);
			  	var obeWeightage=levelOneForm.findField('obeWeightage');
			  	 Ext.Ajax.request({
 					type: 'rest',
 					async: false,
 					url: SERVERURL.COMMON_FORM_FIELD_INFO,
 					params: {
 						//screenName: 'Manage Receipt',
 						academyLocationId: this.getCurrentAcademyLocation(),
 						languageCode:'en'
 					},
 					method: 'GET',
 					success: function(res, action) {
 						var response = Ext.decode(res.responseText);
 						if( Object.keys(response).length > 0 ){
 							var records=response.evaluationplanleveloneform;
 							for(i in records){
 								if(records[i].formFieldInputType=="numberfield" && records[i].formFieldId=="obeWeightage" && records[i].isVisible==true){
 									obeWeightage.setValue(records[i].defaultValue);
 										break;
 									}
 								
 							}
 						}
 					}
 				});
			  	
					/* var obeWeightage=levelOneForm.findField('obeWeightage');
					setTimeout(function(){
			  				obeWeightage.setValue(100);
			  				},300)*/
     			/**
     			  * According to Weightage relevant if (Yes) weight field is shown in first level form.
     			  */
     			/*var weightValue=form.findField('weightageRelevant').getValue();
     			if(!weightValue.isWeightagesRelevant){
     				levelOneForm.findField('weightage').hide();
     				levelOneForm.findField('weightage').allowBlank=true;
     			}*/
				
	          }
        	},
        	'evaluationplanleveltwoform':{
        		afterrender:function(obj){
        			var $this=this;
        			var evaluationLevelTwoForm=obj.getForm();
        			var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
        		    var node=	tree.getSelectionModel().getSelection()[0];
        	    	var evaluationSecondLevelId=node.data.cls;
    				var evaluationFirstLevelId = node.parentNode.data.cls;
        			var form=$this.getEvaluationplanbasicdetailform().getForm();
        			var evaluationTypeValue=form.findField('evaluationPlanType').getValue();
					var isDroolApplicable = form.findField('whetherDroolApplicable').getValue().isDroolApplicable;
					
					if(form.findField('drools').valueModels.length >0){
						var drools=form.findField('drools').valueModels[0].data.code;	
					}
					var whetherPassesCriticalField=evaluationLevelTwoForm.findField('whetherPassesCriticalId');
        			
        			var courseComponentAcademicField=evaluationLevelTwoForm.findField('courseComponentAcademic');
        			var courseComponentExternalField=evaluationLevelTwoForm.findField('courseComponentExternal');
        			var courseComponentOtherField=evaluationLevelTwoForm.findField('courseComponentOther');
        			var calculateAverageField=evaluationLevelTwoForm.findField('calculateAverage');
        			var zscoreField=evaluationLevelTwoForm.findField('zscore');
    	          	var marksOrGradeField=evaluationLevelTwoForm.findField('marksOrGrade');
    	          	var courseGradeTypeForAcademicsValue=form.findField('courseGradeTypeForAcademics').getValue();
    	          	var whetherFinalPromotionLevel = evaluationLevelTwoForm.findField('whetherFinalPromotionLevel');
    			    whetherFinalPromotionLevel.setBoxLabel(getExaminationTranslation('WHETHER_FINAL_PROMOTION_LEVEL'));
    		        
    	          	
        			calculateAverageField.setVisible(false);
        			
        			courseComponentAcademicField.setVisible(false);
        			courseComponentAcademicField.allowBlank=true;
        			courseComponentExternalField.setVisible(false);
        			courseComponentExternalField.allowBlank=true;
        			courseComponentOtherField.setVisible(false);
        			courseComponentOtherField.allowBlank=true;
 	    			
        			if(node.data.depth==2) {
	        			Ext.Ajax.request({
		       	  	   		type: 'rest',
		       	  	   		url: SERVERURL.EVALUATION_PLAN_LEVEL_ONE_FORM_FIND_BY_ID,
		       	  	   		method: 'GET',
		       	  	   		params:{
		       	  	   			id:evaluationSecondLevelId
		       	  	   		},
		       	  	   		success: function(rsp, action) {
		       	  	   			var data = rsp.responseText;
		       					var jData=Ext.JSON.decode(data);
		           	          	if(jData.marksOrGrade==getExaminationTranslation('CNTRL_MARK')) {
		           	          		marksOrGradeField.getStore().load({
	        		          			callback:function(rec,success){
	        		          				marksOrGradeField.setValue(rec[0]);
	        		          			}
	        		          		});
		        		          	marksOrGradeField.setReadOnly(true);
		           	          	}
		       	  	   		}
	        			});
        			}
        			if(evaluationTypeValue==getExaminationTranslation('CNTRL_ACADEMICS')){
        				/**
        				 * Store will load on the bases of Assessment Type In second level form
        				 */
						whetherPassesCriticalField.setVisible(true);
        				//whetherPassesCriticalField.disable();
        				whetherPassesCriticalField.setDisabled(true);   
        				 
        				courseComponentAcademicField.show();
        				courseComponentAcademicField.allowBlank=false;
        				courseComponentAcademicField.labelSeparator='';
        				courseComponentAcademicField.setFieldLabel(getExaminationTranslation('EVALUATION_SUB_TYPE')+':'+'<span class="required" style="color:red"> *</span>');
        				/**
        				 * here rest call is been changed for course component in academics case
        				 */
        				var courseIdField=form.findField('courseId');
        				
        				if(!courseIdField.isHidden()){
        				var ccAcademicStore=courseComponentAcademicField.getStore();
        				  ccAcademicStore.getProxy().extraParams = {
	    					 evaluationPlanLevelOneId:evaluationSecondLevelId
	    				   };
        				  ccAcademicStore.load();
        				}
        				
        				
        				 /**
	                  	   * Course and marking method checks in case of Assessment type "ACADEMICS" only.
	                  	   */
            	          	var markingMethodValue=form.findField('markingMethod').getValue();
            	          	var minMarksOrGradeNumberField=evaluationLevelTwoForm.findField('minMarksOrGradeNumber');
                			var maxMarksOrGradeNumberField=evaluationLevelTwoForm.findField('maxMarksOrGradeNumber');
                			var minMarksOrGradeComboField=evaluationLevelTwoForm.findField('minMarksOrGradeCombo');
                			var maxMarksOrGradeComboField=evaluationLevelTwoForm.findField('maxMarksOrGradeCombo');
                			
                			var minMarksOrGradeAwardComboField=evaluationLevelTwoForm.findField('minMarksOrGradeAwardCombo');
                			var maxMarksOrGradeAwardComboField=evaluationLevelTwoForm.findField('maxMarksOrGradeAwardCombo');
                			
                			var gradeTypeField=evaluationLevelTwoForm.findField('gradeType');
                			
                			marksOrGradeField.setReadOnly(false);
                			gradeTypeField.allowBlank=true;
                			
                			minMarksOrGradeComboField.allowBlank=true;
            				maxMarksOrGradeComboField.allowBlank=true;
            				minMarksOrGradeNumberField.allowBlank=true;
            				maxMarksOrGradeNumberField.allowBlank=true;
                			
                			gradeTypeField.setVisible(false);
                			
            				minMarksOrGradeComboField.setVisible(false);
            				maxMarksOrGradeComboField.setVisible(false);
            				minMarksOrGradeNumberField.setVisible(false);
            				maxMarksOrGradeNumberField.setVisible(false);
            				
            				
                            gradeTypeField.reset();
            				
                            calculateAverageField.setVisible(true);
                            
                            permissionsMap=this.getASSESSMENT_SCHEME_SUBTYPE_LEVEL_PERMISSION();
              			    this.hidezScoreFieldPivileges(evaluationLevelTwoForm,permissionsMap);

              			    if(courseGradeTypeForAcademicsValue=="RELATIVE" && markingMethodValue=="CONSOLIDATED"){
            	          		/**
            	          		 * Mark is shown in marksOrGrade Field
            	          		 */
            	          		marksOrGradeField.getStore().load({
            	          			callback:function(rec,success){
            	          				marksOrGradeField.setValue(rec[0]);
            	          			}
            	          		});
            	          		marksOrGradeField.setReadOnly(true);
            	          		
            	          		minMarksOrGradeNumberField.allowBlank=false;
                				maxMarksOrGradeNumberField.allowBlank=false;
                				
                				minMarksOrGradeNumberField.setVisible(true);
                				maxMarksOrGradeNumberField.setVisible(true);
 
              			    }else if(courseGradeTypeForAcademicsValue=="RELATIVE" && markingMethodValue=="INDIVIDUAL"){
            	          		
            	          		/**
            	          		 * Grade is shown in marksOrGrade Field
            	          		 */
            	          		marksOrGradeField.getStore().load({
            	          			callback:function(rec,success){
            	          				marksOrGradeField.setValue(rec[1]);
            	          			}
            	          		});
            	          		marksOrGradeField.setReadOnly(true);
            	          		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
            	          		gradeTypeField.setVisible(true);
                				
                				gradeTypeField.allowBlank=false;
                				//gradeTypeField.setFieldLabel(gradeTypeField.getFieldLabel()+allowblankFalse);
                				minMarksOrGradeComboField.allowBlank=false;
                				maxMarksOrGradeComboField.allowBlank=false;
                				
                				/*minMarksOrGradeComboField.setFieldLabel(minMarksOrGradeComboField.getFieldLabel()+allowblankFalse);
         	    				maxMarksOrGradeComboField.setFieldLabel(maxMarksOrGradeComboField.getFieldLabel()+allowblankFalse);
                				*/
                				minMarksOrGradeComboField.setVisible(true);
                				maxMarksOrGradeComboField.setVisible(true);
                			
              			    }else if(isNullOrEmpty(courseGradeTypeForAcademicsValue)){
            	          		/**
            	          		 * Mark is shown in marksOrGrade Field
            	          		 */
            	          		marksOrGradeField.getStore().load({
            	          			callback:function(rec,success){
            	          				marksOrGradeField.setValue(rec[0]);
            	          			}
            	          		});
            	          		marksOrGradeField.setReadOnly(true);
            	          		
            	          		minMarksOrGradeNumberField.allowBlank=false;
                				maxMarksOrGradeNumberField.allowBlank=false;
                				
                				minMarksOrGradeNumberField.setVisible(true);
                				maxMarksOrGradeNumberField.setVisible(true);
                				
                			}
        				
        			}else if (evaluationTypeValue==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
        				
        				courseComponentExternalField.show();
        				courseComponentExternalField.allowBlank=false;
        				courseComponentExternalField.setFieldLabel(getExaminationTranslation('COURSE_ASSESSMENT')+'<span class="required" style="color:red"> *</span>');
                        var externalCourseField=form.findField('externalCourseMaster');
        				
        				if(!externalCourseField.isHidden()){
        				var ccExternalStore=courseComponentExternalField.getStore();
        				ccExternalStore.getProxy().extraParams = {
	    					 id: externalCourseField.getValue(),
	    					 evaluationPlanLevelTwoId:evaluationSecondLevelId
	    				   };
        				ccExternalStore.load();
        				}
        			}else if(evaluationTypeValue==getExaminationTranslation('CNTRL_OTHER')){
        				courseComponentOtherField.show();
        				courseComponentOtherField.allowBlank=false;
        				courseComponentOtherField.setFieldLabel(getExaminationTranslation('SUB_CATEGORY')+'<span class="required" style="color:red"> *</span>');
                        var categoryIdField=form.findField('categoryId');
                        var categoryId ;

                        /**below changes required are for sub catagry related changes found in DRS by Amruta**/
        				var store = $this.getStore('examinationcenters.evaluation.OtherCategory');
            	    	var catagryName=node.data.text;
            	    	if(!categoryIdField.isHidden()){
            	    		store.load({
            	    			callback:function(record){
            	    				var flag=false;
            	    				for(var i in record){
            	    					if(record[i].data.value==catagryName){
            	    						flag=true;
            	    						categoryId=record[i].data.id;
            	    						var ccOtherStore=courseComponentOtherField.getStore();
            	    						if(isNullOrEmpty(evaluationFirstLevelId)){
            	    							ccOtherStore.getProxy().extraParams = {
                	    							id: categoryId,
                	    							evaluationPlanLevelOneId: evaluationSecondLevelId,
                	    							evaluationPlanLevelTwoId:evaluationFirstLevelId
                	    						};
            	    						} else {
            	    							ccOtherStore.getProxy().extraParams = {
                	    							id: categoryId,
                	    							evaluationPlanLevelOneId: evaluationFirstLevelId,
                	    							evaluationPlanLevelTwoId:evaluationSecondLevelId
                	    						};
            	    						}
            	    						ccOtherStore.load();
            	    					}
            	    				}
            	    				if(!flag) {
            	    					for(var i in record){
            	    						if(record[i].data.value==node.parentNode.data.text){
            	    							categoryId=record[i].data.id;
            	    							var ccOtherStore=courseComponentOtherField.getStore();
            	    							if(isNullOrEmpty(evaluationFirstLevelId)){
                	    							ccOtherStore.getProxy().extraParams = {
                    	    							id: categoryId,
                    	    							evaluationPlanLevelOneId: evaluationSecondLevelId,
                    	    							evaluationPlanLevelTwoId:evaluationFirstLevelId
                    	    						};
                	    						} else {
                	    							ccOtherStore.getProxy().extraParams = {
                    	    							id: categoryId,
                    	    							evaluationPlanLevelOneId: evaluationFirstLevelId,
                    	    							evaluationPlanLevelTwoId:evaluationSecondLevelId
                    	    						};
                	    						}
            	    							ccOtherStore.load();
            	    						}
            	    					}
            	    				}
            	    			}
            	    		});
            	    	}
        			}
        			
        			/*var weightValue=form.findField('weightageRelevant').getValue();
         			if(!weightValue.isWeightagesRelevant){
         				evaluationLevelTwoForm.findField('weightage').hide();
         				evaluationLevelTwoForm.findField('weightage').allowBlank=true;
         			}*/
         			
        			var roundingMode=evaluationLevelTwoForm.findField('roundingMode');
    			  	roundingMode.getStore().load({
       				callback:function(){
       					roundingMode.setValue("HALF_UP");		
       				}
    			  	});
    			  	var roundingCount=evaluationLevelTwoForm.findField('roundingCount');
    			  	setTimeout(function(){
    			  		roundingCount.setValue(2);
    			  	},300);
    			  	
    			  	var obeWeightage=evaluationLevelTwoForm.findField('obeWeightage');
    			  	 Ext.Ajax.request({
    	 					type: 'rest',
    	 					async: false,
    	 					url: SERVERURL.COMMON_FORM_FIELD_INFO,
    	 					params: {
    	 						//screenName: 'Manage Receipt',
    	 						academyLocationId: this.getCurrentAcademyLocation(),
    	 						languageCode:'en'
    	 					},
    	 					method: 'GET',
    	 					success: function(res, action) {
    	 						var response = Ext.decode(res.responseText);
    	 						if( Object.keys(response).length > 0 ){
    	 							var records=response.evaluationplanleveltwoform;
    	 							for(i in records){
    	 								if(records[i].formFieldInputType=="numberfield" && records[i].formFieldId=="obeWeightage" && records[i].isVisible==true){
    	 									obeWeightage.setValue(records[i].defaultValue);
    	 										break;
    	 									}
    	 								
    	 							}
    	 						}
    	 					}
    	 				});
					/* var obeWeightage=evaluationLevelTwoForm.findField('obeWeightage');
					setTimeout(function(){
			  				obeWeightage.setValue(100);
			  				},300)*/
	   	           whetherPassesCriticalField.setDisabled(true);   

        		 }
        	  },
        	  /**
        	   * after render on field because when ever user come first time on screen we have change field label on the bases of evaluation type. 
        	   */
	        	'evaluationplanleveloneform textfield[itemId=printNameInMarksheetItemId]':{
	        		afterrender:function(obj){
	        			var levelOneForm=obj.up('form').getForm();
	        			var form=this.getEvaluationplanbasicdetailform().getForm();
	        			var evaluationTypeValue=form.findField('evaluationPlanType').getValue();
	        			
	        			/**
		 		     	 * printNameInMarksheet in level one
		 		     	 */
			      		 var printNameInMarksheetField=levelOneForm.findField('printNameInMarksheet');
			      		 printNameInMarksheetField.setVisible(true);
			      		 if(evaluationTypeValue==getExaminationTranslation('CNTRL_ACADEMICS')){
			      			printNameInMarksheetField.setFieldLabel(getExaminationTranslation('EVALUATION_PLAN_TO_BE_PRINTED'));
			      		 }else if(evaluationTypeValue==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
		     				printNameInMarksheetField.setFieldLabel(getExaminationTranslation('EXTERNAL_COURSE_TO_BE_PRINTED'));
			      		 } else if(evaluationTypeValue==getExaminationTranslation('CNTRL_OTHER')){
			      			printNameInMarksheetField.setFieldLabel(getExaminationTranslation('CATEGORY_TO_BE_PRINTED'));
			      		 }
			      		this.setAllowBlank(printNameInMarksheetField,false);
			      		form.isValid();
		      		 }
	        	},
	        	'evaluationplanleveloneform customcombobox[itemId=evaluationTypeAcademicItemId]':{
	        		select:function(obj,rec){
	        			/**
	        			 * Populate  print name in marksheet level one.
	        			 */
	        			this.populatePrintNameInMarksheetLevelOne(obj);
	        		}
	        	},
	        	'evaluationplanleveloneform customcombobox[itemId=evaluationTypeExternalItemId]':{
	        		select:function(obj,rec){
	        			/**
	        			 * Populate  print name in marksheet level one.
	        			 */
	        			this.populatePrintNameInMarksheetLevelOne(obj);
	        		}
	        	},
	        	'evaluationplanleveloneform customcombobox[itemId=evaluationTypeOtherItemId]':{
	        		select:function(obj,rec){
	        			/**
	        			 * Populate  print name in marksheet level one.
	        			 */
	        			this.populatePrintNameInMarksheetLevelOne(obj);
	        		}
	        	},
	        	'evaluationplanleveloneform customcombobox[itemId=marksOrGradeItemId]':{
	        		select:function(obj,rec){
	        			var form=obj.up('form').getForm();
	        			$this =this;
	        			var data=form.findField('marksOrGrade').getValue();
	        			var minMarksOrGradeNumberField=form.findField('minMarksOrGradeNumber');
	        			var maxMarksOrGradeNumberField=form.findField('maxMarksOrGradeNumber');
	        			var minMarksOrGradeComboField=form.findField('minMarksOrGradeCombo');
	        			var maxMarksOrGradeComboField=form.findField('maxMarksOrGradeCombo');
	        			var whetherPassesCriticalId=form.findField('whetherPassesCriticalId');
        			
	        			var minMarksOrGradeAwardComboField=form.findField('minMarksOrGradeAwardCombo');
	        			var maxMarksOrGradeAwardComboField=form.findField('maxMarksOrGradeAwardCombo');
	        			
	        			var gradeTypeField=form.findField('gradeType');
	        			
	        			//gradeTypeField.allowBlank=true;
						$this.setAllowBlank(gradeTypeField,true);
                      //  minMarksOrGradeComboField.allowBlank=true;
        			///	maxMarksOrGradeComboField.allowBlank=true;
        			//	minMarksOrGradeNumberField.allowBlank=true;
        			//	maxMarksOrGradeNumberField.allowBlank=true;
						minMarksOrGradeComboField.reset();
        				maxMarksOrGradeComboField.reset();
        			minMarksOrGradeNumberField.reset();
        				maxMarksOrGradeNumberField.reset();
						
						$this.setAllowBlank(minMarksOrGradeComboField,true);
						$this.setAllowBlank(maxMarksOrGradeComboField,true);
						$this.setAllowBlank(minMarksOrGradeNumberField,true);
						$this.setAllowBlank(maxMarksOrGradeNumberField,true);
						
	        			
	        			gradeTypeField.setVisible(false);
	        			whetherPassesCriticalId.setDisabled(false);
	        			
        				minMarksOrGradeComboField.setVisible(false);
        				maxMarksOrGradeComboField.setVisible(false);
        				minMarksOrGradeNumberField.setVisible(false);
        				maxMarksOrGradeNumberField.setVisible(false);
        				
                        gradeTypeField.reset();
        				
       					this.whetherPassingCritical(obj);
        				var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
	        			if(data==getExaminationTranslation('CNTRL_MARK')){
	        				
	        				/*if(whetherPassesCriticalId.getValue().whetherPassesCritical) {
	        					failMarksToBeAwarded.setVisible(true);
        		    			failGradeToBeAwarded.setVisible(false);
        		    			failMarksToBeAwarded.allowBlank=false;
        		    			failMarksToBeAwarded.setFieldLabel(failMarksToBeAwarded.getFieldLabel()+allowblankFalse);
            		    		failGradeToBeAwarded.allowBlank=true;
	        				} else {
	        					failMarksToBeAwarded.setVisible(false);
        		    			failGradeToBeAwarded.setVisible(false);
        		    			failMarksToBeAwarded.allowBlank=true;
            		    		failGradeToBeAwarded.allowBlank=true;
	        				}
	        				failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue();
	        				if(minMarksOrGradeAwardNumberField.getValue()==null) {
	        					failMarksToBeAwarded.minValue=0;
	        				} else {
	        					failMarksToBeAwarded.minValue=minMarksOrGradeAwardNumberField.getValue();
	        				}*/
	        				
	        				//maxMarksOrGradeNumberField.allowBlank=false;
							minMarksOrGradeNumberField.setVisible(true);
	        				maxMarksOrGradeNumberField.setVisible(true);
							$this.setAllowBlank(minMarksOrGradeNumberField,false);
									$this.setAllowBlank(maxMarksOrGradeNumberField,false);
	        				/* setTimeout(function(){
	                				$this.setAllowBlank(minMarksOrGradeNumberField,false);
									$this.setAllowBlank(maxMarksOrGradeNumberField,false);
									
		                	 },300);*/
	        			
	        				
	        			} else if(data==getExaminationTranslation('CNTRL_GRADE')){
	        				gradeTypeField.setVisible(true);
	        				gradeTypeField.setFieldLabel(gradeTypeField.getFieldLabel());
	        				
	        				/*if(whetherPassesCriticalId.getValue().whetherPassesCritical) {
	        					failGradeToBeAwarded.setVisible(true);
	        		    		failMarksToBeAwarded.setVisible(false);
	        		    		failMarksToBeAwarded.allowBlank=true;
	        		    		failGradeToBeAwarded.allowBlank=false;
	        		    		failGradeToBeAwarded.setFieldLabel(failGradeToBeAwarded.getFieldLabel()+allowblankFalse);
	        				} else {
	        					failMarksToBeAwarded.setVisible(false);
        		    			failGradeToBeAwarded.setVisible(false);
        		    			failMarksToBeAwarded.allowBlank=true;
            		    		failGradeToBeAwarded.allowBlank=true;
	        				}
	        				*/
	        				minMarksOrGradeComboField.setFieldLabel(minMarksOrGradeComboField.getFieldLabel());
     	    				maxMarksOrGradeComboField.setFieldLabel(maxMarksOrGradeComboField.getFieldLabel());
						$this.setAllowBlank(gradeTypeField,false);
	                				$this.setAllowBlank(minMarksOrGradeComboField,false);
									$this.setAllowBlank(maxMarksOrGradeComboField,false);
							/*setTimeout(function(){
									$this.setAllowBlank(gradeTypeField,false);
	                				$this.setAllowBlank(minMarksOrGradeComboField,false);
									$this.setAllowBlank(maxMarksOrGradeComboField,false);
		                	 },300);*/
     	    				//this.setAllowBlank(maxMarksOrGradeComboField,false);
							
	        				minMarksOrGradeComboField.setVisible(true);
	        				maxMarksOrGradeComboField.setVisible(true);
	        			}
	        			
	        		}
	        	},
	        	'evaluationplanleveloneform customcombobox[itemId=gradeTypeItemId]':{
	        	  select:function(obj,rec){
	        		  /**
	        		   * Here we have to send grade type (e.g G1,G2) not its Id 
	        		   */
	        		  var data=rec[0].data.value;
	        		  var store=this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
	      				store.getProxy().extraParams = {
	      					gradeType:data
		    				   };
	      				store.load();
	        	  }
	        	},
	        	'evaluationplanleveloneform radiogroup[itemId=showInMarksheetRadioGroupItemId]':{
	        		change:function(obj, newValue, oldValue, eOpts){
	        			var form=obj.up('form').getForm();
	        			    
        			    var evaluationTypeAcademicField=form.findField('evaluationTypeAcademic');
        		    	var evaluationTypeExternalField=form.findField('evaluationTypeExternal');
        		    	var evaluationTypeOtherField=form.findField('evaluationTypeOther');
        		    	var fieldLabel=null;
        		    	if(!evaluationTypeAcademicField.isHidden()){
        		    		fieldLabel=getExaminationTranslation('EVALUATION_PLAN_TO_BE_PRINTED');
        		    	}else if(!evaluationTypeExternalField.isHidden()){
        		    		fieldLabel=getExaminationTranslation('EXTERNAL_COURSE_TO_BE_PRINTED');
        		    	}else if(!evaluationTypeOtherField.isHidden()){
        		    		fieldLabel=getExaminationTranslation('CATEGORY_TO_BE_PRINTED');
        		    	}
        		    	
	        			form.isValid();
	        		}
	        	},
	        	'evaluationplanleveltwoform customcombobox[itemId=marksOrGradeItemId]':{
	        		change:function(obj,rec){
	        			var form=obj.up('form');
	        			this.markOrGradeTypeChangeOrSelect(obj,form);
        			},
//        			select:function(obj,rec){
//        				var form=obj.up('form').getForm();
//        				this.markOrGradeTypeChangeOrSelect(obj,form);
//        				form.isValid(); 
//        			}
	        	},
	        	'evaluationplanleveltwoform customcombobox[itemId=gradeTypeItemId]':{
		        	  select:function(obj,rec){
		        		  /**
		        		   * Here we have to send grade type (e.g G1,G2) not its Id 
		        		   */
		        		  var form=obj.up('form').getForm();
		        		  var minMarksOrGradeCombo = form.findField('minMarksOrGradeCombo');
		        		  var maxMarksOrGradeCombo = form.findField('maxMarksOrGradeCombo');
		        		  minMarksOrGradeCombo.reset();
		        		  maxMarksOrGradeCombo.reset();
		        		  var data=rec[0].data.value;
		        		  var store=this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
		      				store.getProxy().extraParams = {
		      					gradeType:data
			    				   };
		      				store.load();
	        	  }
	        	},
        	  /**
        	   * after render on field because when ever user come first time on screen we have change field label on the bases of evaluation type. 
        	   */
	        	'evaluationplanleveltwoform textfield[itemId=printNameInMarksheetItemId]':{
	        		afterrender:function(obj){
	        			var levelOneForm=obj.up('form').getForm();
	        			var form=this.getEvaluationplanbasicdetailform().getForm();
	        			var evaluationTypeValue=form.findField('evaluationPlanType').getValue();
	        			
	        			/**
		 		     	 * printNameInMarksheet in level one
		 		     	 */
			      		 var printNameInMarksheetField=levelOneForm.findField('printNameInMarksheet');
			      		printNameInMarksheetField.setVisible(true);
			      		if(evaluationTypeValue==getExaminationTranslation('CNTRL_ACADEMICS')){
			      			printNameInMarksheetField.setFieldLabel(getExaminationTranslation('COURSE_COMPONENT_TO_BE_PRINTED'));
			      		 }else if(evaluationTypeValue==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
		     				printNameInMarksheetField.setFieldLabel(getExaminationTranslation('COURSE_ASSESSMENT_TO_BE_PRINTED'));
			      		 } else if(evaluationTypeValue==getExaminationTranslation('CNTRL_OTHER')){
			      			printNameInMarksheetField.setFieldLabel(getExaminationTranslation('SUB_CATEGORY_TO_BE_PRINTED'));
			      		 }
			      		this.setAllowBlank(printNameInMarksheetField,false);
			      		/* comment for V2D-89686 */
	        			/* form.isValid(); */
	        			 
		      		 }
	        	},
	        	'evaluationplanleveltwoform customcombobox[itemId=courseComponentAcademicItemId]':{
	        		select:function(obj,rec){
	        			/**
        				 * Populate  print name in marksheet level two.
        				 */
        			    this.populatePrintNameInMarksheetLevelTwo(obj);
	        		}
	        	},
	        	'evaluationplanleveltwoform customcombobox[itemId=courseComponentExternalItemId]':{
	        		select:function(obj,rec){
	        			/**
        				 * Populate  print name in marksheet level two.
        				 */
        			    this.populatePrintNameInMarksheetLevelTwo(obj);
	        		}
	        	},
	        	'evaluationplanleveltwoform customcombobox[itemId=courseComponentOtherItemId]':{
	        		select:function(obj,rec){
	        			/**
        				 * Populate  print name in marksheet level two.
        				 */
        			    this.populatePrintNameInMarksheetLevelTwo(obj);
	        		}
	        	},
	        	'evaluationplanleveltwoform radiogroup[itemId=showInMarksheetRadioGroupItemId]':{
	        		change:function(obj, newValue, oldValue, eOpts){
	        			var form=obj.up('form').getForm();
	        			    
        			    var courseComponentAcademicField=form.findField('courseComponentAcademic');
        		    	var courseComponentExternalField=form.findField('courseComponentExternal');
        		    	var courseComponentOtherField=form.findField('courseComponentOther');
        		    	
        		    	if(!courseComponentAcademicField.isHidden()){
        		    		fieldLabel=getExaminationTranslation('COURSE_COMPONENT_TO_BE_PRINTED');
        		    	}else if(!courseComponentExternalField.isHidden()){
        		    		fieldLabel=getExaminationTranslation('COURSE_ASSESSMENT_TO_BE_PRINTED');
        		    	}else if(!courseComponentOtherField.isHidden()){
        		    		fieldLabel=getExaminationTranslation('SUB_CATEGORY_TO_BE_PRINTED');
        		    	}
        		    	
	        			form.isValid();
	        		}
	        	},
	        	'evaluationplanleveloneform radiogroup[itemId=whetherRemarkRadioGroupItemId]':{
	        		change:function(obj, newValue, oldValue, eOpts){
	        			this.whetherRemarkRadioGroup(obj);
	        		}
	        	},
	        	'evaluationplanleveltwoform radiogroup[itemId=whetherRemarkRadioGroupItemId]':{
	        		change:function(obj, newValue, oldValue, eOpts){
	        			this.whetherRemarkRadioGroup(obj);
	        		}
	        	},
	        	'evaluationplanleveloneform radiogroup[itemId=whetherPassesCriticalId]':{
	        		change:function(obj, newValue, oldValue, eOpts){
	        			this.whetherPassingCritical(obj);
	        		}
	        	},
	        	'evaluationplanleveltwoform radiogroup[itemId=whetherPassesCriticalId]':{
	        		change:function(obj, newValue, oldValue, eOpts){
	        			this.whetherPassingCritical(obj);
	        		}
	        	},
	        	'evaluationplanleveloneform customcombobox[itemId=repetitionTypeId]':{
	   			   select:function(obj, record){
	 		        		var form=obj.up('form').getForm();
	 		        		var repetitionType = form.findField('repetitionType');
	 		        		var eventTobeRepeated = form.findField('eventTobeRepeated');
	 		        		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
	 		        		if(record[0].data.value=="Event Level") {
	 		           		 	var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
	 		        		    var node=tree.getSelectionModel().getSelection()[0];
	 		        	    	var evaluationFirstLevelId=node.data.cls;
	 		        	    	eventTobeRepeated.setVisible(true);
	 		        	    	eventTobeRepeated.allowBlank=false;
	 		        	    	eventTobeRepeated.setFieldLabel("");
	 		        	    	eventTobeRepeated.setFieldLabel(getExaminationTranslation('EVENT_TO_BE_REPEAT')+allowblankFalse);
	 		        			var store=eventTobeRepeated.getStore();
	 		        			store.getProxy().extraParams={
	 		        				levelId:evaluationFirstLevelId,
	 		        				levelName:'Assessment Type'
	 		        			};
	 		        			store.load();
	 	        			} else {
	 	        				eventTobeRepeated.setVisible(false);
	 	        				eventTobeRepeated.allowBlank=true;
	 	        				eventTobeRepeated.setFieldLabel(getExaminationTranslation('EVENT_TO_BE_REPEAT'));
	 	        				eventTobeRepeated.reset();
	 	        			}
	 		        		form.isValid();
	 	        		}
	 	        	},
	 	        	'evaluationplanleveltwoform customcombobox[itemId=repetitionTypeId]':{
	 	        		select:function(obj,rec){
	 	        			var form=obj.up('form').getForm();
	 	        			var repetitionType = form.findField('repetitionType');
	 	        			var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
	 	        			var eventTobeRepeated = form.findField('eventTobeRepeated');
	 	        			if(repetitionType.valueModels[0].data.value=="Event Level") {
	 		        			var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
	 		        		    var node=	tree.getSelectionModel().getSelection()[0];
	 		        	    	var evaluationSecondLevelId=node.data.cls;
	 		        	    	eventTobeRepeated.setVisible(true);
	 		        	    	eventTobeRepeated.allowBlank=false;
	 		        	    	eventTobeRepeated.setFieldLabel("");
	 		        	    	eventTobeRepeated.setFieldLabel(getExaminationTranslation('EVENT_TO_BE_REPEAT')+allowblankFalse);
	 		        			var store=eventTobeRepeated.getStore();
	 		        			store.getProxy().extraParams={
	 		        				levelId:evaluationSecondLevelId,
	 		        				levelName:'Assessment Sub Type'
	 		        			};
	 		        			store.load();
	 		        			eventTobeRepeated.reset();
	 	        			} else {
	 	        				eventTobeRepeated.setVisible(false);
	 	        				eventTobeRepeated.allowBlank=true;
	 	        				eventTobeRepeated.setFieldLabel(getExaminationTranslation('EVENT_TO_BE_REPEAT'));
	 	        				eventTobeRepeated.reset();
	 	        			}
	 	        			form.isValid();
	 	        	}
	 	        }
        });
    },
    
    /***
     * This function is used for whether passing critical.
     */
    whetherPassingCritical :function(obj){
    	var form=obj.up('form').getForm();
    	var whetherPassesCriticalId=form.findField('whetherPassesCriticalId');
    	var whetherPassesCritical=whetherPassesCriticalId.getValue().whetherPassesCritical;
		var failMarksToBeAwarded=form.findField('failMarksToBeAwarded');
    	var failGradeToBeAwarded=form.findField('failGradeToBeAwarded');
    	var minMarksOrGradeNumberField=form.findField('minMarksOrGradeNumber');
		var repetitionType=form.findField('repetitionType');
		var eventTobeRepeated = form.findField('eventTobeRepeated');
		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
		var levelId=form.findField('id').getValue();
		var supplementaryDrool = form.findField('supplementaryDrool');
		if(whetherPassesCritical) {
			supplementaryDrool.setVisible(true);
	    	var data=form.findField('marksOrGrade').getValue();
	    	if(levelId!=null && levelId!="") {
		    	repetitionType.allowBlank=false;
		    	repetitionType.setFieldLabel(repetitionType.getFieldLabel()+allowblankFalse);
				repetitionType.setVisible(true);
				repetitionType.reset();
	    	} else {
	    		repetitionType.allowBlank=false;
		    	repetitionType.setFieldLabel(repetitionType.getFieldLabel()+allowblankFalse);
				repetitionType.setVisible(true);
				repetitionType.setReadOnly(true);
				repetitionType.getStore().load({
			  		  callback: function(records, operation, success) {
	          			 if (success) {
	          				repetitionType.setValue("COURSE_LEVEL");
	          			 }
			  		  }
				});
	    	}
	    	if(data==getExaminationTranslation('CNTRL_MARK')){
	    		failMarksToBeAwarded.allowBlank=false;
	    		failMarksToBeAwarded.setFieldLabel(failMarksToBeAwarded.getFieldLabel()+allowblankFalse);
	    		failGradeToBeAwarded.allowBlank=true;
	    		failMarksToBeAwarded.setVisible(true);
	    		failGradeToBeAwarded.setVisible(false);
	    		if(minMarksOrGradeNumberField.getValue()>0) {
	    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()-1;
	    		} else {
	    			failMarksToBeAwarded.maxValue=minMarksOrGradeNumberField.getValue()!=null?minMarksOrGradeNumberField.getValue():0;
	    		}
	    	} else if(data==getExaminationTranslation('CNTRL_GRADE')){
	    		failGradeToBeAwarded.setVisible(true);
	    		failMarksToBeAwarded.setVisible(false);
	    		failMarksToBeAwarded.allowBlank=true;
	    		failGradeToBeAwarded.allowBlank=false;
	    		failGradeToBeAwarded.setFieldLabel(failGradeToBeAwarded.getFieldLabel()+allowblankFalse);
	    	}
		} else {
			supplementaryDrool.reset();
			supplementaryDrool.setVisible(false);
			failGradeToBeAwarded.setVisible(false);
			failGradeToBeAwarded.reset();
			failGradeToBeAwarded.allowBlank=true;
    		failMarksToBeAwarded.setVisible(false);
    		failMarksToBeAwarded.reset();
    		failMarksToBeAwarded.allowBlank=true;
    		repetitionType.setVisible(false);
    		repetitionType.allowBlank=true;
    		repetitionType.reset();
    		eventTobeRepeated.setVisible(false);
    		eventTobeRepeated.allowBlank=true;
    		eventTobeRepeated.reset();
    		failGradeToBeAwarded.setFieldLabel(getExaminationTranslation('FAIL_GRADE_TO_BE_AWARDED'));
    		failMarksToBeAwarded.setFieldLabel(getExaminationTranslation('FAIL_MARKS_TO_BE_AWARDED'));
    		repetitionType.setFieldLabel(getExaminationTranslation('REPETITION_TYPE'));
		}
		form.isValid();
		form.clearInvalid();
    },

    whetherRemarkRadioGroup :function(obj){
    	var form=obj.up('form').getForm();
    	var whetherRemarkRadioGroupField = form.findField('whetherRemarkRadioGroup');
    	var whetherRemark = whetherRemarkRadioGroupField.getValue().whetherRemark;
		var remarkOnlyRadioGroupField = form.findField('remarkOnlyRadioGroup');
		remarkOnlyRadioGroupField.reset();
		if(whetherRemark) {
			remarkOnlyRadioGroupField.setVisible(true);
		} else {
			remarkOnlyRadioGroupField.setVisible(false);
		}
    },
        
    /***
     * This function is used to save the Assessment Scheme form one data.
     */
    saveFormData:function(){
    	var $this=this;
    	var form=$this.getEvaluationPlanLeveloneForm().getForm();
    	var formValue=form.getValues();
    	
    	var evalBasicForm=this.getEvaluationplanbasicdetailform().getForm();
    	var evaluationFirstLevelId=evalBasicForm.findField('id').getValue();
    	var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
	    var node=tree.getSelectionModel().getSelection()[0];
	    
	    var marksOrGradeFieldValue = form.findField('marksOrGrade').getValue();
	    var minMarksOrGradeNumberField=form.findField('minMarksOrGradeNumber');
		var maxMarksOrGradeNumberField=form.findField('maxMarksOrGradeNumber');
		var minMarksOrGradeComboField=form.findField('minMarksOrGradeCombo');
		var maxMarksOrGradeComboField=form.findField('maxMarksOrGradeCombo');
		
		var minMarksOrGradeAwardComboField=form.findField('minMarksOrGradeAwardCombo');
		var maxMarksOrGradeAwardComboField=form.findField('maxMarksOrGradeAwardCombo');
	    
		var failMarksToBeAwarded=form.findField('failMarksToBeAwarded');
    	var failGradeToBeAwarded=form.findField('failGradeToBeAwarded');
    	var eventTobeRepeated=form.findField('eventTobeRepeated');
        
        var WhetherLatestmarksRuleApplicable=form.findField('WhetherLatestmarksRuleApplicable'); 
	    
	    var submitData=new Academia.model.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationLevelOneForm();
    	submitData.set('evaluationPlanId',evaluationFirstLevelId);
    	submitData.set('whetherPassingCritical',formValue.whetherPassesCritical);
    	if(!form.findField('evaluationTypeAcademic').isHidden()){
    		submitData.set('levelName',formValue.evaluationTypeAcademic);
    		submitData.set('evaluationTypeId',
    		form.findField('evaluationTypeAcademic').getStore().findRecord('value',form.findField('evaluationTypeAcademic').getValue()).get('id'));
    	}else if(!form.findField('evaluationTypeExternal').isHidden()){
    		var evaluationTypeAcademicValue=form.findField('evaluationTypeExternal').getRawValue();
    		submitData.set('levelName',evaluationTypeAcademicValue);
    	}else if(!form.findField('evaluationTypeOther').isHidden()){
    		var evaluationTypeOtherValue=form.findField('evaluationTypeOther').getRawValue();
    		submitData.set('levelName',evaluationTypeOtherValue);
    		if(node.data.id =='levelOne'){
    			submitData.set('evaluationPlanOtherCategoryId',form.findField('evaluationTypeOther').getValue());
    		}else if(!Ext.isObject(form.findField('evaluationTypeOther').getValue())){
				submitData.set('evaluationPlanOtherCategoryId',form.findField('evaluationTypeOther').getValue());
			}else{
				submitData.set('evaluationPlanOtherCategoryId',form.findField('evaluationTypeOther').getStore().findRecord('value',form.findField('evaluationTypeOther').getValue()).get('id'));
    		}
    	}
    	
    	
    	var minMarksOrGradeAward=null;
    	var maxMarksOrGradeAward=null;
    	var minMarksOrGrade=null;
    	var maxMarksOrGrade=null;
    	var failMarksGradeToBeAwarded=null;
    
    	if(!minMarksOrGradeNumberField.isHidden()&&!maxMarksOrGradeNumberField.isHidden()){
    		minMarksOrGrade=formValue.minMarksOrGradeNumber;
    		maxMarksOrGrade=formValue.maxMarksOrGradeNumber;
    	}else if(!minMarksOrGradeComboField.isHidden()&&!maxMarksOrGradeComboField.isHidden()){
    		minMarksOrGrade=formValue.minMarksOrGradeCombo;
    		maxMarksOrGrade=formValue.maxMarksOrGradeCombo;
    	}
    	
    	if(!failMarksToBeAwarded.isHidden()){
    		failMarksGradeToBeAwarded=formValue.failMarksToBeAwarded;
    	}else if(!failGradeToBeAwarded.isHidden()){
    		failMarksGradeToBeAwarded=formValue.failGradeToBeAwarded;
    	}
    	submitData.set('supplementaryDrool',formValue.supplementaryDrool);
    	submitData.set('marksOrGrade',formValue.marksOrGrade);
    	submitData.set('minMarksOrGradeAward',minMarksOrGradeAward);
    	submitData.set('maxMarksOrGradeAward',maxMarksOrGradeAward);
    	submitData.set('minMarksOrGrade',minMarksOrGrade);
    	submitData.set('maxMarksOrGrade',maxMarksOrGrade);
    	submitData.set('whetherShowInMarksheet',formValue.whetherShowInMarksheet);
    	submitData.set('gradeType',formValue.gradeType);
    	submitData.set('whetherRemark',formValue.whetherRemark);
    	submitData.set('printNameInMarksheet',formValue.printNameInMarksheet);
    	submitData.set('failMarksGradeToBeAwarded', failMarksGradeToBeAwarded);
    	submitData.set('whetherCalculateAverage',formValue.whetherCalculateAverage);
    	submitData.set('remarkOnlyAssessment', formValue.remarkOnlyAssessment);
    	submitData.set('roundingMode',formValue.roundingMode);
    	submitData.set('roundingCount', formValue.roundingCount);
    	submitData.set('resultPublishMode', formValue.resultPublishMode);
		submitData.set('obeWeightage',formValue.obeWeightage);
		submitData.set('whetherFinalPromotionLevel',formValue.whetherFinalPromotionLevel);
    	if(!isNullOrEmpty(formValue.repetitionType)) {
    		submitData.set('repetitionType', formValue.repetitionType);
    	} else {
    		submitData.set('repetitionType', null);
    	}
        
        
    	submitData.set('repeatedEventId', eventTobeRepeated.getValue());
    	/**
    	 * Weightage check
    	 * Here while updating, selected node id is send in exitId and parent Id is send in  selecRecId.
    	 * Here while adding, selected node id is send in selecRecId and exitId is default set to zero.
    	 */
    	
    	var selecRecId=0;
    	var exitId=0;
    	if(formValue.id>0&&formValue.id!=null){
    		selecRecId=evaluationFirstLevelId;
    		exitId=node.data.cls;
    		submitData.set('id',formValue.id);
    		submitData.set('evaluationPlanId',formValue.evaluationPlanId);
    		submitData.set('evalPlanLevelOneStatus',formValue.evalPlanLevelOneStatus);
    		submitUrl = SERVERURL.EVALUATION_PLAN_LEVEL_ONE_FORM_UPDATE;	
    	}else{
    		submitData.set('evalPlanLevelOneStatus',getExaminationTranslation('CNTRL_MARK_ENTRY_PENDING'));
    		selecRecId=evaluationFirstLevelId;	
    		submitUrl = SERVERURL.EVALUATION_PLAN_LEVEL_ONE_FORM_CREATE;
    	}
    	/**
    	 * Check Weightage for level form one
    	 */
    	 if(formValue.weightage!=null&&formValue.weightage>=0){
    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
			 type: 'rest',
			 url: SERVERURL.EVALUATION_PLAN_CHECK_LEVEL_ONE_FORM_WEIGHTAGE,
			 method: 'GET',
			 params:{
				 id:selecRecId,
				 exitId:exitId
			 },
			 success: function(rsp, action) {
				 Ext.getBody().unmask();
				 var data = rsp.responseText;
				 
				 if(data!=null&&data!=""){
					 var jData=Ext.JSON.decode(data);
					 var weitageValue =parseFloat(formValue.weightage) +jData;
					 if(weitageValue<0||weitageValue>100){
						 showWarningMessage(getExaminationTranslation('WEIGHTAGE'),getExaminationTranslation('WEITAGE_NOT_MORE_THAN_100'));
						 return false;
					 }
					 submitData.set('levelValue',weitageValue);
					 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					 var fData = Ext.encode(submitData.data);
				   	    Ext.Ajax.request({
				   		 type: 'rest',
				   		 url: submitUrl,
				   		 jsonData: fData,
				   		 method: 'POST',
				   		 success: function(obj, action) {
				   			Ext.getBody().unmask();
				   			 if(obj.responseText!=""){
				   	   			showSuccessMessage(getExaminationTranslation('EVALUATION_PLAN_TYPE'), getCommonTranslation('SUCCESS'));
				   	   		    form.reset();
				   	   		    form.findField('marksOrGrade').setValue(marksOrGradeFieldValue);
				   	   		    node.collapse();
				   	   		    node.parentNode.collapse();
				   	   		    node.parentNode.expand();
				   	   		    node.expand();
				   			 }
				   		    }
				   	    });
				 }
			 }
	    });
      }else{
    	  var fData = Ext.encode(submitData.data);
    	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   	    Ext.Ajax.request({
	   		 type: 'rest',
	   		 url: submitUrl,
	   		 jsonData: fData,
	   		 method: 'POST',
	   		 success: function(obj, action) {
	   			Ext.getBody().unmask();
	   			 if(obj.responseText!=""){
	   	   			showSuccessMessage(getExaminationTranslation('EVALUATION_PLAN_TYPE'), getCommonTranslation('SUCCESS'));
	   	   		    form.reset();
	   	   		    form.findField('marksOrGrade').setValue(marksOrGradeFieldValue);
	   	   		    node.collapse();
	   	   		    node.parentNode.collapse();
	   	   		    node.parentNode.expand();
	   			 }
	   		    }
	   	    });
    	  
      }
    },
    saveLevelTwoFormData:function(){
    	var $this=this;
    	var form=$this.getEvaluationPlanLeveltwoForm().getForm();
    	var formValue=form.getValues();
    	var tree=Ext.ComponentQuery.query('treepanel#evaluationPlanTreeItemId')[0];
	    var node=	tree.getSelectionModel().getSelection()[0];
    	var evaluationSecondLevelId=node.data.cls;
    	var parentId=node.parentNode.data.cls;
    	
    	var minMarksOrGradeNumberField=form.findField('minMarksOrGradeNumber');
    	var maxMarksOrGradeNumberField=form.findField('maxMarksOrGradeNumber');
		var minMarksOrGradeComboField=form.findField('minMarksOrGradeCombo');
		var maxMarksOrGradeComboField=form.findField('maxMarksOrGradeCombo');

		var minMarksOrGradeAwardComboField=form.findField('minMarksOrGradeAwardCombo');
		var maxMarksOrGradeAwardComboField=form.findField('maxMarksOrGradeAwardCombo');
    	
		var failMarksToBeAwarded=form.findField('failMarksToBeAwarded');
    	var failGradeToBeAwarded=form.findField('failGradeToBeAwarded');
    	var eventTobeRepeated=form.findField('eventTobeRepeated');
        var WhetherLatestmarksRuleApplicable=form.findField('WhetherLatestmarksRuleApplicable');

    	var submitData=new Academia.model.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationLevelOneForm();
    	
    	submitData.set('evaluationPlanOneId',evaluationSecondLevelId);
    	submitData.set('whetherPassingCritical',formValue.whetherPassesCritical);
    	
    	if(!form.findField('courseComponentAcademic').isHidden()){
    		submitData.set('levelName',formValue.courseComponentAcademic);
    		submitData.set('evaluationSubTypeId',
    		form.findField('courseComponentAcademic').getStore().findRecord('value',form.findField('courseComponentAcademic').getValue()).get('id'));
    	}else if(!form.findField('courseComponentExternal').isHidden()){
    		submitData.set('levelName',formValue.courseComponentExternal);
    	}else if(!form.findField('courseComponentOther').isHidden()){
    		submitData.set('levelName',form.findField('courseComponentOther').rawValue);
    		submitData.set('evaluationPlanOtherSubCategoryId',form.findField('courseComponentOther').getValue());
    	}
    	
    	var minMarksOrGradeAward=null;
    	var maxMarksOrGradeAward=null;
    	var minMarksOrGrade=null;
    	var maxMarksOrGrade=null;
    	var failMarksGradeToBeAwarded=null;
    
    	if(!minMarksOrGradeNumberField.isHidden()&&!maxMarksOrGradeNumberField.isHidden()){
    		minMarksOrGrade=formValue.minMarksOrGradeNumber;
    		maxMarksOrGrade=formValue.maxMarksOrGradeNumber;
    	}else if(!minMarksOrGradeComboField.isHidden()&&!maxMarksOrGradeComboField.isHidden()){
    		minMarksOrGrade=formValue.minMarksOrGradeCombo;
    		maxMarksOrGrade=formValue.maxMarksOrGradeCombo;
    	}
    	
    	if(!failMarksToBeAwarded.isHidden()){
    		failMarksGradeToBeAwarded=formValue.failMarksToBeAwarded;
    	}else if(!failGradeToBeAwarded.isHidden()){
    		failMarksGradeToBeAwarded=formValue.failGradeToBeAwarded;
    	}
    	submitData.set('supplementaryDrool',formValue.supplementaryDrool);
    	submitData.set('marksOrGrade',formValue.marksOrGrade);
    	submitData.set('minMarksOrGradeAward',minMarksOrGradeAward);
    	submitData.set('maxMarksOrGradeAward',maxMarksOrGradeAward);
    	submitData.set('minMarksOrGrade',minMarksOrGrade);
    	submitData.set('maxMarksOrGrade',maxMarksOrGrade);
    	submitData.set('whetherShowInMarksheet',formValue.whetherShowInMarksheet);
    	submitData.set('gradeType',formValue.gradeType);
    	submitData.set('whetherRemark',formValue.whetherRemark);
    	submitData.set('failMarksGradeToBeAwarded', failMarksGradeToBeAwarded);
    	submitData.set('whetherCalculateAverage',formValue.whetherCalculateAverage);
    	submitData.set('remarkOnlyAssessment', formValue.remarkOnlyAssessment);
    	submitData.set('roundingMode',formValue.roundingMode);
    	submitData.set('roundingCount', formValue.roundingCount);
    	submitData.set('whetherZScore',formValue.zscore);
    	submitData.set('resultPublishMode',formValue.resultPublishMode);
		submitData.set('obeWeightage',formValue.obeWeightage);
		submitData.set('whetherFinalPromotionLevel',formValue.whetherFinalPromotionLevel);
		submitData.set('whetherLatest', formValue.WhetherLatestmarksRuleApplicable);
    	if(!isNullOrEmpty(formValue.printNameInMarksheet)) {
    		submitData.set('printNameInMarksheet',formValue.printNameInMarksheet);
    	} else {
    		submitData.set('printNameInMarksheet',node.data.text);
    	}
    	
    	submitData.set('contributeToDetention',formValue.contributeToDetention);
    	if(!isNullOrEmpty(formValue.repetitionType)) {
    		submitData.set('repetitionType', formValue.repetitionType);
    	} else {
    		submitData.set('repetitionType', null);
    	}
    	submitData.set('repeatedEventId', eventTobeRepeated.getValue());
    	
    	/**
    	 * Weightage check
    	 * Here while updating, selected node id is send in exitId and parent Id is send in  selecRecId.
    	 * Here while adding, selected node id is send in selecRecId and exitId is default set to zero.
    	 */
    	var selecRecId=0;
    	var exitId=0;
     	
   	    if(formValue.id!=null&&formValue.id>0){
   	    	selecRecId=parentId;
    		exitId=evaluationSecondLevelId;
   	    	submitData.set('id',formValue.id);
   	    	submitData.set('evaluationPlanOneId',formValue.evaluationPlanOneId);
   	    	submitData.set('evaluationPlan2LevelStatus',formValue.evaluationPlan2LevelStatus);
            submitData.set('whetherLatest', formValue.WhetherLatestmarksRuleApplicable);
   	    	submitUrl = SERVERURL.EVALUATION_PLAN_LEVEL_TWO_FORM_UPDATE;
   	    }else{
   	    	selecRecId=evaluationSecondLevelId;
   	    	submitData.set('evaluationPlan2LevelStatus',getExaminationTranslation('CNTRL_MARK_ENTRY_PENDING'));
   	    	submitUrl = SERVERURL.EVALUATION_PLAN_LEVEL_TWO_FORM_CREATE;
   	    }
   	   /**
    	 * Check Weightage for level form two
    	 */
   	 if(formValue.weightage!=null&&formValue.weightage>=0){
   		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
			 type: 'rest',
			 url: SERVERURL.EVALUATION_PLAN_CHECK_LEVEL_TWO_FORM_WEIGHTAGE,
			 method: 'GET',
			 params:{
				 id:selecRecId,
				 exitId:exitId
			 },
			 success: function(rsp, action) {
				 Ext.getBody().unmask();
				 var data = rsp.responseText;
				 
				 if(data!=null&&data!=""){
					 var jData=Ext.JSON.decode(data);
					 var weitageValue = parseFloat(formValue.weightage)+jData;
					 if(weitageValue<0||weitageValue>100){
						 showWarningMessage(getExaminationTranslation('WEIGHTAGE'),getExaminationTranslation('WEITAGE_NOT_MORE_THAN_100'));
						 return false;
					 }
				  submitData.set('levelValue',weitageValue);
				  
				  var fData = Ext.encode(submitData.data);
			     	Ext.Ajax.request({
			   		 type: 'rest',
			   		 url: submitUrl,
			   		 jsonData: fData,
			   		 method: 'POST',
			   		 success: function(obj, action) {
			   			 if(obj.responseText!=""){
			   	   			showSuccessMessage(getExaminationTranslation('EVALUATION_SUB_TYPE'), getCommonTranslation('SUCCESS'));   	
			   	   		    form.reset();
			   	   		    node.parentNode.collapse();
			   	            node.parentNode.expand();
			   			 }
			   		    }
			   	    });
				 }
			 }
	    });
   	 }else{
   		 var fData = Ext.encode(submitData.data);
   		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     	Ext.Ajax.request({
   		 type: 'rest',
   		 url: submitUrl,
   		 jsonData: fData,
   		 method: 'POST',
   		 success: function(obj, action) {
   			 Ext.getBody().unmask();
   			 if(obj.responseText!=""){
   	   			showSuccessMessage(getExaminationTranslation('EVALUATION_SUB_TYPE'), getCommonTranslation('SUCCESS'));   	
   	   		    form.reset();
   	   		    node.parentNode.collapse();
   	   		    node.parentNode.expand();
   			 }
   		    }
   	    });
   	 }
    },
    /**
	 * Populate  print name in marksheet level one.
	 */
    populatePrintNameInMarksheetLevelOne:function(obj){
    	var form=obj.up('form').getForm();
    	var printNameInMarksheetField=form.findField('printNameInMarksheet');
    	var evaluationTypeAcademicField=form.findField('evaluationTypeAcademic');
    	var evaluationTypeExternalField=form.findField('evaluationTypeExternal');
    	var evaluationTypeOtherField=form.findField('evaluationTypeOther');
    	var resultPublishMode=form.findField('resultPublishMode');
    	var value=null;
    	
    	if(!evaluationTypeAcademicField.isHidden()){
    		value=evaluationTypeAcademicField.getValue();
    		
//    		if(evaluationTypeAcademicField.valueModels[0]!=undefined && 
//    				evaluationTypeAcademicField.valueModels[0].data.code=="true"){
    		if(evaluationTypeAcademicField.getStore().data.items[0]!=undefined && 
    				evaluationTypeAcademicField.getStore().data.items[0].data.code=="true"){
        		resultPublishMode.reset(); 
        		resultPublishMode.enable();
        		resultPublishMode.setVisible(true);
        		resultPublishMode.getStore().load({
	          			callback:function(rec,success){
	          				resultPublishMode.setValue(rec[1].data.id);
	          			}
	          	});
        	}else{
        		resultPublishMode.reset();
        		resultPublishMode.disable(); 
        		resultPublishMode.setVisible(false);
        	}
    		
    	}else if(!evaluationTypeExternalField.isHidden()){
    		value=evaluationTypeExternalField.getValue();
    		
    		if(evaluationTypeExternalField.valueModels[0]!=undefined && 
    				evaluationTypeExternalField.valueModels[0].data.code=="true"){
        		resultPublishMode.reset();
        		resultPublishMode.enable();
        		resultPublishMode.setVisible(true);
        		resultPublishMode.getStore().load({
          			callback:function(rec,success){
          				resultPublishMode.setValue(rec[1].data.id);
          			}
        		});
        	}else{
        		resultPublishMode.reset();
        		resultPublishMode.disable();
        		resultPublishMode.setVisible(false);
        	}
    	}else if(!evaluationTypeOtherField.isHidden()){
    		value=evaluationTypeOtherField.getRawValue();
    		
    		if(evaluationTypeOtherField.valueModels[0]!=undefined && 
    				evaluationTypeOtherField.valueModels[0].data.code=="true"){
        		resultPublishMode.reset();
        		resultPublishMode.enable();
        		resultPublishMode.setVisible(true);
        		resultPublishMode.getStore().load({
          			callback:function(rec,success){
          				resultPublishMode.setValue(rec[1].data.id);
          			}
        		});
        	}else{
        		resultPublishMode.reset();
        		resultPublishMode.disable();
        		resultPublishMode.setVisible(false);
        	}
    	}
    	
    	if(!printNameInMarksheetField.isHidden()){
    		printNameInMarksheetField.setValue(value);
    	}
    	
    },
    /**
	 * Populate  print name in marksheet level two.
	 */
    populatePrintNameInMarksheetLevelTwo:function(obj){
    	var form=obj.up('form').getForm();
    	var printNameInMarksheetField=form.findField('printNameInMarksheet');
    	var courseComponentAcademicField=form.findField('courseComponentAcademic');
    	var courseComponentExternalField=form.findField('courseComponentExternal');
    	var courseComponentOtherField=form.findField('courseComponentOther');
    	var resultPublishMode=form.findField('resultPublishMode');
    	var value=null;
    	
    	if(!courseComponentAcademicField.isHidden()){
    		value=courseComponentAcademicField.getValue();
//    		if(courseComponentAcademicField.valueModels[0]!=undefined && 
//    				courseComponentAcademicField.valueModels[0].data.code=="true"){
    			if(courseComponentAcademicField.getStore().data.items[0]!=undefined && 
    					courseComponentAcademicField.getStore().data.items[0].data.code=="true"){
        		resultPublishMode.reset();
        		resultPublishMode.enable();
        		resultPublishMode.setVisible(true);
        		resultPublishMode.getStore().load({
          			callback:function(rec,success){
          				resultPublishMode.setValue(rec[1].data.id);
          			}
        		});
        	}else{
        		resultPublishMode.reset();
        		resultPublishMode.disable();
        		resultPublishMode.setVisible(false);
        	}
    	}else if(!courseComponentExternalField.isHidden()){
    		value=courseComponentExternalField.getValue();
    		if(courseComponentExternalField.valueModels[0]!=undefined && 
    				courseComponentExternalField.valueModels[0].data.code=="true"){
        		resultPublishMode.reset();
        		resultPublishMode.enable();
        		resultPublishMode.setVisible(true);
        		resultPublishMode.getStore().load({
          			callback:function(rec,success){
          				resultPublishMode.setValue(rec[1].data.id);
          			}
        		});
        	}else{
        		resultPublishMode.reset();
        		resultPublishMode.disable();
        		resultPublishMode.setVisible(false);
        	}
    	}else if(!courseComponentOtherField.isHidden()){
    		value=courseComponentOtherField.getDisplayValue();
    		if(courseComponentOtherField.valueModels[0]!=undefined && 
    				courseComponentOtherField.valueModels[0].data.code=="true"){
        		resultPublishMode.reset();
        		resultPublishMode.enable();
        		resultPublishMode.setVisible(true);
        		resultPublishMode.getStore().load({
          			callback:function(rec,success){
          				resultPublishMode.setValue(rec[1].data.id);
          			}
        		});
        	}else{
        		resultPublishMode.reset();
        		resultPublishMode.disable();
        		resultPublishMode.setVisible(false);
        	}
    	}
    	
    	if(!printNameInMarksheetField.isHidden()){
    		printNameInMarksheetField.setValue(value);
    	}
    	
    },
    
    hidezScoreFieldPivileges: function(searchForm, permissionsMap) {
		var academyLocationId = this.getCurrentAcademyLocation();
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(academyLocationId);
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var zscoreId=searchForm.findField('zscoreId');
		zscoreId.setVisible(false);
		if((Ext.Array.contains(permissionList, 'ZSCORE'))){
			zscoreId.setVisible(true);
		}
	},
	markOrGradeTypeChangeOrSelect: function(obj,formObj) {
		var form = formObj.getForm();
		var data=form.findField('marksOrGrade').getValue();
		var minMarksOrGradeNumberField=form.findField('minMarksOrGradeNumber');
		var maxMarksOrGradeNumberField=form.findField('maxMarksOrGradeNumber');
		var minMarksOrGradeComboField=form.findField('minMarksOrGradeCombo');
		var maxMarksOrGradeComboField=form.findField('maxMarksOrGradeCombo');
		var whetherPassesCriticalId=form.findField('whetherPassesCriticalId');
		
		var minMarksOrGradeAwardComboField=form.findField('minMarksOrGradeAwardCombo');
		var maxMarksOrGradeAwardComboField=form.findField('maxMarksOrGradeAwardCombo');
		
		var gradeTypeField=form.findField('gradeType');
		
      
		minMarksOrGradeComboField.allowBlank=true;
		maxMarksOrGradeComboField.allowBlank=true;
		minMarksOrGradeNumberField.allowBlank=true;
		maxMarksOrGradeNumberField.allowBlank=true;
		
		if(formObj.down('#addEdit').getValue() != 'add') {
			whetherPassesCriticalId.setDisabled(false);
		}
		minMarksOrGradeComboField.setVisible(false);
		maxMarksOrGradeComboField.setVisible(false);
		minMarksOrGradeNumberField.setVisible(false);
		maxMarksOrGradeNumberField.setVisible(false);
		
      
		
		//this.whetherPassingCritical(obj);
		if(data==getExaminationTranslation('CNTRL_MARK')){
			  gradeTypeField.allowBlank=true;
		     gradeTypeField.setVisible(false);
             gradeTypeField.reset();
			minMarksOrGradeNumberField.allowBlank=false;
			maxMarksOrGradeNumberField.allowBlank=false;
			
			minMarksOrGradeNumberField.setVisible(true);
			maxMarksOrGradeNumberField.setVisible(true);
		}else if(data==getExaminationTranslation('CNTRL_GRADE')){
			gradeTypeField.setVisible(true);
			gradeTypeField.allowBlank=false;
			minMarksOrGradeComboField.allowBlank=false;
			maxMarksOrGradeComboField.allowBlank=false;
			
			minMarksOrGradeComboField.setVisible(true);
			maxMarksOrGradeComboField.setVisible(true);
			formObj.down('#levelTwoAddButtonId').setDisabled(true);
		}
	},
});
   