/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.controller.examinationcenters.thesisManagement.studentThesisManagementController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['common.AcademicTermByMappedPeriodStore','coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch','attendance.AttendanceProgramSectionStore',
		'attendance.FacultyCodeSmartSearch','common.AcademyLocationNameSeparated','examinationcenters.thesisManagement.ThesisManagementGridStore','common.AllUserBySmartSearch'
		,'examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore','facilitiesresources.managegallery.FileUploadWindowDataviewStore',
		'examinationcenters.thesisManagement.ThesisManagementSupervisorDetailsGridStore'],
	views : [
		'examinationcenters.thesisManagement.StudentThesisManagementStructure',
		'examinationcenters.thesisManagement.StudentThesisManagementGrid',
		'examinationcenters.thesisManagement.ThesisMangementStatusDetailWin',
		'examinationcenters.thesisManagement.ThesisManagementSubmitDocumentWindow',
		'facilitiesresources.managegallery.FileUploadWin',
		'examinationcenters.thesisManagement.ThesisManagementSupervisorDetailsgrid',
		],
		config:{
			STUDENT_PORTAL_THESIS_MANAGEMENT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAM_THESIS_MANAGEMENT_PRIVILEGES'),
			PARENT_PORTAL_THESIS_MANAGEMENT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAM_THESIS_MANAGEMENT_PRIVILEGES'),
		},     
		refs : [{
			ref:'studentthesismanagementstructure',
			selector:'studentthesismanagementstructure'
		},{
			ref:'studentthesismanagementgrid',
			selector:'studentthesismanagementgrid'
		},
		{
			ref : 'thesismangementstatusdetailwin',
			selector : 'thesismangementstatusdetailwin'
		},{
			ref: 'thesismanagementsubmitdocumentwindow',
			selector: 'thesismanagementsubmitdocumentwindow'
		},{
			ref: 'fileuploadwin',
			selector: 'fileuploadwin'
		},{
			ref:'thesismanagementsupervisordetailsgrid',
			selector:'thesismanagementsupervisordetailsgrid'
		}],
		init : function() {
			this.control({
				'studentthesismanagementstructure':{},
				'studentthesismanagementgrid':{
					render: function(grid){
						var grid = this.getStudentthesismanagementgrid();
						var portalId = this.getCurrentLoggedPortalId();
						if(portalId==3){
							this.checkPermissionForExportOfThesisManagement(grid, this.getSTUDENT_PORTAL_THESIS_MANAGEMENT_PERMISSION());
						}else {
							this.checkPermissionForExportOfThesisManagement(grid, this.getPARENT_PORTAL_THESIS_MANAGEMENT_PERMISSION());
						}
						
						grid.getStore().removeAll();
	    			},
					afterrender: function(grid){
						this.loadThesisManagementGrid();
	    				setTimeout(function(){
	    					grid.getHeader().items.items[1].show();
	    				},3000);
	    			},
	    			cellclick: function(View, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	    				var $this = this;
	    				var grid = $this.getStudentthesismanagementgrid();
	    				var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	    				if (e.target.tagName == 'A') {
	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
	    					if(dataIndex == 'supervisorName'){
	    						this.viewThesisManagementSupervisorDetail(record, grid);
	    					}
	    				}
	    				
	    				if (e.target.tagName == 'A') {
	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
	    					if(dataIndex == 'thesisDocument'){
	    						this.viewThesisDocumentDetail(record, grid);
	    					}
	    				}
	    			},
	    			selectionchange: function(column, selected) {
	            		var grid = this.getStudentthesismanagementgrid();
	            		if(selected.length== 1){ 
	            			var record = selected[0].data;
		            		var thesisStatus = record.thesisStatus;
	            			if(!isNullOrEmpty(thesisStatus) && (thesisStatus=='Nominated' || thesisStatus=='Rejected')){
	            				grid.down('#btnSubmitThesis').setDisabled(false);
	            			} else{
	            				grid.down('#btnSubmitThesis').setDisabled(true);
	            			}
	            		}
	            		else{
	            			grid.down('#btnSubmitThesis').setDisabled(true);
	            		}
	            	}
				},
				'studentthesismanagementgrid button[itemId=btnSubmitThesis]': {
					click: this.openSubmitThesisWindow
				},
				'thesismanagementsubmitdocumentwindow button[itemId=btnThesisDocumentAddImage]':{
    				click : this.openDocumentAddWindow
    			}, 
    			'thesismanagementsubmitdocumentwindow button[itemId=btnOtherDocumentAddImage]':{
    				click : this.openDocumentAddWindow
    			},
				'thesismanagementsubmitdocumentwindow dataview[itemId=thesisDocumentDataView]':{
				afterrender: function(dataview){
					var me = this;
					var grid = me.getStudentthesismanagementgrid();
					var record = grid.getSelectionModel().getSelection();
					var thesisManagementId = record[0].data.id;
					var dataViewStore = dataview.getStore();
					var thesismanagementsubmitdocumentwindow = me.getThesismanagementsubmitdocumentwindow();
					dataViewStore.getProxy().extraParams = {
						thesisManagementId : thesisManagementId,
						documentType: 'THESIS_DOCUMENT'
					};
					dataViewStore.removeAll();
					dataViewStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length > 0){
									thesismanagementsubmitdocumentwindow.down('#btnThesisDocumentAddImage').hide();
								}
								else{
									thesismanagementsubmitdocumentwindow.down('#btnThesisDocumentAddImage').show();
								}
							}
						}
					});
				}
			},
			'thesismanagementsubmitdocumentwindow dataview[itemId=otherDocumentDataView]':{
				afterrender: function(dataview){
					var me = this;
					var grid = me.getStudentthesismanagementgrid();
					var record = grid.getSelectionModel().getSelection();
					var thesisManagementId = record[0].data.id;
					var dataViewStore = dataview.getStore();
					dataViewStore.getProxy().extraParams = {
						thesisManagementId : thesisManagementId,
						documentType: 'OTHER_DOCUMENT'
					};
					dataViewStore.removeAll();
					dataViewStore.load();
				}
			},
			'thesismanagementsubmitdocumentwindow button[itemId=btnThesisDocumentDeleteImage]':{
				click: this.deleteThesisDocument
			},
			'thesismanagementsubmitdocumentwindow button[itemId=btnOtherDocumentDeleteImage]':{
				click: this.deleteOtherDocument
			},
			'fileuploadwin[itemId=thesisDocument] button[itemId=submitImageBtnWin]': {
				click: this.uploadThesisDocument
			},
			'fileuploadwin[itemId=thesisDocument] button[itemId=cancelImageBtnWin]': {
				click: function(btn){
					btn.up('window').close();
				}
			},
			'thesismanagementsubmitdocumentwindow button[itemId=thesisDocumentFormCancelButtonId]': {
				click: function(btn){
					btn.up('window').close();
				}
			},
			'thesismanagementsubmitdocumentwindow button[itemId=thesisDocumentFormSubmitButtonId]': {
				click: function(btn){
					this.submitThesisDocuments(btn);
				}
			},
			});
		},
		onSave : function(){

		},
		loadThesisManagementGrid : function(){
			var $this = this;
			var grid = $this.getStudentthesismanagementgrid();
			var academyLocationIds = $this.getCurrentAcademyLocation();
			var student = this.getCurrentlyLoggedInUserInfoForPortal();
			grid.getStore().getProxy().extraParams= {
	    		academyLocationIds:academyLocationIds,
	    		admissionId:student.admissionDetails[0].id
	    	};
			grid.getStore().load();
		},
		getIdValueJson : function(id, value, code) {
			if (id)
				return {
				id : id,
				value : value,
				code : code
			};
		},
		viewThesisDocumentDetail : function(record,grid){
			var window=	this.getThesismangementstatusdetailwin();
			var me=this;
			var records = grid.getSelectionModel().getSelection();
			var pk =records[0].data.id;
			var status=records[0].data.thesisStatus;
			if (!window) {
     			Ext.widget('thesismangementstatusdetailwin');
     			window = this.getThesismangementstatusdetailwin();
     		}
     		window.show();
     		var otherStore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore');
			otherStore.getProxy().extraParams = {
				thesisManagementId:pk,
				documentType:'OTHER_DOCUMENT',
				 thesisStatus:'SUBMITTED'
			};
			otherStore.load({
				callback: function(records, operation, success){
					
					var msg = getCommonTranslation('DOUBLE_CLICK_TO_DOWNLOAD_FILE');							

					
						var imageTpl = new Ext.XTemplate(
								'<tpl for=".">',
								'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
								'<tpl else>',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="'+msg+'">',
								'</tpl>',
								'<img src="{iconImage}" />',
								'<br/><span>{imageName}</span>',
								//'<div><input type="checkbox" value="{id}" name="imageId" onclick="changePaymentPlanDeleteBtnState();" /></div>',
								'</div>',
								'</tpl>'
						);
					
				
					Ext.each(Ext.ComponentQuery.query('#krishna'), function(currentGalleryDataView){
						currentGalleryDataView.destroy();
					});
					Ext.create('Ext.view.View', {
						store:otherStore,
						tpl: imageTpl,
						itemSelector: 'div.gallery-thumb-wrap',
						emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
						renderTo: window.down('#OtherDocDataView').body,
						itemId: 'krishna',
						height: '90%',
						deferEmptyText: false,
						style: {
							marginTop: '15px',
							marginLeft: '10px'
						},
						listeners: {
							itemclick: function( dataview, record, item, index, e, eOpts ){

							},
							itemdblclick: function(dataview, record, item, index, e, eOpts ){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
									|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
										|| extension == "txt" || extension == "odt"|| extension=="png"||extension=="jpeg"||extension=="jpg"||extension=="gif"){
									me.downloadDocumentFile(record.raw.documentId);
								}
							}
						}
					});

				}
			});
			var bstore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore');
			bstore.getProxy().extraParams = {
				thesisManagementId:pk,
				documentType:'THESIS_DOCUMENT',
				 thesisStatus:'SUBMITTED'
			};
			bstore.load({
				callback: function(records, operation, success){
					
					var msg = getCommonTranslation('DOUBLE_CLICK_TO_DOWNLOAD_FILE');							

					
						var imageTpl = new Ext.XTemplate(
								'<tpl for=".">',
								'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
								'<tpl else>',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="'+msg+'">',
								'</tpl>',
								'<img src="{iconImage}" />',
								'<br/><span>{imageName}</span>',
								//'<div><input type="checkbox" value="{id}" name="imageId" onclick="changePaymentPlanDeleteBtnState();" /></div>',
								'</div>',
								'</tpl>'
						);
					
				
					Ext.each(Ext.ComponentQuery.query('#krishna1'), function(currentGalleryDataView){
						currentGalleryDataView.destroy();
					});
					Ext.create('Ext.view.View', {
						store:bstore,
						tpl: imageTpl,
						itemSelector: 'div.gallery-thumb-wrap',
						emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
						renderTo: window.down('#DocDataView').body,
						itemId: 'krishna1',
						height: '90%',
						deferEmptyText: false,
						style: {
							marginTop: '15px',
							marginLeft: '10px'
						},
						listeners: {
							itemclick: function( dataview, record, item, index, e, eOpts ){

							},
							itemdblclick: function(dataview, record, item, index, e, eOpts ){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
									|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
										|| extension == "txt" || extension == "odt"|| extension=="png"||extension=="jpeg"||extension=="jpg"||extension=="gif"){
									me.downloadDocumentFile(record.raw.documentId);
								}
							}
						}
					});

				}
			});
			console.log('in');
		}
		,
		downloadDocumentFile : function(documentId){
			var whetherFile = false;
			if(!isNullOrEmpty(documentId)){
				var csvForm = Ext.create('Ext.form.Panel'); 
	       		csvForm.getForm().submit({
	       			target: '_blank',
	       			method:'GET',
	       			params :{
	       				access_token : Ext.Ajax.defaultHeaders.access_token
	       			},
	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	       			url: SERVERURL.PATH_THESIS_DOCUMENT_FILE_DOWNLOAD + documentId,
	       			standardSubmit :true
	       		});
				
			
			}
		},
		openSubmitThesisWindow: function(grid){
			var me = this;
			var window =  me.getThesismanagementsubmitdocumentwindow();
     		if (!window) {
     			Ext.widget('thesismanagementsubmitdocumentwindow');
     			window = me.getThesismanagementsubmitdocumentwindow();
     		}
     		window.show();
		},
		
		openDocumentAddWindow: function(button){
			var me = this;
			var maxFileUpload = 10;
			if(button.itemId=="btnThesisDocumentAddImage"){
				var winTitle = getCommonTranslation('THESIS_DOCUMENT');
				var dataViewItemId = 'thesisDocumentDataView';
				var maxFileUpload = 1;
			}
			else{
				var winTitle = getCommonTranslation('OTHER_DOCUMENTS');
				var dataViewItemId = 'otherDocumentDataView';
				var dataView=button.up('window').down('#otherDocumentDataView');
				maxFileUpload=10-dataView.getStore().data.items.length;
			}
			var formWindow = me.getFileuploadwin();
			if(maxFileUpload==0){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UPTO_10_FILES_CAN_BE_UPLOADED_MSG'));
			} else{
				if (!formWindow) {
					Ext.widget('fileuploadwin',{
						itemId:'thesisDocument',
						title: winTitle,
						dataViewItemId: dataViewItemId,
						maxFileUpload: maxFileUpload,
						maxFileSize:265000,
					});
					formWindow = me.getFileuploadwin();
				}
			}
			formWindow.maxFileUpload= maxFileUpload;
			var dataview = formWindow.down('#galleryDataViewAddWin');
			var store = dataview.getStore();
			store.removeAll();
			formWindow.show();
		},
		
		openThesisDocumentUploadWin: function(btn){
			var me = this;
			var formWindow = me.getThesismanagementdocuploadwindow();
			if (!formWindow) {
				Ext.widget('thesismanagementdocuploadwindow');
				formWindow = me.getThesismanagementdocuploadwindow();
			}
			/*var dataview = formWindow.down('#planDocDataViewAddWin');
			var store = dataview.getStore();
			store.removeAll();*/
			
			formWindow.show();
		},
		uploadThesisDocument: function(btn){
			var me = this;
			var grid = me.getStudentthesismanagementgrid();
			var record = grid.getSelectionModel().getSelection();
			var thesisManagementId = record[0].data.id;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var formData = new FormData();
			
			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
			var galleryStore = galleryDataViewAddWin.getStore();
			
			if(galleryStore.data.length>0){
				Ext.each(galleryStore.data.items,function(currentFile){
					formData.append("file[]", currentFile.data.fileData);
				});
			}
			btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			$.ajax({
				url: SERVERURL.PATH_THESIS_MANAGEMENT_DOCUMENT,//+'?thesisManagementId='+thesisManagementId+'&uploadedBy='+uploadedBy,
				method: 'POST',
				data: formData,
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					if(response.length){
						var window =  me.getThesismanagementsubmitdocumentwindow();
						if(btn.up('window').dataViewItemId=="thesisDocumentDataView"){
							Ext.ComponentQuery.query('#'+btn.up('window').dataViewItemId)[0].getStore().removeAll();
							window.down('#btnThesisDocumentAddImage').hide();
						}
						Ext.ComponentQuery.query('#'+btn.up('window').dataViewItemId)[0].getStore().add(response);
						if(Ext.ComponentQuery.query('#thesisDocumentDataView')[0].getStore().data.items.length){
							window.down('#thesisDocumentFormSubmitButtonId').setDisabled(false);
						}
						else{
							window.down('#thesisDocumentFormSubmitButtonId').setDisabled(true);
						}
					}
					btn.up('window').close();
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
		
		},
		submitThesisDocuments: function(btn){
			var me = this;
			//if(Ext.ComponentQuery.query('#planDocDataView').length>0){
			var form = me.getThesismanagementsubmitdocumentwindow();
			var thesisDocStore = form.down('#thesisDocumentDataView').getStore();
			var otherDocStore = form.down('#otherDocumentDataView').getStore();
			var grid = me.getStudentthesismanagementgrid();
			var records = grid.getSelectionModel().getSelection();
        	var thesisManagementId = records[0].data.id;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var remark = form.down('#thesisDocumentRemark').getValue();
			var mainJsonObj = [];
			var thesisDoc = {
					thesisManagementId : thesisManagementId,
					uploadedBy : uploadedBy,
					id : thesisDocStore.data.items[0].data.documentId,
					documentType : 'THESIS_DOCUMENT',
					remark : remark	
			}
			mainJsonObj.push(thesisDoc);
			var otherDocs = otherDocStore.data.items;
			for(var i = 0; i<otherDocs.length; i++){
				var otherDoc = {
						thesisManagementId : thesisManagementId,
						uploadedBy : uploadedBy,
						id : otherDocs[i].data.documentId,
						documentType : 'OTHER_DOCUMENT',
						remark : remark	
				} 
				
				mainJsonObj.push(otherDoc);
			}
			mainJsonObj = Ext.encode(mainJsonObj);

				/*if(galleryStore.data.length>0){
					Ext.each(galleryStore.data.items,function(currentFile){
						formData.append("file[]", currentFile.data.fileData);
					});
				}*/
				btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				var submitUrl=SERVERURL.PATH_THESIS_MANAGEMENT_DOCUMENT_SAVE;
				Ext.Ajax.request({
       			 type : 'rest',
       			 url : submitUrl,
       			 jsonData : mainJsonObj,
       			 method : 'POST',
       			success: function (response) {
					showSuccessMessage(getCommonTranslation('THESIS_DOCUMENT'), getCommonTranslation('THESIS_DOCUMENT_SUBMITTED'));
					btn.up('window').body.unmask();
					btn.up('window').close();
					grid.store.reload();
					grid.down('#btnSubmitThesis').setDisabled(true);
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
       		 });
				
			
			//}
		},
		
		deleteThesisDocument: function(button){
			var me = this;
			showConfirmMessage(getCommonTranslation('THESIS_DOCUMENT'), getCommonTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function(btn, text) {
				if (btn == 'yes') {
					var window=me.getThesismanagementsubmitdocumentwindow();
					var dataview = window.down('#thesisDocumentDataView');
					var store = dataview.getStore();
					var imageIDs = $("[name=thesisDocumentDataViewImage]:checked").map(function(){
						return $(this).val();
					}).get();
					if(imageIDs.length>0){
						var submitURL = SERVERURL.DELETE_THESIS_DOCUMENTS+'?id='+imageIDs.toString();
						Ext.Ajax.request({
							method: "GET",
							type: 'rest',
							url : submitURL,
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('THESIS_DOCUMENT'), getServiceRequestTranslation("DOCUMENT_DELETE"));	
								Ext.each(imageIDs, function(documentId) {
									store.removeAt(store.find('documentId',documentId));
								});
								button.setDisabled(true);
								window.down('#btnThesisDocumentAddImage').show();
								if(Ext.ComponentQuery.query('#thesisDocumentDataView')[0].getStore().data.items.length){
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(false);
								}
								else{
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(true);
								}
							}
						});
					}
				}
			});
		},
		
		deleteOtherDocument: function(button){
			var me = this;
			showConfirmMessage(getCommonTranslation('THESIS_DOCUMENT'), getCommonTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function(btn, text) {
				if (btn == 'yes') {
					var window=me.getThesismanagementsubmitdocumentwindow();
					var dataview = window.down('#otherDocumentDataView');
					var store = dataview.getStore();
					var imageIDs = $("[name=otherDocumentDataViewImage]:checked").map(function(){
						return $(this).val();
					}).get();
					if(imageIDs.length>0){
						var submitURL = SERVERURL.DELETE_THESIS_DOCUMENTS+'?id='+imageIDs.toString();
						Ext.Ajax.request({
							method: "GET",
							type: 'rest',
							url : submitURL,
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('THESIS_DOCUMENT'), getServiceRequestTranslation("DOCUMENT_DELETE"));	
								Ext.each(imageIDs, function(documentId) {
									store.removeAt(store.find('documentId',documentId));
								});
								button.setDisabled(true);
								if(Ext.ComponentQuery.query('#thesisDocumentDataView')[0].getStore().data.items.length){
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(false);
								}
								else{
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(true);
								}
							}
						});
					}
				}
			});
		},
		
		viewThesisManagementSupervisorDetail : function(record, grid){
			var $this = this;
			var window =  $this.getThesismanagementsupervisordetailsgrid();
     		if (!window) {
     			Ext.widget('thesismanagementsupervisordetailsgrid');
     			window = $this.getThesismanagementsupervisordetailsgrid();
     		}
     		window.show();
     		var grid = window.down('grid');
     		if(!isNullOrEmpty(record)){
     			var store = grid.getStore();
     			store.getProxy().extraParams = {
     				thesisManagementId:record.data.id
     			};
     			this.resetPageSetting(store, grid);
     			store.load({
     				callback: function(){
     	         		window.center();
     				}
     			});
     		}
		},
		checkPermissionForExportOfThesisManagement : function(grid, permissionMap){
			this.doAccessControlValidation(grid, permissionMap);
			var associatedAcadLocationIds = new Array();
	   	 	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
			var btnSubmitThesis = grid.down('#btnSubmitThesis');
			btnSubmitThesis.setVisible(false);
			Ext.each(permissionList, function(privilege) {
		   		 if (privilege === 'SUBMIT_THESIS') {
		   			btnSubmitThesis.setVisible(true);      		
		   		 }
		   	 	});
		}
		
});
