/**
 * @author Manas
 * @description Controller to manage Evaluation Scheduling and Mark Uploads
 */
Ext.define('Academia.controller.examscheduled.EvaluationScheduledController', {
	extend: 'Academia.controller.base.BaseController',

	// Models typically match the store names or specific entities
	models: [],

	// Stores used across the listed views
	stores: [
		'common.AcademicTermStore',
		'examinationcenters.evaluation.SortingFilterStore',
		'examinationcenters.evaluation.SortingFilter2Store',
		'examinationcenters.evaluation.SortingFilter3Store',
		'importutility.ModuleName',
		'schedule.TemplateTypeStore',
		'examschedule.ImportUtilityExamScheduleGridStore'
	],

	// All the views identified from the uploaded files
	views: [
		'assessmentSchedule.AssessmentScheduleSearchFilter',
		'assessmentSchedule.AssessmentScheduleStructure',
		'assessmentSchedule.DownloadForEvalScheduleFilter',
		'assessmentSchedule.ImportUtilityAssessmentSchedule',
		'assessmentSchedule.ManageEvalScheduleSearch',
		'assessmentSchedule.UploadMarksForEvalScheduleFilter',
		'assessmentSchedule.Uploadmarksformevalschedule'
	],


	refs: [{
		ref: 'examTimetable',
		selector: 'examtimetable'
	}, {
		ref: 'assessmentStructure',
		selector: 'assessmentschedulestructure'
	}, {
		ref: 'searchFilter',
		selector: 'assessmentschedulesearchfilter'
	}, {
		ref: 'uploadMarksFilter',
		selector: 'uploadmarksforevalschedulefilter'
	}, {
		ref: 'importutilityassessmentschedule',
		selector: 'importutilityassessmentschedule'
	}, {
		ref: 'downloadforevalschedulefilter',
		selector: 'downloadforevalschedulefilter'
	}, {
		ref: 'uploadmarksforevalschedulefilter',
		selector: 'uploadmarksforevalschedulefilter'
	}],


	/**
	 * Component control and event listeners
	 */
	init: function() {
		this.control({
			// Example: Listen for search button click in the filter
			'assessmentschedulesearchfilter button[itemId=searchBtn]': {
				click: this.onSearchClick
			},
			'uploadmarksforevalschedulefilter customcombobox[itemId=uploadTemplateForItemId]': {
				select: this.onTemplateForChange
			},
			'downloadforevalschedulefilter customcombobox[itemId=templateName]': {
				select: this.onTemplateChange
			},

		/*	'uploadmarksforevalschedulefilter customcombobox[itemId=uploadTemplateForItemId]': {
				select: this.onTemplateForChangebyUplaod
			}, */ 

			'importutilityassessmentschedule': {
				cellclick: this.getDownloadLogFileForPreExamDetail
			},
			// Example: Listen for radio group change in upload marks view
			'uploadmarksformevalschedule radiogroup[itemId=importDownloadgroupId]': {
				change: this.onUploadTemplateTypeChange
			},

			'uploadmarksformevalschedule radiogroup[itemId=resetBtn]': {
				change: this.onUploadTemplateTypeChange
			},

			'downloadforevalschedulefilter button[itemId=scheduleDownload]': {
				click: this.downloadExamScheduleTemplate
			},

			'downloadforevalschedulefilter button[itemId=resetBtn]': {
				click: this.resetExamScheduleTemplate
			},

			'uploadmarksforevalschedulefilter button[itemId=resetBtn]': {
				click: this.resetUploadMarksModerationForm
			},
			'uploadmarksforevalschedulefilter button[itemId=uploadScheduleBtn]': {
				click: this.uploadPreExamDetailData
			},

			'importutilityassessmentschedule button[itemId=btnForce]': {
				click: this.doForceRunPreExamDetailJob
			},

			'uploadmarksforevalschedulefilter uploadoptionradiogroup[itemId=uploadmarksUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]': {
				change: this.toggleMyUploadAllUpload
			},
			'uploadmarksforevalschedulefilter uploadoptionradiogroup[itemId=uploadmarksUploadOptionRadioGroupItemId] radiogroup[itemId=resetBtn]': {
				change: this.resetExamScheduleTemplate
			},
			
			'importutilityassessmentschedule': {
				cellclick: this.getDownloadLogFileForEvalSchedule
			}
		});
	},

	/**
	 * Event Handlers (Placeholders)Fgrid
	 */
	onSearchClick: function(btn) {
		console.log('Search initiated from EvaluationScheduledController');
		// Implementation logic for search
	},

	resetExamScheduleTemplate: function(btn) {
		var form = btn.up('form') || btn.up('panel').down('form');
		if (form) {
			form.getForm().reset();
		}
	},

	resetUploadMarksModerationForm: function(btn) {
	   //  var formCmp = btn.up('form') || btn.up('panel'); 
		var formCmp = this.getUploadmarksforevalschedulefilter();
		
	    var form = formCmp.getForm();

	    form.findField('file').reset();
		form.findField('templateFor').reset();

	    formCmp.down('uploadoptionradiogroup')
	           .down("#uploadgroupItemId")
	           .setValue({ isUploadAll: false });

	    form.checkValidity();
	},
	
	onTemplateForChange: function(cmp, records) {

		var curVal = records[0].get('displayValue');
		var form = cmp.up('form');
		var moduleName = records[0].get('value');
		var combo = form.down('#moduleNamePreExamDetail');
		combo.getStore().load({
			callback: function(records, operation, success) {
				for (var i in records) {
					if (records[i].data.value == moduleName) {
						combo.setValue(records[i].data.id);
						combo.setReadOnly(true);
					}
				}
			}
		});
		var grid = this.getImportutilityassessmentschedule();
		var gridStore = grid.getStore();
		gridStore.getProxy().extraParams = {
			moduleName: records[0].get('value')
		};
		this.resetPageSetting(gridStore, grid);
		gridStore.pageSize = 100;
		gridStore.load();
	},
	
    onTemplateChange: function (combo, record) {
	    var form = combo.up('form');       // parent form

	    if (form) {
	        Ext.suspendLayouts();          // fast reset
	        form.getForm().getFields().each(function (field) {
	            if (field.itemId !== 'templateName') {
	                field.reset();
	            }
	        });
	        Ext.resumeLayouts(true);
	    }
	},
	
	onTemplateForChangebyUplaod: function(cmp, records) {

	    var form = cmp.up('form');
	    var uploadBtn = form.down('#uploadgroupItemId');
		
		var myUploadBtn = form.down('#uploadmarksUploadOptionRadioGroupItemId');

		var fileField = form.down('#uploadFileField');
		if (fileField) {
		    fileField.reset();
		}
		myUploadBtn.setDisabled(false);
	    uploadBtn.setDisabled(!form.getForm().isValid());
	},

	onUploadTemplateTypeChange: function(radio, nVal, oVal) {
	    var downloadTemplateForm = this.getDownloadforevalschedulefilter();
	    var uploadTemplateForm = this.getUploadmarksforevalschedulefilter();
	    
	    downloadTemplateForm.setVisible(nVal.downloadUploadTemplate == "forDownloadTemplate");
	    uploadTemplateForm.setVisible(nVal.downloadUploadTemplate == "forUploadTemplate");

	    var grid = this.getImportutilityassessmentschedule();

	    if (nVal.downloadUploadTemplate == 'forDownloadTemplate') {
	        this.doResetDownloadFrom(downloadTemplateForm.down('#resetBtn'));
	        grid.setVisible(false);
	        this.resetPageSetting(grid.getStore(), grid);
	    }
	    else {
	        this.resetUploadForm(uploadTemplateForm.down('#resetBtn'));
	        grid.setVisible(true);
	        this.resetPageSetting(grid.getStore(), grid);

	        var templateCombo = uploadTemplateForm.down('#uploadTemplateForItemId');
	        var templateText = templateCombo ? templateCombo.getRawValue() : null;

	        this.onChangeUploadOptionRadioGroup(false, grid, templateText);
	    }
	},

	/*   loadTemplateNameCombo: function(combo) {
			combo.getStore().load({
				callback: function(records, operation, success) {
					for(var i in records){
						if(records[i].data.code == 'importMarksModeration'){
							combo.setValue(records[i].data.id);
							combo.setReadOnly(true);
						}
					}
				}	   
			});
		},*/

	resetUploadForm: function(btn) {
		var form = btn.up('form').getForm();
		form.findField('file').reset();
		var uploadoptionradiogroupform = btn.up('form').down('uploadoptionradiogroup');
		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
			isUploadAll: false
		});
		form.checkValidity();
	},

	doResetDownloadFrom: function(btn) {
		var form = btn.up('form');
		form.getForm().reset();
		// 	form.down('#evaluationPlanIdMarkModeration').disable();

	},

	uploadPreExamDetailData: function(obj) {
		var $this = this;
		var grid = this.getImportutilityassessmentschedule();
		var form = this.getUploadmarksforevalschedulefilter();
		var vals = form.getValues();
		$this.getHashOfFile(form);
		var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;


		setTimeout(function() {
			form.getForm().submit({
				method: 'POST',
				url: submitUrl,
				success: function(form, action) {
					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
					grid.getStore().load();
					form.reset();
					$this.resetUploadMarksModerationForm($this.getImportutilityassessmentschedule().down('#resetBtn'));
				},
				failure: function(form, action) {
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CONTENT_MISMATCH'));
				}
			});
		}, 1000);
	},


	doForceRunPreExamDetailJob: function(obj) {
		var grid = this.getImportutilityassessmentschedule();
		if (grid.getSelectionModel().getCount() > 0) {
			if (grid.getSelectionModel().getCount() > 1) {
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			} else {
				var this$ = this;
				var id = grid.getSelectionModel().selectionStart.data.id;
				console.log(id);
				var urlAppend = "?jobName=" + id;
				var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
				Ext.Ajax.request({
					url: submitURL,
					method: 'GET',
					success: function(response) {
						if (response.responseText === "JOB_STATUS_NOT_PENDING") {
							showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
						} else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
							showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
						} else if (response.responseText === "SUCCESS") {
							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
						}
					}
				});
			}
		} else {
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},

	getDownloadLogFileForEvalSchedule: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	         if (e.target.tagName == 'A') {
	             var fileType = null;
	             if (cellIndex == 1) {
	                 fileType = 'successFile';
	             } else if (cellIndex == 6) {
	                 fileType = 'errorFile';
	             } else if (cellIndex == 7) {
	                 fileType = 'logFile';
	             }
	             var documentId = record.get("id");
	             if (!isNullOrEmpty(documentId)) {
	                 this.getDownloadFileNew(documentId, fileType);
	             }
	         }
	     },
	     
	     getDownloadFileNew: function (documentId, fileType) {
	          if (!isNullOrEmpty(documentId)) {
	              var csvForm = Ext.create('Ext.form.Panel');
	              csvForm.getForm().submit({
	                  target: '_blank',
	                  method: 'POST',
	                  params: {
	                      access_token: Ext.Ajax.defaultHeaders.access_token
	                  },
	                  headers: {
	                      'Authorization': Ext.Ajax.defaultHeaders.Authorization
	                  },
	                  url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
	                  standardSubmit: true
	              });
	          }
	      },

	downloadExamScheduleTemplate: function(btn) {
		var form = btn.up('form');
		var values = form.getValues();
		var downloadUrl = values.templateName && values.templateName.includes('CAMPUS')
			? SERVERURL.DOWNLOAD_TEMPLATE_FOR_ASSESSMENT_SCHEDULES
			: SERVERURL.DOWNLOAD_FOR_ASSESSMENT_SCHEDULES_QCTO;

		var payload = {
			templateName: values.templateName,
			academicTermId: values.scbeduleTermId
		};

		var hiddenForm = Ext.create('Ext.form.Panel', {
			items: [{
				xtype: 'textfield',
				name: 'exportListDTO',
				value: Ext.encode(payload)
			}]
		});

		hiddenForm.getForm().submit({
			url: downloadUrl,
			method: 'POST',
			target: '_blank',
			standardSubmit: true,
			params: {
				access_token: Ext.Ajax.defaultHeaders.access_token,
				academicTermId: values.scbeduleTermId
			},
			headers: {
				'Authorization': Ext.Ajax.defaultHeaders.Authorization
			}
		});
	},

	toggleMyUploadAllUpload: function(radio, nVal) {
	    var form = radio.up('uploadmarksforevalschedulefilter');
	    var templateCombo = form.down('#uploadTemplateForItemId');
	    var templateText = templateCombo.getRawValue();
	    var grid = this.getImportutilityassessmentschedule();
	    this.onChangeUploadOptionRadioGroup(nVal, grid, templateText);
	}
});