var attendanceTypeSettings=[];
Ext.define('Academia.controller.facultyportal.attendance.FacultyStudentAttendanceSummaryReportController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['attendance.UpdateAttendanceModel'],
	stores : ['attendance.attendancereport.AcadmyByAdmission',
		'common.AcademicTermStore',
		'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
		'attendance.facultyportal.AttendanceProgramStore',
		'attendance.FacultyAttendanceReportTreeStore',
		'attendance.StudentAttendanceStatusStore',
		'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore',
		'attendance.facultyportal.AttendanceCourseVariantStore',
		'attendance.facultyportal.StudentAttendanceSummaryReportStore',
		'attendance.facultyportal.CourseLevelAttendanceReportStore',
		'messaging.AttendanceReportStaticDocumentAttachmentGridStore',
		'messaging.MessagingTemplatesStore',
		'committee.committee.MessageTypeNotificationStore',
		'attendance.attendancereport.AttendanceRegisterStore',
		'attendance.attendancereport.AttendanceReportSummary',
		'attendance.attendancereport.AttendanceReportGrid'
		],
		requires:['Ext.ux.LinkedTagField' ],
		views : ['facultyPortal.attendance.AttendanceSummaryReportStructureForFaculty',
			'facultyPortal.attendance.CompleteDayStudentAttendanceSummarySearch',
			'facultyPortal.attendance.SessionWiseStudentAttendanceSummarySearch',
			'facultyPortal.attendance.CourseLevelStudentAttendanceSummarySearch',
			'facultyPortal.attendance.StudentAttendanceSummaryGridForFaculty',
			'facultyPortal.attendance.StudentCourseAttendanceSummaryGridForFaculty',
			'attendance.attendancereport.AttendanceDataStatus',
			'attendance.attendancereport.AttendanceDataStatusGrid',
			'attendance.attendancereport.AttendanceDataStatusDetails',
			'Academia.view.attendance.attendancereport.AttendanceSendSurvey',
			'attendance.AttendanceRegisterWindow','personinfo.student.AttendanceReportStudentSendMessages','messaging.AttendanceReportStudentStaticDocumentAttachmentGrid'
			],
			config: {
				FACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES')			},
				refs : [{
					ref : 'attendancesummaryreportstructureforfaculty',
					selector : 'attendancesummaryreportstructureforfaculty'
				},{
					ref : 'completedaystudentattendancesummarysearch',
					selector : 'completedaystudentattendancesummarysearch'
				},{
					ref : 'sessionwisestudentattendancesummarysearch',
					selector : 'sessionwisestudentattendancesummarysearch'
				},{
					ref : 'courselevelstudentattendancesummarysearch',
					selector : 'courselevelstudentattendancesummarysearch'
				},{
					ref : 'studentattendancesummarygridforfaculty',
					selector : 'studentattendancesummarygridforfaculty'
				},{
					ref : 'studentcourseattendancesummarygridforfaculty',
					selector : 'studentcourseattendancesummarygridforfaculty'
				},{
					ref : 'attendancedatastatus',
					selector : 'attendancedatastatus'
				},{
					ref : 'attendancedatastatusgrid',
					selector : 'attendancedatastatusgrid'
				},{
					ref : 'attendancedatastatusdetails',
					selector : 'attendancedatastatusdetails'
				},{
					ref :'attendancesendsurvey',
					selector : 'attendancesendsurvey'
				},{
					ref :'attendanceSendSurvey',
					selector : 'attendancesendsurvey form'
				},{
					ref: 'attendanceregisterwindow',
					selector: 'attendanceregisterwindow'
				},{
					ref :'attendancereportstudentsendmessages',
					selector : 'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows]'
				},{
					ref: 'contentpanel',
					selector: 'contentpanel'
				},{
					ref :'attendanceReportStudentDocumentMessageAttachmentGrid',
					selector : 'attendancereportstudentstaticdocumentattachmentgrid [itemId=attendancereportstudentstaticdocumentattachmentgridmessage]'
				}],
				init : function() {
					this.control({
						'attendancesummaryreportstructureforfaculty': {
							render: function(obj){
								var grid = obj.down('studentattendancereportgridforfaculty');
								this.checkAttendanceSettingAndPermissions(this.getCurrentAcademyLocation());
							}
						},
						'studentattendancesummarygridforfaculty':{
							render:function(grid){
								var portalId = this
								.getCurrentLoggedPortalId();
								if (portalId == 2) {
									this.doAccessControlValidation(grid, this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES());
									this.disableMoreActionPivileges(grid, this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES());
								}
							},
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								var $this=this;
								var attendanceSummaryGrid = $this.getStudentattendancesummarygridforfaculty();
								var columnName=attendanceSummaryGrid.columnManager.columns[cellIndex].dataIndex;

								if(columnName=='totalRecords' &&  record.data.totalRecords > 0){
									this.attendanceSummayDataAccordingAttendanceStatus(record);
								}

								if(columnName=='presentRecords' &&  record.data.presentRecords > 0){
									var status = 'PRESENT';
									this.attendanceSummayDataAccordingAttendanceStatus(record,status);
								}
								if(columnName=='absentRecords' &&  record.data.absentRecords > 0){
									var status = 'ABSENT';
									this.attendanceSummayDataAccordingAttendanceStatus(record,status);
								}
							}
						},
						'studentcourseattendancesummarygridforfaculty':{
							render:function(grid){
								this.doAccessControlValidation(grid, this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES());
								this.disableMoreActionPivileges(grid, this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES());
							},
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								var $this=this;
								var attendanceSummaryGrid = $this.getStudentcourseattendancesummarygridforfaculty();
								var columnName=attendanceSummaryGrid.columnManager.columns[cellIndex].dataIndex;

								if(columnName=='totalRecords' &&  record.data.totalRecords > 0){
									this.attendanceSummayDataAccordingAttendanceStatus(record);
								}

								if(columnName=='presentRecords' &&  record.data.presentRecords > 0){
									var status = 'PRESENT';
									this.attendanceSummayDataAccordingAttendanceStatus(record,status);
								}
								if(columnName=='absentRecords' &&  record.data.absentRecords > 0){
									var status = 'ABSENT';
									this.attendanceSummayDataAccordingAttendanceStatus(record,status);
								}
							}
						},
						'attendancesummaryreportstructureforfaculty radiogroup[itemId=studentAttendanceTypeRadioField]':{
							change : function(obj,record){
								var attendanceType=record.summaryAttendanceType;
								this.onChangeAttendanceTypeReport(attendanceType); 
							}
						},
						'completedaystudentattendancesummarysearch customcombobox[itemId=academyLocationId]':{
							select : function(obj,record){
								var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
								authenticationController.loadMultipleLangFilePerAL(record[0].data.id);
								var form =  this.getAttendancesummaryreportstructureforfaculty();
								form.down('[inputValue=COMPLETE_DAY]').setValue(false);
								form.down('[inputValue=COURSE_LEVEL]').setValue(false);
								form.down('[inputValue=MULTIPLE_SESSION]').setValue(false);
								this.checkAttendanceSettingAndPermissions(record[0].data.id);
								form.down('#selectedAcademyLocationId').reset();
								form.down('#selectedAcademyLocationId').setValue(record[0].data.id);
							}
						},
						'sessionwisestudentattendancesummarysearch customcombobox[itemId=academyLocationId]':{
							select : function(obj,record){
								var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
								authenticationController.loadMultipleLangFilePerAL(record[0].data.id);
								var form =  this.getAttendancesummaryreportstructureforfaculty();
								form.down('[inputValue=COMPLETE_DAY]').setValue(false);
								form.down('[inputValue=COURSE_LEVEL]').setValue(false);
								form.down('[inputValue=MULTIPLE_SESSION]').setValue(false);
								this.checkAttendanceSettingAndPermissions(record[0].data.id);
								form.down('#selectedAcademyLocationId').reset();
								form.down('#selectedAcademyLocationId').setValue(record[0].data.id);
							}
						},
						'completedaystudentattendancesummarysearch customcombobox[itemId=attendanceSummaryAcademicTermId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var academicTermId = obj.value;
								if(academicTermId > 0) {
									setTimeout(function(){
										me.academicTermChange(form,academicTermId);
									},100);
								}
							}
						},
						'sessionwisestudentattendancesummarysearch customcombobox[itemId=sessionWiseAttendanceSummaryAcademicTermId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var academicTermId = obj.value;
								if(academicTermId > 0) {
									this.academicTermChange(form,academicTermId);
								}
							}
						},
						'completedaystudentattendancesummarysearch customcombobox[itemId=attendanceSummaryProgramGroupItemId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var programGroupId = obj.value;
								if(programGroupId > 0) {
									this.programGroupChange(form,programGroupId);
								}
							}
						},
						'sessionwisestudentattendancesummarysearch customcombobox[itemId=sessionWiseAttendanceSummaryProgramGroupId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var programGroupId = obj.value;
								if(programGroupId > 0) {
									this.programGroupChange(form,programGroupId);
								}
							}
						},
						'completedaystudentattendancesummarysearch customcombobox[itemId=attendanceSummaryStudentId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var studentId = obj.value;
								if(studentId > 0) {
									form.down('#statusComboItemId').setValue(obj.valueModels[0].data.activeStatus);
									this.onStudentFieldChange(form,studentId);
								}
							}
						},
						'sessionwisestudentattendancesummarysearch customcombobox[itemId=sessionWiseAttendanceSummaryStudentNameId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var studentId = obj.value;
								if(studentId > 0) {
									form.down('#statusComboItemId').setValue(obj.valueModels[0].data.activeStatus);
									this.onStudentFieldChange(form,studentId);
								}
							}
						},
						'completedaystudentattendancesummarysearch customcombobox[itemId=attendanceSummaryProgramId]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'completedaystudentattendancesummarysearch datefield[itemId=startDate]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'completedaystudentattendancesummarysearch datefield[itemId=tillDate]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'sessionwisestudentattendancesummarysearch customcombobox[itemId=sessionWiseAttendanceSummaryProgramId]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'sessionwisestudentattendancesummarysearch datefield[itemId=startDate]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'sessionwisestudentattendancesummarysearch datefield[itemId=tillDate]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'completedaystudentattendancesummarysearch button[itemId=attendanceSummarySearchButton]' :{
							click : function(obj, record){
								var me = this;
								var attendancesearchstrucure =  me.getAttendancesummaryreportstructureforfaculty();
								var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
								this.loadStudentAttendanceSummaryReport(attendanceType);
							}
						},
						'sessionwisestudentattendancesummarysearch button[itemId=sessionAttendanceSummaySearchBtn]' :{
							click : function(obj, record){
								var me = this;
								var attendancesearchstrucure =  me.getAttendancesummaryreportstructureforfaculty();
								var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
								this.loadStudentAttendanceSummaryReport(attendanceType);
							}
						},
						'completedaystudentattendancesummarysearch button[itemId=attendanceSummaryResetBtn]':{
							click : function(obj,record){
								var me = this;
								var attendancereportsearch =Ext.ComponentQuery.query('completedaystudentattendancesummarysearch')[0];
								var attendanceReportMainPanel = Ext.ComponentQuery.query('attendancesummaryreportstructureforfaculty')[0];
								
								var moreDetailId = attendancereportsearch.down('#moreDetailId');
								var isCollapsed = moreDetailId.collapsed;
								attendancereportsearch.destroy();
								attendanceReportMainPanel.insert(4,{xtype:'completedaystudentattendancesummarysearch'});
								var form = this.getCompletedaystudentattendancesummarysearch();
								form.config.isCollapsed = isCollapsed;
								form.down('#moreDetailId').collapse();
								if(form.config.isCollapsed){
									form.down('#moreDetailId').collapse();	
								}
								else{
									form.down('#moreDetailId').setExpanded(true);
								}
								setTimeout(function(){
									me.resetAttendanceSummarySearchForm(form);
								},100);
								var academyLocationId = attendanceReportMainPanel.down('#selectedAcademyLocationId').getValue();
								
								form.down('#academyLocationId').setValue(parseInt(academyLocationId));
							}
						},
						'sessionwisestudentattendancesummarysearch button[itemId=sessionAttendanceSummayResetBtn]':{
							click : function(obj,record){
								var me = this;
								var attendancereportsearch =Ext.ComponentQuery.query('sessionwisestudentattendancesummarysearch')[0];
								var attendanceReportMainPanel = Ext.ComponentQuery.query('attendancesummaryreportstructureforfaculty')[0];
								var moreDetailId = attendancereportsearch.down('#moreDetailId');
								var isCollapsed = moreDetailId.collapsed;
								attendancereportsearch.destroy();
								attendanceReportMainPanel.insert(6,{xtype:'sessionwisestudentattendancesummarysearch'});
								var form = this.getSessionwisestudentattendancesummarysearch();
								form.config.isCollapsed = isCollapsed;
								form.down('#moreDetailId').collapse();
								if(form.config.isCollapsed){
									form.down('#moreDetailId').collapse();	
								}
								else{
									form.down('#moreDetailId').setExpanded(true);
								}
								setTimeout(function(){
									me.resetAttendanceSummarySearchForm(form);
								},100);
								var academyLocationId = attendanceReportMainPanel.down('#selectedAcademyLocationId').getValue();
								form.down('#academyLocationId').setValue(parseInt(academyLocationId));
							}
						},
						'courselevelstudentattendancesummarysearch customcombobox[itemId=academyLocationId]':{
							select : function(obj,record){
								var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
								authenticationController.loadMultipleLangFilePerAL(record[0].data.id);
								var form =  this.getAttendancesummaryreportstructureforfaculty();
								form.down('[inputValue=COMPLETE_DAY]').setValue(false);
								form.down('[inputValue=COURSE_LEVEL]').setValue(false);
								form.down('[inputValue=MULTIPLE_SESSION]').setValue(false);
								this.checkAttendanceSettingAndPermissions(record[0].data.id);
								form.down('#selectedAcademyLocationId').reset();
								form.down('#selectedAcademyLocationId').setValue(record[0].data.id);
							}
						},
						'courselevelstudentattendancesummarysearch customcombobox[itemId=courseAttendanceSummaryAcademicTermId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var academicTermId = obj.value;
								if(academicTermId > 0) {
									this.onChangeAcademicTermFilter(form,academicTermId);
								}
							}
						},
						'courselevelstudentattendancesummarysearch customcombobox[itemId=courseAttendanceSummaryStudentNameId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var studentId = obj.value;
								if(studentId > 0) {
									form.down('#statusComboItemId').setValue(obj.valueModels[0].data.activeStatus);
									this.onChangeStudentNameFilter(form,studentId);
								}
							}
						},
						'courselevelstudentattendancesummarysearch customcombobox[itemId=courseAttendanceSummaryCourseVariantId]' :{
							change : function(obj, record){
								var me = this;
								var form = obj.up('form');
								var courseVariantId = obj.getValue();
								if(courseVariantId > 0) {
									this.attReportExportBtnDisableEnable();
								}
							}
						},
						'courselevelstudentattendancesummarysearch datefield[itemId=startDate]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'courselevelstudentattendancesummarysearch datefield[itemId=tillDate]' :{
							change : function(obj, record){
								this.attReportExportBtnDisableEnable();
							}
						},
						'courselevelstudentattendancesummarysearch button[itemId=courseLevelSummarySearchBtn]' :{
							click : function(obj, record){
								var me = this;
								var attendancesearchstrucure =  me.getAttendancesummaryreportstructureforfaculty();
								var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
								this.loadStudentCourseAttendanceSummaryReport();
							}
						},
						'courselevelstudentattendancesummarysearch button[itemId=courseLevelSummaryResetBtn]':{
							click : function(obj,record){
								var me = this;
								var attendancereportsearch =Ext.ComponentQuery.query('courselevelstudentattendancesummarysearch')[0];
								var attendanceReportMainPanel = Ext.ComponentQuery.query('attendancesummaryreportstructureforfaculty')[0];
								var moreDetailId = attendancereportsearch.down('#moreDetailId');
								var isCollapsed = moreDetailId.collapsed;
								attendancereportsearch.destroy();
								attendanceReportMainPanel.insert(5,{xtype:'courselevelstudentattendancesummarysearch'});
								var form = this.getCourselevelstudentattendancesummarysearch();
								form.config.isCollapsed = isCollapsed;
								form.down('#moreDetailId').collapse();
								if(form.config.isCollapsed){
									form.down('#moreDetailId').collapse();	
								}
								else{
									form.down('#moreDetailId').setExpanded(true);
								}
								setTimeout(function(){
									me.resetCourseLevelSummarySearchForm(form);
								},100);
								var academyLocationId = attendanceReportMainPanel.down('#selectedAcademyLocationId').getValue();
								form.down('#academyLocationId').setValue(parseInt(academyLocationId));
							}
						},
						'studentattendancesummarygridforfaculty button[itemId=summarySendMessageBtn]': {
							click : function(obj, record){
								var grid = this.getStudentattendancesummarygridforfaculty();
								this.openStudentSendMessage(grid);
							}
						},
						'studentattendancesummarygridforfaculty button[itemId=sendSurveyBtn]': {
							click: function(obj) {
								var grid = this.getStudentattendancesummarygridforfaculty();
								if (grid.getSelectionModel().getCount() > 0) {
									var this$ = this;
									var window = this$.getAttendancesendsurvey();
									if(!window){
										window = Ext.widget('attendancesendsurvey');
									}
									window.show();
								} else {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
								}  
							}
						},
						'studentattendancesummarygridforfaculty button[itemId=exportReport]': {
							click: function(obj) {
								this.openAttendanceRegisterWin();
							}
						},
						'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows] radiogroup[itemId=messageType]':{
							change : function(val,nV,oV){
								this.selectSectionMessageType(val,nV,oV);
							}
						},
						'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows] customcombobox[itemId=msgTempletId]':{
							select : function(obj,rec){
								this.selectMessageTemp(obj,rec);
							}
						},
						'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows] button[itemId=adhocMsgSubmitBtn]':{
							click: function(obj) {
								var grid = this.getStudentattendancesummarygridforfaculty();
								var studentsendmessage = this.getAttendancereportstudentsendmessages();

								var wsMsgEventRecipientConfigsUpdated = [];
								var formData = obj.up('form').getValues();

								var sendMessageToOptions = formData.recieverType;
								var isStudentChecked = false;
								var isParentChecked = false;
								var isFeePayerChecked = false;
								var isMySelfChecked = false;
								var isLoggedInUserId=this.getCurrentlyLoggedInUser().id;
								
								var formPnl = obj.up('form');
			    				var fldValues = formPnl.getForm().getFieldValues();
			    				if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false ){
			  	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
			  	        	    	return;
			  	        	    }
								
								if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
									if(sendMessageToOptions.constructor === Array){
										if(sendMessageToOptions.length > 0){
											sendMessageToOptions.forEach(function(current_value, index, initial_array) {
												if(current_value == 1 || current_value == '1'){
													isStudentChecked = true;
												}
												if(current_value == 2 || current_value == '2'){
													isParentChecked = true;
												}
												if(current_value == 3 || current_value == '3'){
													isFeePayerChecked = true;
												}if(current_value == 4 || current_value == '4'){
		  											isMySelfChecked = true;
		  										}
											});
										}
									}else{
										if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
											isStudentChecked = true;
										}
										if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
											isParentChecked = true;
										}
										if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
											isFeePayerChecked = true;
										}
										if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
											isFeePayerChecked = true;
										}if(sendMessageToOptions == 4 || sendMessageToOptions == '4'){
		  									isMySelfChecked = true;
		  								}
									}
								}

								//var abc = xyz.c;

								if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
									//wsMsgEventRecipientConfigsUpdated = [];
									studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
								}else{
									var recipientIds = formData.recipientFieldARName;
									recipientIds = Ext.encode(recipientIds);

									/*if(grid.itemId == 'attendancereportgridItemId'){
			    						recipientIds = this.getStudentReceipientIdsForAttendanceReport(grid);
			    						recipientIds = Ext.encode(recipientIds);
			    						//typeId = 2;
			    						//recipientId = 2;
			    					}*/

									var RecipientTypeCodes = ["Parent Adhoc"];

									if(isParentChecked){ // Both checkboxes are cheked 
										// Ajax Call to get Parent Ids by Admission Ids

										Ext.Ajax.request({
											type: 'rest',
											url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
											jsonData: RecipientTypeCodes,
											method: 'POST',
											async: false,
											success: function(response) {
												var RecipientTypeCodesData = Ext.decode(response.responseText);

												Ext.Ajax.request({
													type: 'rest',
													url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
													jsonData: recipientIds,
													method: 'POST',
													async: false,
													success: function(response) {
														// update wsMsgEventRecipientConfigsUpdated with parent ids
														var wsMsgEventRecipientConfigsParents = {
																msgRecipientTypeId: 66,
																msgTemplateConfigId: 0,	//formData.id, 
																selectiveRecipientIds: []
														};
														if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
															wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
														}
														wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);

														// Ajax Call to get Fee Payer Ids by Admission Ids
														Ext.Ajax.request({
															type: 'rest',
															url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
															jsonData: recipientIds,
															method: 'POST',
															success: function(response) {
																// update wsMsgEventRecipientConfigsUpdated with fee payer ids
																var wsMsgEventRecipientConfigsFeePayer = {
																		msgRecipientTypeId: 67,
																		msgTemplateConfigId: 0,	//formData.id, 
																		selectiveRecipientIds: []
																};

																if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																	wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
																}

																wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
																wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
																studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
															}
														});
													}
												});
											}
										});
									}else{ // Only one checkbox is selected
										var urlNew = '';
										if(isParentChecked) { // If Parent checkbox is selected
											// url for getting parent ids
											urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
										}
										/*if(isFeePayerChecked) { // If Fee Payer checkbox is selected
			    							// url for getting fee payer ids
			    							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
			    						}
										 */
										Ext.Ajax.request({
											type: 'rest',
											url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
											jsonData: RecipientTypeCodes,
											method: 'POST',
											success: function(response) {
												var RecipientTypeCodesData = Ext.decode(response.responseText);

												Ext.Ajax.request({
													type: 'rest',
													url: urlNew,
													jsonData: recipientIds,
													method: 'POST',
													success: function(response) {
														if(isParentChecked) { // If Parent checkbox is selected
															// update wsMsgEventRecipientConfigsUpdated with parent ids
															var wsMsgEventRecipientConfigsParents = {
																	msgRecipientTypeId: 66,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};
															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
																wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
															}
															wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
															wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
														}
														if(isFeePayerChecked) { // If Fee Payer checkbox is selected
															// update wsMsgEventRecipientConfigsUpdated with fee payer ids
															var wsMsgEventRecipientConfigsFeePayer = {
																	msgRecipientTypeId: 67,
																	msgTemplateConfigId: 0,	//formData.id, 
																	selectiveRecipientIds: []
															};
															if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
																wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
															}
															wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
															wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
														}
														studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked);
													}
												});
											}
										});

									}
								}
								if(isMySelfChecked){
	  	    						var wsMsgEventRecipientConfigsMySelf = {
	  	    									msgRecipientTypeId: 166,
	  	    									msgTemplateConfigId: 0,	//formData.id, 
	  	    									selectiveRecipientIds: [isLoggedInUserId]
	  	    										};
	  	    							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsMySelf);

	  	    										}
							}
						},
						'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows] textarea[itemId=smsDiscription]':{
							change : function(val,nV,oV){
								var studentsendmessage = this.getAttendancereportstudentsendmessages();
								var smsTextField = studentsendmessage.down('#smsDiscription');
								var smsTextFieldDiscription = studentsendmessage.down('#smsDiscriptionNotice');  
								var maxLength = localStorage.getItem('maxLength');
								var newValue = maxLength - smsTextField.getValue().length;
								smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
							}
						},
						'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows]  filefield[itemId=staticUploadFileField]': {
							change: function(fileField, value, eOpts){
								var this$ = this;
								this$.uploadStudentStaticDocumentFileMessage(fileField, value, eOpts);
							}
						},
						'attendancereportstudentstaticdocumentattachmentgrid[itemId=attendancereportstudentstaticdocumentattachmentgridmessage] actioncolumn': {
							click : function(view, rowIndex, colIndex, item, e, record, row){
								this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
							}
						},'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows]': {
							render: function(grid){
								var this$ = this;
								var docGrid = grid.down('#attendancereportstudentstaticdocumentattachmentgridmessage');
								docGrid.getStore().removeAll();
								docGrid.getStore().sync();
							}
						}, 'attendancereportstudentsendmessages[itemId=studentListSendMessageWindows] radiogroup#sendingPriority': {
							change: function( radio, newValue, oldValue, eOpts) {
								this.loadStudentScheduleField(radio, newValue, oldValue);
							}
						},
						'attendancereportstudentsendmessages':{
							render:function(messageForm){
								var portalId = this.getCurrentLoggedPortalId();
								var searchForm=this.getAttendancereportstudentsendmessages();
								var academyLocationId = this.getCurrentAcademyLocation();
								var permissionsMap = new Ext.util.HashMap();
								permissionsMap= this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES();
								var associatedAcadLocationIds = new Array();
								associatedAcadLocationIds.push(academyLocationId);
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
								var messageTypeRadio=searchForm.getForm().findField('messageTypeGroup');
								var adhocMessage, messageTemplate;
								messageTypeRadio.setVisible(false);
								if((Ext.Array.contains(permissionList, 'ADHOC_MESSAGE'))){
									messageTypeRadio.items.items[0].setValue(true);
									messageTypeRadio.items.items[1].setValue(false);
									adhocMessage=true;
								}
								if((Ext.Array.contains(permissionList, 'MESSAGE_TEMPLATE'))){
									messageTypeRadio.items.items[0].setValue(false);
									messageTypeRadio.items.items[1].setValue(true);
									messageTemplate=true;
								}
								if(adhocMessage && messageTemplate){
									messageTypeRadio.setVisible(true);
									messageTypeRadio.items.items[0].setValue(true);
									messageTypeRadio.items.items[1].setValue(false);
								}

							}
						},
						'attendancesendsurvey button#saveBtn': {
							click: function(obj) {
								this.sendSurveyDetails(obj);
							}
						},

						'attendanceregisterwindow button[itemId=submitBtn]': {
							click: function(btn) {
								this.exportXlsStudentAttendance();
							}
						},
						'studentcourseattendancesummarygridforfaculty button[itemId=summarySendMessageBtn]': {
							click : function(obj, record){
								var grid = this.getStudentcourseattendancesummarygridforfaculty();
								this.openStudentSendMessage(grid);
							}
						},
						'studentcourseattendancesummarygridforfaculty button[itemId=sendSurveyBtn]': {
							click: function(obj) {
								var grid = this.getStudentcourseattendancesummarygridforfaculty();
								if (grid.getSelectionModel().getCount() > 0) {
									var this$ = this;
									var window = this$.getAttendancesendsurvey();
									if(!window){
										window = Ext.widget('attendancesendsurvey');
									}
									window.show();
								} else {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
								}  
							}
						},
						'studentcourseattendancesummarygridforfaculty button[itemId=exportReport]': {
							click: function(obj) {
								this.openAttendanceRegisterWin();
							}
						},
					});
				},
				checkAttendanceSettingAndPermissions : function(academyLocationId) {
					var me = this;
					var $this=this;
					var form =this.getAttendancesummaryreportstructureforfaculty();
					var attendanceTypeRadio=form.down('#studentAttendanceTypeRadioField');
					var permissionsMap = new Ext.util.HashMap();
					permissionsMap=this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES();
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(academyLocationId);
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

					var studentAttendanceType = [];
					var attendanceType=[];
					attendanceTypeSettings = [];
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY)) {
						attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
						attendanceTypeSettings.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
					}
					if(!isNullOrEmpty(attendanceTypess.data.MULTIPLE_SESSION)) {
						attendanceType.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
						attendanceTypeSettings.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
					}
					if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)) {
						attendanceType.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
						attendanceTypeSettings.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
					}

					if(attendanceType.length > 0){
						studentAttendanceType=attendanceType.join();
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
					}


					//--setting initial values to false
					var tab2=false, tab3=false,tab4=false;

					//--initially setting all radio fields to true
					var completeDayRadio = form.down('[inputValue=COMPLETE_DAY]');
					var courseLevelRadio = form.down('[inputValue=COURSE_LEVEL]');
					var multipleSessionRadio = form.down('[inputValue=MULTIPLE_SESSION]');
					attendanceTypeRadio.items.items[0].setVisible(true);
					attendanceTypeRadio.items.items[1].setVisible(true);
					attendanceTypeRadio.items.items[2].setVisible(true);

					//--checking for the visible tabs
					if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
						tab2=true;
					}
					if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
						tab3=true;
					}
					if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
						tab4=true;
					}

					if(!tab2 && !tab3 && !tab4){
						tab2=true;
					}

					if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
						attendanceTypeRadio.setVisible(false);
					}
					else {
						attendanceTypeRadio.setVisible(true);
					}

					//-- setting values to true/false on the basis of visible tabs
					if(!tab2){
						attendanceTypeRadio.items.items[0].setVisible(false);
					}
					if(!tab3){
						attendanceTypeRadio.items.items[1].setVisible(false);
					}
					if(!tab4){
						attendanceTypeRadio.items.items[2].setVisible(false);
					}

					//-- setting radioGroup value on the basis of visible tabs
					setTimeout(function(){
						if(tab2){
							completeDayRadio.setValue(true);
						}
						else if(tab3){
							courseLevelRadio.setValue(true);
						}
						else if(tab4){
							multipleSessionRadio.setValue(true);
						}
					},300);
				},
				onChangeAttendanceTypeReport:function(attendanceType){
					var $this = this;
					var programWiseSearch = this.getCompletedaystudentattendancesummarysearch();
					var courseWiseSearch = this.getCourselevelstudentattendancesummarysearch();
					var sessionWiseSearch = this.getSessionwisestudentattendancesummarysearch();
					var programGrid = this.getStudentattendancesummarygridforfaculty();
					var courseGrid = this.getStudentcourseattendancesummarygridforfaculty()
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var academyLocationId = this.getAttendancesummaryreportstructureforfaculty().down('#selectedAcademyLocationId').getValue();
					if(isNullOrEmpty(academyLocationId)) {
						this.setCurrentAcademyLocationOnSummaryReport(programWiseSearch);
						academyLocationId = this.getCurrentAcademyLocation()
					} else {
						academyLocationId = parseInt(academyLocationId);
					}
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
						programGrid.setVisible(true);
						courseGrid.setVisible(false);
						programGrid.getStore().removeAll();
						try{
							programGrid.down('custompagingtoolbar').hide();
						}catch(e){
						}
						if(wheatherSchool){
							programGrid.columns[9].setVisible(false);
						} else {
							programGrid.columns[9].setVisible(true);
						}
						var exportReport = programGrid.down("#exportReport");
						exportReport.setDisabled(true);
						programWiseSearch.setVisible(true);
						sessionWiseSearch.setVisible(false);
						courseWiseSearch.setVisible(false);
						
						programWiseSearch.down('#moreDetailId').collapse();
						programWiseSearch.down('#academyLocationId').setValue(academyLocationId);
						var data=attendanceTypess.data.COMPLETE_DAY;
						if(wheatherSchool) {
							programWiseSearch.down("#attendanceSummaryProgramId").setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
						} else {
							programWiseSearch.down("#attendanceSummaryProgramId").setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
						}
						var academicTerm = programWiseSearch.down('#attendanceSummaryAcademicTermId');
						var studentField = programWiseSearch.down('#attendanceSummaryStudentId');
						var programGroupField = programWiseSearch.down('#attendanceSummaryProgramGroupItemId');
						var programBatchPeriodFeild = programWiseSearch.down('#attendanceSummaryProgramId');
						var attendancePercentageFromField = programWiseSearch.down('#attendancePercentageFromId');
						var attendancePercentageToFeild = programWiseSearch.down('#attendancePercentageToId');
						var absentAboveNumberOfSessionsFeild = programWiseSearch.down('#absentAboveNumberOfSessions');
						var minAbsentPercentageFeild = programWiseSearch.down('#minAbsentPercentageId');
						var attendancePercentageToFeild = programWiseSearch.down('#attendancePercentageToId');
						var startDateField = programWiseSearch.down('#startDate');
						var endDateField = programWiseSearch.down('#tillDate');

						academicTerm.reset();
						studentField.reset();
						programBatchPeriodFeild.reset();
						attendancePercentageFromField.reset();
						attendancePercentageToFeild.reset();
						absentAboveNumberOfSessionsFeild.setValue(0);
						minAbsentPercentageFeild.setValue(0);
						startDateField.reset();
						endDateField.reset();

						var academicTermStore = academicTerm.getStore();
					 		academicTermStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId
						};
						academicTermStore.load({
				 			callback: function(rec, success) {
				 				if (success) {
				 					for(var i in rec){
				 						if(rec[i].get('whetherCurrentAcademicTerm')){
				 							programWiseSearch.down('#attendanceSummaryAcademicTermId').setValue(rec[i].get('id'));
				 							var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				 							var studentStore = studentField.getStore();
				 							studentStore.getProxy().api.read=submitURL;
				 							studentStore.getProxy().extraParams = {
				 								academyLocationIds : academyLocationId,
				 								facultyId : facultyId,
				 								academicTermId : rec[i].get('id')
				 							};
				 							studentStore.load();

				 							var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				 							programByAcademyLocationStore.getProxy().extraParams = {
				 								academyLocationIds:academyLocationId,
				 								facultyId:facultyId,
				 								onlyCurrentRecords:false,
				 								wheatherSchool:wheatherSchool,
				 								academicTermId : rec[i].get('id')
				 							};
				 							programByAcademyLocationStore.load();
				 						}
				 					}
				 				}
				 			}
				 		});

					} else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL') {
						programGrid.setVisible(false);
						courseGrid.setVisible(true);
						courseGrid.getStore().removeAll();
						try{
							courseGrid.down('custompagingtoolbar').hide();
						}catch(e){
						}
						var exportReport = courseGrid.down("#exportReport");
						exportReport.setDisabled(true);
						programWiseSearch.setVisible(false);
						sessionWiseSearch.setVisible(false);
						courseWiseSearch.setVisible(true);
						courseWiseSearch.down('#academyLocationId').setValue(academyLocationId);
						var date = new Date();
						var academicTerm = courseWiseSearch.down('#courseAttendanceSummaryAcademicTermId');
						var studentField = courseWiseSearch.down('#courseAttendanceSummaryStudentNameId');
						var courseVariantFeild = courseWiseSearch.down('#courseAttendanceSummaryCourseVariantId');
						var attendancePercentageFromField = courseWiseSearch.down('#attendancePercentageFromCBSId');
						var attendancePercentageToFeild = courseWiseSearch.down('#attendancePercentageToCBSId');
						var absentAboveNumberOfSessionsFeild = courseWiseSearch.down('#absentAboveNumberOfSessions');
						var minAbsentPercentageFeild = courseWiseSearch.down('#minAbsentPercentageCBSId');
						var startDateField = courseWiseSearch.down('#startDate');
						var endDateField = courseWiseSearch.down('#tillDate');
						courseWiseSearch.down('#moreDetailId').collapse();
						academicTerm.reset();
						studentField.reset();
						courseVariantFeild.reset();
						attendancePercentageFromField.reset();
						attendancePercentageToFeild.reset();
						absentAboveNumberOfSessionsFeild.setValue(0);
						minAbsentPercentageFeild.setValue(0);
						startDateField.reset();
						endDateField.reset();

						var academicTermStore = academicTerm.getStore();
						academicTermStore.load({
				 			callback: function(rec, success) {
				 				if (success) {
				 					for(var i in rec){
				 						if(rec[i].get('whetherCurrentAcademicTerm')){
				 							courseWiseSearch.down('#courseAttendanceSummaryAcademicTermId').setValue(rec[i].get('id'));
				 							var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
				 							var studentStore = studentField.getStore();
				 							studentStore.getProxy().api.read=submitURL;
				 							studentStore.getProxy().extraParams = {
				 								academyLocationIds: academyLocationId,
				 								facultyId: facultyId,
				 								academicTermId : rec[i].get('id')
				 							};
				 							studentStore.load();

				 							var courseVariantStore = courseVariantFeild.getStore();
				 							courseVariantStore.getProxy().extraParams = {
				 								academyLocationIds: academyLocationId,
				 								facultyId: facultyId,
				 								isCurrentPeriod:false,
				 								academicTermId : rec[i].get('id')
				 							};
				 							courseVariantStore.load();
				 						}
				 					}
				 				}
				 			}
				 		});
					} else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION') {
						programGrid.setVisible(true);
						courseGrid.setVisible(false);
						programGrid.getStore().removeAll();
						try{
							programGrid.down('custompagingtoolbar').hide();
						}catch(e){
						}
						var exportReport = programGrid.down("#exportReport");
						exportReport.setDisabled(true);
						if(wheatherSchool){
							programGrid.columns[9].setVisible(false);
						} else {
							programGrid.columns[9].setVisible(true);
						}
						programWiseSearch.setVisible(false);
						sessionWiseSearch.setVisible(true);
						courseWiseSearch.setVisible(false);
						sessionWiseSearch.down('#moreDetailId').collapse();
						sessionWiseSearch.down('#academyLocationId').setValue(academyLocationId);
						if(wheatherSchool) {
							sessionWiseSearch.down("#sessionWiseAttendanceSummaryProgramId").setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
						} else {
							sessionWiseSearch.down("#sessionWiseAttendanceSummaryProgramId").setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
						}
						var academicTerm = sessionWiseSearch.down('#sessionWiseAttendanceSummaryAcademicTermId');
						var studentField = sessionWiseSearch.down('#sessionWiseAttendanceSummaryStudentNameId');
						var programGroupField = sessionWiseSearch.down('#sessionWiseAttendanceSummaryProgramGroupId');
						var programBatchPeriodFeild = sessionWiseSearch.down('#sessionWiseAttendanceSummaryProgramId');
						var attendancePercentageFromField = sessionWiseSearch.down('#attendancePercentageFromSessionId');
						var attendancePercentageToFeild = sessionWiseSearch.down('#minAbsentPercentageSessionId');
						var absentAboveNumberOfSessionsFeild = sessionWiseSearch.down('#absentAboveNumberOfSessions');
						var minAbsentPercentageFeild = sessionWiseSearch.down('#minAbsentPercentageSessionId');
						var startDateField = sessionWiseSearch.down('#startDate');
						var endDateField = sessionWiseSearch.down('#tillDate');

						academicTerm.reset();
						studentField.reset();
						programBatchPeriodFeild.reset();
						attendancePercentageFromField.reset();
						attendancePercentageToFeild.reset();
						absentAboveNumberOfSessionsFeild.setValue(0);
						minAbsentPercentageFeild.setValue(0);
						startDateField.reset();
						endDateField.reset();

						var academicTermStore = academicTerm.getStore();
						academicTermStore.load({
				 			callback: function(rec, success) {
				 				if (success) {
				 					for(var i in rec){
				 						if(rec[i].get('whetherCurrentAcademicTerm')){
				 							sessionWiseSearch.down('#sessionWiseAttendanceSummaryAcademicTermId').setValue(rec[i].get('id'));
				 							var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				 							var studentStore = studentField.getStore();
				 							studentStore.getProxy().api.read=submitURL;
				 							studentStore.getProxy().extraParams = {
				 								academyLocationIds : academyLocationId,
				 								facultyId : facultyId
				 							};
				 							studentStore.load();

				 							var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				 							programByAcademyLocationStore.getProxy().extraParams = {
				 								academyLocationIds:academyLocationId,
				 								facultyId:facultyId,
				 								onlyCurrentRecords:false,
				 								wheatherSchool:wheatherSchool
				 							};
				 							programByAcademyLocationStore.load();
				 						}
				 					}
				 				}
				 			}
				 		});

						var sessionItemId=sessionWiseSearch.down('#sessionWiseSessionItemId');
						sessionItemId.reset();
						var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
						var sessionNumber=attendanceTypess.data.MULTIPLE_SESSION.sessionNo;
						var storeArray = [];
						var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
						multipleSessionStore.getProxy().extraParams = {
							type:"multipleSession"
						};
						multipleSessionStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for (s=1;s<=sessionNumber;s++) {
										if(multipleSessionStore.find("code",s)>=0){
											storeArray.push({
												'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
												'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
											});
										} else {
											storeArray.push({'val':s,
												'code': s});
										}
									}
								}
								var store1 = Ext.create('Ext.data.Store', {
									fields: ['val','code'],
									data : storeArray
								});
								var l = Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]').length-1;
								Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].bindStore(store1);
								if(storeArray.length>0)
								{
									Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].setValue(1);
								}
							}
						});

					}
				},
				setCurrentAcademyLocationOnSummaryReport : function(form){
					var this$ = this;
					var academyLocationIds;
					var accessibleLocations = new Array();
					var aLId = this$.getCurrentAcademyLocation();
					var store = form.down('#academyLocationId').getStore();
					store.load({
						callback: function(records, operation, success) {
							for(var i=0; i<records.length; i++){
								if(records[i].get('id')==aLId){
									this$.getAttendancesummaryreportstructureforfaculty().down('#selectedAcademyLocationId').setValue(records[i].get('id'));
								}
								accessibleLocations.push(records[i].get('id'));
							}
						}
					});
				},
				academicTermChange: function(form,academicTermId){
					var this$ = this;
					var attendancesearchstrucure =  this$.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var studentField = '';
					var programGroupField = '';
					var programBatchPeriodFeild = '';
					if(attendanceType == 'COMPLETE_DAY') {
						programGroupField = form.down('#attendanceSummaryProgramGroupItemId');
						studentField = form.down('#attendanceSummaryStudentId');
						programBatchPeriodFeild = form.down('#attendanceSummaryProgramId');
					} else {
						programGroupField = form.down('#sessionWiseAttendanceSummaryProgramGroupId');
						studentField = form.down('#sessionWiseAttendanceSummaryStudentNameId');
						programBatchPeriodFeild = form.down('#sessionWiseAttendanceSummaryProgramId');
					}
					var academyLocationId = form.down('#academyLocationId').getValue();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');

					studentField.reset();
					programBatchPeriodFeild.reset();

					var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
					var studentStore = studentField.getStore();
					studentStore.getProxy().api.read=submitURL;
					studentStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						facultyId : facultyId,
						academicTermId:academicTermId
					};
					studentStore.load();

					var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
					programByAcademyLocationStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:false,
						academicTermId:academicTermId,
						wheatherSchool:wheatherSchool
					};
					programByAcademyLocationStore.load();

				},
				programGroupChange: function(form,programGroupId){
					var this$ = this;
					var attendancesearchstrucure =  this$.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var studentField = '';
					var academicTermField = '';
					var programBatchPeriodFeild = '';
					if(attendanceType == 'COMPLETE_DAY') {
						academicTermField = form.down('#attendanceSummaryAcademicTermId');
						studentField = form.down('#attendanceSummaryStudentId');
						programBatchPeriodFeild = form.down('#attendanceSummaryProgramId');
					} else {
						academicTermField = form.down('#sessionWiseAttendanceSummaryAcademicTermId');
						studentField = form.down('#sessionWiseAttendanceSummaryStudentNameId');
						programBatchPeriodFeild = form.down('#sessionWiseAttendanceSummaryProgramId');
					}
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');

					var academicTermId = academicTermField.getValue();
					var studentId = studentField.getValue();

					programBatchPeriodFeild.reset();
					var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
					programByAcademyLocationStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:false,
						academicTermId:academicTermId,
						studentId:studentId,
						programGroupId:programGroupId,
						wheatherSchool:wheatherSchool
					};
					programByAcademyLocationStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length > 0 && records.length == 1){
									programBatchPeriodFeild.setValue(records[0].data.sectionId);
								}
							}
						}
					});

				},
				onStudentFieldChange: function(form,studentId){
					var this$ = this;
					var attendancesearchstrucure =  this$.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var programGroupField = '';
					var academicTermField = '';
					var programBatchPeriodFeild = '';
					if(attendanceType == 'COMPLETE_DAY') {
						academicTermField = form.down('#attendanceSummaryAcademicTermId');
						programGroupField = form.down('#attendanceSummaryProgramGroupItemId');
						programBatchPeriodFeild = form.down('#attendanceSummaryProgramId');
					} else {
						academicTermField = form.down('#sessionWiseAttendanceSummaryAcademicTermId');
						programGroupField = form.down('#sessionWiseAttendanceSummaryProgramGroupId');
						programBatchPeriodFeild = form.down('#sessionWiseAttendanceSummaryProgramId');
					}
					var academyLocationId = form.down('#academyLocationId').getValue();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var academicTermId = academicTermField.getValue();
					programBatchPeriodFeild.reset();

					var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
					programByAcademyLocationStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:false,
						academicTermId:academicTermId,
						studentId:studentId,
						wheatherSchool:wheatherSchool
					};
					programByAcademyLocationStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length > 0){
									programBatchPeriodFeild.setValue(records[0].data.sectionId);
								}
							}
						}
					});
				},
				loadStudentAttendanceSummaryReport: function(attendanceType){
					var this$=this;
					var grid = this.getStudentattendancesummarygridforfaculty();
					grid.setVisible(true);
					var store = grid.getStore();
					var sessionNo = null;
					if(attendanceType == 'COMPLETE_DAY') {
						var form = this$.getCompletedaystudentattendancesummarysearch();
						var academyLocationField = form.down('#academyLocationId');
						var academicTermField = form.down('#attendanceSummaryAcademicTermId');
						var studentField = form.down('#attendanceSummaryStudentId');
						var programBatchPeriodFeild = form.down('#attendanceSummaryProgramId');
						var startDateField = form.down('#startDate');
						var endDateField = form.down('#tillDate');
						var minAbsentPercentage = form.down('#minAbsentPercentageId').getValue();
						var attendancePercentageFrom = form.down('#attendancePercentageFromId').getValue();
						if(isNullOrEmpty(attendancePercentageFrom)){
							attendancePercentageFrom=0;
						}
						var attendancePercentageTo = form.down('#attendancePercentageToId').getValue();
						if(isNullOrEmpty(attendancePercentageTo) || attendancePercentageTo == 0){
							attendancePercentageTo=100;
						}
						var absentAboveNumberOfSessions = form.down('#absentAboveNumberOfSessions').getValue();
						var activeStatus = form.down('#statusComboItemId').getValue();
					} else {
						var form = this$.getSessionwisestudentattendancesummarysearch();
						var academyLocationField = form.down('#academyLocationId');
						var academicTermField = form.down('#sessionWiseAttendanceSummaryAcademicTermId');
						var studentField = form.down('#sessionWiseAttendanceSummaryStudentNameId');
						var programGroupField = form.down('#sessionWiseAttendanceSummaryProgramGroupId');
						var programBatchPeriodFeild = form.down('#sessionWiseAttendanceSummaryProgramId');
						var startDateField = form.down('#startDate');
						var endDateField = form.down('#tillDate');
						var sessionNoField = form.down('#sessionWiseSessionItemId');
						var attendancePercentageFrom = form.down('#attendancePercentageFromSessionId').getValue();
						if(isNullOrEmpty(attendancePercentageFrom)){
							attendancePercentageFrom=0;
						}
						var attendancePercentageTo = form.down('#attendancePercentageToSessionId').getValue();
						if(isNullOrEmpty(attendancePercentageTo) || attendancePercentageTo == 0){
							attendancePercentageTo=100;
						}
						var absentAboveNumberOfSessions = form.down('#absentAboveNumberOfSessions').getValue();
						var activeStatus = form.down('#statusComboItemId').getValue();
						sessionNo = sessionNoField.getValue();
					}
					var academyLocationId = academyLocationField.getValue();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var academicTermId = academicTermField.getValue();
					var studentId = studentField.getValue();
					var programBatchPeriodSectionId =  programBatchPeriodFeild.getValue();
					var startDate =Ext.Date.format(startDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
					var endDate = Ext.Date.format(endDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					store.getProxy().extraParams = {
						sectionId:programBatchPeriodSectionId,
						facultyId:facultyId,
						startDate:startDate,
						endDate:endDate,
						attendanceType:attendanceType,
						academicTermId:academicTermId,
						studentId:studentId,
						activeStatus: activeStatus,
						sessionNo:sessionNo,
						academyLocationId:academyLocationId,
						minAbsentPercentage:minAbsentPercentage,
						attendancePercentageFrom : attendancePercentageFrom,
						attendancePercentageTo : attendancePercentageTo,
						absentAboveNumberOfSessions:absentAboveNumberOfSessions
					};
					Ext.getBody().unmask();
					this.resetPageSetting(store, grid);
					store.load();
				},
				/**
				 * show attendance summury report on click of hyper link 
				 */
				attendanceSummayDataAccordingAttendanceStatus:function(record,status){
					var $this =this;
					var formWindow = $this.getAttendancedatastatus();
					if (!formWindow) {
						Ext.widget('attendancedatastatus');
						formWindow = $this.getAttendancedatastatus();
					}
					formWindow.show();
					$this.loadAttendanceDateStatusData(record,status);
				},

				loadAttendanceDateStatusData:function(record,statusData){
					var $this = this;
					var attendancesearchstrucure =  $this.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var form = $this.getCompletedaystudentattendancesummarysearch();
					var grid = $this.getAttendancedatastatusgrid();
					
					var attendancedatastatusdetails=$this.getAttendancedatastatusdetails();
					attendancedatastatusdetails.down('#admissionCodeItemId').setValue(record.data.admissionCode);
					attendancedatastatusdetails.down('#studentCodeItemId').setValue(record.data.studentCode);
					attendancedatastatusdetails.down('#studentNameItemId').setValue(record.data.studentName);
					attendancedatastatusdetails.down('#programNameItemId').setVisible(false);
					attendancedatastatusdetails.down('#batchNameItemId').setVisible(false);
					attendancedatastatusdetails.down('#periodItemId').setVisible(false);
					
					var store = grid.getStore();
					var admissionId = record.data.admissionId;
					var studentId = record.data.studentId;
					var activeStatus = record.data.activeStatus;
					var sectionId = record.data.sectionId;
					var sessionNo = null;
					var courseVariantId = null;
					if(attendanceType == "COURSE_LEVEL"){
						form = $this.getCourselevelstudentattendancesummarysearch();
						grid.columns[0].show();
						grid.columns[1].hide();
						grid.columns[2].show();
						grid.columns[4].show();
						grid.columns[6].hide();
						courseVariantId=record.data.courseVariantId;
						admissionId = null;
					}else if (attendanceType == "COMPLETE_DAY"){
						grid.columns[0].hide();
						grid.columns[1].show();
						grid.columns[2].hide();
						grid.columns[4].hide();
						grid.columns[6].hide();
					} else {
						form = $this.getSessionwisestudentattendancesummarysearch();
						grid.columns[0].hide();
						grid.columns[1].show();
						grid.columns[2].hide();
						grid.columns[4].hide();
						grid.columns[6].show();
						sessionNo = form.down('#sessionWiseSessionItemId').getValue();
					}

					var status; 
					if(!isNullOrEmpty(statusData)){
						status = statusData;
					}else{
						status =null;
					}

					var sd = form.down('#startDate').getValue();
					var td = form.down('#tillDate').getValue();
					var startDate = null;
					var endDate = null;
					if(!isNullOrEmpty(sd)){
						startDate = Ext.Date.format(new Date(sd), 'Y-m-d');
					}
					if(!isNullOrEmpty(td)){
						endDate = Ext.Date.format(new Date(td), 'Y-m-d');
					}

					store.getProxy().extraParams = {
						sectionId: sectionId,
						studentId:studentId,
						activeStatus: activeStatus,
						attendanceType:attendanceType,
						attendanceStatus:status,
						startDate:startDate,
						endDate:endDate,
						sessionNo:sessionNo,
						courseVariantId:courseVariantId,
						admissionId:admissionId
					};
					this.resetPageSetting(store, grid);
					store.load();

				},
				disableMoreActionPivileges: function(gridReference, permissionsMap) {
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					buttonsToolBar = gridReference.query('toolbar')[0];
					var sendSurveyBtn = gridReference.down('#sendSurveyBtn');
					var exportReport = gridReference.down('#exportReport');
					var sendMessageBtn = gridReference.down('#summarySendMessageBtn');

					sendSurveyBtn.setVisible(false);
					sendMessageBtn.setVisible(false);
					exportReport.setVisible(false);		
					var completeDayPer = false;
					var programWiseOnly = false;
					Ext.each(permissionList, function(privilege) {

						if (privilege === 'SENDSURVEY') {
							var button = buttonsToolBar.query('#sendSurveyBtn')[0];
							if(!isNullOrEmpty(button)){
								sendSurveyBtn.setVisible(true);
							}        	
						} else if (privilege === 'ATTENDANCE_REGISTER' || 
								privilege === 'ATTENDANCE_REGISTER_BLANK' ||
								privilege === 'PROGRAM_AND_COURSE_WISE_REPORT') {
							var button = buttonsToolBar.query('#exportReport')[0];
							if(privilege === 'ATTENDANCE_REGISTER' || privilege === 'ATTENDANCE_REGISTER_BLANK'){
								programWiseOnly = true;
							}
							if(!isNullOrEmpty(button)){
								exportReport.setVisible(true);
							}        	
						} else if (privilege === 'SENDMESSAGE') {
							var button = buttonsToolBar.query('#summarySendMessageBtn')[0];
							if(!isNullOrEmpty(button)){
								sendMessageBtn.setVisible(true);
							}        	
						} else if(privilege === 'COMPLETE_DAY'){
							completeDayPer = true;
						} else if(privilege === 'PROGRAM_WISE'){
							completeDayPer = true;
						}
					});
					if(!completeDayPer && !programWiseOnly){
						exportReport.setVisible(false);
					}
				},
				openStudentSendMessage:function(grid){
					if(grid.getSelectionModel().getCount()>0) {
						var recipientIds = [];
						Ext.each(grid.getSelectionModel().getSelection(), function(currentSelectedRecord){
							recipientIds.push(currentSelectedRecord.get('admissionId'));
						});

						var $this=this;
						var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
						var structure = Ext.widget('attendancereportstudentsendmessages',{
							itemId:'studentListSendMessageWindows'
						});
						var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
						/**
						 * This is to remove tab from content panel and open same tab again
						 */
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getTab=getcontroller.getTab(tabName);
						if(getTab!=null){
							contentPanel.remove(getTab, true);
						}
						var formWindowTab = $this.getAttendancereportstudentsendmessages();
						formWindowTab.down("#selectTemplate").allowBlank=true;
						formWindowTab.down("#selectTemplate").setVisible(false);
						formWindowTab.down("#messageName").allowBlank=true;   
						formWindowTab.down("#messageName").setVisible(false);
						formWindowTab.down("#recipientFieldARItemId").bindStore(grid.getStore());
						formWindowTab.down("#recipientFieldARItemId").setValue(recipientIds);
						var templateStore = formWindowTab.down('#selectTemplate').getStore();
						templateStore.getProxy().extraParams={
							msgRecipientTypeId:2
						};
						templateStore.load();

						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							method : "GET",
							type : 'rest',
							url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
							headers : {
								'Content-Type' : 'application/json'
							},
							success : function(form,action) {
								var data = Ext.JSON.decode(form.responseText);
								formWindowTab.down("#id").setValue(data.id);
								formWindowTab.down("#code").setValue(data.code);
								formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
								formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
								formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
								Ext.getBody().unmask();
							}

						});
						openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);

					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				},
				sendSurveyDetails:function(obj) {
					var $this = this;
					var grid = $this.getStudentattendancesummarygridforfaculty();		
					var form = $this.getAttendanceSendSurvey().getForm();
					var surveyId = form.findField('survey').getValue();

					var jsonData = [];
					var selected = grid.getSelectionModel().getSelection();
					if( selected.length > 0){
						for( var i = 0; i < selected.length; i++) {
							jsonData.push({
								"surveyMaster" : $this.getIdValueJson(surveyId),
								"applicant": null,
								"student": $this.getIdValueJson(selected[i].data.studentId),
								"enquiry": null,
								"user": null,
								"userType": "STUDENT"
							});
						}
					}
					submitUrl = SERVERURL.SEND_SURVEY;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : jsonData,
						method : 'POST',
						success : function(form, action) {
							showSuccessMessage(getCommonTranslation('SEND_SURVEY'), getCommonTranslation('SUCCESS'));
							grid.getStore().reload();
							obj.up('window').close();
						}
					});
				},
				exportXlsStudentAttendance : function() {
					var $this = this;
					var exportType = $this.getAttendanceregisterwindow().down("#exportType");
					var reportTitle = "Student Register Report";
					var code = 'STUDENT_ATTENDANCE_REPORT_REGISTER';
					var attendanceType  = $this.getAttendancesummaryreportstructureforfaculty().down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var reportParams = new Object();
					var reportType=exportType.getValue();
					if((attendanceType=='COMPLETE_DAY' || attendanceType=='MULTIPLE_SESSION') && reportType=='REPORT'){
						code = 'STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER';
					}
					else if((attendanceType=='COMPLETE_DAY' || attendanceType=='MULTIPLE_SESSION') && reportType=='BLANK'){
						code = 'STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER_BLANK';
					}else if(attendanceType == "COURSE_LEVEL" && reportType=='ATTENDANCE_REGISTER_REPORT_EXCEL' ){
						 var form = $this.getCourselevelstudentattendancesummarysearch().getForm();
						 code = 'ATTENDANCE_REGISTER_REPORT_EXCEL';
					}/*else if(attendanceType == "COURSE_LEVEL" && reportType=='ATTENDANCE_REGISTER_REPORT_EXCEL'){
						 var form = $this.getCoursesearchattendancesectiongroup().getForm();
						 code = 'ATTENDANCE_REGISTER_REPORT_EXCEL';
					}*/else if(attendanceType == "COURSE_LEVEL" && reportType=='ATTENDANCE_REGISTER_REPORT_PDF'){
						 var form = $this.getCourselevelstudentattendancesummarysearch().getForm()
						 code = 'ATTENDANCE_REGISTER_REPORT_PDF';
					}/*else if(attendanceType == "COURSE_LEVEL" && reportType=='ATTENDANCE_REGISTER_REPORT_PDF'){
						 var form = $this.getCoursesearchattendancesectiongroup().getForm();
						 code = 'ATTENDANCE_REGISTER_REPORT_PDF';
					}*/
					
					if(attendanceType=='COMPLETE_DAY'){
						var form = $this.getCompletedaystudentattendancesummarysearch().getForm();
						var values = form.getValues();
						var sectionId = values.attendanceSummaryProgram;
						sectionData = form.findField('attendanceSummaryProgram').getStore().findRecord('sectionId', sectionId).data;
						reportParams.programId = sectionData.programId;
						reportParams.batchId = sectionData.batchId;
						reportParams.periodId = sectionData.periodId;
						reportParams.sectionId = sectionId;
						reportParams.studentId = values.attendanceSummaryStudent;
					} else if(attendanceType=='MULTIPLE_SESSION'){
						var form = $this.getSessionwisestudentattendancesummarysearch().getForm();
						var values = form.getValues();
						var sectionId = values.sessionWiseAttendanceSummaryProgram;
						sectionData = form.findField('sessionWiseAttendanceSummaryProgram').getStore().findRecord('sectionId', sectionId).data;
						reportParams.programId = sectionData.programId;
						reportParams.batchId = sectionData.batchId;
						reportParams.periodId = sectionData.periodId;
						reportParams.sectionId = sectionId;
						reportParams.studentId = values.sessionWiseAttendanceSummaryStudentName;
						reportParams.sessionNo = values.sessionNo1;
					} else {
						var form = $this.getCourselevelstudentattendancesummarysearch().getForm();
						var values = form.getValues();
						reportParams.courseVariantId = values.courseAttendanceSummaryCourseVariant;
					}
					reportParams.code = code;
					reportParams.reportTitle = reportTitle;
					reportParams.startDate = values.startDate;
					reportParams.endDate = values.tillDate;
					reportParams.activeStatus = values.STATUS;
					reportParams.exportType = exportType.getValue();
					reportParams.attendanceType = attendanceType;
					reportParams.minAbsentPercentage = values.minAbsentPercentage;
					reportParams.minPresentPercentage = values.minPresentPercentage;
					reportParams.academyLocationId = values.academyLocation;
					reportParams.headerName = getProgramandcourseTranslation('STUDENT_REGISTER_REPORT');
					if(reportType=="ATTENDANCE_REGISTER_REPORT_PDF")
						$this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.STUDENT_ATTENDANCE_EXPORT_PDF);
						else
					$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.STUDENT_ATTENDANCE_EXPORT);
					$this.getAttendanceregisterwindow().close();
				},
				attReportExportBtnDisableEnable: function() {
					var $this = this;
					var form = '';
					var structure  = $this.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = structure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var sectionId = '';
					var values = '';
					var exportReport = $this.getStudentattendancesummarygridforfaculty().down("#exportReport");
					exportReport.setDisabled(true);
					if(attendanceType == 'COMPLETE_DAY'){
						form = $this.getCompletedaystudentattendancesummarysearch().getForm();
						values = form.getValues();
						sectionId = values.attendanceSummaryProgram;
					} else if(attendanceType == 'COURSE_LEVEL') {
						form = $this.getCourselevelstudentattendancesummarysearch().getForm();
						values = form.getValues();
						courseVariantId = values.courseAttendanceSummaryCourseVariant;
						exportReport = $this.getStudentcourseattendancesummarygridforfaculty().down("#exportReport");
					} else {
						form = $this.getSessionwisestudentattendancesummarysearch().getForm();
						values = form.getValues();
						sectionId = values.sessionWiseAttendanceSummaryProgram;
					} 
					var sectionType =values.sectionType;
					var isCompleteDayOrSession = false;
					var isCourseLevel =  false;
					if(attendanceType == "COMPLETE_DAY" || attendanceType == "MULTIPLE_SESSION"){
						isCompleteDayOrSession = true;
					}
					if(attendanceType == "COURSE_LEVEL"){
						isCourseLevel = true;		
					}
					if(form.isValid()) {
						if((!isNullOrEmpty(values.startDate) || values.startDate != "") && (!isNullOrEmpty(values.tillDate) || values.tillDate != "")){
							if(isCompleteDayOrSession && !isNullOrEmpty(sectionId) && sectionId != ""){
								exportReport.setDisabled(false);
							}
							if(isCourseLevel){
								if((!isNullOrEmpty(courseVariantId) && courseVariantId != "")){
									exportReport.setDisabled(false);
								}
							}
						}else{
							exportReport.setDisabled(true);
						}
					}
				},
				openAttendanceRegisterWin : function(){
					var window = this.getAttendanceregisterwindow();
					var $this = this;
					var structure  = $this.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = structure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;

					if(!window){
						window = Ext.widget('attendanceregisterwindow');
					}
					window.show();
					var portalId = this.getCurrentLoggedPortalId();
					var academyLocationId = this.getCompletedaystudentattendancesummarysearch().down("#academyLocationId").getValue();
					if(attendanceType == 'COURSE_LEVEL') {
						academyLocationId = this.getCourselevelstudentattendancesummarysearch().down("#academyLocationId").getValue();
					}
					if(attendanceType == 'MULTIPLE_SESSION') {
						academyLocationId = this.getSessionwisestudentattendancesummarysearch().down("#academyLocationId").getValue();
					}
					var permissionsMap = new Ext.util.HashMap();
					permissionsMap= this.getFACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES();
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(academyLocationId);
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

					var store = window.down('#exportType').getStore();
					if(!Ext.Array.contains(attendanceTypeSettings, 'COURSE_LEVEL')
							|| attendanceType != "COMPLETE_DAY" || !Ext.Array.contains(permissionList, 'PROGRAM_AND_COURSE_WISE_REPORT')){
						var recIndex = store.find('id','PROGRAM_AND_COURSE');
						store.removeAt(recIndex);
					}else if(attendanceType === "COMPLETE_DAY" && (Ext.Array.contains(permissionList, 'PROGRAM_AND_COURSE_WISE_REPORT'))){
						store.add({
							'id':'PROGRAM_AND_COURSE',
							'name':'programAndCourse',
							'value':getProgramandcourseTranslation('PROGRAM_AND_COURSE_WISE_REPORT')
						});
					}
					if((!Ext.Array.contains(permissionList, 'ATTENDANCE_REGISTER'))){
						var recIndex = store.find('id','REPORT');
						store.removeAt(recIndex);
					}

					if((!Ext.Array.contains(permissionList, 'ATTENDANCE_REGISTER_BLANK'))){
						var recIndex = store.find('id','BLANK');
						store.removeAt(recIndex);
					}else{
						window.down('#exportType').setValue('BLANK');
					}
					if(store.find('id','COURSEWISE_ATTENDANCE_REPORT')){
						var recIndex = store.find('id','COURSEWISE_ATTENDANCE_REPORT');
						store.removeAt(recIndex);
					}
					
					if(store.find('id','COURSEWISE_ATTENDANCE_REPORT_OF_SECTION_GROUP')){
						var recIndex = store.find('id','COURSEWISE_ATTENDANCE_REPORT_OF_SECTION_GROUP');
						store.removeAt(recIndex);
					}
					if(attendanceType == 'COURSE_LEVEL') {
					var store1 = Ext.create('Academia.store.personinfo.student.ChedExportTypeStore');
					//window.down('#exportType').bindStore(store1);
					store1.getProxy().extraParams={
				    	academyLocationId:academyLocationId,
				    	reportType:'Basic Reports'
					};
					
					store1.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length>0){
									   Ext.each(records, function(record) {
											if(record.get('value')=='ATTENDANCE_REGISTER_REPORT_EXCEL' ){
												store.add({
													 'id':'ATTENDANCE_REGISTER_REPORT_EXCEL',
													 'name':'Attendance_Register_Blank_Excel',
													 'value':getProgramandcourseTranslation('ATTENDANCE_REGISTER_BLANK_EXCEL')
												 });
											
											}else if(record.get('value')=='ATTENDANCE_REGISTER_REPORT_PDF'){
												store.add({
													 'id':'ATTENDANCE_REGISTER_REPORT_PDF',
													 'name':'ATTENDANCE_REGISTER_REPORT_PDF',
													 'value':getProgramandcourseTranslation('ATTENDANCE_REGISTER_BLANK_PDF')
												 });
												
											}

										});
								   }
							   }
						   }
					   });
					}
					
				},
				resetAttendanceSummarySearchForm:function(form){
					var this$ = this;
					var attendancesearchstrucure =  this$.getAttendancesummaryreportstructureforfaculty();
					var attendanceType = attendancesearchstrucure.down('#studentAttendanceTypeRadioField').getValue().summaryAttendanceType;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(attendanceType == 'COMPLETE_DAY') {
						var academyLocationId = form.down('#academyLocationId').getValue();
						var academicTerm = form.down('#attendanceSummaryAcademicTermId');
						var studentField = form.down('#attendanceSummaryStudentId');
						var programGroupField = form.down('#attendanceSummaryProgramGroupItemId');
						var programBatchPeriodFeild = form.down('#attendanceSummaryProgramId');
						
						var academicTermStore = academicTerm.getStore();
						academicTermStore.load({
				 			callback: function(rec, success) {
				 				if (success) {
				 					for(var i in rec){
				 						if(rec[i].get('whetherCurrentAcademicTerm')){
				 							attendancesearchstrucure.down('#attendanceSummaryAcademicTermId').setValue(rec[i].get('id'));
				 							var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				 							var studentStore = studentField.getStore();
				 							studentStore.getProxy().api.read=submitURL;
				 							studentStore.getProxy().extraParams = {
				 								academyLocationIds : academyLocationId,
				 								facultyId : facultyId,
				 								academicTermId : rec[i].get('id')
				 							};
				 							studentStore.load();

				 							var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				 							programByAcademyLocationStore.getProxy().extraParams = {
				 								academyLocationIds:academyLocationId,
				 								facultyId:facultyId,
				 								onlyCurrentRecords:false,
				 								wheatherSchool:wheatherSchool,
				 								academicTermId : rec[i].get('id')
				 							};
				 							programByAcademyLocationStore.load();
				 						}
				 					}
				 				}
				 			}
				 		});
					} else {
						var academicTerm = form.down('#sessionWiseAttendanceSummaryAcademicTermId');
						var studentField = form.down('#sessionWiseAttendanceSummaryStudentNameId');
						var programGroupField = form.down('#sessionWiseAttendanceSummaryProgramGroupId');
						var programBatchPeriodFeild = form.down('#sessionWiseAttendanceSummaryProgramId');
						var academyLocationId = form.down('#academyLocationId').getValue();
						var sessionItemId=form.down('#sessionWiseSessionItemId');
						sessionItemId.reset();
						var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
						var sessionNumber=attendanceTypess.data.MULTIPLE_SESSION.sessionNo;
						var storeArray = [];
						var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
						multipleSessionStore.getProxy().extraParams = {
							type:"multipleSession"
						};
						
						var academicTermStore = academicTerm.getStore();
						academicTermStore.load({
				 			callback: function(rec, success) {
				 				if (success) {
				 					for(var i in rec){
				 						if(rec[i].get('whetherCurrentAcademicTerm')){
				 							attendancesearchstrucure.down('#sessionWiseAttendanceSummaryAcademicTermId').setValue(rec[i].get('id'));
				 							var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				 							var studentStore = studentField.getStore();
				 							studentStore.getProxy().api.read=submitURL;
				 							studentStore.getProxy().extraParams = {
				 								academyLocationIds : academyLocationId,
				 								facultyId : facultyId,
				 								academicTermId : rec[i].get('id')
				 							};
				 							studentStore.load();

				 							var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				 							programByAcademyLocationStore.getProxy().extraParams = {
				 								academyLocationIds:academyLocationId,
				 								facultyId:facultyId,
				 								onlyCurrentRecords:false,
				 								wheatherSchool:wheatherSchool,
				 								academicTermId : rec[i].get('id')
				 							};
				 							programByAcademyLocationStore.load();
				 						}
				 					}
				 				}
				 			}
				 		});
						
						multipleSessionStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for (s=1;s<=sessionNumber;s++) {
										if(multipleSessionStore.find("code",s)>=0){
											storeArray.push({
												'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
												'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
											});
										} else {
											storeArray.push({'val':s,
												'code': s});
										}
									}
								}
								var store1 = Ext.create('Ext.data.Store', {
									fields: ['val','code'],
									data : storeArray
								});
								var l = Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]').length-1;
								Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].bindStore(store1);
								if(storeArray.length>0)
								{
									Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].setValue(1);
								}
							}
						});
					}
					if(wheatherSchool) {
						programBatchPeriodFeild.setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
					} else {
						programBatchPeriodFeild.setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
					}
					var academyLocation = form.down('#academyLocationId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#tillDate');
					form.down('#absentAboveNumberOfSessions').setValue(0);
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var grid = this.getStudentattendancesummarygridforfaculty();
					var store = grid.getStore();
					academicTerm.reset();
					studentField.reset();
					programBatchPeriodFeild.reset();
					startDateField.reset();
					endDateField.reset();
					startDateField.setMinValue(false);
					startDateField.setMaxValue(false);
					endDateField.setMinValue(false);
					endDateField.setMaxValue(false);
					var academyLocationId = academyLocation.getValue();
					
					/**
					 * No need to reset academyLocation
					 * otherwise we have to reset the selected attendance type radio button also
					 */
					//this.setCurrentAcademyLocationOnSummaryReport(form);
					
					store.removeAll();
					grid.down('#exportReport').setDisabled(true);
					grid.getStore().removeAll();
					try{
						grid.down('custompagingtoolbar').hide();
					}catch(e){
					}

				},
				selectSectionMessageType : function(val,nV,oV){

					var $this =  this;
					var formWin = $this.getAttendancereportstudentsendmessages();

					//var value = nV.1;
					if(nV.messageType==2){
						formWin.down("#messageId").hide();
						formWin.down("#selectTemplate").allowBlank=true;
						formWin.down("#selectTemplate").setVisible(false);     		 
						formWin.down("#messageName").allowBlank=true;   
						formWin.down("#messageName").setVisible(false);
						formWin.down("#msgTempletId").setVisible(true);
						formWin.down("#msgTempletId").allowBlank=false;
						formWin.down("#msgTempletId").reset();
						formWin.down("#subject").setVisible(true);
						formWin.down("#subject").allowBlank=false;
						formWin.down("#subject").reset();
						formWin.down("#discriptionId").setVisible(true);
						formWin.down("#discriptionId").reset();
						formWin.down('#smsDiscription').reset();
						formWin.down('#smsDiscription').hide();
						formWin.down('#smsDiscriptionNotice').hide();
					}else{
						formWin.down("#msgTempletId").allowBlank=true;
						formWin.down("#msgTempletId").setVisible(false);     		
						formWin.down("#messageId").setVisible(true);
						formWin.down("#selectTemplate").setVisible(true);     		
						formWin.down("#messageName").setVisible(true);
						formWin.down("#messageName").reset();
						formWin.down("#subject").allowBlank=true;
						formWin.down("#subject").setVisible(false);
						formWin.down("#discriptionId").setVisible(false);
						formWin.down("#messageName").allowBlank=false;  
						formWin.down("#selectTemplate").allowBlank=false;
						formWin.down("#selectTemplate").reset();
						formWin.down("#attendanceReportStudentDocumentMessageAttachmentGrid").setVisible(false);
						formWin.down("#staticUploadFileField").setVisible(false);
						formWin.down('#smsDiscription').reset();
						formWin.down('#smsDiscription').hide();
						formWin.down('#smsDiscriptionNotice').hide();
						var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
						formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
						formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
					}
				},
				selectMessageTemp: function(obj,rec){
					var $this =  this;
					var formWin = $this.getAttendancereportstudentsendmessages();
					if(rec[0].data.value == "SMS")
					{
						formWin.down("#subject").allowBlank=true;
						formWin.down("#subject").hide();
						formWin.down("#staticUploadFileField").hide();
						formWin.down("#attendanceReportStudentDocumentMessageAttachmentGrid").hide();
						formWin.down('#discriptionId').reset();
						formWin.down('#discriptionId').hide();	       		 
						formWin.down('#subject').reset();
						formWin.down('#smsDiscription').show();
						formWin.down('#smsDiscriptionNotice').show();
					}else
					{
						formWin.down('#discriptionId').reset();
						formWin.down('#smsDiscription').reset();
						formWin.down('#smsDiscription').hide();
						formWin.down('#smsDiscriptionNotice').hide();
						formWin.down("#staticUploadFileField").show();
						// formWin.down("#staticDocumentMessageAttachmentGrid").show();
						formWin.down("#attendanceReportStudentDocumentMessageAttachmentGrid").show()
						formWin.down("#subject").show();
						formWin.down("#subject").allowBlank=false;
						formWin.down('#discriptionId').show();    		
					}
				},
				uploadStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
					var this$ = this;
					var setupForm = fileField.up('attendancereportstudentsendmessages');
					var grid = setupForm.down('#attendancereportstudentstaticdocumentattachmentgridmessage');
					fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
					fileField.setRawValue(fileUploadPath);
					var file = fileField.fileInputEl.dom.files[0];
					if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
						if(!isNullOrEmpty(fileUploadPath)){
							var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
							if (this$.isValidFileExtensionForMessaging(extension)) {
								var entityId = 'student';
								var module = 'messaging';
								var entityType = 'template';
								var documentType = 'DOCUMENT';
								var isTransient = true;
								var this$ = this;
								this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
									if(success){
										var path = Ext.JSON.decode(action.response.responseText).path;
										var user = this$.getCurrentlyLoggedInUser();
										var store = grid.getStore();
										var documentStatus = "SUBMITTED";
										var documentType = null;
										if(!isNullOrEmpty(path)){
											store.add({
												id: '',
												name: fileUploadPath,
												path: path ,
												createdBy : {
													id :user.id,
													value : user.value,
													code : user.code
												},
												status : documentStatus,
												documentType : documentType,
												templateConfigDocId: '',
												submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

											});
											this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
											showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
										}

										fileField.reset();
									}

								}, isTransient);
							}else{
								fileField.reset();
								showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
							}
						}
					}else{
						fileField.reset();
						showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					}
				},
				loadGridWithFileNameMessage:function(grid,value,store){
					grid.bindStore(store);
				},
				deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
					var grid = view.up('#attendancereportstudentstaticdocumentattachmentgridmessage');
					var panel = this.getContentpanel().getActiveTab();
					var tabTitle = panel.title;
					var store = grid.getStore();
					var templateConfigDocId = record.get('templateConfigDocId');
					var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
					if(!(tabTitle == viewTitle)){
						if(!isNullOrEmpty(templateConfigDocId)){
							showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
								if (btn == 'yes') {
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.STATIC_DOC_DELETE,
										method: 'DELETE',
										params: {
											templateConfigDocId : templateConfigDocId
										},
										headers: {
											'Content-Type': 'application/json'
										},
										success: function(form, action) {
											store.remove(record);
											showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
										}
									});
								}
							});

						}else{
							store.remove(record);
							showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
						}
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
					}

				},
				loadStudentScheduleField : function(radio,newValue, oldValue){
					var adhocMessageForm = radio.up('form');
					var scheduleDateField = adhocMessageForm.down('#scheduleDate');
					var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
					var radioValue = radio.getValue().sendingPriority;

					if(radioValue=='IMMEDIATE'){
						scheduleDateField.setVisible(false);
						scheduleDateField.setDisabled(true);
						scheduleTimeField.setVisible(false);
						scheduleTimeField.setDisabled(true);    		
					}
					else if(radioValue=='SCHEDULE'){
						scheduleDateField.setVisible(true);
						scheduleDateField.setDisabled(false);
						scheduleTimeField.setVisible(true);
						scheduleTimeField.setDisabled(false);
					}
				},
				saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
					var submitUrl = '';
					var templateTab = this.getContentpanel();
					var formWin =  this.getAttendancereportstudentsendmessages();
					var form = formWin.down('#msgDetailsForm');
					var id = form.down('#document_hidden_field');
					if (isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
					}
					var data = new Object();
					if(!isNullOrEmpty(entityId)){
						data.entityId = entityId;
					}else{
						data.entityId = null;
					}
					if(!isNullOrEmpty(module)){
						data.module = module;
					}else{
						data.module = null;
					}
					if(!isNullOrEmpty(entityType)){
						data.entityType = entityType;
					}else{
						data.entityType = null;
					}
					form.getForm().setValues(data);
					form.getForm().submit({
						method : 'POST',
						url : submitUrl,
						success : function(form, action){
							callBackFunction(true, action, isTransient);

						}
					});
				},
				onChangeAcademicTermFilter : function(form,academicTermId){
					var this$ = this;
					var studentField = form.down('#courseAttendanceSummaryStudentNameId');
					var courseVariantField = form.down('#courseAttendanceSummaryCourseVariantId');
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId = this.getCurrentlyLoggedInUser().id;

					studentField.reset();
					courseVariantField.reset();

					var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
					var studentStore = studentField.getStore();
					studentStore.getProxy().api.read=submitURL;
					studentStore.getProxy().extraParams = {
						academyLocationIds: academyLocationId,
						facultyId: facultyId,
						academicTermId:academicTermId
					};
					studentStore.load();

					var courseVariantStore = courseVariantField.getStore();
					courseVariantStore.getProxy().extraParams = {
						academyLocationIds: academyLocationId,
						facultyId: facultyId,
						academicTermId:academicTermId,
						isCurrentPeriod:false
					};
					courseVariantStore.load();
				},
				onChangeStudentNameFilter : function(form,studentId){
					var this$ = this;
					var courseVariantField = form.down('#courseAttendanceSummaryCourseVariantId');
					var academicTermId = form.down('#courseAttendanceSummaryAcademicTermId').getValue();
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					courseVariantField.reset();
					var courseVariantStore = courseVariantField.getStore();
					courseVariantStore.getProxy().extraParams = {
						academyLocationIds: academyLocationId,
						facultyId: facultyId,
						academicTermId:academicTermId,
						isCurrentPeriod:false,
						studentId:studentId
					};
					courseVariantStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1) {
									courseVariantField.setValue(records[0].get('id'));
								}
							}
						}
					});
				},
				loadStudentCourseAttendanceSummaryReport: function(){
					var this$=this;
					var grid = this.getStudentcourseattendancesummarygridforfaculty();
					grid.setVisible(true);
					var store = grid.getStore();
					
					var form = this$.getCourselevelstudentattendancesummarysearch();
					
					var academyLocationField = form.down('#academyLocationId');
					var academicTermField = form.down('#courseAttendanceSummaryAcademicTermId');
					var studentField = form.down('#courseAttendanceSummaryStudentNameId');
					var courseVariantField = form.down('#courseAttendanceSummaryCourseVariantId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#tillDate');
					var minAbsentPercentage = form.down('#minAbsentPercentageCBSId').getValue();
					var attendancePercentageFrom = form.down('#attendancePercentageFromCBSId').getValue();
					if(isNullOrEmpty(attendancePercentageFrom)){
						attendancePercentageFrom=0;
					}
					var attendancePercentageTo = form.down('#attendancePercentageToCBSId').getValue();
					if(isNullOrEmpty(attendancePercentageTo) || attendancePercentageTo == 0){
						attendancePercentageTo=100;
					}
					var absentAboveNumberOfSessions = form.down('#absentAboveNumberOfSessions').getValue();
					var activeStatus = form.down('#statusComboItemId').getValue();
					var academyLocationId = academyLocationField.getValue();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var academicTermId = academicTermField.getValue();
					var studentId = studentField.getValue();
					var courseVariantId = courseVariantField.getValue();
					var startDate =Ext.Date.format(startDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
					var endDate = Ext.Date.format(endDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
					
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					store.getProxy().extraParams = {
						courseVariantId:courseVariantId,
						facultyId:facultyId,
						startDate:startDate,
						endDate:endDate,
						attendanceType:'COURSE_LEVEL',
						academicTermId:academicTermId,
						studentId:studentId,
						activeStatus: activeStatus,
						academyLocationId:academyLocationId,
						minAbsentPercentage:minAbsentPercentage,
						attendancePercentageFrom : attendancePercentageFrom,
						attendancePercentageTo : attendancePercentageTo,
						absentAboveNumberOfSessions:absentAboveNumberOfSessions
					};
					Ext.getBody().unmask();
					this.resetPageSetting(store, grid);
					store.load();
				},
				resetCourseLevelSummarySearchForm : function(form){
					var this$ = this;
					var academicTermField = form.down('#courseAttendanceSummaryAcademicTermId');
					var studentField = form.down('#courseAttendanceSummaryStudentNameId');
					var courseVariantField = form.down('#courseAttendanceSummaryCourseVariantId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#tillDate');
					form.down('#minAbsentPercentageCBSId').setValue(0);
					form.down('#absentAboveNumberOfSessions').setValue(0);
					var academyLocationId = form.down('#academyLocationId').getValue();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var grid = this.getStudentcourseattendancesummarygridforfaculty();
					var store = grid.getStore();
					grid.down('#exportReport').setDisabled(true);
					grid.getStore().removeAll();
					try{
						grid.down('custompagingtoolbar').hide();
					}catch(e){
					}
					academicTermField.reset();
					studentField.reset();
					courseVariantField.reset();
					startDateField.reset();
					endDateField.reset();
					
					startDateField.setMinValue(false);
					startDateField.setMaxValue(false);
					endDateField.setMinValue(false);
					endDateField.setMaxValue(false);
					
					var academicTermStore = academicTermField.getStore();
					academicTermStore.load({
			 			callback: function(rec, success) {
			 				if (success) {
			 					for(var i in rec){
			 						if(rec[i].get('whetherCurrentAcademicTerm')){
			 							form.down('#courseAttendanceSummaryAcademicTermId').setValue(rec[i].get('id'));
			 							var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
			 							var studentStore = studentField.getStore();
			 							studentStore.getProxy().api.read=submitURL;
			 							studentStore.getProxy().extraParams = {
			 								academyLocationIds: academyLocationId,
			 								facultyId: facultyId,
			 								academicTermId : rec[i].get('id')
			 							};
			 							studentStore.load();

			 							var courseVariantStore = courseVariantField.getStore();
			 							courseVariantStore.getProxy().extraParams = {
			 								academyLocationIds: academyLocationId,
			 								facultyId: facultyId,
			 								isCurrentPeriod:false,
			 								academicTermId : rec[i].get('id')
			 							};
			 							courseVariantStore.load();
			 						}
			 					}
			 				}
			 			}
			 		});
				},
});
