/**
 *  @author Priyanshi sharma
 * 
 */
Ext.define('Academia.controller.feeandpayment.debitOrders.ManageDebitOrdersController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['feeandpayment.reports.Student','feeandpayment.payment.DebitOrdersDateStore','common.AcademyLocationNameSeparated',
		      'enquiry.AcademicBatchStore','enquiry.ProgramBatchSeatTypeStore','feeandpayment.payment.DebitOrdersStatusStore','feeandpayment.receipts.CostCentreReceipt',
		      'feeandpayment.payment.DebitOrdersPaymentPlanStore','feeandpayment.payment.DebitOrdersFeePayerStore','feeandpayment.payment.DebitOrdersAccountNumberStore',
		      'feeandpayment.payment.DebitOrdersBankNameStore','feeandpayment.payment.DebitOrdersBranchNameStore','feeandpayment.FindAllPaymentPlanStore','feeandpayment.payment.ManageDebitOrderGridStore',
		      'feeandpayment.AcademyCurrency'],
	views  : ['feeandpayment.payment.ManageDebitOrdersStructure','feeandpayment.payment.ManageDebitOrdersFilter','feeandpayment.payment.ManageDebitOrdersGrid',
		'feeandpayment.payment.DebitOrderChangeStatusWin'],	

	config: {ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES'),
	         MANAGE_DEBIT_ORDER_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_DEBIT_ORDER_PRIVILEGES')},     	         

	refs : [{
		ref:'managedebitordersfilter',
		selector:'managedebitordersfilter'
	},{
		ref:'managedebitordersgrid',
		selector:'managedebitordersgrid'
	},{
		ref:'debitorderchangestatuswin',
		selector:'debitorderchangestatuswin'
	}],

	init : function() {
		this.suspendDebitOrderAlEvent=false;
		this.control({
			'managedebitordersfilter': {
				render: function(filter) {
					var multiselectAcademyLocation = filter.down('#debitOrderBrandCampus').getValue();
					var bankName = filter.down('#bankNameId');
					var branchCode = filter.down('#branchCode');
					var accountNumber = filter.down('#accountNumberId');
					var feePayer = filter.down('#feePayerId');
					personId = null;
					var ALsId = [];
					for(var i in multiselectAcademyLocation){
						if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
							ALsId.push(multiselectAcademyLocation[i].data.id);
						}else{
							ALsId.push(multiselectAcademyLocation[i]);
						}
					} 
					if(academyLocationId>0){
						var paymentPlanStore = this.getStore('feeandpayment.FindAllPaymentPlanStore');
						paymentPlanStore.getProxy().extraParams = {
							academyLocationIds: ALsId.join()
						};
						paymentPlanStore.load();
					}
					delete feePayer.store.proxy.extraParams.personId;
					delete accountNumber.store.proxy.extraParams.personId;
					delete bankName.store.proxy.extraParams.personId;
					delete bankName.store.proxy.extraParams.feePayerId;
					delete branchCode.store.proxy.extraParams.personId;
					delete branchCode.store.proxy.extraParams.feePayerId;
					delete branchCode.store.proxy.extraParams.bankId;
					feePayer.store.reload();
					accountNumber.store.reload();
					bankName.store.reload();
					branchCode.store.reload();
				}
			},
	        'managedebitordersfilter combo[itemId=student]': {
	        	select: function(obj, record) {
	        		var filter=this.getManagedebitordersfilter();
	        		var filterForm = filter.getForm();
	        		var feePayer = filter.down('#feePayerId');
	        		var accountNumber = filter.down('#accountNumberId');
	        		var bankName = filter.down('#bankNameId');
	        		var branchCode = filter.down('#branchCode');
	        		personId = record[0].data.personId;
	        		feePayer.reset();
	        		accountNumber.reset();
	        		bankName.reset();
	        		branchCode.reset();

	        		feePayer.getStore().getProxy().extraParams = {
	        			personId:personId
	        		}
	        		feePayer.getStore().load();
	        		accountNumber.getStore().getProxy().extraParams = {
	        			personId:personId
	        		}
	        		accountNumber.getStore().load();
	        		bankName.getStore().getProxy().extraParams = {
	        			personId:personId,
	        		}
	        		bankName.getStore().load();
	        		branchCode.getStore().getProxy().extraParams = {
	        			personId:personId,
	        		}
	        		branchCode.getStore().load();
	        	}
            },
            'managedebitordersfilter combo[itemId=feePayerId]': {
            	select: function(obj, record) {
            		var filter=this.getManagedebitordersfilter();
            		var filterForm = filter.getForm();
            		var studentCombo = filter.down('#student');
            		var accountNumber = filter.down('#accountNumberId');
            		var bankName = filter.down('#bankNameId');
            		var branchCode = filter.down('#branchCode');
            		var feePayer = filter.down('#feePayerId');
            		accountNumber.reset();
            		bankName.reset();
            		branchCode.reset();
            		accountNumber.getStore().getProxy().extraParams = {
            			personId:personId
            		}
            		accountNumber.getStore().load();
            		bankName.getStore().getProxy().extraParams = {
            			personId:personId,
            			feePayerId:feePayer.getValue(),
            		}
            		bankName.getStore().load();
            		branchCode.getStore().getProxy().extraParams = {
            			personId:personId,
            			feePayerId:feePayer.getValue(),
            			bankId:bankName.getValue(),
            		}
            		branchCode.getStore().load();
            	}
               },
               'managedebitordersfilter combo[itemId=accountNumberId]': {
            	   select: function(obj, record) {
            		   var filter=this.getManagedebitordersfilter();
            		   var filterForm = filter.getForm();
            		   var bankName = filter.down('#bankNameId');
            		   var studentCombo = filter.down('#student');
            		   var branchCode = filter.down('#branchCode');
            		   var feePayer = filter.down('#feePayerId');
            		   bankName.getStore().getProxy().extraParams = {
            			   personId:personId,
            			   feePayerId:feePayer.getValue(),
            		   }
            		   bankName.getStore().load();
            	   }
                  },
                  'managedebitordersfilter combo[itemId=bankNameId]': {
                	  select: function(obj, record) {
                		  var filter=this.getManagedebitordersfilter();
                		  var filterForm = filter.getForm();
                		  var bankName = filter.down('#bankNameId').getValue();
                		  var branchCode = filter.down('#branchCode');
                		  var studentCombo = filter.down('#student');
                		  var feePayer = filter.down('#feePayerId').getValue();
                			  branchCode.getStore().getProxy().extraParams = {
                				  personId:personId,
                				  feePayerId:feePayer,
                				  bankId:bankName
                			  }
                			  branchCode.getStore().load();
                		 
                	  }
                  },
                  'managedebitordersfilter combo[itemId=programId]': {
                	  change: function(obj, newValue) {
                		  var filter=this.getManagedebitordersfilter();
                		  var filterForm = filter.getForm();
                		  var programName = filter.down('#programId');
                		  var batchName = filter.down('#intakeId');
                		  var seatTypeName = filter.down('#seatTypeId');

                		  if(typeof newValue=='number'){
                			  batchName.reset();
                    		  seatTypeName.reset();
                			  batchName.enable();
                			  seatTypeName.disable();
                			  batchName.getStore().getProxy().extraParams = {
                				  id:newValue
                			  }
                			  batchName.getStore().load({
                				  callback:function(batchRecord){
                					  if(batchRecord.length ==1){
                						  batchName.setValue(batchRecord[0].data.id);
                						  seatTypeName.reset();
                						  seatTypeName.enable();
                					  }
                				  }
                			  });
                		  }
                	  }
                  },
	             'managedebitordersfilter combo[itemId=intakeId]': {
	            	 select: function(obj, record) {
	    				 var filter=this.getManagedebitordersfilter();
	    				 var filterForm = filter.getForm();
		    			 var batchName = filter.down('#intakeId');
		    			 var seatTypeName = filter.down('#seatTypeId');
		    				
	    				seatTypeName.reset();
	    				seatTypeName.enable();
	    				
	    				seatTypeName.getStore().getProxy().extraParams = {
	    					id:record[0].data.id
	    				}
	    				seatTypeName.getStore().load({
							callback:function(batchRecord){
								if(batchRecord.length ==1){
									seatTypeName.setValue(batchRecord[0].data.id);
								}
							}
						});
	    				 
	    			 }
	             },
	             'managedebitordersfilter button[itemId=resetBtn]': {
	            	 click: function(obj, record) {
	            		 var filter=this.getManagedebitordersfilter();
	            		 var filterForm = filter.getForm();
	            		 filterForm.reset();
	            		 var alCombo = filter.down('#debitOrderBrandCampus');
	            		 var alComboStore = alCombo.getStore();
	            		 var batchName = filter.down('#intakeId');
	            		 var seatTypeName = filter.down('#seatTypeId');
	            		 batchName.setDisabled(true);
	            		 seatTypeName.setDisabled(true);
	            		 //personId=undefined;
	            		 var bankName = filter.down('#bankNameId');
	            		 var branchCode = filter.down('#branchCode');
	            		 var accountNumber = filter.down('#accountNumberId');
	            		 var feePayer = filter.down('#feePayerId');
	            		 delete feePayer.store.proxy.extraParams.personId;
	            		 delete accountNumber.store.proxy.extraParams.personId;
	            		 delete bankName.store.proxy.extraParams.personId;
	            		 delete bankName.store.proxy.extraParams.feePayerId;
	            		 delete branchCode.store.proxy.extraParams.personId;
	            		 delete branchCode.store.proxy.extraParams.feePayerId;
	            		 delete branchCode.store.proxy.extraParams.bankId;
	            		 feePayer.store.reload();
	            		 accountNumber.store.reload();
	            		 bankName.store.reload();
	            		 branchCode.store.reload();
	            		
	            		 alComboStore.load({
	            			 callback: function(records, operation, success) {
	            				 if (success) {
	            					 alCombo.select(alCombo.getStore().collect(alCombo.valueField));
	            				 }
	            			 }   
	            		 });	
	            	 }
	             },
	             'managedebitordersfilter button[itemId=searchBtn]': {
	            	 click: function(btn, record) {
	    				this.loadManageDebitGridData(btn);
	    			 }
	             },
	             'managedebitordersfilter multiselectcombofield[itemId=debitOrderBrandCampus]': {
	            	 afterrender: function(obj) {
	            		 var $this = this;
	            		 var ALComboStore = obj.getStore();
	            		 ALComboStore.load({
	            			 callback: function(records, operation, success) {
	            				 if (success) {
	            					 $this.suspendDebitOrderAlEvent=true;
	            					 obj.select(obj.getStore().collect(obj.valueField));
	            					 $this.suspendDebitOrderAlEvent=false;
	            				 }
	            			 }   
	            		 });		
	            	 },
	            	 change:function(obj){
	            		 if(!this.suspendDebitOrderAlEvent){
	            			this.loadALDependentCombo(obj);
	            		 }
	            	 }
	             },
	             'managedebitordersfilter combo':{
	            	 afterrender: function(obj) {
	            		 var this$ = this;
	            		 if(obj.itemId=='paymentPlanId' || obj.itemId=='programId' || obj.itemId=='intakeId' || 
	            				 obj.itemId=='seatTypeId' || obj.itemId=='student'){
	            			 var store = obj.store;
	            			 store.on('beforeload', function(store, operation) {
	            				 var form = this$.getManagedebitordersfilter();
	            				 var alField = form.down("#debitOrderBrandCampus");
	            				 var multiselectAcademyLocation=alField.getValue();
	            				 var ALsId = [];
	            				 for(var i in multiselectAcademyLocation){
	            					 if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
	            						 ALsId.push(multiselectAcademyLocation[i].data.id);
	            					 }else{
	            						 ALsId.push(multiselectAcademyLocation[i]);
	            					 }
	            				 }
	            				 if(obj.itemId=='paymentPlanId'){
	            					 store.proxy.extraParams.alIds=ALsId.join()
	            				 }else{
	            					 store.proxy.extraParams.academyLocationIds=ALsId.join()
	            				 }
	            			 });
	            		 }
	            	 }
	             },
	             'managedebitordersgrid': {
	            	 afterrender: function(grid){
	            		 var me = this;
	            		 setTimeout(function(){
	            			 // me.doAccessControlValidation(grid, me.getMANAGE_DEBIT_ORDER_PRIVILEGES());
	            			 me.disableMoreActionPivileges(me.getMANAGE_DEBIT_ORDER_PRIVILEGES());
	            			 me.addDataGridConfigButton(grid,me.getATTENDANCE_ENTRY_PERMISSIONS());
	            		 },1500);
	            		 grid.getStore().removeAll();
	            	 } 
	             },
	             'managedebitordersgrid button[itemId=exportReport]':{
	            	 click:this.exportReportManageDebitOrder
	             },
	             'managedebitordersgrid button[itemId=changeStatus]':{
	            	click:function(obj){
	            		 this.openChangeStatusWin(obj);
	            	}
	             },
	             'debitorderchangestatuswin button[itemId=SubmitBtn]':{
		            	click:function(obj){
		            		 this.saveDebitOrderChangedStatus(obj);
		            	}
		          },
		          'debitorderchangestatuswin button[itemId=CancelBtn]':{
		            	click:function(obj){
		            		this.getDebitorderchangestatuswin().close();
		            	}
		          },
		          'debitorderchangestatuswin':{
		        	  afterrender:function(form){
		        		  this.applyDFRForDebitOrderChangeStatus(form);
		        	  }
		          }
		});
	},
	loadManageDebitGridData:function(btn){
		btn.setDisabled(true);
		var me =this,
		filter=me.getManagedebitordersfilter(),
		formValue = filter.getForm().getValues();
		var multiselectAcademyLocation = formValue.debitOrderBrandCampus;
		var ALsId = [];
		for(var i in multiselectAcademyLocation){
			if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
				ALsId.push(multiselectAcademyLocation[i].data.id);
			}else{
				ALsId.push(multiselectAcademyLocation[i]);
			}
		}
		grid = this.getManagedebitordersgrid();
		var changeStatusBtn = grid.down('#changeStatus');
		var exportReport = grid.down('#exportReport');
		manageDebitStore = grid.getStore();
		manageDebitStore.getProxy().extraParams = {
			debitOrderFrom: formValue.debitOrderDate,
			paymentFromDate:formValue.paymentFromDate,
			paymentTillDate:formValue.paymentTillDate,
			paymentPlanId:formValue.paymentPlan,
			programId: formValue.program,
			intakeId: formValue.intake,
			seatTypeId: formValue.seatType,
			studentId: formValue.student,
			debitOrderStatus: formValue.debitOrderStatus,
			accountNumber: formValue.accountNumber,
			bankName: formValue.bankName,
			branchCode: formValue.branchCode,
			feePayerId: formValue.feePayer,
			academyLocationIds:ALsId.join(),
			minAmount:formValue.minimumAmount,
			maxAmount:formValue.maximumAmount,
		};
		grid.getSelectionModel().deselectAll();
		me.resetGridSetting(grid);
		me.resetPageSetting(manageDebitStore);
		manageDebitStore.load({
			callback: function(record, operation, success) {
				btn.setDisabled(false);
				if(success){
					if(record.length>0){
						if(this.proxy.extraParams.debitOrderStatus=='PENDING'){
							changeStatusBtn.setDisabled(false);
							exportReport.setDisabled(false);
						}else{
							changeStatusBtn.setDisabled(true);
							exportReport.setDisabled(true);
						}
					}else{
						changeStatusBtn.setDisabled(true);
						exportReport.setDisabled(true);
					}
				}
			}
		});
	},
	disableMoreActionPivileges: function(permissionsMap) {
    	var manageDebitOrderGrid = this.getManagedebitordersgrid();
    	var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var button = manageDebitOrderGrid.down('#exportReport');
        var ChngeStatusbutton = manageDebitOrderGrid.down('#changeStatus');
    	button.setVisible(false);
        ChngeStatusbutton.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'EXPORTREPORTS') {
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}        		
        	}
          if (privilege === 'CHANGESTATUS') {
        		if(!isNullOrEmpty(ChngeStatusbutton)){
        			ChngeStatusbutton.setVisible(true);
        		}        		
        	}


    	});
    },
    loadALDependentCombo:function(obj){
    	var form=this.getManagedebitordersfilter();
    	var paymentPlan = form.down('#paymentPlanId');
    	var program = form.down('#programId');
    	var student = form.down('#student');
    	var feePayerId = form.down('#feePayerId');
    	paymentPlan.reset();
    	program.reset();
    	student.reset();
    	feePayerId.reset();
    	program.store.load();
    	paymentPlan.store.load();
    },
    /*This method is used to download report when user click on export button */
    exportReportManageDebitOrder:function(btn){
		var grid = this.getManagedebitordersgrid();
    	var store = grid.getStore();
    	var records = grid.getSelectionModel().getSelection();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var debitOrderArray = [];
    		Ext.each(records,function (record){
    			var studentData=new Object();
    			studentData.amount=Ext.util.Format.number(record.data.amount,'0.00');
    			studentData.studentId=record.data.stuId;
    			debitOrderArray.push(studentData);
    		});
    		var obj = new Object();
    		obj.wsData = debitOrderArray;
    		var csvForm = Ext.create('Ext.form.Panel',{
    			             items:[{
    				                 xtype : 'textfield',
    				                 maxLength:1000000,
    				                 itemId : 'debitOrderExportData',
    				                 name : 'debitOrderExportData'
    					             }]
    		         }); 
    	    csvForm.down('#debitOrderExportData').setValue(Ext.encode(debitOrderArray)); 
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'POST',
    			params :{
    				access_token : Ext.Ajax.defaultHeaders.access_token,
    				logs:Ext.encode(obj)
    				//logs : form.responseText
    			},
    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    			url: SERVERURL.PATH_MANAGE_DEBIT_ORDER_EXPORT,
    			standardSubmit :true
    		}); 
    	}
    	else{
    		store.load({
    			params: {
    				limit:-1
    			},
                callback: function(rec, operation, success) {
                    if (success) {
                    	var debitOrderArray = [];
                		Ext.each(rec,function (record){
                			var studentData=new Object();
                			studentData.amount=Ext.util.Format.number(record.data.amount,'0.00');
                			studentData.studentId=record.data.stuId;
                			debitOrderArray.push(studentData);
                		});
                		var obj = new Object();
                		obj.wsData = debitOrderArray;
                		var csvForm = Ext.create('Ext.form.Panel',{
                			             items:[{
                				                 xtype : 'textfield',
                				                 maxLength:1000000,
                				                 itemId : 'debitOrderExportData',
                				                 name : 'debitOrderExportData'
                					             }]
                		         }); 
                	    csvForm.down('#debitOrderExportData').setValue(Ext.encode(debitOrderArray)); 
                		csvForm.getForm().submit({
                			target: '_blank',
                			method:'POST',
                			params :{
                				access_token : Ext.Ajax.defaultHeaders.access_token,
                				logs:Ext.encode(obj)
                				//logs : form.responseText
                			},
                			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                			url: SERVERURL.PATH_MANAGE_DEBIT_ORDER_EXPORT,
                			standardSubmit :true
                		});
                    }
                }
            });
    	}
    },
    openChangeStatusWin:function(obj){
    	var changestatuswin = this.getDebitorderchangestatuswin();
    	if (!changestatuswin) {
    		Ext.widget('debitorderchangestatuswin');
    		changestatuswin = this.getDebitorderchangestatuswin();
    	}
    	changestatuswin.show();
    },
    saveDebitOrderChangedStatus:function(){
    	var changestatuswin = this.getDebitorderchangestatuswin();
    	var form = changestatuswin.down('form').getForm();
    	var formFieldsData = form.getValues();
    	var debitOrderjson = new Object();
    	changestatuswin.down('#SubmitBtn').setDisabled(true);
    	var submitData;
    	var grid = this.getManagedebitordersgrid();
    	var records = grid.getSelectionModel().getSelection();
    	var stdPayementPlanSchedule = [];
    	if (grid.getSelectionModel().getCount() > 0) {
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.each(records,function (record){
        		if(record.data.bankId){
        			var paymentData=new Object();
        			paymentData.amount=record.data.amount;
        			paymentData.studentPaymentPlanEnrollment={
        					"id":record.data.studentPaymentPlanEnrollmentId
        			};
        			paymentData.paymentPlanSchedule={
        					"id":record.data.paymentPlanScheduleId
        			};
        			stdPayementPlanSchedule.push(paymentData);
        		}
        	});
        	var costCentre = {
        			"id":formFieldsData.costCentre
        	}
        	var currency={
        			"id":formFieldsData.receivingCurrency
        	}
        	debitOrderjson.costCentre=(!isNullOrEmpty(formFieldsData.costCentre)?costCentre:null);
        	debitOrderjson.narration=formFieldsData.narration;
        	debitOrderjson.currency=(!isNullOrEmpty(formFieldsData.receivingCurrency)?currency:null);
        	debitOrderjson.isAutoSettle=formFieldsData.isAutoSettlement;
        	debitOrderjson.paymentDate=formFieldsData.receiptDate;
        	debitOrderjson.externalReceiptNo=formFieldsData.externalReceiptNum;
        	debitOrderjson.studentPaymentPlanSchedule=stdPayementPlanSchedule;
        	submitData = Ext.encode(debitOrderjson);
        	Ext.Ajax.request({
        		type : 'rest',
        		method: 'POST',
        		url: SERVERURL.PATH_SAVE_DEBIT_ORDER_RECEIPT,
        		jsonData: submitData,
        		success: function(response) {
        			grid.store.load();
        			changestatuswin.close();
        			Ext.getBody().unmask();
        			showSuccessMessage(getFeeAndPaymentCommonTranslation('MANAGE_DEBIT_ORDERS'),getFeeAndPaymentCommonTranslation('DEBIT_ORDER_STATUS_UPDATED_SUCCESSFULLY_RECEIPTS_SUCCESSFULLY_GENERATED'));
        		},
        		failure: function(){
        			changestatuswin.down('#SubmitBtn').setDisabled(false);
        			Ext.getBody().unmask();
        		}
        	});
    	}else{
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		grid.store.load({
    			params: {
    				limit:-1
    			},
    			callback: function(records, operation, success) {
    				if(success){
    					Ext.each(records,function (record){
    			    		if(record.data.bankId){
    			    			var paymentData=new Object();
    			    			paymentData.amount=record.data.amount;
    			    			paymentData.studentPaymentPlanEnrollment={
    			    					"id":record.data.studentPaymentPlanEnrollmentId
    			    			};
    			    			paymentData.paymentPlanSchedule={
    			    					"id":record.data.paymentPlanScheduleId
    			    			};
    			    			stdPayementPlanSchedule.push(paymentData);
    			    		}
    			    	});
    			    	var costCentre = {
    			    			"id":formFieldsData.costCentre
    			    	}
    			    	var currency={
    			    			"id":formFieldsData.receivingCurrency
    			    	}
    			    	debitOrderjson.costCentre=(!isNullOrEmpty(formFieldsData.costCentre)?costCentre:null);
    			    	debitOrderjson.narration=formFieldsData.narration;
    			    	debitOrderjson.currency=(!isNullOrEmpty(formFieldsData.receivingCurrency)?currency:null);
    			    	debitOrderjson.isAutoSettle=formFieldsData.isAutoSettlement;
    			    	debitOrderjson.paymentDate=formFieldsData.receiptDate;
    			    	debitOrderjson.externalReceiptNo=formFieldsData.externalReceiptNum;
    			    	debitOrderjson.studentPaymentPlanSchedule=stdPayementPlanSchedule;
    			    	submitData = Ext.encode(debitOrderjson);
    			    	Ext.Ajax.request({
    			    		type : 'rest',
    			    		method: 'POST',
    			    		url: SERVERURL.PATH_SAVE_DEBIT_ORDER_RECEIPT,
    			    		jsonData: submitData,
    			    		success: function(response) {
    			    			grid.store.load();
    			    			changestatuswin.close();
    			    			Ext.getBody().unmask();
    			    			showSuccessMessage(getFeeAndPaymentCommonTranslation('MANAGE_DEBIT_ORDERS'),getFeeAndPaymentCommonTranslation('DEBIT_ORDER_STATUS_UPDATED_SUCCESSFULLY_RECEIPTS_SUCCESSFULLY_GENERATED'));
    			    		},
    			    		failure: function(){
    		        			changestatuswin.down('#SubmitBtn').setDisabled(false);
    		        			Ext.getBody().unmask();
    		        		}
    			    	});
    				}
    			}
    		});
    	}
    },
    applyDFRForDebitOrderChangeStatus:function(form){
    	var $this = this;
    	var receiptDate = form.down('#receiptDate');
    	var debitOrderStatus = form.down('#debitOrderStatus');
		Ext.Ajax.request({
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		method: 'GET',
    		async: false,
    		params: {
    			screenName: 'debitorderchangestatuswin',
    			academyLocationId:$this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		success: function(response) {
    			var response = Ext.decode(response.responseText);
    			var records= response.debitorderchangestatuswin;
    			for(i in records){  
    				if(records[i].formFieldId=='receiptDate'){
    					receiptDate.setValue(Ext.Date.add(new Date()));
    				}
    				if(records[i].formFieldId=='debitOrderStatus'){
    					debitOrderStatus.setValue('Processed');
    				}
    			}
    		}
		});
    }
});
