/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.feerequest.FeeRequestController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['feeandpayment.feerequest.FeeReqBillInstallment','feeandpayment.feerequest.TempInstallmentData',
	          'feeandpayment.feerequest.FeeRequestSave','feeandpayment.feerequest.FeeServiceRequestModel',
	          'feeandpayment.feerequest.FeeServiceRequest','feeandpayment.feerequest.FeeRelatedServiceRequestInstallment'],
	stores : ['feeandpayment.feerequest.FeeRequestFors','feeandpayment.feerequest.ChooseAgainst',
	          'feeandpayment.feerequest.ConcessionType','feeandpayment.feerequest.TempInstallmentData',
	          'feeandpayment.feerequest.FeeReqBillInstallment','feeandpayment.feerequest.FeeRelatedServiceRequestInstallment',
	          'feeandpayment.feerequest.TempInstallmentStore','feeandpayment.feerequest.ApprovalStatus',
	          'feeandpayment.feerequest.FeeConcessionDetails','feeandpayment.feerequest.ApproverFeeRequestDetails',
	          'feeandpayment.managebill.Sponsors','feeandpayment.managebill.User','feeandpayment.managebill.Student'],
	views : ['feeandpayment.feerequest.FeeRequestStructure','feeandpayment.feerequest.FeeReqSearchForm',
	         'feeandpayment.feerequest.FeeReqBillWaiverGrid','feeandpayment.feerequest.FeeReqInstallmentWin',
	         'feeandpayment.feerequest.FeeReqBillInstallmentGrid','servicerequest.feeservicerequest.ApproverFeeRequestDetailGrid',
	         'feeandpayment.feerequest.FeeRequestItemsStructure'],
	         config: {

	        	 /* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.

	        	  *//**
	        	  * @cfg {Array} MANAGE_RECEIPT_PERMISSIONS array (required)
	        	  * The array of permissions to use for Access control wise enabling and disabling buttons.
	        	  * @accessor
	        	  */
	        	 FEE_REQUEST_GRID_CONFIGURATION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FEE_REQUEST_GRID_CONFIGURATION'),
	         },

	refs : [{
        	   ref:'feerequeststructure',
        	   selector:'feerequeststructure'
	       },{
	    	   ref:'feereqsearchform',
        	   selector:'feereqsearchform'
	       },{
	    	   ref:'feereqbillwaivergrid',
        	   selector:'feereqbillwaivergrid'
	       },{
	    	   ref:'feereqinstallmentwin',
	    	   selector:'feereqinstallmentwin'
	       },{
	    	   ref:'feereqinstallmentWin',
	    	   selector:'feereqinstallmentwin form'
	       },{
	    	   ref:'feereqbillinstallmentgrid',
	    	   selector:'feereqbillinstallmentgrid'
	       },{
	    	   ref:'approverFeeRequestDetailGrid',
	    	   selector:'approverfeerequestdetailgrid'
	       }],

      init : function() {
    	  this.control({
    		  'feerequestitemsstructure':{
    			  afterrender : function(structure){
     				 var $this = this;
     				 structure.body.on('scroll', function(e, target) {
     					 var feereqbillwaivergrid = $this.getFeereqbillwaivergrid();
     					 var feereqbillinstallmentgrid = $this.getFeereqbillinstallmentgrid();
     					
     					 var grid = null;
     					 if(!feereqbillwaivergrid.isHidden()){
     						 grid = $this.getFeereqbillwaivergrid();
     					 }
     					 if(!feereqbillinstallmentgrid.isHidden()){
     						 grid = $this.getFeereqbillinstallmentgrid();
     					 }
     					 $this.getMultipleGridHeaderFreeze(grid,structure);
     				 });
     			  }
    		  },
    		  'feereqsearchform':{
    			  render:function(){
    				  this.getAutoLoadFields();
    			  }
    		  },
    		  'feereqsearchform button[itemId=searchBtn]':{
    			  click:this.getSearchFeeReq
    		  },
    		  'feereqsearchform button[itemId=resetBtn]':{
    			  click:function(){
    				  var form =  this.getFeereqsearchform().getForm();
    				  form.getFields().each(function(field) {
    					  if(field.name !== 'requestFor' && field.name != 'chooseAgainst' && field.name != 'concessionType') {
    						  field.reset();	
    					  }
    				  });
    				  Ext.resumeLayouts();
    			  }
    		  },
    		  'feereqsearchform customcombobox[itemId=requestFor]':{
    			  select:this.showHideSmartSearch
    		  },
    		  'feereqbillwaivergrid button[itemId=btnSave]':{
    			  click : function(){
    				  var grid = this.getFeereqbillwaivergrid(); 
    				  this.getSaveFeeRequestForStudent(grid);
    			  }
    		  },
    		  'feereqbillinstallmentgrid':{
    			  select:function(){
    				  this.getLockedGrids();
    			  },
    			  cellclick : function(obj,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var grid = this.getFeereqbillinstallmentgrid();
    				  if(e.target.tagName=='A'){
    					  this.getInstallment(grid,record);
    				  }
    			  }
    		  },
    		  'feereqbillinstallmentgrid button[itemId=btnSave]':{
    			  click : function(){
    				  var grid = this.getFeereqbillinstallmentgrid(); 
    				  this.getSaveFeeRequestForStudent(grid);
    			  }
    		  },
    		  'feereqbillwaivergrid':{
    			  select : function(){
    				  this.getLockedWaiverGrids();
    			  },
    			  cellclick : function(obj,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				  var grid = this.getFeereqbillwaivergrid();
    				  if(e.target.tagName=='A'){
    					  this.getInstallmentForPendingBill(grid,record);
    				  }
    			  },
    			  afterrender : function(grid){
    				  grid.columns[5].hide();
    				  var me = this;
    				  setTimeout(function(){
    					  me.addDataGridConfigButton(grid, me.getFEE_REQUEST_GRID_CONFIGURATION());
    				  },1500);
    			  }
    		  },
    		  'feereqinstallmentwin button[itemId=cancelBtn]':{
    			  click:this.getCloseInstallmentWindow
    		  },
    		  'feereqinstallmentwin button[itemId=btnAddInstallment]':{
    			  click:this.addIntallmentContainer
    		  },
    		  'feereqinstallmentwin button[itemId=saveBtn]':{
    			  click:this.saveInstallment
    		  },
    		  'feereqsearchform customcombobox[itemId=concessionType]':{
    			  select:this.getSelectChooseAgainstAndConcessionType
    		  },
    		  'feereqsearchform customcombobox[itemId=chooseAgainst]':{
    			  select:this.getSelectChooseAgainstAndConcessionType
    		  },
    		  'feereqbillwaivergrid numberfield[itemId=amountWaiverRequested]':{
    			  blur:function(obj,record){
    				  var value = obj.getValue();
    				  var grid = this.getFeereqbillwaivergrid();
    				  var record = grid.getSelectionModel().getSelection()[0];
    				  var amount = record.get("totalAmount");
    				  if(amount<value){
    					  record.set("amountWaiverRequested",0);
    				  }
    			  }
    		  }
    		  
    	  });
      },
      getAutoLoadFields : function(){
    	  
    	  var form = this.getFeereqsearchform();
    	  
    	  var user = this.getCurrentlyLoggedInUser();
   	      form.getForm().findField("requestCreatedBy").setValue(user.value);
    	 
    	  var requestForField = form.down("#requestFor");
    	  var requestForStore = requestForField.getStore();
    	  
    	  var chooseAgainstField = form.down("#chooseAgainst");
    	  var chooseAgainstStore = chooseAgainstField.getStore();

    	  var concessionTypeField =  form.down("#concessionType");
    	  var concessionTypeStore = concessionTypeField.getStore();

    	  requestForStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  requestForField.setValue('STUDENT');
    				 // form.down("#student").setVisible(true);
    			  }
    		  }
    	  });
    	  
    	  chooseAgainstStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  chooseAgainstField.setValue('PENDING_BILLS');
    			  }
    		  }
    	  });
    	  
    	  concessionTypeStore.load({
    		  callback: function(record, operation, success) {
    			  if (success) {
    				  concessionTypeField.setValue('INSTALLMENT');
    			  }
    		  }
    	  });
    	  
    	  //amountWaiverRequested
      },
      
      //  *************** showHide Smart Search based on Request for ************
      showHideSmartSearch : function(obj,record){
    	  
    	  var value = record[0].get("id");
    	  
    	  var form = this.getFeereqsearchform();
    	  var student = form.down("#student");
    	  var user = form.down("#userId");
    	  var sponsor = form.down("#sponsors");
    	  
    	  student.reset();
    	  user.reset();
    	  sponsor.reset();
    	  
    	  student.allowBlank=true;
    	  user.allowBlank=true;
    	  sponsor.allowBlank=true;
    	  
    	  student.setVisible(false);
    	  user.setVisible(false);
    	  sponsor.setVisible(false);
    	  
    	  if(value==getFeeAndPaymentCommonTranslation('STUDENT_TYPE')){
    		  student.setVisible(true);
    		  student.allowBlank=false;
    		  student.labelSeparator='',
    		  student.setFieldLabel(getFeeAndPaymentCommonTranslation('STUDENT')+': <span class="required" style="color:red"> *</span>');
    		  
    	  }
    	  else if(value==getFeeAndPaymentCommonTranslation('SPONSOR_TYPE')){
    		  sponsor.setVisible(true);  
    		  sponsor.allowBlank=false;
    		  sponsor.labelSeparator='',
    		  sponsor.setFieldLabel(getFeeAndPaymentCommonTranslation('SPONSOR')+': <span class="required" style="color:red"> *</span>');
    	  }else{
    		  var whetherInternal=null;
    		  if(value==getFeeAndPaymentCommonTranslation('INTERNAL_USER_CONDITION')){
    			  whetherInternal = true;
    		  }else if(value==getFeeAndPaymentCommonTranslation('EXTERNAL_USER_CONDITION')){
    			  whetherInternal = false;
    		  }
    		  
        	  var store = form.down("#userId").getStore();
    		  store.getProxy().extraParams = {
    				 whetherInternal : whetherInternal,
    				 codeOrName :null
    			 };
    			 store.load();
    		  
    		  
    		  user.setVisible(true);
    		  user.allowBlank=false;
    		  user.labelSeparator='',
    		  user.setFieldLabel(getFeeAndPaymentCommonTranslation('USER')+': <span class="required" style="color:red"> *</span>');
    	  }
      },
      // **********get records based on student Id,billedUserType &adjustmentType *****
      getSearchFeeReq : function(){
    	  
    	  var structure = this.getFeerequeststructure();

    	  var billInstallment = structure.down("#feereqbillinstallmentgrid");
    	  var billWaiver = structure.down("#feereqbillwaivergrid");
    	  
    	  var form = this.getFeereqsearchform();
    	  
    	  var billedUserType = form.down("#requestFor").getValue();
    	  if(billedUserType == 'SPONSOR'){
    		  var id = form.down("#sponsors").getValue();
    	  }else if(billedUserType == 'STUDENT'){
    		  var id = form.down("#student").getValue();
    	  }else if(billedUserType == 'INTERNAL_USER'){
    		  var id = form.down("#userId").getValue();
    	  }else if(billedUserType == 'EXTERNAL_USER'){
    		  var id = form.down("#userId").getValue();
    	  }
    	  
    	  if(!billWaiver.isHidden()){
    		  var adjustmentType = 'RECEIPT';
    		  var store = this.getStore('feeandpayment.feerequest.FeeConcessionDetails');
        	  store.getProxy().extraParams = {
        		  id:id,
        		  billedUserType: billedUserType,
        		  adjustmentType:adjustmentType
        	  };
        	  store.load();
        	  
    	  }else if(!billInstallment.isHidden()){
    		  var store1 = this.getStore('feeandpayment.feerequest.FeeReqBillInstallment');
        	  store1.getProxy().extraParams = {
        		  id:id,
        		  requestFor: billedUserType
        	  };
        	  store1.load();
    	  }
      },
   // **********get Save records for student ,pending billing *****
      getSaveFeeRequestForStudent : function(grid){
    	   
    	  var $this = this;
    	  var portalId = $this.getCurrentLoggedPortalId();
    	  var form = $this.getFeereqsearchform();
    	  var records = grid.selModel.getSelection();
    	  var feerequestModel = new Academia.model.feeandpayment.feerequest.FeeRequestSave();
    	  var concessionType = form.down("#concessionType").getValue();

    	  var submitUrl = SERVERURL.FEE_SERVICE_REQUEST_SETTING_FIND_ID;
    	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading')
    	  Ext.Ajax.request({
    		  url: submitUrl,
    		  method: 'GET',
    		  params:{
    			  feeRelatedCategory:concessionType,
    			  academyLocation:this.getCurrentAcademyLocation(),
				  portalId: portalId
    		  },
    		  success: function(response) {
    			  var SRSO = Ext.decode(response.responseText);
    			  if(!isNullOrEmpty(SRSO) && !isNullOrEmpty(SRSO.id)){
    			  var serviceRequestSetting = {
					                   "id":SRSO.id,
					                   "isAutoApprove":SRSO.value
			                                };
    			  var student  = form.down("#student").getValue();
    			  var sponsor  = form.down("#sponsors").getValue();
    			  var user  = form.down("#userId").getValue();
    			  var requestFor = form.down("#requestFor").getValue();
    			  var chooseAgainst = form.down("#chooseAgainst").getValue();
    			  var date = form.down("#requestDate").getValue();
    			  //var requestDate = Ext.Date.format(new Date(date), 'd-m-Y');
    			  var requestDate = new Date().getTime();
    			  var remarks = null;
    			  if (isNullOrEmpty(form.up().down("feereqbillwaivergrid").down("#remark"))){
    				  remarks = form.up().down("feereqbillinstallmentgrid").down("#remark")
    			  } else {
    				  remarks = form.up().down("feereqbillwaivergrid").down("#remark").value;
    			  }
    			  var proxyStore = $this.getStore('feeandpayment.feerequest.TempInstallmentData');
    			  var myItems = proxyStore.getRange();
    			  var installmentJson = new Array();
    			  if(myItems.length>0){
    				var myJson = myItems[0].get("myJson");
    				  for(var j in myJson){
    					  installmentJson.push(myJson[j]);
    				  }
    			  }
    			  var feeRequestData=[];
    			  for(var r in records){
    				  var amountWaiverRequested=0;
        			  if(records[r].get("waiverAmountRequested")!= null){
        				  amountWaiverRequested =  records[r].get("waiverAmountRequested");
        			  }
					  if(isNullOrEmpty(records[r].data.remark)){
						  	Ext.getBody().unmask();
						  	showWarningMessage(getFeeAndPaymentCommonTranslation('INSERT_REMARK'), getFeeAndPaymentCommonTranslation('PLEASE_INSERT_REMARK'));
						  	return false;
					  }
    			  feeRequestData.push({
    				  "user":$this.getIdValueJson(user),
    				  "student":$this.getIdValueJson(student),
    				  "sponsor":$this.getIdValueJson(sponsor),
    				  "billFeePlanRuleStage":$this.getIdValueJson(records[r].get("billFeePlanRuleStageId")),
    				  "feeStageHeadConfiguration":$this.getIdValueJson(records[r].get("feeStageHeadConfigId")),
    				  "feePlanSubmissionSchedule":$this.getIdValueJson(records[r].get("id")),
    				  "waiverAmountRequested":amountWaiverRequested,
    				  "waiverAmountApproved":null,
    				  "requestDate":requestDate,
    				  "requestFor":requestFor,
    				  "category":concessionType,
    				  "remark":records[r].get("remark"),
    				  "feeRequestAgainst":chooseAgainst,
    				  "installmentDetails":installmentJson
    			   });
    			  }
    			  feerequestModel.set("detail",feeRequestData);
    			  feerequestModel.set("serviceRequestSetting",serviceRequestSetting);
    			  feerequestModel.set("enteredBy",$this.getIdValueJson(student));
    			  feerequestModel.set("requesterType",requestFor);
    			  feerequestModel.set("requester",$this.getIdValueJson(student));
    			  feerequestModel.set("requestDate",requestDate);
    			  feerequestModel.set("remarks",remarks);
    				   
    			  var submitData = Ext.encode(feerequestModel.data);
    			  var submitUrl = SERVERURL.FEE_REQUEST_DETAILS_CREATE;

    			  Ext.Ajax.request({
    				  url: submitUrl,
    				  jsonData: submitData,
    				  method: 'POST',
    				  success: function(response) {
    					  Ext.getBody().unmask();
    					  grid.getStore().reload();
    					  proxyStore.removeAll();
    					  grid.getSelectionModel().setLocked(false);
    					  grid.getSelectionModel().deselectAll();
    					  showSuccessMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'),getFeeAndPaymentCommonTranslation('FEE_REQUEST_CREATED_SUCCESS'));
    				  }
    			  });
    			  }else{
    				  Ext.getBody().unmask();
    				  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'),getFeeAndPaymentCommonTranslation('FEE_SERVICE_REQUEST_SEETINGS_NOT_CONFIGURE'));
    			  }
    			 
    		  }
    	  });
      },
      //***********get installment**************
      getInstallment : function(grid,record){
    	 
    	  var checkRecord = grid.selModel.getSelection();
    	  
    	  if(checkRecord.length>0){
    	  
    	  var formWin = this.getFeereqinstallmentwin();
	      if (!formWin) {
	            Ext.widget('feereqinstallmentwin');
	            formWin = this.getFeereqinstallmentwin();
	       }
	      formWin.down("#id").setValue(record.get("billFeePlanRuleStageId"));
	      formWin.down("#studentId").setValue(record.get("userCode"));
	      formWin.down("#studentName").setValue(record.get("userPrintName"));
	      formWin.down("#billNo").setValue(record.get("billNo"));
	      formWin.down("#feeHead").setValue(record.get("feeHeadName"));
	      formWin.down("#amount").setValue(record.get("totalAmount"));
	      
	      formWin.show();
    	  }else{
    		  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_CHECKBOX'));
    	  }
      },
      // *********** installment for pending bills *************
      getInstallmentForPendingBill : function(grid,record){
    	 
         var checkRecord = grid.selModel.getSelection();
    	  
    	  if(checkRecord.length>0){
    		  
    	  var formWin = this.getFeereqinstallmentwin();
	      if (!formWin) {
	            Ext.widget('feereqinstallmentwin');
	            formWin = this.getFeereqinstallmentwin();
	       }
	      formWin.down("#id").setValue(record.get("billFeePlanRuleStageId"));
	      formWin.down("#studentId").setValue(record.get("code"));
	      formWin.down("#studentName").setValue(record.get("printName"));
	      formWin.down("#billNo").setValue(record.get("billNo"));
	      formWin.down("#feeHead").setValue(record.get("feeHeadName"));
	      formWin.down("#amount").setValue(record.get("totalBalanceAmount"));
	      
	      formWin.show();
      }else{
    	  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_CHECKBOX')); 
      }
      },
      getCloseInstallmentWindow : function(){
    	  this.getFeereqinstallmentwin().close();
      },
      
      //********add dyanmic fields**********************
      addIntallmentContainer: function() {
          var this$ = this;
          var form = this$.getFeereqinstallmentWin();
          var panelItem = new Array();
          panelItem.push({
              xtype: 'fieldcontainer',
              width: '100%',
              layout: {
                  type: 'hbox',
                  align: 'bottom'
              },
	           items: [{
		            	  xtype:'datefield',
		            	  itemId:'installmentDueDate',
		            	  name:'installmentDueDate',
		            	  labelAlign: 'top',
		            	  //format: CONSTANTS.DATE_FORMAT,
		            	  //--submitFormat: CONSTANTS.DATE_FORMAT,
		            	  allowBlank: false,
//		            	  value:new Date(),
//		            	  minValue:new Date(),
		            	  listeners: {
		            		  render: function(obj) {
		            			  obj = dateFormatRender(obj);						
		            			  obj.setMinValue(new Date());
		            			  obj.setValue(new Date());
		            		  }
		            	  }
		              },{
		            	  xtype: 'numberfield',
		            	  itemId: 'installmentAmount',
		            	  labelAlign: 'top',
		            	  name: 'installmentAmount',
		            	  minValue: 0,
		            	  allowDecimals:false,
		            	  allowBlank: false,
		            	  hideTrigger:true,
		            	  mouseWheelEnabled:false
		              },{
		            	  xtype: 'textfield',
		            	  itemId: 'installmentStatus',
		            	  labelAlign: 'top',
		            	  name: 'installmentStatus',
		            	  readOnly:true,
		  				  value:'PENDING',
		            	  allowBlank: false
		              },{
	                      xtype: 'button',
                    	  glyph: ICONGLYPH.DELETEGLYPH,
                    	  cls: 'CustomBodyBtnReject',
                    	  tooltip: getCommonTranslation('DELETETOOLTIP'),
                    	  listeners:{
	                    		click:function(obj){
	                    			var frm = obj.ownerCt.ownerCt.ownerCt;
	                    			var installmentPanel = frm.down('#installmentPanel');
	                    			var container = obj.up('fieldcontainer');
	                    			installmentPanel.remove(container);
	                    			frm.doLayout();
	                    		}
	                    	}
	                    }]    
                 });

          var installmentPanel = form.down('#installmentPanel');
        	  installmentPanel.add(panelItem);
          form.doLayout();
      },
      //**********save installment data in temprary store***********
      saveInstallment : function(){
    	  
    	  var frm = this.getFeereqinstallmentWin();
    	  var form = frm.getForm();
    	  var value = form.getValues();
    	  
    	  var totalInstallmentAmount = 0;
    	  var myJson = new Array();
    	  if (!isEmpty(value["installmentDueDate"])) {
    		  var isArr = isArray(value["installmentDueDate"]);
    		  if (isArr == true) {
    			  for (var i = 0; i < value["installmentDueDate"].length; i++) {
    				  var obj = new Object();
    				  obj.installmentDueDate = value["installmentDueDate"][i];
    				  obj.installmentAmount = value["installmentAmount"][i];
    				  obj.installmentStatus = value["installmentStatus"][i];
    				  myJson.push(obj);
    				  totalInstallmentAmount = parseInt(totalInstallmentAmount) + parseInt(value["installmentAmount"][i]);
    			  }
    		  }else{
    			  var obj = new Object();
    			  obj.installmentDueDate = value["installmentDueDate"];
    			  obj.installmentAmount = value["installmentAmount"];
    			  obj.installmentStatus = value["installmentStatus"];
    			  myJson.push(obj);
    			  totalInstallmentAmount = value["installmentAmount"];
    		  }
    	  }
    	  
    	  if(value.amount == totalInstallmentAmount){
    		  var data = {"myJson" : myJson};
    		  var store = this.getStore('feeandpayment.feerequest.TempInstallmentData');
    		  store.loadRawData(data, true);
    		  this.getCloseInstallmentWindow();
    	  }else{
    		  showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('AMOUNT_AND_INSTALLMENT_AMOUNT_SHOULD_BE_EQUAL')); 
    	  }
      },
      
      //************** lock grids***************
      getLockedGrids : function(){
    	  var form = this.getFeereqsearchform();
    	  var concessionType  = form.down("#concessionType").getValue();
    	  if(concessionType=='INSTALLMENT'){
             this.getFeereqbillinstallmentgrid().getSelectionModel().setLocked(true);
    	  }
    	 },
      
      getLockedWaiverGrids : function(){
    	  var form = this.getFeereqsearchform();
    	  var concessionType  = form.down("#concessionType").getValue();
    	  if(concessionType=='INSTALLMENT'){
    	     this.getFeereqbillwaivergrid().getSelectionModel().setLocked(true);
    	  }
      },
      
      getSelectConcessionType : function(obj,record){
    	  
    	  var value = record[0].get("id");
    	  var structure = this.getFeerequeststructure();
    	  structure.down("#feereqbillwaivergrid").setVisible(false);
    	  structure.down("#feereqbillinstallmentgrid").setVisible(false);
    	 
    	  if(value=='INSTALLMENT'){
    		  structure.down("#feereqbillinstallmentgrid").setVisible(true);
    	  }else{
    		  structure.down("#feereqbillwaivergrid").setVisible(true);
    	  }
      },
      
      getSelectChooseAgainstAndConcessionType : function(obj,record){
    	  
    	  var form = this.getFeereqsearchform();
    	  var chooseAgainst =  form.down("#chooseAgainst").getValue();
    	  var concessionType = form.down("#concessionType").getValue();
    	 
    	  var futureGrid = this.getFeereqbillinstallmentgrid();
    	  var pendingGrid = this.getFeereqbillwaivergrid();
    	  
    	//  var futureGridModel = futureGrid.selModel.getSelection()[0];
     	 // var pendingGridModel = pendingGrid.selModel.getSelection()[0];
    	 
    	  pendingGrid.setVisible(false);
    	  futureGrid.setVisible(false);
    	  
    	  if(chooseAgainst=='FUTURE_BILLING'){
    		  
    		  futureGrid.setVisible(true);
    		  futureGrid.getSelectionModel().setLocked(false);
    		  futureGrid.getSelectionModel().deselectAll();
    		  
    		  if(concessionType=='FEE_CONCESSION'){
    			  futureGrid.columns[5].hide();
    			  futureGrid.columns[4].show();
    			 		  
    		  }else{
    			  futureGrid.columns[4].hide();
    			  futureGrid.columns[5].show();
    		  }

    	  }else if(chooseAgainst=='PENDING_BILLS'){
    		  
    		  pendingGrid.setVisible(true);
    		  pendingGrid.getSelectionModel().setLocked(false);
    		  pendingGrid.getSelectionModel().deselectAll();
    		  	
    		  if(concessionType=='FEE_CONCESSION'){
    			  pendingGrid.columns[6].hide();
    			  pendingGrid.columns[5].show();
    		  }else{
    			  pendingGrid.columns[5].hide();
    			  pendingGrid.columns[6].show();
    		  }
    	  }
      },
      
      //******* get id value json **********
      getIdValueJson: function(id, value) {
  		if (id) return {
  			id: id,
  			value: value
  		};
      }
});
