/**
 * This controller is used for the HR Recruitment Process Job  Application Posting
 * 
 * 
 * @author Ramkrsihna yadav
 */
Ext.define('Academia.controller.hrRecruitmentProcess.jobApplication.JobApplicationController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['common.FacultyTypeCSMStore','common.AllUserBySmartSearch','hrRecruitmentProcess.jobPosting.JobTitleComboStore',
    	'user.UserAcademyLocationStore','hrRecruitmentProcess.jobApplication.JobApplicationTitleComboStore',
		'department.DepartmentAcademyLocationWiseStore',
		'user.EmployeeTypeStore','common.DesignationTypeStore','course.CourseDepartmentStore',
		'common.CountryStore','common.EmployeeLanguageStore','common.ExamPassedStore',
		'hrRecruitmentProcess.jobApplication.JobApplicationGridStore',
		'hrRecruitmentProcess.jobApplication.JobApplicantionCodeComboStore','hrRecruitmentProcess.jobApplication.JobApplicantionNameComboStore',
         'hrRecruitmentProcess.jobApplication.jobApplicationStatusStore','common.MultiLanguageStore',
         'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
         'hrRecruitmentProcess.jobApplication.jobApplicationStatusStore','common.MultiLanguageStore',
         'hrRecruitmentProcess.jobApplication.JobApplicationEmployeeLangyageStore',
         'hrRecruitmentProcess.jobApplication.JobApplicationDocumentStore',
         'hostel.roomallocation.userwise.HostelDocumentStore','hrRecruitmentProcess.jobApplication.JobTitleJobAppComboStore',
         'hrRecruitmentProcess.jobApplication.jobApplicationWithoutApproveStatusStore',
         'hrRecruitmentProcess.jobApplication.JobApplicationLanguageGridStore',
         'hrRecruitmentProcess.jobApplication.JobApplicationExportTypeStore',
         'committee.committee.MessageTypeNotificationStore',
 		'messaging.MessagingTemplatesStore',
 		'messaging.StaticDocumentAttachmentGridStore',
 		
    ],
    views: ['hrRecruitmentProcess.jobApplication.JobApplicationStructure',
    		'hrRecruitmentProcess.jobApplication.JobApplicationTabStructure',
    		'hrRecruitmentProcess.jobApplication.JobApplicationFilter',
    		'hrRecruitmentProcess.jobApplication.UpdateJoiningStatusWin',
    		'hrRecruitmentProcess.jobApplication.JobApplicationGrid','hrRecruitmentProcess.jobApplication.JobApplicationDocumentWin',
    		'hrRecruitmentProcess.jobApplication.JobApplicationlDocumentGrid','hrRecruitmentProcess.jobApplication.JobApplicationLanguageCompentcyWin',
    		'hrRecruitmentProcess.jobApplication.JobApplicationlEmployeeCompentcyGrid','hrRecruitmentProcess.jobApplication.JobAppUpdateStatusWin','hrRecruitmentProcess.jobApplication.JobApplicationExportWindow',
    		'hrRecruitmentProcess.jobApplication.JobApplicationEmployeeSendMessages',
			'messaging.EmployeeJobPostingStaticDocumentAttachmentGrid'],
    
    models: ['hrRecruitmentProcess.jobPosting.JobApplicationGridModel','Academia.model.personinfo.common.documents.DocumentModel'],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
        ref: 'jobapplicationstructure',
        selector: 'jobapplicationstructure'
    }, {
        ref: 'jobapplicationtabstructure',
        selector: 'jobapplicationtabstructure'
    }, {
        ref: 'jobapplicationfilter',
        selector: 'jobapplicationfilter'
    }, {
        ref: 'jobapplicationgrid',
        selector: 'jobapplicationgrid'
    }, {
        ref: 'updatejoiningstatuswin',
        selector: 'updatejoiningstatuswin'
    }, {
        ref: 'jobappupdatestatuswin',
        selector: 'jobappupdatestatuswin'
    }, {
        ref: 'jobapplicationlanguagecompentcywin',
        selector: 'jobapplicationlanguagecompentcywin'
    }, {
        ref: 'jobapplicationlemployeecompentcygrid',
        selector: 'jobapplicationlemployeecompentcygrid'
    }, {
        ref: 'jobapplicationdocumentwin',
        selector: 'jobapplicationdocumentwin'
    }, {
        ref: 'jobapplicationldocumentgrid',
        selector: 'jobapplicationldocumentgrid'
    },
    {
		ref: 'jobApplicationExportWindow',
		selector: 'jobApplicationExportWindow'
	}
	,{
		ref : 'jobapplicationemployeesendmessages',
		selector : 'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows]'	
	},{
    	ref :'employeeDocumentMessageAttachmentGrid',
    	selector : 'employeejobpostingstaticdocumentattachmentgrid [itemId=employeeStaticDocumentAttachmentGridMessage]'
    }],
    config: {
    	FACULTY_JOB_APPLICATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_JOB_APPLICATION_PRIVILEGES'),
    },
    init: function() {
        this.control({
          'jobapplicationfilter button[itemId=searchBtnJobApplicationItemId]':{
    			click: this.loadJobApplocationGrid
    		},
    		'jobapplicationfilter button[itemId=resetBtnJobApplicationItemId]':{
    			click: this.resetJobApplicationFilterForm
    		},
    		'jobapplicationgrid button[itemId=updateJoiningStatus]':{
    			click: function() {
    				var $this = this;
    				var grid = this.getJobapplicationgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					 var record = grid.getSelectionModel().getSelection()[0];
    					var formWindow = $this.getUpdatejoiningstatuswin();
    					if (!formWindow) {
    						Ext.widget('updatejoiningstatuswin');
    						formWindow = $this.getUpdatejoiningstatuswin();
    					}
    					var form = formWindow.down('#updateJoiningStatusFormItemId');
    					var confirmedById = form.down('#confirmedById');
    					formWindow.show();
    					form.down('#joiningDateId').setValue(new Date());
    					form.down('#academyLocationId').setValue(record.get('academyLocation'));
    					form.down('#jobTitleId').setValue(record.get('jobTitle'));
    					form.down('#designationId').setValue(record.get('designationName'));
    				} else {
    					showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
    				}
    			}
    		},
    		'jobapplicationgrid button[itemId=updateStatus]':{
    			click: function() {
    				var $this = this;
    				var grid = this.getJobapplicationgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					for(var i=0;i<grid.getSelectionModel().getCount();i++){
    						var selectedRecord = grid.getSelectionModel().getSelection()[i];
    						var id = selectedRecord.get('id');
    						

    						
    					}
    					 var record = grid.getSelectionModel().getSelection()[0];
    					var formWindow = $this.getJobappupdatestatuswin();
    					if (!formWindow) {
    						Ext.widget('jobappupdatestatuswin');
    						formWindow = $this.getJobappupdatestatuswin();
    					}
    					var form = formWindow.down('#jobAppUpdateStatusWinFormItemId');
    					var jobApplicationStatus = form.down('#jobApplicationStatus').setValue(record.get('jobApplicationStatus'));
    					var DateId = form.down('#DateId').setValue(new Date());
    					var remark = form.down('#remark').setValue(record.get('remarks'));
    					formWindow.show();
    					
    				} else {
    					showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
    				}
    			}
    		},
    		'jobappupdatestatuswin button[itemId=canceljobappupdatestatusWinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getJobappupdatestatuswin();
                    formWindow.close();
                    }
                },
    		'updatejoiningstatuswin button[itemId=cancelJoiningStatusWinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getUpdatejoiningstatuswin();
                    formWindow.close();
                }
            },
            'updatejoiningstatuswin button[itemId=saveJoiningStatusWinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getUpdatejoiningstatuswin();
                    var grid = $this.getJobapplicationgrid();

                    var jsonArry = [];
                    
                    for(var i=0;i<grid.getSelectionModel().getCount();i++){
        				var selectedRecord = grid.getSelectionModel().getSelection()[i];
        				var id = selectedRecord.get('id');
        				var form = formWindow.down('#updateJoiningStatusFormItemId');
                        var formValues = form.getValues();

                        var obj = new Object();
                        obj.id = id;
                        obj.markAsEmployee = formValues.chkMarkAsAcademyEmp;
                        obj.confirmedBy = {
                        		 "id": formValues.confirmedBy
                        }
                        obj.applicationStatusDate = formValues.joiningDate;
                        jsonArry.push(obj);
                        

        			}
                    
                    
                    
                    var formData = Ext.encode(jsonArry);
                    
                    $this.applyWindowMask(); 
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_UPDATE_JOINING_STATUS,
                        jsonData: formData,
                        method: 'POST',
                        success: function(frm, action) {
                            $this.hideWindowMask();
                            $this.resetPageSetting(grid.getStore());
                            grid.getStore().reload();
                            grid.getSelectionModel().deselectAll();
                            showSuccessMessage(getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                            formWindow.close();
                        }
                    });
                }
            },
            'jobappupdatestatuswin button[itemId=savejobappupdatestatusWinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getJobappupdatestatuswin();
                    var grid = $this.getJobapplicationgrid();
                    var jsonArry = [];
                    for(var i=0;i<grid.getSelectionModel().getCount();i++){
        				var selectedRecord = grid.getSelectionModel().getSelection()[i];
        				var id = selectedRecord.get('id');
        				        			

                      //  var id = record.get("id");

                        var form = formWindow.down('#jobAppUpdateStatusWinFormItemId');
                        var formValues = form.getValues();

                      
                        
                        var obj = new Object();
                        obj.id = id;
                        obj.remarks = formValues.remark;
                        
                        obj.jobApplicationStatus = formValues.jobApplicationStatus
                        obj.applicationStatusDate = formValues.date;
                        jsonArry.push(obj);
                        

        			}
                    var formData = Ext.encode(jsonArry);
                    $this.applyWindowMask(); 
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_UPDATE_APPLICATION_STATUS,
                        jsonData: formData,
                        method: 'POST',
                        success: function(frm, action) {
                            $this.hideWindowMask();
                            $this.resetPageSetting(grid.getStore());
                            grid.getStore().reload();
                            grid.getSelectionModel().deselectAll();
                            showSuccessMessage(getCommonTranslation('UPDATE_STATUS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                            formWindow.close();
                        }
                    });
                }  
             },
            'jobapplicationldocumentgrid': {
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        var $this = this;
                        var grid = $this.getJobapplicationldocumentgrid();
                        var record = grid.getSelectionModel().getSelection()[0];
                      if (columnName == "name") {
                            var this$ = this;
                            var documentId =null;
                            if(null!=record.data)
                             {
                             documentId=record.data.id
                             }
                           if (!isNullOrEmpty(documentId)) {
                                if (e.target.tagName == 'A') {
                                    this$.getDocumentController().downloadDocumentFile(documentId);
                                }
                            }

                        }
                    }
                }
             },
    		
    		'jobapplicationgrid': {
      			
               cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var jobApplicationGridlist = this.getJobapplicationgrid();
					var columnName=jobApplicationGridlist.columnManager.columns[cellIndex].dataIndex;
					  var updateStatus  =  jobApplicationGridlist.down("#updateStatus");
	                   var updateJoiningStatus=jobApplicationGridlist.down("#updateJoiningStatus");
	               	var currentStatus = record.get("jobApplicationStatus");
					if(columnName=='identityDetails'){
						if (e.target.tagName == 'A') {
							this.showJobApplicationDocumentGridDetails(grid,record);
						}
					}
				if(columnName=='language'){
						if (e.target.tagName == 'A') {
							this.showJobApplicationLanguageGridDetails(grid,record);
						}
					}
					if(currentStatus=="APPROVED"){
					//	checkOutBtn.setDisabled(true);
						updateStatus.setDisabled(true);
						updateJoiningStatus.setDisabled(true);
					}else{
						updateStatus.setDisabled(false);
						updateJoiningStatus.setDisabled(false);
						
					}
					
				}},
				 'jobapplicationgrid  button[itemId=exportJobApplicationReport]': {
	              	   click: function(obj) {
	                    	 var grid = this.getJobapplicationgrid();
	                         if (grid.getSelectionModel().getCount() > 0) {
	                      	  var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                      	 var jobCode =  selectedRecord.data.jobCode;
	                      	 var openwin=false;
	                      	   for(var i=0;i<grid.getSelectionModel().getCount();i++){
	                 				var selectedRecord = grid.getSelectionModel().getSelection()[i];
	                 				if(jobCode==selectedRecord.data.jobCode){
	                 					openwin=true;
	                 				
	                 				}else{
	                 					openwin=false;
	                 					break;
	                 				}
	                 				   }
	                      	 if(openwin==true){
		                      	   this.openApplicationReportExportWin();
		                      	   
		                         }else{
		            					
		             					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_JOB_POSTING_TO_DOWNLOAD_REPORT'));
		             				}
	                            
	                             } else {
	                          	   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                     } 
	                         
	                    	   }
	                       },
                 'jobApplicationExportWindow button[itemId=submitBtn]': {
              	   click: function(btn) {
              		   this.exportXlsJobApplicantList();
              	   }
                 },
       	 'jobapplicationtabstructure' :  {
			 afterrender : function(structure){
				 var $this = this;
				 structure.body.on('scroll', function(e, target) {
	   				  var pcstructure = structure.down("jobapplicationgrid");
	   				  var academyLocationId = $this.getCurrentAcademyLocation();
	   				  var grid = null;
	   				  
	   				  if(!pcstructure.isHidden()){
	   					  grid = pcstructure;
	   				  }
	   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
					 });
			 }
       	 }, 'jobapplicationgrid button[itemId=sendMessageBtn]':{
				click:function(){
					this.openEmployeeSendMessage();
				}
			},'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows] radiogroup[itemId=messageType]':{
				change : function(val,nV,oV){
					this.selectSectionMessageType(val,nV,oV);
				}
			},
			'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows] customcombobox[itemId=empMsgTempletId]':{
				select : function(obj,rec){
					this.selectMessageTemp(obj,rec);
				}
			},
			'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows] textarea[itemId=empPushNotificationDiscription]':{
				change : function(val,nV,oV){
					var employeeSendMessages =  this.getJobapplicationemployeesendmessages();
					var pushTextField = employeeSendMessages.down('#empPushNotificationDiscription');
					var pushTextFieldDiscription = employeeSendMessages.down('#empPushNotificationDiscriptionNotice');
					var maxLength = 1000;
					var newValue = maxLength - pushTextField.getValue().length;
					pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
				}
			},
			'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows] button[itemId=empAdhocMsgSubmitBtn]':{
				click: function(obj) {
					var grid = this.getJobapplicationgrid();
					var employeesendmessage =  this.getJobapplicationemployeesendmessages();
					var formPnl = obj.up('form');
					var isMySelfChecked = false;
					var fldValues = formPnl.getForm().getFieldValues();
					isMySelfChecked = fldValues.empRecieverType;
					if(fldValues.empRecieverType[0] == false ){
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
						return;
					}
					var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
					var empWsMsgEventRecipientConfigsUpdated = [];
					/*var empWsMsgEventRecipientConfigsUpdated = [{ 
						                           	 	msgRecipientTypeId: 500,
						                           	 	msgTemplateConfigId: 0,	//formData.id, 
						                           	 	selectiveRecipientIds: [] 
						                            },{ 
						                           	 	msgRecipientTypeId: 600,
						                           	 	msgTemplateConfigId: 0,	//formData.id, 
						                           	 	selectiveRecipientIds: [] 
						                            }];*/

					var formData = obj.up('form').getValues();

					var sendMessageToOptions = formData.empRecieverType;
					var isStudentChecked = false;
					var isParentChecked = false;
					var isFeePayerChecked = false;

					if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
						if(sendMessageToOptions.constructor === Array){
							if(sendMessageToOptions.length > 0){
								sendMessageToOptions.forEach(function(current_value, index, initial_array) {
									if(current_value == 1 || current_value == '1'){
										isStudentChecked = true;
									}
									if(current_value == 2 || current_value == '2'){
										isParentChecked = true;
									}
									if(current_value == 3 || current_value == '3'){
										isFeePayerChecked = true;
									}
								});
							}
						}else{
							if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
								isStudentChecked = true;
							}
							if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
								isParentChecked = true;
							}
							if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
								isFeePayerChecked = true;
							}
						}
					}

					//var abc = xyz.c;

					if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
						//empWsMsgEventRecipientConfigsUpdated = [];
						employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
					}else{
						var recipientIds;
						if(grid.xtype == 'jobapplicationgrid'){
							recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
							recipientIds = Ext.encode(recipientIds);
							//typeId = 2;
							//recipientId = 2;
						}

						var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

						if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
							// Ajax Call to get Parent Ids by Admission Ids

							Ext.Ajax.request({
								type: 'rest',
								url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
								jsonData: RecipientTypeCodes,
								method: 'POST',
								success: function(response) {
									var RecipientTypeCodesData = Ext.decode(response.responseText);

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
										jsonData: recipientIds,
										method: 'POST',
										success: function(response) {
											// update empWsMsgEventRecipientConfigsUpdated with parent ids
											var empWsMsgEventRecipientConfigsParents = {
													msgRecipientTypeId: 66,
													msgTemplateConfigId: 0,	//formData.id, 
													selectiveRecipientIds: []
											};
											if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
												empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
											}
											empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
											empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);

											// Ajax Call to get Fee Payer Ids by Admission Ids
											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
													var empWsMsgEventRecipientConfigsFeePayer = {
															msgRecipientTypeId: 67,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};

													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
														empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
													}

													empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
													empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
													employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
												}
											});
										}
									});
								}
							});
						}else{ // Only one checkbox is selected
							var urlNew = '';
							if(isParentChecked) { // If Parent checkbox is selected
								// url for getting parent ids
								urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
							}
							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
								// url for getting fee payer ids
								urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
							}

							Ext.Ajax.request({
								type: 'rest',
								url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
								jsonData: RecipientTypeCodes,
								method: 'POST',
								success: function(response) {
									var RecipientTypeCodesData = Ext.decode(response.responseText);

									Ext.Ajax.request({
										type: 'rest',
										url: urlNew,
										jsonData: recipientIds,
										method: 'POST',
										success: function(response) {
											if(isParentChecked) { // If Parent checkbox is selected
												// update empWsMsgEventRecipientConfigsUpdated with parent ids
												var empWsMsgEventRecipientConfigsParents = {
														msgRecipientTypeId: 66,
														msgTemplateConfigId: 0,	//formData.id, 
														selectiveRecipientIds: []
												};
												if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
													empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
												}
												empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
												empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);
											}
											if(isFeePayerChecked) { // If Fee Payer checkbox is selected
												// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
												var empWsMsgEventRecipientConfigsFeePayer = {
														msgRecipientTypeId: 67,
														msgTemplateConfigId: 0,	//formData.id, 
														selectiveRecipientIds: []
												};
												if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
													empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
												}
												empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
												empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
											}
											employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
										}
									});
								}
							});

						}
						//employeesendmessage.sendMessage(obj,grid);
					}

				}
			},
			/*V2D-13247*/
			'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows] textarea[itemId=empSmsDiscription]':{
				change : function(val,nV,oV){
					var employeesendmessage =  this.getJobapplicationemployeesendmessages();
					var smsTextField = employeesendmessage.down('#empSmsDiscription');
					var smsTextFieldDiscription = employeesendmessage.down('#empSmsDiscriptionNotice');
					var maxLength = localStorage.getItem('maxLength');
					var newValue = maxLength - smsTextField.getValue().length;
					smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
				}
			},'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows]  filefield[itemId=empStaticUploadFileField]': {
				change: function(fileField, value, eOpts){
					var this$ = this;
					//value = value.replace('C:\\fakepath\\', '');
					var form=this$.getJobapplicationemployeesendmessages();
					var empSubject = form.down('#empSubject').getValue();
					if(isNullOrEmpty(empSubject)){
						form.down('#empSubject').setValue(' ');
					}
					this$.uploadEmployeeStaticDocumentFileMessage(fileField, value, eOpts);
				}
			}, 'employeejobpostingstaticdocumentattachmentgrid[itemId=employeeStaticDocumentAttachmentGridMessage] actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows]': {
				render: function(grid){
					var this$ = this;
					var docGrid = grid.down('#employeeStaticDocumentAttachmentGridMessage');
					docGrid.getStore().removeAll();
					docGrid.getStore().sync();
				}
			}, 'jobapplicationemployeesendmessages[itemId=employeeListSendMessageWindows] radiogroup#empSendingPriority': {
				change: function( radio, newValue, oldValue, eOpts) {
					this.loadStudentScheduleField(radio, newValue, oldValue);
				}
			}
     }); 
 },
    loadJobApplocationGrid: function(){
    	var $this=this;
    	var form = $this.getJobapplicationfilter().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getJobapplicationgrid();
    	var store = grid.getStore();
    	var startDate=form.findField('fromDate').getValue();
    	if(!isNullOrEmpty(startDate)){
    		startDate = startDate.getTime();
    	}
    	var tillDate=form.findField('tillDate').getValue();
    	if(!isNullOrEmpty(tillDate)){
    		tillDate = tillDate.getTime();
    	}
    	 store.getProxy().extraParams= {
    		 academyLocationId:formValue.academyLocationId,
    		 applicationCode:formValue.jobCode,
    		 applicantName:formValue.jobApplicationName,
    		jobTitle:formValue.jobTitle,
    		applicationStatus:formValue.jobApplicationStatus,
    		emailId:formValue.EMAIL_ID,
    		mobileNumber:formValue.MOBILE_NO,
    		designationId:formValue.designationCombo,
    		departmentId:formValue.departmentId,
    		experience:formValue.yearsOfExperience,
    		qualificationId:formValue.highestQualification,
    		noticePeriod:formValue.noticePeriod,
    		languageId:formValue.employeeLanguage,
    		countryId:formValue.COUNTRY_ID,
    		fromDate:startDate,
    		toDate :tillDate,
    	};
    	grid.getSelectionModel().deselectAll();
    	$this.resetGridSetting(grid);
    	$this.resetPageSetting(store);
    	store.load();
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = $this.getJobapplicationfilter();
    
    }, 
    resetJobApplicationFilterForm: function() {
    	var $this = this;
    	var filter = $this.getJobapplicationfilter().getForm();
    	filter.reset();
    	var startDateId = filter.findField('fromDate'),
    	endDateId = filter.findField('tillDate');
    	startDateId.setMinValue(false);
    	endDateId.setMinValue(false);
    	startDateId.setMaxValue(false);
    	endDateId.setMaxValue(false);
    },
    showJobApplicationDocumentGridDetails:function(grid,record){
		var $this = this;
		var formWindow = $this.getJobapplicationdocumentwin();
		if (!formWindow) {
			formWindow=	Ext.widget('jobapplicationdocumentwin');
			//formWindow = $this.getHosteldocumentgriddetailswin();
		}
		var id=null;
		// var allotmentsIds=[];
		// formWindow.show();
		 var documentId=[];
		 formWindow.show();
		 for(var i=0; i< record.data.identityDetails.length;i++){
			 if(!isNullOrEmpty(record.data.identityDetails[i].documents[0])){
				 id=record.data.identityDetails[i].documents[0].id;
				 documentId.push(id);
			 }
		 }
		   
		 if(!isNullOrEmpty(documentId[0])){
			var store = $this.getJobapplicationldocumentgrid().getStore();
			store.getProxy().extraParams = {
				documentIds:documentId
			};
			store.load();
		 }

	},
	showJobApplicationLanguageGridDetails:function(gridData,record){
		var $this = this;
		var formWindow = $this.getJobapplicationlanguagecompentcywin();
		if (!formWindow) {
			formWindow=	Ext.widget('jobapplicationlanguagecompentcywin');
		}
		var grid = $this.getJobapplicationlemployeecompentcygrid();
		
		$this.resetPageSetting(grid.getStore());
		var id = record.data.applicantId;
		grid.getStore().getProxy().extraParams={
			applicantId:id
		};
		grid.getStore().load();
		formWindow.show();

	    },
	getDocumentController : function(){
	    var this$ = this;
	    return this$.getController('Academia.controller.document.DocumentController');
	   },
	   openApplicationReportExportWin: function() {
	    	var $this = this;
	    	var win = $this.getJobApplicationExportWindow();
			if(!win){
				win = Ext.widget('jobApplicationExportWindow');
			}
			win.show();
			
			var  exportTypeIdField = win.down("#jobApplicationexportTypeId");
			var store = exportTypeIdField.getStore();
		//	store.load();
			var allStoreData = [];
			store.on('load', function(records, operation, success){
            var recordLength=records.data.items.length;
             for(i in records.data.items){
            		allStoreData.push({
            			id:records.data.items[i].data.id,
    					value : records.data.items[i].data.value,
    					code :  getPortalSetupNew(records.data.items[i].data.code)
    				});   
            	
             }
         
             store.removeAll();
			 store.add(allStoreData);
			}, store, { single : true });
			
			//store.load();
	    },
	    exportXlsJobApplicantList: function(){
	    	var $this = this;
	    	var exportType = $this.getJobApplicationExportWindow().down("#jobApplicationexportTypeId");
	    	var form = $this.getJobapplicationfilter().getForm();
	    	var values = form.getValues();
	    	var reportParams = new Object();
	    	var admParams = [];
	  /*  	userId = form.findField('ADMISSION_NUMBER').getValue();
	    	userStore=form.findField('ADMISSION_NUMBER').getStore();
	    	if(!isNullOrEmpty(userStore.findRecord('id',userId))){
	    		admissionCode = userStore.findRecord('id',userId).data.code;
	    		reportParams.admissionCode = admissionCode;
	    	} else {
	    		reportParams.admissionCode = null;
	    	}*/
	    	reportParams.COUNTRY_ID = values.COUNTRY_ID;
	    	reportParams.EMAIL_ID = values.EMAIL_ID;
	    	reportParams.MOBILE_NO = values.MOBILE_NO;
	    	reportParams.academyLocationId = values.academyLocationId;
	    	reportParams.departmentId = values.departmentId;
	    	reportParams.employeeLanguage = values.employeeLanguage;
	    	reportParams.fromDate = values.fromDate;
	    	reportParams.highestQualification = values.highestQualification;
	    	reportParams.jobApplicationName = values.jobApplicationName;
	    	reportParams.jobApplicationStatus = values.jobApplicationStatus;
	    	reportParams.jobCode = values.jobCode;
	    	reportParams.jobTitle = values.jobTitle;
	    	reportParams.noticePeriod = values.noticePeriod;
	    	reportParams.tillDate = values.tillDate;
	    	reportParams.yearsOfExperience = values.yearsOfExperience;
	    	
	    	 var grid = this.getJobapplicationgrid();
	    	    var applicationsArray=[];
	    	    var record = grid.getSelectionModel().getSelection();
	    	    for(var i in record) {
	    	    applicationsArray.push(record[i].data.id);
	    	    }
	    	    var applicationIds = applicationsArray.join(',');
	    	    reportParams.applicationIds = applicationIds;
	    	
	    	if(exportType.value == 'STEP3_EDUCATION_BACKGROUND'||exportType.value == 'Educational Background'){
	    	    reportHeader = "Education Details Report";
	    	    reportTitle = "Education Details Report";
	    	    code = 'EDUCATION_DETAILS_REPORT';
	    	    reportParams.code = code;
	    	    reportParams.status = values.STATUS;
	    	    reportParams.headerName = reportHeader;
	    	    var gridData = grid.getStore().data.items;
	    	    if(gridData.length>0) {
	    	    $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_EDUCATION);
	    	    } else {
	    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
	    	}
	    	    } else if(exportType.value == 'STEP1_PERSTONAL_DETAILS'||exportType.value == 'Personal Details'){
	    	    reportHeader = "Applicant personal details Report";
	    	    reportTitle = "Applicant personal details Report";
	    	    code = 'APPLICANT_PERSONAL_DETAILS_REPORT';
	    	    reportParams.code = code;
	    	    reportParams.status = values.STATUS;
	    	    reportParams.headerName = reportHeader;
	    	    var gridData = grid.getStore().data.items;
	    	    if(gridData.length>0) {
	    	    $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_PERSONAL_DETAILS);
	    	    } else {
	    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
	    	}
	    	    }
	    	    else if(exportType.value == 'STEP2_CONTACT_DETAILS'||exportType.value == 'Contact Details'){
		    	    reportHeader = "Applicant personal details Report";
		    	    reportTitle = "Applicant Contact details Report";
		    	    code = 'APPLICANT_CONTACT_DETAILS_REPORT';
		    	    reportParams.code = code;
		    	    reportParams.status = values.STATUS;
		    	    reportParams.headerName = reportHeader;
		    	    var gridData = grid.getStore().data.items;
		    	    if(gridData.length>0) {
		    	    $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_CONTACT_DETAILS);
		    	    } else {
		    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
		    	}
		    	    } else if(exportType.value == 'STEP4_WORK_EXPERIENCE'||exportType.value == 'Work Experience'){
			    	    reportHeader = "Applicant Work Experience Report";
			    	    reportTitle = "Applicant Work Experience Report";
			    	    code = 'APPLICANT_WORK_EXPERIENCE_REPORT';
			    	    reportParams.code = code;
			    	    reportParams.status = values.STATUS;
			    	    reportParams.headerName = reportHeader;
			    	    var gridData = grid.getStore().data.items;
			    	    if(gridData.length>0) {
			    	    $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_WORK_EXPERIENCE_DETAILS);
			    	    } else {
			    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
			    	}
			    	    }/*else if(exportType.value == 'STEP5_IDENTITY_DOCUMENTS'||exportType.value == 'Identity Documents'){
				    	    reportHeader = "Applicant Identity Documents Report";
				    	    reportTitle = "Applicant Identity Documents Report";
				    	    code = 'APPLICANT_IDENTITY_DOCUMENTS_REPORT';
				    	    reportParams.code = code;
				    	    reportParams.status = values.STATUS;
				    	    reportParams.headerName = reportHeader;
				    	    var gridData = grid.getStore().data.items;
				    	    if(gridData.length>0) {
				    	    $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_EDUCATION);
				    	    } else {
				    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
				    	}
				    	    }*/else if(exportType.value == 'STEP6_OTHER_INFORMATION'||exportType.value == 'Other Information'){
					    	    reportHeader = "Applicant Other Information Report";
					    	    reportTitle = "Applicant Other Information Report";
					    	    code = 'APPLICANT_OTHER_INFORMATION_REPORT';
					    	    reportParams.code = code;
					    	    reportParams.status = values.STATUS;
					    	    reportParams.headerName = reportHeader;
					    	    var gridData = grid.getStore().data.items;
					    	    if(gridData.length>0) {
					    	    	$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_OTHER_INFORMATION);
					    	    } else {
					    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
					    	}
					    	    }else if(exportType.value == 'STEP32_NON_ACADEMIC_TOPICS'||exportType.value == 'Non academic topics'){
						    	    reportHeader = "Applicant Non academic topics Report";
						    	    reportTitle = "Applicant Non academic topics Report";
						    	    code = 'APPLICANT_NON_ACADEMIC_TOPICS_REPORT';
						    	    reportParams.code = code;
						    	    reportParams.status = values.STATUS;
						    	    reportParams.headerName = reportHeader;
						    	    var gridData = grid.getStore().data.items;
						    	    if(gridData.length>0) {
						    	    	$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_NON_ACADEMIC);
						    	    } else {
						    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
						    	}
						    	    }else if(exportType.value == 'STEP17_REFERENCES'||exportType.value == 'References'){
							    	    reportHeader = "Applicant References Report";
							    	    reportTitle = "Applicant References Report";
							    	    code = 'APPLICANT_REFERENCES_REPORT';
							    	    reportParams.code = code;
							    	    reportParams.status = values.STATUS;
							    	    reportParams.headerName = reportHeader;
							    	    var gridData = grid.getStore().data.items;
							    	    if(gridData.length>0) {
							    	    $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_GENERATE_EXCEL_REPORT_FOR_JOB_APPLICANT_REFERENCE_DETAILS);
							    	    } else {
							    	    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
							    	}
							    	    }
	    	
	    	$this.getJobApplicationExportWindow().close();
	    }, openEmployeeSendMessage:function(obj){

			var grid = this.getJobapplicationgrid();
			if(grid.getSelectionModel().getCount()>0) {

				var $this=this;
				var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
				var structure = Ext.widget('jobapplicationemployeesendmessages',{
					itemId:'employeeListSendMessageWindows'
				});
				var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				var formWindowTab = $this.getJobapplicationemployeesendmessages();
				formWindowTab.down("#empSelectTemplate").allowBlank=true;
				formWindowTab.down("#empSelectTemplate").setVisible(false);
				formWindowTab.down("#empMessageName").allowBlank=true;   
				formWindowTab.down("#empMessageName").setVisible(false);
				var templateStore = formWindowTab.down('#empSelectTemplate').getStore();
				templateStore.getProxy().extraParams={
					msgRecipientTypeId:2
				};
				templateStore.load();

				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=JobPosting539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
					headers : {
						'Content-Type' : 'application/json'
					},
					success : function(form,action) {
						var data = Ext.JSON.decode(form.responseText);
						formWindowTab.down("#id").setValue(data.id);
						formWindowTab.down("#code").setValue(data.code);
						formWindowTab.down("#empTemplateConfigName").setValue(data.templateConfigName);
						formWindowTab.down("#empMsgSubCategoryId").setValue(data.msgSubCategoryId);
						formWindowTab.down("#empMsgCategoryId").setValue(data.msgCategoryId);
						Ext.getBody().unmask();

						//grid.getStore().reload();
						//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
					}

				});
				openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
				/*if (!formWindow) {
			    				Ext.widget('jobapplicationemployeesendmessages');
			    				formWindow = $ this.getJobapplicationemployeesendmessages();
			    			}
			    			formWindow.show(;*/

			} else {
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
		},
		selectMessageTemp: function(obj,rec){
			var $this =  this;
			var formWin = $this.getJobapplicationemployeesendmessages();
			var empSubject = formWin.down('#empSubject');
			var smsDiscription = formWin.down('#empSmsDiscription');
			var smsDiscriptionNotice = formWin.down('#empSmsDiscriptionNotice');
			var pushNotificationDiscription = formWin.down('#empPushNotificationDiscription');
			var pushNotificationDiscriptionNotice = formWin.down('#empPushNotificationDiscriptionNotice');
			if(rec[0].data.value == "SMS")
			{  
				this.setAllowBlank (formWin.down("#empSubject"),true);
				//formWin.down("#empSubject").allowBlank=true;
				formWin.down("#empSubject").hide();
				formWin.down("#empStaticUploadFileField").hide();
				formWin.down("#employeeDocumentMessageAttachmentGrid").hide();
				formWin.down('#empDiscriptionId').reset();
				formWin.down('#empDiscriptionId').hide();	       		 
				formWin.down('#empSubject').reset();
				formWin.down('#empSmsDiscription').show();
				formWin.down('#empSmsDiscriptionNotice').show();
				pushNotificationDiscription.hide();
				pushNotificationDiscriptionNotice.hide();
				pushNotificationDiscription.reset();
			}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
				      		 empSubject.show();
				      		 formWin.down("#empStaticUploadFileField").hide();
				      		 this.setAllowBlank(empSubject,false);
				      		 formWin.down("#employeeDocumentMessageAttachmentGrid").hide();
				      		 formWin.down('#empDiscriptionId').reset();
				      		 formWin.down('#empDiscriptionId').hide();
				      		 empSubject.reset();
				      		 smsDiscription.reset();
				      		 smsDiscription.hide();
				      		 empSmsDiscriptionNotice.hide();
				      		 pushNotificationDiscription.reset();
				      		 pushNotificationDiscription.show();
				      		 pushNotificationDiscriptionNotice.show();
				      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
				      		 //formWin.down('#smsDiscription')
				      	 }*/else{
				      		 formWin.down('#empDiscriptionId').reset();
				      		 formWin.down('#empSmsDiscription').reset();
				      		 formWin.down('#empSmsDiscription').hide();
				      		 formWin.down('#empSmsDiscriptionNotice').hide();
				      		 formWin.down("#empStaticUploadFileField").show();
				      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
				      		 formWin.down("#employeeDocumentMessageAttachmentGrid").show();
				      		 formWin.down("#empSubject").reset();
				      		 formWin.down("#empSubject").show();
				      		 this.setAllowBlank (formWin.down("#empSubject"),false);
				      		 //formWin.down("#empSubject").allowBlank=false;
				      		 formWin.down('#empDiscriptionId').show();
				      		pushNotificationDiscription.hide();
				      		pushNotificationDiscriptionNotice.hide();
				      		pushNotificationDiscription.reset();
				      	 }
		},
		selectSectionMessageType : function(val,nV,oV){

			var $this =  this;
			var formWin = $this.getJobapplicationemployeesendmessages();

			//var value = nV.1;
			formWin.down('#empRecieverTypeIncludeMySelf').setValue(false);
			if(nV.messageType==2){
				formWin.down("#empMessageId").hide();
				formWin.down("#empSelectTemplate").allowBlank=true;
				formWin.down("#empSelectTemplate").setVisible(false);     		 
				formWin.down("#empMessageName").allowBlank=true;   
				formWin.down("#empMessageName").setVisible(false);
				formWin.down("#empMsgTempletId").setVisible(true);
				formWin.down("#empMsgTempletId").allowBlank=false;
				formWin.down("#empMsgTempletId").reset();
				formWin.down("#empSubject").setVisible(true);
				//formWin.down("#empSubject").allowBlank=false;
				formWin.down("#empSubject").reset();
				formWin.down("#empDiscriptionId").setVisible(true);
				formWin.down("#empDiscriptionId").reset();
				formWin.down('#empSmsDiscription').reset();
				formWin.down('#empSmsDiscription').hide();
				formWin.down('#empSmsDiscriptionNotice').hide();
				formWin.down('#empPushNotificationDiscription').hide();
				formWin.down('#empPushNotificationDiscriptionNotice').hide();
				formWin.down('#empRecieverTypeIncludeMySelf').setVisible(true);
				this.setAllowBlank (formWin.down("#empSubject"),false);
			}else{
				formWin.down("#empMsgTempletId").allowBlank=true;
				formWin.down("#empMsgTempletId").setVisible(false);     		
				formWin.down("#empMessageId").setVisible(true);
				formWin.down("#empSelectTemplate").setVisible(true);     		
				formWin.down("#empMessageName").setVisible(true);
				formWin.down("#empMessageName").reset();
				//formWin.down("#empSubject").allowBlank=true;
				this.setAllowBlank (formWin.down("#empSubject"),true);
				formWin.down("#empSubject").setVisible(false);
				formWin.down("#empDiscriptionId").setVisible(false);
				formWin.down("#empMessageName").allowBlank=false;  
				formWin.down("#empSelectTemplate").allowBlank=false;
				formWin.down("#empSelectTemplate").reset();
				formWin.down("#employeeDocumentMessageAttachmentGrid").setVisible(false);
				formWin.down("#empStaticUploadFileField").setVisible(false);
				formWin.down('#empSmsDiscription').reset();
				formWin.down('#empSmsDiscription').hide();
				formWin.down('#empSmsDiscriptionNotice').hide();
				formWin.down('#empPushNotificationDiscription').hide();
				formWin.down('#empPushNotificationDiscriptionNotice').hide();
				formWin.down('#empRecieverTypeIncludeMySelf').setVisible(false);
				this.setAllowBlank (formWin.down("#empMessageName"),false);
				this.setAllowBlank (formWin.down("#empSelectTemplate"),false);
				// var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
				// formWin.down("#empMessageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
				//formWin.down("#empSelectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
			}
		},   
		loadStudentScheduleField : function(radio,newValue, oldValue){
			var adhocMessageForm = radio.up('form');
			var scheduleDateField = adhocMessageForm.down('#empScheduleDate');
			var scheduleTimeField = adhocMessageForm.down('#empScheduleTime');
			var radioValue = radio.getValue().empSendingPriority;

			if(radioValue=='IMMEDIATE'){
				scheduleDateField.setVisible(false);
				scheduleDateField.setDisabled(true);
				scheduleTimeField.setVisible(false);
				scheduleTimeField.setDisabled(true);    		
			}
			else if(radioValue=='SCHEDULE'){
				scheduleDateField.setVisible(true);
				scheduleDateField.setDisabled(false);
				scheduleTimeField.setVisible(true);
				scheduleTimeField.setDisabled(false);
			}
		}, 
		loadGridWithFileNameMessage:function(grid,value,store){
	    	   grid.bindStore(store);
	       },
		  /**
	        * upload static document file for Student
	        */
	       uploadEmployeeStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	    	   var this$ = this;
	    	   var setupForm = fileField.up('jobapplicationemployeesendmessages');
	    	   var grid = setupForm.down('#employeeStaticDocumentAttachmentGridMessage');
	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	    	   fileField.setRawValue(fileUploadPath);
	    	   var file = fileField.fileInputEl.dom.files[0];
	    	   fileField.setRawValue(fileUploadPath);
	    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
	    		   if(!isNullOrEmpty(fileUploadPath)){
	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    			   if (extension == "gif" || extension == "png" || extension == "bmp"
	    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	    					   || extension == "doc" || extension == "docx" || extension == "txt"
	    						   || extension == "xls" || extension == "csv" || extension == "xml" 
	    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
	    				   var entityId = 'student';
	    				   var module = 'messaging';
	    				   var entityType = 'template';
	    				   var documentType = 'DOCUMENT';
	    				   var isTransient = true;
	    				   var this$ = this;
	    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
	    				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	    					   if(success){
	    						   Ext.getBody().unmask();
	    						   var path = Ext.JSON.decode(action.response.responseText).path;
	    						   var user = this$.getCurrentlyLoggedInUser();
	    						   var store = grid.getStore();
	    						   var documentStatus = "SUBMITTED";
	    						   var documentType = null;
	    						   if(!isNullOrEmpty(path)){
	    							   store.add({
	    								   id: '',
	    								   name: fileUploadPath,
	    								   path: path ,
	    								   createdBy : {
	    									   id :user.id,
	    									   value : user.value,
	    									   code : user.code
	    								   },
	    								   status : documentStatus,
	    								   documentType : documentType,
	    								   templateConfigDocId: '',
	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	    							   });
	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	    						   }
	    						   var form=this$.getJobapplicationemployeesendmessages();
	           	            	   var empSubject = form.down('#empSubject').getValue();
	           	            	   if(!isNullOrEmpty(empSubject)){
	           	            		   if(empSubject == ' '){
	           	            			form.down('#empSubject').reset();
	           	            		   }
	           	            	   }
	    						   fileField.reset();
	    					   }

	    				   }, isTransient);
	    			   }else{
	    				   fileField.reset();
	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    			   }
	    		   }
	    	   }else{
	    		   fileField.reset();
	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    	   }
	       }, 
	       saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
		       	var submitUrl = '';
		       	var templateTab = this.getContentpanel();
		       	var formWin =  this.getJobapplicationemployeesendmessages();
		       	var form = formWin.down('#empMsgDetailsForm');
		       	var id = form.down('#emp_document_hidden_field');
		           if (isNullOrEmpty(id.getSubmitValue())) {
		               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
		           }
		           var data = new Object();
		           if(!isNullOrEmpty(entityId)){
		           	data.entityId = entityId;
		           }else{
		           	data.entityId = null;
		           }
		           if(!isNullOrEmpty(module)){
		           	data.module = module;
		           }else{
		           	data.module = null;
		           }
		           if(!isNullOrEmpty(entityType)){
		           	data.entityType = entityType;
		           }else{
		           	data.entityType = null;
		           }
		           form.getForm().setValues(data);
		           form.getForm().submit({
		           	method : 'POST',
		           	url : submitUrl,
		           	success : function(form, action){
		           		callBackFunction(true, action, isTransient);
		           		
		           	}
		           });
		       },
		       deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
		    	   var grid = view.up('#employeeStaticDocumentAttachmentGridMessage');
		    	   var panel = this.getContentpanel().getActiveTab();
		    	   var tabTitle = panel.title;
		    	   var store = grid.getStore();
		    	   var templateConfigDocId = record.get('templateConfigDocId');
		    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
		    	   if(!(tabTitle == viewTitle)){
		    		   if(!isNullOrEmpty(templateConfigDocId)){
		    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		    				   if (btn == 'yes') {
		    					   Ext.Ajax.request({
		    						   type: 'rest',
		    						   url: SERVERURL.STATIC_DOC_DELETE,
		    						   method: 'DELETE',
		    						   params: {
		    							   templateConfigDocId : templateConfigDocId
		    						   },
		    						   headers: {
		    							   'Content-Type': 'application/json'
		    						   },
		    						   success: function(form, action) {
		    							   store.remove(record);
		    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
		    						   }
		    					   });
		    				   }
		    			   });

		    		   }else{
		    			   store.remove(record);
		    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
		    		   }
		    	   }else{
		    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
		    	   }

		       }
});