/**
 * This controller is used for the HR Recruitment Process Job Posting Add/Edit/Delete/View
 * 
 * 
 * @author Deepak S
 */
Ext.define('Academia.controller.hrRecruitmentProcess.jobPosting.JobPostingController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['user.UserAcademyLocationStore',
    	'common.FacultyTypeCSMStore','hrRecruitmentProcess.jobPosting.AssignUserGroupTypeStore','common.StatusComboStore',
    	'common.AllUserBySmartSearch',
    	'hrRecruitmentProcess.jobPosting.JobPostingGridStore',
    	'hrRecruitmentProcess.jobPosting.PublishStatusStore',
    	'hrRecruitmentProcess.jobPosting.MappingStatusStore',
    	'hrRecruitmentProcess.jobPosting.JobCodeComboStore',
    	'hrRecruitmentProcess.jobPosting.JobTitleComboStore',
    	'user.UserAcademyLocationStore',
		'department.DepartmentAcademyLocationWiseStore',
		'common.DesignationTypeStore',
		'hrRecruitmentProcess.jobPosting.ConfigureJobPostingSetupGridStore',
		'dynamicformrendering.configurescreen.OptionalMandatoryStore',
		'common.YesNoDynamicFormCombo',
		'hrRecruitmentProcess.jobPosting.JobPostingSetupConfigureScreenStore',
		'hrRecruitmentProcess.jobPosting.JobPostingSetupCustomColumnStore',
		'hrRecruitmentProcess.jobPosting.JobPostingSetupDataRequirementStore',
		'user.EmployeeTypeStore','committee.committee.MessageTypeNotificationStore',
		'messaging.MessagingTemplatesStore',
		'messaging.StaticDocumentAttachmentGridStore'
    ],
    views: ['hrRecruitmentProcess.jobPosting.JobPostingStructure',
    		'hrRecruitmentProcess.jobPosting.JobPostingTabStructure',
    		'hrRecruitmentProcess.jobPosting.JobPostingFilter',
    		'hrRecruitmentProcess.jobPosting.JobPostingGrid',
    		'hrRecruitmentProcess.jobPosting.JobPostingAddFormWindow',
    		'hrRecruitmentProcess.jobPosting.JobPostingFormLayout',
    		'hrRecruitmentProcess.jobPosting.ConfigureJobPostingTabStructure',
    		'hrRecruitmentProcess.jobPosting.ConfigureJobPostingSetUpGrid',
    		'hrRecruitmentProcess.jobPosting.JobPostingApplyToForm',
    		'hrRecruitmentProcess.jobPosting.JobPostingSetupConfigureScreen',
    		'hrRecruitmentProcess.jobPosting.JobPostingSetupConfigureScreenGrid',
    		'hrRecruitmentProcess.jobPosting.JobPostingSetupHelpTextForm',
    		'hrRecruitmentProcess.jobPosting.JobPostingSetupCustomColumnGrid',
    		'hrRecruitmentProcess.jobPosting.JobPostingSetupDataRequirementGrid',
    		'hrRecruitmentProcess.jobPosting.JobPostingAddEditor',
    		'hrRecruitmentProcess.jobPosting.EmployeeSendMessages',
			'messaging.EmployeeStaticDocumentAttachmentGrid',
			'hrRecruitmentProcess.jobPosting.AIJobDescriptionPopup'
    		],
    //requires: ['Academia.utilities.ux.Notification'],
    models: [],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
        ref: 'jobpostingstructure',
        selector: 'jobpostingstructure'
    }, {
        ref: 'jobpostingtabstructure',
        selector: 'jobpostingtabstructure'
    }, {
        ref: 'jobpostingfilter',
        selector: 'jobpostingfilter'
    }, {
        ref: 'jobpostinggrid',
        selector: 'jobpostinggrid'
    }, {
        ref: 'jobpostingaddformwindow',
        selector: 'jobpostingaddformwindow'
    }, {
        ref: 'jobpostingformlayout',
        selector: 'jobpostingformlayout'
    }, {
        ref: 'jobpostingapplytoform',
        selector: 'jobpostingapplytoform'
    }, {
        ref: 'configurejobpostingtabstructure',
        selector: 'configurejobpostingtabstructure'
    }, {
        ref: 'configurejobpostingsetupgrid',
        selector: 'configurejobpostingsetupgrid'
    }, {
        ref: 'jobpostingsetupconfigurescreen',
        selector: 'jobpostingsetupconfigurescreen'
    }, {
        ref: 'jobpostingsetupconfigurescreengrid',
        selector: 'jobpostingsetupconfigurescreengrid'
    },{
        ref: 'jobpostingsetuphelptextform',
        selector: 'jobpostingsetuphelptextform[itemId=jobPostingAppSetupHelpTextFormId]'
    },{
		ref : 'jobpostingsetupcustomcolumngrid',
		selector : 'jobpostingsetupcustomcolumngrid'
	},{
		ref : 'jobpostingsetupdatarequirementgrid',
		selector : 'jobpostingsetupdatarequirementgrid'
	},{
		ref : 'jobpostingaddeditor',
		selector : 'jobpostingaddeditor'
	},{
		ref : 'employeesendmessages',
		selector : 'employeesendmessages[itemId=employeeListSendMessageWindows]'	
	},{
    	ref :'employeeDocumentMessageAttachmentGrid',
    	selector : 'employeestaticdocumentattachmentgrid [itemId=employeeStaticDocumentAttachmentGridMessage]'
    }, {
    	ref: 'aijobdescriptionpopup',
    	selector: 'aijobdescriptionpopup'
    }],
    config: {
    	FACULTY_JOB_POSTING_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_JOB_POSTING_PRIVILEGES'),
    	PLACEMENT_JOB_POSTING_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT_JOB_POSTING_PRIVILEGES')
    },
    init: function() {
        this.control({
        	'jobpostinggrid button[itemId=btnAdd]':{
    			click: this.addJobPosting
    		},
    		'jobpostinggrid button[itemId=btnEdit]':{
    			click: Ext.bind(
    	                this.editViewJobPosting, this, [false])
    		},
    		'jobpostinggrid button[itemId=btnView]':{
    			click: Ext.bind(
    	                this.editViewJobPosting, this, [true])
    		},
    		'jobpostinggrid button[itemId=btnDelete]':{
    			click: function(){
    				this.deleteApproveJobPosting("DELETE");
    			}
    		},
    		'jobpostinggrid menuitem[itemId=approveLink]':{
    			click:function(){
    				this.deleteApproveJobPosting("APPROVE");
    			}
    		},
    		'jobpostinggrid menuitem[itemId=publishJobLink]':{
    			click:function(){
    				this.deleteApproveJobPosting("PUBLISHED");
    			}
    		},
    		'jobpostinggrid menuitem[itemId=unpublishJobLink]':{
    			click:function(){
    				
    				var $this =this;
    				var grid = $this.getJobpostinggrid();
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				showConfirmMessage(getCommonTranslation('JOB_POSTING'), getCommonTranslation('UNPUBLISHED_MSGE'), function(btn, text) {
    	                if (btn == 'yes') {
    	        			Ext.Ajax.request({
    	        				method: "GET",
    	        				type: 'rest',
    	        				url:SERVERURL.PATH_UNPUBLISH_JOB,
    	        				params: {
    	        					id: id
    	        					
    	        				},
    	        				
    	        				success: function(response) {
    	        					$this.loadJobPostingGrid();
    	        					var Jobfilter =$this.getJobpostingfilter();
    	        					var jobCode=Jobfilter.down("#jobCode");
	        						jobCode.getStore().reload();
	        						var jobTitle=Jobfilter.down("#jobTitle");
	        						jobTitle.getStore().reload();
	        						showSuccessMessage(getCommonTranslation('JOB_POSTING'), getCommonTranslation('SUCCESS'));
	        					
    	                        }
    	        			});
    	        				
    	        		}
    	                });
    				
    			}
    		},
    		'jobpostinggrid menuitem[itemId=configureJobLink]':{
    			click:function(){
    				this.configureJobPosting();
    			}
    		},
    		'jobpostinggrid menuitem[itemId=btnApplyToJobPosting]':{
    			click:function(){
    				this.openApplyToJobPosting();
    			}
    		},
    		'jobpostingformlayout button[itemId=submitBtn]':{
    			click: this.saveJobPostingData
    		},
    		'jobpostingfilter button[itemId=searchBtnJobPostingItemId]':{
    			click: this.loadJobPostingGrid
    		},
    		'jobpostingfilter button[itemId=resetBtnJobPostingItemId]':{
    			click: this.resetJobPostingFilterForm
    		},
    		'jobpostingformlayout button[itemId=resetButtonId]':{
    			click: this.resetJobPostingFormWindow
    		},
    		'jobpostingformlayout button[itemId=resetButtonAIId]':{
    			click: this.resetJobPostingAIFormWindow
    		},
    		
    		'jobpostinggrid': {
      			afterrender:function(grid){
   				var me = this;
   				setTimeout(function(){
   					me.addDataGridConfigButton(grid,me.getFACULTY_JOB_POSTING_PERMISSION());
   				},1500);
   			 },
   			 select: function(rowModel, record, index, eOpts){                	
             	this.setPublishedButtonText(rowModel, record, index, eOpts);
             }
       		},
       		'jobpostingapplytoform combo#academyLocationId': {
       			select: function(combo,record) {
       				var $this = this;
       				var form = $this.getJobpostingapplytoform();
       				var jobPostingDepartmentId = form.down('#jobPostingDepartmentId');
       				jobPostingDepartmentId.reset();
       				var academyLocationId = record[0].get('id');
       				var store = jobPostingDepartmentId.getStore();
       				store.getProxy().extraParams = {
       					academyLocationsIds: academyLocationId
       				};
       				store.load();
       			}
       		},
       		'jobpostingapplytoform button[itemId=addJobPostingBtn]':{
       			click: function(obj){
       				this.addMultipleJobPostingMapping(obj);
       			}
       		},
       		'jobpostingapplytoform button[itemId=btnSaveApplyToForm]':{
       			click: function(obj){
       				this.saveApplyToMappingJobPosting();
       			}
       		},
       		'configurejobpostingsetupgrid button[itemId=btnSaveConfigureJobPosting]':{
       			click: function(obj){
       				this.saveConfigurationJobPosting();
       			}
       		},
       		'configurejobpostingsetupgrid':{
 	        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	        		var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		var $this =this;
 	        		var employeeJobPostingId = $this.getConfigurejobpostingsetupgrid().config.employeeJobPostingId;
 	        		if(columnName == "additionalSetUp"){
 	        			if (e.target.tagName == 'A') {
 	        				var setupForm = grid.up('configurejobpostingtabstructure');
 	        				var containpanel = setupForm;
 	        				var tabName = record.data.moduleName;
 	        				var tabDetail = containpanel.items.items;
 	        				for(var i in tabDetail){
 	        					if(tabDetail[i].itemId!='pnlJobPostingId'){
 	        						tabDetail[i].close();
 	        					}
 	        				}
 	        				var configfeestructure = Ext.widget('jobpostingsetupconfigurescreen');
 	        				openTab(containpanel, tabName, configfeestructure);
 	        				configfeestructure.down('#moduleTableItemId').setValue(record.data.tableName);
 	        				configfeestructure.down('#moduleItemId').setValue(record.data.employeeJobPostingFormModuleId);
 	        				configfeestructure.down('#moduleNameItemId').setValue(record.data.moduleCode);
 	        				var configGrid = configfeestructure.down('jobpostingsetupconfigurescreengrid');
 	        				configGrid.getStore().getProxy().extraParams = {
 	        					employeejobPostingId:employeeJobPostingId,
 	        					screenName:record.data.formAliasName,
 	        					screenMode:'Create, Edit, and View'
 	        						//languageId:languageId
 	        				};
 	        				configGrid.getStore().load();
 	        				
 	        				if(record.data.formAliasName =='educationform' || record.data.formAliasName == 'addressformwindow'|| record.data.formAliasName == 'identitydetailsform'){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='dataRequirementTabItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        								if(itemGrid.xtype =='jobpostingsetupdatarequirementgrid'){
 	        									itemGrid.show();
 	        								}
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        					
 	        				}
 	        				if(record.data.formAliasName != null){
 	        					configfeestructure.down('tabpanel').items.items.forEach(function(obj){
 	        						if(obj.itemId =='configureScreenItemId'){
 	        							obj.items.items.forEach(function(itemGrid){
 	        								if(itemGrid.xtype =='jobpostingsetupconfigurescreengrid'){
 	        									itemGrid.show();
 	        								}
 	        							});
 	        							obj.tab.show();
 	        						}
						    	});
 	        				}
 	        			}
 	        		}
 	        	}
       		},
       		'jobpostingapplytoform button[itemId=btnResetApplyToForm]':{
       			click: function(obj){
       				this.resetApplyToMappingForm(obj);
       			}
       		},
       		'jobpostingsetupconfigurescreengrid':{
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var $this=this;
            		var searchResultGrid = $this.getJobpostingsetupconfigurescreengrid();
            		//if(searchResultGrid.columnManager.columns !=null){
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
            		var selectedRecord = searchResultGrid.getSelectionModel().getSelection()[0];

            		if(columnName=='helpText' && searchResultGrid.getSelectionModel().getSelection().length>0  /*&& record.data.helpText ==null || record.data.helpText ==""*/){ 
            			if(searchResultGrid.getSelectionModel().getSelection().length==1 &&  (record.data.formFieldId == selectedRecord.data.formFieldId)){

            				if (e.target.tagName == 'A') {
            					var formWindow = $this.getJobpostingsetuphelptextform();
            					if (!formWindow) {
            						Ext.widget('jobpostingsetuphelptextform',{
            				        	itemId: 'jobPostingAppSetupHelpTextFormId'
            				        });
            						formWindow = $this.getJobpostingsetuphelptextform();
            					}
            					formWindow.show();

            					var defaultHelpText = record.data.defaultHelpText;
            					var helpTextForm = $this.getJobpostingsetuphelptextform().down('form').getForm();
            					helpTextForm.findField('defaultHelpText').setValue(defaultHelpText);

            					if(!isNullOrEmpty(record.data.helpText)){
            						helpTextForm.findField('helpText').setValue(record.data.helpText);
            					}
            				}
            			}else{
            				if(searchResultGrid.getSelectionModel().getSelection().length>1 ){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); 
            				}
            				else if(record.data.formFieldId != selectedRecord.data.formFieldId){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_CURRENT_RECORD'));
            				}
            			}
            		}
            		else{

            			if(columnName=='helpText' && (!searchResultGrid.getSelectionModel().getSelection().length>0 || (record.data.formFieldId != selectedRecord.data.formFieldId)) )
            				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 

            		}
            	}
            //}
            },
            'jobpostingsetuphelptextform[itemId=jobPostingAppSetupHelpTextFormId] button[itemId=submitBtn]':{
            	click:function(obj){
            		var $this =this;
            		var form = obj.up('form').getForm();
            		var values = form.getValues();
            		var helpText =values.helpText;
            		var grid = $this.getJobpostingsetupconfigurescreengrid();
            		var getRange = grid.getSelectionModel().selected.getRange();
            		getRange[0].set("helpText",helpText);
            		$this.getJobpostingsetuphelptextform().close();
            	}
            },
            'jobpostingsetuphelptextform[itemId=jobPostingAppSetupHelpTextFormId] button[itemId=cancelBtn]':{
            	click:function(obj){
            		this.getJobpostingsetuphelptextform().close();
            	}
            },
            
            'jobpostingsetupconfigurescreengrid button[itemId=btnSaveJobPosting]':{
            	click:function(){
            		this.saveJobPostingConfigureScreenData();
            	}
            },
            'jobpostingsetupcustomcolumngrid':{
            	render : function(grid){
            		var $this = this;
            		var configureScreen = $this.getJobpostingsetupconfigurescreen();
            		var setupForm = grid.up('configurejobpostingtabstructure');
            	    var employeeJobPostingId = setupForm.config.employeeJobPostingId;
            	    var moduleId = configureScreen.down('#moduleItemId').getValue();
            		var moduleTableName = configureScreen.down('#moduleTableItemId').getValue();
            		grid.getStore().getProxy().extraParams={
            			tableName:moduleTableName.trim(),
            			setupId:employeeJobPostingId,
            			moduleId:moduleId
            		}
            		grid.getStore().load();
            	} 
            },
            'jobpostingsetupcustomcolumngrid checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var this$ = this;
            		var grid = this$.getJobpostingsetupcustomcolumngrid();
            		var store = grid.getStore();
            		var models = grid.getStore().getRange();
            		if(checked){
            			for(var i =0; i<store.data.length;i++){
            				if(rowIndex==i){
            					models[rowIndex].set('mandatory', true);
            				}
            			}	 
            		}else{
            			for(var i =0; i<store.data.length;i++){
            				if(rowIndex==i){
            					models[rowIndex].set('mandatory', false);
            				}
            			}	 
            		} 
            	}
            },
            'jobpostingsetupcustomcolumngrid button[itemId=btnSaveCustom]':{
            	click:function(){
            		this.saveJobPostingCustomColumnSetup();
            	}
            },
            'jobpostingsetupdatarequirementgrid':{
            	render : function(grid){
            		var $this = this;
            		var min;
            		var max;
            		var configureScreen = $this.getJobpostingsetupconfigurescreen();
            		var moduleCode = configureScreen.down('#moduleNameItemId').getValue();
            		var url;

            		var firstIndex = grid.columns[0];
            		Ext.each(grid.columns, function(column) {
            			if (column.dataIndex == 'minimumEntry') {
            				min = column;
            			}else if (column.dataIndex == 'maximumEntry'){
            				max = column
            			}
            		});

            		var setupForm = grid.up('configurejobpostingtabstructure');
            		var employeeJobPostingId = setupForm.config.employeeJobPostingId;
            		var moduleId = configureScreen.down('#moduleItemId').getValue();
            		var moduleTableName = configureScreen.down('#moduleTableItemId').getValue();

            		if (moduleCode == 'STEP3_EDUCATION_BACKGROUND') {
            			grid.getStore().getProxy().extraParams={
            				employeeJobPostingId:employeeJobPostingId,
            				employeeJobFormModuleId:moduleId
            			}
            			grid.getStore().load();
            		}else if (moduleCode == 'STEP2_CONTACT_DETAILS') {
            			url = SERVERURL.PATH_FIND_RELATED_PERSON_ADDRESS_DATA_REQUIREMENT;
            			
            			Ext.Ajax.request({
                			type: 'rest',
                			url: url+'?employeeJobPostingId='+employeeJobPostingId+'&employeeJobFormModuleId='+moduleId,
                			method: 'GET',
                			callback : function(opt, success, response){
                				var data = Ext.decode(response.responseText);
                				grid.getStore().loadData(data);
                			}
                		});
            		}else if (moduleCode == 'STEP5_IDENTITY_DOCUMENTS') {
            			url = SERVERURL.FIND_ID_TYPE_DATA;
            			
            			Ext.Ajax.request({
                			type: 'rest',
                			url: url+'?employeeJobPostingId='+employeeJobPostingId+'&employeeJobFormModuleId='+moduleId,
                			method: 'GET',
                			callback : function(opt, success, response){
                				var data = Ext.decode(response.responseText);
                				grid.getStore().loadData(data);
                			}
                		});
            		}
            		setTimeout(function() {
            			if (moduleCode == 'STEP2_CONTACT_DETAILS'||moduleCode == 'STEP5_IDENTITY_DOCUMENTS'){
            				if(moduleCode == 'STEP2_CONTACT_DETAILS'){
            					var firstHeaderName = getCommonTranslation('SETUP_CONTACT_DETAILS');	
            				}else if(moduleCode == 'STEP5_IDENTITY_DOCUMENTS'){
            					var firstHeaderName = getPersonModuleTranslation('IDENTITY_DETAILS');
            				}
            				grid.columnManager.columns[0].setText(firstHeaderName);
            				min.setVisible(false);
            				max.setVisible(false);

            			}}, 100);
            	} 
            },
            'jobpostingsetupdatarequirementgrid checkcolumn':{
            	checkchange:function(obj, rowIndex, checked, eOpts ){
            		var this$ = this;
            		var grid = this$.getJobpostingsetupdatarequirementgrid();
            		var store = grid.getStore();
            		var models = grid.getStore().getRange();
            		if(checked){
            			for(var i =0; i<store.data.length;i++){
            				if(rowIndex==i){
            					models[rowIndex].set('mandatory', true);
            				}
            			}	 
            		}else{
            			for(var i =0; i<store.data.length;i++){
            				if(rowIndex==i){
            					models[rowIndex].set('mandatory', false);
            				}
            			}	 
            		} 
            	}
            },
            'jobpostingsetupdatarequirementgrid button[itemId=btnSaveDataReq]':{
            	click:function(){
            		this.saveJobPostingDataReqSetup();
            	}
            }, 
            'jobpostingformlayout nestedJsonCombo#userGroupType' : {
	        	  select: function(obj, record) {
	        		    var userGroupName = record[0].get("userGroupName");
	        		    this.hideOrShowWeatherFaculty(userGroupName);
	        	  }
	        },
	        'jobpostingapplytoform button[itemId=btnToAddCkEditor]':{
    			click:function(btn){
    			 this.addCkEditor(btn); 
    			 }
    		},
    		'jobpostingaddeditor button[itemId=btnSaveDescription]':{
            	click:function(){
            		this.saveCkeditorData();
            	}
            },
            'jobpostingaddeditor button[itemId=btnResetDescription]':{
    			click: this.resetJobpostingaddeditor
    		}, 
    		/*'jobpostinggrid button[itemId=btnSendMessage]':{
				click:function(){
					this.openEmployeeSendMessage();
				}
			},*/
    		'employeesendmessages[itemId=employeeListSendMessageWindows] radiogroup[itemId=messageType]':{
				change : function(val,nV,oV){
					this.selectSectionMessageType(val,nV,oV);
				}
			},
			'employeesendmessages[itemId=employeeListSendMessageWindows] customcombobox[itemId=empMsgTempletId]':{
				select : function(obj,rec){
					this.selectMessageTemp(obj,rec);
				}
			},
			'employeesendmessages[itemId=employeeListSendMessageWindows] textarea[itemId=empPushNotificationDiscription]':{
				change : function(val,nV,oV){
					var employeeSendMessages =  this.getEmployeesendmessages();
					var pushTextField = employeeSendMessages.down('#empPushNotificationDiscription');
					var pushTextFieldDiscription = employeeSendMessages.down('#empPushNotificationDiscriptionNotice');
					var maxLength = 1000;
					var newValue = maxLength - pushTextField.getValue().length;
					pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
				}
			},
			'employeesendmessages[itemId=employeeListSendMessageWindows] button[itemId=empAdhocMsgSubmitBtn]':{
				click: function(obj) {
					var grid = this.getJobpostinggrid();
					var employeesendmessage =  this.getEmployeesendmessages();
					var formPnl = obj.up('form');
					var isMySelfChecked = false;
					var fldValues = formPnl.getForm().getFieldValues();
					isMySelfChecked = fldValues.empRecieverType;
					if(fldValues.empRecieverType[0] == false && fldValues.empRecieverType[1]==false && fldValues.empRecieverType[2]==false ){
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
						return;
					}
					var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
					var empWsMsgEventRecipientConfigsUpdated = [];
					/*var empWsMsgEventRecipientConfigsUpdated = [{ 
						                           	 	msgRecipientTypeId: 500,
						                           	 	msgTemplateConfigId: 0,	//formData.id, 
						                           	 	selectiveRecipientIds: [] 
						                            },{ 
						                           	 	msgRecipientTypeId: 600,
						                           	 	msgTemplateConfigId: 0,	//formData.id, 
						                           	 	selectiveRecipientIds: [] 
						                            }];*/

					var formData = obj.up('form').getValues();

					var sendMessageToOptions = formData.empRecieverType;
					var isStudentChecked = false;
					var isParentChecked = false;
					var isFeePayerChecked = false;

					if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
						if(sendMessageToOptions.constructor === Array){
							if(sendMessageToOptions.length > 0){
								sendMessageToOptions.forEach(function(current_value, index, initial_array) {
									if(current_value == 1 || current_value == '1'){
										isStudentChecked = true;
									}
									if(current_value == 2 || current_value == '2'){
										isParentChecked = true;
									}
									if(current_value == 3 || current_value == '3'){
										isFeePayerChecked = true;
									}
								});
							}
						}else{
							if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
								isStudentChecked = true;
							}
							if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
								isParentChecked = true;
							}
							if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
								isFeePayerChecked = true;
							}
						}
					}

					//var abc = xyz.c;

					if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
						//empWsMsgEventRecipientConfigsUpdated = [];
						employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
					}else{
						var recipientIds;
						if(grid.itemId == 'StudentSearchResultGrid'){
							recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
							recipientIds = Ext.encode(recipientIds);
							//typeId = 2;
							//recipientId = 2;
						}

						var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

						if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
							// Ajax Call to get Parent Ids by Admission Ids

							Ext.Ajax.request({
								type: 'rest',
								url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
								jsonData: RecipientTypeCodes,
								method: 'POST',
								success: function(response) {
									var RecipientTypeCodesData = Ext.decode(response.responseText);

									Ext.Ajax.request({
										type: 'rest',
										url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
										jsonData: recipientIds,
										method: 'POST',
										success: function(response) {
											// update empWsMsgEventRecipientConfigsUpdated with parent ids
											var empWsMsgEventRecipientConfigsParents = {
													msgRecipientTypeId: 66,
													msgTemplateConfigId: 0,	//formData.id, 
													selectiveRecipientIds: []
											};
											if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
												empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
											}
											empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
											empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);

											// Ajax Call to get Fee Payer Ids by Admission Ids
											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
												jsonData: recipientIds,
												method: 'POST',
												success: function(response) {
													// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
													var empWsMsgEventRecipientConfigsFeePayer = {
															msgRecipientTypeId: 67,
															msgTemplateConfigId: 0,	//formData.id, 
															selectiveRecipientIds: []
													};

													if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
														empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
													}

													empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
													empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
													employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
												}
											});
										}
									});
								}
							});
						}else{ // Only one checkbox is selected
							var urlNew = '';
							if(isParentChecked) { // If Parent checkbox is selected
								// url for getting parent ids
								urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
							}
							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
								// url for getting fee payer ids
								urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
							}

							Ext.Ajax.request({
								type: 'rest',
								url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
								jsonData: RecipientTypeCodes,
								method: 'POST',
								success: function(response) {
									var RecipientTypeCodesData = Ext.decode(response.responseText);

									Ext.Ajax.request({
										type: 'rest',
										url: urlNew,
										jsonData: recipientIds,
										method: 'POST',
										success: function(response) {
											if(isParentChecked) { // If Parent checkbox is selected
												// update empWsMsgEventRecipientConfigsUpdated with parent ids
												var empWsMsgEventRecipientConfigsParents = {
														msgRecipientTypeId: 66,
														msgTemplateConfigId: 0,	//formData.id, 
														selectiveRecipientIds: []
												};
												if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
													empWsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
												}
												empWsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
												empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsParents);
											}
											if(isFeePayerChecked) { // If Fee Payer checkbox is selected
												// update empWsMsgEventRecipientConfigsUpdated with fee payer ids
												var empWsMsgEventRecipientConfigsFeePayer = {
														msgRecipientTypeId: 67,
														msgTemplateConfigId: 0,	//formData.id, 
														selectiveRecipientIds: []
												};
												if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
													empWsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
												}
												empWsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
												empWsMsgEventRecipientConfigsUpdated.push(empWsMsgEventRecipientConfigsFeePayer);
											}
											employeesendmessage.sendMessage(obj,grid, empWsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
										}
									});
								}
							});

						}
						//employeesendmessage.sendMessage(obj,grid);
					}

				}
			},
			/*V2D-13247*/
			'employeesendmessages[itemId=employeeListSendMessageWindows] textarea[itemId=empSmsDiscription]':{
				change : function(val,nV,oV){
					var employeesendmessage =  this.getEmployeesendmessages();
					var smsTextField = employeesendmessage.down('#empSmsDiscription');
					var smsTextFieldDiscription = employeesendmessage.down('#empSmsDiscriptionNotice');
					var maxLength = localStorage.getItem('maxLength');
					var newValue = maxLength - smsTextField.getValue().length;
					smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
				}
			},'employeesendmessages[itemId=employeeListSendMessageWindows]  filefield[itemId=empStaticUploadFileField]': {
				change: function(fileField, value, eOpts){
					var this$ = this;
					//value = value.replace('C:\\fakepath\\', '');
					var form=this$.getEmployeesendmessages();
					var empSubject = form.down('#empSubject').getValue();
					if(isNullOrEmpty(empSubject)){
						form.down('#empSubject').setValue(' ');
					}
					this$.uploadEmployeeStaticDocumentFileMessage(fileField, value, eOpts);
				}
			}, 'employeestaticdocumentattachmentgrid[itemId=employeeStaticDocumentAttachmentGridMessage] actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },'employeesendmessages[itemId=employeeListSendMessageWindows]': {
				render: function(grid){
					var this$ = this;
					var docGrid = grid.down('#employeeStaticDocumentAttachmentGridMessage');
					docGrid.getStore().removeAll();
					docGrid.getStore().sync();
				}
			}, 'employeesendmessages[itemId=employeeListSendMessageWindows] radiogroup#empSendingPriority': {
				change: function( radio, newValue, oldValue, eOpts) {
					this.loadStudentScheduleField(radio, newValue, oldValue);
				}
			},
			'jobpostingformlayout button[itemId=generateJobDescBtn]': {
				click: this.openJobDescPopup
			},
			'aijobdescriptionpopup button[itemId=resetButtonId]': {
				click: this.resetJobDescPopup
			},
			'aijobdescriptionpopup button[itemId=generateBtn]': {
				click: this.generateShortJobDesc
			},
			'jobpostingformlayout textfield[itemId=jobTitleId]': {
				change: this.onChangeJobTitle
			},
			'jobpostingformlayout': {
				afterrender: this.onJobpostingformRender
			}
		});
	},
    loadJobPostingGrid: function(){
    	var $this=this;
    	var form = $this.getJobpostingfilter().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getJobpostinggrid();
    	var isActive = null;
    	if(formValue.status == "ACTIVE") {
    		isActive=true;
    	} else if(formValue.status == "INACTIVE") {
    		isActive=false;
    	}
    	var store = grid.getStore();
    	var startDate=form.findField('fromDate').getValue();
    	if(!isNullOrEmpty(startDate)){
    		startDate = startDate.getTime();
    	}
    	var tillDate=form.findField('tillDate').getValue();
    	if(!isNullOrEmpty(tillDate)){
    		tillDate = tillDate.getTime();
    	}
    	store.getProxy().extraParams= {
    		academyLocationId:formValue.academyLocationId,
    		jobCode:formValue.jobCode,
    		jobTitle:formValue.jobTitle,
    		coordinatorId:formValue.coordinator,
    		fromDate:startDate,
    		toDate :tillDate,
    		publishStatus:formValue.publishStatus,
    		mappingStatus:formValue.mappingStatus,
    		status:isActive
    	};
    	if(isNullOrEmpty(formValue.status)) {
    		delete store.getProxy().extraParams.status;
    	}
    	grid.getSelectionModel().deselectAll();
    	$this.resetGridSetting(grid);
    	$this.resetPageSetting(store);
    	store.load();
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = $this.getJobpostingfilter();
    },
    resetJobPostingFilterForm: function() {
    	var $this = this;
    	var filter = $this.getJobpostingfilter().getForm();
    	filter.reset();
    	var startDateId = filter.findField('fromDate'),
    	endDateId = filter.findField('tillDate');
    	startDateId.setMinValue(false);
    	endDateId.setMinValue(false);
    	startDateId.setMaxValue(false);
    	endDateId.setMaxValue(false);
    },
    
    resetJobPostingFormWindow: function() {
    	var $this = this;
    	var window = $this.getJobpostingaddformwindow();
    	var form = $this.getJobpostingformlayout().getForm();
    	form.reset();
    	var startDateId = form.findField('fromDate'),
    	endDateId = form.findField('toDate');
    	startDateId.setMinValue(false);
    	endDateId.setMinValue(false);
    	startDateId.setMaxValue(false);
    	endDateId.setMaxValue(false);
    },
    resetJobPostingAIFormWindow: function() {
    	var $this = this;
    	var window = $this.getJobpostingaddformwindow();
    	var form = $this.getJobpostingformlayout().getForm();
    	form.findField('shortDescription').reset();
    	
    },
    resetJobpostingaddeditor: function() {
    	var $this = this;
    	var window = $this.getJobpostingaddeditor();
    	var edtr = window.down('ckeditor');
    	edtr.reset();
    },
    addJobPosting: function() {
        var formWindow = this.getJobpostingaddformwindow();
        if (isEmpty(formWindow)) {
        	formWindow = Ext.widget('jobpostingaddformwindow');
        }
        formWindow.show();
    },
    editViewJobPosting : function(isEditable){
		var $this = this;
		var grid = $this.getJobpostinggrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addJobPosting();
			var form = $this.getJobpostingformlayout().getForm();
			
			var record = grid.getSelectionModel().getSelection()[0];
			form.setValues(record.data);
			
			var coordinator = form.findField('coordinator');
			coordinator.getStore().load({
				callback:function(){
					coordinator.setValue(record.data.coordinator.id);
				}
			});
			
			var userGroup = form.findField('userGroup');
			userGroup.getStore().load({
				callback:function(){
					userGroup.setValue(record.data.userGroup.id);
				}
			});
			var userGroupName =record.data.userGroup.userGroupName;
			this.hideOrShowWeatherFaculty(userGroupName);	
			var facultyType = form.findField('facultyType');
			if(record.data.facultyType!=null){
			
			facultyType.getStore().load({
				callback:function(){
					facultyType.setValue(record.data.facultyType.id);
				}
			});
			}
			var employeeType = form.findField('employeeType');
			if(record.data.employeeType!=null){
			
			facultyType.getStore().load({
				callback:function(){
					employeeType.setValue(record.data.employeeType);
				}
			});
			}
			var fromDateVal = new Date(record.data.fromDate);
			var toDateVal = new Date(record.data.toDate);
			
			var fromDate = form.findField('fromDate');
			var toDate = form.findField('toDate');
			fromDate.setValue(fromDateVal);
			toDate.setValue(toDateVal);
			
			
			var status = form.findField('status');
			if(!isNullOrEmpty(record.data.status)){
				if(record.data.status) {
					status.setValue('ACTIVE');
				} else {
					status.setValue('INACTIVE');
				}
			}
			var formPnl = $this.getJobpostingformlayout();
			if(isEditable) {
				formPnl.down('#submitBtn').setVisible(false);
				$this.toggleReadOnlyFormItems(formPnl.getForm(), true);
				formPnl.doLayout();
			}
			formPnl.down('#resetButtonId').setVisible(false);
			
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    deleteApproveJobPosting: function(actionType){
    	var $this=this;
    	var grid = $this.getJobpostinggrid();
    	if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			var id = records[0].get("id");
			var values = records[0].data;
			var isActive = true;
			var publishStatus = values.publishStatus;
			if(actionType == "DELETE"){
				isActive = false;
			}
			if(actionType == "PUBLISHED"){
				publishStatus = "PUBLISHED";
				if(Ext.Date.format(new Date(values.toDate), 'Y-m-d')<Ext.Date.format(new Date(), 'Y-m-d')){
					 showErrorMessage(getCommonTranslation('ALERT'), getCommonTranslation('YOU_CANNOT_PUBLISH_JOB_DATE_HAS_EXPIRED')); //Error occured while performing transaction
	                    return false;
				}
			}
			
			var jsonFormatFormData;
			if(!isNullOrEmpty(values.fromDate)){
				values.fromDate = Ext.Date.format(new Date(values.fromDate), 'Y-m-d');
			}
			if(!isNullOrEmpty(values.toDate)){
				values.toDate = Ext.Date.format(new Date(values.toDate), 'Y-m-d');
			}
			
			if(values.userGroup.userGroupName == 'Other Employee') {
		    	delete values.facultyType;
			} else if(values.userGroup.userGroupName == 'Faculty') {
				delete values.employeeType;
			} else {
				delete values.employeeType;
				delete values.facultyType;
			}
			var facultyType=null;
			if(values.facultyType!=null){
			
				facultyType=values.facultyType.id
			}
			
			jsonFormatFormData = {
					"id":values.id,
					"jobCode": values.jobCode,
					"jobTitle": values.jobTitle,
					"jobDescription": values.jobDescription,
					"fromDate":values.fromDate,
					"toDate":values.toDate,
					"status":isActive,
					"publishStatus":publishStatus,
					"employeeType":values.employeeType,
					"mappingStatus":values.mappingStatus,
					"coordinator":{
						"id":values.coordinator.id
					},
					"userGroup":{
						"id":values.userGroup.id
					},
					"facultyType":{
						"id":facultyType
						
					}
					
			}
			if(actionType == "DELETE"){

				if(publishStatus == "PUBLISHED"){
					showWarningMessage(getCommonTranslation('JOB_POSTING'),getCommonTranslation('DELETE_JOB_POSTING_ALERT_MESSAGE'));	
				}else{
					showConfirmMessage(getCommonTranslation('JOB_POSTING'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
							function(btn, text) {
						if (btn == 'yes'){
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		 
							$this.sendSaveAjaxRequest(SERVERURL.UPDATE_EMPLOYEE_JOB_POSTING, 'POST', jsonFormatFormData, function(option, success, response) {
								Ext.getBody().unmask();
								if(success){
									$this.loadJobPostingGrid();
									var Jobfilter =$this.getJobpostingfilter();
									var jobCode=Jobfilter.down("#jobCode");
									jobCode.getStore().reload();
									var jobTitle=Jobfilter.down("#jobTitle");
									jobTitle.getStore().reload();
									showSuccessMessage(getCommonTranslation('JOB_POSTING'), getCommonTranslation('SUCCESS'));
								}else{
									$this.loadJobPostingGrid();
									//alert(getErrorTranslation('CALENDER_DATE_MISMATCH'));
								}
						
				});
			  }
			});	
		}
			}else{
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		 
		$this.sendSaveAjaxRequest(SERVERURL.UPDATE_EMPLOYEE_JOB_POSTING, 'POST', jsonFormatFormData, function(option, success, response) {
			Ext.getBody().unmask();
			if(success){
				$this.loadJobPostingGrid();
				var Jobfilter =$this.getJobpostingfilter();
				var jobCode=Jobfilter.down("#jobCode");
				jobCode.getStore().reload();
				var jobTitle=Jobfilter.down("#jobTitle");
				jobTitle.getStore().reload();
				showSuccessMessage(getCommonTranslation('JOB_POSTING'), getCommonTranslation('SUCCESS'));
			}else{
				$this.loadJobPostingGrid();
				//alert(getErrorTranslation('CALENDER_DATE_MISMATCH'));
			}
		});
	}
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    saveJobPostingData: function(){
    	var $this = this;
    	var window = $this.getJobpostingaddformwindow();
    	var form = $this.getJobpostingformlayout().getForm();
    	var formlayout = $this.getJobpostingformlayout();
    	var grid=$this.getJobpostinggrid();
    	var values = form.getValues();
    	var isActive;
    	if(values.status!= "INACTIVE") {
    		isActive=true;
    	} else {
    		isActive=false;
    	}
    	var userGroupName = formlayout.down('#userGroupType').rawValue;
	    if(userGroupName == 'Other Employee') {
	    	delete values.facultyType;
		} else if(userGroupName == 'Faculty') {
			delete values.employeeType;
		} else {
			delete values.employeeType;
			delete values.facultyType;
		}
    	var id = values.id;
    	var jsonFormatFormData;
    	var submitUrl = '';
    	if(isNullOrEmpty(id)){
    		submitUrl = SERVERURL.SAVE_EMPLOYEE_JOB_POSTING;
    		jsonFormatFormData = {
    				"jobTitle": values.jobTitle,
    				"jobDescription": values.jobDescription,
    				"fromDate":values.fromDate,
    				"toDate":values.toDate,
    				"status":isActive,
    				"publishStatus":"UNPUBLISHED",
    				"mappingStatus":"UNMAPPED",
    				"employeeType":values.employeeType,
    				"coordinator":{
    					"id":values.coordinator
    				},
    				"userGroup":{
    					"id":values.userGroup.id
    				},
    				"facultyType":{
    					"id":values.facultyType
    				}
    		}
    	}
    	else{
    		submitUrl = SERVERURL.UPDATE_EMPLOYEE_JOB_POSTING;
    		jsonFormatFormData = {
    				"id":values.id,
    				"jobCode": values.jobCode,
    				"jobTitle": values.jobTitle,
    				"jobDescription": values.jobDescription,
    				"fromDate":values.fromDate,
    				"toDate":values.toDate,
    				"status":isActive,
    				"employeeType":values.employeeType,
    				"publishStatus":"UNPUBLISHED",
    				"coordinator":{
    					"id":values.coordinator
    				},
    				"userGroup":{
    					"id":values.userGroup.id
    				},
    				
    				"facultyType":{
    					"id":values.facultyType
    				}
    				
    		}
    	}
    	$this.applyWindowMask(); 

    	this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
    		$this.hideWindowMask();
    		if(success){
    			window.close();
    			$this.loadJobPostingGrid();
    			var Jobfilter =$this.getJobpostingfilter();
				var jobCode=Jobfilter.down("#jobCode");
				jobCode.getStore().reload();
				var jobTitle=Jobfilter.down("#jobTitle");
				jobTitle.getStore().reload();
    			showSuccessMessage(getCommonTranslation('JOB_POSTING'), getCommonTranslation('SUCCESS'));
    		}else{
    			window.close();
    			$this.loadJobPostingGrid();
    			//alert(getErrorTranslation('CALENDER_DATE_MISMATCH'));
    		}
    	});
    },
    configureJobPosting: function(){
    	var $this=this;
    	var grid = $this.getJobpostinggrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
			var id = records[0].get("id");
			var values = records[0].data;
			

	    	var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	    	var structure = Ext.widget('configurejobpostingtabstructure');
	    	var tabName = getCommonTranslation('CONFIGURE_JOB_POSTING');
	    	/**
	    	 * This is to remove tab from content panel and open same tab again
	    	 */
	    	var getcontroller=this.getController('menu.CoreERPNavigationController');
	    	var getTab=getcontroller.getTab(tabName);
	    	if(getTab!=null){
	    		contentPanel.remove(getTab, true);
	    	}
	    	var pnlJobPostingId = structure.down('#pnlJobPostingId');
	    	pnlJobPostingId.setTitle(values.jobCode);
	    	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_EIGHT);

	    	
	    	var grid = structure.down('configurejobpostingsetupgrid');
	    	/*structure.down('#committeeItemId').setValue(record.data.id)
	    	structure.down('#committeeName').setValue(record.data.committeeName);
	    	structure.down('#committeeCode').setValue(record.data.committeeCode);
	    	structure.down('#committeeFromDate').setValue(dateRender(record.data.validFromDate));
	    	structure.down('#committeeToDate').setValue(dateRender(record.data.validTillDate));*/
	    	grid.getStore().getProxy().extraParams={
	    		employeeJobPostingId:id
	    	};
	    	grid.config.employeeJobPostingId = id;
	    	structure.config.employeeJobPostingId = id;
	    	grid.getStore().load();
			
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openApplyToJobPosting: function(){
    	var $this=this;
    	var grid = $this.getJobpostinggrid();
    	if (grid.getSelectionModel().getCount() > 0) {

    		var records = grid.getSelectionModel().getSelection();
			var id = records[0].get("id");
			
			var tabName = getExaminationTranslation('APPLY_TO');
			var contentPanel = $this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
			var structure = Ext.widget('jobpostingapplytoform');
			/**
			 * This is to remove tab from content panel and open same tab again
			 */
			var getcontroller=$this.getController('menu.CoreERPNavigationController');
			var getTab=getcontroller.getTab(tabName);
			if(getTab!=null){
				contentPanel.remove(getTab, true);
			}
			structure.config.employeeJobPostingId = id;
			openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_EIGHT);
			var jobPostingContainerId = structure.down('#jobPostingContainerId');
			//Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			Ext.Ajax.request({
				  method : "GET",
				  type : 'rest',
				  url : SERVERURL.PATH_FIND_BY_EMP_JOB_POSTING_ID,
				  headers : {
					  'Content-Type' : 'application/json'
				  },
				  params : {
					  empJobPostingId : id
				  },
				  success : function(form,action) {
					  //Ext.getBody().unmask();
					  if(!isNullOrEmpty(form.responseText)){
						  var data = Ext.JSON.decode(form.responseText);
						  if(data.length>1){
							  jobPostingContainerId.removeAll();
							  data.forEach(function(obj){
								  var panelItem = new Array();
								  //var fieldContainer=obj.up('fieldcontainer');
								  var newcont=jobPostingContainerId.items.items.length;
								  var insertPosition=newcont+1;
								  panelItem.push({
									  xtype : 'fieldcontainer',
									  width: '100%',
									  layout : 'hbox',
									  defaults: {
										  width:226,
										  labelAlign: 'top'
									  },
									  items : [{
											xtype: 'hidden',
											name: 'jobMappingId',
											value:obj.id
										},{
										  xtype: 'customcombobox',
										  fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
										  name: 'academyLocation',
										  itemId: 'academyLocationId1',
										  editable: false,
										  allowBlank: false,
										  store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
										  displayField: 'value',
										  valueField: 'id',
										  listeners: {
											  render: function(combo){
												  $this.setAllowBlank(combo,false);
												  var cDepartmentStore= combo.getStore();
												  cDepartmentStore.load({
													  callback:function(record, operation, success){
														  combo.setValue(obj.academyLocation.id);
													  }
												  });
											  },
											  select: function(combo,record) {
												  var nextSiblingField = combo.nextSibling();
												  nextSiblingField.reset();
												  var academyLocationId = record[0].get('id');
												  var store = nextSiblingField.getStore();
												  store.getProxy().extraParams = {
													  academyLocationsIds: academyLocationId
												  };
												  store.load();
											  }
										  }
									  },{
										  xtype: 'nestedJsonCombo',
										  fieldLabel: getCommonTranslation('DEPARTMENT'),
										  name: 'department',
										  itemId: 'jobPostingDepartmentId1',
										  store: Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
										  valueField: 'id',
										  displayField: 'value',
										  editable: false,
										  allowBlank: false,
										  listeners: {
											  render: function(combo){
												  $this.setAllowBlank(combo,false);
												  var cDepartmentStore= combo.getStore();
												  cDepartmentStore.getProxy().extraParams = {
													  academyLocationsIds: obj.academyLocation.id
												  };
												  cDepartmentStore.load({
													  callback:function(record, operation, success){
														  combo.setValue(obj.department.id);
													  }
												  });
											  }
										  }
									  },{
										  xtype: 'customcombobox',
										  itemId:'jobPostingDesignationComboId1',
										  fieldLabel: getPersonModuleTranslation('DESIGNATION'),
										  store: Ext.create('Academia.store.common.DesignationTypeStore'),
										  valueField: 'id',
										  displayField: 'value',        
										  name : 'designation',
										  allowBlank: false,
										  editable: false,
										  triggerAcation: 'all',
										  fourceSelection: true,
										  listeners: {
											  render: function(combo){
												  $this.setAllowBlank(combo,false);
												  var cDepartmentStore= combo.getStore();
												  cDepartmentStore.load({
													  callback:function(record, operation, success){
														  combo.setValue(obj.designation.id);
													  }
												  });
											  }
										  }
									  },{
								            xtype: 'hiddenfield',
								            name: 'hiddenfield',
								            itemId: 'hidCkeditorTempId',
								            value:obj.alDescription
								        },{
								    		xtype: 'button',
								    		text: getCommonTranslation('ADD_VIEW_DESCRIPTION'),
								    		itemId: 'btnToAddCkEditor',
								    		cls: 'CustomBodyBtnSettings',
								    		style:{
												marginTop:'30px'
											},
											width:145
								    	},{
										  xtype:'fieldcontainer',
										  items:[{
											  xtype: 'button',
											  itemId: 'delJobPostingBtn',
											  cls: 'CustomBodyBtnReject',
											  glyph: ICONGLYPH.DELETEGLYPH,
											  tooltip: getCommonTranslation('DELETE'),
											  hidden:(insertPosition == 1 ? true : false),
											  style:{
												  marginTop:'30px'
											  },
											  listeners:{
												  click:function(obj){
													  var container = obj.up('fieldcontainer').up('fieldcontainer');
													  var jobMappingId = container.down("[name=jobMappingId]").getValue();
													  if(!isNullOrEmpty(jobMappingId)){
														  showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
																  function(btn, text) {
															  if (btn == 'yes') {
																  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
																  Ext.Ajax.request({
																	  method : "DELETE",
																	  type : 'rest',
																	  url : SERVERURL.PATH_EMPLOYEE_JOB_POSTING_LOCATION_DELETE+ '?id='+ jobMappingId,
																	  headers : {
																		  'Content-Type' : 'application/json'
																	  },
																	  params : {
																		  id : jobMappingId
																	  },
																	  success : function(form,action) {
																		  Ext.getBody().unmask();
																		  var form = $this.getJobpostingapplytoform();
																		  var panelContiner = form.down('#jobPostingContainerId');
																		  panelContiner.remove(container);
																		  form.getForm().checkValidity();
																		  showSuccessMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('SUCCESS'));
																	  }
																  });
															  }
														  });
													  }
													  else{
														  var form = $this.getJobpostingapplytoform();
														  var panelContiner = form.down('#jobPostingContainerId');
														  panelContiner.remove(container);
														  form.getForm().checkValidity();
													  }
												  }}
										  },{
											  xtype: 'button',
											  itemId: 'addJobPostingBtn',
											  cls: 'CustomBodyBtnSettings',
											  text: getCommonTranslation('ADDBUTTONTEXT'),
											  tooltip: getCommonTranslation('ADD'),
											  style:{
												  marginTop:'30px'
											  }
										  }]
									  }]
								  });
								  jobPostingContainerId.insert(insertPosition,panelItem);
								  jobPostingContainerId.doLayout();
							  });
						  }
						  else{
							  var academyLocationId = jobPostingContainerId.down("[name=academyLocation]");
							  var departmentFld = jobPostingContainerId.down("[name=department]");
							  var designationFld = jobPostingContainerId.down("[name=designation]");
							  var jobMappingId = jobPostingContainerId.down("[name=jobMappingId]");
							  var hiddenfield = jobPostingContainerId.down("[name=hiddenfield]");
							  
							  if(data.length>0){
								  var alId = data[0].academyLocation.id;
								  var departmentId = data[0].department.id;
								  var designationId = data[0].designation.id;
								  jobMappingId.setValue(data[0].id);
								  hiddenfield.setValue(data[0].alDescription);
								  var academyLocationIdStore= academyLocationId.getStore();
								  academyLocationIdStore.load({
									  callback:function(record, operation, success){
										  academyLocationId.setValue(alId);
									  }
								  });
								  var departmentIdStore= departmentFld.getStore();
								  departmentIdStore.getProxy().extraParams = {
									  academyLocationsIds: alId
								  };
								  departmentIdStore.load({
									  callback:function(record, operation, success){
										  departmentFld.setValue(departmentId);
									  }
								  });
								  var designationIdStore= designationFld.getStore();
								  designationIdStore.load({
									  callback:function(record, operation, success){
										  designationFld.setValue(designationId);
									  }
								  });
							  }
						  }
					  }
				  }
			  });
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    saveApplyToMappingJobPosting: function(){
    	var $this=this;
    	var form = $this.getJobpostingapplytoform();
    	//var values =form.getValue(); 
    	var contentPanel = $this.getContentpanel();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var jobPostingContainer = $this.getJobpostingapplytoform().down('#jobPostingContainerId');
    	var myJson = new Array();
    	var employeeJobPostingId = form.config.employeeJobPostingId;
    	if(jobPostingContainer.items.length>0){
    		Ext.each(jobPostingContainer.items.items, function(item) {
    			var obj=new Object();
    			var academyLocationId = item.down("[name=academyLocation]").getValue();
    			var departmentId = item.down("[name=department]").getValue();
    			var designationId = item.down("[name=designation]").getValue();
    			var jobMappingId = item.down("[name=jobMappingId]").getValue();
    			var alDescriptionId = item.down("[name=hiddenfield]").getValue();
    			obj.id = jobMappingId;
    			obj.employeeJobPosting = {
    					"id":employeeJobPostingId
    			};
    			obj.academyLocation = {
    					"id":academyLocationId
    			};
    			obj.department = {
    					"id":departmentId
    			};
    			obj.designation = {
    					"id":designationId
    			};
    			obj.alDescription = alDescriptionId;	
    			myJson.push(obj);
    		});

    		var formData = Ext.encode(myJson);
    		var submitUrl = SERVERURL.PATH_EMPLOYEE_JOB_POSTING_LOCATION_SAVE;
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: submitUrl,
    			jsonData: formData,
    			method: 'POST',
    			success: function(response, action) {
    				Ext.getBody().unmask();
    				var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    				var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    				if(getTabApplyTo!=null){
    					contentPanel.remove(getTabApplyTo, true);
    				}
    				showSuccessMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('SUCCESS'));
    				$this.loadJobPostingGrid();
    			},
				failure: function(form, action) {
					Ext.getBody().unmask();
					if(!isNullOrEmpty(form.responseText)){
						if(form.responseText.indexOf("Duplicate") != -1){
							showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('DUPLICATE_MAPPING_NOT_ALLOWD'));	
						}
						
					}
					
				}
    		});
    	}
    },
    addMultipleJobPostingMapping:function(obj){
    	var $this = this;
    	var form = $this.getJobpostingapplytoform();
    	var jobPostingContainer = form.down('#jobPostingContainerId');
    	var panelItem = new Array();
    	var fieldContainer=obj.up('fieldcontainer');
    	var newcont=jobPostingContainer.items.items.length;
    	var insertPosition=newcont+1;
    	panelItem.push({
    		xtype : 'fieldcontainer',
    		width: '100%',
    		layout : 'hbox',
    		defaults: {
    			width:226,
    			labelAlign: 'top'
    		},
    		items : [{
				xtype: 'hidden',
				name: 'jobMappingId',
			},{
	            xtype: 'customcombobox',
	            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            name: 'academyLocation',
	            itemId: 'academyLocationId1',
	            editable: false,
	            allowBlank: false,
	            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
	            displayField: 'value',
	            valueField: 'id',
	            listeners: {
	            	render: function(combo){
	            		$this.setAllowBlank(combo,false);
	            	},
	            	select: function(combo,record) {
	            		var nextSiblingField = combo.nextSibling();
	       				nextSiblingField.reset();
	       				var academyLocationId = record[0].get('id');
	       				var store = nextSiblingField.getStore();
	       				store.getProxy().extraParams = {
	       					academyLocationsIds: academyLocationId
	       				};
	       				store.load();
	       			}
				}
	            
	        },{
	            xtype: 'nestedJsonCombo',
	            fieldLabel: getCommonTranslation('DEPARTMENT'),
	            name: 'department',
	            itemId: 'jobPostingDepartmentId1',
	            store: Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
	            valueField: 'id',
	            displayField: 'value',
	            editable: false,
	            allowBlank: false,
	            listeners:{
	            	render: function(combo){
	            		$this.setAllowBlank(combo,false);
	            	}
	            }
	        },{
	    		xtype: 'customcombobox',
	    		itemId:'jobPostingDesignationComboId1',
	    		fieldLabel: getPersonModuleTranslation('DESIGNATION'),
	    		store: Ext.create('Academia.store.common.DesignationTypeStore'),
				valueField: 'id',
				displayField: 'value',        
				name : 'designation',
				allowBlank: false,
				editable: false,
	    		triggerAcation: 'all',
	    		fourceSelection: true,
	    		listeners:{
	            	render: function(combo){
	            		$this.setAllowBlank(combo,false);
	            	}
	            }
	    	},{
	            xtype: 'hiddenfield',
	            name: 'hiddenfield',
	            itemId: 'hidCkeditorTempId'
	        },{
	    		xtype: 'button',
	    		text: getCommonTranslation('ADD_VIEW_DESCRIPTION'),
	    		itemId: 'btnToAddCkEditor',
	    		ui: 'CustomBtnCancel',
	    		scale: CONSTANTS.BUTTONSIZE,
	    		style:{
					marginTop:'30px'
				},
				width:145
	        },{
	        	xtype:'fieldcontainer',
	        	items:[

	        		   {
	        			xtype: 'button',
	        			itemId: 'delJobPostingBtn',
	        			cls: 'CustomBodyBtnReject',
	        			glyph: ICONGLYPH.DELETEGLYPH,
	        			tooltip: getCommonTranslation('DELETE'),
	        			style:{
	        				marginTop:'30px'
	        			},
	        			listeners:{
	        				click:function(obj){
	        					var container = obj.up('fieldcontainer').up('fieldcontainer');
	        					var form = $this.getJobpostingapplytoform();
	        					var panelContiner = form.down('#jobPostingContainerId');
	        					panelContiner.remove(container);
	        					form.getForm().checkValidity();
	        				}}
	        		  },{

				        xtype: 'button',
				        itemId: 'addJobPostingBtn',
				        cls: 'CustomBodyBtnSettings',
				       text: getCommonTranslation('ADDBUTTONTEXT'),
				      tooltip: getCommonTranslation('ADD'),
				       style:{
					      marginTop:'30px'
				          }
	        		  
			       }]
	        }]
    	});
    	jobPostingContainer.insert(insertPosition,panelItem);
    	form.getForm().checkValidity();
    	jobPostingContainer.doLayout();
    },
    addCkEditor: function(btn) {
       var hiddenfield = btn.prev();
       var ckEditor = this.getJobpostingaddeditor();
        if (isEmpty(ckEditor)) {
        	ckEditor = Ext.widget('jobpostingaddeditor');
        }
        ckEditor.config.hidFielCkeditor=hiddenfield;
        ckEditor.show();
 
        if(!isNullOrEmpty(ckEditor.config.hidFielCkeditor.getValue())) {
        	var form = ckEditor.down('form');
        	var hidFieldCkeditor = ckEditor.config.hidFielCkeditor.getValue();
        	var ckeditor = form.down('#discriptionId');
        	var editor = CKEDITOR.instances[ckeditor.name];
        	editor.setData(hidFieldCkeditor);
        }
    },
    saveConfigurationJobPosting: function(){
    	var $this = this;
    	var grid = $this.getConfigurejobpostingsetupgrid();
    	var records = grid.getStore().getRange();
    	
    	var employeeJobPostingId = grid.config.employeeJobPostingId;
    	if(records.length>0){
    		var configureJsonArr = [];
    		records.forEach(function(rec){
    			var obj=new Object();
    			if(isNullOrEmpty(rec.data.employeeJobPostingFormModuleId)){
    				obj.employeeJobPostingFormModules = {
        					"id":rec.data.id
        			};
        			obj.id = rec.data.employeeJobPostingFormModuleId;
    			}
    			else{
    				obj.employeeJobPostingFormModules = {
        					"id":rec.data.employeeJobPostingFormModuleId
        			};
        			obj.id = rec.data.id;
    			}
    			obj.employeeJobposting = {
    					"id":employeeJobPostingId
    			};
    			obj.sequenceNo = rec.data.sequenceNo;
    			obj.visibility = rec.data.visibility;
    			
    			configureJsonArr.push(obj);
        	});

    		var formData = Ext.encode(configureJsonArr);
    		var submitUrl = SERVERURL.PATH_SAVE_EMPLYEE_JOB_MODULE_CONFIGURATION;
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: submitUrl,
    			jsonData: formData,
    			method: 'POST',
    			success: function(response, action) {
    				Ext.getBody().unmask();
    				
    				if(response.responseText != null){
    					grid.getStore().getProxy().extraParams={
        		    		employeeJobPostingId:employeeJobPostingId
        		    	};
        		    	grid.getStore().load();
        		    	showSuccessMessage(getCommonTranslation('JOB_POSTING'), getCommonTranslation('SUCCESS'));
    				}
    			}
    		});
    	}
    },
    resetApplyToMappingForm: function(){
    	var $this = this;
    	var form = $this.getJobpostingapplytoform();
    	var jobPostingContainer = form.down('#jobPostingContainerId');
    	form.getForm().reset();
    },
    
    saveJobPostingConfigureScreenData:function(){
    	var $this = this;
    	var grid = $this.getJobpostingsetupconfigurescreengrid();
    	var academyLocationId; 
    	var languageId;
    	var screenMode;
    	var screenName;
    	var configureArray = [];
    	var submitUrl;
    	var selectedRecord = grid.getSelectionModel().getSelection().length;
    	if(selectedRecord > 0){
    		var totalCount = grid.getStore().data.length;
    		var record = grid.getSelectionModel().getSelection();
    		for(var i=0;i<record.length;i++){
    			var isVisible;
    			var isVisibleField = record[i].data.isVisible;
    			if(isVisibleField == null || isVisibleField == 'Yes'){
    				isVisible = true;
    			}else{
    				isVisible = false;
    			}

    			var isMendate;
    			var isMendateField = record[i].data.isMandatory;
    			if(isMendateField == null || isMendateField == 'Optional'){
    				isMendate = false;
    			}else if(isMendateField == true || isMendateField == 'Mandatory'){
    				isMendate = true;
    			}else if (isMendateField == false) {
    				isMendate = false;
    			}

    			configureArray.push({
    				"formFieldId": record[i].data.formFieldId,
    				"formFieldDisplaySettingId": record[i].data.formFieldDisplaySettingId,
    				"screenName": record[i].data.screenName,
    				"screenMode": record[i].data.screenMode,
    				"defaultLabel": record[i].data.defaultLabel,
    				"fieldDisplayName": record[i].data.fieldDisplayName,
    				"isFieldLocked": record[i].data.isFieldLocked,
    				"isMandatory": isMendate,
    				"isVisible": isVisible,
    				"languageId":1,
    				"helpText": record[i].data.helpText,
    				"defaultValue": record[i].data.defaultValue,
    				"employeeJobPostingId": record[i].data.employeeJobPostingId,
    				"newLabel":record[i].data.newLabel,
    				"whetherForAllAcademyLocation":false
    			});
    		}

    		submitUrl = SERVERURL.CONFIGURE_SCREEN_SAVE;
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : configureArray,
    			method : 'POST',
    			success : function(form, action) {
    				Ext.getBody().unmask();
    				showSuccessMessage(getCommonTranslation('CONFIGURE_SCREEN'),getCommonTranslation('SUCCESS'));
    				grid.getStore().reload();
    			}
    		});
    	} 
    	else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    	}
    },
    saveJobPostingCustomColumnSetup:function(){
    	var this$ = this;
    	var setUpGrid = this$.getJobpostingsetupcustomcolumngrid();
    	var configureScreen = this$.getJobpostingsetupconfigurescreen();
    	var setupForm = setUpGrid.up('configurejobpostingtabstructure');
    	var employeeJobPostingId = setupForm.config.employeeJobPostingId;
    	var moduleId = configureScreen.down('#moduleItemId').getValue();
    	var moduleTableName = configureScreen.down('#moduleTableItemId').getValue();
    	var records = setUpGrid.getStore().data.items;
    	if(records.length > 0) {        	
    		var customColumnModuleSetup = new Array();
    		var visibilityParam=null;
    		var mandatoryParam = null;
    		
    		var customColumnModuleSetup = [];
    		records.forEach(function(rec){
    			var obj=new Object();
    			var mandatory;
    			if (rec.data.isVisible == null || rec.data.isVisible == false) {
    				mandatory = false;
    			}else{
    				mandatory = rec.data.isMandatory;
    			}
    			obj.id = rec.data.id;
    			obj.employeeJobFormModule = {
    					"id":rec.data.employeeJobFormModule.id
    			};
    			obj.employeeJobPosting = {
    					"id":employeeJobPostingId
    			};
    			obj.customFieldConfig = {
    					"id":rec.data.customFieldConfig.id
    			};
    			obj.isVisible = rec.data.isVisible;
    			obj.isMandatory = mandatory;
    			obj.whetherCustomField = rec.data.whetherCustomField;
    			
    			customColumnModuleSetup.push(obj);
        	});
    		
    		var recordsToUpdate = Ext.encode(customColumnModuleSetup);
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			method: 'post',
    			url: SERVERURL.PATH_CUSTOM_FIELD_CONFIG_EMPLOYEE_JOB_SAVE,
    			jsonData: recordsToUpdate,
    			success : function(response, action) {
    				var jsonData = Ext.JSON.decode(response.responseText);
    				var response = response.responseText;
    				Ext.getBody().unmask();
    				showSuccessMessage(getCommonTranslation('CUSTOM_COLUMN'), getCommonTranslation('SUCCESS'));
    				if(setUpGrid.getStore().getRange().length>0){
    					setUpGrid.getStore().removeAll();
    				}
    				setUpGrid.getStore().loadData(jsonData);
    			}
    		});
    	}
    },
    saveJobPostingDataReqSetup:function(){
    	var this$ = this;
    	var setUpGrid = this$.getJobpostingsetupdatarequirementgrid();
    	var records = setUpGrid.getStore().data.items;
    	var configureScreen = this$.getJobpostingsetupconfigurescreen();
    	var setupForm = setUpGrid.up('configurejobpostingtabstructure');
		var employeeJobPostingId = setupForm.config.employeeJobPostingId;
		var moduleId = configureScreen.down('#moduleItemId').getValue();
		var moduleTableName = configureScreen.down('#moduleTableItemId').getValue();
		
    	if(records.length > 0) {        	
    		var customColumnModuleSetup = new Array();
    		var visibilityParam=null;
    		var mandatoryParam = null;
    		var examPassed = null;
    		var competitiveExam = null;
    		var sequence = 0;
    		var identityType = null;
    		Ext.each(records, function(obj) {
    			var mandatory;
    			if (obj.data.isVisible == null || obj.data.isVisible == false) {
    				mandatory = false;
    			}else{
    				mandatory = obj.data.isMandatory;
    			}
    			if (obj.data.examPassed != null) {
    				examPassed = this$.getIdValueJson(obj.data.examPassed.id);
    			}
    			if (obj.data.competitiveExam != null) {
    				competitiveExam = this$.getIdValueJson(obj.data.competitiveExam.id);
    			}
    			if (obj.raw.identityType != null) {
    				identityType = this$.getIdValueJson(obj.raw.identityType.id);
    			}
    			customColumnModuleSetup.push({
    				"id" : obj.data.id,
    				"applicantPortalSetup":obj.raw.applicantPortalSetup,
    				"applicantPortalModules":obj.raw.applicantPortalModules,
    				"employeeJbFormModules":this$.getIdValueJson(obj.data.employeeJbFormModules.id),
    				"employeeJobPosting":this$.getIdValueJson(obj.data.employeeJobPosting.id),
    				"examPassed":examPassed,
    				"competitiveExam":competitiveExam,
    				"parentGuardianCode":obj.data.parentGuardianCode,
    				"parentGuardianValue":obj.data.parentGuardianValue,
    				"parentGuardianDisplay":obj.data.parentGuardianDisplay,
    				"relatedPersonAddressCode":obj.data.relatedPersonAddressCode,
    				"relatedPersonAddressValue":obj.data.relatedPersonAddressValue,
    				"relatedPersonAddressDisplay":obj.data.relatedPersonAddressDisplay,
    				"maximumEntry":obj.data.maximumEntry,
    				"minimumEntry":obj.data.minimumEntry,
    				"isVisible":obj.data.isVisible,
    				"isMandatory":mandatory,
    				"isOneTimeFee":obj.raw.isOneTimeFee,
    				"sequence":sequence,
    				"displayName":obj.data.displayName,
    				"guideline":obj.raw.guideline,
    				"documentPath":obj.raw.documentPath,
    				"documents":obj.raw.documents,
    				"examPassValueMaxCount":obj.raw.examPassValueMaxCount,
    				"isMultipleOfferLetters":obj.raw.isMultipleOfferLetters,
    				"identityType":identityType,
    			});
    			sequence++;
    		});

    		var recordsToUpdate = Ext.encode(customColumnModuleSetup);
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			method: 'post',
    			url: SERVERURL.PATH_CREATE_DATA_REQUIREMENT_SETUP,
    			jsonData: recordsToUpdate,
    			success : function(response, action) {
    				var jsonData = Ext.JSON.decode(response.responseText);
    				var response = response.responseText;
    				Ext.getBody().unmask();
    				showSuccessMessage(getCommonTranslation('DATA_REQUIREMENT'), getCommonTranslation('SUCCESS'));
    				if(setUpGrid.getStore().getRange().length>0){
    					setUpGrid.getStore().removeAll();
    				}
    				setUpGrid.getStore().loadData(jsonData);
    			}
    		});
    	}
    },
    getIdValueJson: function(id, value) {
    	if (id) return {
    		id: id,
    		value: value
    	};
    },
					   
    hideOrShowWeatherFaculty : function(userGroupName) {
    	var form = this.getJobpostingformlayout();
    	if (userGroupName == 'Other Employee') {

    		form.down('#employeeTypeId').setVisible(true);
    		form.down('#employeeTypeId').allowBlank = false;
    		form.down('#employeeTypeId').reset();
    		form.down('#facultyTypeId').setVisible(false);
    		form.down('#facultyTypeId').allowBlank = true;

    	} else if (userGroupName == 'Faculty') {

    		form.down('#facultyTypeId').setVisible(true);
    		form.down('#facultyTypeId').allowBlank = false;
    		form.down('#facultyTypeId').reset();

    		form.down('#employeeTypeId').setVisible(false);
    		form.down('#employeeTypeId').allowBlank = true;
    	} else {
    		form.down('#employeeTypeId').setVisible(false);
    		form.down('#employeeTypeId').allowBlank = true;
    		form.down('#facultyTypeId').setVisible(false);
    		form.down('#facultyTypeId').allowBlank = true;
    	}

    	var valid = form.isValid();
    	if (!valid) {
    		form.down('#submitBtn').setDisabled(true);
    	}
    },
    setPublishedButtonText: function(rowModel, record, index, eOpts) {
    	var me=this;
    	var systemEventPanel=me.getJobpostinggrid();   
    	if(rowModel){
    		var publishJobLinkBtn=systemEventPanel.down('#publishJobLink');
    		var unpublishJobLinkBtn=systemEventPanel.down('#unpublishJobLink');
    		if(!isEmpty(record.data)) {
    			if(record.get('publishStatus') == "UNPUBLISHED"){
    				publishJobLinkBtn.setVisible(true);
    				unpublishJobLinkBtn.setVisible(false);

    			}else{
    				unpublishJobLinkBtn.setVisible(true);
    				publishJobLinkBtn.setVisible(false);

    			}
    		}
    	}        
    },
    saveCkeditorData: function(){

    	var me=this;
    	var windowPanel=me.getJobpostingaddeditor();   
    	var form = windowPanel.down('form');
    	//var values=form.getValues();
    	var hidFieldCkeditor = windowPanel.config.hidFielCkeditor;
    	var ckeditor = form.down('#discriptionId');
    	var editor = CKEDITOR.instances[ckeditor.name];
    	var templateContent = editor.getData();
    	hidFieldCkeditor.setValue(templateContent);
    	windowPanel.close();
    },
    openEmployeeSendMessage:function(obj){

		var grid = this.getJobpostinggrid();
		if(grid.getSelectionModel().getCount()>0) {

			var $this=this;
			var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
			var structure = Ext.widget('employeesendmessages',{
				itemId:'employeeListSendMessageWindows'
			});
			var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
			/**
			 * This is to remove tab from content panel and open same tab again
			 */
			var getcontroller=this.getController('menu.CoreERPNavigationController');
			var getTab=getcontroller.getTab(tabName);
			if(getTab!=null){
				contentPanel.remove(getTab, true);
			}
			var formWindowTab = $this.getEmployeesendmessages();
			formWindowTab.down("#empSelectTemplate").allowBlank=true;
			formWindowTab.down("#empSelectTemplate").setVisible(false);
			formWindowTab.down("#empMessageName").allowBlank=true;   
			formWindowTab.down("#empMessageName").setVisible(false);
			var templateStore = formWindowTab.down('#empSelectTemplate').getStore();
			templateStore.getProxy().extraParams={
				msgRecipientTypeId:2
			};
			templateStore.load();

			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
				method : "GET",
				type : 'rest',
				url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
				headers : {
					'Content-Type' : 'application/json'
				},
				success : function(form,action) {
					var data = Ext.JSON.decode(form.responseText);
					formWindowTab.down("#id").setValue(data.id);
					formWindowTab.down("#code").setValue(data.code);
					formWindowTab.down("#empTemplateConfigName").setValue(data.empTemplateConfigName);
					formWindowTab.down("#empMsgSubCategoryId").setValue(data.empMsgSubCategoryId);
					formWindowTab.down("#empMsgCategoryId").setValue(data.empMsgCategoryId);
					Ext.getBody().unmask();

					//grid.getStore().reload();
					//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
				}

			});
			openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
			/*if (!formWindow) {
		    				Ext.widget('employeesendmessages');
		    				formWindow = $ this.getEmployeesendmessages();
		    			}
		    			formWindow.show(;*/

		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	selectMessageTemp: function(obj,rec){
		var $this =  this;
		var formWin = $this.getEmployeesendmessages();
		var empSubject = formWin.down('#empSubject');
		var smsDiscription = formWin.down('#empSmsDiscription');
		var smsDiscriptionNotice = formWin.down('#empSmsDiscriptionNotice');
		var pushNotificationDiscription = formWin.down('#empPushNotificationDiscription');
		var pushNotificationDiscriptionNotice = formWin.down('#empPushNotificationDiscriptionNotice');
		if(rec[0].data.value == "SMS")
		{  
			this.setAllowBlank (formWin.down("#empSubject"),true);
			//formWin.down("#empSubject").allowBlank=true;
			formWin.down("#empSubject").hide();
			formWin.down("#empStaticUploadFileField").hide();
			formWin.down("#employeeDocumentMessageAttachmentGrid").hide();
			formWin.down('#empDiscriptionId').reset();
			formWin.down('#empDiscriptionId').hide();	       		 
			formWin.down('#empSubject').reset();
			formWin.down('#empSmsDiscription').show();
			formWin.down('#empSmsDiscriptionNotice').show();
			pushNotificationDiscription.hide();
			pushNotificationDiscriptionNotice.hide();
			pushNotificationDiscription.reset();
		}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
			      		 empSubject.show();
			      		 formWin.down("#empStaticUploadFileField").hide();
			      		 this.setAllowBlank(empSubject,false);
			      		 formWin.down("#employeeDocumentMessageAttachmentGrid").hide();
			      		 formWin.down('#empDiscriptionId').reset();
			      		 formWin.down('#empDiscriptionId').hide();
			      		 empSubject.reset();
			      		 smsDiscription.reset();
			      		 smsDiscription.hide();
			      		 empSmsDiscriptionNotice.hide();
			      		 pushNotificationDiscription.reset();
			      		 pushNotificationDiscription.show();
			      		 pushNotificationDiscriptionNotice.show();
			      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
			      		 //formWin.down('#smsDiscription')
			      	 }*/else{
			      		 formWin.down('#empDiscriptionId').reset();
			      		 formWin.down('#empSmsDiscription').reset();
			      		 formWin.down('#empSmsDiscription').hide();
			      		 formWin.down('#empSmsDiscriptionNotice').hide();
			      		 formWin.down("#empStaticUploadFileField").show();
			      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
			      		 formWin.down("#employeeDocumentMessageAttachmentGrid").show();
			      		 formWin.down("#empSubject").reset();
			      		 formWin.down("#empSubject").show();
			      		 this.setAllowBlank (formWin.down("#empSubject"),false);
			      		 //formWin.down("#empSubject").allowBlank=false;
			      		 formWin.down('#empDiscriptionId').show();
			      		pushNotificationDiscription.hide();
			      		pushNotificationDiscriptionNotice.hide();
			      		pushNotificationDiscription.reset();
			      	 }
	},
	selectSectionMessageType : function(val,nV,oV){

		var $this =  this;
		var formWin = $this.getEmployeesendmessages();

		//var value = nV.1;
		formWin.down('#empRecieverTypeIncludeMySelf').setValue(false);
		if(nV.messageType==2){
			formWin.down("#empMessageId").hide();
			formWin.down("#empSelectTemplate").allowBlank=true;
			formWin.down("#empSelectTemplate").setVisible(false);     		 
			formWin.down("#empMessageName").allowBlank=true;   
			formWin.down("#empMessageName").setVisible(false);
			formWin.down("#empMsgTempletId").setVisible(true);
			formWin.down("#empMsgTempletId").allowBlank=false;
			formWin.down("#empMsgTempletId").reset();
			formWin.down("#empSubject").setVisible(true);
			//formWin.down("#empSubject").allowBlank=false;
			formWin.down("#empSubject").reset();
			formWin.down("#empDiscriptionId").setVisible(true);
			formWin.down("#empDiscriptionId").reset();
			formWin.down('#empSmsDiscription').reset();
			formWin.down('#empSmsDiscription').hide();
			formWin.down('#empSmsDiscriptionNotice').hide();
			formWin.down('#empPushNotificationDiscription').hide();
			formWin.down('#empPushNotificationDiscriptionNotice').hide();
			formWin.down('#empRecieverTypeIncludeMySelf').setVisible(true);
			this.setAllowBlank (formWin.down("#empSubject"),false);
		}else{
			formWin.down("#empMsgTempletId").allowBlank=true;
			formWin.down("#empMsgTempletId").setVisible(false);     		
			formWin.down("#empMessageId").setVisible(true);
			formWin.down("#empSelectTemplate").setVisible(true);     		
			formWin.down("#empMessageName").setVisible(true);
			formWin.down("#empMessageName").reset();
			//formWin.down("#empSubject").allowBlank=true;
			this.setAllowBlank (formWin.down("#empSubject"),true);
			formWin.down("#empSubject").setVisible(false);
			formWin.down("#empDiscriptionId").setVisible(false);
			formWin.down("#empMessageName").allowBlank=false;  
			formWin.down("#empSelectTemplate").allowBlank=false;
			formWin.down("#empSelectTemplate").reset();
			formWin.down("#employeeDocumentMessageAttachmentGrid").setVisible(false);
			formWin.down("#empStaticUploadFileField").setVisible(false);
			formWin.down('#empSmsDiscription').reset();
			formWin.down('#empSmsDiscription').hide();
			formWin.down('#empSmsDiscriptionNotice').hide();
			formWin.down('#empPushNotificationDiscription').hide();
			formWin.down('#empPushNotificationDiscriptionNotice').hide();
			formWin.down('#empRecieverTypeIncludeMySelf').setVisible(false);
			this.setAllowBlank (formWin.down("#empMessageName"),false);
			this.setAllowBlank (formWin.down("#empSelectTemplate"),false);
			// var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
			// formWin.down("#empMessageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
			//formWin.down("#empSelectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
		}
	},   
	loadStudentScheduleField : function(radio,newValue, oldValue){
		var adhocMessageForm = radio.up('form');
		var scheduleDateField = adhocMessageForm.down('#empScheduleDate');
		var scheduleTimeField = adhocMessageForm.down('#empScheduleTime');
		var radioValue = radio.getValue().empSendingPriority;

		if(radioValue=='IMMEDIATE'){
			scheduleDateField.setVisible(false);
			scheduleDateField.setDisabled(true);
			scheduleTimeField.setVisible(false);
			scheduleTimeField.setDisabled(true);    		
		}
		else if(radioValue=='SCHEDULE'){
			scheduleDateField.setVisible(true);
			scheduleDateField.setDisabled(false);
			scheduleTimeField.setVisible(true);
			scheduleTimeField.setDisabled(false);
		}
	}, 
	loadGridWithFileNameMessage:function(grid,value,store){
    	   grid.bindStore(store);
       },
	  /**
        * upload static document file for Student
        */
       uploadEmployeeStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
    	   var this$ = this;
    	   var setupForm = fileField.up('employeesendmessages');
    	   var grid = setupForm.down('#employeeStaticDocumentAttachmentGridMessage');
    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
    	   fileField.setRawValue(fileUploadPath);
    	   var file = fileField.fileInputEl.dom.files[0];
    	   fileField.setRawValue(fileUploadPath);
    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
    		   if(!isNullOrEmpty(fileUploadPath)){
    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    			   if (extension == "gif" || extension == "png" || extension == "bmp"
    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
    					   || extension == "doc" || extension == "docx" || extension == "txt"
    						   || extension == "xls" || extension == "csv" || extension == "xml" 
    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
    				   var entityId = 'student';
    				   var module = 'messaging';
    				   var entityType = 'template';
    				   var documentType = 'DOCUMENT';
    				   var isTransient = true;
    				   var this$ = this;
    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
    				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
    					   if(success){
    						   Ext.getBody().unmask();
    						   var path = Ext.JSON.decode(action.response.responseText).path;
    						   var user = this$.getCurrentlyLoggedInUser();
    						   var store = grid.getStore();
    						   var documentStatus = "SUBMITTED";
    						   var documentType = null;
    						   if(!isNullOrEmpty(path)){
    							   store.add({
    								   id: '',
    								   name: fileUploadPath,
    								   path: path ,
    								   createdBy : {
    									   id :user.id,
    									   value : user.value,
    									   code : user.code
    								   },
    								   status : documentStatus,
    								   documentType : documentType,
    								   templateConfigDocId: '',
    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

    							   });
    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
    						   }
    						   var form=this$.getEmployeesendmessages();
           	            	   var empSubject = form.down('#empSubject').getValue();
           	            	   if(!isNullOrEmpty(empSubject)){
           	            		   if(empSubject == ' '){
           	            			form.down('#empSubject').reset();
           	            		   }
           	            	   }
    						   fileField.reset();
    					   }

    				   }, isTransient);
    			   }else{
    				   fileField.reset();
    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
    			   }
    		   }
    	   }else{
    		   fileField.reset();
    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
    	   }
       }, 
       saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
	       	var submitUrl = '';
	       	var templateTab = this.getContentpanel();
	       	var formWin =  this.getEmployeesendmessages();
	       	var form = formWin.down('#empMsgDetailsForm');
	       	var id = form.down('#emp_document_hidden_field');
	           if (isNullOrEmpty(id.getSubmitValue())) {
	               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
	           }
	           var data = new Object();
	           if(!isNullOrEmpty(entityId)){
	           	data.entityId = entityId;
	           }else{
	           	data.entityId = null;
	           }
	           if(!isNullOrEmpty(module)){
	           	data.module = module;
	           }else{
	           	data.module = null;
	           }
	           if(!isNullOrEmpty(entityType)){
	           	data.entityType = entityType;
	           }else{
	           	data.entityType = null;
	           }
	           form.getForm().setValues(data);
	           form.getForm().submit({
	           	method : 'POST',
	           	url : submitUrl,
	           	success : function(form, action){
	           		callBackFunction(true, action, isTransient);
	           		
	           	}
	           });
	       },
	       deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	    	   var grid = view.up('#employeeStaticDocumentAttachmentGridMessage');
	    	   var panel = this.getContentpanel().getActiveTab();
	    	   var tabTitle = panel.title;
	    	   var store = grid.getStore();
	    	   var templateConfigDocId = record.get('templateConfigDocId');
	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	    	   if(!(tabTitle == viewTitle)){
	    		   if(!isNullOrEmpty(templateConfigDocId)){
	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    				   if (btn == 'yes') {
	    					   Ext.Ajax.request({
	    						   type: 'rest',
	    						   url: SERVERURL.STATIC_DOC_DELETE,
	    						   method: 'DELETE',
	    						   params: {
	    							   templateConfigDocId : templateConfigDocId
	    						   },
	    						   headers: {
	    							   'Content-Type': 'application/json'
	    						   },
	    						   success: function(form, action) {
	    							   store.remove(record);
	    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    						   }
	    					   });
	    				   }
	    			   });

	    		   }else{
	    			   store.remove(record);
	    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    		   }
	    	   }else{
	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	    	   }

	       },
	       openJobDescPopup: function(btn) {
	    	   var me = this;
	    	   if(!CONST.AI_ENABLED){
	    		   showWarningMessage(getExaminationTranslation("GENERATE_JOB_DESC"),
	    		   "AI Feature Is Not Enabled. Please contact administrator.");
	    		   return;
	    	   }
	    	   var ouput = me.getJobpostingformlayout().getForm().findField('jobDescription');
	    	   ouput.addCls('gpt-output');
	    	   ouput.reset();
	    	   var vals = btn.up('form').getValues();
	    	   Ext.Ajax.request({
					url: SERVERURL.PATH_GENERATE_JOB_DESCRIPTION,
					method: 'GET',
					params: {
						jobTitle: vals.jobTitle,
						shortDescription: vals.shortDescription
					},
					success: function(response) {
						if(response.responseText){
							ouput.removeCls('gpt-output');
							me.getJobpostingformlayout().down('[name=jobDescription]').setValue(response.responseText.trim());
						}
					}
				});
	    	  /* var formWindow = Ext.widget('aijobdescriptionpopup');
	    	   formWindow.show();*/
	    	   //formWindow.down('#jobTitleId').setValue(btn.up('form').down('#jobTitleId').getValue());
	       },
	       
	       resetJobDescPopup: function(btn) {
	    	   btn.up('form').getForm().reset();
	       },
	       
	       generateShortJobDesc: function(btn) {
	    	   var me = this;
	    	   btn.up('window').close();
	    	   var ouput = me.getJobpostingformlayout().getForm().findField('jobDescription');
	    	   ouput.addCls('gpt-output');
	    	   ouput.reset();
	    	   var vals = btn.up('form').getValues();
	    	   Ext.Ajax.request({
					url: SERVERURL.PATH_GENERATE_JOB_DESCRIPTION,
					method: 'GET',
					params: {
						jobTitle: vals.jobTitle,
						shortDescription: vals.shortDescription
					},
					success: function(response) {
						if(response.responseText){
							ouput.removeCls('gpt-output');
							me.getJobpostingformlayout().down('[name=jobDescription]').setValue(response.responseText.trim());
						}
					}
				});
	       },
	       
	       onChangeJobTitle: function(cmp, nval) {
	    	   if(!isNullOrEmpty(nval)) {
					cmp.up('form').down('#generateJobDescBtn').enable();
				}
				else {
					cmp.up('form').down('#generateJobDescBtn').disable();
				}
	       },
	       
	       onJobpostingformRender: function(cmp) {
	    	   var generateJobDescBtn = cmp.down('#generateJobDescBtn');
	    	   generateJobDescBtn.hide();
	    	   var shortDescription = cmp.down('#shortDescriptionItemId');
	    	   runPlaceHolderTypeWriting(shortDescription,'Jobposting');
	    	   var permissionMap = this.getPLACEMENT_JOB_POSTING_PERMISSION();
	    	   var associatedAcadLocationIds = new Array();
	    	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	    	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
	    	   if(permissionList.indexOf("GENERATE_JOB_DESC") != -1) {
	    		   generateJobDescBtn.show();
	    	   }
	       }
});