/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.controller.inventorymanagement.InventoryMgtController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [],
	views: ['inventorymanagement.InventoryMgtStructure','inventorymanagement.inventorymgtview'],
    config: {},        
	 refs: [{
		 ref: 'inventorymgtstructure',
		 selector: 'inventorymgtstructure'
	 }],
	 
	 init: function(application) {
		 this.control({
     	    'inventorymgtstructure': {
     	    	render: function(form) {
     	    		var me = this;
     	    		setTimeout(function(){
     					me.getActiveTabfromContentPanel().close();
     	    		},300);
     	    		var currentLoggedUser=this.getCurrentlyLoggedInUser();
     	    		var access_token=Ext.Ajax.defaultHeaders.access_token;
     	    		Ext.Ajax.request({
     	    			method: 'GET',
     	    			url: SERVERURL.PATH_PASS_USERID_CALL_V1API,
     	    			params: {
     	    				userName: currentLoggedUser.code,
     	    				access_token:access_token
     	    			},
     	    			success: function(response) {
     	    				if(response.responseText=='Credentials not found')
     	    				{
     	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_NOT_EXIST'));
     	    				}else{
     	    					var responseObject = Ext.decode(response.responseText);
     	    					var token = responseObject.key;
     	    					var tokenApiResponseLS = localStorage.getItem('tokenApiResponse');
     	    					if(!isNullOrEmpty(tokenApiResponseLS)){
     	    					var encodedTokenApiResponse = Base64.encode(tokenApiResponseLS);
     	    					var  url = CONSTANTS.V1_INTEGRATION_MODULE_PATH+"/getInitLoginFromV2.do?token="+token+"&tokenApiResponse="+encodedTokenApiResponse;
     	    					newOpenedTab = window.open(url);
     	    					}
     	    				}
     	    			}
     	    		});
     	    	}
     	    	}
						 
		 });
	 }
});