/**
 * @author Bhanu PS
 */
Ext.define('Academia.controller.leavemanagement.sanctionleave.LeaveSanctionSettingController', {
	extend: 'Academia.controller.base.BaseController',

    stores: ['leavemanagement.sanctionleave.SanctionCodeStore','leavemanagement.sanctionleave.SanctionSettingGridStore','leavemanagement.LeavePeriodEnumStore',
             'leavemanagement.LeaveTypeStore', 'common.AcademyLocationNameSeparated','leavemanagement.EnumEmployeeAttributeStore','leavemanagement.EligibilityALGridStore',
             'leavemanagement.EligibilityEnumStore','leavemanagement.EmployeeAttributeStore','department.DepartmentStore','leavemanagement.sanctionleave.SanctionLeaveTypeGridStore','leavemanagement.ApplyToSelectedALGridStore'],
             
    views: ['leavemanagement.sanctionleave.LeaveSanctionSettingStructure','leavemanagement.sanctionleave.SanctionSettingFilter','leavemanagement.sanctionleave.SanctionSettingForm',
            'leavemanagement.sanctionleave.SanctionSettingsGrid','leavemanagement.sanctionleave.AddSanctionSetting','leavemanagement.sanctionleave.ApplyToGridView','leavemanagement.SanctioningMappedAlWindow',
            'leavemanagement.sanctionleave.SanctionApplyToGrid','leavemanagement.sanctionleave.AddApplyToSanctionSettingFilter', 'leavemanagement.sanctionleave.AddApplyToSanctionSettingForm','leavemanagement.EligibilityMappedAlWindow'],
            
    
            
    refs: [{
    	ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref: 'leavesanctionsettingstructure',
        selector: 'leavesanctionsettingstructure'
    },{
    	ref: 'sanctionsettingfilter',
        selector: 'sanctionsettingfilter'
    },{
    	ref: 'sanctionsettingform',
        selector: 'sanctionsettingform'
    },{
    	ref: 'sanctionsettingsgrid',
        selector: 'sanctionsettingsgrid'
    },{
    	ref: 'addsanctionsetting',
        selector: 'addsanctionsetting'
    },{
    	ref: 'addsanctionsetting',
        selector: 'addsanctionsetting'
    },{
    	ref: 'applytogridview',
        selector: 'applytogridview'
    },{
    	ref: 'sanctionapplytogrid',
        selector: 'sanctionapplytogrid'
    },{
    	ref: 'addapplytosanctionsettingfilter',
        selector: 'addapplytosanctionsettingfilter'
    },{
    	ref: 'addapplytosanctionsettingform',
        selector: 'addapplytosanctionsettingform'
    },{
    	ref: 'sanctioningmappedalwindow',
        selector: 'sanctioningmappedalwindow'
    }],
    config: {
    	FACULTY_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNASSIGNEDREQUEST_PRIVILEGES'),
    	FACULTY_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	FACULTYDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTYDASHBOARD_PRIVILEGES')
    },
    init: function(application) {
        this.control({
       	 'sanctionsettingform button#quickSearchId':{
			   click: function(obj, record) {
				   this.searchDataList();
			   }
		   },
		   
		   'sanctionsettingform button#resetBtn':{
			   click: function(obj, record) {
				 this.getSanctionsettingform().getForm().reset();
			   }
		   },
		   
		   'sanctionsettingsgrid button#btnAdd':{
			   click: function(obj, record) {
				   this.openAddSanctionSettingTab();
			   }
		   },
		   
		   'sanctionsettingsgrid button#btnEdit':{
			   click: function(obj, record) {
				   this.editSanctionSettingTab();
			   }
		   },
		   
		   'sanctionapplytogrid button#btnAdd':{
			   click: function(obj, record) {
				   this.openAddApplyToSanction();
			   }
		   },
		   
		   'sanctionapplytogrid button#btnEdit':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid= $this.getSanctionapplytogrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.openAddApplyToSanction();
					   $this.editApplyToSanctioningLeaveType();
				   } else{
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'sanctionapplytogrid button#btnDelete':{
			   click: function(obj, record) {
				   var $this = this;
				   var grid= $this.getSanctionapplytogrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.deleteSanctioningLeaveTypeFunction();
				   } else{
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'sanctionapplytogrid ': {
	            cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	          	 var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	          	 if (e.target.tagName == 'A') {
	          		 this.openSanctioningDetailsWindow(columnName, record, ColIdx);
	          	 }
				}
			  }, 
		   
		   'sanctionsettingsgrid button#btnApplyToItemId':{
			   click: function(obj, record) {
				   var $this=this;
				   var grid = $this.getSanctionsettingsgrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   $this.openApplyToSanctioningView();
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   }
		   },
		   
		   'addsanctionsetting radiogroup[itemId=combinableId]':{
  			   change : function(value,newValue,oldValue){
  				   this.showHide(value,newValue,oldValue);
  			   }
  		   },
  		   
  		  'addsanctionsetting numberfield[itemId=minApplDaysItemId]':{
 			   change : function(obj, record){
 				   var $this = this;
 				   var form =  $this.getAddsanctionsetting().getForm();
 				//   form.findField('maxApplDays').reset();
 				   form.findField('maxApplDays').setMinValue(form.findField('minApplDays').getValue());
 			   }
 		   },
  		   
  		 
		   'addsanctionsetting':{
			   render : function(obj){
				   var $this = this;
					var form = $this.getAddsanctionsetting().getForm();
					var combinWith = form.findField('combinWith');
					combinWith.allowBlank=true;
  			   }
  		   },
  		   
  		  'addsanctionsetting button[itemId=resetBtn]':{
			   click : function(obj){
				    var $this = this;
					var form = $this.getAddsanctionsetting().getForm();
					form.reset();
 			   }
 		   },
 		   
 		  'addsanctionsetting button[itemId=saveBtn]':{
			   click : function(obj){
				    var $this = this;
					var form = $this.getAddsanctionsetting().getForm();
					var formValue = form.getValues();
					$this.saveSanctionSetting(form, formValue);
			   }
		   },
		   
 		  'addapplytosanctionsettingform multiselectcombofield[itemId=multiselectAcademyLocationId]' : {
			   render:function(obj,rec){
				   var store = obj.getStore();
				   store.load({
					   callback: function(records, operation, success) {
						   if (success) {
							   var allAl =[];
							   for(var i in records){
								   allAl.push(records[i].get("id"));
							   }
							   obj.setValue(allAl);
						   }
					   }
				   });

			   }
		   },
		   
		   'addapplytosanctionsettingform customcombobox[itemId=EligibilityEnumItemId]' : {
			   select:function(obj, rec){
				   var $this = this;
				   var form = $this.getAddapplytosanctionsettingform().getForm();
				   var multiLeaveType = form.findField("HRLeaveType");
				   var leaveType = form.findField("LeaveType");
				   var empAttributeType =  form.findField("empAttributeType");
				   var empAttributeValue =  form.findField("empAttributeValue");
				   var enumEmpAttributeValue =  form.findField("enumEmpAttributeValue");
				   var store = $this.getStore('leavemanagement.LeaveTypeStore');
				   store.getProxy().extraParams={
					   eligibilityCriteria:rec[0].data.id,
				   };
				   store.load();
				   if(rec[0].data.id != "EMPLOYEEATTRIBUTEBASED"){
					   multiLeaveType.setVisible(true);
					   leaveType.setVisible(false);
					   empAttributeType.setVisible(false);
					   multiLeaveType.allowBlank=false;
					   leaveType.allowBlank=true;
					   empAttributeType.allowBlank=true;
					   empAttributeValue.allowBlank=true;
					   enumEmpAttributeValue.allowBlank=true;
				   } else {
					   multiLeaveType.setVisible(false);
					   multiLeaveType.allowBlank=true;
					   leaveType.setVisible(true);
					   empAttributeType.setVisible(true);
					   leaveType.allowBlank=false;
					   empAttributeType.allowBlank=false;
					   empAttributeValue.allowBlank=false;
					   enumEmpAttributeValue.allowBlank=false;
				   }
				   empAttributeType.reset();
				   leaveType.reset();
				   multiLeaveType.reset();
				   form.isValid();
				   empAttributeValue.setVisible(false);
				   enumEmpAttributeValue.setVisible(false);
				   empAttributeValue.reset();
				   enumEmpAttributeValue.reset();
			   }
		   },
		   
		   'addapplytosanctionsettingform customcombobox[itemId=empAttributeTypeItemId]' : {
			   select:function(obj, rec){
				   var $this = this;
				   var form = $this.getAddapplytosanctionsettingform().getForm();
				   var empAttributeValue = form.findField("empAttributeValue");
				   var enumEmpAttributeValue = form.findField("enumEmpAttributeValue");
				   if(rec[0].data.type=="ENUM"){
					   empAttributeValue.reset();
					   empAttributeValue.setVisible(false);
					   empAttributeValue.allowBlank=true;
					   enumEmpAttributeValue.setVisible(true);
					   enumEmpAttributeValue.reset();
					   enumEmpAttributeValue.allowBlank=false;
					   if(rec[0].data.value=="GENDER"){
						   enumEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.ENQUIRY_GENDER;
						   enumEmpAttributeValue.getStore().load();
					   }
				   } else {
					   if(rec[0].data.value=="department"){
						   empAttributeValue.getStore().getProxy().api.read=SERVERURL.DEPARTMENT_GRIDDATA;
						   empAttributeValue.getStore().load();
					   }
					   empAttributeValue.setVisible(true);
					   empAttributeValue.reset();
					   empAttributeValue.allowBlank=false;
					   enumEmpAttributeValue.reset();
					   enumEmpAttributeValue.setVisible(false);
					   enumEmpAttributeValue.allowBlank=true;
				   }
				   
			   }
		   },
		   
		   'addapplytosanctionsettingform button#saveBtn':{
			   click: function(obj, record) {
				   this.saveApplyToSanctioning();
			   }
		   },
		   
		   'addapplytosanctionsettingform button#cancelBtn':{
			   click: function(obj, record) {
				   this.getAddapplytosanctionsettingfilter().close();
			   }
		   },
		   
		   'sanctioningmappedalwindow grid[itemId=attributeGrid] button[itemId=btnDelete]':{
			   click : function(obj){
				  this.deleteSanctioningAttributeValues();
			   }
		   },
        });
    },
    
    editApplyToSanctioningLeaveType:function(){
    	var $this = this;
    	var filter = $this.getAddapplytosanctionsettingform();
    	var form = filter.getForm();
    	var grid = $this.getSanctionapplytogrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var multiselectAcademyLocation = form.findField('multiselectAcademyLocation');
    	var EligibilityEnum = form.findField('EligibilityEnum');
    	var HRLeaveType = form.findField('HRLeaveType');
    	var LeaveType = form.findField('LeaveType');
    	var empAttributeType = form.findField('empAttributeType');
    	var empAttributeValue = form.findField('empAttributeValue');
    	var enumEmpAttributeValue = form.findField('enumEmpAttributeValue');
    	
    	multiselectAcademyLocation.getStore().load({
    		callback:function(rec){
    			var arr=[];
    			for(var i in rec){
    				for(var j in record.data.academyLocationIdName){
    					if(rec[i].data.value==record.data.academyLocationIdName[j]){
        					arr.push(rec[i].data.id);
        				}
    				}
    			}
    			multiselectAcademyLocation.setValue(arr);
    		}
    	});
    	EligibilityEnum.getStore().load({
			callback:function(rec){
				for(var i in rec){
					if(rec[i].data.id==record.data.eligibilityCtiteria){
						EligibilityEnum.setValue(rec[i].data.id);
					}
				}
			}
		});
    	if(record.data.eligibilityCtiteria == "EMPLOYEEATTRIBUTEBASED"){
    		HRLeaveType.setVisible(false);;
    		HRLeaveType.allowBlank=true;
    		LeaveType.setVisible(true);;
    		LeaveType.allowBlank=false;
    		LeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:'EMPLOYEEATTRIBUTEBASED'
    		};
    		LeaveType.getStore().load({
    			callback:function(rec){
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						LeaveType.setValue(rec[i].data.id);
    					}
    				}
    			}
    		});
    		 empAttributeType.setVisible(true);;
			 empAttributeType.allowBlank=false;
			 empAttributeType.getStore().load({
				 callback:function(rec){
					 if(record.data.employeeAttributeType=='Gender'){
						 empAttributeType.setValue(rec[0].data.id); 
					 } else {
						 empAttributeType.setValue(rec[1].data.id); 
					 }
				 }
			 });
    		if(record.data.employeeAttributeType=='Gender'){
    			  empAttributeValue.setVisible(false);;
    			  empAttributeValue.allowBlank=true;
    			  enumEmpAttributeValue.setVisible(true);;
    			  enumEmpAttributeValue.allowBlank=false;
    			  enumEmpAttributeValue.getStore().getProxy().api.read=SERVERURL.ENQUIRY_GENDER;
    			  enumEmpAttributeValue.getStore().load({
    				  callback:function(rec){
    					  var arr=[];
    					  for(var i in rec){
    						  for(var j in record.data.employeeAttributeValues){
    							  if(rec[i].data.id==record.data.employeeAttributeValues[j]){
    								  arr.push(rec[i].data.id);
    							  }
    						  }
    					  }
    					  enumEmpAttributeValue.setValue(arr);
    				  }
    			  });
    		} else {
    			enumEmpAttributeValue.setVisible(false);;
    			enumEmpAttributeValue.allowBlank=true;
    			empAttributeValue.setVisible(true);;
    			empAttributeValue.allowBlank=false;
    			empAttributeValue.getStore().getProxy().api.read=SERVERURL.DEPARTMENT_GRIDDATA;
    			empAttributeValue.getStore().load({
    				callback:function(rec){
    					var arr=[];
    					for(var i in rec){
    						for(var j in record.data.employeeAttributeValues){
    							if(rec[i].data.name==record.data.employeeAttributeValues[j]){
        							arr.push(rec[i].data.id);
        						}
    						}
    					}
    					empAttributeValue.setValue(arr);
    				}
    			});
    		}
    	} else {
    		empAttributeValue.setVisible(false);;
    		empAttributeValue.allowBlank=true;
    		enumEmpAttributeValue.setVisible(false);;
    		enumEmpAttributeValue.allowBlank=true;
    		empAttributeType.setVisible(false);;
    		empAttributeType.allowBlank=true;
    		LeaveType.setVisible(false);;
    		LeaveType.allowBlank=true;
    		HRLeaveType.setVisible(true);;
    		HRLeaveType.allowBlank=false;
    		HRLeaveType.getStore().getProxy().extraParams={
    			eligibilityCriteria:'GENERIC'
    		};
    		HRLeaveType.getStore().load({
    			callback:function(rec){
    				var arr=[];
    				for(var i in rec){
    					if(rec[i].data.id==record.data.hrLeaveTypeId){
    						arr.push(rec[i].data.id);
    					}
    				}
    				HRLeaveType.setValue(arr);
    			}
    		});
    	}
    	form.isValid();
    	filter.down('#saveBtn').setText('Save');
    },
    
    openSanctioningDetailsWindow:function(title, record, ColIdx){
		var $this = this;
		var formWindow = this.getSanctioningmappedalwindow();
 	    if (!formWindow) {
 		   Ext.widget('sanctioningmappedalwindow');
 		   formWindow = this.getSanctioningmappedalwindow();
 	    }
	    formWindow.show();
	    var gridAl = formWindow.down('#alGridItemId');
	    var gridAttr = formWindow.down('#attributeGrid');
	    gridAttr.hide();
	    gridAl.hide();
	    if(ColIdx==3){
	    	gridAttr.show();
	    	formWindow.setTitle(getCommonTranslation('ATTRIBUTE_VALUE'));
			var gridStore =  gridAttr.getStore();
			gridStore.removeAll();
			var details;
			if(record.data.employeeAttributeValues.length != 0){
				for(var i in record.data.employeeAttributeValues){
					if(!isNullOrEmpty(record.data.employeeAttributeLongValues)){
						details={
								'id':record.data.employeeAttributeLongValues[i],
								'value':record.data.employeeAttributeValues[i]
						};
					} else {
						details={
								'value':record.data.employeeAttributeValues[i]
						};
					}
					gridStore.loadRawData(details, true);
				}
			}
	    } else{
	    	gridAl.show();
	    	formWindow.setTitle(getCommonTranslation('ACADEMY_LOCATION'));
			var gridStore =  gridAl.getStore();
			gridStore.removeAll();
			var details;
			if(record.data.academyLocationIdName.length != 0){
				for(var i in record.data.academyLocationIdName){
					details={
							'value':record.data.academyLocationIdName[i],
					};
					gridStore.loadRawData(details, true);
				}
			}
	    }
    },
    
    deleteSanctioningLeaveTypeFunction:function() {
    	var $this=this;
    	var grid = $this.getSanctionapplytogrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var attributeName = !isNullOrEmpty(record.data.employeeAttributeType)?record.data.employeeAttributeType:'';
    	showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    		function(btn, text) {
				if (btn == 'yes') {
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "DELETE",
						type : 'rest',
						url : SERVERURL.PATH_SANCTION_LEAVE_TYPE_DELETE+ '?id='+ record.data.hrSanctioningSettingId+"&eligibilityCtiteria="+record.data.eligibilityCtiteria
						+"&attributeName="+attributeName+"&hrLeaveTypeId=" + record.data.hrLeaveTypeId,
						headers : {
							'Content-Type' : 'application/json'
						},
						params : {
							id : record.data.hrEligibilitySettingId,
							eligibilityCtiteria:record.data.eligibilityCtiteria,
							attributeName:record.data.employeeAttributeType
						},
						success : function(form,action) {
							Ext.getBody().unmask();
							showSuccessMessage(getCommonTranslation('SANCTION_SETTING'),getCommonTranslation('SUCCESS'));
							grid.getStore().reload();
						}
					});
				}
    	});
    },
    
    searchDataList:function(){
    	var $this = this;
    	var formValue = $this.getSanctionsettingform().getForm().getValues();
    	var grid = $this.getSanctionsettingsgrid();
    	grid.getStore().getProxy().extraParams={
    		id:formValue.sanctionCode
    	};
    	$this.resetGridSetting(grid);
    	grid.getStore().load();
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = $this.getSanctionsettingform();
    },
    
    openAddSanctionSettingTab:function(){
    	var $this = this;
		var contentPanel = $this.getLeavesanctionsettingstructure();
			var newTab = contentPanel.items.findBy(function(tab) {
				return tab.title === getCommonTranslation('ADD_SANCTION_SETTING_LIST');
			});
			if (!newTab) {
				contentPanel.add({
					title: getCommonTranslation('ADD_SANCTION_SETTING_LIST'),
					closable : true,
					autoScroll:true,
					xtype : 'addsanctionsetting',
				}).show();
			}
			contentPanel.setActiveTab(newTab);
			contentPanel.doLayout();
    },
    showHide:function(value,newValue,oldValue){
	    var $this = this;
		var form = $this.getAddsanctionsetting().getForm();
		var combinWith = form.findField('combinWith');
		if(newValue.isCombinable==true){
			combinWith.show();
			combinWith.reset();
			combinWith.allowBlank=false;
		} else {
			combinWith.hide();
			combinWith.reset();
			combinWith.allowBlank=true;
		}
		form.isValid();
	},
	
	editSanctionSettingTab:function(form, formValue){
    	var $this = this;
    	var grid = $this.getSanctionsettingsgrid();
    	if(grid.getSelectionModel().getCount()>0){
    		$this.openAddSanctionSettingTab();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var form = $this.getAddsanctionsetting().getForm();
    		var filter = $this.getAddsanctionsetting();
    		var id = form.findField('id');
    		var sanctionCode = form.findField('sanctionCode');
    		var minApplDays = form.findField('minApplDays');
    		var maxApplDays = form.findField('maxApplDays');
    		var maxSanctionPeriod = form.findField('maxSanctionPeriod');
    		var maxTimeToSanction = form.findField('maxTimeToSanction');
    		var maxLeaveToSanction = form.findField('maxLeaveToSanction');
    		var daysForAdvanceAppl = form.findField('daysForAdvanceAppl');
    		var daysBeforeEvent = form.findField('daysBeforeEvent');
    		var daysAfterEvent = form.findField('daysAfterEvent');
    		var holidayCheckId = filter.down('#holidayCheckId');
    		var combinableId = filter.down('#combinableId');
    		var combinWith = form.findField('combinWith');
    		
    		id.setValue(record.data.id);
    		daysAfterEvent.setValue(record.data.daysAfterEvent);
    		daysBeforeEvent.setValue(record.data.daysBeforeEvent);
    		daysForAdvanceAppl.setValue(record.data.daysForAdvanceApplication);
    		maxApplDays.setValue(record.data.maxApplicationDays);
    		minApplDays.setValue(record.data.minApplicationDays);
    		maxLeaveToSanction.setValue(record.data.maxLeavesToSanction);
    		maxTimeToSanction.setValue(record.data.maxTimesToSanction);  
    		sanctionCode.setValue(record.data.sanctioningCode)
    		
    		if(record.data.isCombinable){
    			combinableId.items.items[0].setValue(true);
        		combinableId.items.items[1].setValue(false);
        		combinWith.getStore().load({
        			callback:function(rec){
        				var arr=[];
        				for(var i in rec){
        					for(var j in record.data.leaveTypeIds){
        						if(rec[i].data.id == record.data.leaveTypeIds[j]){
        							arr.push(rec[i].data.id);
        						}
        					}
        				}
        				combinWith.setValue(arr);
        			}
        		});
        		
        		combinWith.setVisible(true);
        		combinWith.allowBlank=false;
    		} else {
    			combinWith.setVisible(false);
        		combinWith.allowBlank=true;
    		}
    		if(record.data.isHolidayCheck){
    			holidayCheckId.items.items[0].setValue(true);
    			holidayCheckId.items.items[1].setValue(false);
    		}
    		maxSanctionPeriod.getStore().load({
    			callback:function(rec){
    				for(var i in rec){
    					if(rec[i].data.id == record.data.maxSanctioningPeriod){
    						maxSanctionPeriod.setValue(rec[i].data.id );
    						break;
    					}
    				}
    			}
    		});
    		filter.down('#saveBtn').setText("Save");
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
	},
	
	saveSanctionSetting:function(form, formValue){
    	var $this = this;
    	var filter = $this.getAddsanctionsetting();
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var grid = $this.getSanctionsettingsgrid();
    	var id=null;
    	/*if(filter.down("#saveBtn").getText()=="Save"){
    		if(grid.getSelectionModel().getSelection().length > 0) {
    			var record = grid.getSelectionModel().getSelection()[0];
    			id=record.data.id;
    		}
    	}*/
    	if(!isNullOrEmpty(formValue.id)) {
    		id=formValue.id;
    	}
    	if(!formValue.isCombinable){
    		var submitValue={
    				'id':id!= undefined?id:null,
    				'maxApplicationDays':formValue.maxApplDays,
    				'minApplicationDays':formValue.minApplDays,
    				'maxSanctioningPeriod':formValue.maxSanctionPeriod,
    				'maxTimesToSanction':formValue.maxTimeToSanction,
    				'maxLeavesToSanction':formValue.maxLeaveToSanction,
    				'daysForAdvanceApplication':formValue.daysForAdvanceAppl,
    				'daysBeforeEvent':formValue.daysBeforeEvent,
    				'daysAfterEvent':formValue.daysAfterEvent,
    				'isHolidayCheck':formValue.isholidayCheck,
    				'isCombinable':formValue.isCombinable,
    				'sanctioningCode':formValue.sanctionCode
    				//'otherSanctioningCriteria':
    		}
    	} else {
    		var combinedWith=[];
    		if(formValue.combinWith != undefined || !isNullOrEmpty(formValue.combinWith)){
    			if(formValue.combinWith[0].data != undefined || !isNullOrEmpty(formValue.combinWith[0].data)){
    				for(var i in formValue.combinWith) {
    					combinedWith.push(formValue.combinWith[i].data.id);
    				}
    			} else {
    				for(var i in formValue.combinWith) {
    					combinedWith.push(formValue.combinWith[i]);
    				}
    			}
    		}
    		var submitValue={
    				'id':id!= undefined?id:null,
    				'maxApplicationDays':formValue.maxApplDays,
    				'minApplicationDays':formValue.minApplDays,
    				'maxSanctioningPeriod':formValue.maxSanctionPeriod,
    				'maxTimesToSanction':formValue.maxTimeToSanction,
    				'maxLeavesToSanction':formValue.maxLeaveToSanction,
    				'daysForAdvanceApplication':formValue.daysForAdvanceAppl,
    				'daysBeforeEvent':formValue.daysBeforeEvent,
    				'daysAfterEvent':formValue.daysAfterEvent,
    				'isHolidayCheck':formValue.isholidayCheck,
    				'isCombinable':formValue.isCombinable,
    				'leaveTypeIds':combinedWith,
    				'sanctioningCode':formValue.sanctionCode
    				//'otherSanctioningCriteria':
    		}
    	}
    	var submitUrl;
    	if(! isNullOrEmpty(id)){
    		submitUrl = SERVERURL.PATH_SANCTION_SETTING_UPDATE
    	} else {
    		submitUrl = SERVERURL.PATH_SANCTION_SETTING_SAVE
    	}
    	
    	Ext.Ajax.request({
    		method : "GET",
    		type : 'rest',
    		url : SERVERURL.PATH_SANCTIONING_SETTING_CODE_EXISTS,
    		params:{
    			id:id,
    			code:formValue.sanctionCode
    		},
    		success : function(response, action) {
    			var resp = Ext.decode(response.responseText);
    			if(resp){
    				Ext.getBody().unmask();
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LEAVE_CODE_EXISTS_MSG'));
    			}
    			else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : submitValue,
    					method : 'POST',
    					success : function(form, action) {
    						 Ext.getBody().unmask();
    						 showSuccessMessage(getCommonTranslation('ADD_SANCTION_SETTING_LIST'),getCommonTranslation('SUCCESS'));
    						 var grid =$this.getSanctionsettingsgrid();
    						 grid.getStore().reload();
    						 grid.getSelectionModel().deselectAll();
    						 var tabName = getCommonTranslation('ADD_SANCTION_SETTING_LIST');
    						 var leaveSetting  = $this.getLeavesanctionsettingstructure();
    						 var tabs = leaveSetting.items.items;
    						 for(var i in tabs){
    							 if(tabs[i].title===tabName){
    								 leaveSetting.remove( tabs[i],true);
    							 }
    						 }
    					}
    				});
    			}
    		}
    	});
	},
	
	openApplyToSanctioningView:function(){
    	var $this = this;
		var contentPanel = $this.getLeavesanctionsettingstructure();
		var newTab = contentPanel.items.findBy(function(tab) {
			return tab.title === getCommonTranslation('SANCTION_SETTINGS_APPLY_TO');
		});
		if (!newTab) {
			contentPanel.add({
				title: getCommonTranslation('SANCTION_SETTINGS_APPLY_TO'),
				closable : true,
				autoScroll:true,
				xtype : 'applytogridview',
			}).show();
		}
		contentPanel.setActiveTab(newTab);
		contentPanel.doLayout();
		var grid = $this.getSanctionapplytogrid();
		var leaveSettingsgrid = $this.getSanctionsettingsgrid();
		var record = leaveSettingsgrid.getSelectionModel().getSelection()[0];
		grid.getStore().getProxy().extraParams={
			sanctionSettingId:record.data.id
		};
		grid.getStore().load();
    },
    
    openAddApplyToSanction:function(){
    	var $this = this;
    	var $this = this;
		var formWindow = $this.getAddapplytosanctionsettingfilter();
 	    if (!formWindow) {
 		   Ext.widget('addapplytosanctionsettingfilter');
 		   formWindow = $this.getAddapplytosanctionsettingfilter();
 	    }
 	   formWindow.show();
    },
    
    saveApplyToSanctioning:function(){
    	var $this=this;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var contentpanel = this.getContentPanel();
    	var filter = $this.getAddapplytosanctionsettingform();
    	var form = filter.getForm();
    	var fromValue = form.getValues();
    	var grid = $this.getSanctionapplytogrid();
    	var leaveSettingsgrid =$this.getSanctionsettingsgrid();
    	var record = leaveSettingsgrid.getSelectionModel().getSelection()[0];
    	var empAttributeType;
    	if(!isNullOrEmpty(form.findField("empAttributeType").valueModels) && form.findField("empAttributeType").valueModels.length!=0){
    		empAttributeType=form.findField("empAttributeType").valueModels[0].data.type;
    	}
    	var submitValue =[], alIds=[];
    	var id;
    	var submitUrl;
    	if(filter.down('#saveBtn').getText()=='Save'){
    		if(grid.getSelectionModel().getSelection().length > 0) {
    			id = grid.getSelectionModel().getSelection()[0].data.id;
    		}
    	}
    	submitUrl = SERVERURL.PATH_SANCTION_LEAVE_TYPE_UPDATE;
    	for(var i in fromValue.multiselectAcademyLocation){
    		if(fromValue.multiselectAcademyLocation[i].data == undefined){
    			alIds.push(fromValue.multiselectAcademyLocation[i]);
    		} else {
    			alIds.push(fromValue.multiselectAcademyLocation[i].data.id);
    		}
    	}	
    	if(fromValue.EligibilityEnum=="EMPLOYEEATTRIBUTEBASED"){
    		var enumEmpAttribute;
    		if(empAttributeType=='ENUM'){
    			for (var i in fromValue.enumEmpAttributeValue){
    				if(fromValue.enumEmpAttributeValue[i].data == undefined){
            			enumEmpAttribute=fromValue.enumEmpAttributeValue[i];
            		} else {
            			enumEmpAttribute=fromValue.enumEmpAttributeValue[i].data.id;
            		}
    				var data={
    						'id':id,
        	    			'hrSanctioningSettingId':record.data.id,
        	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
        	    			'hrLeaveTypeId':fromValue.LeaveType,
        	    			'employeeAttributeType':empAttributeType,
        	    			'employeeAttributeValue':enumEmpAttribute,
        	    			'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
        	    			'academyLocationIds':alIds
        	    	};
    				submitValue.push(data);
    			}
        	} else {
        		for (var i in fromValue.empAttributeValue){
        			var empAttributeValue;
        			if(fromValue.empAttributeValue[i].data == undefined){
        				empAttributeValue=fromValue.empAttributeValue[i];
            		} else {
            			empAttributeValue=fromValue.empAttributeValue[i].data.id;
            		}
        			var data={
        					'id':id,
        	    			'hrSanctioningSettingId':record.data.id,
        	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
        	    			'hrLeaveTypeId':fromValue.LeaveType,
        	    			'employeeAttributeType':empAttributeType,
        	    			'employeeAttributeValue':empAttributeValue,
        	    			'hrEmployeeAttributeMasterId':fromValue.empAttributeType,
        	    			'academyLocationIds':alIds
        	    	};
        			submitValue.push(data);
        		}
        	}
    	} else {
    		for (var i in fromValue.HRLeaveType){
    			var leaveTp;
    			if(fromValue.HRLeaveType[i].data == undefined){
    				leaveTp=fromValue.HRLeaveType[i];
        		} else {
        			leaveTp=fromValue.HRLeaveType[i].data.id;
        		}
    			var data={
    					'id':id,
    					'hrSanctioningSettingId':record.data.id,
    	    			'eligibilityCtiteria':fromValue.EligibilityEnum,
    	    			'hrLeaveTypeId':leaveTp,
    	    			'academyLocationIds':alIds
    	    	};
    			submitValue.push(data);
    		}
    	}
    	 Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : submitValue,
				method : 'POST',
				success : function(form, action) {
					 Ext.getBody().unmask();
					 showSuccessMessage(getCommonTranslation('SANCTION_SETTINGS_APPLY_TO'),getCommonTranslation('SUCCESS'));
					 grid.getStore().reload();
					 grid.getSelectionModel().deselectAll();
					 $this.getAddapplytosanctionsettingfilter().close();
				}
			});
    },
    deleteSanctioningAttributeValues:function(){
    	var $this=this;
    	var winGrid = $this.getSanctioningmappedalwindow().down('#attributeGrid');
    	if (winGrid.getSelectionModel().getCount() > 0) {
    		if(winGrid.store.data.items.length==1){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ATTRIBUTE_REQUIRED'));
    			return;
    		}
    		var records = winGrid.getSelectionModel().getSelection()[0];
    		var grid = $this.getSanctionapplytogrid();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var attributeValue = record.data.hrEmployeeAttributeMasterId==1?records.data.value:records.data.id;
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_SANCTION_LEAVE_TYPE_DELETE_ATTRIBUTE+ "?eligibilityCtiteria="+record.data.eligibilityCtiteria
    					+"&hrEmployeeAttributeMasterId="+record.data.hrEmployeeAttributeMasterId+"&hrLeaveTypeId=" + record.data.hrLeaveTypeId
    					+"&attributeValue=" +attributeValue,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params : {
    						id : record.data.hrEligibilitySettingId,
    						eligibilityCtiteria:record.data.eligibilityCtiteria,
    						attributeName:record.data.employeeAttributeType
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('SANCTION_SETTINGS_APPLY_TO'),getCommonTranslation('SUCCESS'));
    						grid.getStore().reload();
    						grid.getSelectionModel().deselectAll();
    						$this.getSanctioningmappedalwindow().close();
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    }
});
