Ext.define('Academia.controller.organization.AddressController', {
    extend: 'Ext.app.Controller',

    stores: ['organization.AddressTypeStore', 'common.CountryStore',
             'organization.CityStore', 'organization.CountryRegionStore',
             'organization.CountryRegionStore1','organization.CityByCountryRegion','common.OtherAddressCopyStore','common.CityPinCodeStoreSmartSearch'],
    views: ['Academia.view.organization.addresses.AddressDetails', 
            'Academia.view.common.AddressFieldsForm',
            'Academia.view.organization.addresses.CustomAddressDisplayField',
            'organization.addresses.AddressFormWindow'],
    models: ['Academia.model.organization.Address', 'Academia.model.organization.OrganizationAddress','Academia.model.common.OtherAddressCopyModel'],
    //requires: ['Academia.view.organization.addresses.AddressFormWindow'],

    refs: [{
        ref: 'addressdetailsform',
        selector: 'addressdetailsform'
    }, {
        ref: 'addressFormWindow',
        selector: 'addressFormWindow'
    }, {
        ref: 'addressfieldsform',
        selector: 'addressFormWindow form[itemId=addressfieldsform]'
    }],
    
    config:{
    	ORGANIZATION_STRUCTURE_ADDRESS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_ADDRESS_PRIVILEGES'),
    },
    
    init: function(application) {
    	this.suspendOrgCityEvent=false;
        this.control({
            'addressdetailsform': {
                render: function(form) {
                	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                	 var modifyAddress1 =  form.down('button#modifyAddress1');
                     var printAddress1 = form.down('button#printAddress1');
                     var modifyAddress2 = form.down('button#modifyAddress2');
                     var printAddress2 = form.down('button#printAddress2');
                     var printallAddress = form.down("#printallAddress");
                     modifyAddress1.setVisible(false);
                     modifyAddress2.setVisible(false);
                    // printAddress1.setVisible(false);
                  //   printAddress2.setVisible(false);
                   //  printallAddress.setVisible(false);
                    this.getAddress();
                }
            },
            "button#printAddress1": {
                click: function() {
                    var addressDisplayField = this.getAddressdetailsform().down('displayfield#customAddressDisplayField1');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "button#printAddress2": {
                click: function() {
                    var addressDisplayField =  this.getAddressdetailsform().down('displayfield#customAddressDisplayField2');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "button#printallAddress": {
                click: function() {
                    var addressDisplayField = this.getAddressdetailsform().down('displayfield#customAddressDisplayField1');
                    var addressDisplayField2 = this.getAddressdetailsform().down('displayfield#customAddressDisplayField2');

                    var allAddressDisplayField = Ext.create('Academia.view.organization.addresses.CustomAddressDisplayField');
                    var str = addressDisplayField.value;
                    str += " \n <hr>";
                    str += addressDisplayField2.value;

                    allAddressDisplayField.setValue(str);
                    this.onPrintClick(allAddressDisplayField);
                }
            },
            "button#modifyAddress1": {
                click: function() {
                    var customAddressDisplayField1 =  this.getAddressdetailsform().down('displayfield#customAddressDisplayField1');
                    this.onModifyClick(customAddressDisplayField1);
                }
            },
            "button#modifyAddress2": {
                click: function() {
                    var customAddressDisplayField2 =  this.getAddressdetailsform().down('displayfield#customAddressDisplayField2');
                    this.onModifyClick(customAddressDisplayField2);
                }
            },
            'addressFormWindow form[itemId=addressfieldsform]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = this.getAddressfieldsform().down('customcombobox#cityId');
                    cityComboBox.setDisabled(false);
                    this.suspendOrgCityEvent=true;
                    cityComboBox.reset();
                    this.suspendOrgCityEvent=false;
                    var cityPinCodeComboBox = this.getAddressfieldsform().down('customcombobox#pincodeNewId');
                    cityPinCodeComboBox.reset();
                    var pincodeId = this.getAddressfieldsform().down("#pincodeId");
                    pincodeId.reset();
                    pincodeId.setDisabled(true);
                    var pincodeNewId = this.getAddressfieldsform().down("#pincodeNewId");
                    pincodeNewId.clearValue();
                    pincodeNewId.setDisabled(true);
                    var countryRegion1 = record[0].get("id");
//                    var store = this.getStore('organization.CountryRegionStore1');
                    var store = cityComboBox.getStore();
//                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                },
                change: function(obj1, newValue) {
                	var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                	if(!isNullOrEmpty(newValue)){                	
                		cityComboBox.setDisabled(false);
                	}else{
                		cityComboBox.setDisabled(true); 
                	}
                }
            },
            'addressFormWindow form[itemId=addressfieldsform]  customcombobox#countryId': {
                select: function(obj, record) {
                    var cityComboBox = this.getAddressfieldsform().down('customcombobox#cityId');
                    this.suspendOrgCityEvent=true;
                    cityComboBox.clearValue();
                    this.suspendOrgCityEvent=false;
                    cityComboBox.setDisabled(true);

                    var cityPinCodeComboBox = this.getAddressfieldsform().down('customcombobox#pincodeNewId');
                    cityPinCodeComboBox.clearValue();
                    
                    var genericField1ComboBox = this.getAddressfieldsform().down('customcombobox#parentCountryRegionId');
                    genericField1ComboBox.reset();
                    genericField1ComboBox.setDisabled(false);

                    var pincodeId = this.getAddressfieldsform().down("#pincodeId");
                	pincodeId.reset();
                	pincodeId.setDisabled(true);
                	var pincodeNewId = this.getAddressfieldsform().down("#pincodeNewId");
                	pincodeNewId.clearValue();
                	pincodeNewId.setDisabled(true);
                    
                   /* var genericField2ComboBox = this.getAddressfieldsform().down('customcombobox#genericFieldId2');
                    genericField2ComboBox.reset();*/

                    var countryId = record[0].get("id");
                    
                    
                    /*var cityStore = cityComboBox.getStore();
                    cityStore.getProxy().extraParams = {
                        id: countryId
                    };
                    cityStore.load();*/
                    
                    var countryRegionStore = genericField1ComboBox.getStore();
                    countryRegionStore.getProxy().extraParams = {
                        cid: countryId
                    };
                    countryRegionStore.load();
                    var form = this.getAddressfieldsform()
                  	var countryCodeField = form.down("#cellCountryCode");
                   	var mobileField = form.down("#cellNo");
                   	this.setMaximumMinimumDigitsForMobileNoValidationInAddress(form,countryCodeField,mobileField,null);
        			
                    
                    /*var countryRegion2Store = genericField2ComboBox.getStore();
                    countryRegion2Store.removeAll();*/
                },
                
                change: function(obj, newValue) {
                	var regionComboBox = obj.up('form').down('customcombobox#parentCountryRegionId');
                	if(!isNullOrEmpty(newValue)){
                		regionComboBox.setDisabled(false);	
                	}else{
                		regionComboBox.setDisabled(true);	
                	}
             	   var phoneCountryCode = this.getAddressfieldsform().down('customcombobox#phoneCountryCode');
             	   var cellCountryCode = this.getAddressfieldsform().down('customcombobox#cellCountryCode');
             	   var countryStore = this.getAddressfieldsform().down('customcombobox#countryId').getStore();
             	   var val=  countryStore.getById(newValue);
             	   phoneCountryCode.setValue(val);
             	   cellCountryCode.setValue(val);
             }
            },
            'addressFormWindow form[itemId=addressfieldsform]  customcombobox#cityId':{
            	select: function(obj1, record) {
            		var me = this;
            		var city = record[0].get("id");
            		var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: getPinCodeUrl1,
            			method: 'GET',
            			headers: {
            				'Content-Type': 'application/json'
            			},
            			params: {
            				id: city
            			},
            			success: function(res, action) {
            				var data = res.responseText;
            				if(!isNullOrEmpty(data) && data !="[]"){
            					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
            					obj1.up('form').down('textfield#pincodeId').setVisible(false);
            					obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
            					setTimeout(function(){
            						obj1.up('form').down('customcombobox#pincodeNewId').reset();
            						obj1.up('form').down('customcombobox#pincodeNewId').clearValue();
            					},100);
            					var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
            					store.getProxy().extraParams = {
            						id: city
            					};
            					store.reload();
            				}else{
            					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
            					obj1.up('form').down('textfield#pincodeId').setVisible(true);
            					obj1.up('form').down('textfield#pincodeId').setDisabled(false);
            					obj1.up('form').down('textfield#pincodeId').reset();
            				}
            			}
            		});
            	},
            	change: function(obj1, newValue) {
            		if(!this.suspendOrgCityEvent){
            			var cityPinCodeTextBox = obj1.up('form').down('textfield#pincodeId');
            			var cityPinCodeComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
            			if(!isNullOrEmpty(newValue)){                	
            				cityPinCodeComboBox.setDisabled(false);
            				cityPinCodeTextBox.setDisabled(false);
            			}else{
            				cityPinCodeTextBox.setDisabled(true);
            				cityPinCodeTextBox.reset();
            				cityPinCodeComboBox.setDisabled(true);
            				cityPinCodeComboBox.clearValue();
            			}

            			var me = this;
            			if(!isNullOrEmpty(newValue) && isNumberValidate(newValue)){
            				var city = newValue;
            			}else{
            				var city = '';
            			}

            			var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            			Ext.Ajax.request({
            				type: 'rest',
            				url: getPinCodeUrl1,
            				method: 'GET',
            				headers: {
            					'Content-Type': 'application/json'
            				},
            				params: {
            					id: city
            				},
            				success: function(res, action) {
            					var data = res.responseText;
            					if(!isNullOrEmpty(data) && data !="[]"){
            						obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
            						obj1.up('form').down('textfield#pincodeId').setVisible(false);
            						obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
            						var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
            						store.getProxy().extraParams = {
            							id: city
            						};
            						store.reload();
            					}else{
            						obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
            						obj1.up('form').down('textfield#pincodeId').setVisible(true);
            						obj1.up('form').down('textfield#pincodeId').setDisabled(false);
            					}
            				}
            			});
            		}
            	}
            },
            'addressFormWindow form[itemId=addressfieldsform]': {             
         	   afterrender: function(form){
         		   var me = this;
         		   form.down('#parentCountryRegionId').setDisabled(true);
         		   form.down('#cityId').setDisabled(true);
         		   form.down('#pincodeNewId').setDisabled(true);
         		   var getPinCodeUrl = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
         		   Ext.Ajax.request({
         			   type: 'rest',
         			   url: getPinCodeUrl,
         			   method: 'GET',
         			   headers: {
         				   'Content-Type': 'application/json'
         			   },
         			   success: function(res, action) {
         				   var data = res.responseText;
         				   if(!isNullOrEmpty(data)){
         					   form.down('#pincodeNewId').setVisible(true);
         					   form.down('#pincodeId').setVisible(false);
         					   if(form.down('#pincodeNewId').defaultVal){
         						   form.down('#pincodeNewId').setValue(form.down('#pincodeNewId').defaultVal);
         					   }
         				   }else{
         					   form.down('#pincodeNewId').setVisible(false);
         					   form.down('#pincodeId').setVisible(true);
         					   if(form.down('#pincodeId').defaultVal){
         						   form.down('#pincodeId').setValue(form.down('#pincodeId').defaultVal);
         					   }
         				   }
         			   }
         		   });
         	   }
            },
            'addressFormWindow#orgAddressWindow button#saveButtonId': {
                click: this.saveAddress
            },
            'addressFormWindow button#cancelButtonId': {
                click: this.resetForm
            }, 
           
		'addressdetailsform customcombobox[itemId=cellCountryCode]': {
			select: function(rowModel, record){
			var this$ = this;
            var form = this.getAddressdetailsform()
          	var countryCodeField = form.down("#cellCountryCode");
           	var mobileField = form.down("#cellNo");
           	this$.setMaximumMinimumDigitsForMobileNoValidationInAddress(form,countryCodeField,mobileField,record);
			}
		},
		'addressdetailsform numberfield[itemId=cellNo]': {
			change: function(record){
			  var this$ = this;
			 var form = this.getAddressdetailsform()
             var mobileField = form.down("#cellNo");
          	mobileField.isValid();
  			form.getForm().checkValidity();
          }
		}
     });
    },

    getAddress: function() {
        var regAddress = false,
            workAddress = false,
            this$=this;
        
        var organization= Academia.model.singleton.Organization;
        
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.ORGANIZATION_GET_ADDRESS,
            params: {
                orgnizationId: organization.id
            },
            method: 'GET',
            success: function(responser, action) {
                var data = Ext.decode(responser.responseText);
                var addressDisplayField1 = this$.getAddressdetailsform().down('displayfield#customAddressDisplayField1');
                var addressDisplayField2 = this$.getAddressdetailsform().down('displayfield#customAddressDisplayField2');

                var AddressTpl = Ext.create('Ext.XTemplate', 
                		'<p><B>{addressText}</B></p>',
                		'<tpl if=\'city != null\'>',
                		'{city.value} , </tpl> {code}<br>', 
                		'<tpl if=\'countryRegion != null\'>',
                		'{countryRegion.value}<br></tpl> ',
                		'<tpl if=\'parentCountryRegion != null\'>',
                		'{parentCountryRegion.value},</tpl> {country.value}<br>', 
                		'<tpl if=\'phoneNo != null\'>',
                			getCommonTranslation('ADDRESS_PHONE_NUMBER')+' '+'{phoneCountryCode}-',
                			'<tpl if=\'phoneAreaCode != null\'>',
                				'{phoneAreaCode}-</tpl>',
                			'{phoneNo}</tpl><br>', 
                			'<tpl if=\'cellNo != null\'>',
                				getCommonTranslation('ADDRESS_MOBILE_NO')+' '+'{cellCountryCode}-{cellNo}</tpl><br>',
                		'{primaryeEmailId}');
                
                Ext.each(data, function(obj) {
                    if (obj['addressType']['id'] == 1) {
                        regAddress = true;
                        addressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
                        addressDisplayField1.setModel(obj);
                    } else {
                        workAddress = true;
                        addressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
                        addressDisplayField2.setModel(obj);
                    }
                });
                var modifyAddress1 =  this$.getAddressdetailsform().down('button#modifyAddress1');
                var printAddress1 = this$.getAddressdetailsform().down('button#printAddress1');
                var modifyAddress2 = this$.getAddressdetailsform().down('button#modifyAddress2');
                var printAddress2 = this$.getAddressdetailsform().down('button#printAddress2');
                var printallAddress =this$.getAddressdetailsform().down("#printallAddress");
                var regAddressFormButton = "ADD";
                var workAddressFormButton = "ADD";
                
                if(regAddress){
                	 modifyAddress1.setText(getCommonTranslation('MODIFY'));
//                     printAddress1.setVisible(true);
                     regAddressFormButton = "MODIFY";
                }
                else{
                    modifyAddress1.setText(getCommonTranslation('ADD_ADDRESS'));
                    //printAddress1.setVisible(false);
                    var object = new Object();
                    object.addressType = 1;
                    addressDisplayField1.setModel(object);
                }
                if ( workAddress) {
                	  modifyAddress2.setText(getCommonTranslation('MODIFY'));
//                	  printAddress2.setVisible(true);
                	  workAddressFormButton = "MODIFY";
                }
                else{
                    modifyAddress2.setText(getCommonTranslation('ADD_ADDRESS'));
                //    printAddress2.setVisible(false);
                    var object = new Object();
                    object.addressType = 2;
                    addressDisplayField2.setModel(object);
                }
                
                if(regAddress && workAddress){
//                	 printallAddress.setVisible(true);
                	 this$.disableOrganizationStructureAddressPrivileges(regAddressFormButton, workAddressFormButton);
                }else{
                	 this$.disableOrganizationStructureAddressPrivileges(regAddressFormButton, workAddressFormButton);
                //	 printallAddress.setVisible(false);
                }
                Ext.getBody().unmask();
            }
        });
    },
    resetForm: function(button) {
    	button.up('window').close();
    },
    saveAddress: function(model) {
        var this$ = this;
        var form = this.getAddressfieldsform().getForm();
        if (form.isValid()) {

            var values = form.getValues();
//            if(this$.validatePhone(values))
//        	{
	            var address = new Academia.model.organization.Address();
	            var submitUrl;
	            var successMessage;
	            var id = form.findField('id').getSubmitValue();
	            form.updateRecord(address);
	            address.set('country', this.getIdValueJson(values.country));
	            address.set('parentCountryRegion', this$.getIdValueJson(values.parentCountryRegion));
	            address.set('countryRegion', this$.getIdValueJson(values.countryRegion));
	            address.set('city', this$.getIdValueJson(values.city));
	            address.set('pincode', values.pincode);
	            address.set('faxNumber', values.faxNumber);
	            address.set('addressType', this$.getIdValueJson(values.addressType));
	            address.set('pincodeNew', this$.getIdValueJson(values.pincodeNew));
	            var organizationAddress = new Academia.model.organization.OrganizationAddress();
	            organizationAddress.set("address", address.data);
	            var organization= Academia.model.singleton.Organization;
	            organizationAddress.set("organizationId", organization.id);
	
	
	            var formData = Ext.encode(organizationAddress.data);
	            if (id == null || id == "") {
	                submitUrl = SERVERURL.ORGANIZATION_ADDRESS_CREATE;
	                successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
	            } else {
	                submitUrl = SERVERURL.ORGANIZATION_ADDRESS_UPDATE;
	                successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
	            }
				
	           /* Ext.Ajax.request({
	                type: 'rest',
	                url: submitUrl,
	                jsonData: formData,
	                method: 'POST',
	                success: function(form, action) {
	                	showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
	                    this$.getAddress();
	                    this$.resetForm(model);
	                }
	            });
	            */
	            
	            var otherAddressTypeIds=[];
	            var otherAddressVals = form.findField('otherAddressTypeId').getValue();
	            if(otherAddressVals != undefined && otherAddressVals.length > 0){
	            	if(!isNaN(otherAddressVals[0])){
	            		if(otherAddressVals[0] !=""){
	            			otherAddressTypeIds.push(otherAddressVals[0].data.id);	
	            		}
	            	}
	            	else{
	            		for(var i in otherAddressVals){
	            			otherAddressTypeIds.push(otherAddressVals[i].data.id);
	            		}
	            	}
	            }

	            submitUrl = submitUrl+'?otherAddressTypes='+otherAddressTypeIds.join();				
	            Ext.Ajax.request({
	            	type: 'rest',
	            	url: SERVERURL.ORGANIZATION_IS_ADDRESS_EXIST + '?orgnizationId=' +organization.id +'&otherAddressTypes='+ otherAddressTypeIds.join() ,
	            	method: 'GET',
	            	success: function(form, action) {
	            		var response = Ext.decode(form.responseText);
	            		if(response.length>0){
	            			var message = 'Are you sure, you want to continue?';
	            			showConfirmMessage(getCommonTranslation('WARNING'),message, function(btn, text) {
	            				if (btn == 'yes') {
	            					Ext.Ajax.request({
	            						type: 'rest',
	            						url: submitUrl,
	            						jsonData: formData,
	            						method: 'POST',
	            						success: function(form, action) {
	            							showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
	            							this$.getAddress();
	            							this$.resetForm(model);
	            						}
	            					});
	            				}
	            			});
	            		}
	            		else{
	            			Ext.Ajax.request({
	            				type: 'rest',
	            				url: submitUrl,
	            				jsonData: formData,
	            				method: 'POST',
	            				success: function(form, action) {
	            					showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
	            					this$.getAddress();
	            					this$.resetForm(model);
	            				}
	            			});
	            		}
	            	}
	            });
//	    	} 
        }
    },
    onPrintClick: function(addressDisplayField) {
        Ext.ux.Printer.print(addressDisplayField);
    },
    onModifyClick: function(customAddressDisplayField) {
        var this$ = this;
        // Enable Form.
        var addressFormWindow = Ext.widget('addressFormWindow',{
        	itemId:'orgAddressWindow'
        });
        addressFormWindow.show();
        addressFormWindow.down('#otherAddressTypeItemId').show();

        var addressTypeComboBox = addressFormWindow.down('#addressTypeId');
//        addressTypeComboBox.setReadOnly(true);
        addressTypeComboBox.setVisible(false);
        
        var websiteURLItemId = addressFormWindow.down('#websiteURLItemId');
        websiteURLItemId.setVisible(true);
        
        var data = customAddressDisplayField.getModel();
        var addressdetailsform = this.getAddressfieldsform();
        this.setAddressFormData(data,addressdetailsform);
        
        var otherAddressType = addressFormWindow.down('#otherAddressTypeItemId');

        if(isNaN(data.addressType)){
        	if(!isNullOrEmpty(data.addressType.id)) {
        		otherAddressType.getStore().getProxy().setExtraParam('addressTypeId', data.addressType.id);
        	}
        }
        else{
        	otherAddressType.getStore().getProxy().setExtraParam('addressTypeId', data.addressType);
        }

        otherAddressType.getStore().getProxy().setExtraParam('addressCategory', 'ORG');
        otherAddressType.getStore().load();
        
       // var form = this.getAddressdetailsform();
    	var countryCodeField = addressdetailsform.down("#cellCountryCode");
    	var mobileField = addressdetailsform.down("#cellNo");
    	this.setMaximumMinimumDigitsForMobileNoValidationInAddress(addressdetailsform, countryCodeField, mobileField, null);
   
    },


    setAddressFormData : function(data,addressdetailsform){
    	
        var form = addressdetailsform.getForm();
        form.reset();
        
        if(data){
	        this.setIdFromNestedObject(data, "addressType");
	        this.setIdFromNestedObject(data, "country");
	        this.setIdFromNestedObject(data, "parentCountryRegion");
	        this.setIdFromNestedObject(data, "countryRegion");
	        this.setIdFromNestedObject(data, "city");

	        var countryId = data["country"];
	        var countryRegionId = data["parentCountryRegion"];
	        var pinCodeId = data["pincodeNew"];
	        this.setAddressTypeDropDown(data["addressType"], addressdetailsform);
	        if (countryId) {
	            this.setCountryDropDown(countryId, addressdetailsform);
	            this.setCityropDown(countryRegionId, data["city"], addressdetailsform);
	            this.setPincodeDropDown(pinCodeId,data["city"],addressdetailsform);
	            this.setRegion1DropDown(countryId, data["parentCountryRegion"], addressdetailsform);
	            this.setRegion2DropDown(data["parentCountryRegion"], data["countryRegion"], addressdetailsform);
	        }
	        
	        form.setValues(data);
        }
        
    },
    setAddressTypeDropDown: function(value, addressdetailsform) {
        var addressTypeComboBox = addressdetailsform.down('#addressTypeId');
        addressTypeComboBox.store.load({
            callback: function(records, operation, success) {
                if (success) {
                    if(addressTypeComboBox && value)
                    	addressTypeComboBox.setValue(value);
                }
            }
        });
    },

    setCountryDropDown: function(countryId, addressdetailsform) {

        var countryComboBox = addressdetailsform.down('#countryId');
        if (!countryComboBox.store.items) {
            countryComboBox.store.load({
                callback: function(records, operation, success) {
                    if (success) {
                        if(countryComboBox && countryId)
                        	 countryComboBox.setValue(countryId);
                    }
                }
            });
        }
    },
    setCityropDown: function(countryId, cityId, addressdetailsform) {
    	var cityComboBox = addressdetailsform.down('#cityId');
    	cityComboBox.getStore().getProxy().extraParams = {
            id: countryId
        };
    	cityComboBox.getStore().load({
            callback: function(records, operation, success) {
                if (success) {
                    
                    if(cityComboBox && cityId)
                    	cityComboBox.setValue(cityId);
                }
            }
        });
    },
    setPincodeDropDown: function(pincodeId,cityId, addressdetailsform) {
    	var pincodeComboBox = addressdetailsform.down('#pincodeNewId');
    	pincodeComboBox.getStore().getProxy().extraParams = {
            id: cityId
        };
    	pincodeComboBox.getStore().load({
            callback: function(records, operation, success) {
                if (success) {
                    if(pincodeComboBox && pincodeId)
                    	pincodeComboBox.setValue(pincodeId.id);
                }
            }
        });
    },
    setRegion1DropDown: function(countryId, regionId, addressdetailsform) {
    	var genericField1ComboBox = addressdetailsform.down('#parentCountryRegionId');
        genericField1ComboBox.getStore().getProxy().extraParams = {
            cid: countryId
        };
        genericField1ComboBox.getStore().load({
            callback: function(records, operation, success) {
                if (success) {
                    
                    if(genericField1ComboBox && regionId)
                    	genericField1ComboBox.setValue(regionId);
                }
            }
        });
    },

    setRegion2DropDown: function(countryRegion1, regionId, addressdetailsform) {
        var countryRegionStore = this.getStore('organization.CountryRegionStore1');
        countryRegionStore.getProxy().extraParams = {
            pid: countryRegion1
        };
        countryRegionStore.load({
            callback: function(records, operation, success) {
                if (success) {
                    /*var genericField1ComboBox = addressdetailsform.down('#genericFieldId2');
                    if(genericField1ComboBox && regionId)
                    	genericField1ComboBox.setValue(regionId);*/
                }
            }
        });
    },

    validatePhone:function(data){
    	var isValid;
    	if(!data.phoneNo && !data.cellNo){
    		showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
    		isValid= false;
    	}
    	else{
    		isValid=true;
    	}
    	return isValid;
    },
    getIdValueJson: function(id, value) {
        if (id) return {
            id: id,
            value: value
        };
    },
    setIdFromNestedObject: function(object, field) {
        if (object && object[field] && object[field].hasOwnProperty('id')) {
            object[field] = object[field]["id"];
        }
    },
   
    disableOrganizationStructureAddressPrivileges: function(regAddressFormButton, workAddressFormButton) {
    	var addressDetailForm = this.getAddressdetailsform();
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getORGANIZATION_STRUCTURE_ADDRESS_PERMISSIONS());
    	
    	 var modifyAddress1 =  addressDetailForm.down('button#modifyAddress1');
         var printAddress1 = addressDetailForm.down('button#printAddress1');
         var modifyAddress2 = addressDetailForm.down('button#modifyAddress2');
         var printAddress2 = addressDetailForm.down('button#printAddress2');
         var printallAddress = addressDetailForm.down("#printallAddress");
         modifyAddress1.setVisible(false);
         modifyAddress2.setVisible(false);
//         printAddress1.setVisible(false);
//         printAddress2.setVisible(false);
//         printallAddress.setVisible(false);
         
     	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'CREATE') {
    			if(!isNullOrEmpty(modifyAddress1) && !isNullOrEmpty(modifyAddress2)){
    				if(regAddressFormButton == 'ADD') {
    					modifyAddress1.setVisible(true);
    				}
    				if(workAddressFormButton == 'ADD') {
    					modifyAddress2.setVisible(true);
    				}
    			}        		
    		} else if (privilege === 'UPDATE') {
    			if(!isNullOrEmpty(modifyAddress1) && !isNullOrEmpty(modifyAddress2)){
    				if(regAddressFormButton == 'MODIFY') {
    					modifyAddress1.setVisible(true);
    				}
    				if(workAddressFormButton == 'MODIFY') {
    					modifyAddress2.setVisible(true);
    				}
    			}        		
    		} else if (privilege === 'PRINT') {
    			if(!isNullOrEmpty(printAddress1) && regAddressFormButton == 'MODIFY'){
    				printAddress1.setVisible(true);
    			}
    			if(!isNullOrEmpty(printAddress2) && workAddressFormButton == 'MODIFY') {
    				printAddress2.setVisible(true);
    			}
    		} else if (privilege === 'PRINT_ALL' && regAddressFormButton == 'MODIFY' && workAddressFormButton == 'MODIFY') {
     			if(!isNullOrEmpty(printallAddress)){
    				printallAddress.setVisible(true);
    			}        		
    		}
    	});
    },
    
    getCurrentAcademyLocation:function(){
		return Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue();
	}, 
	setMaximumMinimumDigitsForMobileNoValidationInAddress:function(form, countryCodeField, mobileField, record){
    	var countryInfo = null;
    	if(!isNullOrEmpty(record)) {
    		countryInfo=record[0].data;
    		mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
    		mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
    		if(!isNullOrEmpty(mobileField.getValue())) {
    			mobileField.isValid();
    			try{
    				form.getForm().checkValidity();
    	 		}
    	 		catch(e){}
    		}
    	}
    	else {
    		countryCodeField.getStore().load({
    			callback: function(records, operation, success) {
    				if (success) {
    					setTimeout(function(){
    						var countryCode=countryCodeField.getValue();
        					for(var i in records){
        						if(records[i].data.isdCode == countryCode){
    								countryInfo = records[i].data;
    								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
    								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
    								if(!isNullOrEmpty(mobileField.getValue())) {
    									mobileField.isValid();
    									try{
    				        				form.getForm().checkValidity();
    				        	 		}
    				        	 		catch(e){}
    								}
    								break;
    							}
        					}
		            	},1000);
    				}
    			}
    		});
    	}
    }
});