Ext.define('Academia.controller.organization.SU-SAU-MAUMappingController', {
    extend: 'Ext.app.Controller',

    stores: ['organization.susaumapping.OrganizationGroupStore', 'organization.susaumapping.StructureTreeStore', 'organization.susaumapping.UnallocatedALPStore', 'organization.susaumapping.AllocatedALPStore', 'organization.susaumapping.AllocatedALPToOthersStore'],
    views: ['Academia.view.organization.sasaumaumapping.SU-SAU-MAUStructure'],
    models: ['Academia.model.organization.OrganizationGroup'],

    refs: [{
        ref: 'organizationGroupTree',
        selector: 'organizationgrouptreestructure'
    }, {
        ref: 'unallocatedalpgrid',
        selector: 'alpgroupmapping unallocatedalpgrid'
    }, {
        ref: 'allocatedalpgrid',
        selector: 'alpgroupmapping allocatedalpgrid'
    }, {
        ref: 'allocatedalptoothersgrid',
        selector: 'alpgroupmapping allocatedalptoothersgrid'
    }],

    init: function(application) {

        this.control({
            activate: function() {
                var unallocatedalpgrid = this.getUnallocatedALPGrid();
                var unAllocatedALPStore = unallocatedalpgrid.getStore();
                unAllocatedALPStore.reload();

                var allocatedAlpToOthers = this.getAllocatedALPToOthersGrid();
                var allocatedALPToOthersStore = allocatedAlpToOthers.getStore();
                allocatedALPToOthersStore.reload();
            },


            'alpgroupmapping organizationgrouptreestructure': {
                render: function() {
                    var tree = this.getOrganizationGroupTree();
                    if (tree) {
                        var store = tree.getStore();
                        store.load();
                    }
                }
            },

            'alpgroupmapping combo#organizationGroupId': {
                select: function(obj1, record) {
                    var organizationGroupId = record[0].get("id");

                    // var store=Ext.getTreeStore('Academia.store.organization.susaumapping.StructureTreeStore');

                    var tree = this.getOrganizationGroupTree();
                    var store = tree.getStore();
                    store.getProxy().extraParams = {
                        id: organizationGroupId
                    };
                    store.load();

                    this.getAllocatedALPGrid().setVisible(false);
                    this.getUnallocatedALPGrid().setVisible(false);
                    this.getAllocatedALPToOthersGrid().setVisible(false);


                    var unallocatedalpgrid = this.getUnallocatedALPGrid();
                    var unAllocatedALPStore = unallocatedalpgrid.getStore();

                    unAllocatedALPStore.getProxy().extraParams = {
                        organizationSupervisoryUnitId: organizationGroupId
                    };
                    unAllocatedALPStore.reload();
                }
            },

            'organizationgrouptreestructure': {
                select: function(obj, record, index) {
                    var orgUnitId = record.get('id');

                    var allocatedalpgrid = this.getAllocatedALPGrid();
                    var whetherAllocatedALPGridHidden = allocatedalpgrid.isHidden();
                    if (whetherAllocatedALPGridHidden) {
                        allocatedalpgrid.setVisible(true);
                    }

                    var allocatedAlpToOthers = this.getAllocatedALPToOthersGrid();
                    var whetherAllocatedAlpToOthersHidden = allocatedAlpToOthers.isHidden();
                    if (whetherAllocatedAlpToOthersHidden) {
                        allocatedAlpToOthers.setVisible(true);
                    }

                    var allocatedALPToOthersStore = allocatedAlpToOthers.getStore();
                    allocatedALPToOthersStore.getProxy().extraParams = {
                        organizationUnitId: orgUnitId
                    };
                    allocatedALPToOthersStore.reload();

                    var allocatedALPStore = allocatedalpgrid.getStore();
                    allocatedALPStore.getProxy().extraParams = {
                        organizationUnitId: orgUnitId
                    };
                    allocatedALPStore.reload();

                    var unallocatedalpgrid = this.getUnallocatedALPGrid();
                    var unAllocatedALPStore = unallocatedalpgrid.getStore();

                    unAllocatedALPStore.each(function(record) {
                        record.set('organizationUnitId', orgUnitId);
                    });

                    var whetherHidden = unallocatedalpgrid.isHidden();
                    if (whetherHidden) {
                        unallocatedalpgrid.setVisible(true);
                    }

                }
            },

            'actioncolumn#unallocatedGridActionColumnId': {
                click: function(grid, cell, row, col, e) {
                    var rec = grid.getStore().getAt(row);
                    if (rec.data.startDate == null) {
                        showErrorMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getCommonTranslation('SU_SAU_MAU_START_DATE'));
                    } else if (rec.data.startDate > rec.data.tillDate && rec.data.tillDate != null) {
                        showErrorMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getCommonTranslation('SU_SAU_MAU_START_END_DATE'));
                    } else {
                   
                    	var organizationSupervisoryUnitId = rec.data.organizationSupervisoryUnitId;
                    	if(rec.data.organizationUnitId){
                    		var organizationUnitId = rec.data.organizationUnitId;
                    	}else
                    	{
                    		var treeStore = this.getOrganizationGroupTree();
                    		records = treeStore.getSelectionModel().getSelection();
                    		var organizationUnitId = records[0].get("id");
                    	}

                        var organizationUnitALPModel = new Object();

                        organizationUnitALPModel.alpId = rec.data.alpId;
                        organizationUnitALPModel.organizationUnitId = organizationUnitId;
                        organizationUnitALPModel.startDate = Ext.util.Format.date(rec.data.startDate, CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
                        organizationUnitALPModel.tillDate = Ext.util.Format.date(rec.data.tillDate, CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
                        organizationUnitALPModel.version = rec.data.version;

                        var this$ = this;
                        if (organizationUnitALPModel.organizationUnitId) {

                            Ext.Ajax.request({
                                method: 'POST',
                                corsSupport: true,
                                url: SERVERURL.LINKORGANIZATIONUNITTOALP,
                                jsonData: organizationUnitALPModel,

                                success: function(response) {
                                    showSuccessMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getCommonTranslation('LINKSUCCESS'));

                                    var allocatedalpgrid = this$.getAllocatedALPGrid();
                                    var allocatedALPStore = allocatedalpgrid.getStore();
                                    allocatedALPStore.getProxy().extraParams = {
                                        organizationUnitId: organizationUnitId
                                    };
                                    allocatedALPStore.reload();

                                    var unallocatedalpgrid = this$.getUnallocatedALPGrid();
                                    var unAllocatedALPStore = unallocatedalpgrid.getStore();

                                    unAllocatedALPStore.getProxy().extraParams = {
                                        organizationSupervisoryUnitId: organizationSupervisoryUnitId
                                    };
                                    unAllocatedALPStore.reload({
                                        callback: function(records, operation, success) {
                                            if (success) {
                                                unAllocatedALPStore.each(function(record) {
                                                    record.set('organizationUnitId', organizationUnitId);
                                                });
                                            }
                                        }
                                    });

                                    var allocatedAlpToOthers = this$.getAllocatedALPToOthersGrid();

                                    var allocatedALPToOthersStore = allocatedAlpToOthers.getStore();
                                    allocatedALPToOthersStore.getProxy().extraParams = {
                                        organizationUnitId: organizationUnitId
                                    };
                                    allocatedALPToOthersStore.reload();

                                },
                                failure: function(response) {
                                    showErrorMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getErrorTranslation(response.responseText)); 
                                }
                            });
                        } else {
                            showErrorMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getErrorTranslation('su_sau_mau_select_error'));
                        }
                    }

                }

            },

            'actioncolumn#allocatedGridActionColumnId': {
                click: function(grid, cell, row, col, e) {
                    var rec = grid.getStore().getAt(row);
                    var organizationSupervisoryUnitId = rec.data.organizationSupervisoryUnitId;
                    var organizationUnitId = rec.data.organizationUnitId;
                    var organizationUnitALPId = rec.data.id;
                    this.unLinkOrganizationUnitALP(organizationUnitId, organizationSupervisoryUnitId, organizationUnitALPId);

                }
            },


            'actioncolumn#allocatedALPToOthersGridActionColumnId': {
                click: function(grid, cell, row, col, e) {
                    var rec = grid.getStore().getAt(row);
                    var organizationSupervisoryUnitId = rec.data.organizationSupervisoryUnitId;
                    var organizationUnitId = rec.data.organizationUnitId;
                    var organizationUnitALPId = rec.data.id;
                    this.unLinkOrganizationUnitALP(organizationUnitId, organizationSupervisoryUnitId, organizationUnitALPId);

                }
            }

        });
    },
    unLinkOrganizationUnitALP: function(organizationUnitId, organizationSupervisoryUnitId, organizationUnitALPId) {
        var this$ = this;

        if (organizationUnitId && organizationSupervisoryUnitId && organizationUnitALPId) {

            Ext.Ajax.request({
                //jsonData:values,
                method: 'DELETE',
                corsSupport: true,
                url: SERVERURL.UNLINKORGANIZATIONUNITTOALP,
                params: {
                    organizationUnitALPId: organizationUnitALPId
                },
                success: function(response) {
                    showSuccessMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getCommonTranslation('UNLINKSUCCESS'));

                    var allocatedalpgrid = this$.getAllocatedALPGrid();
                    var allocatedALPStore = allocatedalpgrid.getStore();

                    allocatedALPStore.getProxy().extraParams = {
                        organizationUnitId: organizationUnitId
                    };
                    allocatedALPStore.reload();

                    var unallocatedalpgrid = this$.getUnallocatedALPGrid();
                    var unAllocatedALPStore = unallocatedalpgrid.getStore();
                    unAllocatedALPStore.getProxy().extraParams = {
                        organizationSupervisoryUnitId: organizationSupervisoryUnitId
                    };
                    unAllocatedALPStore.reload({
                        callback: function(records, operation, success) {
                            if (success) {
                                unAllocatedALPStore.each(function(record) {
                                    record.set('organizationUnitId', organizationUnitId);
                                });
                            }
                        }
                    });


                    var allocatedAlpToOthers = this$.getAllocatedALPToOthersGrid();

                    var allocatedALPToOthersStore = allocatedAlpToOthers.getStore();
                    allocatedALPToOthersStore.getProxy().extraParams = {
                        organizationUnitId: organizationUnitId
                    };
                    allocatedALPToOthersStore.reload();

                },
                failure: function(response) {
                    showErrorMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getErrorTranslation(response.responseText));
                }
            });
        } else {
            showErrorMessage(getCommonTranslation('SAUMAUMAPTABTEXT'), getErrorTranslation('su_sau_mau_select_error'));
        }
    },


    getUnallocatedALPGrid: function() {
        return this.getUnallocatedalpgrid();
    },

    getAllocatedALPGrid: function() {
        return this.getAllocatedalpgrid();
    },

    getAllocatedALPToOthersGrid: function() {
        return this.getAllocatedalptoothersgrid();
    }

});