/**
 * This controller is used for Academy Locations Address  
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.organization.academylocations.AcademyLocationAddressController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['Academia.model.organization.academylocations.AcademyLocationAddressModel',
        'Academia.model.organization.Address','Academia.model.common.OtherAddressCopyModel' 
    ],
    stores: ['organization.AddressTypeStore', 'common.CountryStore',
        'organization.CityStore', 'organization.CountryRegionStore',
        'organization.CountryRegionStore1', 'organization.CityByCountryRegion','common.OtherAddressCopyStore'
    ],
    views: ['organization.academylocations.AcademyLocationLinkGrid',
        'organization.academylocations.AcademyLocationAddressForm',
        'organization.addresses.AddressFormWindow',
        'common.AddressFieldsForm'
    ],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'academylocationlinkgrid',
        selector: 'academylocationlinkgrid'
    }, {
        ref: 'academylocationaddressform',
        selector: 'academylocationaddressform'
    }, {
        ref: 'addressFormWindow',
        selector: 'addressFormWindow'
    }, {
        ref: 'addressfieldsform',
        selector: 'addressFormWindow form[itemId=addressfieldsform]'
    }],
    init: function() {
        this.control({
            'academylocationlinkgrid button[itemId=addAddressItemId]': {
                click: function(button) {
                    var grid = this.getAcademylocationlinkgrid();
                    if (grid.getSelectionModel().getCount() > 0 && button.itemId === "addAddressItemId") {
                        this.openAcademyLocationAddressFormTab(grid.getSelectionModel().getSelection()[0]);
                    } else {
                        showWarningMessage(getCommonTranslation('ACADLOCTT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'academylocationaddressform': {
                render: function() {
                    this.getAcademyLocationAddress();
                }
            },
            "button#modifyAddressALAF1": {
                click: function() {
                    var customAddressDisplayField1 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF1');
                    this.onModifyClick(customAddressDisplayField1, 10);
                }
            },
            "button#modifyAddressALAF2": {
                click: function() {
                    var customAddressDisplayField2 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF2');
                    this.onModifyClick(customAddressDisplayField2, 11);
                }
            },
            "button#modifyAddressALAF3": {
                click: function() {
                    var customAddressDisplayField3 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF3');
                    this.onModifyClick(customAddressDisplayField3, 12);
                }
            },
            "button#modifyAddressALAF4": {
                click: function() {
                    var customAddressDisplayField4 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF4');
                    this.onModifyClick(customAddressDisplayField4, 13);
                }
            },
            'addressFormWindow#academyLocationAddressWindow button#saveButtonId': {
                click: this.saveAcademyLocationAddress
            },
            'addressFormWindow#academyLocationAddressWindow button#cancelButtonId': {
                click: this.resetForm
            },
            "button#printAddressALAF1": {
                click: function() {
                    var addressDisplayField = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF1');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "button#printAddressALAF2": {
                click: function() {
                    var addressDisplayField = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF2');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "button#printAddressALAF3": {
                click: function() {
                    var addressDisplayField = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF3');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "button#printAddressALAF4": {
                click: function() {
                    var addressDisplayField = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF4');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "button#printallAddressALAF": {
                click: function() {
                    var addressDisplayField1 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF1');
                    var addressDisplayField2 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF2');
                    var addressDisplayField3 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF3');
                    var addressDisplayField4 = this.getAcademylocationaddressform().down('displayfield#customAddressDisplayFieldALAF4');

                    var allAddressDisplayField = Ext.create('Academia.view.organization.addresses.CustomAddressDisplayField');
                    var str = addressDisplayField1.value;
                    str += " \n <hr/>";
                    str += addressDisplayField2.value;
                    str += " \n <hr/>";
                    str += addressDisplayField3.value;
                    str += " \n <hr/>";
                    str += addressDisplayField4.value;

                    allAddressDisplayField.setValue(str);
                    this.onPrintClick(allAddressDisplayField);
                }
            },//addressFormWindow form[itemId=addressfieldsform]
            'addressFormWindow form[itemId=addressfieldsform] customcombobox[itemId=cellCountryCode]': {
                select: function(rowModel, record) {
                	var form = this.getAddressfieldsform();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
                }
            },
            'addressFormWindow form[itemId=addressfieldsform]  numberfield[itemId=cellNo]': {
                change: function(record) {
                	var form = this.getAddressfieldsform();
                	var mobileField = form.down("#cellNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
        });
    },
    openAcademyLocationAddressFormTab: function(record) {
    	var $this = this;
    	var contentpanel = this.getContentpanel();
    	var academylocationaddressform = Ext.widget('academylocationaddressform');
    	var tabName = getCommonTranslation('ALA_ADDRESS');
    	
    	/** This is to remove tab from content panel and open same tab again */
    	var getcontroller = this.getController('menu.CoreERPNavigationController');
    	var getTab = getcontroller.getTab(tabName);
    	if (getTab != null) {
    	    contentPanel.remove(getTab, true);
    	}

    	openTab(contentpanel, tabName, academylocationaddressform, CONSTANTS.MENU_COLOR_THREE);
    },

    getAcademyLocationAddress: function() {
        var $this = this;
        var currentAddress = false,
            correspondanceAddress = false,
            permanentAddress = false,
            officeAddress = false;

        var academylocationaddressform = $this.getAcademylocationaddressform();

        var grid = $this.getAcademylocationlinkgrid();
        var record = grid.getSelectionModel().getSelection()[0];
        var academyLocationId = record.data.id;

        Ext.apply(grid, {
            academyLocationId: null,
            setAcademyLocationId: function(code) {
                grid.academyLocationId = academyLocationId;
            },
            getAcademyLocationId: function() {
                return grid.academyLocationId;
            }
        });
        grid.setAcademyLocationId(academyLocationId);

        if (!isNullOrEmpty(academyLocationId)) {
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.ALA_FIND_ALL_ADDRESS_BY_ACADEMY_LOCATION_ID,
                params: {
                    academyLocationId: academyLocationId
                },
                method: 'GET',
                success: function(responser, action) {
                    var data = Ext.decode(responser.responseText);
                    var addressDisplayField1 = academylocationaddressform.down('displayfield#customAddressDisplayFieldALAF1');
                    var addressDisplayField2 = academylocationaddressform.down('displayfield#customAddressDisplayFieldALAF2');
                    var addressDisplayField3 = academylocationaddressform.down('displayfield#customAddressDisplayFieldALAF3');
                    var addressDisplayField4 = academylocationaddressform.down('displayfield#customAddressDisplayFieldALAF4');

                    var AddressTpl = Ext.create('Ext.XTemplate',
                        '<p><B>{addressText}</B></p>',
                        '<tpl if=\'city != null\'>',
                        '{city.value} , </tpl> {code}<br>',
                        '<tpl if=\'countryRegion != null\'>',
                        '{countryRegion.value}<br></tpl> ',
                        '<tpl if=\'parentCountryRegion != null\'>',
                        '{parentCountryRegion.value},</tpl> {country.value}<br>',
                        '<tpl if=\'phoneNo != null\'>',
                        getCommonTranslation('ADDRESS_PHONE_NUMBER') + ' ' + '{phoneCountryCode}-',
                        '<tpl if=\'phoneAreaCode != null\'>',
                        '{phoneAreaCode}-</tpl>',
                        '{phoneNo}</tpl><br>',
                        '<tpl if=\'cellNo != null\'>',
                        getCommonTranslation('ADDRESS_MOBILE_NO') + ' ' + '{cellCountryCode}-{cellNo}</tpl><br>',
                        '{primaryeEmailId}');

                    Ext.each(data, function(obj) {
                        if (obj['addressType']['id'] == 10) {
                            currentAddress = true;
                            addressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
                            addressDisplayField1.setModel(obj);
                        } else if (obj['addressType']['id'] == 11) {
                            correspondanceAddress = true;
                            addressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
                            addressDisplayField2.setModel(obj);
                        } else if (obj['addressType']['id'] == 12) {
                            permanentAddress = true;
                            addressDisplayField3.setValue(AddressTpl.applyTemplate(obj));
                            addressDisplayField3.setModel(obj);
                        } else if (obj['addressType']['id'] == 13) {
                            officeAddress = true;
                            addressDisplayField4.setValue(AddressTpl.applyTemplate(obj));
                            addressDisplayField4.setModel(obj);
                        }
                    });
                    var modifyAddress1 = academylocationaddressform.down('button#modifyAddressALAF1');
                    var printAddress1 = academylocationaddressform.down('button#printAddressALAF1');
                    var modifyAddress2 = academylocationaddressform.down('button#modifyAddressALAF2');
                    var printAddress2 = academylocationaddressform.down('button#printAddressALAF2');
                    var modifyAddress3 = academylocationaddressform.down('button#modifyAddressALAF3');
                    var printAddress3 = academylocationaddressform.down('button#printAddressALAF3');
                    var modifyAddress4 = academylocationaddressform.down('button#modifyAddressALAF4');
                    var printAddress4 = academylocationaddressform.down('button#printAddressALAF4');

                    var printallAddress = academylocationaddressform.down("#printallAddressALAF");

                    if (currentAddress) {
                        modifyAddress1.setText(getCommonTranslation('MODIFY'));
//                        printAddress1.setVisible(true);
                    } else {
                        modifyAddress1.setText(getCommonTranslation('ADD_ADDRESS'));
                       // printAddress1.setVisible(false);
                        var object = new Object();
                        object.addressType = 10;
                        addressDisplayField1.setModel(object);
                    }
                    if (correspondanceAddress) {
                        modifyAddress2.setText(getCommonTranslation('MODIFY'));
                     //   printAddress2.setVisible(true);
                    } else {
                        modifyAddress2.setText(getCommonTranslation('ADD_ADDRESS'));
                      //  printAddress2.setVisible(false);
                        var object = new Object();
                        object.addressType = 11;
                        addressDisplayField2.setModel(object);
                    }

                    if (permanentAddress) {
                        modifyAddress3.setText(getCommonTranslation('MODIFY'));
                    //    printAddress3.setVisible(true);
                    } else {
                        modifyAddress3.setText(getCommonTranslation('ADD_ADDRESS'));
                      //  printAddress3.setVisible(false);
                        var object = new Object();
                        object.addressType = 12;
                        addressDisplayField3.setModel(object);
                    }

                    if (officeAddress) {
                        modifyAddress4.setText(getCommonTranslation('MODIFY'));
                     //   printAddress4.setVisible(true);
                    } else {
                        modifyAddress4.setText(getCommonTranslation('ADD_ADDRESS'));
                       // printAddress4.setVisible(false);
                        var object = new Object();
                        object.addressType = 13;
                        addressDisplayField4.setModel(object);
                    }

                    if (currentAddress && correspondanceAddress && permanentAddress && officeAddress) {
                //        printallAddress.setVisible(true);
                    } else {
                    //    printallAddress.setVisible(false);
                    }
                }
            });
        }
    },
    onModifyClick: function(customAddressDisplayField, addressTypeALId) {
        var $this = this;
        /** Enable Form. */
        var addressFormWindow = Ext.widget('addressFormWindow', {
            itemId: 'academyLocationAddressWindow'
        });
        addressFormWindow.show();

        var websiteURLItemId = addressFormWindow.down('#websiteURLItemId');
        websiteURLItemId.setVisible(true);

        var grid = $this.getAcademylocationlinkgrid();
        Ext.apply(grid, {
            addressTypeALId: null,
            setAddressTypeALId: function(code) {
                grid.addressTypeALId = addressTypeALId;
            },
            getAddressTypeALId: function() {
                return grid.addressTypeALId;
            }
        });
        grid.setAddressTypeALId(addressTypeALId);

        var data = customAddressDisplayField.getModel();
        var addressfieldsform = $this.getAddressfieldsform();
        $this.setAddressFormData(data, addressfieldsform);
        
        var form = this.getAddressfieldsform();
    	var countryCodeField = form.down("#cellCountryCode");
    	var mobileField = form.down("#cellNo");
    	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
   
        
    },

    setAddressFormData: function(data, addressfieldsform) {

        var form = addressfieldsform.getForm();
        form.reset();

        if (data) {
            this.setIdFromNestedObject(data, "addressType");
            this.setIdFromNestedObject(data, "country");
            this.setIdFromNestedObject(data, "parentCountryRegion");
            this.setIdFromNestedObject(data, "countryRegion");
            this.setIdFromNestedObject(data, "city");

            var countryId = data["country"];
            var countryRegionId = data["parentCountryRegion"];
            var pinCodeId = data["pincodeNew"];
            if (countryId) {
                this.setCountryDropDown(countryId, addressfieldsform);
                this.setCityropDown(countryRegionId, data["city"], addressfieldsform);
                this.setPincodeDropDown(pinCodeId,data["city"],addressfieldsform);
                this.setRegion1DropDown(countryId, data["parentCountryRegion"], addressfieldsform);
                this.setRegion2DropDown(data["parentCountryRegion"], data["countryRegion"], addressfieldsform);
            }

            form.setValues(data);
            
        }

    },
    setCountryDropDown: function(countryId, addressfieldsform) {
        var countryComboBox = addressfieldsform.down('#countryId');
        var store = countryComboBox.getStore();
            store.load({
                callback: function(records, operation, success) {
                    if (success) {
                        if (countryComboBox && countryId)
                            countryComboBox.setValue(countryId);
                    }
                }
            });
    },
    setCityropDown: function(countryId, cityId, addressfieldsform) {
    	var cityComboBox = addressfieldsform.down('#cityId');
        var store = cityComboBox.getStore();
        store.getProxy().extraParams = {
            id: countryId
        };
        store.load({
            callback: function(records, operation, success) {
                if (success) {
                    if (cityComboBox && cityId)
                        cityComboBox.setValue(cityId);
                }
            }
        });
    },
    setPincodeDropDown: function(pincodeId,cityId, addressdetailsform) {
    	var pincodeComboBox = addressdetailsform.down('#pincodeNewId');
    	pincodeComboBox.getStore().getProxy().extraParams = {
            id: cityId
        };
    	pincodeComboBox.getStore().load({
            callback: function(records, operation, success) {
                if (success) {
                    if(pincodeComboBox && pincodeId)
                    	pincodeComboBox.setValue(pincodeId.id);
                }
            }
        });
    },
    setRegion1DropDown: function(countryId, regionId, addressfieldsform) {
    	var genericField1ComboBox = addressfieldsform.down('#parentCountryRegionId');
        var countryRegionStore = genericField1ComboBox.getStore();
        countryRegionStore.getProxy().extraParams = {
            cid: countryId
        };
        countryRegionStore.load({
            callback: function(records, operation, success) {
                if (success) {
                    if (genericField1ComboBox && regionId)
                        genericField1ComboBox.setValue(regionId);
                }
            }
        });
    },
    setRegion2DropDown: function(countryRegion1, regionId, addressfieldsform) {
        var countryRegionStore = this.getStore('organization.CountryRegionStore1');
        countryRegionStore.getProxy().extraParams = {
            pid: countryRegion1
        };
        countryRegionStore.load({
            callback: function(records, operation, success) {
                if (success) {
                    /*var genericField1ComboBox = academylocationaddressform.down('#genericFieldId2');
                    if(genericField1ComboBox && regionId)
                    	genericField1ComboBox.setValue(regionId);*/
                }
            }
        });
    },
    validatePhone: function(data) {
        var isValid;
        if (!data.phoneNo && !data.cellNo) {
            showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), getCommonTranslation('ADD_PHONE_NO'));
            isValid = false;
        } else {
            isValid = true;
        }
        return isValid;
    },
    getIdValueJson: function(id, value) {
        if (id) return {
            id: id,
            value: value
        };
    },
    setIdFromNestedObject: function(object, field) {
        if (object && object[field] && object[field].hasOwnProperty('id')) {
            object[field] = object[field]["id"];
        }
    },
    saveAcademyLocationAddress: function(model) {
        var $this = this;
        var form = $this.getAddressfieldsform().getForm();
        if (form.isValid()) {
            var values = form.getValues();
//            if ($this.validatePhone(values)) {
                var address = new Academia.model.organization.Address();
                var submitUrl;
                var successMessage;
                var id = form.findField('id').getSubmitValue();
                form.updateRecord(address);
                address.set('country', this.getIdValueJson(values.country));
                address.set('parentCountryRegion', $this.getIdValueJson(values.parentCountryRegion));
                address.set('countryRegion', $this.getIdValueJson(values.countryRegion));
                address.set('city', $this.getIdValueJson(values.city));
                address.set('pincode', values.pincode);
                address.set('customData',values.customData);
                address.set('faxNumber',values.faxNumber);
                var grid = $this.getAcademylocationlinkgrid();
                var academyLocationId = grid.getAcademyLocationId();
                var addressTypeALId = grid.getAddressTypeALId();
                address.set('addressType', $this.getIdValueJson(addressTypeALId));

                var academyLocationAddressModel = new Academia.model.organization.academylocations.AcademyLocationAddressModel;
                academyLocationAddressModel.set("address", address.data);
                academyLocationAddressModel.set("academyLocationId", academyLocationId);

                var formData = Ext.encode(academyLocationAddressModel.data);
                if (id == null || id == "") {
                    submitUrl = SERVERURL.ALA_ACADEMY_LOCATION_ADDRESS_CREATE;
                    successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
                } else {
                    submitUrl = SERVERURL.ALA_ACADEMY_LOCATION_ADDRESS_UPDATE;
                    successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
                }
                Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    jsonData: formData,
                    method: 'POST',
                    success: function(form, action) {
                        showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
                        $this.getAcademyLocationAddress();
                        $this.resetForm(model);
                    }
                });
//            }
        }
    },
    resetForm: function(button) {
        button.up('window').close();
    },
    onPrintClick: function(addressDisplayField) {
        Ext.ux.Printer.print(addressDisplayField);
    },
});